import { f as bind_props, s as store_get, e as escape_html, u as unsubscribe_stores, h as head, d as ensure_array_like, a as attr_class, c as clsx } from "../../../chunks/index3.js";
import { E as Expandable, h as Avatar, M as Material, i as Markdown, a2 as escapeHtml, q as publishedToDate, B as Button, p as profile, a as getClient, j as searchParam, g as goto } from "../../../chunks/client.svelte.js";
import { p as page } from "../../../chunks/index4.js";
import { t } from "../../../chunks/index.js";
import { F as Fixate } from "../../../chunks/Fixate.js";
import { P as Placeholder } from "../../../chunks/Placeholder.js";
import { H as Header } from "../../../chunks/Header.js";
import { C as CommonList } from "../../../chunks/CommonList.js";
import { I as Icon } from "../../../chunks/Icon.js";
import { A as ArrowPath } from "../../../chunks/ArrowPath.js";
import { C as Check } from "../../../chunks/Check.js";
import { F as Funnel } from "../../../chunks/Funnel.js";
import { I as Inbox } from "../../../chunks/Inbox.js";
import { S as Select, O as Option } from "../../../chunks/Select.js";
import "../../../chunks/settings.svelte.js";
import { P as Pageination } from "../../../chunks/Pageination.js";
import "openapi-fetch";
import "@dicebear/core";
import "@dicebear/initials";
import { C as CommentItem } from "../../../chunks/CommentItem.js";
import { P as PrivateMessage } from "../../../chunks/PrivateMessage.js";
import { B as ButtonGroup } from "../../../chunks/ButtonGroup.js";
import { A as AtSymbol } from "../../../chunks/AtSymbol.js";
import { C as ChatBubbleOvalLeftEllipsis } from "../../../chunks/ChatBubbleOvalLeftEllipsis.js";
import { E as EyeSlash, a as Eye } from "../../../chunks/EyeSlash.js";
import { P as PaperAirplane } from "../../../chunks/PaperAirplane.js";
import "@sveltejs/kit/internal";
import "../../../chunks/exports.js";
import "../../../chunks/utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
import { R as RelativeDate } from "../../../chunks/RelativeDate.js";
function InboxItem($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { item = void 0 } = $$props;
    let loading = false;
    async function markAsRead(isRead) {
      if (isRead && item.read) return;
      loading = true;
      switch (item.type) {
        case "person_mention": {
          await getClient().markPersonMentionAsRead({ person_mention_id: item.id, read: isRead });
          break;
        }
        case "comment_reply": {
          await getClient().markCommentReplyAsRead({ comment_reply_id: item.id, read: isRead });
          break;
        }
        case "private_message": {
          await getClient().markPrivateMessageAsRead({ private_message_id: item.id, read: isRead });
        }
      }
      item.read = isRead;
      if (profile.current.user) profile.inbox.notifications.inbox += isRead ? -1 : 1;
      loading = false;
    }
    function actions($$renderer3) {
      Button($$renderer3, {
        color: item.read ? "secondary" : "primary",
        loading,
        disabled: loading || item.creator.id == profile.current.user?.local_user_view.person.id,
        onclick: (e) => {
          e.stopPropagation();
          markAsRead(!item.read);
        },
        size: "sm",
        rounding: "pill",
        class: "shrink-0",
        icon: item.read ? EyeSlash : Eye,
        children: ($$renderer4) => {
          $$renderer4.push(`<!---->${escape_html(item.read ? store_get($$store_subs ??= {}, "$t", t)("post.actions.more.markUnread") : store_get($$store_subs ??= {}, "$t", t)("post.actions.more.markRead"))}`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      Button($$renderer3, {
        href: item.type == "private_message" ? `/inbox/messages/${item.item.private_message.creator_id}` : `/comment/${item.item.comment.id}`,
        size: "sm",
        rounding: "pill",
        class: "shrink-0",
        onclick: () => markAsRead(true),
        children: ($$renderer4) => {
          $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("common.jump"))}`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!---->`);
    }
    {
      let title = function($$renderer3) {
        $$renderer3.push(`<div class="flex flex-row gap-2 items-center w-full"><div class="relative">`);
        Avatar($$renderer3, { url: item.creator.avatar, width: 28, alt: item.creator.name });
        $$renderer3.push(`<!----> `);
        Material($$renderer3, {
          color: "uniform",
          padding: "none",
          class: "absolute -bottom-2 -right-2 p-1",
          rounding: "full",
          children: ($$renderer4) => {
            Icon($$renderer4, {
              src: item.type == "comment_reply" ? ChatBubbleOvalLeftEllipsis : item.type == "person_mention" ? AtSymbol : PaperAirplane,
              size: "12",
              micro: true
            });
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----></div> <div class="flex flex-col"><div class="text-sm font-normal text-slate-600 dark:text-zinc-400">`);
        if (item.type == "comment_reply") {
          $$renderer3.push("<!--[-->");
          Markdown($$renderer3, {
            inline: true,
            source: store_get($$store_subs ??= {}, "$t", t)("routes.inbox.item.reply", {
              user: `**${item.creator.name}**`,
              post: `**${escapeHtml(item.item.post.name)}**`
            }),
            noStyle: true
          });
        } else {
          $$renderer3.push("<!--[!-->");
          if (item.type == "person_mention") {
            $$renderer3.push("<!--[-->");
            Markdown($$renderer3, {
              inline: true,
              source: store_get($$store_subs ??= {}, "$t", t)("routes.inbox.item.mention", {
                user: `**${item.creator.name}**`,
                post: `**${escapeHtml(item.item.post.name)}**`
              }),
              noStyle: true
            });
          } else {
            $$renderer3.push("<!--[!-->");
            if (item.type == "private_message") {
              $$renderer3.push("<!--[-->");
              Markdown($$renderer3, {
                inline: true,
                source: store_get($$store_subs ??= {}, "$t", t)("routes.inbox.item.message", {
                  user: `**${item.creator.name}**`,
                  recipient: `**${escapeHtml(item.item.recipient.name)}**`
                }),
                noStyle: true
              });
            } else {
              $$renderer3.push("<!--[!-->");
            }
            $$renderer3.push(`<!--]-->`);
          }
          $$renderer3.push(`<!--]-->`);
        }
        $$renderer3.push(`<!--]--></div> <div class="text-xs text-slate-600 dark:text-zinc-400">`);
        RelativeDate($$renderer3, { date: publishedToDate(item.published) });
        $$renderer3.push(`<!----></div></div> <div class="flex-1"></div> `);
        ButtonGroup($$renderer3, {
          orientation: "horizontal",
          class: "md:flex hidden shrink-0",
          children: ($$renderer4) => {
            actions($$renderer4);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----></div>`);
      }, extended = function($$renderer3) {
        ButtonGroup($$renderer3, {
          orientation: "horizontal",
          class: "flex md:hidden",
          children: ($$renderer4) => {
            actions($$renderer4);
          },
          $$slots: { default: true }
        });
      }, content = function($$renderer3) {
        if (item.type == "comment_reply" || item.type == "person_mention") {
          $$renderer3.push("<!--[-->");
          CommentItem($$renderer3, {
            comment: item.item,
            community: false,
            meta: false,
            class: "py-0!",
            commentClass: "py-0!"
          });
        } else {
          $$renderer3.push("<!--[!-->");
          PrivateMessage($$renderer3, { message: item.item, meta: false });
        }
        $$renderer3.push(`<!--]-->`);
      };
      Expandable($$renderer2, {
        open: true,
        icon: false,
        title,
        extended,
        content,
        $$slots: { title: true, extended: true, content: true }
      });
    }
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { item });
  });
}
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { data } = $$props;
    let markingAsRead = false;
    async function markAllAsRead() {
      if (!profile.current?.user) {
        goto();
        return;
      }
      markingAsRead = true;
      const response = await getClient().markAllAsRead();
      profile.inbox.notifications.inbox = 0;
      goto(page.url, {}).then(() => {
        markingAsRead = false;
      });
      return response.replies;
    }
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      head($$renderer3, ($$renderer4) => {
        $$renderer4.title(($$renderer5) => {
          $$renderer5.push(`<title>${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.inbox.title"))}</title>`);
        });
      });
      {
        let extended = function($$renderer4) {
          var bind_get = () => data.unreadOnly.value.toString();
          var bind_set = (v) => data.unreadOnly.value = v == "true";
          $$renderer4.push(`<div class="flex gap-2 tracking-normal items-end">`);
          {
            let customLabel = function($$renderer5) {
              $$renderer5.push(`<div class="flex items-center gap-1">`);
              Icon($$renderer5, { src: Funnel, size: "15", mini: true });
              $$renderer5.push(`<!----> ${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.filter"))}</div>`);
            };
            Select($$renderer4, {
              class: "relative",
              get value() {
                return bind_get();
              },
              set value($$value) {
                bind_set($$value);
              },
              onchange: () => searchParam(page.url, "unreadOnly", data.unreadOnly.value ? "true" : "false", "page"),
              customLabel,
              children: ($$renderer5) => {
                Option($$renderer5, {
                  value: "false",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.location.all"))}`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                Option($$renderer5, {
                  value: "true",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.unread"))}`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!---->`);
              },
              $$slots: { customLabel: true, default: true }
            });
          }
          $$renderer4.push(`<!----> <div class="flex-1"></div> `);
          Button($$renderer4, {
            onclick: markAllAsRead,
            loading: markingAsRead,
            disabled: markingAsRead || data.inbox.value.length == 0,
            color: "primary",
            icon: Check,
            size: "lg",
            children: ($$renderer5) => {
              $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.inbox.markAsRead"))}`);
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!----> `);
          Button($$renderer4, {
            onclick: () => goto(page.url, {}),
            size: "square-lg",
            "aria-label": store_get($$store_subs ??= {}, "$t", t)("common.refresh"),
            icon: ArrowPath
          });
          $$renderer4.push(`<!----></div>`);
        };
        Header($$renderer3, {
          pageHeader: true,
          class: "lg:flex-row justify-between flex-col",
          extended,
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.inbox.title"))}`);
          }
        });
      }
      $$renderer3.push(`<!----> `);
      if (!data.inbox?.value || (data.inbox.value?.length ?? 0) == 0) {
        $$renderer3.push("<!--[-->");
        Placeholder($$renderer3, {
          icon: Inbox,
          title: store_get($$store_subs ??= {}, "$t", t)("routes.inbox.empty.title"),
          description: store_get($$store_subs ??= {}, "$t", t)("routes.inbox.empty.description"),
          class: "self-center justify-self-center my-auto"
        });
      } else {
        $$renderer3.push("<!--[!-->");
        CommonList($$renderer3, {
          size: "md",
          children: ($$renderer4) => {
            $$renderer4.push(`<!--[-->`);
            const each_array = ensure_array_like(data.inbox.value);
            for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
              let item = each_array[$$index];
              $$renderer4.push(`<li${attr_class(clsx([!item.read && "bg-blue-300/10! dark:bg-blue-500/5!"]))}>`);
              InboxItem($$renderer4, { item });
              $$renderer4.push(`<!----></li>`);
            }
            $$renderer4.push(`<!--]-->`);
          }
        });
      }
      $$renderer3.push(`<!--]--> `);
      if (!(data.page == 1 && (data?.inbox?.value.length ?? 0) == 0)) {
        $$renderer3.push("<!--[-->");
        Fixate($$renderer3, {
          placement: "bottom",
          children: ($$renderer4) => {
            Pageination($$renderer4, {
              hasMore: !(!data.inbox || (data.inbox.value?.length ?? 0) < (data?.limit ?? 0)),
              page: data.page,
              href: (page2) => `?page=${page2}`
            });
          }
        });
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]-->`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
