import { u as unsubscribe_stores, s as store_get, e as escape_html, g as await_block, b as attr, k as stringify, d as ensure_array_like } from "../../../../chunks/index3.js";
import { g as goto, B as Button, h as Avatar, p as profile, q as publishedToDate, z as SvelteSet } from "../../../../chunks/client.svelte.js";
import { r as resolve } from "../../../../chunks/server2.js";
import { t } from "../../../../chunks/index.js";
import { U as UserAutocomplete } from "../../../../chunks/UserAutocomplete.js";
import { F as Fixate } from "../../../../chunks/Fixate.js";
import { S as Skeleton } from "../../../../chunks/Skeleton.js";
import { P as Placeholder } from "../../../../chunks/Placeholder.js";
import { H as Header } from "../../../../chunks/Header.js";
import { C as CommonList } from "../../../../chunks/CommonList.js";
import { I as Icon } from "../../../../chunks/Icon.js";
import { C as ChatBubbleOvalLeftEllipsis } from "../../../../chunks/ChatBubbleOvalLeftEllipsis.js";
import { I as Inbox } from "../../../../chunks/Inbox.js";
import { M as Modal } from "../../../../chunks/Modal.js";
import "../../../../chunks/settings.svelte.js";
import { P as Pageination } from "../../../../chunks/Pageination.js";
import "openapi-fetch";
import "@sveltejs/kit";
import "lemmy-js-client";
import { R as RelativeDate } from "../../../../chunks/RelativeDate.js";
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    function getOtherPartyId(message) {
      return message.creator.id == profile.current.user?.local_user_view.person.id ? message.recipient.id : message.creator.id;
    }
    function filterDuplicates(array, predicate) {
      const seen = new SvelteSet();
      return array.filter((element) => {
        const value = predicate(element);
        if (seen.has(value)) {
          return false;
        } else {
          seen.add(value);
          return true;
        }
      });
    }
    function conversationPreviews(conversations) {
      const deduplicated = filterDuplicates(conversations, (i) => getOtherPartyId(i));
      return deduplicated.filter((c) => c.creator.id != c.recipient.id).map((i) => ({
        user: i.creator.id != profile.current.user?.local_user_view.person.id ? i.creator : i.recipient,
        message: {
          date: publishedToDate(i.private_message.published),
          last_sender: i.creator.id,
          content: i.private_message.content
        }
      }));
    }
    let searchModal = { open: false };
    let { data } = $$props;
    function startChat($$renderer3) {
      Button($$renderer3, {
        color: "primary",
        size: "lg",
        class: "w-max",
        onclick: () => searchModal.open = !searchModal.open,
        children: ($$renderer4) => {
          Icon($$renderer4, { src: ChatBubbleOvalLeftEllipsis, size: "18", mini: true });
          $$renderer4.push(`<!----> ${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.inbox.messages.start"))}`);
        },
        $$slots: { default: true }
      });
    }
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      Modal($$renderer3, {
        title: store_get($$store_subs ??= {}, "$t", t)("routes.inbox.messages.start"),
        get open() {
          return searchModal.open;
        },
        set open($$value) {
          searchModal.open = $$value;
          $$settled = false;
        },
        children: ($$renderer4) => {
          UserAutocomplete($$renderer4, {
            listing_type: "All",
            hideOwnUser: true,
            onselect: (u) => goto(resolve("/inbox/messages/[user_id]", { user_id: u.id.toString() }))
          });
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      Header($$renderer3, {
        pageHeader: true,
        extended: startChat,
        children: ($$renderer4) => {
          $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.inbox.messages"))}`);
        }
      });
      $$renderer3.push(`<!----> `);
      await_block(
        $$renderer3,
        data.messages,
        () => {
          $$renderer3.push(`<div class="w-full h-full flex flex-col gap-2"><!--[-->`);
          const each_array = ensure_array_like(new Array(5));
          for (let index = 0, $$length = each_array.length; index < $$length; index++) {
            let _ = each_array[index];
            $$renderer3.push(`<!---->${escape_html(_)} <div>`);
            Skeleton($$renderer3);
            $$renderer3.push(`<!----></div>`);
          }
          $$renderer3.push(`<!--]--></div>`);
        },
        (res) => {
          const conversations = res.private_messages;
          const previews = conversationPreviews(conversations);
          if (previews.length == 0) {
            $$renderer3.push("<!--[-->");
            Placeholder($$renderer3, {
              title: store_get($$store_subs ??= {}, "$t", t)("routes.inbox.messages.empty.title"),
              icon: Inbox,
              class: "my-auto",
              children: ($$renderer4) => {
                startChat?.($$renderer4);
              }
            });
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--> `);
          {
            let item = function($$renderer4, preview) {
              $$renderer4.push(`<a${attr("href", `/inbox/messages/${stringify(preview.user.id)}`)} class="flex flex-row items-center gap-2">`);
              Avatar($$renderer4, { url: preview.user.avatar, alt: preview.user.name, width: 32 });
              $$renderer4.push(`<!----> <div class="flex flex-col w-full overflow-hidden"><div class="font-medium">${escape_html(preview.user.name)}</div> <div class="flex w-full"><div class="text-sm text-ellipsis whitespace-nowrap bg-linear-to-r from-slate-700 via-slate-700 to-slate-700/0 dark:from-zinc-300 dark:via-zinc-300 dark:to-zinc-300/0 text-transparent bg-clip-text flex-1 overflow-hidden">`);
              if (preview.message.last_sender == profile.current.user?.local_user_view.person.id) {
                $$renderer4.push("<!--[-->");
                $$renderer4.push(`${escape_html(profile.current.user?.local_user_view.person.name)}:`);
              } else {
                $$renderer4.push("<!--[!-->");
              }
              $$renderer4.push(`<!--]--> ${escape_html(preview.message.content)}</div> `);
              RelativeDate($$renderer4, {
                date: preview.message.date,
                class: "inline-block text-xs text-slate-600 dark:text-zinc-400 shrink-0"
              });
              $$renderer4.push(`<!----></div></div></a>`);
            };
            CommonList($$renderer3, { items: previews, item });
          }
          $$renderer3.push(`<!----> `);
          if (res.private_messages.length == 50 || data.page != 1) {
            $$renderer3.push("<!--[-->");
            Fixate($$renderer3, {
              placement: "bottom",
              children: ($$renderer4) => {
                Pageination($$renderer4, {
                  page: data.page,
                  hasMore: res.private_messages.length == 50,
                  href: (current) => `/inbox/messages?page=${current}`
                });
              }
            });
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]-->`);
        }
      );
      $$renderer3.push(`<!--]-->`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
