import { a as attr_class, e as escape_html, s as store_get, u as unsubscribe_stores, k as stringify, h as head, d as ensure_array_like, c as clsx, g as await_block } from "../../../../../chunks/index3.js";
import { i as Markdown, q as publishedToDate, B as Button, M as Material, U as UserLink, c as client, p as profile, o as Plus, a3 as Minus } from "../../../../../chunks/client.svelte.js";
import { t } from "../../../../../chunks/index.js";
import { M as MarkdownEditor } from "../../../../../chunks/MarkdownEditor.js";
import { s as settings } from "../../../../../chunks/settings.svelte.js";
import { c as report } from "../../../../../chunks/moderation.js";
import { H as Header } from "../../../../../chunks/Header.js";
import { o as onDestroy } from "../../../../../chunks/index-server.js";
import "@sveltejs/kit/internal";
import "../../../../../chunks/exports.js";
import "../../../../../chunks/utils.js";
import "@sveltejs/kit/internal/server";
import { T as TextInput } from "../../../../../chunks/TextInput.js";
import { I as Icon } from "../../../../../chunks/Icon.js";
import { A as ArrowLeft } from "../../../../../chunks/ArrowLeft.js";
import { C as ChevronUp } from "../../../../../chunks/ChevronUp.js";
import { P as PaperAirplane } from "../../../../../chunks/PaperAirplane.js";
import "openapi-fetch";
import "@dicebear/core";
import "@dicebear/initials";
import { F as Flag } from "../../../../../chunks/Flag.js";
import { T as Trash } from "../../../../../chunks/Trash.js";
import "clsx";
import { M as Menu, a as MenuButton } from "../../../../../chunks/MenuButton.js";
import { R as RelativeDate } from "../../../../../chunks/RelativeDate.js";
const EllipsisVertical = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M8 2a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM8 6.5a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM9.5 12.5a1.5 1.5 0 1 0-3 0 1.5 1.5 0 0 0 3 0Z"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M10 3a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM10 8.5a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM11.5 15.5a1.5 1.5 0 1 0-3 0 1.5 1.5 0 0 0 3 0Z"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "M12 6.75a.75.75 0 1 1 0-1.5.75.75 0 0 1 0 1.5ZM12 12.75a.75.75 0 1 1 0-1.5.75.75 0 0 1 0 1.5ZM12 18.75a.75.75 0 1 1 0-1.5.75.75 0 0 1 0 1.5Z"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M10.5 6a1.5 1.5 0 1 1 3 0 1.5 1.5 0 0 1-3 0Zm0 6a1.5 1.5 0 1 1 3 0 1.5 1.5 0 0 1-3 0Zm0 6a1.5 1.5 0 1 1 3 0 1.5 1.5 0 0 1-3 0Z",
        "clip-rule": "evenodd"
      }
    ]
  }
};
function Message($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let {
      message,
      primary = false,
      ondelete,
      onreport,
      showTimestamp = true
    } = $$props;
    $$renderer2.push(`<div${attr_class(`group relative w-full flex gap-1 items-center ${stringify(primary ? "flex-row-reverse" : "flex-row")}`)} style="max-width: min(80vw,24rem)"><div><div${attr_class(`${stringify(primary ? "bg-primary-900 dark:bg-primary-100 text-slate-50 dark:text-zinc-900 hover:brightness-75" : "bg-slate-100 dark:bg-zinc-900 hover:brightness-125")} rounded-2xl w-full p-1.5 px-3 font-medium cursor-pointer transition-all`)}>`);
    Markdown($$renderer2, {
      rendererOptions: { autoloadImages: false },
      source: message.private_message.content,
      class: "w-full"
    });
    $$renderer2.push(`<!----></div> `);
    if (showTimestamp) {
      $$renderer2.push("<!--[-->");
      RelativeDate($$renderer2, {
        class: "text-xs block -mt-0.5 ml-1 text-slate-600 dark:text-zinc-400",
        date: publishedToDate(message.private_message.published)
      });
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--></div> `);
    {
      let target = function($$renderer3, attachment) {
        Button($$renderer3, {
          color: "tertiary",
          class: "opacity-0 group-hover:opacity-100 group-focus-within:opacity-100 transition-all shrink-0",
          size: "square-md",
          rounding: "pill",
          title: store_get($$store_subs ??= {}, "$t", t)("post.actions.more.actions"),
          children: ($$renderer4) => {
            Icon($$renderer4, { src: EllipsisVertical, size: "16", micro: true });
          },
          $$slots: { default: true }
        });
      };
      Menu($$renderer2, {
        target,
        children: ($$renderer3) => {
          if (primary) {
            $$renderer3.push("<!--[-->");
            MenuButton($$renderer3, {
              color: "danger-subtle",
              onclick: () => ondelete?.(true),
              icon: Trash,
              children: ($$renderer4) => {
                $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("post.actions.more.delete"))}`);
              },
              $$slots: { default: true }
            });
          } else {
            $$renderer3.push("<!--[!-->");
            MenuButton($$renderer3, {
              color: "danger-subtle",
              onclick: () => onreport?.(true),
              icon: Flag,
              children: ($$renderer4) => {
                $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("moderation.report"))}`);
              },
              $$slots: { default: true }
            });
          }
          $$renderer3.push(`<!--]-->`);
        },
        $$slots: { target: true, default: true }
      });
    }
    $$renderer2.push(`<!----></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { data } = $$props;
    let textbox = { message: "", loading: false };
    async function deleteMessage(id) {
      await client().deletePrivateMessage({ deleted: true, private_message_id: id });
      data.message.value = {
        private_messages: data.message.value.private_messages.toSpliced(data.message.value.private_messages.findLastIndex((i) => i.private_message.id == id), 1)
      };
    }
    let interval = -1;
    let page = 1;
    async function loadMore(page2 = 1) {
      const res = await client().getPrivateMessages({
        creator_id: Number(data.creator.value.person_view.person.id),
        limit: 50,
        page: page2
      });
      const messageSet = new Set(data.message.value.private_messages.map((i) => i.private_message.id));
      const newMessages = res.private_messages.filter((i) => !messageSet.has(i.private_message.id));
      data.message.value.private_messages.push(...newMessages);
      data.message.value.private_messages.sort((a, b) => publishedToDate(b.private_message.published).getTime() - publishedToDate(a.private_message.published).getTime());
      markRead();
    }
    async function markRead() {
      data.message.value.private_messages.filter((i) => !i.private_message.read && i.private_message.creator_id != profile.current.user?.local_user_view.person.id).forEach((i) => client().markPrivateMessageAsRead({ private_message_id: i.private_message.id, read: true }));
    }
    onDestroy(() => {
      clearInterval(interval);
    });
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      head($$renderer3, ($$renderer4) => {
        $$renderer4.title(($$renderer5) => {
          $$renderer5.push(`<title>
    ${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.inbox.messages.indicator", { user: data.creator.value.person_view.person.name }))}
  </title>`);
        });
      });
      {
        let extended = function($$renderer4) {
          $$renderer4.push(`<div class="flex flex-wrap gap-4">`);
          Button($$renderer4, {
            size: "square-md",
            href: ".",
            title: store_get($$store_subs ??= {}, "$t", t)("common.back"),
            icon: ArrowLeft
          });
          $$renderer4.push(`<!----> `);
          UserLink($$renderer4, { avatar: true, user: data.creator.value.person_view.person });
          $$renderer4.push(`<!----></div>`);
        };
        Header($$renderer3, {
          pageHeader: true,
          extended,
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.inbox.messages"))}`);
          }
        });
      }
      $$renderer3.push(`<!----> `);
      Material($$renderer3, {
        color: "transparent",
        rounding: "2xl",
        padding: "none",
        class: "bg-white dark:bg-zinc-950 dark:border-t-zinc-900 w-full overflow-auto relative flex-1 min-h-0 max-h-[66vh] md:max-h-[64vh]",
        children: ($$renderer4) => {
          $$renderer4.push(`<div class="h-full overflow-auto max-w-full"><ul id="chat-window" class="flex flex-col gap-1 flex-1 px-4 py-4 min-h-0 svelte-1cdqzhb"><div class="mt-auto"></div> <p class="mx-auto mt-auto text-slate-400 dark:text-zinc-600 text-center">${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.inbox.messages.conversation", {
            user: data.creator.value.person_view.person.name + "@" + new URL(data.creator.value.person_view.person.actor_id).hostname
          }))}</p> `);
          if (data.message.value.private_messages.length % data.limit == 0) {
            $$renderer4.push("<!--[-->");
            Button($$renderer4, {
              onclick: () => loadMore(++page),
              color: "ghost",
              size: "square-md",
              title: store_get($$store_subs ??= {}, "$t", t)("common.next"),
              icon: ChevronUp,
              class: "mx-auto"
            });
          } else {
            $$renderer4.push("<!--[!-->");
          }
          $$renderer4.push(`<!--]--> <!--[-->`);
          const each_array = ensure_array_like(data.message.value.private_messages.toReversed());
          for (let index = 0, $$length = each_array.length; index < $$length; index++) {
            let private_message = each_array[index];
            const messages = data.message.value.private_messages.toReversed();
            const showTimestamp = index == 0 || new Date(private_message.private_message.published).getTime() - new Date(messages[index - 1].private_message.published).getTime() > 5 * 60 * 1e3;
            $$renderer4.push(`<div${attr_class(clsx(private_message.creator.id == data.creator.value.person_view.person.id ? "self-start" : "self-end"))}>`);
            Message($$renderer4, {
              ondelete: () => deleteMessage(private_message.private_message.id),
              onreport: () => report(private_message),
              message: private_message,
              primary: private_message.creator.id != data.creator.value.person_view.person.id,
              showTimestamp
            });
            $$renderer4.push(`<!----></div>`);
          }
          $$renderer4.push(`<!--]--></ul></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      await_block($$renderer3, data.message.value, () => {
      }, (message) => {
        $$renderer3.push(`<div class="sticky bottom-4 p-4"><form${attr_class(clsx([
          "flex w-full",
          "border-slate-200 dark:border-zinc-800",
          "p-2 gap-2 backdrop-blur-xl",
          "bg-white/50 dark:bg-zinc-950/50 border rounded-2xl",
          settings.messages.fullMarkdown ? "flex flex-col" : "flex-row h-14 items-center"
        ]))}>`);
        if (settings.messages.fullMarkdown) {
          $$renderer3.push("<!--[-->");
          MarkdownEditor($$renderer3, {
            previewButton: false,
            class: "flex-1 rounded-xl",
            get value() {
              return textbox.message;
            },
            set value($$value) {
              textbox.message = $$value;
              $$settled = false;
            }
          });
        } else {
          $$renderer3.push("<!--[!-->");
          Button($$renderer3, {
            onclick: () => settings.messages.fullMarkdown = true,
            size: "custom",
            class: "h-9 w-9",
            rounding: "xl",
            children: ($$renderer4) => {
              Icon($$renderer4, { src: Plus, mini: true, size: "18" });
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          TextInput($$renderer3, {
            class: "rounded-xl! h-full flex-1 dark:bg-zinc-925!",
            get value() {
              return textbox.message;
            },
            set value($$value) {
              textbox.message = $$value;
              $$settled = false;
            }
          });
          $$renderer3.push(`<!---->`);
        }
        $$renderer3.push(`<!--]--> <div class="flex flex-row gap-2">`);
        if (settings.messages.fullMarkdown) {
          $$renderer3.push("<!--[-->");
          Button($$renderer3, {
            onclick: () => settings.messages.fullMarkdown = false,
            size: "custom",
            class: "h-9 w-9",
            rounding: "xl",
            children: ($$renderer4) => {
              Icon($$renderer4, { src: Minus, mini: true, size: "18" });
            },
            $$slots: { default: true }
          });
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--> `);
        Button($$renderer3, {
          title: store_get($$store_subs ??= {}, "$t", t)("common.send"),
          size: "custom",
          rounding: "xl",
          class: "aspect-square h-9 flex-1",
          color: "primary",
          submit: true,
          loading: textbox.loading,
          disabled: textbox.loading,
          icon: PaperAirplane
        });
        $$renderer3.push(`<!----></div></form></div>`);
      });
      $$renderer3.push(`<!--]-->`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
