import { s as store_get, u as unsubscribe_stores, e as escape_html } from "../../../../chunks/index3.js";
import { t } from "../../../../chunks/index.js";
import { V as VirtualList } from "../../../../chunks/VirtualList.js";
import { P as Placeholder } from "../../../../chunks/Placeholder.js";
import { q as publishedToDate } from "../../../../chunks/client.svelte.js";
import { C as Check } from "../../../../chunks/Check.js";
import { T as TextInput } from "../../../../chunks/TextInput.js";
import "@sveltejs/kit/internal";
import "../../../../chunks/exports.js";
import "../../../../chunks/utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
import { R as RelativeDate } from "../../../../chunks/RelativeDate.js";
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { data: passedData } = $$props;
    let data = passedData;
    let filter = "";
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      if (data) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="flex flex-col gap-4"><form>`);
        TextInput($$renderer3, {
          label: store_get($$store_subs ??= {}, "$t", t)("filter.filter"),
          get value() {
            return filter;
          },
          set value($$value) {
            filter = $$value;
            $$settled = false;
          }
        });
        $$renderer3.push(`<!----></form> `);
        if (data.blocked && data.blocked.length > 0) {
          $$renderer3.push("<!--[-->");
          {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--> `);
          {
            let item = function($$renderer4, index) {
              if (data.blocked[index]) {
                $$renderer4.push("<!--[-->");
                $$renderer4.push(`<div class="flex justify-between items-center first:pt-0 last:pb-0 my-3 px-6"><div class="flex flex-col"><span class="font-medium">${escape_html(data.blocked[index].domain)}</span> <span class="text-xs text-slate-600 dark:text-zinc-400 capitalize">${escape_html(data.blocked[index].software ?? "Unknown")} • `);
                RelativeDate($$renderer4, { date: publishedToDate(data.blocked[index].published) });
                $$renderer4.push(`<!----></span></div></div>`);
              } else {
                $$renderer4.push("<!--[!-->");
              }
              $$renderer4.push(`<!--]-->`);
            };
            VirtualList($$renderer3, {
              items: data.blocked,
              useWindow: false,
              height: 600,
              estimatedHeight: 50,
              class: "overflow-auto border rounded-2xl border-slate-200 dark:border-zinc-900 bg-white dark:bg-zinc-950\n      divide-y divide-slate-200 dark:divide-zinc-900 w-full",
              item,
              $$slots: { item: true }
            });
          }
          $$renderer3.push(`<!---->`);
        } else {
          $$renderer3.push("<!--[!-->");
          Placeholder($$renderer3, {
            icon: Check,
            title: "No blocked instances",
            description: "This instance does not block any others."
          });
        }
        $$renderer3.push(`<!--]--></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]-->`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
