import { h as head, e as escape_html, s as store_get, u as unsubscribe_stores } from "../../../chunks/index3.js";
import "@sveltejs/kit/internal";
import "../../../chunks/exports.js";
import "../../../chunks/utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
import { F as DEFAULT_CLIENT_TYPE, L as LINKED_INSTANCE_URL, G as DOMAIN_REGEX_FORMS, D as DEFAULT_INSTANCE_URL, P as PiefedClient, H as LemmyClient, B as Button } from "../../../chunks/client.svelte.js";
import { p as page } from "../../../chunks/index4.js";
import "@sveltejs/kit";
import { t } from "../../../chunks/index.js";
import { E as ErrorContainer } from "../../../chunks/ErrorContainer.js";
import { H as Header } from "../../../chunks/Header.js";
import { I as Icon } from "../../../chunks/Icon.js";
import { I as Identification } from "../../../chunks/Identification.js";
import { Q as QuestionMarkCircle } from "../../../chunks/QuestionMarkCircle.js";
import { U as UserCircle } from "../../../chunks/UserCircle.js";
import { T as TextInput } from "../../../chunks/TextInput.js";
import { N as Note } from "../../../chunks/Note.js";
import "../../../chunks/settings.svelte.js";
import "@dicebear/core";
import "@dicebear/initials";
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { ref = page.url.searchParams.get("redirect") ?? "/", children } = $$props;
    let form = {
      instance: DEFAULT_INSTANCE_URL,
      username: "",
      password: "",
      totp: "",
      loading: false,
      client: DEFAULT_CLIENT_TYPE
    };
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      head($$renderer3, ($$renderer4) => {
        $$renderer4.title(($$renderer5) => {
          $$renderer5.push(`<title>${escape_html(store_get($$store_subs ??= {}, "$t", t)("account.login"))}</title>`);
        });
      });
      $$renderer3.push(`<div class="max-w-xl w-full mx-auto h-max my-auto"><form class="flex flex-col gap-5"><div class="flex flex-col">`);
      children?.($$renderer3);
      $$renderer3.push(`<!----> `);
      Header($$renderer3, {
        children: ($$renderer4) => {
          $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("account.login"))}`);
        }
      });
      $$renderer3.push(`<!----> `);
      ErrorContainer($$renderer3, { class: "pt-2", scope: page.route.id });
      $$renderer3.push(`<!----></div> `);
      if (form.client.name == "piefed") {
        $$renderer3.push("<!--[-->");
        Note($$renderer3, {
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("account.piefedGate"))}`);
          }
        });
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> <div class="flex flex-row w-full items-center gap-2">`);
      TextInput($$renderer3, {
        id: "username",
        label: store_get($$store_subs ??= {}, "$t", t)("form.username"),
        class: "flex-1",
        required: true,
        get value() {
          return form.username;
        },
        set value($$value) {
          form.username = $$value;
          $$settled = false;
        }
      });
      $$renderer3.push(`<!----> `);
      if (!LINKED_INSTANCE_URL) {
        $$renderer3.push("<!--[-->");
        {
          let customLabel = function($$renderer4) {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.instance"))} <span class="absolute right-0">`);
            {
              $$renderer4.push("<!--[!-->");
              {
                $$renderer4.push("<!--[!-->");
              }
              $$renderer4.push(`<!--]-->`);
            }
            $$renderer4.push(`<!--]--></span>`);
          };
          TextInput($$renderer3, {
            id: "instance_url",
            placeholder: DEFAULT_INSTANCE_URL,
            disabled: LINKED_INSTANCE_URL != void 0,
            class: "flex-1 overflow-hidden",
            required: true,
            pattern: DOMAIN_REGEX_FORMS,
            autocorrect: "off",
            autocapitalize: "off",
            get value() {
              return form.instance;
            },
            set value($$value) {
              form.instance = $$value;
              $$settled = false;
            },
            customLabel,
            $$slots: { customLabel: true }
          });
        }
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div> <div role="presentation" class="flex flex-row gap-2">`);
      TextInput($$renderer3, {
        id: "password",
        label: store_get($$store_subs ??= {}, "$t", t)("form.password"),
        type: "password",
        minlength: form.client.name == "piefed" ? PiefedClient.constants.password.minLength : LemmyClient.constants.password.minLength,
        maxlength: form.client.name == "piefed" ? PiefedClient.constants.password.maxLength : LemmyClient.constants.password.maxLength,
        required: true,
        class: "w-full",
        get value() {
          return form.password;
        },
        set value($$value) {
          form.password = $$value;
          $$settled = false;
        }
      });
      $$renderer3.push(`<!----> `);
      TextInput($$renderer3, {
        id: "totp",
        label: store_get($$store_subs ??= {}, "$t", t)("form.2fa"),
        placeholder: "123456",
        pattern: "\\d{6}",
        minlength: 6,
        maxlength: 6,
        class: "w-24",
        get value() {
          return form.totp;
        },
        set value($$value) {
          form.totp = $$value;
          $$settled = false;
        }
      });
      $$renderer3.push(`<!----></div> `);
      Button($$renderer3, {
        loading: form.loading,
        disabled: form.loading,
        color: "primary",
        size: "lg",
        submit: true,
        children: ($$renderer4) => {
          $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("account.login"))}`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> <hr class="border-slate-200 dark:border-zinc-800"/> <div class="flex flex-row items-center gap-2 overflow-auto *:shrink-0">`);
      Button($$renderer3, {
        rounding: "pill",
        color: "ghost",
        href: "/signup",
        children: ($$renderer4) => {
          Icon($$renderer4, { src: Identification, mini: true, size: "16" });
          $$renderer4.push(`<!----> ${escape_html(store_get($$store_subs ??= {}, "$t", t)("account.signup"))}`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      Button($$renderer3, {
        rounding: "pill",
        color: "ghost",
        href: "/login_reset",
        children: ($$renderer4) => {
          Icon($$renderer4, { src: QuestionMarkCircle, mini: true, size: "16" });
          $$renderer4.push(`<!----> ${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.forgotpassword"))}`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      if (!LINKED_INSTANCE_URL) {
        $$renderer3.push("<!--[-->");
        Button($$renderer3, {
          rounding: "pill",
          color: "ghost",
          href: "/login/guest",
          children: ($$renderer4) => {
            Icon($$renderer4, { src: UserCircle, mini: true, size: "16" });
            $$renderer4.push(`<!----> ${escape_html(store_get($$store_subs ??= {}, "$t", t)("account.guest"))}`);
          },
          $$slots: { default: true }
        });
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div></form></div>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
