import { s as store_get, u as unsubscribe_stores, e as escape_html } from "../../../../chunks/index3.js";
import "@sveltejs/kit/internal";
import "../../../../chunks/exports.js";
import "../../../../chunks/utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
import { p as profile, L as LINKED_INSTANCE_URL, G as DOMAIN_REGEX_FORMS, B as Button } from "../../../../chunks/client.svelte.js";
import { p as page } from "../../../../chunks/index4.js";
import { t } from "../../../../chunks/index.js";
import { H as Header } from "../../../../chunks/Header.js";
import { T as TextInput } from "../../../../chunks/TextInput.js";
import "../../../../chunks/settings.svelte.js";
import "openapi-fetch";
import "@sveltejs/kit";
import "lemmy-js-client";
import "@dicebear/core";
import "@dicebear/initials";
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { ref = page.url.searchParams.get("redirect") ?? "/", children } = $$props;
    let form = {
      instance: "",
      username: `${store_get($$store_subs ??= {}, "$t", t)("account.guest")} ${profile.meta.profiles.filter((p) => p.jwt == void 0).length + 1}`,
      loading: false
    };
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      $$renderer3.push(`<div class="max-w-xl w-full mx-auto h-max my-auto"><form class="flex flex-col gap-5"><div class="flex flex-col gap-2">`);
      children?.($$renderer3);
      $$renderer3.push(`<!----> `);
      Header($$renderer3, {
        children: ($$renderer4) => {
          $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("account.addGuest"))}`);
        }
      });
      $$renderer3.push(`<!----></div> <div class="inline-flex items-center gap-2">`);
      TextInput($$renderer3, {
        required: true,
        label: store_get($$store_subs ??= {}, "$t", t)("form.name"),
        placeholder: "Guest 2",
        minlength: 1,
        class: "flex-1",
        get value() {
          return form.username;
        },
        set value($$value) {
          form.username = $$value;
          $$settled = false;
        }
      });
      $$renderer3.push(`<!----> `);
      if (!LINKED_INSTANCE_URL) {
        $$renderer3.push("<!--[-->");
        {
          let customLabel = function($$renderer4) {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.instance"))} <span class="absolute right-0">`);
            {
              $$renderer4.push("<!--[!-->");
              {
                $$renderer4.push("<!--[!-->");
              }
              $$renderer4.push(`<!--]-->`);
            }
            $$renderer4.push(`<!--]--></span>`);
          };
          TextInput($$renderer3, {
            required: true,
            pattern: DOMAIN_REGEX_FORMS,
            placeholder: "example.com",
            class: "flex-1 overflow-hidden",
            autocorrect: "off",
            autocapitalize: "none",
            get value() {
              return form.instance;
            },
            set value($$value) {
              form.instance = $$value;
              $$settled = false;
            },
            customLabel,
            $$slots: { customLabel: true }
          });
        }
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div> `);
      Button($$renderer3, {
        submit: true,
        class: "w-full",
        color: "primary",
        size: "lg",
        loading: form.loading,
        disabled: form.loading,
        children: ($$renderer4) => {
          $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.submit"))}`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----></form></div>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
