import { j as attr_style, k as stringify, f as bind_props, d as ensure_array_like, s as store_get, e as escape_html, a as attr_class, c as clsx, b as attr, u as unsubscribe_stores, i as element, g as await_block } from "../../../chunks/index3.js";
import { U as UserLink, h as Avatar, B as Button, M as Material, b as Badge, p as profile, a as getClient, t as toast, e as errorMessage, j as searchParam, c as client, y as Spinner, g as goto } from "../../../chunks/client.svelte.js";
import { p as page } from "../../../chunks/index4.js";
import { t } from "../../../chunks/index.js";
import { C as CommunityLink } from "../../../chunks/CommunityLink.js";
import { F as Fixate } from "../../../chunks/Fixate.js";
import { P as Placeholder } from "../../../chunks/Placeholder.js";
import "clsx";
import { n as noop, _ as state, c as render_effect, W as set, g as get } from "../../../chunks/utils2.js";
import { H as Header } from "../../../chunks/Header.js";
import { C as CommonList } from "../../../chunks/CommonList.js";
import { S as Select, O as Option } from "../../../chunks/Select.js";
import { I as Icon } from "../../../chunks/Icon.js";
import { C as Check } from "../../../chunks/Check.js";
import { F as Funnel } from "../../../chunks/Funnel.js";
import { S as ShieldCheck } from "../../../chunks/ShieldCheck.js";
import { X as XMark } from "../../../chunks/XMark.js";
import { t as tick } from "../../../chunks/index-server.js";
import "../../../chunks/settings.svelte.js";
import { P as Pageination } from "../../../chunks/Pageination.js";
import "openapi-fetch";
import "@dicebear/core";
import "@dicebear/initials";
import { C as CommentItem } from "../../../chunks/CommentItem.js";
import { P as PrivateMessage } from "../../../chunks/PrivateMessage.js";
import "@sveltejs/kit/internal";
import "../../../chunks/exports.js";
import "../../../chunks/utils.js";
import "@sveltejs/kit/internal/server";
import { L as Label } from "../../../chunks/Label.js";
import { M as Modal } from "../../../chunks/Modal.js";
import { P as PostItem } from "../../../chunks/PostItem.js";
const now = () => Date.now();
const raf = {
  // don't access requestAnimationFrame eagerly outside method
  // this allows basic testing of user code without JSDOM
  // bunder will eval and remove ternary when the user's app is built
  tick: (
    /** @param {any} _ */
    (_) => noop()
  ),
  now: () => now(),
  tasks: /* @__PURE__ */ new Set()
};
function loop(callback) {
  let task;
  if (raf.tasks.size === 0) ;
  return {
    promise: new Promise((fulfill) => {
      raf.tasks.add(task = { c: callback, f: fulfill });
    }),
    abort() {
      raf.tasks.delete(task);
    }
  };
}
const CheckBadge = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M15 8c0 .982-.472 1.854-1.202 2.402a2.995 2.995 0 0 1-.848 2.547 2.995 2.995 0 0 1-2.548.849A2.996 2.996 0 0 1 8 15a2.996 2.996 0 0 1-2.402-1.202 2.995 2.995 0 0 1-2.547-.848 2.995 2.995 0 0 1-.849-2.548A2.996 2.996 0 0 1 1 8c0-.982.472-1.854 1.202-2.402a2.995 2.995 0 0 1 .848-2.547 2.995 2.995 0 0 1 2.548-.849A2.995 2.995 0 0 1 8 1c.982 0 1.854.472 2.402 1.202a2.995 2.995 0 0 1 2.547.848c.695.695.978 1.645.849 2.548A2.996 2.996 0 0 1 15 8Zm-3.291-2.843a.75.75 0 0 1 .135 1.052l-4.25 5.5a.75.75 0 0 1-1.151.043l-2.25-2.5a.75.75 0 1 1 1.114-1.004l1.65 1.832 3.7-4.789a.75.75 0 0 1 1.052-.134Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M16.403 12.652a3 3 0 0 0 0-5.304 3 3 0 0 0-3.75-3.751 3 3 0 0 0-5.305 0 3 3 0 0 0-3.751 3.75 3 3 0 0 0 0 5.305 3 3 0 0 0 3.75 3.751 3 3 0 0 0 5.305 0 3 3 0 0 0 3.751-3.75Zm-2.546-4.46a.75.75 0 0 0-1.214-.883l-3.483 4.79-1.88-1.88a.75.75 0 1 0-1.06 1.061l2.5 2.5a.75.75 0 0 0 1.137-.089l4-5.5Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "M9 12.75 11.25 15 15 9.75M21 12c0 1.268-.63 2.39-1.593 3.068a3.745 3.745 0 0 1-1.043 3.296 3.745 3.745 0 0 1-3.296 1.043A3.745 3.745 0 0 1 12 21c-1.268 0-2.39-.63-3.068-1.593a3.746 3.746 0 0 1-3.296-1.043 3.745 3.745 0 0 1-1.043-3.296A3.745 3.745 0 0 1 3 12c0-1.268.63-2.39 1.593-3.068a3.745 3.745 0 0 1 1.043-3.296 3.746 3.746 0 0 1 3.296-1.043A3.746 3.746 0 0 1 12 3c1.268 0 2.39.63 3.068 1.593a3.746 3.746 0 0 1 3.296 1.043 3.746 3.746 0 0 1 1.043 3.296A3.745 3.745 0 0 1 21 12Z"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M8.603 3.799A4.49 4.49 0 0 1 12 2.25c1.357 0 2.573.6 3.397 1.549a4.49 4.49 0 0 1 3.498 1.307 4.491 4.491 0 0 1 1.307 3.497A4.49 4.49 0 0 1 21.75 12a4.49 4.49 0 0 1-1.549 3.397 4.491 4.491 0 0 1-1.307 3.497 4.491 4.491 0 0 1-3.497 1.307A4.49 4.49 0 0 1 12 21.75a4.49 4.49 0 0 1-3.397-1.549 4.49 4.49 0 0 1-3.498-1.306 4.491 4.491 0 0 1-1.307-3.498A4.49 4.49 0 0 1 2.25 12c0-1.357.6-2.573 1.549-3.397a4.49 4.49 0 0 1 1.307-3.497 4.49 4.49 0 0 1 3.497-1.307Zm7.007 6.387a.75.75 0 1 0-1.22-.872l-3.236 4.53L9.53 12.22a.75.75 0 0 0-1.06 1.06l2.25 2.25a.75.75 0 0 0 1.14-.094l3.75-5.25Z",
        "clip-rule": "evenodd"
      }
    ]
  }
};
function linear(t2) {
  return t2;
}
function expoOut(t2) {
  return t2 === 1 ? t2 : 1 - Math.pow(2, -10 * t2);
}
function is_date(obj) {
  return Object.prototype.toString.call(obj) === "[object Date]";
}
function get_interpolator(a, b) {
  if (a === b || a !== a) return () => a;
  const type = typeof a;
  if (type !== typeof b || Array.isArray(a) !== Array.isArray(b)) {
    throw new Error("Cannot interpolate values of different type");
  }
  if (Array.isArray(a)) {
    const arr = (
      /** @type {Array<any>} */
      b.map((bi, i) => {
        return get_interpolator(
          /** @type {Array<any>} */
          a[i],
          bi
        );
      })
    );
    return (t2) => arr.map((fn) => fn(t2));
  }
  if (type === "object") {
    if (!a || !b) {
      throw new Error("Object cannot be null");
    }
    if (is_date(a) && is_date(b)) {
      const an = a.getTime();
      const bn = b.getTime();
      const delta = bn - an;
      return (t2) => new Date(an + t2 * delta);
    }
    const keys = Object.keys(b);
    const interpolators = {};
    keys.forEach((key) => {
      interpolators[key] = get_interpolator(a[key], b[key]);
    });
    return (t2) => {
      const result = {};
      keys.forEach((key) => {
        result[key] = interpolators[key](t2);
      });
      return result;
    };
  }
  if (type === "number") {
    const delta = (
      /** @type {number} */
      b - /** @type {number} */
      a
    );
    return (t2) => a + t2 * delta;
  }
  return () => b;
}
class Tween {
  #current;
  #target;
  /** @type {TweenedOptions<T>} */
  #defaults;
  /** @type {import('../internal/client/types').Task | null} */
  #task = null;
  /**
   * @param {T} value
   * @param {TweenedOptions<T>} options
   */
  constructor(value, options = {}) {
    this.#current = state(value);
    this.#target = state(value);
    this.#defaults = options;
  }
  /**
   * Create a tween whose value is bound to the return value of `fn`. This must be called
   * inside an effect root (for example, during component initialisation).
   *
   * ```svelte
   * <script>
   * 	import { Tween } from 'svelte/motion';
   *
   * 	let { number } = $props();
   *
   * 	const tween = Tween.of(() => number);
   * <\/script>
   * ```
   * @template U
   * @param {() => U} fn
   * @param {TweenedOptions<U>} [options]
   */
  static of(fn, options) {
    const tween = new Tween(fn(), options);
    render_effect(() => {
      tween.set(fn());
    });
    return tween;
  }
  /**
   * Sets `tween.target` to `value` and returns a `Promise` that resolves if and when `tween.current` catches up to it.
   *
   * If `options` are provided, they will override the tween's defaults.
   * @param {T} value
   * @param {TweenedOptions<T>} [options]
   * @returns
   */
  set(value, options) {
    set(this.#target, value);
    let {
      delay = 0,
      duration = 400,
      easing = linear,
      interpolate = get_interpolator
    } = { ...this.#defaults, ...options };
    if (duration === 0) {
      this.#task?.abort();
      set(this.#current, value);
      return Promise.resolve();
    }
    const start = raf.now() + delay;
    let fn;
    let started = false;
    let previous_task = this.#task;
    this.#task = loop((now2) => {
      if (now2 < start) {
        return true;
      }
      if (!started) {
        started = true;
        const prev = this.#current.v;
        fn = interpolate(prev, value);
        if (typeof duration === "function") {
          duration = duration(prev, value);
        }
        previous_task?.abort();
      }
      const elapsed = now2 - start;
      if (elapsed > /** @type {number} */
      duration) {
        set(this.#current, value);
        return false;
      }
      set(this.#current, fn(easing(elapsed / /** @type {number} */
      duration)));
      return true;
    });
    return this.#task.promise;
  }
  get current() {
    return get(this.#current);
  }
  get target() {
    return get(this.#target);
  }
  set target(v) {
    this.set(v);
  }
}
function ProgressBar($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let { progress = 0 } = $$props;
    let tween = new Tween(progress, { easing: expoOut });
    $$renderer2.push(`<div class="bg-primary-900 dark:bg-primary-100 h-1 rounded-full"${attr_style(`width: ${stringify(tween.current >= 0 ? tween.current * 100 : 0)}%;`)}></div>`);
  });
}
function Report($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { item: items = void 0 } = $$props;
    const item = items[0];
    let resolving = false;
    async function resolve() {
      if (!profile.current?.jwt || !profile.current.user) return;
      resolving = true;
      try {
        switch (item.type) {
          case "comment": {
            await Promise.all(items.map(async (i) => getClient().resolveCommentReport({ report_id: i.id, resolved: !i.resolved }).then((res) => {
              i.resolved = res.comment_report_view.comment_report.resolved;
              i.resolver = res.comment_report_view.resolver;
              profile.inbox.notifications.reports += i.resolved ? -1 : 1;
            })));
            break;
          }
          case "post": {
            await Promise.all(items.map(async (i) => getClient().resolvePostReport({ report_id: i.id, resolved: !i.resolved }).then((res) => {
              i.resolved = res.post_report_view.post_report.resolved;
              i.resolver = res.post_report_view.resolver;
              profile.inbox.notifications.reports += i.resolved ? -1 : 1;
            })));
            break;
          }
          case "message": {
            await Promise.all(items.map(async (i) => getClient().resolvePrivateMessageReport({ report_id: i.id, resolved: !i.resolved }).then((res) => {
              i.resolved = res.private_message_report_view.private_message_report.resolved;
              i.resolver = res.private_message_report_view.resolver;
              profile.inbox.notifications.reports += i.resolved ? -1 : 1;
            })));
            break;
          }
        }
        toast({
          content: item.resolved ? store_get($$store_subs ??= {}, "$t", t)("toast.resolveReport") : store_get($$store_subs ??= {}, "$t", t)("toast.unresolveReport"),
          type: "success"
        });
      } catch (err) {
        toast({ content: errorMessage(err), type: "error" });
      }
      resolving = false;
    }
    let usersModal = false;
    let reasonsModal = false;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      Modal($$renderer3, {
        title: "Report from",
        get open() {
          return usersModal;
        },
        set open($$value) {
          usersModal = $$value;
          $$settled = false;
        },
        children: ($$renderer4) => {
          $$renderer4.push(`<div class="flex flex-col divide-y divide-slate-200 dark:divide-zinc-800"><!--[-->`);
          const each_array = ensure_array_like(items);
          for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
            let item2 = each_array[$$index];
            UserLink($$renderer4, { avatar: false, user: item2.creator, class: "py-1" });
          }
          $$renderer4.push(`<!--]--></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      Modal($$renderer3, {
        title: store_get($$store_subs ??= {}, "$t", t)("moderation.reason"),
        get open() {
          return reasonsModal;
        },
        set open($$value) {
          reasonsModal = $$value;
          $$settled = false;
        },
        children: ($$renderer4) => {
          $$renderer4.push(`<div class="flex flex-col divide-y divide-slate-200 dark:divide-zinc-800"><!--[-->`);
          const each_array_1 = ensure_array_like(items);
          for (let $$index_1 = 0, $$length = each_array_1.length; $$index_1 < $$length; $$index_1++) {
            let item2 = each_array_1[$$index_1];
            $$renderer4.push(`<div class="py-2">`);
            UserLink($$renderer4, { avatar: false, user: item2.creator, class: "py-1 block" });
            $$renderer4.push(`<!----> <blockquote class="italic text-sm pl-4 border-l-2 border-slate-300 dark:border-zinc-700">${escape_html(item2.reason)}</blockquote></div>`);
          }
          $$renderer4.push(`<!--]--></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> <div${attr_class(clsx(["flex flex-row flex-wrap gap-4"]))}>`);
      if (item.type == "comment" || item.type == "post") {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="flex flex-col gap-1.5"><span class="text-xs font-medium">${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.post.community"))}</span> <a${attr("href", `?community=${stringify(item.item.community.id)}`)} class="flex items-center gap-1 font-medium hover:underline">`);
        Avatar($$renderer3, {
          circle: false,
          url: item.item.community.icon,
          alt: item.item.community.name,
          width: 24
        });
        $$renderer3.push(`<!----> ${escape_html(item.item.community.title)}</a></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      if (items.length > 1) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<button class="flex-1 text-2xl font-medium hover:underline cursor-pointer text-left w-max">${escape_html(items.length)}x</button>`);
      } else {
        $$renderer3.push("<!--[!-->");
        $$renderer3.push(`<div class="flex flex-col gap-1.5"><span class="text-xs font-medium">Report from</span> <span class="font-bold">`);
        UserLink($$renderer3, { avatar: true, user: item.creator });
        $$renderer3.push(`<!----></span></div>`);
      }
      $$renderer3.push(`<!--]--> <div class="flex-1"></div> `);
      Button($$renderer3, {
        onclick: resolve,
        class: "h-max self-end",
        loading: resolving,
        disabled: resolving,
        rounding: "pill",
        size: "sm",
        color: item.resolved ? "secondary" : "primary",
        icon: CheckBadge,
        children: ($$renderer4) => {
          $$renderer4.push(`<!---->${escape_html(!item.resolved ? store_get($$store_subs ??= {}, "$t", t)("routes.moderation.resolve") : store_get($$store_subs ??= {}, "$t", t)("routes.moderation.unresolve"))}`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----></div> `);
      Material($$renderer3, {
        rounding: "xl",
        color: "uniform",
        class: "dark:bg-zinc-950",
        children: ($$renderer4) => {
          if (item.type == "comment") {
            $$renderer4.push("<!--[-->");
            CommentItem($$renderer4, { comment: item.item, class: "p-0!" });
          } else {
            $$renderer4.push("<!--[!-->");
            if (item.type == "post") {
              $$renderer4.push("<!--[-->");
              PostItem($$renderer4, { post: item.item });
            } else {
              $$renderer4.push("<!--[!-->");
              if (item.type == "message") {
                $$renderer4.push("<!--[-->");
                PrivateMessage($$renderer4, {
                  message: {
                    creator: item.reportee,
                    private_message: item.item,
                    recipient: item.creator
                  }
                });
              } else {
                $$renderer4.push("<!--[!-->");
              }
              $$renderer4.push(`<!--]-->`);
            }
            $$renderer4.push(`<!--]-->`);
          }
          $$renderer4.push(`<!--]-->`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> <div class="flex flex-row gap-4 items-center flex-wrap"><div>`);
      Label($$renderer3, {
        children: ($$renderer4) => {
          $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.moderation.reason"))}`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> <p>${escape_html(item.reason)}</p> `);
      if (items.length > 1) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<button class="cursor-pointer">`);
        Badge($$renderer3, {
          class: "w-max my-1",
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->+${escape_html(items.length - 1)}`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----></button>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div> <div class="flex-1"></div> `);
      if (item.resolver) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div>`);
        Label($$renderer3, {
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.moderation.resolvedBy"))}`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        UserLink($$renderer3, { avatar: true, user: item.resolver });
        $$renderer3.push(`<!----></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { item: items });
  });
}
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { data = void 0 } = $$props;
    let batch = { progress: -1 };
    async function markAllAsResolved() {
      if (!data.items?.value) return;
      batch.progress = 0;
      await Promise.all(data.items?.value.map((report) => {
        report.map((r) => {
          switch (r.type) {
            case "comment": {
              const promise = client().resolveCommentReport({ report_id: r.id, resolved: true });
              promise.then(() => batch.progress += 1 / data.items?.value.length);
              return promise;
            }
            case "post": {
              const promise = client().resolvePostReport({ report_id: r.id, resolved: true });
              promise.then(() => batch.progress += 1 / data.items?.value.length);
              return promise;
            }
            case "message": {
              const promise = client().resolvePrivateMessageReport({ report_id: r.id, resolved: true });
              promise.then(() => batch.progress += 1 / data.items?.value.length);
              return promise;
            }
          }
        });
      }));
      toast({
        content: store_get($$store_subs ??= {}, "$t", t)("routes.moderation.markAllComplete"),
        type: "success"
      });
      await goto(page.url, {});
      batch.progress = -1;
    }
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      {
        let extended = function($$renderer4) {
          $$renderer4.push(`<div class="flex flex-row gap-2 flex-wrap items-end">`);
          {
            let customLabel = function($$renderer5) {
              $$renderer5.push(`<span class="flex items-center gap-1">`);
              Icon($$renderer5, { src: Funnel, size: "15", mini: true });
              $$renderer5.push(`<!----> ${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.filter"))}</span>`);
            };
            Select($$renderer4, {
              onchange: async () => {
                await tick();
                searchParam(page.url, "type", data.type.value, "page");
              },
              get value() {
                return data.type.value;
              },
              set value($$value) {
                data.type.value = $$value;
                $$settled = false;
              },
              customLabel,
              children: ($$renderer5) => {
                Option($$renderer5, {
                  value: "all",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.location.all"))}`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                Option($$renderer5, {
                  value: "unread",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.unread"))}`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!---->`);
              },
              $$slots: { customLabel: true, default: true }
            });
          }
          $$renderer4.push(`<!----> `);
          Button($$renderer4, {
            loading: batch.progress >= 0,
            disabled: batch.progress >= 0 || data.items.value?.length == 0,
            onclick: markAllAsResolved,
            size: "lg",
            class: "ml-auto",
            color: "primary",
            children: ($$renderer5) => {
              Icon($$renderer5, { src: Check, size: "16", mini: true });
              $$renderer5.push(`<!----> ${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.moderation.markAll"))}`);
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!----></div> `);
          if (data.filters.community) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<ul class="font-normal flex flex-col gap-2 mt-2"><li><span class="text-sm text-slate-600 dark:text-zinc-400">${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.post.community"))}</span> `);
            await_block(
              $$renderer4,
              client().getCommunity({ id: data.filters.community }),
              () => {
                Spinner($$renderer4, { width: 24 });
              },
              (community) => {
                $$renderer4.push(`<a class="inline"${attr("aria-label", store_get($$store_subs ??= {}, "$t", t)("common.remove"))} href="?community=">`);
                Icon($$renderer4, { src: XMark, size: "16", micro: true, class: "inline" });
                $$renderer4.push(`<!----></a> `);
                CommunityLink($$renderer4, {
                  class: "w-max inline",
                  community: community.community_view.community
                });
                $$renderer4.push(`<!---->`);
              }
            );
            $$renderer4.push(`<!--]--></li></ul>`);
          } else {
            $$renderer4.push("<!--[!-->");
          }
          $$renderer4.push(`<!--]-->`);
        };
        Header($$renderer3, {
          pageHeader: true,
          extended,
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.moderation.title"))}`);
          }
        });
      }
      $$renderer3.push(`<!----> `);
      if (batch.progress > 0) {
        $$renderer3.push("<!--[-->");
        ProgressBar($$renderer3, { progress: batch.progress });
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      if (data.items?.value && data.items?.value.length > 0) {
        $$renderer3.push("<!--[-->");
        CommonList($$renderer3, {
          size: "lg",
          children: ($$renderer4) => {
            $$renderer4.push(`<!--[-->`);
            const each_array = ensure_array_like(data.items.value ?? []);
            for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
              let item = each_array[$$index];
              element(
                $$renderer4,
                item.length == 1 ? "li" : "div",
                () => {
                  $$renderer4.push(` class="z-0 relative"`);
                },
                () => {
                  Material($$renderer4, {
                    rounding: item.length == 1 ? "none" : "2xl",
                    color: item.length == 1 ? "none" : "distinct",
                    padding: item.length == 1 ? "none" : "md",
                    class: ["space-y-2 w-full z-10 relative"],
                    children: ($$renderer5) => {
                      Report($$renderer5, { item });
                    },
                    $$slots: { default: true }
                  });
                  $$renderer4.push(`<!----> `);
                  if (item.length > 1) {
                    $$renderer4.push("<!--[-->");
                    Material($$renderer4, {
                      padding: "none",
                      rounding: "none",
                      color: "uniform",
                      class: "-mt-1 rounded-b-2xl w-[97%] h-6 opacity-70 left-1/2 -translate-x-1/2 -z-10 relative"
                    });
                  } else {
                    $$renderer4.push("<!--[!-->");
                  }
                  $$renderer4.push(`<!--]-->`);
                }
              );
            }
            $$renderer4.push(`<!--]-->`);
          }
        });
        $$renderer3.push(`<!----> `);
        Fixate($$renderer3, {
          placement: "bottom",
          children: ($$renderer4) => {
            Pageination($$renderer4, {
              page: data.page,
              href: (current) => `?page=${current}`,
              hasMore: data.items.value.length >= 20
            });
          }
        });
        $$renderer3.push(`<!---->`);
      } else {
        $$renderer3.push("<!--[!-->");
        $$renderer3.push(`<div class="h-full grid place-items-center">`);
        Placeholder($$renderer3, {
          icon: ShieldCheck,
          title: store_get($$store_subs ??= {}, "$t", t)("routes.moderation.empty.title"),
          description: store_get($$store_subs ??= {}, "$t", t)("routes.moderation.empty.description")
        });
        $$renderer3.push(`<!----></div>`);
      }
      $$renderer3.push(`<!--]-->`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { data });
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
