import { g as await_block, d as ensure_array_like, k as stringify, e as escape_html, s as store_get, u as unsubscribe_stores } from "../../../../../chunks/index3.js";
import { t } from "../../../../../chunks/index.js";
import CommunityHeader from "../../../../../chunks/CommunityHeader.js";
import { b as ban } from "../../../../../chunks/moderation.js";
import { U as UserAutocomplete } from "../../../../../chunks/UserAutocomplete.js";
import { S as Switch } from "../../../../../chunks/Switch2.js";
import { H as Header } from "../../../../../chunks/Header.js";
import "@sveltejs/kit/internal";
import "../../../../../chunks/exports.js";
import "../../../../../chunks/utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
import { E as Expandable, M as Material, B as Button, y as Spinner } from "../../../../../chunks/client.svelte.js";
import "../../../../../chunks/settings.svelte.js";
import "openapi-fetch";
import "@sveltejs/kit";
import "lemmy-js-client";
import "@dicebear/core";
import "@dicebear/initials";
import { M as ModlogItemCard } from "../../../../../chunks/ModlogItemCard.js";
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let banFromCommunity = false;
    let { data } = $$props;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      {
        let extended = function($$renderer4) {
          CommunityHeader($$renderer4, {
            community: data.community.community_view.community,
            counts: data.community.community_view.counts,
            moderators: data.community.moderators,
            subscribed: data.community.community_view.subscribed,
            banner: false
          });
        };
        Header($$renderer3, { pageHeader: true, extended });
      }
      $$renderer3.push(`<!----> <div class="flex flex-col *:py-2 divide-y divide-slate-200 dark:divide-zinc-800">`);
      {
        let title = function($$renderer4) {
          $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.moderation.manage.modlogs"))}`);
        };
        Expandable($$renderer3, {
          title,
          children: ($$renderer4) => {
            Material($$renderer4, {
              color: "uniform",
              rounding: "2xl",
              class: "dark:bg-zinc-950 max-h-96 h-full overflow-auto space-y-4 mt-1",
              children: ($$renderer5) => {
                await_block(
                  $$renderer5,
                  data.modlog,
                  () => {
                    Spinner($$renderer5, { width: 24 });
                  },
                  (log) => {
                    $$renderer5.push(`<!--[-->`);
                    const each_array = ensure_array_like(log);
                    for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
                      let modLog = each_array[$$index];
                      ModlogItemCard($$renderer5, { item: modLog });
                    }
                    $$renderer5.push(`<!--]--> <div class="sticky -bottom-4 pb-4 w-full flex items-center bg-gradient-to-b from-white/0 to-white dark:from-zinc-950/0 dark:to-zinc-950">`);
                    Button($$renderer5, {
                      color: "primary",
                      rounding: "pill",
                      class: "mx-auto",
                      href: `/modlog?community=${stringify(data.community.community_view.community.id)}`,
                      children: ($$renderer6) => {
                        $$renderer6.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.post.readMore"))}`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer5.push(`<!----></div>`);
                  }
                );
                $$renderer5.push(`<!--]-->`);
              },
              $$slots: { default: true }
            });
          },
          $$slots: { title: true, default: true }
        });
      }
      $$renderer3.push(`<!----> `);
      {
        let title = function($$renderer4) {
          $$renderer4.push(`<div>${escape_html(store_get($$store_subs ??= {}, "$t", t)("moderation.ban.banFromCommunity"))}</div>`);
        };
        Expandable($$renderer3, {
          title,
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="flex flex-col gap-4">`);
            Switch($$renderer4, {
              options: [false, true],
              optionNames: [
                store_get($$store_subs ??= {}, "$t", t)("routes.moderation.manage.ban"),
                store_get($$store_subs ??= {}, "$t", t)("routes.moderation.manage.unban")
              ],
              get selected() {
                return banFromCommunity;
              },
              set selected($$value) {
                banFromCommunity = $$value;
                $$settled = false;
              }
            });
            $$renderer4.push(`<!----> `);
            UserAutocomplete($$renderer4, {
              onselect: (p) => ban(banFromCommunity, p, data.community.community_view.community),
              listing_type: "All"
            });
            $$renderer4.push(`<!----></div>`);
          },
          $$slots: { title: true, default: true }
        });
      }
      $$renderer3.push(`<!----></div>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
