import { e as escape_html, s as store_get, u as unsubscribe_stores, k as stringify } from "../../../../chunks/index3.js";
import { p as profile, y as Spinner, B as Button } from "../../../../chunks/client.svelte.js";
import { t } from "../../../../chunks/index.js";
import { C as CommunityItem } from "../../../../chunks/CommunityItem.js";
import { H as Header } from "../../../../chunks/Header.js";
import "@sveltejs/kit/internal";
import "../../../../chunks/exports.js";
import "../../../../chunks/utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
import { C as CommonList } from "../../../../chunks/CommonList.js";
import "../../../../chunks/settings.svelte.js";
import "openapi-fetch";
import "@sveltejs/kit";
import "lemmy-js-client";
import "@dicebear/core";
import "@dicebear/initials";
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    Header($$renderer2, {
      pageHeader: true,
      children: ($$renderer3) => {
        $$renderer3.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("nav.communities"))}`);
      }
    });
    $$renderer2.push(`<!----> <div class="w-full h-full flex flex-col mt-4">`);
    if (!profile.current.user) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="mx-auto my-auto">`);
      Spinner($$renderer2, { width: 24 });
      $$renderer2.push(`<!----></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
      {
        let item = function($$renderer3, moderate) {
          const community = moderate.community;
          CommunityItem($$renderer3, {
            community: {
              banned_from_community: false,
              blocked: false,
              community,
              counts: {
                comments: 0,
                community_id: 0,
                posts: 0,
                published: "2023-10-05",
                subscribers: 0,
                subscribers_local: 0,
                users_active_day: 0,
                users_active_half_year: 0,
                users_active_month: 0,
                users_active_week: 0
              },
              subscribed: "NotSubscribed"
            },
            children: ($$renderer4) => {
              Button($$renderer4, {
                href: `/moderation?community=${stringify(community.id)}`,
                color: "secondary",
                rounding: "pill",
                size: "sm",
                class: "h-max self-center",
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.moderation.feed"))}`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> <div class="w-2"></div> `);
              Button($$renderer4, {
                href: `/moderation/c/${stringify(community.id)}`,
                color: "primary",
                rounding: "pill",
                size: "sm",
                class: "h-max self-center",
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.moderation.manage.title"))}`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!---->`);
            },
            $$slots: { default: true }
          });
        };
        CommonList($$renderer2, {
          items: profile.current.user.moderates,
          item
        });
      }
    }
    $$renderer2.push(`<!--]--></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
