import { e as escape_html, s as store_get, u as unsubscribe_stores, f as bind_props, h as head, d as ensure_array_like, g as await_block, b as attr, k as stringify } from "../../../chunks/index3.js";
import { b as browser } from "../../../chunks/index5.js";
import { p as page } from "../../../chunks/index4.js";
import { U as UserLink, B as Button, j as searchParam, p as profile, c as client, y as Spinner, W as postLink } from "../../../chunks/client.svelte.js";
import { t } from "../../../chunks/index.js";
import { s as settings } from "../../../chunks/settings.svelte.js";
import { C as CommunityLink } from "../../../chunks/CommunityLink.js";
import "@dicebear/core";
import "@dicebear/initials";
import { I as Icon } from "../../../chunks/Icon.js";
import { M as MagnifyingGlass } from "../../../chunks/MagnifyingGlass.js";
import { V as ViewColumns } from "../../../chunks/ViewColumns.js";
import { X as XMark } from "../../../chunks/XMark.js";
import { S as Select, O as Option } from "../../../chunks/Select.js";
import "@sveltejs/kit/internal";
import "../../../chunks/exports.js";
import "../../../chunks/utils.js";
import "@sveltejs/kit/internal/server";
import "openapi-fetch";
import { H as Header } from "../../../chunks/Header.js";
import { P as Pageination } from "../../../chunks/Pageination.js";
import { P as Placeholder } from "../../../chunks/Placeholder.js";
import { U as UserAutocomplete } from "../../../chunks/UserAutocomplete.js";
import { O as ObjectAutocomplete } from "../../../chunks/ObjectAutocomplete.js";
import { a as ModlogAction, M as ModlogItemCard } from "../../../chunks/ModlogItemCard.js";
import "clsx";
import { m as modal } from "../../../chunks/modal2.js";
import { R as RelativeDate } from "../../../chunks/RelativeDate.js";
const Bars3BottomRight = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M2 3.75A.75.75 0 0 1 2.75 3h10.5a.75.75 0 0 1 0 1.5H2.75A.75.75 0 0 1 2 3.75ZM2 8a.75.75 0 0 1 .75-.75h10.5a.75.75 0 0 1 0 1.5H2.75A.75.75 0 0 1 2 8Zm6 4.25a.75.75 0 0 1 .75-.75h4.5a.75.75 0 0 1 0 1.5h-4.5a.75.75 0 0 1-.75-.75Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M2 4.75A.75.75 0 0 1 2.75 4h14.5a.75.75 0 0 1 0 1.5H2.75A.75.75 0 0 1 2 4.75Zm7 10.5a.75.75 0 0 1 .75-.75h7.5a.75.75 0 0 1 0 1.5h-7.5a.75.75 0 0 1-.75-.75ZM2 10a.75.75 0 0 1 .75-.75h14.5a.75.75 0 0 1 0 1.5H2.75A.75.75 0 0 1 2 10Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "M3.75 6.75h16.5M3.75 12h16.5M12 17.25h8.25"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M3 6.75A.75.75 0 0 1 3.75 6h16.5a.75.75 0 0 1 0 1.5H3.75A.75.75 0 0 1 3 6.75ZM3 12a.75.75 0 0 1 .75-.75h16.5a.75.75 0 0 1 0 1.5H3.75A.75.75 0 0 1 3 12Zm8.25 5.25a.75.75 0 0 1 .75-.75h8.25a.75.75 0 0 1 0 1.5H12a.75.75 0 0 1-.75-.75Z",
        "clip-rule": "evenodd"
      }
    ]
  }
};
function ModlogItemTable($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { item } = $$props;
    function itemInfo($$renderer3) {
      if (item.link) {
        $$renderer3.push("<!--[-->");
        Button($$renderer3, {
          color: "primary",
          rounding: "pill",
          class: "w-max",
          href: item.link,
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("common.jump"))}`);
          },
          $$slots: { default: true }
        });
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      if (item.moderatee) {
        $$renderer3.push("<!--[-->");
        UserLink($$renderer3, { avatar: true, user: item.moderatee });
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> <div>${escape_html(item.content)}</div>`);
    }
    $$renderer2.push(`<tr><td style="width: 10%;"><span>`);
    RelativeDate($$renderer2, { date: new Date(item.timestamp) });
    $$renderer2.push(`<!----></span></td><td>`);
    if (item.moderator) {
      $$renderer2.push("<!--[-->");
      UserLink($$renderer2, {
        showInstance: false,
        avatar: true,
        avatarSize: 20,
        user: item.moderator
      });
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<p class="text-slate-500 dark:text-zinc-500">Unknown</p> <p></p>`);
    }
    $$renderer2.push(`<!--]--></td><td>`);
    if (item.community) {
      $$renderer2.push("<!--[-->");
      CommunityLink($$renderer2, {
        showInstance: false,
        avatar: true,
        avatarSize: 20,
        community: item.community
      });
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--></td><td>`);
    ModlogAction($$renderer2, { action: item.actionName });
    $$renderer2.push(`<!----></td><td>`);
    if (item.reason) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<p>${escape_html(item.reason)}</p>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--></td><td align="right">`);
    if (item.content) {
      $$renderer2.push("<!--[-->");
      Button($$renderer2, {
        size: "sm",
        onclick: () => modal({
          title: store_get($$store_subs ??= {}, "$t", t)("common.info"),
          snippet: itemInfo
        }),
        children: ($$renderer3) => {
          $$renderer3.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("common.info"))}`);
        },
        $$slots: { default: true }
      });
    } else {
      $$renderer2.push("<!--[!-->");
      if (item.moderatee) {
        $$renderer2.push("<!--[-->");
        UserLink($$renderer2, { user: item.moderatee });
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]-->`);
    }
    $$renderer2.push(`<!--]--></td></tr>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { data = void 0 } = $$props;
    let view = `${settings.modlogCardView ?? browser ? !window.matchMedia("(min-width: 1600px)").matches : false}`;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      head($$renderer3, ($$renderer4) => {
        $$renderer4.title(($$renderer5) => {
          $$renderer5.push(`<title>${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.modlog.title"))}</title>`);
        });
      });
      $$renderer3.push(`<div class="flex flex-col gap-4">`);
      {
        let extended = function($$renderer4) {
          $$renderer4.push(`<span class="font-medium text-lg">${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.modlog.filters"))}</span> <ul class="font-normal flex flex-col gap-2 mt-2">`);
          if (data.params.community) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<li><div class="text-sm text-slate-600 dark:text-zinc-400">${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.post.community"))}</div> `);
            await_block(
              $$renderer4,
              client().getCommunity({ id: data.params.community }),
              () => {
                Spinner($$renderer4, { width: 24 });
              },
              (community) => {
                CommunityLink($$renderer4, { community: community.community_view.community });
              }
            );
            $$renderer4.push(`<!--]--></li>`);
          } else {
            $$renderer4.push("<!--[!-->");
          }
          $$renderer4.push(`<!--]--> `);
          if (data.params.user) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<li><div class="text-sm text-slate-600 dark:text-zinc-400">${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.admin.applications.user"))}</div> `);
            await_block(
              $$renderer4,
              client().getPersonDetails({ person_id: data.params.user, limit: 1 }),
              () => {
                Spinner($$renderer4, { width: 24 });
              },
              (person) => {
                UserLink($$renderer4, { class: "inline", user: person.person_view.person });
              }
            );
            $$renderer4.push(`<!--]--></li>`);
          } else {
            $$renderer4.push("<!--[!-->");
          }
          $$renderer4.push(`<!--]--> `);
          if (data.params.moderator) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<li><div class="text-sm text-slate-600 dark:text-zinc-400">Moderator</div> `);
            await_block(
              $$renderer4,
              client().getPersonDetails({ person_id: data.params.moderator, limit: 1 }),
              () => {
                Spinner($$renderer4, { width: 24 });
              },
              (person) => {
                UserLink($$renderer4, { class: "inline", user: person.person_view.person });
              }
            );
            $$renderer4.push(`<!--]--></li>`);
          } else {
            $$renderer4.push("<!--[!-->");
          }
          $$renderer4.push(`<!--]--> `);
          if (data.params.post) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<li><div class="text-sm text-slate-600 dark:text-zinc-400">${escape_html(store_get($$store_subs ??= {}, "$t", t)("nav.create.post"))}</div> `);
            await_block(
              $$renderer4,
              client().getPost({ id: data.params.post }),
              () => {
                Spinner($$renderer4, { width: 24 });
              },
              (post) => {
                $$renderer4.push(`<a class="hover:underline block"${attr("href", postLink(post.post_view.post))}>${escape_html(post.post_view.post.name)}</a>`);
              }
            );
            $$renderer4.push(`<!--]--></li>`);
          } else {
            $$renderer4.push("<!--[!-->");
          }
          $$renderer4.push(`<!--]--> `);
          if (data.params.comment) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<li><div class="text-sm text-slate-600 dark:text-zinc-400">${escape_html(store_get($$store_subs ??= {}, "$t", t)("moderation.removeSubmission.comment"))}</div> `);
            await_block(
              $$renderer4,
              client().getComment({ id: data.params.comment }),
              () => {
                Spinner($$renderer4, { width: 24 });
              },
              (comment) => {
                $$renderer4.push(`<a class="hover:underline block"${attr("href", `/comment/${stringify(data.params.comment)}`)}>${escape_html(comment.comment_view.comment.content.slice(1, 200))}...</a>`);
              }
            );
            $$renderer4.push(`<!--]--></li>`);
          } else {
            $$renderer4.push("<!--[!-->");
          }
          $$renderer4.push(`<!--]--></ul>`);
        };
        Header($$renderer3, {
          pageHeader: true,
          extended,
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.modlog.title"))}`);
          }
        });
      }
      $$renderer3.push(`<!----> <div class="flex flex-row flex-wrap gap-2">`);
      {
        let customLabel = function($$renderer4) {
          $$renderer4.push(`<span class="flex gap-1 items-center">`);
          Icon($$renderer4, { src: Bars3BottomRight, size: "15", mini: true });
          $$renderer4.push(`<!----> Type</span>`);
        };
        Select($$renderer3, {
          onchange: () => searchParam(page.url, "type", data.type, "page"),
          class: "w-48",
          get value() {
            return data.type;
          },
          set value($$value) {
            data.type = $$value;
            $$settled = false;
          },
          customLabel,
          children: ($$renderer4) => {
            Option($$renderer4, {
              value: "All",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->All`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Option($$renderer4, {
              value: "ModRemovePost",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->Remove post`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Option($$renderer4, {
              value: "ModLockPost",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->Lock post`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Option($$renderer4, {
              value: "ModFeaturePost",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->Feature post`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Option($$renderer4, {
              value: "ModRemoveComment",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->Remove comment`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Option($$renderer4, {
              value: "ModRemoveCommunity",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->Remove community`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Option($$renderer4, {
              value: "ModBanFromCommunity",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->Ban from community`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Option($$renderer4, {
              value: "ModAddCommunity",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->Add moderator`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Option($$renderer4, {
              value: "ModTransferCommunity",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->Transfer community`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Option($$renderer4, {
              value: "ModAdd",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->Add admin`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Option($$renderer4, {
              value: "ModBan",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->Ban admin`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Option($$renderer4, {
              value: "ModHideCommunity",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->Hide community`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Option($$renderer4, {
              value: "AdminPurgePerson",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->Purge user`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Option($$renderer4, {
              value: "AdminPurgeCommunity",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->Purge community`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Option($$renderer4, {
              value: "AdminPurgePost",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->Purge post`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Option($$renderer4, {
              value: "AdminPurgeComment",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->Purge comment`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { customLabel: true, default: true }
        });
      }
      $$renderer3.push(`<!----> `);
      {
        let customLabel = function($$renderer4) {
          $$renderer4.push(`<span class="flex gap-1 items-center">`);
          Icon($$renderer4, { src: ViewColumns, size: "15", mini: true });
          $$renderer4.push(`<!----> View</span>`);
        };
        Select($$renderer3, {
          class: "w-36",
          get value() {
            return view;
          },
          set value($$value) {
            view = $$value;
            $$settled = false;
          },
          customLabel,
          children: ($$renderer4) => {
            Option($$renderer4, {
              value: "false",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->Table`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Option($$renderer4, {
              value: "true",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->Cards`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Option($$renderer4, {
              value: "undefined",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->Default`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { customLabel: true, default: true }
        });
      }
      $$renderer3.push(`<!----></div> <div class="flex flex-col md:flex-row md:items-center gap-2 w-full">`);
      ObjectAutocomplete($$renderer3, {
        placeholder: "Filter by community",
        listing_type: "All",
        showWhenEmpty: true,
        label: "Community",
        q: page.url.searchParams.get("community") ? "Selected" : "",
        onselect: (e) => searchParam(page.url, "community", e?.community.id.toString() ?? "", "page")
      });
      $$renderer3.push(`<!----> `);
      UserAutocomplete($$renderer3, {
        instance: page.url.searchParams.get("instance") || void 0,
        placeholder: "Filter by user",
        listing_type: "All",
        showWhenEmpty: true,
        label: "User",
        q: page.url.searchParams.get("user") ? data.filters.user ?? "Selected" : "",
        onselect: (e) => searchParam(page.url, "user", e?.id.toString() ?? "", "page")
      });
      $$renderer3.push(`<!----> `);
      if (profile.isAdmin) {
        $$renderer3.push("<!--[-->");
        UserAutocomplete($$renderer3, {
          placeholder: "Filter by moderator",
          listing_type: "All",
          showWhenEmpty: true,
          label: "Moderator",
          q: page.url.searchParams.get("mod_id") ? data.filters.moderator ?? "Selected" : "",
          onselect: (e) => searchParam(page.url, "mod_id", e?.id.toString() ?? "", "page")
        });
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      Button($$renderer3, {
        onclick: () => {
          searchParam(page.url, "", "", "user", "moderator", "community", "instance");
        },
        size: "custom",
        class: "self-end shrink-0 h-8.5 aspect-square",
        title: "Clear filters",
        children: ($$renderer4) => {
          Icon($$renderer4, { src: XMark, size: "16", mini: true });
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----></div> `);
      if (data.modlog && data.modlog.length > 0) {
        $$renderer3.push("<!--[-->");
        if (settings.modlogCardView ?? !window.matchMedia("(min-width: 1600px)").matches) {
          $$renderer3.push("<!--[-->");
          $$renderer3.push(`<div class="grid grid-cols-1 md:grid-cols-2 gap-4"><!--[-->`);
          const each_array = ensure_array_like(data.modlog);
          for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
            let modlog = each_array[$$index];
            ModlogItemCard($$renderer3, { item: modlog });
          }
          $$renderer3.push(`<!--]--></div>`);
        } else {
          $$renderer3.push("<!--[!-->");
          $$renderer3.push(`<div style="width:100%; overflow-x: auto;" class="table-container svelte-k5bzdb"><table class="table overflow-x-auto table-fixed relative w-full min-w-2xl svelte-k5bzdb"><colgroup><col style="width: 10.6%;"/><col style="width: 16.6%;"/><col style="width: 16.6%;"/><col style="width: 16.6%;"/><col style="width: 16.6%;"/><col style="width: 16.6%;"/></colgroup><thead class="text-left svelte-k5bzdb"><tr class="rounded-t-lg overflow-hidden svelte-k5bzdb"><th class="svelte-k5bzdb">Time</th><th class="svelte-k5bzdb">Moderator</th><th class="svelte-k5bzdb">Community</th><th class="svelte-k5bzdb">Action</th><th class="svelte-k5bzdb">Reason</th><th align="right" class="svelte-k5bzdb">Content</th></tr></thead><tbody class="text-sm divide-y divide-slate-200 dark:divide-zinc-800 svelte-k5bzdb"><!--[-->`);
          const each_array_1 = ensure_array_like(data.modlog);
          for (let $$index_1 = 0, $$length = each_array_1.length; $$index_1 < $$length; $$index_1++) {
            let modlog = each_array_1[$$index_1];
            ModlogItemTable($$renderer3, { item: modlog });
          }
          $$renderer3.push(`<!--]--></tbody></table></div>`);
        }
        $$renderer3.push(`<!--]--> `);
        Pageination($$renderer3, {
          page: data.page,
          hasMore: data.params.hasMore,
          href: (page2) => `?page=${page2}`
        });
        $$renderer3.push(`<!---->`);
      } else {
        $$renderer3.push("<!--[!-->");
        Placeholder($$renderer3, {
          title: "No results",
          description: "There are no mod logs with that filter. Try refining your search.",
          icon: MagnifyingGlass
        });
      }
      $$renderer3.push(`<!--]--></div>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { data });
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
