import { e as escape_html, s as store_get, u as unsubscribe_stores } from "../../../../chunks/index3.js";
import "@sveltejs/kit/internal";
import "../../../../chunks/exports.js";
import "../../../../chunks/utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
import { L as LINKED_INSTANCE_URL, p as profile, D as DEFAULT_INSTANCE_URL, B as Button } from "../../../../chunks/client.svelte.js";
import { t } from "../../../../chunks/index.js";
import "@sveltejs/kit";
import "lemmy-js-client";
import "openapi-fetch";
import { T as TextInput } from "../../../../chunks/TextInput.js";
import { H as Header } from "../../../../chunks/Header.js";
import "../../../../chunks/settings.svelte.js";
import "@dicebear/core";
import "@dicebear/initials";
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { data } = $$props;
    let instance = LINKED_INSTANCE_URL || profile.current.instance || "";
    let password = "", password_verify = "";
    let loading = false;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      $$renderer3.push(`<div class="my-auto max-w-xl mx-auto flex flex-col gap-2">`);
      Header($$renderer3, {
        children: ($$renderer4) => {
          $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.passwordChange.title"))}`);
        }
      });
      $$renderer3.push(`<!----> <p>${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.passwordChange.description"))}</p> <form class="mt-2 flex flex-col gap-4">`);
      if (!LINKED_INSTANCE_URL) {
        $$renderer3.push("<!--[-->");
        TextInput($$renderer3, {
          label: store_get($$store_subs ??= {}, "$t", t)("form.password"),
          placeholder: DEFAULT_INSTANCE_URL,
          required: true,
          get value() {
            return instance;
          },
          set value($$value) {
            instance = $$value;
            $$settled = false;
          },
          children: ($$renderer4) => {
            $$renderer4.push(`<span class="font-normal text-xs">${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.passwordChange.instance"))}</span>`);
          },
          $$slots: { default: true }
        });
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      TextInput($$renderer3, {
        label: store_get($$store_subs ??= {}, "$t", t)("form.profile.newPassword"),
        type: "password",
        required: true,
        get value() {
          return password;
        },
        set value($$value) {
          password = $$value;
          $$settled = false;
        }
      });
      $$renderer3.push(`<!----> `);
      TextInput($$renderer3, {
        label: store_get($$store_subs ??= {}, "$t", t)("form.profile.verifyNewPassword"),
        type: "password",
        required: true,
        get value() {
          return password_verify;
        },
        set value($$value) {
          password_verify = $$value;
          $$settled = false;
        }
      });
      $$renderer3.push(`<!----> `);
      Button($$renderer3, {
        color: "primary",
        size: "lg",
        loading,
        disabled: loading,
        submit: true,
        children: ($$renderer4) => {
          $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.submit"))}`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----></form></div>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
