import { f as bind_props, d as ensure_array_like, b as attr, a as attr_class, s as store_get, c as clsx, i as element, e as escape_html, k as stringify, u as unsubscribe_stores, h as head, g as await_block } from "../../../../../chunks/index3.js";
import { p as page } from "../../../../../chunks/index4.js";
import { n as SvelteMap, B as Button, g as goto, c as client, t as toast, e as errorMessage, p as profile, W as postLink, a7 as mediaType, q as publishedToDate, i as Markdown, E as Expandable } from "../../../../../chunks/client.svelte.js";
import { t } from "../../../../../chunks/index.js";
import { s as settings } from "../../../../../chunks/settings.svelte.js";
import { p as parseTags, P as PostMeta } from "../../../../../chunks/PostVote.js";
import { T as Trophy, S as Star, A as ArrowTrendingDown, P as PlusCircle, C as ChatBubbleLeftRight } from "../../../../../chunks/Trophy.js";
import { C as ChevronDoubleUp } from "../../../../../chunks/ChevronDoubleUp.js";
import "@sveltejs/kit/internal";
import "../../../../../chunks/exports.js";
import "../../../../../chunks/utils.js";
import "@sveltejs/kit/internal/server";
import { P as PostItem } from "../../../../../chunks/PostItem.js";
import { F as FormattedNumber } from "../../../../../chunks/FormattedNumber.js";
import { a as PostMedia, b as PostActions } from "../../../../../chunks/PostActions.js";
import { P as Placeholder } from "../../../../../chunks/Placeholder.js";
import { C as CommonList } from "../../../../../chunks/CommonList.js";
import "openapi-fetch";
import { E as EndPlaceholder } from "../../../../../chunks/EndPlaceholder.js";
import { C as Comment, a as CommentForm } from "../../../../../chunks/Comment.js";
import "clsx";
import "@sveltejs/kit";
import "lemmy-js-client";
import { A as ArrowDownCircle } from "../../../../../chunks/ArrowDownCircle.js";
import { I as Icon } from "../../../../../chunks/Icon.js";
import { A as ArrowPath } from "../../../../../chunks/ArrowPath.js";
import { C as ChatBubbleOvalLeft } from "../../../../../chunks/ChatBubbleOvalLeft.js";
import { C as Clock } from "../../../../../chunks/Clock.js";
import { F as Fire } from "../../../../../chunks/Fire.js";
import { S as Select, O as Option } from "../../../../../chunks/Select.js";
import "@dicebear/core";
import "@dicebear/initials";
function getCommentParentId(comment) {
  const split = comment?.path.split(".");
  split?.shift();
  return split && split.length > 1 ? Number(split.at(split.length - 2)) : void 0;
}
function getDepthFromComment(comment) {
  const len = comment?.path.split(".").length;
  return len ? len - 2 : void 0;
}
function buildCommentsTree(comments, baseDepth = 0, filter = () => true) {
  const map = new SvelteMap();
  let min_depth = Number.MAX_VALUE;
  for (const comment_view of comments) {
    const depthI = getDepthFromComment(comment_view.comment) ?? 0;
    const depth = depthI + baseDepth;
    if (comment_view.comment.content == "" && comment_view.comment.removed) {
      comment_view.comment.content = `*Removed by Moderator — [${t.get("routes.modlog.title")}](/modlog?comment=${comment_view.comment.id})*`;
    }
    const node = { comment_view, children: [], depth, expanded: true };
    min_depth = Math.min(min_depth, depth);
    if (filter(comment_view)) {
      map.set(comment_view.comment.id, { ...node });
    }
  }
  const tree = [];
  for (const comment_view of comments) {
    const cNode = map.get(comment_view.comment.id);
    if (cNode && cNode.depth == min_depth) {
      tree.push(cNode);
    }
  }
  for (const comment_view of comments) {
    const child = map.get(comment_view.comment.id);
    if (child) {
      const parent_id = getCommentParentId(comment_view.comment);
      if (parent_id) {
        const parent = map.get(parent_id);
        if (parent) {
          parent.children.push(child);
        }
      }
    }
  }
  return tree;
}
function CommentTree_1($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { nodes = void 0, post } = $$props;
    let childrenPage = 0;
    async function fetchChildren(parent) {
      if (!(parent.comment_view.counts.child_count > 0 && parent.children.length == 0)) {
        return;
      }
      try {
        parent.loading = true;
        const newComments = await client().getComments({
          max_depth: 5,
          parent_id: parent.comment_view.comment.id,
          type_: "All",
          page: childrenPage
        });
        if (newComments.comments.length == 0) {
          toast({
            content: store_get($$store_subs ??= {}, "$t", t)("toast.noComments"),
            type: "error"
          });
          return;
        }
        parent.children = buildCommentsTree(newComments.comments, parent.depth)[0].children;
        childrenPage++;
      } catch (err) {
        console.error(err);
        toast({ content: errorMessage(err), type: "error" });
      }
    }
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      $$renderer3.push(`<ul class="svelte-cfzx81"><!--[-->`);
      const each_array = ensure_array_like(nodes);
      for (let index = 0, $$length = each_array.length; index < $$length; index++) {
        let node = each_array[index];
        Comment($$renderer3, {
          contentClass: [
            (node.children.length > 0 || node.comment_view.counts.child_count > 0) && "border-l",
            "ml-2.5 pl-3 sm:pl-4 lg:pl-5",
            "comment-border"
          ],
          get node() {
            return nodes[index];
          },
          set node($$value) {
            nodes[index] = $$value;
            $$settled = false;
          },
          get open() {
            return nodes[index].expanded;
          },
          set open($$value) {
            nodes[index].expanded = $$value;
            $$settled = false;
          },
          children: ($$renderer4) => {
            $$renderer4.push(`<button class="expand-btn svelte-cfzx81"${attr("aria-label", store_get($$store_subs ??= {}, "$t", t)("comment.expand"))}></button> <div${attr_class(clsx(["comment-corner", node.depth == 0 && "hidden"]), "svelte-cfzx81")}></div> `);
            if (node.children?.length > 0) {
              $$renderer4.push("<!--[-->");
              CommentTree_1($$renderer4, {
                post,
                get nodes() {
                  return nodes[index].children;
                },
                set nodes($$value) {
                  nodes[index].children = $$value;
                  $$settled = false;
                }
              });
            } else {
              $$renderer4.push("<!--[!-->");
            }
            $$renderer4.push(`<!--]-->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        if (node.comment_view.counts.child_count > 0 && node.children.length == 0) {
          $$renderer3.push("<!--[-->");
          element(
            $$renderer3,
            "a",
            () => {
              $$renderer3.push(` class="w-full h-10 -mt-2 -ml-2.5 svelte-cfzx81"${attr("href", `/comment/${stringify(node.comment_view.comment.id)}`)}`);
            },
            () => {
              Button($$renderer3, {
                loading: nodes[index].loading,
                disabled: nodes[index].loading,
                rounding: "pill",
                color: "tertiary",
                class: "font-normal text-slate-600 dark:text-zinc-400",
                shadow: "none",
                loaderWidth: 16,
                onclick: () => {
                  if (nodes[index].depth > 4) {
                    goto(`/comment/${nodes[index].comment_view.comment.id}#comments`);
                  } else {
                    nodes[index].loading = true;
                    fetchChildren(nodes[index]).then(() => nodes[index].loading = false);
                  }
                },
                icon: ArrowDownCircle,
                children: ($$renderer4) => {
                  $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("comment.more", { comments: node.comment_view.counts.child_count }))}`);
                },
                $$slots: { default: true }
              });
            }
          );
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]-->`);
      }
      $$renderer3.push(`<!--]--></ul>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { nodes });
  });
}
function CommentListVirtualizer($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      $$renderer3.push(`<div>`);
      {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
  });
}
function CommentProvider($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let {
      post,
      comments,
      sort = void 0,
      onupdate,
      focus,
      virtualize = true,
      showContext,
      singleThread
    } = $$props;
    let commenting = false;
    let tree = buildCommentsTree(comments);
    function allCommentsPlaceholder($$renderer3) {
      {
        let action = function($$renderer4) {
          Button($$renderer4, {
            href: postLink(post.post),
            icon: PlusCircle,
            rounding: "pill",
            children: ($$renderer5) => {
              $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.post.thread.allComments"))}`);
            },
            $$slots: { default: true }
          });
        };
        EndPlaceholder($$renderer3, { alignment: "center", action });
      }
    }
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      if (profile.current?.jwt) {
        $$renderer3.push("<!--[-->");
        if (!commenting) {
          $$renderer3.push("<!--[-->");
          {
            let action = function($$renderer4) {
              $$renderer4.push(`<div class="gap-2 flex items-center">`);
              Select($$renderer4, {
                size: "md",
                onchange: onupdate,
                get value() {
                  return settings.defaultSort.comments;
                },
                set value($$value) {
                  settings.defaultSort.comments = $$value;
                  $$settled = false;
                },
                children: ($$renderer5) => {
                  Option($$renderer5, {
                    icon: Fire,
                    value: "Hot",
                    children: ($$renderer6) => {
                      $$renderer6.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.sort.hot"))}`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----> `);
                  Option($$renderer5, {
                    icon: Trophy,
                    value: "Top",
                    children: ($$renderer6) => {
                      $$renderer6.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.sort.top.label"))}`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----> `);
                  Option($$renderer5, {
                    icon: Star,
                    value: "New",
                    children: ($$renderer6) => {
                      $$renderer6.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.sort.new"))}`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----> `);
                  Option($$renderer5, {
                    icon: Clock,
                    value: "Old",
                    children: ($$renderer6) => {
                      $$renderer6.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.sort.old"))}`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----> `);
                  Option($$renderer5, {
                    icon: ArrowTrendingDown,
                    value: "Controversial",
                    children: ($$renderer6) => {
                      $$renderer6.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.sort.controversial"))}`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!---->`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              Button($$renderer4, {
                size: "custom",
                class: "h-8.5 w-8.5",
                rounding: "xl",
                onclick: onupdate,
                icon: ArrowPath
              });
              $$renderer4.push(`<!----></div>`);
            };
            EndPlaceholder($$renderer3, {
              border: false,
              action,
              children: ($$renderer4) => {
                Button($$renderer4, {
                  color: "primary",
                  rounding: "xl",
                  disabled: (post.post.locked || post.banned_from_community) && !(profile.isAdmin || profile.isMod(post.community)),
                  onclick: () => commenting = true,
                  children: ($$renderer5) => {
                    Icon($$renderer5, { src: ChatBubbleOvalLeft, size: "16", micro: true });
                    $$renderer5.push(`<!----> ${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.post.addComment"))}`);
                  },
                  $$slots: { default: true }
                });
              }
            });
          }
        } else {
          $$renderer3.push("<!--[!-->");
          CommentForm($$renderer3, {
            postId: post.post.id,
            oncomment: (comment) => {
              tree.unshift({
                children: [],
                depth: 1,
                expanded: true,
                comment_view: comment.comment_view
              });
            },
            onfocus: () => commenting = true,
            tools: commenting,
            preview: commenting,
            placeholder: commenting ? void 0 : store_get($$store_subs ??= {}, "$t", t)("routes.post.addComment"),
            rows: commenting ? 7 : 1,
            oncancel: () => commenting = false
          });
        }
        $$renderer3.push(`<!--]-->`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      if (commenting || !profile.current.jwt) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="gap-2 flex items-center">`);
        Select($$renderer3, {
          size: "md",
          onchange: onupdate,
          get value() {
            return settings.defaultSort.comments;
          },
          set value($$value) {
            settings.defaultSort.comments = $$value;
            $$settled = false;
          },
          children: ($$renderer4) => {
            Option($$renderer4, {
              icon: Fire,
              value: "Hot",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.sort.hot"))}`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Option($$renderer4, {
              icon: Trophy,
              value: "Top",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.sort.top.label"))}`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Option($$renderer4, {
              icon: Star,
              value: "New",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.sort.new"))}`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Option($$renderer4, {
              icon: Clock,
              value: "Old",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.sort.old"))}`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            Option($$renderer4, {
              icon: ArrowTrendingDown,
              value: "Controversial",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.sort.controversial"))}`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        Button($$renderer3, {
          size: "custom",
          class: "h-8.5 w-8.5",
          rounding: "xl",
          onclick: onupdate,
          icon: ArrowPath
        });
        $$renderer3.push(`<!----></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      if (singleThread && !showContext) {
        $$renderer3.push("<!--[-->");
        allCommentsPlaceholder($$renderer3);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      if (showContext && tree[0]) {
        $$renderer3.push("<!--[-->");
        Button($$renderer3, {
          color: "secondary",
          alignment: "left",
          rounding: "pill",
          href: `/comment/${comments[0].comment.path.split(".").slice(-5)[1]}`,
          class: "mt-2 -mb-2 -mx-2.5 w-max",
          children: ($$renderer4) => {
            Icon($$renderer4, { src: PlusCircle, size: "16", micro: true });
            $$renderer4.push(`<!----> ${escape_html(store_get($$store_subs ??= {}, "$t", t)("comment.more", {
              comments: tree[0].comment_view.comment.path.split(".").length - 2
            }))}`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> <div class="border-l h-4 -mb-5 ml-2.5 border-slate-200 dark:border-zinc-800"></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      if (virtualize) {
        $$renderer3.push("<!--[-->");
        CommentListVirtualizer($$renderer3, { post: post.post });
      } else {
        $$renderer3.push("<!--[!-->");
        $$renderer3.push(`<div class="divide-y divide-slate-200 dark:divide-zinc-800"><div class="-mx-3 sm:-mx-6 px-3 sm:px-6">`);
        CommentTree_1($$renderer3, { nodes: tree, post: post.post });
        $$renderer3.push(`<!----></div></div>`);
      }
      $$renderer3.push(`<!--]--> `);
      if (singleThread && !showContext) {
        $$renderer3.push("<!--[-->");
        allCommentsPlaceholder($$renderer3);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]-->`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { sort });
  });
}
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { data } = $$props;
    async function reloadComments() {
      data.data.value.comments = client().getComments({
        page: 1,
        limit: 25,
        type_: "All",
        post_id: data.data.value.post.post.id,
        sort: settings.defaultSort.comments,
        max_depth: data.data.value.post.counts.comments > 100 ? 1 : 3
      }).then((i) => i.comments);
      data.data.value.params.thread.singleThread = false;
    }
    let tags = (() => {
      const parsed = parseTags(data.data.value.post.post.name);
      return {
        title: parsed.title,
        tags: [
          ...parsed.tags,
          ...data.data.value.post.flair_list?.map((i) => ({
            content: i.flair_title,
            color: i.background_color,
            icon: null,
            textColor: i.text_color,
            type: "flair"
          })) ?? []
        ]
      };
    })();
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      head($$renderer3, ($$renderer4) => {
        $$renderer4.title(($$renderer5) => {
          $$renderer5.push(`<title>
    ${escape_html(data.data.value.post.community.title)} | ${escape_html(data.data.value.post.post.name)}
  </title>`);
        });
        $$renderer4.push(`<meta property="og:title"${attr("content", data.data.value.post.post.name)}/> `);
        if (!data.data.value.post.post.local) {
          $$renderer4.push("<!--[-->");
          $$renderer4.push(`<meta name="robots" content="noindex, follow"/>`);
        } else {
          $$renderer4.push("<!--[!-->");
        }
        $$renderer4.push(`<!--]--> <link rel="canonical"${attr("href", data.data.value.post.post.ap_id)}/> `);
        if (data.data.value.post.post.body) {
          $$renderer4.push("<!--[-->");
          $$renderer4.push(`<meta property="description"${attr("content", data.data.value.post.post.body.slice(0, 500))}/> <meta property="og:description"${attr("content", data.data.value.post.post.body.slice(0, 500))}/> <meta property="twitter:description"${attr("content", data.data.value.post.post.body.slice(0, 500))}/>`);
        } else {
          $$renderer4.push("<!--[!-->");
        }
        $$renderer4.push(`<!--]--> <meta property="og:url"${attr("content", page.url.toString())}/> `);
        if (mediaType(data.data.value.post.post.url) == "image") {
          $$renderer4.push("<!--[-->");
          $$renderer4.push(`<meta property="og:image"${attr("content", data.data.value.post.post.url)}/> <meta property="twitter:card"${attr("content", data.data.value.post.post.url)}/>`);
        } else {
          $$renderer4.push("<!--[!-->");
          if (data.data.value.post.post.thumbnail_url) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<meta property="og:image"${attr("content", data.data.value.post.post.thumbnail_url)}/> <meta property="twitter:card"${attr("content", data.data.value.post.post.thumbnail_url)}/>`);
          } else {
            $$renderer4.push("<!--[!-->");
          }
          $$renderer4.push(`<!--]-->`);
        }
        $$renderer4.push(`<!--]-->`);
      });
      $$renderer3.push(`<article class="flex flex-col gap-2"><header class="flex flex-col gap-2"><div class="flex flex-row items-center gap-2 flex-wrap">`);
      PostMeta($$renderer3, {
        community: data.data.value.post.community,
        user: data.data.value.post.creator,
        subscribed: profile.current.user?.follows.find((i) => i.community.id == data.data.value.post.community.id) ? "Subscribed" : "NotSubscribed",
        badges: {
          deleted: data.data.value.post.post.deleted,
          removed: data.data.value.post.post.removed,
          locked: data.data.value.post.post.locked,
          featured: data.data.value.post.post.featured_community || data.data.value.post.post.featured_local,
          nsfw: data.data.value.post.post.nsfw,
          saved: data.data.value.post.saved,
          admin: data.data.value.post.creator_is_admin,
          moderator: data.data.value.post.creator_is_moderator
        },
        published: publishedToDate(data.data.value.post.post.published),
        edited: data.data.value.post.post.updated,
        title: data.data.value.post.post.name,
        style: "width: max-content;",
        tags: tags.tags
      });
      $$renderer3.push(`<!----></div> <h1 class="font-medium font-display text-xl leading-5 tracking-tight">`);
      Markdown($$renderer3, {
        inline: true,
        source: tags.title ?? data.data.value.post.post.name
      });
      $$renderer3.push(`<!----></h1></header> `);
      PostMedia($$renderer3, {
        type: mediaType(data.data.value.post.post),
        post: data.data.value.post.post,
        opened: true,
        view: "cozy",
        autoplay: false
      });
      $$renderer3.push(`<!----> `);
      if (data.data.value.post.post.body) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="text-base text-slate-800 dark:text-zinc-300 leading-normal">`);
        Markdown($$renderer3, { source: data.data.value.post.post.body });
        $$renderer3.push(`<!----></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> <div class="w-full relative">`);
      PostActions($$renderer3, {
        onedit: () => toast({
          content: "The post was edited successfully.",
          type: "success"
        }),
        get post() {
          return data.data.value.post;
        },
        set post($$value) {
          data.data.value.post = $$value;
          $$settled = false;
        }
      });
      $$renderer3.push(`<!----></div> `);
      await_block($$renderer3, data.data.value.meta, () => {
      }, (meta) => {
        const crossposts = meta.cross_posts;
        if (crossposts?.length > 0) {
          $$renderer3.push("<!--[-->");
          {
            let title = function($$renderer4) {
              {
                let action = function($$renderer5) {
                  $$renderer5.push(`<span class="font-bold">`);
                  FormattedNumber($$renderer5, { number: crossposts.length });
                  $$renderer5.push(`<!----></span>`);
                };
                EndPlaceholder($$renderer4, {
                  size: "md",
                  color: "none",
                  class: "w-full ",
                  action,
                  children: ($$renderer5) => {
                    $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.post.crosspostCount"))}`);
                  }
                });
              }
            };
            Expandable($$renderer3, {
              class: "text-base mt-2 w-full cursor-pointer",
              title,
              children: ($$renderer4) => {
                {
                  let item = function($$renderer5, item2) {
                    PostItem($$renderer5, { post: item2 });
                  };
                  CommonList($$renderer4, { items: crossposts, item });
                }
              },
              $$slots: { title: true, default: true }
            });
          }
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]-->`);
      });
      $$renderer3.push(`<!--]--></article> <section class="flex flex-col gap-2 w-full" id="comments"><header class="mt-4">`);
      {
        let action = function($$renderer4) {
          $$renderer4.push(`<span class="font-bold">`);
          FormattedNumber($$renderer4, { number: data.data.value.post.counts.comments });
          $$renderer4.push(`<!----></span>`);
        };
        EndPlaceholder($$renderer3, {
          size: "md",
          color: "none",
          action,
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.post.commentCount"))}`);
          }
        });
      }
      $$renderer3.push(`<!----></header> `);
      if (!page.url.searchParams.get("noVirtualize")) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<noscript>`);
        Button($$renderer3, {
          href: "?noVirtualize=true",
          class: "block",
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.post.loadComments"))}`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----></noscript>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      await_block(
        $$renderer3,
        data.data.value.comments,
        () => {
          $$renderer3.push(`<div class="flex flex-col gap-4"><!--[-->`);
          const each_array = ensure_array_like(new Array(10));
          for (let index = 0, $$length = each_array.length; index < $$length; index++) {
            let _ = each_array[index];
            $$renderer3.push(`<!---->${escape_html(_)} <div class="animate-pulse flex flex-col gap-2 w-full *:bg-slate-100 dark:*:bg-zinc-800 *:rounded-md"><div class="w-96 h-3"></div> <div class="w-full h-12"></div> <div class="w-48 h-4"></div></div>`);
          }
          $$renderer3.push(`<!--]--></div>`);
        },
        (comments) => {
          CommentProvider($$renderer3, {
            comments,
            post: data.data.value.post,
            focus: data.data.value.params.thread.focus,
            onupdate: reloadComments,
            virtualize: !page.url.searchParams.get("noVirtualize"),
            showContext: data.data.value.params.thread.showContext,
            singleThread: data.data.value.params.thread.singleThread,
            get sort() {
              return data.data.value.params.comments.sort;
            },
            set sort($$value) {
              data.data.value.params.comments.sort = $$value;
              $$settled = false;
            }
          });
          $$renderer3.push(`<!----> `);
          if (comments.length == 0) {
            $$renderer3.push("<!--[-->");
            Placeholder($$renderer3, {
              icon: ChatBubbleLeftRight,
              title: store_get($$store_subs ??= {}, "$t", t)("routes.post.emptyComments.title"),
              description: store_get($$store_subs ??= {}, "$t", t)("routes.post.emptyComments.description")
            });
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]-->`);
        }
      );
      $$renderer3.push(`<!--]--> `);
      if (data.data.value.post.counts.comments > 5) {
        $$renderer3.push("<!--[-->");
        {
          let action = function($$renderer4) {
            $$renderer4.push(`<span class="text-black dark:text-white font-bold">${escape_html(data.data.value.post.counts.comments)}</span> `);
            Button($$renderer4, {
              color: "tertiary",
              onclick: () => window.scrollTo({ top: 0, behavior: "smooth" }),
              icon: ChevronDoubleUp,
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.post.scrollToTop"))}`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!---->`);
          };
          EndPlaceholder($$renderer3, {
            action,
            children: ($$renderer4) => {
              $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.post.commentCount"))}`);
            }
          });
        }
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></section>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
