import { r as resolve } from "../../../../../chunks/server2.js";
import { p as profile, R as ReactiveState, c as client } from "../../../../../chunks/client.svelte.js";
import { s as settings } from "../../../../../chunks/settings.svelte.js";
import { C as CommunityCard } from "../../../../../chunks/CommunityCard.js";
import { f as feed, a as feeds } from "../../../../../chunks/feed.svelte.js";
import { redirect } from "@sveltejs/kit";
function buildContext(thread) {
  let parentId;
  let showContext = false;
  let max_depth = 3;
  if (thread) {
    const split = thread.split(".");
    if (split[0] == "0") parentId = Number(thread.split(".")[1]);
    else {
      parentId = Number(thread.split(".")[0]);
      showContext = true;
      max_depth = 5;
    }
  }
  return { parentId, showContext, max_depth, focus: thread?.split(".").at(-1) };
}
async function findInFeed(id, postId) {
  if (id == "/") {
    return feeds.get(id)?.peek()?.posts.find((i) => i.post.id.toString() == postId);
  } else {
    return feeds.get(id)?.peek()?.posts.find((i) => i.post.id.toString() == postId);
  }
}
async function load({ params, url, route }) {
  if (profile.current.instance != params.instance)
    redirect(302, resolve("/post/[instance]/[id]/confirm", params));
  const sort = settings?.defaultSort?.comments ?? "Hot";
  const cachedPost = await findInFeed("/", params.id) ?? await findInFeed("/c/[name]", params.id) ?? await findInFeed("/f/[id]", params.id);
  const {
    parentId,
    showContext,
    focus,
    max_depth: passedMaxDepth
  } = buildContext(url.searchParams.get("thread") || void 0);
  const max_depth = passedMaxDepth;
  const feedData = feed(route.id, async (p) => {
    const commentPromise = client().getComments(p.comments);
    const postPromise = client().getPost(p.posts);
    const post = p.preload ?? (await postPromise).post_view;
    return {
      post,
      comments: commentPromise.then((i) => i.comments),
      meta: postPromise.then((i) => ({
        community_view: i.community_view,
        cross_posts: i.cross_posts,
        post_view: i.post_view
      })),
      thread: p.thread,
      params: p
    };
  });
  const loaded = new ReactiveState(
    await feedData.load({
      comments: {
        post_id: Number(params.id),
        type_: "All",
        max_depth,
        saved_only: false,
        sort,
        parent_id: parentId
      },
      posts: { id: Number(params.id) },
      preload: cachedPost,
      thread: {
        showContext,
        focus,
        singleThread: parentId != null
      }
    })
  );
  return {
    data: loaded,
    slots: {
      sidebar: {
        component: CommunityCard,
        props: {
          community_view: loaded.value.meta.then((i) => i.community_view)
        }
      }
    }
  };
}
export {
  load
};
//# sourceMappingURL=_page.ts.js.map
