import { s as store_get, u as unsubscribe_stores } from "../../../../../../chunks/index3.js";
import { m as communityLink, B as Button, p as profile } from "../../../../../../chunks/client.svelte.js";
import { t } from "../../../../../../chunks/index.js";
import { I as ItemList } from "../../../../../../chunks/ItemList.js";
import { P as Placeholder } from "../../../../../../chunks/Placeholder.js";
import { A as ArrowUturnUp } from "../../../../../../chunks/ArrowUturnUp.js";
import { C as Check } from "../../../../../../chunks/Check.js";
import { T as Trash } from "../../../../../../chunks/Trash.js";
import "@sveltejs/kit/internal";
import "../../../../../../chunks/exports.js";
import "../../../../../../chunks/utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { data } = $$props;
    async function unblock(id) {
      if (!data.community_blocks) return;
      data.community_blocks.splice(data.community_blocks.findIndex((i) => i.community.id == id), 1);
      await profile.client.blockCommunity({ block: false, community_id: id });
    }
    if (data.community_blocks && data.community_blocks?.length > 0) {
      $$renderer2.push("<!--[-->");
      {
        let action = function($$renderer3, block) {
          Button($$renderer3, {
            title: store_get($$store_subs ??= {}, "$t", t)("common.jump"),
            size: "square-md",
            href: block.url,
            color: "primary",
            icon: ArrowUturnUp
          });
          $$renderer3.push(`<!----> `);
          Button($$renderer3, {
            title: "Unblock",
            size: "square-md",
            onclick: () => unblock(block.id),
            icon: Trash
          });
          $$renderer3.push(`<!---->`);
        };
        ItemList($$renderer2, {
          items: data.community_blocks.map((i) => ({
            id: i.community.id,
            name: i.community.title,
            avatar: i.community.icon,
            url: communityLink(i.community),
            instance: new URL(i.community.actor_id).hostname
          })),
          link: false,
          action
        });
      }
    } else {
      $$renderer2.push("<!--[!-->");
      Placeholder($$renderer2, {
        title: store_get($$store_subs ??= {}, "$t", t)("routes.profile.blocks.empty.community.title"),
        description: store_get($$store_subs ??= {}, "$t", t)("routes.profile.blocks.empty.community.description"),
        icon: Check,
        class: "my-auto"
      });
    }
    $$renderer2.push(`<!--]-->`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
