import { s as store_get, u as unsubscribe_stores } from "../../../../../../chunks/index3.js";
import { u as userLink, B as Button, p as profile } from "../../../../../../chunks/client.svelte.js";
import { t } from "../../../../../../chunks/index.js";
import { I as ItemList } from "../../../../../../chunks/ItemList.js";
import { P as Placeholder } from "../../../../../../chunks/Placeholder.js";
import { A as ArrowUturnUp } from "../../../../../../chunks/ArrowUturnUp.js";
import { C as Check } from "../../../../../../chunks/Check.js";
import { T as Trash } from "../../../../../../chunks/Trash.js";
import "@sveltejs/kit/internal";
import "../../../../../../chunks/exports.js";
import "../../../../../../chunks/utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { data } = $$props;
    async function unblock(id) {
      if (!data.person_blocks) return;
      data.person_blocks.splice(data.person_blocks.findIndex((i) => i.person.id == id), 1);
      await profile.client.blockPerson({ block: false, person_id: id });
    }
    if (data.person_blocks && data.person_blocks?.length > 0) {
      $$renderer2.push("<!--[-->");
      {
        let action = function($$renderer3, block) {
          Button($$renderer3, {
            title: store_get($$store_subs ??= {}, "$t", t)("common.jump"),
            size: "square-md",
            href: block.url,
            color: "primary",
            icon: ArrowUturnUp
          });
          $$renderer3.push(`<!----> `);
          Button($$renderer3, {
            title: "Unblock",
            size: "square-md",
            onclick: () => unblock(block.id),
            icon: Trash
          });
          $$renderer3.push(`<!---->`);
        };
        ItemList($$renderer2, {
          items: data.person_blocks.map((i) => ({
            id: i.target.id,
            name: i.target.name,
            avatar: i.target.avatar,
            url: userLink(i.target),
            instance: new URL(i.target.actor_id).hostname,
            circle: true
          })),
          link: false,
          action
        });
      }
    } else {
      $$renderer2.push("<!--[!-->");
      Placeholder($$renderer2, {
        title: store_get($$store_subs ??= {}, "$t", t)("routes.profile.blocks.empty.user.title"),
        description: store_get($$store_subs ??= {}, "$t", t)("routes.profile.blocks.empty.user.description"),
        icon: Check,
        class: "my-auto"
      });
    }
    $$renderer2.push(`<!--]-->`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
