import { s as store_get, e as escape_html, u as unsubscribe_stores } from "../../../../../../chunks/index3.js";
import { B as Button, c as client, t as toast, g as goto, e as errorMessage, M as Material, C as ClipboardDocument } from "../../../../../../chunks/client.svelte.js";
import { p as page } from "../../../../../../chunks/index4.js";
import { t } from "../../../../../../chunks/index.js";
import { P as Placeholder } from "../../../../../../chunks/Placeholder.js";
import "headless-qr";
import { T as TextInput } from "../../../../../../chunks/TextInput.js";
import { I as Icon } from "../../../../../../chunks/Icon.js";
import { K as Key } from "../../../../../../chunks/Key.js";
import { M as Modal } from "../../../../../../chunks/Modal.js";
import "clsx";
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { data } = $$props;
    let totpLink = void 0;
    let totpEnabled = data.my_user?.local_user_view.local_user.totp_2fa_enabled;
    let verify_totp = "";
    let openModal = false;
    async function twofa(enabled, update = false) {
      try {
        if (!enabled && !update) {
          openModal = true;
          return;
        }
        if (update) {
          await client().updateTotp({ enabled, totp_token: verify_totp });
          toast({
            content: `2FA has been ${enabled ? "enabled" : "disabled"}`,
            type: "success"
          });
          goto(page.url, { invalidateAll: true });
        } else {
          const res = await client().generateTotpSecret();
          totpLink = res.totp_secret_url;
          openModal = true;
        }
      } catch (err) {
        toast({ content: errorMessage(err), type: "error" });
      }
    }
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      $$renderer3.push(`<div class="w-full flex flex-col h-full">`);
      Modal($$renderer3, {
        dismissable: false,
        title: store_get($$store_subs ??= {}, "$t", t)("form.profile.2fa.2fa"),
        get open() {
          return openModal;
        },
        set open($$value) {
          openModal = $$value;
          $$settled = false;
        },
        children: ($$renderer4) => {
          if (totpLink && !totpEnabled) {
            $$renderer4.push("<!--[-->");
            Material($$renderer4, {
              rounding: "2xl",
              color: "uniform",
              class: "",
              children: ($$renderer5) => {
                $$renderer5.push(`<svg></svg>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            {
              let suffix = function($$renderer5) {
                $$renderer5.push(`<button class="contents">`);
                Icon($$renderer5, { src: ClipboardDocument, size: "20", mini: true });
                $$renderer5.push(`<!----></button>`);
              };
              TextInput($$renderer4, {
                disabled: true,
                type: "password",
                value: totpLink,
                label: store_get($$store_subs ??= {}, "$t", t)("form.profile.2fa.totp"),
                suffix,
                children: ($$renderer5) => {
                  $$renderer5.push(`<span class="font-normal text-xs">${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.profile.2fa.paste"))}</span>`);
                },
                $$slots: { suffix: true, default: true }
              });
            }
            $$renderer4.push(`<!---->`);
          } else {
            $$renderer4.push("<!--[!-->");
          }
          $$renderer4.push(`<!--]--> <form class="flex flex-col gap-2 w-full">`);
          TextInput($$renderer4, {
            placeholder: "012345",
            label: store_get($$store_subs ??= {}, "$t", t)("form.2fa"),
            pattern: "\\d{6}",
            required: true,
            get value() {
              return verify_totp;
            },
            set value($$value) {
              verify_totp = $$value;
              $$settled = false;
            }
          });
          $$renderer4.push(`<!----> `);
          if (totpEnabled) {
            $$renderer4.push("<!--[-->");
            Button($$renderer4, {
              submit: true,
              size: "lg",
              color: "primary",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("common.disable"))}`);
              },
              $$slots: { default: true }
            });
          } else {
            $$renderer4.push("<!--[!-->");
            Button($$renderer4, {
              submit: true,
              size: "lg",
              color: "primary",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("common.enable"))}`);
              },
              $$slots: { default: true }
            });
          }
          $$renderer4.push(`<!--]--></form>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> <div class="flex flex-col items-center justify-center h-full gap-4 p-4">`);
      if (totpEnabled) {
        $$renderer3.push("<!--[-->");
        Placeholder($$renderer3, {
          iconClass: "p-3 bg-green-100 text-green-600 dark:bg-green-500/10 dark:text-green-400 rounded-full",
          icon: Key,
          title: store_get($$store_subs ??= {}, "$t", t)("form.profile.2fa.enabled"),
          children: ($$renderer4) => {
            Button($$renderer4, {
              onclick: () => twofa(false, false),
              rounding: "pill",
              color: "primary",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("common.disable"))}`);
              },
              $$slots: { default: true }
            });
          }
        });
      } else {
        $$renderer3.push("<!--[!-->");
        Placeholder($$renderer3, {
          iconClass: "p-3 bg-red-100 text-red-600 dark:bg-red-500/10 dark:text-red-400 rounded-full",
          icon: Key,
          title: store_get($$store_subs ??= {}, "$t", t)("form.profile.2fa.disabled"),
          children: ($$renderer4) => {
            Button($$renderer4, {
              onclick: () => twofa(true, false),
              rounding: "pill",
              color: "primary",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.setup"))}`);
              },
              $$slots: { default: true }
            });
          }
        });
      }
      $$renderer3.push(`<!--]--></div></div>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
