import { e as escape_html, s as store_get, d as ensure_array_like, u as unsubscribe_stores } from "../../../../../chunks/index3.js";
import { M as Material, s as site, b as Badge, o as Plus, B as Button } from "../../../../../chunks/client.svelte.js";
import { t } from "../../../../../chunks/index.js";
import { M as MarkdownEditor } from "../../../../../chunks/MarkdownEditor.js";
import { I as ImageInputUpload } from "../../../../../chunks/ImageInputUpload.js";
import { H as Header } from "../../../../../chunks/Header.js";
import "@sveltejs/kit/internal";
import "../../../../../chunks/exports.js";
import "../../../../../chunks/utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
import { L as Label } from "../../../../../chunks/Label.js";
import { T as TextInput } from "../../../../../chunks/TextInput.js";
import { I as Icon } from "../../../../../chunks/Icon.js";
import { S as Switch } from "../../../../../chunks/Switch.js";
import { M as Menu, a as MenuButton } from "../../../../../chunks/MenuButton.js";
import "../../../../../chunks/settings.svelte.js";
import "openapi-fetch";
import "@dicebear/core";
import "@dicebear/initials";
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { inline = false, data, children } = $$props;
    let formData = {
      ...data.my_user?.local_user_view?.local_user,
      ...data.my_user?.local_user_view?.person,
      discussion_languages: data.my_user?.discussion_languages
    };
    let loading = false;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      $$renderer3.push(`<form class="flex flex-col gap-4 h-full">`);
      if (!inline) {
        $$renderer3.push("<!--[-->");
        Header($$renderer3, {
          pageHeader: true,
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.profile.edit"))}`);
          }
        });
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      children?.($$renderer3);
      $$renderer3.push(`<!----> `);
      if (data.my_user?.local_user_view?.local_user && formData) {
        $$renderer3.push("<!--[-->");
        var bind_get = () => formData.bio ?? "";
        var bind_set = (v) => formData.bio = v;
        TextInput($$renderer3, {
          label: store_get($$store_subs ??= {}, "$t", t)("form.profile.email"),
          get value() {
            return formData.email;
          },
          set value($$value) {
            formData.email = $$value;
            $$settled = false;
          }
        });
        $$renderer3.push(`<!----> `);
        TextInput($$renderer3, {
          label: store_get($$store_subs ??= {}, "$t", t)("form.profile.displayName"),
          placeholder: "Optional",
          get value() {
            return formData.display_name;
          },
          set value($$value) {
            formData.display_name = $$value;
            $$settled = false;
          }
        });
        $$renderer3.push(`<!----> `);
        MarkdownEditor($$renderer3, {
          images: false,
          get value() {
            return bind_get();
          },
          set value($$value) {
            bind_set($$value);
          },
          label: store_get($$store_subs ??= {}, "$t", t)("form.profile.bio"),
          previewButton: true
        });
        $$renderer3.push(`<!----> <div class="flex gap-2 items-center *:flex-1">`);
        ImageInputUpload($$renderer3, {
          label: store_get($$store_subs ??= {}, "$t", t)("form.profile.avatar"),
          get imageUrl() {
            return formData.avatar;
          },
          set imageUrl($$value) {
            formData.avatar = $$value;
            $$settled = false;
          }
        });
        $$renderer3.push(`<!----> `);
        ImageInputUpload($$renderer3, {
          label: store_get($$store_subs ??= {}, "$t", t)("form.profile.banner"),
          get imageUrl() {
            return formData.banner;
          },
          set imageUrl($$value) {
            formData.banner = $$value;
            $$settled = false;
          }
        });
        $$renderer3.push(`<!----></div> `);
        TextInput($$renderer3, {
          label: store_get($$store_subs ??= {}, "$t", t)("form.profile.matrix"),
          placeholder: "@user:example.com",
          get value() {
            return formData.matrix_user_id;
          },
          set value($$value) {
            formData.matrix_user_id = $$value;
            $$settled = false;
          }
        });
        $$renderer3.push(`<!----> `);
        Switch($$renderer3, {
          get checked() {
            return formData.show_nsfw;
          },
          set checked($$value) {
            formData.show_nsfw = $$value;
            $$settled = false;
          },
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.profile.showNSFW"))}`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        Switch($$renderer3, {
          get checked() {
            return formData.bot_account;
          },
          set checked($$value) {
            formData.bot_account = $$value;
            $$settled = false;
          },
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.profile.bot"))}`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        Switch($$renderer3, {
          get checked() {
            return formData.show_bot_accounts;
          },
          set checked($$value) {
            formData.show_bot_accounts = $$value;
            $$settled = false;
          },
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.profile.showBots"))}`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        Switch($$renderer3, {
          get checked() {
            return formData.show_read_posts;
          },
          set checked($$value) {
            formData.show_read_posts = $$value;
            $$settled = false;
          },
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.profile.showRead"))}`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> <div class="space-y-1">`);
        Label($$renderer3, {
          id: "languages",
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.profile.languages.title"))}`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> <p>${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.profile.languages.description"))}</p> `);
        Material($$renderer3, {
          rounding: "xl",
          color: "uniform",
          class: "dark:bg-zinc-950",
          children: ($$renderer4) => {
            if (site.data && formData.discussion_languages) {
              $$renderer4.push("<!--[-->");
              $$renderer4.push(`<div class="flex gap-2 flex-wrap flex-row">`);
              {
                let target = function($$renderer5, attachment) {
                  $$renderer5.push(`<button type="button">`);
                  Badge($$renderer5, {
                    color: "blue-subtle",
                    children: ($$renderer6) => {
                      Icon($$renderer6, { src: Plus, micro: true, size: "14" });
                      $$renderer6.push(`<!----> ${escape_html(store_get($$store_subs ??= {}, "$t", t)("common.add"))}`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----></button>`);
                };
                Menu($$renderer4, {
                  class: "gap-px",
                  target,
                  children: ($$renderer5) => {
                    $$renderer5.push(`<!--[-->`);
                    const each_array = ensure_array_like(site.data.all_languages.filter((l) => !formData.discussion_languages?.includes(l.id)));
                    for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
                      let language = each_array[$$index];
                      MenuButton($$renderer5, {
                        class: "min-h-[16px] py-0",
                        onclick: () => {
                          formData.discussion_languages?.push(language.id);
                        },
                        children: ($$renderer6) => {
                          $$renderer6.push(`<!---->${escape_html(language.name)}`);
                        },
                        $$slots: { default: true }
                      });
                    }
                    $$renderer5.push(`<!--]-->`);
                  },
                  $$slots: { target: true, default: true }
                });
              }
              $$renderer4.push(`<!----> <!--[-->`);
              const each_array_1 = ensure_array_like(formData.discussion_languages);
              for (let index = 0, $$length = each_array_1.length; index < $$length; index++) {
                let languageId = each_array_1[index];
                const language = site.data.all_languages.find((l) => l.id == languageId);
                $$renderer4.push(`<button type="button" class="hover:brightness-150 transition-all">`);
                Badge($$renderer4, {
                  class: "cursor-pointer",
                  children: ($$renderer5) => {
                    $$renderer5.push(`<!---->${escape_html(language?.name)}`);
                  },
                  $$slots: { default: true }
                });
                $$renderer4.push(`<!----></button>`);
              }
              $$renderer4.push(`<!--]--></div>`);
            } else {
              $$renderer4.push("<!--[!-->");
            }
            $$renderer4.push(`<!--]-->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----></div> `);
        Button($$renderer3, {
          submit: true,
          size: "lg",
          color: "primary",
          class: "mt-auto",
          loading,
          disabled: loading,
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("common.save"))}`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></form>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
