import { h as head, s as store_get, u as unsubscribe_stores, e as escape_html } from "../../../chunks/index3.js";
import { t } from "../../../chunks/index.js";
import { T as Tabs } from "../../../chunks/Tabs.js";
import { B as Button } from "../../../chunks/client.svelte.js";
import { I as Icon } from "../../../chunks/Icon.js";
import { E as EllipsisHorizontal } from "../../../chunks/EllipsisHorizontal.js";
import { P as Photo } from "../../../chunks/Photo.js";
import "@sveltejs/kit/internal";
import "../../../chunks/exports.js";
import "../../../chunks/utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
import { M as Menu, a as MenuButton } from "../../../chunks/MenuButton.js";
import "../../../chunks/settings.svelte.js";
import "openapi-fetch";
import "@sveltejs/kit";
import "lemmy-js-client";
import "@dicebear/core";
import "@dicebear/initials";
const ArrowDown = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M8 2a.75.75 0 0 1 .75.75v8.69l3.22-3.22a.75.75 0 1 1 1.06 1.06l-4.5 4.5a.75.75 0 0 1-1.06 0l-4.5-4.5a.75.75 0 0 1 1.06-1.06l3.22 3.22V2.75A.75.75 0 0 1 8 2Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M10 3a.75.75 0 0 1 .75.75v10.638l3.96-4.158a.75.75 0 1 1 1.08 1.04l-5.25 5.5a.75.75 0 0 1-1.08 0l-5.25-5.5a.75.75 0 1 1 1.08-1.04l3.96 4.158V3.75A.75.75 0 0 1 10 3Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "M19.5 13.5 12 21m0 0-7.5-7.5M12 21V3"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M12 2.25a.75.75 0 0 1 .75.75v16.19l6.22-6.22a.75.75 0 1 1 1.06 1.06l-7.5 7.5a.75.75 0 0 1-1.06 0l-7.5-7.5a.75.75 0 1 1 1.06-1.06l6.22 6.22V3a.75.75 0 0 1 .75-.75Z",
        "clip-rule": "evenodd"
      }
    ]
  }
};
const ArrowUp = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M8 14a.75.75 0 0 1-.75-.75V4.56L4.03 7.78a.75.75 0 0 1-1.06-1.06l4.5-4.5a.75.75 0 0 1 1.06 0l4.5 4.5a.75.75 0 0 1-1.06 1.06L8.75 4.56v8.69A.75.75 0 0 1 8 14Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M10 17a.75.75 0 0 1-.75-.75V5.612L5.29 9.77a.75.75 0 0 1-1.08-1.04l5.25-5.5a.75.75 0 0 1 1.08 0l5.25 5.5a.75.75 0 1 1-1.08 1.04l-3.96-4.158V16.25A.75.75 0 0 1 10 17Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "M4.5 10.5 12 3m0 0 7.5 7.5M12 3v18"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M11.47 2.47a.75.75 0 0 1 1.06 0l7.5 7.5a.75.75 0 1 1-1.06 1.06l-6.22-6.22V21a.75.75 0 0 1-1.5 0V4.81l-6.22 6.22a.75.75 0 1 1-1.06-1.06l7.5-7.5Z",
        "clip-rule": "evenodd"
      }
    ]
  }
};
function _layout($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { children } = $$props;
    head($$renderer2, ($$renderer3) => {
      $$renderer3.title(($$renderer4) => {
        $$renderer4.push(`<title>${escape_html(store_get($$store_subs ??= {}, "$t", t)("profile.profile"))}</title>`);
      });
    });
    $$renderer2.push(`<div class="flex flex-row justify-between">`);
    Tabs($$renderer2, {
      routes: [
        {
          href: "/profile/user",
          name: store_get($$store_subs ??= {}, "$t", t)("routes.profile.submissions")
        },
        {
          href: "/profile/settings",
          name: store_get($$store_subs ??= {}, "$t", t)("routes.profile.edit")
        },
        {
          href: "/profile/blocks",
          name: store_get($$store_subs ??= {}, "$t", t)("routes.profile.blocks.title")
        },
        {
          href: "/profile/password",
          name: store_get($$store_subs ??= {}, "$t", t)("routes.profile.credentials")
        }
      ],
      children: ($$renderer3) => {
        {
          let target = function($$renderer4, attachment) {
            Button($$renderer4, {
              "aria-label": store_get($$store_subs ??= {}, "$t", t)("post.actions.more.label"),
              size: "square-sm",
              color: "none",
              class: "z-0 text-slate-600 dark:text-zinc-500 hover:bg-slate-100 hover:dark:bg-zinc-800",
              children: ($$renderer5) => {
                Icon($$renderer5, { src: EllipsisHorizontal, size: "16", micro: true });
              },
              $$slots: { default: true }
            });
          };
          Menu($$renderer3, {
            class: "flex-1",
            placement: "bottom-end",
            target,
            children: ($$renderer4) => {
              MenuButton($$renderer4, {
                href: "/profile/media",
                icon: Photo,
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.profile.media.title"))}`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              MenuButton($$renderer4, {
                href: "/profile/voted/up",
                icon: ArrowUp,
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.profile.upvoted"))}`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              MenuButton($$renderer4, {
                href: "/profile/voted/down",
                icon: ArrowDown,
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.profile.downvoted"))}`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!---->`);
            },
            $$slots: { target: true, default: true }
          });
        }
      }
    });
    $$renderer2.push(`<!----></div> `);
    children?.($$renderer2);
    $$renderer2.push(`<!---->`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _layout as default
};
//# sourceMappingURL=_layout.svelte.js.map
