import { e as escape_html } from "../../../../chunks/index3.js";
import "clsx";
import { R as ReactiveState } from "../../../../chunks/client.svelte.js";
import _page$1 from "../../u/_name_/_page.svelte.js";
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let { data } = $$props;
    if (data.user && data.sort && data.type && data.page) {
      $$renderer2.push("<!--[-->");
      _page$1($$renderer2, {
        data: {
          items: new ReactiveState(data.user.submissions),
          filters: new ReactiveState({
            page: data.page,
            sort: data.sort,
            type: data.type,
            limit: data.limit
          }),
          person_view: { value: data.user.person_view },
          moderates: { value: data.user.moderates }
        }
      });
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`User data is missing. <pre>
    ${escape_html(JSON.stringify(data))}
  </pre>`);
    }
    $$renderer2.push(`<!--]-->`);
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
