import { h as head, e as escape_html, s as store_get, u as unsubscribe_stores } from "../../../chunks/index3.js";
import { p as page } from "../../../chunks/index4.js";
import { t } from "../../../chunks/index.js";
import { j as searchParam } from "../../../chunks/client.svelte.js";
import { C as CommentItem } from "../../../chunks/CommentItem.js";
import "../../../chunks/settings.svelte.js";
import "@sveltejs/kit";
import "lemmy-js-client";
import "openapi-fetch";
import { I as Icon } from "../../../chunks/Icon.js";
import { A as AdjustmentsHorizontal } from "../../../chunks/AdjustmentsHorizontal.js";
import { B as Bars3 } from "../../../chunks/Bars3.js";
import { B as Bookmark } from "../../../chunks/Bookmark.js";
import { C as ChatBubbleOvalLeft } from "../../../chunks/ChatBubbleOvalLeft.js";
import { P as PencilSquare } from "../../../chunks/PencilSquare.js";
import { S as Select, O as Option } from "../../../chunks/Select.js";
import "@sveltejs/kit/internal";
import "../../../chunks/exports.js";
import "../../../chunks/utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
import "@dicebear/core";
import "@dicebear/initials";
import { P as PostItem } from "../../../chunks/PostItem.js";
import { H as Header } from "../../../chunks/Header.js";
import { C as CommonList } from "../../../chunks/CommonList.js";
import { P as Pageination } from "../../../chunks/Pageination.js";
import { P as Placeholder } from "../../../chunks/Placeholder.js";
import { F as Fixate } from "../../../chunks/Fixate.js";
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { data } = $$props;
    let type = data.type;
    const isComment = (item) => "comment" in item;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      head($$renderer3, ($$renderer4) => {
        $$renderer4.title(($$renderer5) => {
          $$renderer5.push(`<title>${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.saved"))}</title>`);
        });
      });
      {
        let extended = function($$renderer4) {
          $$renderer4.push(`<div class="flex items-center">`);
          {
            let customLabel = function($$renderer5) {
              $$renderer5.push(`<div class="flex items-center gap-0.5">`);
              Icon($$renderer5, { src: AdjustmentsHorizontal, size: "15", mini: true });
              $$renderer5.push(`<!----> ${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.filter"))}</div>`);
            };
            Select($$renderer4, {
              onchange: () => searchParam(page.url, "type", type, "page"),
              get value() {
                return type;
              },
              set value($$value) {
                type = $$value;
                $$settled = false;
              },
              customLabel,
              children: ($$renderer5) => {
                Option($$renderer5, {
                  icon: Bars3,
                  value: "all",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("content.all"))}`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                Option($$renderer5, {
                  icon: PencilSquare,
                  value: "posts",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("content.posts"))}`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                Option($$renderer5, {
                  icon: ChatBubbleOvalLeft,
                  value: "comments",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("content.comments"))}`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!---->`);
              },
              $$slots: { customLabel: true, default: true }
            });
          }
          $$renderer4.push(`<!----></div>`);
        };
        Header($$renderer3, {
          pageHeader: true,
          extended,
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.saved"))}`);
          }
        });
      }
      $$renderer3.push(`<!----> `);
      if (!data.data || (data.data?.length ?? 0) == 0) {
        $$renderer3.push("<!--[-->");
        Placeholder($$renderer3, {
          icon: Bookmark,
          title: "No saved items",
          description: "Save posts or comments, and they'll be here to refer to them later.",
          class: "my-auto"
        });
      } else {
        $$renderer3.push("<!--[!-->");
        {
          let item = function($$renderer4, item2) {
            if (isComment(item2)) {
              $$renderer4.push("<!--[-->");
              CommentItem($$renderer4, { comment: item2 });
            } else {
              $$renderer4.push("<!--[!-->");
              PostItem($$renderer4, { post: item2 });
            }
            $$renderer4.push(`<!--]-->`);
          };
          CommonList($$renderer3, { items: data.data, size: "lg", item });
        }
      }
      $$renderer3.push(`<!--]--> `);
      Fixate($$renderer3, {
        placement: "bottom",
        children: ($$renderer4) => {
          Pageination($$renderer4, {
            hasMore: data.data.length == 40,
            href: (page2) => `?page=${page2}`,
            page: data.page
          });
        }
      });
      $$renderer3.push(`<!---->`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
