import { h as head, e as escape_html, s as store_get, d as ensure_array_like, j as attr_style, g as await_block, u as unsubscribe_stores, k as stringify } from "../../../chunks/index3.js";
import { n as navigating, p as page } from "../../../chunks/index4.js";
import { c as client, B as Button, j as searchParam, Q as isPostView, w as isCommentView, X as isCommunityView, Y as isUser } from "../../../chunks/client.svelte.js";
import { t } from "../../../chunks/index.js";
import { C as CommentItem } from "../../../chunks/CommentItem.js";
import { C as CommunityItem } from "../../../chunks/CommunityItem.js";
import { S as Sort } from "../../../chunks/Sort.js";
import "../../../chunks/settings.svelte.js";
import "@dicebear/core";
import "@dicebear/initials";
import { T as TextLoader } from "../../../chunks/TextLoader.js";
import { I as Icon } from "../../../chunks/Icon.js";
import { A as AdjustmentsHorizontal } from "../../../chunks/AdjustmentsHorizontal.js";
import { G as GlobeAmericas } from "../../../chunks/GlobeAmericas.js";
import { M as MagnifyingGlass } from "../../../chunks/MagnifyingGlass.js";
import { S as Select, O as Option } from "../../../chunks/Select.js";
import "@sveltejs/kit/internal";
import "../../../chunks/exports.js";
import "../../../chunks/utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
import { P as PostItem } from "../../../chunks/PostItem.js";
import "openapi-fetch";
import { H as Header } from "../../../chunks/Header.js";
import { C as CommonList } from "../../../chunks/CommonList.js";
import { S as SearchBar } from "../../../chunks/SearchBar.js";
import { P as Pageination } from "../../../chunks/Pageination.js";
import { P as Placeholder } from "../../../chunks/Placeholder.js";
import { U as UserItem } from "../../../chunks/UserItem.js";
import { O as ObjectAutocomplete } from "../../../chunks/ObjectAutocomplete.js";
import { S as Skeleton } from "../../../chunks/Skeleton.js";
const ChevronDoubleDown = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M7.47 12.78a.75.75 0 0 0 1.06 0l3.25-3.25a.75.75 0 0 0-1.06-1.06L8 11.19 5.28 8.47a.75.75 0 0 0-1.06 1.06l3.25 3.25ZM4.22 4.53l3.25 3.25a.75.75 0 0 0 1.06 0l3.25-3.25a.75.75 0 0 0-1.06-1.06L8 6.19 5.28 3.47a.75.75 0 0 0-1.06 1.06Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M9.47 15.28a.75.75 0 0 0 1.06 0l4.25-4.25a.75.75 0 1 0-1.06-1.06L10 13.69 6.28 9.97a.75.75 0 0 0-1.06 1.06l4.25 4.25ZM5.22 6.03l4.25 4.25a.75.75 0 0 0 1.06 0l4.25-4.25a.75.75 0 0 0-1.06-1.06L10 8.69 6.28 4.97a.75.75 0 0 0-1.06 1.06Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "m4.5 5.25 7.5 7.5 7.5-7.5m-15 6 7.5 7.5 7.5-7.5"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M11.47 13.28a.75.75 0 0 0 1.06 0l7.5-7.5a.75.75 0 0 0-1.06-1.06L12 11.69 5.03 4.72a.75.75 0 0 0-1.06 1.06l7.5 7.5Z",
        "clip-rule": "evenodd"
      },
      {
        "fill-rule": "evenodd",
        "d": "M11.47 19.28a.75.75 0 0 0 1.06 0l7.5-7.5a.75.75 0 1 0-1.06-1.06L12 17.69l-6.97-6.97a.75.75 0 0 0-1.06 1.06l7.5 7.5Z",
        "clip-rule": "evenodd"
      }
    ]
  }
};
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { data } = $$props;
    let form = void 0;
    let moreOptions = false;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      head($$renderer3, ($$renderer4) => {
        $$renderer4.title(($$renderer5) => {
          $$renderer5.push(`<title>${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.search.title"))}</title>`);
        });
      });
      {
        let extended = function($$renderer4) {
          const clientType = client().type.name;
          $$renderer4.push(`<form method="get" action="/search" class="contents">`);
          SearchBar($$renderer4, {
            get query() {
              return data.filters.value.query;
            },
            set query($$value) {
              data.filters.value.query = $$value;
              $$settled = false;
            }
          });
          $$renderer4.push(`<!----> <div class="flex flex-row flex-wrap items-center gap-4">`);
          {
            let customLabel = function($$renderer5) {
              $$renderer5.push(`<span class="flex items-center gap-1">`);
              Icon($$renderer5, { src: AdjustmentsHorizontal, mini: true, size: "15" });
              $$renderer5.push(`<!----> ${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.type"))}</span>`);
            };
            Select($$renderer4, {
              name: "type",
              onchange: () => form?.requestSubmit(),
              get value() {
                return data.filters.value.type;
              },
              set value($$value) {
                data.filters.value.type = $$value;
                $$settled = false;
              },
              customLabel,
              children: ($$renderer5) => {
                if (clientType == "lemmy") {
                  $$renderer5.push("<!--[-->");
                  Option($$renderer5, {
                    value: "All",
                    children: ($$renderer6) => {
                      $$renderer6.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("content.all"))}`);
                    },
                    $$slots: { default: true }
                  });
                } else {
                  $$renderer5.push("<!--[!-->");
                }
                $$renderer5.push(`<!--]--> `);
                Option($$renderer5, {
                  value: "Posts",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("content.posts"))}`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                if (clientType == "lemmy") {
                  $$renderer5.push("<!--[-->");
                  Option($$renderer5, {
                    value: "Comments",
                    children: ($$renderer6) => {
                      $$renderer6.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("content.comments"))}`);
                    },
                    $$slots: { default: true }
                  });
                } else {
                  $$renderer5.push("<!--[!-->");
                }
                $$renderer5.push(`<!--]--> `);
                Option($$renderer5, {
                  value: "Communities",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("content.communities"))}`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                Option($$renderer5, {
                  value: "Users",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("content.users"))}`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                Option($$renderer5, {
                  value: "Url",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("content.url"))}`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!---->`);
              },
              $$slots: { customLabel: true, default: true }
            });
          }
          $$renderer4.push(`<!----> `);
          Sort($$renderer4, {
            name: "sort",
            onchange: () => form?.requestSubmit(),
            get selected() {
              return data.filters.value.sort;
            },
            set selected($$value) {
              data.filters.value.sort = $$value;
              $$settled = false;
            }
          });
          $$renderer4.push(`<!----> `);
          Button($$renderer4, {
            size: "custom",
            rounding: "xl",
            class: "self-end justify-self-center h-8.5 w-8.5",
            onclick: () => moreOptions = !moreOptions,
            "aria-label": store_get($$store_subs ??= {}, "$t", t)("post.actions.more.label"),
            children: ($$renderer5) => {
              Icon($$renderer5, { src: ChevronDoubleDown, size: "20", mini: true });
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!----></div></form>`);
        };
        Header($$renderer3, {
          pageHeader: true,
          extended,
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.search.title"))}`);
          }
        });
      }
      $$renderer3.push(`<!----> `);
      if (moreOptions) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="flex flex-row gap-2 flex-wrap">`);
        ObjectAutocomplete($$renderer3, {
          label: store_get($$store_subs ??= {}, "$t", t)("nav.create.community"),
          listing_type: "All",
          showWhenEmpty: true,
          onselect: (c) => searchParam(page.url, "community", c?.id || void 0, "page")
        });
        $$renderer3.push(`<!----></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      if (!data.results) {
        $$renderer3.push("<!--[-->");
        if (navigating.to?.route.id == "/search") {
          $$renderer3.push("<!--[-->");
          $$renderer3.push(`<div class="flex flex-col gap-3 mt-6"><!--[-->`);
          const each_array = ensure_array_like(new Array(5));
          for (let index = 0, $$length = each_array.length; index < $$length; index++) {
            let _ = each_array[index];
            $$renderer3.push(`<!---->${escape_html(_)} <div${attr_style(`width: ${stringify(1 / ((index + 1) % 3) * 100)}%`)}>`);
            Skeleton($$renderer3);
            $$renderer3.push(`<!----></div>`);
          }
          $$renderer3.push(`<!--]--></div>`);
        } else {
          $$renderer3.push("<!--[!-->");
          $$renderer3.push(`<div class="my-auto">`);
          Placeholder($$renderer3, {
            icon: data.results ? MagnifyingGlass : GlobeAmericas,
            title: store_get($$store_subs ??= {}, "$t", t)("routes.search.noResults.title"),
            description: data.results ? store_get($$store_subs ??= {}, "$t", t)("routes.search.noResults.description") : store_get($$store_subs ??= {}, "$t", t)("routes.search.noResults.alt")
          });
          $$renderer3.push(`<!----></div>`);
        }
        $$renderer3.push(`<!--]-->`);
      } else {
        $$renderer3.push("<!--[!-->");
        await_block(
          $$renderer3,
          data.streamed.object,
          () => {
            $$renderer3.push(`<div class="flex gap-2 items-center my-4">`);
            TextLoader($$renderer3, {
              children: ($$renderer4) => {
                $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.search.federating"))}`);
              }
            });
            $$renderer3.push(`<!----></div>`);
          },
          (object) => {
            if (object) {
              $$renderer3.push("<!--[-->");
              $$renderer3.push(`<div class="divide-y divide-slate-200 dark:divide-zinc-900 my-4">`);
              if (object.community) {
                $$renderer3.push("<!--[-->");
                CommunityItem($$renderer3, { community: object.community, showCounts: false });
              } else {
                $$renderer3.push("<!--[!-->");
              }
              $$renderer3.push(`<!--]--> `);
              if (object.post) {
                $$renderer3.push("<!--[-->");
                PostItem($$renderer3, { post: object.post });
              } else {
                $$renderer3.push("<!--[!-->");
              }
              $$renderer3.push(`<!--]--> `);
              if (object.comment) {
                $$renderer3.push("<!--[-->");
                CommentItem($$renderer3, { comment: object.comment });
              } else {
                $$renderer3.push("<!--[!-->");
              }
              $$renderer3.push(`<!--]--> `);
              if (object.person) {
                $$renderer3.push("<!--[-->");
                UserItem($$renderer3, { user: object.person });
              } else {
                $$renderer3.push("<!--[!-->");
              }
              $$renderer3.push(`<!--]--></div>`);
            } else {
              $$renderer3.push("<!--[!-->");
            }
            $$renderer3.push(`<!--]-->`);
          }
        );
        $$renderer3.push(`<!--]--> `);
        {
          let item = function($$renderer4, result) {
            if (isPostView(result)) {
              $$renderer4.push("<!--[-->");
              PostItem($$renderer4, { post: result });
            } else {
              $$renderer4.push("<!--[!-->");
              if (isCommentView(result)) {
                $$renderer4.push("<!--[-->");
                CommentItem($$renderer4, { comment: result });
              } else {
                $$renderer4.push("<!--[!-->");
                if (isCommunityView(result)) {
                  $$renderer4.push("<!--[-->");
                  CommunityItem($$renderer4, { community: result, showCounts: false });
                } else {
                  $$renderer4.push("<!--[!-->");
                  if (isUser(result)) {
                    $$renderer4.push("<!--[-->");
                    UserItem($$renderer4, { user: result, showCounts: false });
                  } else {
                    $$renderer4.push("<!--[!-->");
                  }
                  $$renderer4.push(`<!--]-->`);
                }
                $$renderer4.push(`<!--]-->`);
              }
              $$renderer4.push(`<!--]-->`);
            }
            $$renderer4.push(`<!--]-->`);
          };
          CommonList($$renderer3, { items: data.results.value, item });
        }
        $$renderer3.push(`<!----> <div class="mt-4"></div> `);
        if (data.results.value.length > 0) {
          $$renderer3.push("<!--[-->");
          Pageination($$renderer3, {
            href: (page2) => `?page=${page2}`,
            get page() {
              return data.filters.value.page;
            },
            set page($$value) {
              data.filters.value.page = $$value;
              $$settled = false;
            }
          });
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]-->`);
      }
      $$renderer3.push(`<!--]-->`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
