import { p as profile, P as PiefedClient, c as client, v as getItemPublished, a as getClient, R as ReactiveState } from "../../../chunks/client.svelte.js";
async function load({ url, fetch }) {
  const query = url.searchParams.get("q");
  const page = Number(url.searchParams.get("page")) || 1;
  const community = Number(url.searchParams.get("community")) || void 0;
  const sort = url.searchParams.get("sort") || "New";
  const type = url.searchParams.get("type") || (profile.client instanceof PiefedClient ? "Posts" : "All");
  const listing_type = url.searchParams.get("listing_type") || "All";
  if (query) {
    const results = await client({ func: fetch }).search({
      q: query,
      community_id: community ?? void 0,
      limit: 20,
      page,
      sort,
      listing_type,
      type_: type
    });
    const [posts, comments, users, communities] = [
      results.posts,
      results.comments,
      results.users,
      results.communities
    ];
    const everything = [...posts, ...comments, ...users, ...communities];
    if (sort == "New") {
      everything.sort(
        (a, b) => new Date(getItemPublished(b)).getTime() - new Date(getItemPublished(a)).getTime()
      );
    }
    return {
      filters: new ReactiveState({
        type,
        sort,
        page,
        query
      }),
      results: new ReactiveState(everything),
      streamed: {
        object: profile.current?.jwt ? getClient(void 0, fetch).resolveObject({
          q: query
        }) : void 0
      }
    };
  }
  return {
    filters: new ReactiveState({
      page: 1,
      sort,
      type,
      query
    })
  };
}
export {
  load
};
//# sourceMappingURL=_page.ts.js.map
