import { h as head, e as escape_html, s as store_get, u as unsubscribe_stores } from "../../../chunks/index3.js";
import { t } from "../../../chunks/index.js";
import { s as settings, d as defaultSettings } from "../../../chunks/settings.svelte.js";
import { H as Header } from "../../../chunks/Header.js";
import { T as Tabs } from "../../../chunks/Tabs.js";
import { B as Button, A as ArrowDownTray, t as toast } from "../../../chunks/client.svelte.js";
import { A as ArrowPath } from "../../../chunks/ArrowPath.js";
import { A as ArrowUpTray } from "../../../chunks/ArrowUpTray.js";
import { T as TextArea } from "../../../chunks/TextArea.js";
import { M as Modal } from "../../../chunks/Modal.js";
import { m as modal, a as action } from "../../../chunks/modal2.js";
import "clsx";
import "@sveltejs/kit/internal";
import "../../../chunks/exports.js";
import "../../../chunks/utils.js";
import "@sveltejs/kit/internal/server";
import "openapi-fetch";
import "@sveltejs/kit";
import "lemmy-js-client";
import "@dicebear/core";
import "@dicebear/initials";
function _layout($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { children } = $$props;
    let importing = false;
    let importText = "";
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      head($$renderer3, ($$renderer4) => {
        $$renderer4.title(($$renderer5) => {
          $$renderer5.push(`<title>${escape_html(store_get($$store_subs ??= {}, "$t", t)("settings.title"))}</title>`);
        });
      });
      if (importing) {
        $$renderer3.push("<!--[-->");
        Modal($$renderer3, {
          onaction: () => {
            try {
              if (importText == "") {
                throw new Error("import failed");
              }
              const parsed = JSON.parse(importText);
              const merged = { ...defaultSettings, ...parsed };
              Object.assign(settings, merged);
              toast({
                content: store_get($$store_subs ??= {}, "$t", t)("toast.settingsImport"),
                type: "success"
              });
              importing = false;
            } catch (err) {
              toast({ content: err, type: "error" });
            }
          },
          title: store_get($$store_subs ??= {}, "$t", t)("settings.import"),
          action: store_get($$store_subs ??= {}, "$t", t)("settings.import"),
          get open() {
            return importing;
          },
          set open($$value) {
            importing = $$value;
            $$settled = false;
          },
          children: ($$renderer4) => {
            TextArea($$renderer4, {
              style: "font-family: monospace;",
              get value() {
                return importText;
              },
              set value($$value) {
                importText = $$value;
                $$settled = false;
              }
            });
          },
          $$slots: { default: true }
        });
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      Tabs($$renderer3, {
        routes: [
          {
            href: "/settings/app",
            name: store_get($$store_subs ??= {}, "$t", t)("settings.app.title")
          },
          {
            href: "/settings/lemmy",
            name: store_get($$store_subs ??= {}, "$t", t)("settings.lemmy.title")
          },
          {
            href: "/settings/embeds",
            name: store_get($$store_subs ??= {}, "$t", t)("settings.embeds.title")
          },
          {
            href: "/settings/moderation",
            name: store_get($$store_subs ??= {}, "$t", t)("settings.moderation.title")
          },
          {
            href: "/settings/other",
            name: store_get($$store_subs ??= {}, "$t", t)("settings.other.title")
          }
        ]
      });
      $$renderer3.push(`<!----> `);
      {
        let extended = function($$renderer4) {
          $$renderer4.push(`<div class="flex items-center tracking-normal gap-2">`);
          Button($$renderer4, {
            onclick: () => {
              importText = "";
              importing = true;
            },
            icon: ArrowDownTray,
            size: "lg",
            children: ($$renderer5) => {
              $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("settings.import"))}`);
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!----> `);
          Button($$renderer4, {
            onclick: () => {
              const json = JSON.stringify(settings);
              navigator?.clipboard?.writeText?.(json);
              toast({
                content: store_get($$store_subs ??= {}, "$t", t)("toast.copied")
              });
            },
            icon: ArrowUpTray,
            size: "lg",
            children: ($$renderer5) => {
              $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("settings.export"))}`);
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!----> `);
          Button($$renderer4, {
            onclick: () => {
              modal({
                title: store_get($$store_subs ??= {}, "$t", t)("settings.reset"),
                body: store_get($$store_subs ??= {}, "$t", t)("toast.resetSettings"),
                actions: [
                  action({
                    action: () => Object.assign(settings, defaultSettings),
                    close: true,
                    type: "danger",
                    content: store_get($$store_subs ??= {}, "$t", t)("settings.reset")
                  }),
                  action({
                    content: store_get($$store_subs ??= {}, "$t", t)("common.cancel")
                  })
                ]
              });
            },
            icon: ArrowPath,
            size: "lg",
            children: ($$renderer5) => {
              $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("settings.reset"))}`);
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!----></div>`);
        };
        Header($$renderer3, {
          pageHeader: true,
          class: "text-3xl font-bold flex justify-between",
          extended,
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("settings.title"))}`);
          }
        });
      }
      $$renderer3.push(`<!----> `);
      children?.($$renderer3);
      $$renderer3.push(`<!---->`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _layout as default
};
//# sourceMappingURL=_layout.svelte.js.map
