import { e as escape_html, s as store_get, d as ensure_array_like, u as unsubscribe_stores } from "../../../../chunks/index3.js";
import { p as public_env } from "../../../../chunks/shared-server.js";
import { t, c as locale } from "../../../../chunks/index.js";
import { s as settings } from "../../../../chunks/settings.svelte.js";
import { C as ChartBar, S as Sort } from "../../../../chunks/Sort.js";
import { V as ViewSelect } from "../../../../chunks/ViewSelect.js";
import { L as Link } from "../../../../chunks/Link2.js";
import { S as Switch } from "../../../../chunks/Switch2.js";
import "@sveltejs/kit/internal";
import "../../../../chunks/exports.js";
import "../../../../chunks/utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
import { B as Button, a6 as Language } from "../../../../chunks/client.svelte.js";
import { C as CommonList } from "../../../../chunks/CommonList.js";
import { I as Icon } from "../../../../chunks/Icon.js";
import { A as ArrowTopRightOnSquare, D as DocumentText } from "../../../../chunks/DocumentText.js";
import { T as Trophy, S as Star, A as ArrowTrendingDown } from "../../../../chunks/Trophy.js";
import { A as ArrowsUpDown } from "../../../../chunks/ArrowsUpDown.js";
import { C as Clock, a as Calendar } from "../../../../chunks/Clock.js";
import { C as ChatBubbleOvalLeftEllipsis } from "../../../../chunks/ChatBubbleOvalLeftEllipsis.js";
import { C as CubeTransparent } from "../../../../chunks/CubeTransparent.js";
import { F as Fire } from "../../../../chunks/Fire.js";
import { G as GlobeAmericas } from "../../../../chunks/GlobeAmericas.js";
import { P as Photo } from "../../../../chunks/Photo.js";
import { T as Tag } from "../../../../chunks/Tag.js";
import { V as ViewColumns } from "../../../../chunks/ViewColumns.js";
import { S as Select, O as Option } from "../../../../chunks/Select.js";
import "openapi-fetch";
import "@sveltejs/kit";
import "lemmy-js-client";
import "@dicebear/core";
import "@dicebear/initials";
import { S as Setting } from "../../../../chunks/Setting.js";
import { T as ToggleSetting } from "../../../../chunks/ToggleSetting.js";
const ArrowsPointingOut = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M2.75 9a.75.75 0 0 1 .75.75v1.69l2.22-2.22a.75.75 0 0 1 1.06 1.06L4.56 12.5h1.69a.75.75 0 0 1 0 1.5h-3.5a.75.75 0 0 1-.75-.75v-3.5A.75.75 0 0 1 2.75 9ZM2.75 7a.75.75 0 0 0 .75-.75V4.56l2.22 2.22a.75.75 0 0 0 1.06-1.06L4.56 3.5h1.69a.75.75 0 0 0 0-1.5h-3.5a.75.75 0 0 0-.75.75v3.5c0 .414.336.75.75.75ZM13.25 9a.75.75 0 0 0-.75.75v1.69l-2.22-2.22a.75.75 0 1 0-1.06 1.06l2.22 2.22H9.75a.75.75 0 0 0 0 1.5h3.5a.75.75 0 0 0 .75-.75v-3.5a.75.75 0 0 0-.75-.75ZM13.25 7a.75.75 0 0 1-.75-.75V4.56l-2.22 2.22a.75.75 0 1 1-1.06-1.06l2.22-2.22H9.75a.75.75 0 0 1 0-1.5h3.5a.75.75 0 0 1 .75.75v3.5a.75.75 0 0 1-.75.75Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "m13.28 7.78 3.22-3.22v2.69a.75.75 0 0 0 1.5 0v-4.5a.75.75 0 0 0-.75-.75h-4.5a.75.75 0 0 0 0 1.5h2.69l-3.22 3.22a.75.75 0 0 0 1.06 1.06ZM2 17.25v-4.5a.75.75 0 0 1 1.5 0v2.69l3.22-3.22a.75.75 0 0 1 1.06 1.06L4.56 16.5h2.69a.75.75 0 0 1 0 1.5h-4.5a.747.747 0 0 1-.75-.75ZM12.22 13.28l3.22 3.22h-2.69a.75.75 0 0 0 0 1.5h4.5a.747.747 0 0 0 .75-.75v-4.5a.75.75 0 0 0-1.5 0v2.69l-3.22-3.22a.75.75 0 1 0-1.06 1.06ZM3.5 4.56l3.22 3.22a.75.75 0 0 0 1.06-1.06L4.56 3.5h2.69a.75.75 0 0 0 0-1.5h-4.5a.75.75 0 0 0-.75.75v4.5a.75.75 0 0 0 1.5 0V4.56Z"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "M3.75 3.75v4.5m0-4.5h4.5m-4.5 0L9 9M3.75 20.25v-4.5m0 4.5h4.5m-4.5 0L9 15M20.25 3.75h-4.5m4.5 0v4.5m0-4.5L15 9m5.25 11.25h-4.5m4.5 0v-4.5m0 4.5L15 15"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M15 3.75a.75.75 0 0 1 .75-.75h4.5a.75.75 0 0 1 .75.75v4.5a.75.75 0 0 1-1.5 0V5.56l-3.97 3.97a.75.75 0 1 1-1.06-1.06l3.97-3.97h-2.69a.75.75 0 0 1-.75-.75Zm-12 0A.75.75 0 0 1 3.75 3h4.5a.75.75 0 0 1 0 1.5H5.56l3.97 3.97a.75.75 0 0 1-1.06 1.06L4.5 5.56v2.69a.75.75 0 0 1-1.5 0v-4.5Zm11.47 11.78a.75.75 0 1 1 1.06-1.06l3.97 3.97v-2.69a.75.75 0 0 1 1.5 0v4.5a.75.75 0 0 1-.75.75h-4.5a.75.75 0 0 1 0-1.5h2.69l-3.97-3.97Zm-4.94-1.06a.75.75 0 0 1 0 1.06L5.56 19.5h2.69a.75.75 0 0 1 0 1.5h-4.5a.75.75 0 0 1-.75-.75v-4.5a.75.75 0 0 1 1.5 0v2.69l3.97-3.97a.75.75 0 0 1 1.06 0Z",
        "clip-rule": "evenodd"
      }
    ]
  }
};
const ArrowsRightLeft = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M10.47 2.22a.75.75 0 0 1 1.06 0l2.25 2.25a.75.75 0 0 1 0 1.06l-2.25 2.25a.75.75 0 1 1-1.06-1.06l.97-.97H5.75a.75.75 0 0 1 0-1.5h5.69l-.97-.97a.75.75 0 0 1 0-1.06Zm-4.94 6a.75.75 0 0 1 0 1.06l-.97.97h5.69a.75.75 0 0 1 0 1.5H4.56l.97.97a.75.75 0 1 1-1.06 1.06l-2.25-2.25a.75.75 0 0 1 0-1.06l2.25-2.25a.75.75 0 0 1 1.06 0Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M13.2 2.24a.75.75 0 0 0 .04 1.06l2.1 1.95H6.75a.75.75 0 0 0 0 1.5h8.59l-2.1 1.95a.75.75 0 1 0 1.02 1.1l3.5-3.25a.75.75 0 0 0 0-1.1l-3.5-3.25a.75.75 0 0 0-1.06.04Zm-6.4 8a.75.75 0 0 0-1.06-.04l-3.5 3.25a.75.75 0 0 0 0 1.1l3.5 3.25a.75.75 0 1 0 1.02-1.1l-2.1-1.95h8.59a.75.75 0 0 0 0-1.5H4.66l2.1-1.95a.75.75 0 0 0 .04-1.06Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "M7.5 21 3 16.5m0 0L7.5 12M3 16.5h13.5m0-13.5L21 7.5m0 0L16.5 12M21 7.5H7.5"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M15.97 2.47a.75.75 0 0 1 1.06 0l4.5 4.5a.75.75 0 0 1 0 1.06l-4.5 4.5a.75.75 0 1 1-1.06-1.06l3.22-3.22H7.5a.75.75 0 0 1 0-1.5h11.69l-3.22-3.22a.75.75 0 0 1 0-1.06Zm-7.94 9a.75.75 0 0 1 0 1.06l-3.22 3.22H16.5a.75.75 0 0 1 0 1.5H4.81l3.22 3.22a.75.75 0 1 1-1.06 1.06l-4.5-4.5a.75.75 0 0 1 0-1.06l4.5-4.5a.75.75 0 0 1 1.06 0Z",
        "clip-rule": "evenodd"
      }
    ]
  }
};
const Bars2 = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M2 4.75A.75.75 0 0 1 2.75 4h10.5a.75.75 0 0 1 0 1.5H2.75A.75.75 0 0 1 2 4.75Zm0 6.5a.75.75 0 0 1 .75-.75h10.5a.75.75 0 0 1 0 1.5H2.75a.75.75 0 0 1-.75-.75Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M2 6.75A.75.75 0 0 1 2.75 6h14.5a.75.75 0 0 1 0 1.5H2.75A.75.75 0 0 1 2 6.75Zm0 6.5a.75.75 0 0 1 .75-.75h14.5a.75.75 0 0 1 0 1.5H2.75a.75.75 0 0 1-.75-.75Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "M3.75 9h16.5m-16.5 6.75h16.5"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M3 9a.75.75 0 0 1 .75-.75h16.5a.75.75 0 0 1 0 1.5H3.75A.75.75 0 0 1 3 9Zm0 6.75a.75.75 0 0 1 .75-.75h16.5a.75.75 0 0 1 0 1.5H3.75a.75.75 0 0 1-.75-.75Z",
        "clip-rule": "evenodd"
      }
    ]
  }
};
const BarsArrowDown = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M2 2.75A.75.75 0 0 1 2.75 2h9.5a.75.75 0 0 1 0 1.5h-9.5A.75.75 0 0 1 2 2.75ZM2 6.25a.75.75 0 0 1 .75-.75h5.5a.75.75 0 0 1 0 1.5h-5.5A.75.75 0 0 1 2 6.25Zm0 3.5A.75.75 0 0 1 2.75 9h3.5a.75.75 0 0 1 0 1.5h-3.5A.75.75 0 0 1 2 9.75ZM14.78 11.47a.75.75 0 0 1 0 1.06l-2.25 2.25a.75.75 0 0 1-1.06 0l-2.25-2.25a.75.75 0 1 1 1.06-1.06l.97.97V6.75a.75.75 0 0 1 1.5 0v5.69l.97-.97a.75.75 0 0 1 1.06 0Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M2 3.75A.75.75 0 0 1 2.75 3h11.5a.75.75 0 0 1 0 1.5H2.75A.75.75 0 0 1 2 3.75ZM2 7.5a.75.75 0 0 1 .75-.75h7.508a.75.75 0 0 1 0 1.5H2.75A.75.75 0 0 1 2 7.5ZM14 7a.75.75 0 0 1 .75.75v6.59l1.95-2.1a.75.75 0 1 1 1.1 1.02l-3.25 3.5a.75.75 0 0 1-1.1 0l-3.25-3.5a.75.75 0 1 1 1.1-1.02l1.95 2.1V7.75A.75.75 0 0 1 14 7ZM2 11.25a.75.75 0 0 1 .75-.75h4.562a.75.75 0 0 1 0 1.5H2.75a.75.75 0 0 1-.75-.75Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "M3 4.5h14.25M3 9h9.75M3 13.5h9.75m4.5-4.5v12m0 0-3.75-3.75M17.25 21 21 17.25"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M2.25 4.5A.75.75 0 0 1 3 3.75h14.25a.75.75 0 0 1 0 1.5H3a.75.75 0 0 1-.75-.75Zm0 4.5A.75.75 0 0 1 3 8.25h9.75a.75.75 0 0 1 0 1.5H3A.75.75 0 0 1 2.25 9Zm15-.75A.75.75 0 0 1 18 9v10.19l2.47-2.47a.75.75 0 1 1 1.06 1.06l-3.75 3.75a.75.75 0 0 1-1.06 0l-3.75-3.75a.75.75 0 1 1 1.06-1.06l2.47 2.47V9a.75.75 0 0 1 .75-.75Zm-15 5.25a.75.75 0 0 1 .75-.75h9.75a.75.75 0 0 1 0 1.5H3a.75.75 0 0 1-.75-.75Z",
        "clip-rule": "evenodd"
      }
    ]
  }
};
const Heart = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M2 6.342a3.375 3.375 0 0 1 6-2.088 3.375 3.375 0 0 1 5.997 2.26c-.063 2.134-1.618 3.76-2.955 4.784a14.437 14.437 0 0 1-2.676 1.61c-.02.01-.038.017-.05.022l-.014.006-.004.002h-.002a.75.75 0 0 1-.592.001h-.002l-.004-.003-.015-.006a5.528 5.528 0 0 1-.232-.107 14.395 14.395 0 0 1-2.535-1.557C3.564 10.22 1.999 8.558 1.999 6.38L2 6.342Z"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "m9.653 16.915-.005-.003-.019-.01a20.759 20.759 0 0 1-1.162-.682 22.045 22.045 0 0 1-2.582-1.9C4.045 12.733 2 10.352 2 7.5a4.5 4.5 0 0 1 8-2.828A4.5 4.5 0 0 1 18 7.5c0 2.852-2.044 5.233-3.885 6.82a22.049 22.049 0 0 1-3.744 2.582l-.019.01-.005.003h-.002a.739.739 0 0 1-.69.001l-.002-.001Z"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "M21 8.25c0-2.485-2.099-4.5-4.688-4.5-1.935 0-3.597 1.126-4.312 2.733-.715-1.607-2.377-2.733-4.313-2.733C5.1 3.75 3 5.765 3 8.25c0 7.22 9 12 9 12s9-4.78 9-12Z"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "m11.645 20.91-.007-.003-.022-.012a15.247 15.247 0 0 1-.383-.218 25.18 25.18 0 0 1-4.244-3.17C4.688 15.36 2.25 12.174 2.25 8.25 2.25 5.322 4.714 3 7.688 3A5.5 5.5 0 0 1 12 5.052 5.5 5.5 0 0 1 16.313 3c2.973 0 5.437 2.322 5.437 5.25 0 3.925-2.438 7.111-4.739 9.256a25.175 25.175 0 0 1-4.244 3.17 15.247 15.247 0 0 1-.383.219l-.022.012-.007.004-.003.001a.752.752 0 0 1-.704 0l-.003-.001Z"
      }
    ]
  }
};
const TableCells = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M15 11a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h10a2 2 0 0 1 2 2v6ZM7.25 7.5a.5.5 0 0 0-.5-.5H3a.5.5 0 0 0-.5.5V8a.5.5 0 0 0 .5.5h3.75a.5.5 0 0 0 .5-.5v-.5Zm1.5 3a.5.5 0 0 1 .5-.5H13a.5.5 0 0 1 .5.5v.5a.5.5 0 0 1-.5.5H9.25a.5.5 0 0 1-.5-.5v-.5ZM13.5 8v-.5A.5.5 0 0 0 13 7H9.25a.5.5 0 0 0-.5.5V8a.5.5 0 0 0 .5.5H13a.5.5 0 0 0 .5-.5Zm-6.75 3.5a.5.5 0 0 0 .5-.5v-.5a.5.5 0 0 0-.5-.5H3a.5.5 0 0 0-.5.5v.5a.5.5 0 0 0 .5.5h3.75Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M.99 5.24A2.25 2.25 0 0 1 3.25 3h13.5A2.25 2.25 0 0 1 19 5.25l.01 9.5A2.25 2.25 0 0 1 16.76 17H3.26A2.267 2.267 0 0 1 1 14.74l-.01-9.5Zm8.26 9.52v-.625a.75.75 0 0 0-.75-.75H3.25a.75.75 0 0 0-.75.75v.615c0 .414.336.75.75.75h5.373a.75.75 0 0 0 .627-.74Zm1.5 0a.75.75 0 0 0 .627.74h5.373a.75.75 0 0 0 .75-.75v-.615a.75.75 0 0 0-.75-.75H11.5a.75.75 0 0 0-.75.75v.625Zm6.75-3.63v-.625a.75.75 0 0 0-.75-.75H11.5a.75.75 0 0 0-.75.75v.625c0 .414.336.75.75.75h5.25a.75.75 0 0 0 .75-.75Zm-8.25 0v-.625a.75.75 0 0 0-.75-.75H3.25a.75.75 0 0 0-.75.75v.625c0 .414.336.75.75.75H8.5a.75.75 0 0 0 .75-.75ZM17.5 7.5v-.625a.75.75 0 0 0-.75-.75H11.5a.75.75 0 0 0-.75.75V7.5c0 .414.336.75.75.75h5.25a.75.75 0 0 0 .75-.75Zm-8.25 0v-.625a.75.75 0 0 0-.75-.75H3.25a.75.75 0 0 0-.75.75V7.5c0 .414.336.75.75.75H8.5a.75.75 0 0 0 .75-.75Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "M3.375 19.5h17.25m-17.25 0a1.125 1.125 0 0 1-1.125-1.125M3.375 19.5h7.5c.621 0 1.125-.504 1.125-1.125m-9.75 0V5.625m0 12.75v-1.5c0-.621.504-1.125 1.125-1.125m18.375 2.625V5.625m0 12.75c0 .621-.504 1.125-1.125 1.125m1.125-1.125v-1.5c0-.621-.504-1.125-1.125-1.125m0 3.75h-7.5A1.125 1.125 0 0 1 12 18.375m9.75-12.75c0-.621-.504-1.125-1.125-1.125H3.375c-.621 0-1.125.504-1.125 1.125m19.5 0v1.5c0 .621-.504 1.125-1.125 1.125M2.25 5.625v1.5c0 .621.504 1.125 1.125 1.125m0 0h17.25m-17.25 0h7.5c.621 0 1.125.504 1.125 1.125M3.375 8.25c-.621 0-1.125.504-1.125 1.125v1.5c0 .621.504 1.125 1.125 1.125m17.25-3.75h-7.5c-.621 0-1.125.504-1.125 1.125m8.625-1.125c.621 0 1.125.504 1.125 1.125v1.5c0 .621-.504 1.125-1.125 1.125m-17.25 0h7.5m-7.5 0c-.621 0-1.125.504-1.125 1.125v1.5c0 .621.504 1.125 1.125 1.125M12 10.875v-1.5m0 1.5c0 .621-.504 1.125-1.125 1.125M12 10.875c0 .621.504 1.125 1.125 1.125m-2.25 0c.621 0 1.125.504 1.125 1.125M13.125 12h7.5m-7.5 0c-.621 0-1.125.504-1.125 1.125M20.625 12c.621 0 1.125.504 1.125 1.125v1.5c0 .621-.504 1.125-1.125 1.125m-17.25 0h7.5M12 14.625v-1.5m0 1.5c0 .621-.504 1.125-1.125 1.125M12 14.625c0 .621.504 1.125 1.125 1.125m-2.25 0c.621 0 1.125.504 1.125 1.125m0 1.5v-1.5m0 0c0-.621.504-1.125 1.125-1.125m0 0h7.5"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M1.5 5.625c0-1.036.84-1.875 1.875-1.875h17.25c1.035 0 1.875.84 1.875 1.875v12.75c0 1.035-.84 1.875-1.875 1.875H3.375A1.875 1.875 0 0 1 1.5 18.375V5.625ZM21 9.375A.375.375 0 0 0 20.625 9h-7.5a.375.375 0 0 0-.375.375v1.5c0 .207.168.375.375.375h7.5a.375.375 0 0 0 .375-.375v-1.5Zm0 3.75a.375.375 0 0 0-.375-.375h-7.5a.375.375 0 0 0-.375.375v1.5c0 .207.168.375.375.375h7.5a.375.375 0 0 0 .375-.375v-1.5Zm0 3.75a.375.375 0 0 0-.375-.375h-7.5a.375.375 0 0 0-.375.375v1.5c0 .207.168.375.375.375h7.5a.375.375 0 0 0 .375-.375v-1.5ZM10.875 18.75a.375.375 0 0 0 .375-.375v-1.5a.375.375 0 0 0-.375-.375h-7.5a.375.375 0 0 0-.375.375v1.5c0 .207.168.375.375.375h7.5ZM3.375 15h7.5a.375.375 0 0 0 .375-.375v-1.5a.375.375 0 0 0-.375-.375h-7.5a.375.375 0 0 0-.375.375v1.5c0 .207.168.375.375.375Zm0-3.75h7.5a.375.375 0 0 0 .375-.375v-1.5A.375.375 0 0 0 10.875 9h-7.5A.375.375 0 0 0 3 9.375v1.5c0 .207.168.375.375.375Z",
        "clip-rule": "evenodd"
      }
    ]
  }
};
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let localeMap = /* @__PURE__ */ new Map([
      ["en", { name: "English" }],
      ["ar", { name: "العربية" }],
      ["he", { name: "עברית" }],
      ["bg", { name: "български" }],
      ["de", { name: "Deutsch" }],
      ["es", { name: "Español" }],
      ["et", { name: "eesti keel" }],
      ["fi", { name: "suomi" }],
      ["fr", { name: "Français" }],
      ["hu", { name: "Magyar" }],
      ["ja", { name: "日本語" }],
      ["nl", { name: "Nederlands" }],
      ["pl", { name: "Polski" }],
      ["pt", { name: "Português (PT)" }],
      ["pt-BR", { name: "Português (BR)" }],
      ["tr", { name: "Türkçe" }],
      ["ru", { name: "Русский" }],
      ["zh-Hans", { name: "简体中文" }],
      ["zh-Hant", { name: "繁體中文" }]
    ]);
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      CommonList($$renderer3, {
        children: ($$renderer4) => {
          if (public_env.PUBLIC_XYLIGHT_MODE) {
            $$renderer4.push("<!--[-->");
            {
              let title = function($$renderer5) {
                $$renderer5.push(`<span class="dark:text-pink-400 text-pink-600">${escape_html(store_get($$store_subs ??= {}, "$t", t)("nav.menu.donate"))}</span>`);
              }, description = function($$renderer5) {
                $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("settings.donate.description"))}`);
              };
              Setting($$renderer4, {
                icon: Heart,
                title,
                description,
                children: ($$renderer5) => {
                  Button($$renderer5, {
                    color: "none",
                    class: "bg-gradient-to-r ml-6 dark:from-pink-400 dark:to-fuchsia-400 from-pink-600 to-red-600 text-white dark:text-black",
                    href: "https://buymeacoffee.com/xylight",
                    target: "_blank",
                    rounding: "xl",
                    icon: Heart,
                    children: ($$renderer6) => {
                      $$renderer6.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("nav.menu.donate"))}`);
                    },
                    $$slots: { default: true }
                  });
                }
              });
            }
          } else {
            $$renderer4.push("<!--[!-->");
          }
          $$renderer4.push(`<!--]--> `);
          {
            let title = function($$renderer5) {
              $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("settings.app.lang.title"))}`);
            }, description = function($$renderer5) {
              $$renderer5.push(`<p>${escape_html(store_get($$store_subs ??= {}, "$t", t)("settings.app.lang.description"))} `);
              Link($$renderer5, {
                href: "/translators",
                highlight: true,
                class: "text-base font-semibold",
                children: ($$renderer6) => {
                  $$renderer6.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("settings.app.lang.credits"))}`);
                },
                $$slots: { default: true }
              });
              $$renderer5.push(`<!----></p>`);
            };
            Setting($$renderer4, {
              icon: Language,
              title,
              description,
              children: ($$renderer5) => {
                Select($$renderer5, {
                  get value() {
                    return settings.language;
                  },
                  set value($$value) {
                    settings.language = $$value;
                    $$settled = false;
                  },
                  children: ($$renderer6) => {
                    Option($$renderer6, {
                      icon: Language,
                      value: null,
                      children: ($$renderer7) => {
                        $$renderer7.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("settings.app.lang.auto"))}`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> <!--[-->`);
                    const each_array = ensure_array_like(localeMap.entries());
                    for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
                      let [key, value] = each_array[$$index];
                      Option($$renderer6, {
                        "data-label": key == "placeholder",
                        disabled: key == "placeholder",
                        value: key,
                        children: ($$renderer7) => {
                          $$renderer7.push(`<!---->${escape_html(value.name)}`);
                        },
                        $$slots: { default: true }
                      });
                    }
                    $$renderer6.push(`<!--]-->`);
                  },
                  $$slots: { default: true }
                });
              }
            });
          }
          $$renderer4.push(`<!----> `);
          if (store_get($$store_subs ??= {}, "$locale", locale) == "he" || store_get($$store_subs ??= {}, "$locale", locale) == "ar") {
            $$renderer4.push("<!--[-->");
            ToggleSetting($$renderer4, {
              title: store_get($$store_subs ??= {}, "$t", t)("settings.app.lang.useRtl.title"),
              get checked() {
                return settings.useRtl;
              },
              set checked($$value) {
                settings.useRtl = $$value;
                $$settled = false;
              }
            });
          } else {
            $$renderer4.push("<!--[!-->");
          }
          $$renderer4.push(`<!--]--> `);
          {
            let title = function($$renderer5) {
              $$renderer5.push(`<span>${escape_html(store_get($$store_subs ??= {}, "$t", t)("settings.app.view.title"))}</span>`);
            }, description = function($$renderer5) {
              $$renderer5.push(`<p>`);
              if (settings.view == "cozy") {
                $$renderer5.push("<!--[-->");
                $$renderer5.push(`${escape_html(store_get($$store_subs ??= {}, "$t", t)("settings.app.view.cozy"))}`);
              } else {
                $$renderer5.push("<!--[!-->");
                if (settings.view == "compact") {
                  $$renderer5.push("<!--[-->");
                  $$renderer5.push(`${escape_html(store_get($$store_subs ??= {}, "$t", t)("settings.app.view.compact"))}`);
                } else {
                  $$renderer5.push("<!--[!-->");
                }
                $$renderer5.push(`<!--]-->`);
              }
              $$renderer5.push(`<!--]--></p>`);
            };
            Setting($$renderer4, {
              icon: ViewColumns,
              title,
              description,
              children: ($$renderer5) => {
                ViewSelect($$renderer5, { showLabel: false });
              }
            });
          }
          $$renderer4.push(`<!----> `);
          {
            let title = function($$renderer5) {
              $$renderer5.push(`<span>${escape_html(store_get($$store_subs ??= {}, "$t", t)("settings.app.sort.title"))}</span>`);
            }, description = function($$renderer5) {
              $$renderer5.push(`<span>${escape_html(store_get($$store_subs ??= {}, "$t", t)("settings.app.sort.description"))}</span>`);
            };
            Setting($$renderer4, {
              optionClass: "flex-2 max-w-full flex-wrap min-w-0 ",
              icon: ChartBar,
              title,
              description,
              children: ($$renderer5) => {
                $$renderer5.push(`<div class="flex flex-row flex-wrap flex-1 gap-2 w-full lg:w-max max-w-full lg:self-end">`);
                {
                  let customLabel = function($$renderer6) {
                    $$renderer6.push(`<div class="flex items-center gap-1">`);
                    Icon($$renderer6, { src: GlobeAmericas, size: "16", mini: true });
                    $$renderer6.push(`<!----> ${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.location.label"))}</div>`);
                  };
                  Select($$renderer5, {
                    get value() {
                      return settings.defaultSort.feed;
                    },
                    set value($$value) {
                      settings.defaultSort.feed = $$value;
                      $$settled = false;
                    },
                    customLabel,
                    children: ($$renderer6) => {
                      Option($$renderer6, {
                        value: "All",
                        children: ($$renderer7) => {
                          $$renderer7.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.location.all"))}`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer6.push(`<!----> `);
                      Option($$renderer6, {
                        value: "Local",
                        children: ($$renderer7) => {
                          $$renderer7.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.location.local"))}`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer6.push(`<!----> `);
                      Option($$renderer6, {
                        value: "Subscribed",
                        children: ($$renderer7) => {
                          $$renderer7.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.location.subscribed"))}`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer6.push(`<!----> `);
                      Option($$renderer6, {
                        value: "Moderator",
                        children: ($$renderer7) => {
                          $$renderer7.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.location.moderator"))}`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer6.push(`<!---->`);
                    },
                    $$slots: { customLabel: true, default: true }
                  });
                }
                $$renderer5.push(`<!----> `);
                Sort($$renderer5, {
                  navigate: false,
                  get selected() {
                    return settings.defaultSort.sort;
                  },
                  set selected($$value) {
                    settings.defaultSort.sort = $$value;
                    $$settled = false;
                  }
                });
                $$renderer5.push(`<!----> `);
                {
                  let customLabel = function($$renderer6) {
                    $$renderer6.push(`<div class="flex items-center gap-1">`);
                    Icon($$renderer6, { src: ChatBubbleOvalLeftEllipsis, size: "14", mini: true });
                    $$renderer6.push(`<!----> ${escape_html(store_get($$store_subs ??= {}, "$t", t)("content.comments"))}</div>`);
                  };
                  Select($$renderer5, {
                    get value() {
                      return settings.defaultSort.comments;
                    },
                    set value($$value) {
                      settings.defaultSort.comments = $$value;
                      $$settled = false;
                    },
                    customLabel,
                    children: ($$renderer6) => {
                      Option($$renderer6, {
                        icon: Fire,
                        value: "Hot",
                        children: ($$renderer7) => {
                          $$renderer7.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.sort.hot"))}`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer6.push(`<!----> `);
                      Option($$renderer6, {
                        icon: Trophy,
                        value: "Top",
                        children: ($$renderer7) => {
                          $$renderer7.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.sort.top.label"))}`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer6.push(`<!----> `);
                      Option($$renderer6, {
                        icon: Star,
                        value: "New",
                        children: ($$renderer7) => {
                          $$renderer7.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.sort.new"))}`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer6.push(`<!----> `);
                      Option($$renderer6, {
                        icon: Clock,
                        value: "Old",
                        children: ($$renderer7) => {
                          $$renderer7.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.sort.old"))}`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer6.push(`<!----> `);
                      Option($$renderer6, {
                        icon: ArrowTrendingDown,
                        value: "Controversial",
                        children: ($$renderer7) => {
                          $$renderer7.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.sort.controversial"))}`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer6.push(`<!---->`);
                    },
                    $$slots: { customLabel: true, default: true }
                  });
                }
                $$renderer5.push(`<!----></div>`);
              }
            });
          }
          $$renderer4.push(`<!----> `);
          ToggleSetting($$renderer4, {
            icon: BarsArrowDown,
            title: store_get($$store_subs ??= {}, "$t", t)("settings.app.infiniteScroll.title"),
            description: store_get($$store_subs ??= {}, "$t", t)("settings.app.infiniteScroll.description"),
            get checked() {
              return settings.infiniteScroll;
            },
            set checked($$value) {
              settings.infiniteScroll = $$value;
              $$settled = false;
            }
          });
          $$renderer4.push(`<!----> `);
          {
            let title = function($$renderer5) {
              $$renderer5.push(`<span>${escape_html(store_get($$store_subs ??= {}, "$t", t)("settings.app.thumbnailSide.title"))}</span>`);
            }, description = function($$renderer5) {
              $$renderer5.push(`<span>${escape_html(store_get($$store_subs ??= {}, "$t", t)("settings.app.thumbnailSide.description"))}</span>`);
            };
            Setting($$renderer4, {
              icon: Photo,
              title,
              description,
              children: ($$renderer5) => {
                Switch($$renderer5, {
                  options: [true, false],
                  optionNames: [
                    store_get($$store_subs ??= {}, "$t", t)("settings.app.thumbnailSide.left"),
                    store_get($$store_subs ??= {}, "$t", t)("settings.app.thumbnailSide.right")
                  ],
                  get selected() {
                    return settings.leftAlign;
                  },
                  set selected($$value) {
                    settings.leftAlign = $$value;
                    $$settled = false;
                  }
                });
              }
            });
          }
          $$renderer4.push(`<!----> `);
          ToggleSetting($$renderer4, {
            icon: ArrowsRightLeft,
            title: store_get($$store_subs ??= {}, "$t", t)("settings.app.reverseActions.title"),
            description: store_get($$store_subs ??= {}, "$t", t)("settings.app.reverseActions.description"),
            get checked() {
              return settings.posts.reverseActions;
            },
            set checked($$value) {
              settings.posts.reverseActions = $$value;
              $$settled = false;
            }
          });
          $$renderer4.push(`<!----> `);
          ToggleSetting($$renderer4, {
            icon: TableCells,
            supportedPlatforms: { desktop: true, tablet: false, mobile: false },
            title: store_get($$store_subs ??= {}, "$t", t)("settings.app.limitLayoutWidth.title"),
            description: store_get($$store_subs ??= {}, "$t", t)("settings.app.limitLayoutWidth.description"),
            get checked() {
              return settings.newWidth;
            },
            set checked($$value) {
              settings.newWidth = $$value;
              $$settled = false;
            }
          });
          $$renderer4.push(`<!----> `);
          ToggleSetting($$renderer4, {
            icon: Calendar,
            title: store_get($$store_subs ??= {}, "$t", t)("settings.app.absoluteDates.title"),
            description: store_get($$store_subs ??= {}, "$t", t)("settings.app.absoluteDates.description"),
            get checked() {
              return settings.absoluteDates;
            },
            set checked($$value) {
              settings.absoluteDates = $$value;
              $$settled = false;
            }
          });
          $$renderer4.push(`<!----> `);
          ToggleSetting($$renderer4, {
            icon: ArrowsUpDown,
            title: store_get($$store_subs ??= {}, "$t", t)("settings.app.voteRatioBar.title"),
            description: store_get($$store_subs ??= {}, "$t", t)("settings.app.voteRatioBar.description"),
            get checked() {
              return settings.voteRatioBar;
            },
            set checked($$value) {
              settings.voteRatioBar = $$value;
              $$settled = false;
            }
          });
          $$renderer4.push(`<!----> `);
          ToggleSetting($$renderer4, {
            icon: CubeTransparent,
            supportedPlatforms: { desktop: false, tablet: false, mobile: true },
            title: store_get($$store_subs ??= {}, "$t", t)("settings.navigation.autoHide.title"),
            description: store_get($$store_subs ??= {}, "$t", t)("settings.navigation.autoHide.description"),
            get checked() {
              return settings.dock.autoHide;
            },
            set checked($$value) {
              settings.dock.autoHide = $$value;
              $$settled = false;
            }
          });
          $$renderer4.push(`<!----> `);
          ToggleSetting($$renderer4, {
            icon: ArrowTopRightOnSquare,
            title: store_get($$store_subs ??= {}, "$t", t)("settings.app.postsInNewTab.title"),
            description: store_get($$store_subs ??= {}, "$t", t)("settings.app.postsInNewTab.description"),
            get checked() {
              return settings.openLinksInNewTab;
            },
            set checked($$value) {
              settings.openLinksInNewTab = $$value;
              $$settled = false;
            }
          });
          $$renderer4.push(`<!----> `);
          {
            let title = function($$renderer5) {
              $$renderer5.push(`<span>${escape_html(store_get($$store_subs ??= {}, "$t", t)("settings.app.font.title"))}</span>`);
            }, description = function($$renderer5) {
              $$renderer5.push(`<span>${escape_html(store_get($$store_subs ??= {}, "$t", t)("settings.app.font.description"))}</span>`);
            };
            Setting($$renderer4, {
              icon: DocumentText,
              title,
              description,
              children: ($$renderer5) => {
                Select($$renderer5, {
                  get value() {
                    return settings.font;
                  },
                  set value($$value) {
                    settings.font = $$value;
                    $$settled = false;
                  },
                  children: ($$renderer6) => {
                    Option($$renderer6, {
                      value: "inter",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<!---->Inter`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Option($$renderer6, {
                      value: "system",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<!---->System UI`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!----> `);
                    Option($$renderer6, {
                      value: "browser",
                      children: ($$renderer7) => {
                        $$renderer7.push(`<!---->Browser`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer6.push(`<!---->`);
                  },
                  $$slots: { default: true }
                });
              }
            });
          }
          $$renderer4.push(`<!----> `);
          ToggleSetting($$renderer4, {
            icon: ArrowsPointingOut,
            title: store_get($$store_subs ??= {}, "$t", t)("settings.app.expandImages.title"),
            description: store_get($$store_subs ??= {}, "$t", t)("settings.app.expandImages.description"),
            get checked() {
              return settings.expandImages;
            },
            set checked($$value) {
              settings.expandImages = $$value;
              $$settled = false;
            }
          });
          $$renderer4.push(`<!----> `);
          ToggleSetting($$renderer4, {
            icon: Bars2,
            title: store_get($$store_subs ??= {}, "$t", t)("settings.app.duplicateTitles.title"),
            description: store_get($$store_subs ??= {}, "$t", t)("settings.app.duplicateTitles.description"),
            get checked() {
              return settings.posts.deduplicateEmbed;
            },
            set checked($$value) {
              settings.posts.deduplicateEmbed = $$value;
              $$settled = false;
            }
          });
          $$renderer4.push(`<!----> `);
          ToggleSetting($$renderer4, {
            icon: ArrowTopRightOnSquare,
            title: store_get($$store_subs ??= {}, "$t", t)("settings.app.titleOpensUrl.title"),
            description: store_get($$store_subs ??= {}, "$t", t)("settings.app.titleOpensUrl.description"),
            get checked() {
              return settings.posts.titleOpensUrl;
            },
            set checked($$value) {
              settings.posts.titleOpensUrl = $$value;
              $$settled = false;
            }
          });
          $$renderer4.push(`<!----> `);
          ToggleSetting($$renderer4, {
            icon: Tag,
            title: store_get($$store_subs ??= {}, "$t", t)("settings.app.titleTags.title"),
            description: store_get($$store_subs ??= {}, "$t", t)("settings.app.titleTags.description"),
            get checked() {
              return settings.parseTags;
            },
            set checked($$value) {
              settings.parseTags = $$value;
              $$settled = false;
            }
          });
          $$renderer4.push(`<!---->`);
        }
      });
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
