import { d as ensure_array_like, e as escape_html, s as store_get, u as unsubscribe_stores } from "../../../../chunks/index3.js";
import { t } from "../../../../chunks/index.js";
import { M as MarkdownEditor } from "../../../../chunks/MarkdownEditor.js";
import { s as settings } from "../../../../chunks/settings.svelte.js";
import { r as removalTemplate } from "../../../../chunks/moderation.js";
import "@sveltejs/kit/internal";
import "../../../../chunks/exports.js";
import "../../../../chunks/utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
import { E as Expandable, B as Button, o as Plus } from "../../../../chunks/client.svelte.js";
import { C as CommonList } from "../../../../chunks/CommonList.js";
import { I as Icon } from "../../../../chunks/Icon.js";
import { T as Trash } from "../../../../chunks/Trash.js";
import { T as TextInput } from "../../../../chunks/TextInput.js";
import "openapi-fetch";
import "@sveltejs/kit";
import "lemmy-js-client";
import "@dicebear/core";
import "@dicebear/initials";
import { S as Setting } from "../../../../chunks/Setting.js";
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      CommonList($$renderer3, {
        children: ($$renderer4) => {
          {
            let title = function($$renderer5) {
              $$renderer5.push(`<span>${escape_html(store_get($$store_subs ??= {}, "$t", t)("settings.moderation.replyPresets.title"))}</span>`);
            }, description = function($$renderer5) {
              $$renderer5.push(`<span><p>${escape_html(store_get($$store_subs ??= {}, "$t", t)("settings.moderation.replyPresets.description"))}</p> <ul class="leading-6"><li>${escape_html(store_get($$store_subs ??= {}, "$t", t)("settings.moderation.replyPresets.syntax"))}</li> <li><code>{{reason}}</code></li> <li><code>{{post}}</code></li> <li><code>{{community}}</code></li> <li><code>{{username}}</code></li></ul></span>`);
            };
            Setting($$renderer4, {
              icon: Trash,
              adaptive: false,
              title,
              description
            });
          }
          $$renderer4.push(`<!----> <!--[-->`);
          const each_array = ensure_array_like(settings.moderation.presets);
          for (let index = 0, $$length = each_array.length; index < $$length; index++) {
            let preset = each_array[index];
            $$renderer4.push(`<li>`);
            {
              let title = function($$renderer5) {
                $$renderer5.push(`<!---->${escape_html(preset.title)}`);
              };
              Expandable($$renderer4, {
                title,
                children: ($$renderer5) => {
                  $$renderer5.push(`<div class="flex flex-col gap-3">`);
                  TextInput($$renderer5, {
                    label: "Title",
                    placeholder: "Reason 1",
                    get value() {
                      return preset.title;
                    },
                    set value($$value) {
                      preset.title = $$value;
                      $$settled = false;
                    }
                  });
                  $$renderer5.push(`<!----> `);
                  MarkdownEditor($$renderer5, {
                    label: "Content",
                    images: false,
                    previewButton: true,
                    beforePreview: (input) => removalTemplate(input, {
                      postTitle: "<Example post>",
                      communityLink: "[!community@example.com]()",
                      reason: "<Being a meanie>",
                      username: "@Bob"
                    }),
                    get value() {
                      return preset.content;
                    },
                    set value($$value) {
                      preset.content = $$value;
                      $$settled = false;
                    }
                  });
                  $$renderer5.push(`<!----> `);
                  Button($$renderer5, {
                    color: "danger",
                    rounding: "pill",
                    onclick: () => {
                      settings.moderation.presets.splice(index, 1);
                      settings.moderation.presets = settings.moderation.presets;
                    },
                    class: "w-max",
                    children: ($$renderer6) => {
                      Icon($$renderer6, { src: Trash, size: "16", mini: true });
                      $$renderer6.push(`<!----> ${escape_html(store_get($$store_subs ??= {}, "$t", t)("common.remove"))}`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----></div>`);
                },
                $$slots: { title: true, default: true }
              });
            }
            $$renderer4.push(`<!----></li>`);
          }
          $$renderer4.push(`<!--]--> <li>`);
          Button($$renderer4, {
            color: "none",
            class: "w-full p-2",
            onclick: () => {
              settings.moderation.presets = [
                ...settings.moderation.presets,
                {
                  title: `Preset ${settings.moderation.presets.length + 1}`,
                  content: "Your submission in *{{post}}* was removed for *{{reason}}*."
                }
              ];
            },
            icon: Plus,
            children: ($$renderer5) => {
              $$renderer5.push(`<!---->Add Preset`);
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!----></li>`);
        }
      });
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
