import { h as head, e as escape_html, s as store_get, g as await_block, b as attr, u as unsubscribe_stores, k as stringify } from "../../../../chunks/index3.js";
import "@sveltejs/kit/internal";
import "../../../../chunks/exports.js";
import "../../../../chunks/utils.js";
import "@sveltejs/kit/internal/server";
import { B as Button, M as Material, i as Markdown, a as getClient, o as Plus, h as Avatar, y as Spinner } from "../../../../chunks/client.svelte.js";
import { p as page } from "../../../../chunks/index4.js";
import { t } from "../../../../chunks/index.js";
import { M as MarkdownEditor } from "../../../../chunks/MarkdownEditor.js";
import { I as InstanceCard } from "../../../../chunks/InstanceCard.js";
import { E as ErrorContainer } from "../../../../chunks/ErrorContainer.js";
import { P as Placeholder } from "../../../../chunks/Placeholder.js";
import { H as Header } from "../../../../chunks/Header.js";
import { L as Label } from "../../../../chunks/Label.js";
import { T as TextInput } from "../../../../chunks/TextInput.js";
import { I as Icon } from "../../../../chunks/Icon.js";
import { A as ArrowLeft } from "../../../../chunks/ArrowLeft.js";
import { A as ArrowPath } from "../../../../chunks/ArrowPath.js";
import { E as ExclamationTriangle } from "../../../../chunks/ExclamationTriangle.js";
import { Q as QuestionMarkCircle } from "../../../../chunks/QuestionMarkCircle.js";
import { X as XCircle } from "../../../../chunks/XCircle.js";
import { S as Switch } from "../../../../chunks/Switch.js";
import "../../../../chunks/settings.svelte.js";
import "openapi-fetch";
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { data } = $$props;
    const instance = page.params.instance;
    let captchaRequired = data.site_view.local_site.captcha_enabled;
    let email = "";
    let username = "", password = "", passwordVerify = "", captcha = void 0, verifyCaptcha = void 0, application = "", submitting = false, honeypot = void 0, nsfw = false;
    const getCaptcha = async () => captcha = await getClient(instance, fetch).getCaptcha();
    let captchaAudio = captcha?.ok?.wav ? `data:audio/wav;base64,${captcha.ok.wav}` : "";
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      head($$renderer3, ($$renderer4) => {
        $$renderer4.title(($$renderer5) => {
          $$renderer5.push(`<title>${escape_html(store_get($$store_subs ??= {}, "$t", t)("account.signup"))}</title>`);
        });
      });
      $$renderer3.push(`<div class="flex flex-col md:flex-row flex-1/3 gap-8 h-full max-w-5xl mx-auto">`);
      {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<form class="flex flex-col gap-4 h-full w-full flex-2/3">`);
        Button($$renderer3, {
          href: "/accounts",
          class: " mb-4 w-max",
          rounding: "pill",
          children: ($$renderer4) => {
            Icon($$renderer4, { src: ArrowLeft, size: "16", micro: true });
            $$renderer4.push(`<!----> ${escape_html(store_get($$store_subs ??= {}, "$t", t)("common.back"))}`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        {
          let extended = function($$renderer4) {
            $$renderer4.push(`<span class="flex gap-4 items-center text-xl text-center mx-auto">`);
            if (data.site_view.site.icon) {
              $$renderer4.push("<!--[-->");
              Avatar($$renderer4, { circle: false, width: 48, url: data.site_view.site.icon });
            } else {
              $$renderer4.push("<!--[!-->");
            }
            $$renderer4.push(`<!--]--> ${escape_html(data.site_view.site.name)}</span>`);
          };
          Header($$renderer3, {
            extended,
            children: ($$renderer4) => {
              $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.signup.title"))}`);
            }
          });
        }
        $$renderer3.push(`<!----> `);
        ErrorContainer($$renderer3, { scope: page.url.pathname });
        $$renderer3.push(`<!----> `);
        if (data.site_view.local_site.registration_mode != "Closed") {
          $$renderer3.push("<!--[-->");
          $$renderer3.push(`<div class="flex flex-col md:flex-row gap-2 *:flex-1">`);
          TextInput($$renderer3, {
            label: store_get($$store_subs ??= {}, "$t", t)("form.email"),
            required: data.site_view.local_site.require_email_verification,
            type: "email",
            get value() {
              return email;
            },
            set value($$value) {
              email = $$value;
              $$settled = false;
            }
          });
          $$renderer3.push(`<!----> `);
          TextInput($$renderer3, {
            label: store_get($$store_subs ??= {}, "$t", t)("form.username"),
            required: true,
            get value() {
              return username;
            },
            set value($$value) {
              username = $$value;
              $$settled = false;
            }
          });
          $$renderer3.push(`<!----></div> <div class="flex flex-col md:flex-row gap-2 *:flex-1">`);
          TextInput($$renderer3, {
            label: store_get($$store_subs ??= {}, "$t", t)("form.password"),
            required: true,
            type: "password",
            get value() {
              return password;
            },
            set value($$value) {
              password = $$value;
              $$settled = false;
            }
          });
          $$renderer3.push(`<!----> `);
          TextInput($$renderer3, {
            label: store_get($$store_subs ??= {}, "$t", t)("form.confirmPassword"),
            required: true,
            type: "password",
            get value() {
              return passwordVerify;
            },
            set value($$value) {
              passwordVerify = $$value;
              $$settled = false;
            }
          });
          $$renderer3.push(`<!----></div> `);
          if (data.site_view.local_site.registration_mode == "RequireApplication") {
            $$renderer3.push("<!--[-->");
            Material($$renderer3, {
              rounding: "2xl",
              color: "warning",
              icon: ExclamationTriangle,
              children: ($$renderer4) => {
                $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.signup.application.info"))}`);
              },
              $$slots: { default: true }
            });
            $$renderer3.push(`<!----> `);
            if (data.site_view.local_site.application_question) {
              $$renderer3.push("<!--[-->");
              Markdown($$renderer3, { source: data.site_view.local_site.application_question });
            } else {
              $$renderer3.push("<!--[!-->");
            }
            $$renderer3.push(`<!--]--> `);
            MarkdownEditor($$renderer3, {
              label: store_get($$store_subs ??= {}, "$t", t)("form.signup.application.label"),
              required: true,
              get value() {
                return application;
              },
              set value($$value) {
                application = $$value;
                $$settled = false;
              }
            });
            $$renderer3.push(`<!---->`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--> `);
          if (captchaRequired) {
            $$renderer3.push("<!--[-->");
            Label($$renderer3, {
              class: "block -mb-3 font-medium text-sm",
              children: ($$renderer4) => {
                $$renderer4.push(`<!---->Captcha`);
              },
              $$slots: { default: true }
            });
            $$renderer3.push(`<!----> `);
            Material($$renderer3, {
              rounding: "2xl",
              children: ($$renderer4) => {
                $$renderer4.push(`<div class="flex flex-col gap-4">`);
                await_block(
                  $$renderer4,
                  getCaptcha(),
                  () => {
                    Spinner($$renderer4, { width: 32 });
                  },
                  () => {
                    if (captcha?.ok) {
                      $$renderer4.push("<!--[-->");
                      $$renderer4.push(`<img${attr("src", `data:image/png;base64,${stringify(captcha.ok.png)}`)} alt="Captcha" class="w-max"/> <audio controls${attr("src", captchaAudio)}></audio>`);
                    } else {
                      $$renderer4.push("<!--[!-->");
                      Material($$renderer4, {
                        class: "flex gap-2 dark:text-yellow-200 text-yellow-800 bg-yellow-500/20",
                        children: ($$renderer5) => {
                          Icon($$renderer5, { src: QuestionMarkCircle, mini: true, size: "24" });
                          $$renderer5.push(`<!----> No captcha was returned`);
                        },
                        $$slots: { default: true }
                      });
                    }
                    $$renderer4.push(`<!--]-->`);
                  }
                );
                $$renderer4.push(`<!--]--> `);
                Button($$renderer4, {
                  onclick: () => getCaptcha(),
                  size: "square-md",
                  children: ($$renderer5) => {
                    Icon($$renderer5, { src: ArrowPath, size: "16", mini: true });
                  },
                  $$slots: { default: true }
                });
                $$renderer4.push(`<!----> `);
                TextInput($$renderer4, {
                  required: true,
                  get value() {
                    return verifyCaptcha;
                  },
                  set value($$value) {
                    verifyCaptcha = $$value;
                    $$settled = false;
                  }
                });
                $$renderer4.push(`<!----></div>`);
              },
              $$slots: { default: true }
            });
            $$renderer3.push(`<!---->`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--> `);
          Switch($$renderer3, {
            get checked() {
              return nsfw;
            },
            set checked($$value) {
              nsfw = $$value;
              $$settled = false;
            },
            children: ($$renderer4) => {
              $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.profile.showNSFW"))}`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> <input type="dn" name="honeypot"${attr("value", honeypot)} class="hidden"/> `);
          Button($$renderer3, {
            submit: true,
            color: "primary",
            size: "lg",
            loading: submitting,
            disabled: submitting,
            class: "mt-auto",
            children: ($$renderer4) => {
              $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.submit"))}`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!---->`);
        } else {
          $$renderer3.push("<!--[!-->");
          $$renderer3.push(`<div class="my-auto">`);
          Placeholder($$renderer3, {
            icon: XCircle,
            title: store_get($$store_subs ??= {}, "$t", t)("form.signup.closed.title"),
            description: store_get($$store_subs ??= {}, "$t", t)("form.signup.closed.description"),
            children: ($$renderer4) => {
              Button($$renderer4, {
                icon: Plus,
                href: "/signup",
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.signup.closed.anotherInstance"))}`);
                },
                $$slots: { default: true }
              });
            }
          });
          $$renderer3.push(`<!----></div>`);
        }
        $$renderer3.push(`<!--]--></form>`);
      }
      $$renderer3.push(`<!--]--> `);
      Material($$renderer3, {
        color: "uniform",
        class: "flex-1/3 overflow-auto max-h-full max-md:hidden",
        rounding: "2xl",
        padding: "none",
        children: ($$renderer4) => {
          InstanceCard($$renderer4, {
            admins: data.admins,
            site: data.site_view,
            taglines: data.taglines,
            version: data.version,
            class: "w-full p-4"
          });
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----></div>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
