import { h as head, e as escape_html, s as store_get, u as unsubscribe_stores } from "../../../chunks/index3.js";
import "@sveltejs/kit/internal";
import "../../../chunks/exports.js";
import "../../../chunks/utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
import { B as Button, D as DEFAULT_INSTANCE_URL } from "../../../chunks/client.svelte.js";
import { t } from "../../../chunks/index.js";
import "@sveltejs/kit";
import "lemmy-js-client";
import "openapi-fetch";
import { I as Icon } from "../../../chunks/Icon.js";
import { A as ArrowLeft } from "../../../chunks/ArrowLeft.js";
import { T as TextInput } from "../../../chunks/TextInput.js";
import "../../../chunks/settings.svelte.js";
import "@dicebear/core";
import "@dicebear/initials";
import { H as Header } from "../../../chunks/Header.js";
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let selectedInstance = "";
    let validating = false;
    let placeholder = DEFAULT_INSTANCE_URL;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      head($$renderer3, ($$renderer4) => {
        $$renderer4.title(($$renderer5) => {
          $$renderer5.push(`<title>${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.signup.title"))}</title>`);
        });
      });
      $$renderer3.push(`<div class="mx-auto max-w-xl flex flex-col gap-4 my-auto h-max w-full">`);
      Button($$renderer3, {
        href: "/accounts",
        class: "mb-4 w-max",
        rounding: "pill",
        children: ($$renderer4) => {
          Icon($$renderer4, { src: ArrowLeft, size: "16", micro: true });
          $$renderer4.push(`<!----> ${escape_html(store_get($$store_subs ??= {}, "$t", t)("common.back"))}`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      Header($$renderer3, {
        children: ($$renderer4) => {
          $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.signup.title"))}`);
        }
      });
      $$renderer3.push(`<!----> <p>${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.signup.description"))}</p> <p>${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.signup.info"))}</p> `);
      {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> <form class="flex flex-col gap-4">`);
      TextInput($$renderer3, {
        label: store_get($$store_subs ??= {}, "$t", t)("form.signup.chooseInstance"),
        required: true,
        placeholder,
        oninput: () => {
          selectedInstance = selectedInstance.toLowerCase().replaceAll(" ", "");
        },
        get value() {
          return selectedInstance;
        },
        set value($$value) {
          selectedInstance = $$value;
          $$settled = false;
        }
      });
      $$renderer3.push(`<!----> `);
      Button($$renderer3, {
        submit: true,
        color: "primary",
        size: "lg",
        loading: validating,
        disabled: validating,
        children: ($$renderer4) => {
          $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.submit"))}`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----></form></div>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
