import { a as attr_class, j as attr_style, b as attr, f as bind_props, k as stringify, c as clsx, e as escape_html, s as store_get, u as unsubscribe_stores, h as head, d as ensure_array_like } from "../../../chunks/index3.js";
import { t } from "../../../chunks/index.js";
import { t as theme, g as getDefaultColors } from "../../../chunks/theme.svelte.js";
import { H as Header } from "../../../chunks/Header.js";
import "@sveltejs/kit/internal";
import "../../../chunks/exports.js";
import "../../../chunks/utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
import { M as Material, B as Button, o as Plus, A as ArrowDownTray, t as toast } from "../../../chunks/client.svelte.js";
import { T as TextArea } from "../../../chunks/TextArea.js";
import { I as Icon } from "../../../chunks/Icon.js";
import { A as ArrowPath } from "../../../chunks/ArrowPath.js";
import { A as ArrowUpTray } from "../../../chunks/ArrowUpTray.js";
import { M as Modal } from "../../../chunks/Modal.js";
import { m as modal, a as action } from "../../../chunks/modal2.js";
import { N as Note } from "../../../chunks/Note.js";
import "../../../chunks/settings.svelte.js";
import "openapi-fetch";
import "@sveltejs/kit";
import "lemmy-js-client";
import "@dicebear/core";
import "@dicebear/initials";
import { C as CheckCircle } from "../../../chunks/CheckCircle.js";
import { T as Trash } from "../../../chunks/Trash.js";
function ColorSwatch($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let { value = void 0, oncontextmenu, onchange, class: clazz = "" } = $$props;
    $$renderer2.push(`<div${attr_class(`w-full h-8 relative rounded-md border dark:border-zinc-600 dark:hover:border-zinc-400 transition-colors ${stringify(clazz)}`)}${attr_style(`background-color: rgb(${stringify(value)});`)}><input class="rounded-md border cursor-pointer absolute top-0 left-0 w-full h-full opacity-0" type="color"${attr("value", value)}/></div>`);
    bind_props($$props, { value });
  });
}
function ThemePreset($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { theme: theme$1 = void 0 } = $$props;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      $$renderer3.push(`<button class="h-full">`);
      Material($$renderer3, {
        padding: "none",
        rounding: "none",
        class: `${stringify(theme$1.id == theme.data.currentTheme ? "ring-2 ring-primary-900 dark:ring-primary-100" : "")} rounded-2xl flex relative cursor-pointer h-full flex-col text-left p-0.5`,
        children: ($$renderer4) => {
          $$renderer4.push(`<div${attr_class(clsx([
            "h-20 w-full rounded-2xl rounded-b-none flex flex-row flex-wrap p-3 gap-2"
          ]))}${attr_style(`background-color: rgb(${stringify(theme$1.colors["zinc"][900])}); color: rgb(${stringify(theme$1.colors["zinc"][50])});`)}><div${attr_style(`color: rgb(${stringify(theme$1.colors["zinc"][50])})`)} class="text-xs">Lorem ipsum dolor sit amet, consectetur adipisicing elit.</div> <div class="w-3 h-3 rounded-full ml-auto"${attr_style(`background-color: rgb(${stringify(theme$1.colors["primary"][100])})`)}></div></div> `);
          if (theme$1.id == theme.data.currentTheme) {
            $$renderer4.push("<!--[-->");
            Icon($$renderer4, {
              src: CheckCircle,
              size: "20",
              solid: true,
              class: "absolute top-0 right-0 m-2 text-primary-100"
            });
          } else {
            $$renderer4.push("<!--[!-->");
          }
          $$renderer4.push(`<!--]--> <div class="px-4 py-2 flex items-center gap-1 justify-between">`);
          {
            $$renderer4.push("<!--[!-->");
            $$renderer4.push(`<button class="text-left font-medium text-lg font-display">${escape_html(theme$1.name)}</button>`);
          }
          $$renderer4.push(`<!--]--> `);
          if (theme$1.id > 0) {
            $$renderer4.push("<!--[-->");
            Button($$renderer4, {
              color: "ghost",
              size: "square-md",
              class: "shrink-0",
              rounding: "xl",
              onclick: () => {
                modal({
                  actions: [
                    action({
                      close: true,
                      type: "secondary",
                      content: store_get($$store_subs ??= {}, "$t", t)("common.cancel")
                    }),
                    action({
                      close: true,
                      content: store_get($$store_subs ??= {}, "$t", t)("routes.theme.preset.delete.confirm"),
                      type: "danger",
                      action: () => {
                        const index = theme.data.themes.map((t2) => t2.id).indexOf(theme$1.id);
                        theme.data.themes = theme.data.themes.toSpliced(index, 1);
                        if (theme$1.id == theme.data.currentTheme) {
                          theme.data.currentTheme = 0;
                        }
                      }
                    })
                  ],
                  type: "error",
                  body: "",
                  title: store_get($$store_subs ??= {}, "$t", t)("routes.theme.preset.delete.title")
                });
              },
              icon: Trash
            });
          } else {
            $$renderer4.push("<!--[!-->");
          }
          $$renderer4.push(`<!--]--></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----></button>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { theme: theme$1 });
  });
}
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let importing = false;
    let importText = "";
    let defaultColors = getDefaultColors();
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      head($$renderer3, ($$renderer4) => {
        $$renderer4.title(($$renderer5) => {
          $$renderer5.push(`<title>${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.theme.title"))}</title>`);
        });
      });
      if (importing) {
        $$renderer3.push("<!--[-->");
        Modal($$renderer3, {
          onaction: () => {
            try {
              if (importText == "") {
                throw new Error("import failed");
              }
              theme.current.colors = JSON.parse(importText);
              toast({
                content: store_get($$store_subs ??= {}, "$t", t)("message.success"),
                type: "success"
              });
              importing = false;
            } catch (err) {
              toast({ content: err, type: "error" });
            }
          },
          title: store_get($$store_subs ??= {}, "$t", t)("settings.import"),
          action: store_get($$store_subs ??= {}, "$t", t)("settings.import"),
          get open() {
            return importing;
          },
          set open($$value) {
            importing = $$value;
            $$settled = false;
          },
          children: ($$renderer4) => {
            TextArea($$renderer4, {
              style: "font-family: monospace;",
              get value() {
                return importText;
              },
              set value($$value) {
                importText = $$value;
                $$settled = false;
              }
            });
          },
          $$slots: { default: true }
        });
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      {
        let extended = function($$renderer4) {
          $$renderer4.push(`<div class="flex items-center gap-2">`);
          Button($$renderer4, {
            onclick: () => {
              importing = !importing;
            },
            size: "lg",
            disabled: theme.current.id <= 0,
            children: ($$renderer5) => {
              Icon($$renderer5, { src: ArrowUpTray, size: "16", mini: true });
              $$renderer5.push(`<!----> ${escape_html(store_get($$store_subs ??= {}, "$t", t)("settings.import"))}`);
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!----> `);
          Button($$renderer4, {
            onclick: () => {
              navigator.clipboard.writeText(JSON.stringify(theme.current.colors));
              toast({ content: "Copied theme to clipboard." });
            },
            size: "lg",
            children: ($$renderer5) => {
              Icon($$renderer5, { src: ArrowDownTray, size: "16", mini: true });
              $$renderer5.push(`<!----> ${escape_html(store_get($$store_subs ??= {}, "$t", t)("settings.export"))}`);
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!----> `);
          Button($$renderer4, {
            disabled: theme.current.id <= 0,
            onclick: () => {
              modal({
                actions: [
                  action({
                    content: store_get($$store_subs ??= {}, "$t", t)("common.cancel"),
                    close: true
                  }),
                  action({
                    action: () => {
                      theme.current.colors = { other: {}, primary: {}, zinc: {}, slate: {} };
                    },
                    content: store_get($$store_subs ??= {}, "$t", t)("settings.reset"),
                    close: true,
                    type: "danger"
                  })
                ],
                title: store_get($$store_subs ??= {}, "$t", t)("routes.theme.resetWarning.title"),
                body: store_get($$store_subs ??= {}, "$t", t)("routes.theme.resetWarning.description")
              });
            },
            size: "lg",
            children: ($$renderer5) => {
              Icon($$renderer5, { src: ArrowPath, size: "16", mini: true });
              $$renderer5.push(`<!----> ${escape_html(store_get($$store_subs ??= {}, "$t", t)("settings.reset"))}`);
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!----></div>`);
        };
        Header($$renderer3, {
          pageHeader: true,
          extended,
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.theme.title"))}`);
          }
        });
      }
      $$renderer3.push(`<!----> <div class="flex flex-col gap-4 h-full"><h3 class="relative -mb-7 z-10 left-6 font-medium text-sm bg-slate-25 dark:bg-zinc-925 w-max px-1">${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.theme.preset.presets"))}</h3> `);
      Material($$renderer3, {
        color: "uniform",
        rounding: "2xl",
        class: "overflow-auto max-h-96 relative @container",
        children: ($$renderer4) => {
          $$renderer4.push(`<div class="grid grid-cols-1 @md:grid-cols-2 @xl:grid-cols-3 @3xl:grid-cols-4 gap-2"><!--[-->`);
          const each_array = ensure_array_like(theme.data.themes);
          for (let index = 0, $$length = each_array.length; index < $$length; index++) {
            each_array[index];
            ThemePreset($$renderer4, {
              get theme() {
                return theme.data.themes[index];
              },
              set theme($$value) {
                theme.data.themes[index] = $$value;
                $$settled = false;
              }
            });
          }
          $$renderer4.push(`<!--]--> <button>`);
          Material($$renderer4, {
            color: "none",
            padding: "sm",
            class: "border-dashed border-2 border-slate-400 dark:border-zinc-600\n        text-slate-400 dark:text-zinc-600 hover:border-slate-600 dark:hover:border-zinc-400\n        grid place-items-center w-14 h-14",
            rounding: "xl",
            children: ($$renderer5) => {
              Icon($$renderer5, { src: Plus, size: "28" });
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!----></button></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      if (theme.current.id <= 0) {
        $$renderer3.push("<!--[-->");
        Note($$renderer3, {
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.theme.preset.description"))}`);
          }
        });
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> <div${attr_class("relative", void 0, {
        "opacity-50": theme.current.id <= 0,
        "pointer-events-none": theme.current.id <= 0
      })}>`);
      Material($$renderer3, {
        color: "uniform",
        class: "items-center gap-x-4 color-grid gap-y-2",
        rounding: "2xl",
        children: ($$renderer4) => {
          Header($$renderer4, {
            size: "sm",
            style: "grid-column: span 2 / span 2;",
            children: ($$renderer5) => {
              $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.theme.accent"))}`);
            }
          });
          $$renderer4.push(`<!----> `);
          ColorSwatch($$renderer4, {
            value: theme.current.colors.primary?.[900],
            onchange: (e) => {
              theme.current.colors.primary[900] = e;
            },
            oncontextmenu: (e) => {
              e.preventDefault();
              theme.current.colors.primary[900] = defaultColors.primary[900];
              return true;
            },
            class: "w-12! h-12! col-span-1"
          });
          $$renderer4.push(`<!----> `);
          ColorSwatch($$renderer4, {
            value: theme.current.colors.primary?.[100],
            onchange: (e) => {
              theme.current.colors.primary[100] = e;
            },
            oncontextmenu: (e) => {
              e.preventDefault();
              theme.current.colors.primary[100] = defaultColors.primary[100];
              return true;
            },
            class: "w-12! h-12! col-span-1"
          });
          $$renderer4.push(`<!----> <span class="font-medium text-sm -mt-2">${escape_html(store_get($$store_subs ??= {}, "$t", t)("nav.menu.colorscheme.light"))}</span> <span class="font-medium text-sm -mt-2">${escape_html(store_get($$store_subs ??= {}, "$t", t)("nav.menu.colorscheme.dark"))}</span>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-4 mt-4"><!--[-->`);
      const each_array_1 = ensure_array_like(Object.entries(defaultColors));
      for (let $$index_2 = 0, $$length = each_array_1.length; $$index_2 < $$length; $$index_2++) {
        let [category, value] = each_array_1[$$index_2];
        Material($$renderer3, {
          rounding: "2xl",
          color: "uniform",
          class: "flex flex-col gap-2",
          children: ($$renderer4) => {
            Header($$renderer4, {
              class: "capitalize",
              size: "sm",
              style: "grid-column: span 2 / span 2;",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->${escape_html(category)}`);
              }
            });
            $$renderer4.push(`<!----> <div class="flex flex-row gap-1 flex-wrap items-center space-evenly"><!--[-->`);
            const each_array_2 = ensure_array_like(Object.entries(value));
            for (let $$index_1 = 0, $$length2 = each_array_2.length; $$index_1 < $$length2; $$index_1++) {
              let [shade] = each_array_2[$$index_1];
              $$renderer4.push(`<div class="flex flex-col gap-0.5 w-10 group">`);
              ColorSwatch($$renderer4, {
                onchange: (e) => {
                  theme.current.colors[category][shade] = e;
                },
                oncontextmenu: (e) => {
                  e.preventDefault();
                  theme.current.colors[category][shade] = defaultColors[category][shade];
                  return true;
                },
                get value() {
                  return theme.current.colors[category][shade];
                },
                set value($$value) {
                  theme.current.colors[category][shade] = $$value;
                  $$settled = false;
                }
              });
              $$renderer4.push(`<!----> <span class="font-medium -mt-1 capitalize">${escape_html(shade)}</span></div>`);
            }
            $$renderer4.push(`<!--]--></div>`);
          },
          $$slots: { default: true }
        });
      }
      $$renderer3.push(`<!--]--></div></div></div>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
