import { s as store_get, e as escape_html, u as unsubscribe_stores, k as stringify, h as head, b as attr } from "../../../../chunks/index3.js";
import { p as page } from "../../../../chunks/index4.js";
import { t } from "../../../../chunks/index.js";
import { B as Button, c as client, t as toast, e as errorMessage, p as profile, N as NoSymbol, a1 as removeToast, E as Expandable, q as publishedToDate, U as UserLink, w as isCommentView, m as communityLink } from "../../../../chunks/client.svelte.js";
import { C as CommentItem } from "../../../../chunks/CommentItem.js";
import { S as Sort } from "../../../../chunks/Sort.js";
import "../../../../chunks/settings.svelte.js";
import "@sveltejs/kit";
import "lemmy-js-client";
import "openapi-fetch";
import { I as Icon } from "../../../../chunks/Icon.js";
import { A as AdjustmentsHorizontal } from "../../../../chunks/AdjustmentsHorizontal.js";
import { P as PencilSquare } from "../../../../chunks/PencilSquare.js";
import { S as Select, O as Option } from "../../../../chunks/Select.js";
import "@sveltejs/kit/internal";
import "../../../../chunks/exports.js";
import "../../../../chunks/utils.js";
import "@sveltejs/kit/internal/server";
import "@dicebear/core";
import "@dicebear/initials";
import { f as formatRelativeDate } from "../../../../chunks/RelativeDate.js";
import { P as PostItem } from "../../../../chunks/PostItem.js";
import { H as Header } from "../../../../chunks/Header.js";
import { C as CommonList } from "../../../../chunks/CommonList.js";
import { P as Pageination } from "../../../../chunks/Pageination.js";
import { P as Placeholder } from "../../../../chunks/Placeholder.js";
import { E as EntityHeader } from "../../../../chunks/EntityHeader.js";
import { I as ItemList } from "../../../../chunks/ItemList.js";
import { b as ban } from "../../../../chunks/moderation.js";
import { i as isBlocked, b as blockUser } from "../../../../chunks/index6.js";
import { T as TextInput } from "../../../../chunks/TextInput.js";
import "clsx";
import { A as AtSymbol } from "../../../../chunks/AtSymbol.js";
import { E as EllipsisHorizontal } from "../../../../chunks/EllipsisHorizontal.js";
import { F as Fire } from "../../../../chunks/Fire.js";
import { N as Newspaper } from "../../../../chunks/Newspaper.js";
import { S as ShieldCheck } from "../../../../chunks/ShieldCheck.js";
import { S as ShieldExclamation } from "../../../../chunks/ShieldExclamation.js";
import { T as Tag } from "../../../../chunks/Tag.js";
import { M as Modal } from "../../../../chunks/Modal.js";
import { M as Menu, a as MenuButton } from "../../../../chunks/MenuButton.js";
const Envelope = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M2.5 3A1.5 1.5 0 0 0 1 4.5v.793c.026.009.051.02.076.032L7.674 8.51c.206.1.446.1.652 0l6.598-3.185A.755.755 0 0 1 15 5.293V4.5A1.5 1.5 0 0 0 13.5 3h-11Z"
      },
      {
        "d": "M15 6.954 8.978 9.86a2.25 2.25 0 0 1-1.956 0L1 6.954V11.5A1.5 1.5 0 0 0 2.5 13h11a1.5 1.5 0 0 0 1.5-1.5V6.954Z"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M3 4a2 2 0 0 0-2 2v1.161l8.441 4.221a1.25 1.25 0 0 0 1.118 0L19 7.162V6a2 2 0 0 0-2-2H3Z"
      },
      {
        "d": "m19 8.839-7.77 3.885a2.75 2.75 0 0 1-2.46 0L1 8.839V14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2V8.839Z"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "M21.75 6.75v10.5a2.25 2.25 0 0 1-2.25 2.25h-15a2.25 2.25 0 0 1-2.25-2.25V6.75m19.5 0A2.25 2.25 0 0 0 19.5 4.5h-15a2.25 2.25 0 0 0-2.25 2.25m19.5 0v.243a2.25 2.25 0 0 1-1.07 1.916l-7.5 4.615a2.25 2.25 0 0 1-2.36 0L3.32 8.91a2.25 2.25 0 0 1-1.07-1.916V6.75"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M1.5 8.67v8.58a3 3 0 0 0 3 3h15a3 3 0 0 0 3-3V8.67l-8.928 5.493a3 3 0 0 1-3.144 0L1.5 8.67Z"
      },
      {
        "d": "M22.5 6.908V6.75a3 3 0 0 0-3-3h-15a3 3 0 0 0-3 3v.158l9.714 5.978a1.5 1.5 0 0 0 1.572 0L22.5 6.908Z"
      }
    ]
  }
};
function UserNote($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { note: passedNote = "", person, onsubmit } = $$props;
    let note = passedNote;
    let loading = false;
    async function submit(note2) {
      try {
        loading = note2 ? true : null;
        if (!client().setNote) throw new Error("unsupported");
        await client().setNote({ person_id: person, note: note2 });
        onsubmit?.(note2);
      } catch (err) {
        toast({ content: errorMessage(err), type: "error" });
      }
      loading = false;
    }
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      $$renderer3.push(`<form class="contents">`);
      TextInput($$renderer3, {
        label: store_get($$store_subs ??= {}, "$t", t)("nav.commands.content"),
        required: true,
        get value() {
          return note;
        },
        set value($$value) {
          note = $$value;
          $$settled = false;
        }
      });
      $$renderer3.push(`<!----> <div class="flex flex-row gap-2 *:flex-1">`);
      Button($$renderer3, {
        loading: loading === true,
        submit: true,
        color: "primary",
        size: "lg",
        children: ($$renderer4) => {
          $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.submit"))}`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      Button($$renderer3, {
        onclick: () => submit(null),
        loading: loading === null,
        color: "danger",
        size: "lg",
        children: ($$renderer4) => {
          $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("common.remove"))}`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----></div></form>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function UserActions($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { person } = $$props;
    let purgingUser = false;
    let setNote = false;
    async function purgeUser() {
      purgingUser = false;
      const purgeToast = toast({ content: "", loading: true });
      try {
        await client().purgePerson({ person_id: person.person.id });
        removeToast(purgeToast);
        toast({
          content: store_get($$store_subs ??= {}, "$t", t)("toast.purgeUser"),
          type: "success"
        });
      } catch (e) {
        toast({ content: e, type: "error" });
      }
    }
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      if (purgingUser) {
        $$renderer3.push("<!--[-->");
        {
          let customTitle = function($$renderer4) {
            $$renderer4.push(`<!---->Purging User`);
          };
          Modal($$renderer3, {
            get open() {
              return purgingUser;
            },
            set open($$value) {
              purgingUser = $$value;
              $$settled = false;
            },
            customTitle,
            children: ($$renderer4) => {
              $$renderer4.push(`<p>Purging user <span class="font-bold">${escape_html(person.person.name)}</span></p> <p>Are you sure you want to do this?</p> <div class="flex flex-row gap-2">`);
              Button($$renderer4, {
                size: "lg",
                onclick: () => purgingUser = false,
                class: "flex-1",
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->Cancel`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              Button($$renderer4, {
                size: "lg",
                color: "danger",
                onclick: purgeUser,
                class: "flex-1",
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->Purge`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----></div>`);
            },
            $$slots: { customTitle: true, default: true }
          });
        }
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      if (setNote) {
        $$renderer3.push("<!--[-->");
        {
          let customTitle = function($$renderer4) {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.user.note"))}`);
          };
          Modal($$renderer3, {
            get open() {
              return setNote;
            },
            set open($$value) {
              setNote = $$value;
              $$settled = false;
            },
            customTitle,
            children: ($$renderer4) => {
              UserNote($$renderer4, {
                person: person.person.id,
                note: person.person.note,
                onsubmit: (e) => {
                  person.person.note = e ?? void 0;
                  setNote = !setNote;
                  toast({
                    content: store_get($$store_subs ??= {}, "$t", t)("message.success"),
                    type: "success"
                  });
                }
              });
            },
            $$slots: { customTitle: true, default: true }
          });
        }
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      if (profile.current?.user && profile.current.jwt && person.person.id != profile.current.user.local_user_view.person.id) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="flex items-center gap-2 w-full flex-wrap">`);
        Button($$renderer3, {
          size: "lg",
          color: "primary",
          href: `/inbox/messages/${stringify(person.person.id)}`,
          icon: Envelope,
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("content.message"))}`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        if (person.person.matrix_user_id) {
          $$renderer3.push("<!--[-->");
          {
            let prefix = function($$renderer4) {
              Icon($$renderer4, { solid: true, size: "16", src: AtSymbol });
            };
            Button($$renderer3, {
              size: "lg",
              color: "secondary",
              href: `https://matrix.to/#/${stringify(person.person.matrix_user_id)}`,
              prefix,
              children: ($$renderer4) => {
                $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.profile.matrix"))}`);
              },
              $$slots: { prefix: true, default: true }
            });
          }
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--> `);
        if (profile.isAdmin) {
          $$renderer3.push("<!--[-->");
          {
            let target = function($$renderer4, attachment) {
              Button($$renderer4, {
                size: "square-lg",
                rounding: "2xl",
                icon: ShieldCheck,
                "aria-label": store_get($$store_subs ??= {}, "$t", t)("moderation.label")
              });
            };
            Menu($$renderer3, {
              class: "ml-auto",
              placement: "bottom-end",
              target,
              children: ($$renderer4) => {
                MenuButton($$renderer4, {
                  href: `/modlog?user=${stringify(person.person.id)}`,
                  color: "success-subtle",
                  icon: Newspaper,
                  children: ($$renderer5) => {
                    $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("moderation.modlog.user"))}`);
                  },
                  $$slots: { default: true }
                });
                $$renderer4.push(`<!----> `);
                MenuButton($$renderer4, {
                  color: "danger-subtle",
                  onclick: () => ban(person.person.banned, person.person),
                  icon: ShieldExclamation,
                  children: ($$renderer5) => {
                    $$renderer5.push(`<!---->${escape_html(person.person.banned ? "Unban" : "Ban")}`);
                  },
                  $$slots: { default: true }
                });
                $$renderer4.push(`<!----> `);
                MenuButton($$renderer4, {
                  color: "danger-subtle",
                  onclick: () => purgingUser = !purgingUser,
                  icon: Fire,
                  children: ($$renderer5) => {
                    $$renderer5.push(`<!---->Purge`);
                  },
                  $$slots: { default: true }
                });
                $$renderer4.push(`<!---->`);
              },
              $$slots: { target: true, default: true }
            });
          }
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--> `);
        {
          let target = function($$renderer4, attachment) {
            Button($$renderer4, {
              size: "square-lg",
              rounding: "2xl",
              icon: EllipsisHorizontal,
              "aria-label": store_get($$store_subs ??= {}, "$t", t)("post.actions.more.label")
            });
          };
          Menu($$renderer3, {
            placement: "bottom-end",
            target,
            children: ($$renderer4) => {
              MenuButton($$renderer4, {
                onclick: () => setNote = !setNote,
                icon: Tag,
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.user.note"))}`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              {
                let prefix = function($$renderer5) {
                  Icon($$renderer5, { mini: true, size: "16", src: NoSymbol });
                };
                MenuButton($$renderer4, {
                  color: "danger-subtle",
                  onclick: async () => {
                    const res = await blockUser(!isBlocked(profile.current.user, person.person.id), person.person.id);
                    if (res.blocked) {
                      profile.current.user.person_blocks.push({ person: person.person, target: person.person });
                    } else {
                      const index = profile.current.user.person_blocks.findIndex((i) => i.target.id == person.person.id);
                      if (index != -1) profile.current.user.person_blocks.splice(index, 1);
                    }
                  },
                  prefix,
                  children: ($$renderer5) => {
                    $$renderer5.push(`<!---->${escape_html(isBlocked(profile.current.user, person.person.id) ? "Unblock" : "Block")}`);
                  },
                  $$slots: { prefix: true, default: true }
                });
              }
              $$renderer4.push(`<!---->`);
            },
            $$slots: { target: true, default: true }
          });
        }
        $$renderer3.push(`<!----></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]-->`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { data, inline = false } = $$props;
    let sortForm = void 0;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      head($$renderer3, ($$renderer4) => {
        $$renderer4.title(($$renderer5) => {
          $$renderer5.push(`<title>${escape_html(data.person_view.value.person.name)}</title>`);
        });
      });
      $$renderer3.push(`<div class="flex flex-col gap-4 max-w-full w-full">`);
      if (!inline) {
        $$renderer3.push("<!--[-->");
        {
          let extended = function($$renderer4) {
            $$renderer4.push(`<div class="flex flex-col gap-4 max-w-full w-full min-w-0"><form${attr("action", page.url.origin + page.url.pathname)} method="GET" class="flex flex-row gap-4 flex-wrap">`);
            {
              let customLabel = function($$renderer5) {
                $$renderer5.push(`<span class="flex items-center gap-1">`);
                Icon($$renderer5, { src: AdjustmentsHorizontal, size: "15", mini: true });
                $$renderer5.push(`<!----> ${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.type"))}</span>`);
              };
              Select($$renderer4, {
                name: "type",
                onchange: () => sortForm?.requestSubmit(),
                get value() {
                  return data.filters.value.type;
                },
                set value($$value) {
                  data.filters.value.type = $$value;
                  $$settled = false;
                },
                customLabel,
                children: ($$renderer5) => {
                  Option($$renderer5, {
                    value: "all",
                    children: ($$renderer6) => {
                      $$renderer6.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("content.all"))}`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----> `);
                  Option($$renderer5, {
                    value: "posts",
                    children: ($$renderer6) => {
                      $$renderer6.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("content.posts"))}`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!----> `);
                  Option($$renderer5, {
                    value: "comments",
                    children: ($$renderer6) => {
                      $$renderer6.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("content.comments"))}`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer5.push(`<!---->`);
                },
                $$slots: { customLabel: true, default: true }
              });
            }
            $$renderer4.push(`<!----> `);
            Sort($$renderer4, {
              onchange: () => sortForm?.requestSubmit(),
              get selected() {
                return data.filters.value.sort;
              },
              set selected($$value) {
                data.filters.value.sort = $$value;
                $$settled = false;
              }
            });
            $$renderer4.push(`<!----></form></div>`);
          };
          Header($$renderer3, {
            pageHeader: true,
            class: "tracking-normal!",
            extended,
            children: ($$renderer4) => {
              $$renderer4.push(`<div class="w-full">`);
              {
                let nameDetail = function($$renderer5) {
                  $$renderer5.push(`<span class="text-sm flex gap-0 items-center w-max">@ `);
                  UserLink($$renderer5, {
                    showInstance: true,
                    user: data.person_view.value.person,
                    displayName: false,
                    class: "font-normal"
                  });
                  $$renderer5.push(`<!----></span>`);
                }, actions = function($$renderer5) {
                  UserActions($$renderer5, { person: data.person_view.value });
                };
                EntityHeader($$renderer4, {
                  avatarCircle: true,
                  avatar: data.person_view.value.person.avatar,
                  name: data.person_view.value.person.display_name || data.person_view.value.person.name,
                  banner: data.person_view.value.person.banner,
                  bio: data.person_view.value.person.bio,
                  stats: [
                    {
                      name: store_get($$store_subs ??= {}, "$t", t)("content.posts"),
                      value: data.person_view.value.counts.post_count.toString()
                    },
                    {
                      name: store_get($$store_subs ??= {}, "$t", t)("content.comments"),
                      value: data.person_view.value.counts.comment_count.toString()
                    },
                    {
                      name: store_get($$store_subs ??= {}, "$t", t)("stats.joined"),
                      value: formatRelativeDate(publishedToDate(data.person_view.value.person.published), { style: "short" }).toString(),
                      format: false
                    }
                  ],
                  nameDetail,
                  actions,
                  children: ($$renderer5) => {
                    if ((data.moderates.value ?? []).length > 0) {
                      $$renderer5.push("<!--[-->");
                      {
                        let title = function($$renderer6) {
                          $$renderer6.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.profile.moderates"))} <hr class="flex-1 w-full border-slate-200 dark:border-zinc-800 mx-3"/>`);
                        };
                        Expandable($$renderer5, {
                          class: "",
                          title,
                          children: ($$renderer6) => {
                            ItemList($$renderer6, {
                              items: data.moderates.value.map((m) => ({
                                id: m.community.id,
                                name: m.community.title,
                                url: communityLink(m.community),
                                avatar: m.community.icon,
                                instance: new URL(m.community.actor_id).hostname
                              }))
                            });
                          },
                          $$slots: { title: true, default: true }
                        });
                      }
                    } else {
                      $$renderer5.push("<!--[!-->");
                    }
                    $$renderer5.push(`<!--]-->`);
                  },
                  $$slots: { nameDetail: true, actions: true, default: true }
                });
              }
              $$renderer4.push(`<!----></div>`);
            }
          });
        }
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      if (data.items.value.length == 0) {
        $$renderer3.push("<!--[-->");
        Placeholder($$renderer3, {
          icon: PencilSquare,
          title: "No submissions",
          description: "This user has no submissions that match this filter."
        });
      } else {
        $$renderer3.push("<!--[!-->");
        {
          let item = function($$renderer4, item2) {
            if (isCommentView(item2)) {
              $$renderer4.push("<!--[-->");
              CommentItem($$renderer4, { comment: item2 });
            } else {
              $$renderer4.push("<!--[!-->");
              if (!isCommentView(item2)) {
                $$renderer4.push("<!--[-->");
                PostItem($$renderer4, { post: item2 });
              } else {
                $$renderer4.push("<!--[!-->");
              }
              $$renderer4.push(`<!--]-->`);
            }
            $$renderer4.push(`<!--]-->`);
          };
          CommonList($$renderer3, { items: data.items.value, item });
        }
      }
      $$renderer3.push(`<!--]--> `);
      Pageination($$renderer3, {
        href: (page2) => `?page=${page2}`,
        get page() {
          return data.filters.value.page;
        },
        set page($$value) {
          data.filters.value.page = $$value;
          $$settled = false;
        }
      });
      $$renderer3.push(`<!----></div>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
