import { e as escape_html } from "../../../../chunks/index3.js";
import "clsx";
import { I as placeholders, B as Button } from "../../../../chunks/client.svelte.js";
import "../../../../chunks/index.js";
import "@sveltejs/kit/internal";
import "../../../../chunks/exports.js";
import "../../../../chunks/utils.js";
import "@sveltejs/kit/internal/server";
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let post = placeholders.get("post");
    let comment = placeholders.get("comment");
    let url = placeholders.get("url");
    $$renderer2.push(`<h1 class="font-bold text-2xl">Placeholders</h1> <p>Photon randomly generates placeholders for use in text inputs and stuff. If
  you have "Random Placeholders" disabled in settings, they will be empty.</p> <h2 class="font-bold text-xl mt-4">Posts</h2> <p>${escape_html(post)}</p> `);
    Button($$renderer2, {
      onclick: () => post = placeholders.get("post"),
      class: "w-max",
      children: ($$renderer3) => {
        $$renderer3.push(`<!---->Generate`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----> <h2 class="font-bold text-xl mt-4">Comments</h2> <p>${escape_html(comment)}</p> `);
    Button($$renderer2, {
      onclick: () => comment = placeholders.get("comment"),
      class: "w-max",
      children: ($$renderer3) => {
        $$renderer3.push(`<!---->Generate`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----> <h2 class="font-bold text-xl mt-4">Urls</h2> <p>${escape_html(url)}</p> `);
    Button($$renderer2, {
      onclick: () => url = placeholders.get("url"),
      class: "w-max",
      children: ($$renderer3) => {
        $$renderer3.push(`<!---->Generate`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!---->`);
  });
}
export {
  _page as default
};
//# sourceMappingURL=_page.svelte.js.map
