declare module '@svelte-put/qr' {
	import type { qr } from 'headless-qr';
	/**
	 * create SVG parts that make up a QR. You should typically use {@link createQrSvgString} instead
	 * */
	export function createQrSvgParts(config: QRConfig, qr?: QRCode): QRSVGParts;
	/**
	 * create QR as an SVG string
	 * */
	export function createQrSvgString(config: QRConfig & Partial<SizeAttributes>): string;
	/**
	 * create QR as a base64 data URL (image/svg+xml)
	 * */
	export function createQrSvgDataUrl(config: QRConfig & Partial<SizeAttributes>): string;

	export function createQrPngDataUrl(config: CreateQrPngDataUrlConfig): Promise<string>;
	type QRCode = ReturnType<typeof qr>;
	type QRCodeOptions = NonNullable<Parameters<typeof qr>[1]>;

	/**
	 * instructions to render a QR
	 */
	type QRConfig = {
		/** the data to encode in QR, typically an URL */
		data: string;
		/**
		 * the quite zone along the edges of QR
		 */
		margin?: number;
		/**
		 * determine what shape to render the elements
		 *
		 * - `square` (default): each module or anchor is a sharp-edged square
		 * - `circle`: each module is a circle, each anchor is a round-edged square
		 */
		shape?: 'square' | 'circle';
		/**
		 * logo to render in the middle of QR
		 */
		logo?: string;
		/** width : height */
		logoRatio?: number;

		/* styling */
		/** fill for each module */
		moduleFill?: string;
		/** fill for the outer ring of each anchor (big positioning square at the corners) */
		anchorOuterFill?: string;
		/** fill for the inner square of each anchor */
		anchorInnerFill?: string;
		/**
		 * Type number (1 ~ 40), or 0 for auto detection,
		 * passed as option to {@link https://github.com/Rich-Harris/headless-qr | headless-qr},
		 * default to 0,
		 */
		version?: QRCodeOptions['version'];
		/**
		 * Error correction level, one of {'L', 'M', 'Q', 'H'},
		 * passed as option to {@link https://github.com/Rich-Harris/headless-qr | headless-qr},
		 * default to M,
		 */
		correction?: QRCodeOptions['correction'];

		/**
		 * @deprecated use `version` instead
		 */
		typeNumber?: QRCodeOptions['version'];
		/**
		 * @deprecated use `correction` instead
		 */
		errorCorrectionLevel?: QRCodeOptions['correction'];
	};

	type QRSVGParts = {
		attributes: {
			viewBox: string;
			xmlns: string;
			version: string;
		};
		anchors: string;
		modules: string;
		logo: string;
	};

	type CreateQrPngDataUrlConfig = QRConfig &
		SizeAttributes & {
			backgroundFill?: string;
		};
	type SizeAttributes = {
		width: number;
		height: number;
	};

	export {};
}

declare module '@svelte-put/qr/img' {
	import type { ActionReturn, Action } from 'svelte/action';
	import type { qr as qr_1 } from 'headless-qr';
	/**
	 * Fetch a remote image and convert to base64 string
	 * */
	export function toDataURL(url: string): Promise<string>;
	/**
	 * Svelte action for rendering a QR as base64 data URL into the src attribute of this HTMLImageElement
	 * */
	export function qr(node: HTMLImageElement, param: ImgQRParameter): ImgQRActionReturn;
	export type ImgQRParameter = QRConfig &
		SizeAttributes & {
			/** background of the generated png. Default to transparent */
			backgroundFill?: string;
		};

	/** Configurations available for */
	export type ImgQRAttributes = {
		onqrinit?: (event: CustomEvent<HTMLImageElement>) => void;
	};
	export type ImgQRAction = Action<HTMLImageElement, ImgQRParameter, ImgQRAttributes>;
	export type ImgQRActionReturn = ActionReturn<ImgQRParameter, ImgQRAttributes>;
	type SizeAttributes = {
		width: number;
		height: number;
	};
	type QRCodeOptions = NonNullable<Parameters<typeof qr_1>[1]>;

	/**
	 * instructions to render a QR
	 */
	type QRConfig = {
		/** the data to encode in QR, typically an URL */
		data: string;
		/**
		 * the quite zone along the edges of QR
		 */
		margin?: number;
		/**
		 * determine what shape to render the elements
		 *
		 * - `square` (default): each module or anchor is a sharp-edged square
		 * - `circle`: each module is a circle, each anchor is a round-edged square
		 */
		shape?: 'square' | 'circle';
		/**
		 * logo to render in the middle of QR
		 */
		logo?: string;
		/** width : height */
		logoRatio?: number;

		/* styling */
		/** fill for each module */
		moduleFill?: string;
		/** fill for the outer ring of each anchor (big positioning square at the corners) */
		anchorOuterFill?: string;
		/** fill for the inner square of each anchor */
		anchorInnerFill?: string;
		/**
		 * Type number (1 ~ 40), or 0 for auto detection,
		 * passed as option to {@link https://github.com/Rich-Harris/headless-qr | headless-qr},
		 * default to 0,
		 */
		version?: QRCodeOptions['version'];
		/**
		 * Error correction level, one of {'L', 'M', 'Q', 'H'},
		 * passed as option to {@link https://github.com/Rich-Harris/headless-qr | headless-qr},
		 * default to M,
		 */
		correction?: QRCodeOptions['correction'];

		/**
		 * @deprecated use `version` instead
		 */
		typeNumber?: QRCodeOptions['version'];
		/**
		 * @deprecated use `correction` instead
		 */
		errorCorrectionLevel?: QRCodeOptions['correction'];
	};

	export {};
}

declare module '@svelte-put/qr/svg' {
	import type { ActionReturn, Action } from 'svelte/action';
	import type { qr as qr_1 } from 'headless-qr';
	/**
	 * Svelte action for rendering a QR as innerHTML of this SVGElement
	 * */
	export function qr(node: SVGElement, param: SvgQRParameter): SvgQRActionReturn;
	export type SvgQRParameter = QRConfig;
	export type SvgQRAttributes = {
		onqrinit?: (event: CustomEvent<SVGElement>) => void;
	};
	export type SvgQRAction = Action<SVGElement, SvgQRParameter, SvgQRAttributes>;
	export type SvgQRActionReturn = ActionReturn<SvgQRParameter, SvgQRAttributes>;
	type QRCodeOptions = NonNullable<Parameters<typeof qr_1>[1]>;

	/**
	 * instructions to render a QR
	 */
	type QRConfig = {
		/** the data to encode in QR, typically an URL */
		data: string;
		/**
		 * the quite zone along the edges of QR
		 */
		margin?: number;
		/**
		 * determine what shape to render the elements
		 *
		 * - `square` (default): each module or anchor is a sharp-edged square
		 * - `circle`: each module is a circle, each anchor is a round-edged square
		 */
		shape?: 'square' | 'circle';
		/**
		 * logo to render in the middle of QR
		 */
		logo?: string;
		/** width : height */
		logoRatio?: number;

		/* styling */
		/** fill for each module */
		moduleFill?: string;
		/** fill for the outer ring of each anchor (big positioning square at the corners) */
		anchorOuterFill?: string;
		/** fill for the inner square of each anchor */
		anchorInnerFill?: string;
		/**
		 * Type number (1 ~ 40), or 0 for auto detection,
		 * passed as option to {@link https://github.com/Rich-Harris/headless-qr | headless-qr},
		 * default to 0,
		 */
		version?: QRCodeOptions['version'];
		/**
		 * Error correction level, one of {'L', 'M', 'Q', 'H'},
		 * passed as option to {@link https://github.com/Rich-Harris/headless-qr | headless-qr},
		 * default to M,
		 */
		correction?: QRCodeOptions['correction'];

		/**
		 * @deprecated use `version` instead
		 */
		typeNumber?: QRCodeOptions['version'];
		/**
		 * @deprecated use `correction` instead
		 */
		errorCorrectionLevel?: QRCodeOptions['correction'];
	};

	export {};
}

//# sourceMappingURL=index.d.ts.map