import { Parser as Parser$1, Config as Config$1 } from '@sveltekit-i18n/base';

declare const eq: Modifier.T;
declare const ne: Modifier.T;
declare const lt: Modifier.T;
declare const gt: Modifier.T;
declare const lte: Modifier.T;
declare const gte: Modifier.T;
declare const number: Modifier.T<Modifier.NumberProps>;
declare const date: Modifier.T<Modifier.DateProps>;
declare const ago: Modifier.T<Modifier.AgoProps>;
declare const currency: Modifier.T<Modifier.CurrencyProps>;

declare const modifiers_ago: typeof ago;
declare const modifiers_currency: typeof currency;
declare const modifiers_date: typeof date;
declare const modifiers_eq: typeof eq;
declare const modifiers_gt: typeof gt;
declare const modifiers_gte: typeof gte;
declare const modifiers_lt: typeof lt;
declare const modifiers_lte: typeof lte;
declare const modifiers_ne: typeof ne;
declare const modifiers_number: typeof number;
declare namespace modifiers {
  export {
    modifiers_ago as ago,
    modifiers_currency as currency,
    modifiers_date as date,
    modifiers_eq as eq,
    modifiers_gt as gt,
    modifiers_gte as gte,
    modifiers_lt as lt,
    modifiers_lte as lte,
    modifiers_ne as ne,
    modifiers_number as number,
  };
}

type CommonProps<CustomModifierProps = Modifier.DefaultProps> = {
    value: any;
    props?: CustomModifierProps;
    locale?: Config$1.Locale;
    parserOptions?: Parser.Options;
};
declare module Modifier {
    type Key = string;
    type DefaultKeys = keyof typeof modifiers;
    type AgoProps = {
        ago?: Intl.RelativeTimeFormatOptions & {
            format?: Intl.RelativeTimeFormatUnit | 'auto';
        };
    };
    type DateProps = {
        date?: Intl.DateTimeFormatOptions;
    };
    type NumberProps = {
        number?: Intl.NumberFormatOptions;
    };
    type CurrencyProps = {
        currency?: Intl.NumberFormatOptions & {
            ratio?: number;
        };
    };
    type DefaultProps = NumberProps & AgoProps & DateProps & CurrencyProps;
    type Props<T = DefaultProps> = T & DefaultProps;
    type ModifierOption = Record<'key' | 'value', string>;
    type DefaultValue = string | undefined;
    type T<CustomModifierProps = any> = (config: CommonProps<CustomModifierProps> & {
        options: ModifierOption[];
        defaultValue?: DefaultValue;
    }) => string;
    type DefaultModifiers = typeof modifiers;
    type CustomModifiers<K extends string = any, ModifierProps = any> = Record<K, Modifier.T<ModifierProps>>;
}
declare module Parser {
    type Options<Key extends string = Modifier.Key, Props = any> = {
        customModifiers?: Modifier.CustomModifiers<Key, Props>;
        modifierDefaults?: Modifier.DefaultProps;
    } | undefined;
    type PayloadDefault = {
        [key in 'default']?: any;
    };
    type Payload<T = any> = T & PayloadDefault;
    type Params<P = PayloadDefault, M = Modifier.DefaultProps> = [payload?: Payload<P>, props?: Modifier.Props<M>];
    type T<Params extends Parser$1.Params = Parser.Params> = Parser$1.T<Params>;
    type Factory = <O extends string = string, Props = {}, Payload = {}>(options?: Parser.Options<O, Props>) => Parser.T<Parser.Params<Payload & PayloadDefault, Props & Modifier.DefaultProps>>;
}
type Config<P = Parser.PayloadDefault, M = Modifier.DefaultProps> = Config$1.T<Parser.Params<P, M>>;

declare const parser: Parser.Factory;

export { Config, Modifier, Parser, parser as default };
