// see: https://github.com/sveltejs/svelte/blob/a129592e5b248a734a68da6e9028941803a3d063/packages/svelte/elements.d.ts#L83
export const EVENT_NAMES = [
    // Clipboard Events
    'on:copy',
    'oncopy',
    'oncopycapture',
    'on:cut',
    'oncut',
    'oncutcapture',
    'on:paste',
    'onpaste',
    'onpastecapture',
    // Composition Events
    'on:compositionend',
    'oncompositionend',
    'oncompositionendcapture',
    'on:compositionstart',
    'oncompositionstart',
    'oncompositionstartcapture',
    'on:compositionupdate',
    'oncompositionupdate',
    'oncompositionupdatecapture',
    // Focus Events
    'on:focus',
    'onfocus',
    'onfocuscapture',
    'on:focusin',
    'onfocusin',
    'onfocusincapture',
    'on:focusout',
    'onfocusout',
    'onfocusoutcapture',
    'on:blur',
    'onblur',
    'onblurcapture',
    // Form Events
    'on:change',
    'onchange',
    'onchangecapture',
    'on:beforeinput',
    'onbeforeinput',
    'onbeforeinputcapture',
    // oninput can be either an InputEvent or an Event, depending on the target element (input, textarea etc).
    'on:input',
    'oninput',
    'oninputcapture',
    'on:reset',
    'onreset',
    'onresetcapture',
    'on:submit',
    'onsubmit',
    'onsubmitcapture',
    'on:invalid',
    'oninvalid',
    'oninvalidcapture',
    'on:formdata',
    'onformdata',
    'onformdatacapture',
    // Image Events
    'on:load',
    'onload',
    'onloadcapture',
    'on:error',
    'onerror',
    'onerrorcapture',
    // Popover Events
    'on:beforetoggle',
    'onbeforetoggle',
    'onbeforetogglecapture',
    'on:toggle',
    'ontoggle',
    'ontogglecapture',
    // Content visibility Events
    'on:contentvisibilityautostatechange',
    'oncontentvisibilityautostatechange',
    'oncontentvisibilityautostatechangecapture',
    // Keyboard Events
    'on:keydown',
    'onkeydown',
    'onkeydowncapture',
    'on:keypress',
    'onkeypress',
    'onkeypresscapture',
    'on:keyup',
    'onkeyup',
    'onkeyupcapture',
    // Media Events
    'on:abort',
    'onabort',
    'onabortcapture',
    'on:canplay',
    'oncanplay',
    'oncanplaycapture',
    'on:canplaythrough',
    'oncanplaythrough',
    'oncanplaythroughcapture',
    'on:cuechange',
    'oncuechange',
    'oncuechangecapture',
    'on:durationchange',
    'ondurationchange',
    'ondurationchangecapture',
    'on:emptied',
    'onemptied',
    'onemptiedcapture',
    'on:encrypted',
    'onencrypted',
    'onencryptedcapture',
    'on:ended',
    'onended',
    'onendedcapture',
    'on:loadeddata',
    'onloadeddata',
    'onloadeddatacapture',
    'on:loadedmetadata',
    'onloadedmetadata',
    'onloadedmetadatacapture',
    'on:loadstart',
    'onloadstart',
    'onloadstartcapture',
    'on:pause',
    'onpause',
    'onpausecapture',
    'on:play',
    'onplay',
    'onplaycapture',
    'on:playing',
    'onplaying',
    'onplayingcapture',
    'on:progress',
    'onprogress',
    'onprogresscapture',
    'on:ratechange',
    'onratechange',
    'onratechangecapture',
    'on:seeked',
    'onseeked',
    'onseekedcapture',
    'on:seeking',
    'onseeking',
    'onseekingcapture',
    'on:stalled',
    'onstalled',
    'onstalledcapture',
    'on:suspend',
    'onsuspend',
    'onsuspendcapture',
    'on:timeupdate',
    'ontimeupdate',
    'ontimeupdatecapture',
    'on:volumechange',
    'onvolumechange',
    'onvolumechangecapture',
    'on:waiting',
    'onwaiting',
    'onwaitingcapture',
    // MouseEvents
    'on:auxclick',
    'onauxclick',
    'onauxclickcapture',
    'on:click',
    'onclick',
    'onclickcapture',
    'on:contextmenu',
    'oncontextmenu',
    'oncontextmenucapture',
    'on:dblclick',
    'ondblclick',
    'ondblclickcapture',
    'on:drag',
    'ondrag',
    'ondragcapture',
    'on:dragend',
    'ondragend',
    'ondragendcapture',
    'on:dragenter',
    'ondragenter',
    'ondragentercapture',
    'on:dragexit',
    'ondragexit',
    'ondragexitcapture',
    'on:dragleave',
    'ondragleave',
    'ondragleavecapture',
    'on:dragover',
    'ondragover',
    'ondragovercapture',
    'on:dragstart',
    'ondragstart',
    'ondragstartcapture',
    'on:drop',
    'ondrop',
    'ondropcapture',
    'on:mousedown',
    'onmousedown',
    'onmousedowncapture',
    'on:mouseenter',
    'onmouseenter',
    'on:mouseleave',
    'onmouseleave',
    'on:mousemove',
    'onmousemove',
    'onmousemovecapture',
    'on:mouseout',
    'onmouseout',
    'onmouseoutcapture',
    'on:mouseover',
    'onmouseover',
    'onmouseovercapture',
    'on:mouseup',
    'onmouseup',
    'onmouseupcapture',
    // Selection Events
    'on:select',
    'onselect',
    'onselectcapture',
    'on:selectionchange',
    'onselectionchange',
    'onselectionchangecapture',
    'on:selectstart',
    'onselectstart',
    'onselectstartcapture',
    // Touch Events
    'on:touchcancel',
    'ontouchcancel',
    'ontouchcancelcapture',
    'on:touchend',
    'ontouchend',
    'ontouchendcapture',
    'on:touchmove',
    'ontouchmove',
    'ontouchmovecapture',
    'on:touchstart',
    'ontouchstart',
    'ontouchstartcapture',
    // Pointer Events
    'on:gotpointercapture',
    'ongotpointercapture',
    'ongotpointercapturecapture',
    'on:pointercancel',
    'onpointercancel',
    'onpointercancelcapture',
    'on:pointerdown',
    'onpointerdown',
    'onpointerdowncapture',
    'on:pointerenter',
    'onpointerenter',
    'onpointerentercapture',
    'on:pointerleave',
    'onpointerleave',
    'onpointerleavecapture',
    'on:pointermove',
    'onpointermove',
    'onpointermovecapture',
    'on:pointerout',
    'onpointerout',
    'onpointeroutcapture',
    'on:pointerover',
    'onpointerover',
    'onpointerovercapture',
    'on:pointerup',
    'onpointerup',
    'onpointerupcapture',
    'on:lostpointercapture',
    'onlostpointercapture',
    'onlostpointercapturecapture',
    // Gamepad Events
    'on:gamepadconnected',
    'ongamepadconnected',
    'on:gamepaddisconnected',
    'ongamepaddisconnected',
    // UI Events
    'on:scroll',
    'onscroll',
    'onscrollcapture',
    'on:scrollend',
    'onscrollend',
    'onscrollendcapture',
    'on:resize',
    'onresize',
    'onresizecapture',
    // Wheel Events
    'on:wheel',
    'onwheel',
    'onwheelcapture',
    // Animation Events
    'on:animationstart',
    'onanimationstart',
    'onanimationstartcapture',
    'on:animationend',
    'onanimationend',
    'onanimationendcapture',
    'on:animationiteration',
    'onanimationiteration',
    'onanimationiterationcapture',
    // Transition Events
    'on:transitionstart',
    'ontransitionstart',
    'ontransitionstartcapture',
    'on:transitionrun',
    'ontransitionrun',
    'ontransitionruncapture',
    'on:transitionend',
    'ontransitionend',
    'ontransitionendcapture',
    'on:transitioncancel',
    'ontransitioncancel',
    'ontransitioncancelcapture',
    // Svelte Transition Events
    'on:outrostart',
    'onoutrostart',
    'onoutrostartcapture',
    'on:outroend',
    'onoutroend',
    'onoutroendcapture',
    'on:introstart',
    'onintrostart',
    'onintrostartcapture',
    'on:introend',
    'onintroend',
    'onintroendcapture',
    // Message Events
    'on:message',
    'onmessage',
    'onmessagecapture',
    'on:messageerror',
    'onmessageerror',
    'onmessageerrorcapture',
    // Document Events
    'on:visibilitychange',
    'onvisibilitychange',
    'onvisibilitychangecapture',
    // Global Events
    'on:beforematch',
    'onbeforematch',
    'onbeforematchcapture',
    'on:cancel',
    'oncancel',
    'oncancelcapture',
    'on:close',
    'onclose',
    'onclosecapture',
    'on:fullscreenchange',
    'onfullscreenchange',
    'onfullscreenchangecapture',
    'on:fullscreenerror',
    'onfullscreenerror',
    'onfullscreenerrorcapture'
];
