import { createRequire } from "node:module";
var __create = Object.create;
var __getProtoOf = Object.getPrototypeOf;
var __defProp = Object.defineProperty;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __toESM = (mod, isNodeMode, target) => {
  target = mod != null ? __create(__getProtoOf(mod)) : {};
  const to = isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target;
  for (let key of __getOwnPropNames(mod))
    if (!__hasOwnProp.call(to, key))
      __defProp(to, key, {
        get: () => mod[key],
        enumerable: true
      });
  return to;
};
var __commonJS = (cb, mod) => () => (mod || cb((mod = { exports: {} }).exports, mod), mod.exports);
var __require = /* @__PURE__ */ createRequire(import.meta.url);

// node_modules/globrex/index.js
var require_globrex = __commonJS((exports, module) => {
  var isWin = process.platform === "win32";
  var SEP = isWin ? `\\\\+` : `\\/`;
  var SEP_ESC = isWin ? `\\\\` : `/`;
  var GLOBSTAR = `((?:[^/]*(?:/|$))*)`;
  var WILDCARD = `([^/]*)`;
  var GLOBSTAR_SEGMENT = `((?:[^${SEP_ESC}]*(?:${SEP_ESC}|$))*)`;
  var WILDCARD_SEGMENT = `([^${SEP_ESC}]*)`;
  function globrex(glob, { extended = false, globstar = false, strict = false, filepath = false, flags = "" } = {}) {
    let regex = "";
    let segment = "";
    let path = { regex: "", segments: [] };
    let inGroup = false;
    let inRange = false;
    const ext = [];
    function add(str, { split, last, only } = {}) {
      if (only !== "path")
        regex += str;
      if (filepath && only !== "regex") {
        path.regex += str === "\\/" ? SEP : str;
        if (split) {
          if (last)
            segment += str;
          if (segment !== "") {
            if (!flags.includes("g"))
              segment = `^${segment}$`;
            path.segments.push(new RegExp(segment, flags));
          }
          segment = "";
        } else {
          segment += str;
        }
      }
    }
    let c, n;
    for (let i = 0;i < glob.length; i++) {
      c = glob[i];
      n = glob[i + 1];
      if (["\\", "$", "^", ".", "="].includes(c)) {
        add(`\\${c}`);
        continue;
      }
      if (c === "/") {
        add(`\\${c}`, { split: true });
        if (n === "/" && !strict)
          regex += "?";
        continue;
      }
      if (c === "(") {
        if (ext.length) {
          add(c);
          continue;
        }
        add(`\\${c}`);
        continue;
      }
      if (c === ")") {
        if (ext.length) {
          add(c);
          let type = ext.pop();
          if (type === "@") {
            add("{1}");
          } else if (type === "!") {
            add("([^/]*)");
          } else {
            add(type);
          }
          continue;
        }
        add(`\\${c}`);
        continue;
      }
      if (c === "|") {
        if (ext.length) {
          add(c);
          continue;
        }
        add(`\\${c}`);
        continue;
      }
      if (c === "+") {
        if (n === "(" && extended) {
          ext.push(c);
          continue;
        }
        add(`\\${c}`);
        continue;
      }
      if (c === "@" && extended) {
        if (n === "(") {
          ext.push(c);
          continue;
        }
      }
      if (c === "!") {
        if (extended) {
          if (inRange) {
            add("^");
            continue;
          }
          if (n === "(") {
            ext.push(c);
            add("(?!");
            i++;
            continue;
          }
          add(`\\${c}`);
          continue;
        }
        add(`\\${c}`);
        continue;
      }
      if (c === "?") {
        if (extended) {
          if (n === "(") {
            ext.push(c);
          } else {
            add(".");
          }
          continue;
        }
        add(`\\${c}`);
        continue;
      }
      if (c === "[") {
        if (inRange && n === ":") {
          i++;
          let value = "";
          while (glob[++i] !== ":")
            value += glob[i];
          if (value === "alnum")
            add("(\\w|\\d)");
          else if (value === "space")
            add("\\s");
          else if (value === "digit")
            add("\\d");
          i++;
          continue;
        }
        if (extended) {
          inRange = true;
          add(c);
          continue;
        }
        add(`\\${c}`);
        continue;
      }
      if (c === "]") {
        if (extended) {
          inRange = false;
          add(c);
          continue;
        }
        add(`\\${c}`);
        continue;
      }
      if (c === "{") {
        if (extended) {
          inGroup = true;
          add("(");
          continue;
        }
        add(`\\${c}`);
        continue;
      }
      if (c === "}") {
        if (extended) {
          inGroup = false;
          add(")");
          continue;
        }
        add(`\\${c}`);
        continue;
      }
      if (c === ",") {
        if (inGroup) {
          add("|");
          continue;
        }
        add(`\\${c}`);
        continue;
      }
      if (c === "*") {
        if (n === "(" && extended) {
          ext.push(c);
          continue;
        }
        let prevChar = glob[i - 1];
        let starCount = 1;
        while (glob[i + 1] === "*") {
          starCount++;
          i++;
        }
        let nextChar = glob[i + 1];
        if (!globstar) {
          add(".*");
        } else {
          let isGlobstar = starCount > 1 && (prevChar === "/" || prevChar === undefined) && (nextChar === "/" || nextChar === undefined);
          if (isGlobstar) {
            add(GLOBSTAR, { only: "regex" });
            add(GLOBSTAR_SEGMENT, { only: "path", last: true, split: true });
            i++;
          } else {
            add(WILDCARD, { only: "regex" });
            add(WILDCARD_SEGMENT, { only: "path" });
          }
        }
        continue;
      }
      add(c);
    }
    if (!flags.includes("g")) {
      regex = `^${regex}$`;
      segment = `^${segment}$`;
      if (filepath)
        path.regex = `^${path.regex}$`;
    }
    const result = { regex: new RegExp(regex, flags) };
    if (filepath) {
      path.segments.push(new RegExp(segment, flags));
      path.regex = new RegExp(path.regex, flags);
      path.globstar = new RegExp(!flags.includes("g") ? `^${GLOBSTAR_SEGMENT}$` : GLOBSTAR_SEGMENT, flags);
      result.path = path;
    }
    return result;
  }
  module.exports = globrex;
});

// node_modules/globalyzer/src/index.js
var require_src = __commonJS((exports, module) => {
  var os = __require("os");
  var path = __require("path");
  var isWin = os.platform() === "win32";
  var CHARS = { "{": "}", "(": ")", "[": "]" };
  var STRICT = /\\(.)|(^!|\*|[\].+)]\?|\[[^\\\]]+\]|\{[^\\}]+\}|\(\?[:!=][^\\)]+\)|\([^|]+\|[^\\)]+\)|(\\).|([@?!+*]\(.*\)))/;
  var RELAXED = /\\(.)|(^!|[*?{}()[\]]|\(\?)/;
  function isglob(str, { strict = true } = {}) {
    if (str === "")
      return false;
    let match, rgx = strict ? STRICT : RELAXED;
    while (match = rgx.exec(str)) {
      if (match[2])
        return true;
      let idx = match.index + match[0].length;
      let open = match[1];
      let close = open ? CHARS[open] : null;
      if (open && close) {
        let n = str.indexOf(close, idx);
        if (n !== -1)
          idx = n + 1;
      }
      str = str.slice(idx);
    }
    return false;
  }
  function parent(str, { strict = false } = {}) {
    if (isWin && str.includes("/"))
      str = str.split("\\").join("/");
    if (/[\{\[].*[\/]*.*[\}\]]$/.test(str))
      str += "/";
    str += "a";
    do {
      str = path.dirname(str);
    } while (isglob(str, { strict }) || /(^|[^\\])([\{\[]|\([^\)]+$)/.test(str));
    return str.replace(/\\([\*\?\|\[\]\(\)\{\}])/g, "$1");
  }
  function globalyzer(pattern, opts = {}) {
    let base = parent(pattern, opts);
    let isGlob = isglob(pattern, opts);
    let glob;
    if (base != ".") {
      glob = pattern.substr(base.length);
      if (glob.startsWith("/"))
        glob = glob.substr(1);
    } else {
      glob = pattern;
    }
    if (!isGlob) {
      base = path.dirname(pattern);
      glob = base !== "." ? pattern.substr(base.length) : pattern;
    }
    if (glob.startsWith("./"))
      glob = glob.substr(2);
    if (glob.startsWith("/"))
      glob = glob.substr(1);
    return { base, glob, isGlob };
  }
  module.exports = globalyzer;
});

// node_modules/tiny-glob/index.js
var require_tiny_glob = __commonJS((exports, module) => {
  var fs = __require("fs");
  var globrex = require_globrex();
  var { promisify } = __require("util");
  var globalyzer = require_src();
  var { join, resolve, relative } = __require("path");
  var isHidden = /(^|[\\\/])\.[^\\\/\.]/g;
  var readdir = promisify(fs.readdir);
  var stat = promisify(fs.stat);
  var CACHE = {};
  async function walk(output, prefix, lexer, opts, dirname = "", level = 0) {
    const rgx = lexer.segments[level];
    const dir = resolve(opts.cwd, prefix, dirname);
    const files = await readdir(dir);
    const { dot, filesOnly } = opts;
    let i = 0, len = files.length, file;
    let fullpath, relpath, stats, isMatch;
    for (;i < len; i++) {
      fullpath = join(dir, file = files[i]);
      relpath = dirname ? join(dirname, file) : file;
      if (!dot && isHidden.test(relpath))
        continue;
      isMatch = lexer.regex.test(relpath);
      if ((stats = CACHE[relpath]) === undefined) {
        CACHE[relpath] = stats = fs.lstatSync(fullpath);
      }
      if (!stats.isDirectory()) {
        isMatch && output.push(relative(opts.cwd, fullpath));
        continue;
      }
      if (rgx && !rgx.test(file))
        continue;
      !filesOnly && isMatch && output.push(join(prefix, relpath));
      await walk(output, prefix, lexer, opts, relpath, rgx && rgx.toString() !== lexer.globstar && level + 1);
    }
  }
  module.exports = async function(str, opts = {}) {
    if (!str)
      return [];
    let glob = globalyzer(str);
    opts.cwd = opts.cwd || ".";
    if (!glob.isGlob) {
      try {
        let resolved = resolve(opts.cwd, str);
        let dirent = await stat(resolved);
        if (opts.filesOnly && !dirent.isFile())
          return [];
        return opts.absolute ? [resolved] : [str];
      } catch (err) {
        if (err.code != "ENOENT")
          throw err;
        return [];
      }
    }
    if (opts.flush)
      CACHE = {};
    let matches = [];
    const { path } = globrex(glob.glob, { filepath: true, globstar: true, extended: true });
    path.globstar = path.globstar.toString();
    await walk(matches, glob.base, path, opts, ".", 0);
    return opts.absolute ? matches.map((x) => resolve(opts.cwd, x)) : matches;
  };
});

// src/adapter/steps/compress.ts
var import_tiny_glob = __toESM(require_tiny_glob(), 1);
import { createReadStream, createWriteStream, existsSync, statSync } from "node:fs";
import { pipeline } from "node:stream";
import { promisify } from "node:util";
import zlib from "node:zlib";
var pipe = promisify(pipeline);
async function compressAll(to_compress) {
  await Promise.all(to_compress.map((params) => compress(...params)));
}
async function compress(directory, options) {
  if (!existsSync(directory)) {
    return;
  }
  const optionsObj = typeof options === "boolean" ? {} : options;
  const filesExt = optionsObj.files ?? ["html", "js", "json", "css", "svg", "xml", "wasm"];
  const files = await import_tiny_glob.default(`**/*.{${filesExt.join(",")}}`, {
    cwd: directory,
    dot: true,
    absolute: true,
    filesOnly: true
  });
  const doBr = options === true || optionsObj.brotli === true;
  const doGz = options === true || optionsObj.gzip === true;
  try {
    const compressionTasks = files.flatMap((file) => {
      const tasks = [];
      if (doGz)
        tasks.push(compress_file(file, "gz"));
      if (doBr)
        tasks.push(compress_file(file, "br"));
      return tasks;
    });
    await Promise.all(compressionTasks);
  } catch (error) {
    console.error(`Error compressing files: ${error.message}`);
  }
}
async function compress_file(file, format = "gz") {
  try {
    const fileSize = statSync(file).size;
    const compress2 = format === "br" ? zlib.createBrotliCompress({
      params: {
        [zlib.constants.BROTLI_PARAM_MODE]: zlib.constants.BROTLI_MODE_TEXT,
        [zlib.constants.BROTLI_PARAM_QUALITY]: zlib.constants.BROTLI_MAX_QUALITY,
        [zlib.constants.BROTLI_PARAM_SIZE_HINT]: fileSize
      }
    }) : zlib.createGzip({ level: zlib.constants.Z_BEST_COMPRESSION });
    const source = createReadStream(file);
    const destination = createWriteStream(`${file}.${format}`);
    await pipe(source, compress2, destination);
  } catch (error) {
    console.error(`Error compressing ${file} to ${format}: ${error.message}`);
    throw error;
  }
}

// src/adapter/steps/copy-assets.ts
function copyAssets(builder, outDirectory) {
  builder.writeClient(`${outDirectory}/client${builder.config.kit.paths.base}`);
  builder.writePrerendered(`${outDirectory}/prerendered${builder.config.kit.paths.base}`);
}

// src/adapter/steps/copy-server.ts
import path from "node:path";
import { fileURLToPath } from "node:url";
var __filename2 = fileURLToPath(import.meta.url);
var __dirname2 = path.dirname(__filename2);
var SERVER_DIR = "../server";
function _copy(builder, outDirectory, filename) {
  const src = path.join(__dirname2, SERVER_DIR, filename);
  const dest = path.join(outDirectory, filename);
  builder.copy(src, dest);
}
function copyServer(builder, outDirectory) {
  _copy(builder, outDirectory, "index.js");
  _copy(builder, outDirectory, "index.js.jsc");
  _copy(builder, outDirectory, "index.js.map");
}

// src/adapter/steps/generate-manifest.ts
import fs from "node:fs/promises";
import path2 from "node:path";
async function generateManifest(builder, outDirectory) {
  const manifestContent = `export const manifest = ${builder.generateManifest({ relativePath: "./server" })};

export const prerendered = new Set(${JSON.stringify(builder.prerendered.paths)});
`;
  const manifestPath = path2.join(outDirectory, "manifest.js");
  try {
    await fs.writeFile(manifestPath, manifestContent, "utf8");
    builder.log(`Manifest file generated at ${manifestPath}`);
  } catch (error) {
    builder.log.error(`Error writing manifest file: ${error}`);
    throw error;
  }
}

// src/adapter/steps/package-json.ts
import fs2 from "node:fs/promises";
import path3 from "node:path";
import { fileURLToPath as fileURLToPath2 } from "node:url";
var __filename3 = fileURLToPath2(import.meta.url);
var __dirname3 = path3.dirname(__filename3);
var files = path3.join(__dirname3, "files");
async function createPackageJson(builder, out, envPrefix, buildOptions) {
  let pkg = {};
  try {
    const packageJsonContent = await fs2.readFile("package.json", "utf-8");
    pkg = JSON.parse(packageJsonContent);
  } catch (error) {
    builder.log.warn(`Could not read package.json: ${error.message}`);
  }
  builder.copy(files, out, {
    replace: {
      SERVER: "./server/index.js",
      MANIFEST: "./manifest.js",
      ENV_PREFIX: JSON.stringify(envPrefix),
      dotENV_PREFIX: envPrefix,
      BUILD_OPTIONS: JSON.stringify(buildOptions)
    }
  });
  const packageData = {
    name: pkg.name || "bun-sveltekit-app",
    version: pkg.version || "0.0.0",
    type: "module",
    private: true,
    main: "index.js",
    scripts: {
      start: "bun run ./index.js"
    },
    dependencies: {
      ...pkg.dependencies || {}
    }
  };
  await fs2.writeFile(`${out}/package.json`, JSON.stringify(packageData, null, "\t"), "utf-8");
}

// src/adapter/steps/patch-server-ws.ts
import fs3 from "node:fs/promises";
import path4 from "node:path";
async function patchServerWebsocketHandler(out) {
  try {
    const serverFile = path4.join(out, "index.js");
    const src = await fs3.readFile(serverFile, "utf-8");
    const regexGetHook = /(this\.#options\.hooks\s+=\s+{)\s+(handle:)/gm;
    const substrGetHook = `$1 
handleWebsocket: module.handleWebsocket || null,
$2`;
    const regexSetHook = /(this\.#options\s+=\s+options;)/gm;
    const substrSetHook = `$1
this.websocket = () => this.#options.hooks.handleWebsocket;`;
    const patchedContent = src.replace(regexGetHook, substrGetHook).replace(regexSetHook, substrSetHook);
    await fs3.writeFile(serverFile, patchedContent, "utf-8");
  } catch (e) {
    console.error(`Error patching server for WebSocket support: ${e.message}`);
    throw e;
  }
}

// src/adapter/index.ts
var ADAPTER_NAME = "adapter-bun";
var adapter = (options) => {
  return {
    name: ADAPTER_NAME,
    adapt: async (builder) => {
      const _options = { out: "build", ...options };
      builder.rimraf(_options.out);
      builder.mkdirp(_options.out);
      builder.log.minor("Copying assets");
      copyAssets(builder, _options.out);
      if (_options.precompress) {
        builder.log.minor("Compressing assets");
        const basePath = builder.config.kit.paths.base;
        await compressAll([
          [`${_options.out}/client${basePath}`, _options.precompress],
          [`${_options.out}/prerendered${basePath}`, _options.precompress]
        ]);
      }
      builder.log.minor("Building server");
      builder.writeServer(`${_options.out}/server`);
      await generateManifest(builder, _options.out);
      builder.log.minor("Patching server (websocket support)");
      patchServerWebsocketHandler(`${_options.out}/server`);
      const { out, ...derivedOptions } = _options;
      await createPackageJson(builder, _options.out, "", derivedOptions);
      builder.log.minor("Copying server");
      copyServer(builder, _options.out);
      builder.log.success(`Start server with: bun run ./${_options.out}/index.js`);
    },
    supports: {
      read: () => true
    }
  };
};
var adapter_default = adapter;
export {
  adapter_default as default
};
