import type { ESLintExtendedProgram } from "./index.js";
import type { NormalizedParserOptions } from "./parser-options.js";
/**
 * Parse for <script>
 */
export declare function parseScriptInSvelte(code: string, attrs: Record<string, string | undefined>, parserOptions: NormalizedParserOptions): ESLintExtendedProgram;
/**
 * Parse for script
 */
export declare function parseScript(code: string, attrs: Record<string, string | undefined>, parserOptions: NormalizedParserOptions): ESLintExtendedProgram;
/**
 * Parse for script without analyze scope
 */
export declare function parseScriptWithoutAnalyzeScope(code: string, attrs: Record<string, string | undefined>, options: NormalizedParserOptions): ESLintExtendedProgram;
