import { SvelteComponent, init, safe_not_equal, element, attr, set_style, insert, noop, detach, empty, binding_callbacks } from 'svelte/internal';
import { createEventDispatcher, onMount, onDestroy } from 'svelte';

/* src/lib/InfiniteScroll.svelte generated by Svelte v3.42.1 */

function create_if_block(ctx) {
	let div;

	return {
		c() {
			div = element("div");
			attr(div, "id", "svelte-infinite-scroll");
			set_style(div, "width", "0");
		},
		m(target, anchor) {
			insert(target, div, anchor);
			/*div_binding*/ ctx[11](div);
		},
		p: noop,
		d(detaching) {
			if (detaching) detach(div);
			/*div_binding*/ ctx[11](null);
		}
	};
}

function create_fragment(ctx) {
	let if_block_anchor;
	let if_block = !/*window*/ ctx[1] && !/*elementScroll*/ ctx[0] && create_if_block(ctx);

	return {
		c() {
			if (if_block) if_block.c();
			if_block_anchor = empty();
		},
		m(target, anchor) {
			if (if_block) if_block.m(target, anchor);
			insert(target, if_block_anchor, anchor);
		},
		p(ctx, [dirty]) {
			if (!/*window*/ ctx[1] && !/*elementScroll*/ ctx[0]) {
				if (if_block) {
					if_block.p(ctx, dirty);
				} else {
					if_block = create_if_block(ctx);
					if_block.c();
					if_block.m(if_block_anchor.parentNode, if_block_anchor);
				}
			} else if (if_block) {
				if_block.d(1);
				if_block = null;
			}
		},
		i: noop,
		o: noop,
		d(detaching) {
			if (if_block) if_block.d(detaching);
			if (detaching) detach(if_block_anchor);
		}
	};
}

function instance($$self, $$props, $$invalidate) {
	let { threshold = 0 } = $$props;
	let { horizontal = false } = $$props;
	let { elementScroll = null } = $$props;
	let { hasMore = true } = $$props;
	let { reverse = false } = $$props;
	let { window = false } = $$props;
	const dispatch = createEventDispatcher();
	let isLoadMore = false;
	let component;
	let beforeScrollHeight;
	let beforeScrollTop;
	let element;

	const onScroll = e => {
		if (!hasMore) return;
		const target = e.target;
		const offset = calcOffset(target, reverse, horizontal);

		if (offset <= threshold) {
			if (!isLoadMore && hasMore) {
				dispatch("loadMore");
				$$invalidate(8, beforeScrollHeight = target.scrollHeight);
				$$invalidate(9, beforeScrollTop = target.scrollTop);
			}

			$$invalidate(7, isLoadMore = true);
		} else {
			$$invalidate(7, isLoadMore = false);
		}
	};

	const calcOffset = (target, reverse, horizontal) => {
		const element = target.documentElement ? target.documentElement : target;

		if (reverse) {
			return horizontal ? element.scrollLeft : element.scrollTop;
		}

		return horizontal
		? element.scrollWidth - element.clientWidth - element.scrollLeft
		: element.scrollHeight - element.clientHeight - element.scrollTop;
	};

	onMount(() => {
		if (window) {
			$$invalidate(10, element = document);
		} else if (elementScroll) {
			$$invalidate(10, element = elementScroll);
		} else {
			$$invalidate(10, element = component.parentNode);
		}
	});

	onDestroy(() => {
		if (element) {
			element.removeEventListener("scroll", onScroll);
			element.removeEventListener("resize", onScroll);
		}
	});

	function div_binding($$value) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			component = $$value;
			$$invalidate(2, component);
		});
	}

	$$self.$$set = $$props => {
		if ('threshold' in $$props) $$invalidate(3, threshold = $$props.threshold);
		if ('horizontal' in $$props) $$invalidate(4, horizontal = $$props.horizontal);
		if ('elementScroll' in $$props) $$invalidate(0, elementScroll = $$props.elementScroll);
		if ('hasMore' in $$props) $$invalidate(5, hasMore = $$props.hasMore);
		if ('reverse' in $$props) $$invalidate(6, reverse = $$props.reverse);
		if ('window' in $$props) $$invalidate(1, window = $$props.window);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*element, reverse*/ 1088) {
			if (element) {
				if (reverse) {
					$$invalidate(10, element.scrollTop = element.scrollHeight, element);
				}

				element.addEventListener("scroll", onScroll);
				element.addEventListener("resize", onScroll);
			}
		}

		if ($$self.$$.dirty & /*isLoadMore, reverse, element, beforeScrollHeight, beforeScrollTop*/ 1984) {
			if (isLoadMore && reverse) {
				$$invalidate(10, element.scrollTop = element.scrollHeight - beforeScrollHeight + beforeScrollTop, element);
			}
		}
	};

	return [
		elementScroll,
		window,
		component,
		threshold,
		horizontal,
		hasMore,
		reverse,
		isLoadMore,
		beforeScrollHeight,
		beforeScrollTop,
		element,
		div_binding
	];
}

class InfiniteScroll extends SvelteComponent {
	constructor(options) {
		super();

		init(this, options, instance, create_fragment, safe_not_equal, {
			threshold: 3,
			horizontal: 4,
			elementScroll: 0,
			hasMore: 5,
			reverse: 6,
			window: 1
		});
	}
}

export { InfiniteScroll as default };
