
# Autogenerated by mlir-tblgen; don't manually edit.

from ._ods_common import _cext as _ods_cext
from ._ods_common import (
    equally_sized_accessor as _ods_equally_sized_accessor,
    get_default_loc_context as _ods_get_default_loc_context,
    get_op_results_or_values as _get_op_results_or_values,
    segmented_accessor as _ods_segmented_accessor,
)
_ods_ir = _ods_cext.ir
_ods_cext.globals.register_traceback_file_exclusion(__file__)

import builtins
from typing import Sequence as _Sequence, Union as _Union, Optional as _Optional


@_ods_cext.register_dialect
class _Dialect(_ods_ir.Dialect):
  DIALECT_NAMESPACE = "chlo"

@_ods_cext.register_operation(_Dialect)
class AcosOp(_ods_ir.OpView):
  r"""
  Returns `Acos(operand)` element-wise.
  
  $$
  \acos(x) = 2 * \atan(\sqrt(1 - x^2) / (1 + x)) if x != -1
           = pi                                  if x == -1
  $$
  """

  OPERATION_NAME = "chlo.acos"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def acos(operand, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return AcosOp(operand=operand, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class AcoshOp(_ods_ir.OpView):
  r"""
  Returns `Acosh(operand)` element-wise.
  
  $$
  \acosh(x) = log(x + sqrt(x^2 - 1))      if x >= -1
  \acosh(x) = nan                         if x < -1
  $$
  """

  OPERATION_NAME = "chlo.acosh"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def acosh(operand, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return AcoshOp(operand=operand, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class AsinAcosKernelOp(_ods_ir.OpView):
  r"""
  Returns `AsinAcosKernel(operand)` element-wise.
  
  ```
  If
    w = _asin_acos_kernel(z)
    w' = _asin_acos_kernel(I * z)
  Then
    asin(z) = complex(atan2(z.real, w.real), sign(z.imag) * w.imag)
    acos(z) = complex(atan2(w.real, z.real), -sign(z.imag) * w.imag)
    asinh(z) = complex(sign(z.real) * w'.imag, atan2(z.imag, w'.real))
    acosh(z) = complex(w.imag, sign(z.imag) * atan2(w.real, z.real))
  ```
  
  This op is used as an intermediate value in decompositions and
  should never be constructed directly by frameworks or consumed by
  backends.
  """

  OPERATION_NAME = "chlo._asin_acos_kernel"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def _asin_acos_kernel(operand, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return AsinAcosKernelOp(operand=operand, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class AsinOp(_ods_ir.OpView):
  r"""
  Returns `Asin(operand)` element-wise.
  
  $$
  \asin(x) = 2 * atan(x / (1 + sqrt(1 - x^2)))
  $$
  """

  OPERATION_NAME = "chlo.asin"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def asin(operand, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return AsinOp(operand=operand, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class AsinhOp(_ods_ir.OpView):
  r"""
  Returns `Asinh(operand)` element-wise.
  
  $$
  \asinh(x) = log(x + sqrt(x^2 + 1))
  $$
  """

  OPERATION_NAME = "chlo.asinh"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def asinh(operand, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return AsinhOp(operand=operand, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class AtanOp(_ods_ir.OpView):
  r"""
  Returns `Atan(operand)` element-wise.
  
  $$
  \atan(x) = \atan2(x, 1)
  $$
  """

  OPERATION_NAME = "chlo.atan"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def atan(operand, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return AtanOp(operand=operand, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class AtanhOp(_ods_ir.OpView):
  r"""
  Returns `Atanh(operand)` element-wise.
  
  $$
  \atanh(x) = 0.5 * log((1 + x) / (1 - x)) if abs(x) <= 1
            = nan                          otherwise
  $$
  """

  OPERATION_NAME = "chlo.atanh"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def atanh(operand, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return AtanhOp(operand=operand, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BesselI1eOp(_ods_ir.OpView):
  r"""
  Returns `bessel_i1e(operand)` element-wise.
  """

  OPERATION_NAME = "chlo.bessel_i1e"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def bessel_i1e(operand, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return BesselI1eOp(operand=operand, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BroadcastAddOp(_ods_ir.OpView):
  r"""
  Returns `lhs + rhs` element-wise.
  
  See
  https://www.tensorflow.org/xla/operation_semantics#element-wise_binary_arithmetic_operations.
  """

  OPERATION_NAME = "chlo.broadcast_add"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if broadcast_dimensions is not None: attributes["broadcast_dimensions"] = (broadcast_dimensions if (
        isinstance(broadcast_dimensions, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(broadcast_dimensions, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def broadcast_dimensions(self) -> _Optional[_ods_ir.DenseI64ArrayAttr]:
    if "broadcast_dimensions" not in self.operation.attributes:
      return None
    return self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.setter
  def broadcast_dimensions(self, value: _Optional[_ods_ir.DenseI64ArrayAttr]):
    if value is not None:
      self.operation.attributes["broadcast_dimensions"] = value
    elif "broadcast_dimensions" in self.operation.attributes:
      del self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.deleter
  def broadcast_dimensions(self):
    del self.operation.attributes["broadcast_dimensions"]

def broadcast_add(lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return BroadcastAddOp(lhs=lhs, rhs=rhs, broadcast_dimensions=broadcast_dimensions, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BroadcastAndOp(_ods_ir.OpView):
  r"""
  Returns `logical_and(lhs, rhs)` element-wise.
  
  See
  https://www.tensorflow.org/xla/operation_semantics#element-wise_binary_arithmetic_operations.
  """

  OPERATION_NAME = "chlo.broadcast_and"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if broadcast_dimensions is not None: attributes["broadcast_dimensions"] = (broadcast_dimensions if (
        isinstance(broadcast_dimensions, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(broadcast_dimensions, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def broadcast_dimensions(self) -> _Optional[_ods_ir.DenseI64ArrayAttr]:
    if "broadcast_dimensions" not in self.operation.attributes:
      return None
    return self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.setter
  def broadcast_dimensions(self, value: _Optional[_ods_ir.DenseI64ArrayAttr]):
    if value is not None:
      self.operation.attributes["broadcast_dimensions"] = value
    elif "broadcast_dimensions" in self.operation.attributes:
      del self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.deleter
  def broadcast_dimensions(self):
    del self.operation.attributes["broadcast_dimensions"]

def broadcast_and(lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return BroadcastAndOp(lhs=lhs, rhs=rhs, broadcast_dimensions=broadcast_dimensions, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BroadcastAtan2Op(_ods_ir.OpView):
  r"""
  Returns `atan2(lhs/rhs)` element-wise.
  
  See
  https://www.tensorflow.org/xla/operation_semantics#element-wise_binary_arithmetic_operations.
  """

  OPERATION_NAME = "chlo.broadcast_atan2"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if broadcast_dimensions is not None: attributes["broadcast_dimensions"] = (broadcast_dimensions if (
        isinstance(broadcast_dimensions, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(broadcast_dimensions, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def broadcast_dimensions(self) -> _Optional[_ods_ir.DenseI64ArrayAttr]:
    if "broadcast_dimensions" not in self.operation.attributes:
      return None
    return self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.setter
  def broadcast_dimensions(self, value: _Optional[_ods_ir.DenseI64ArrayAttr]):
    if value is not None:
      self.operation.attributes["broadcast_dimensions"] = value
    elif "broadcast_dimensions" in self.operation.attributes:
      del self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.deleter
  def broadcast_dimensions(self):
    del self.operation.attributes["broadcast_dimensions"]

def broadcast_atan2(lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return BroadcastAtan2Op(lhs=lhs, rhs=rhs, broadcast_dimensions=broadcast_dimensions, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BroadcastCompareOp(_ods_ir.OpView):
  r"""
  Compares `lhs` and `rhs` elementwise according to `comparison_direction`
  and `compare_type`. If unspecified, `compare_type` is FLOAT for float element
  types, SIGNED for signed element types and UNSIGNED for unsigned element
  types.
  
  See
  https://www.tensorflow.org/xla/operation_semantics#element-wise_comparison_operations.
  """

  OPERATION_NAME = "chlo.broadcast_compare"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, comparison_direction, *, broadcast_dimensions=None, compare_type=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if broadcast_dimensions is not None: attributes["broadcast_dimensions"] = (broadcast_dimensions if (
        isinstance(broadcast_dimensions, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(broadcast_dimensions, context=_ods_context))
    attributes["comparison_direction"] = (comparison_direction if (
    isinstance(comparison_direction, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('CHLO_ComparisonDirectionAttr')) else
      _ods_ir.AttrBuilder.get('CHLO_ComparisonDirectionAttr')(comparison_direction, context=_ods_context))
    if compare_type is not None: attributes["compare_type"] = (compare_type if (
        isinstance(compare_type, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('CHLO_ComparisonTypeAttr')) else
          _ods_ir.AttrBuilder.get('CHLO_ComparisonTypeAttr')(compare_type, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def broadcast_dimensions(self) -> _Optional[_ods_ir.DenseI64ArrayAttr]:
    if "broadcast_dimensions" not in self.operation.attributes:
      return None
    return self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.setter
  def broadcast_dimensions(self, value: _Optional[_ods_ir.DenseI64ArrayAttr]):
    if value is not None:
      self.operation.attributes["broadcast_dimensions"] = value
    elif "broadcast_dimensions" in self.operation.attributes:
      del self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.deleter
  def broadcast_dimensions(self):
    del self.operation.attributes["broadcast_dimensions"]

  @builtins.property
  def comparison_direction(self) -> _ods_ir.Attribute:
    return self.operation.attributes["comparison_direction"]

  @comparison_direction.setter
  def comparison_direction(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["comparison_direction"] = value

  @builtins.property
  def compare_type(self) -> _Optional[_ods_ir.Attribute]:
    if "compare_type" not in self.operation.attributes:
      return None
    return self.operation.attributes["compare_type"]

  @compare_type.setter
  def compare_type(self, value: _Optional[_ods_ir.Attribute]):
    if value is not None:
      self.operation.attributes["compare_type"] = value
    elif "compare_type" in self.operation.attributes:
      del self.operation.attributes["compare_type"]

  @compare_type.deleter
  def compare_type(self):
    del self.operation.attributes["compare_type"]

def broadcast_compare(lhs, rhs, comparison_direction, *, broadcast_dimensions=None, compare_type=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return BroadcastCompareOp(lhs=lhs, rhs=rhs, comparison_direction=comparison_direction, broadcast_dimensions=broadcast_dimensions, compare_type=compare_type, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BroadcastComplexOp(_ods_ir.OpView):
  r"""
  Performs element-wise conversion of a pair of real and imaginary values to
  a complex value.
  """

  OPERATION_NAME = "chlo.broadcast_complex"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if broadcast_dimensions is not None: attributes["broadcast_dimensions"] = (broadcast_dimensions if (
        isinstance(broadcast_dimensions, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(broadcast_dimensions, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def broadcast_dimensions(self) -> _Optional[_ods_ir.DenseI64ArrayAttr]:
    if "broadcast_dimensions" not in self.operation.attributes:
      return None
    return self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.setter
  def broadcast_dimensions(self, value: _Optional[_ods_ir.DenseI64ArrayAttr]):
    if value is not None:
      self.operation.attributes["broadcast_dimensions"] = value
    elif "broadcast_dimensions" in self.operation.attributes:
      del self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.deleter
  def broadcast_dimensions(self):
    del self.operation.attributes["broadcast_dimensions"]

def broadcast_complex(lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return BroadcastComplexOp(lhs=lhs, rhs=rhs, broadcast_dimensions=broadcast_dimensions, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BroadcastDivOp(_ods_ir.OpView):
  r"""
  Returns `lhs / rhs` element-wise.
  
  See
  https://www.tensorflow.org/xla/operation_semantics#element-wise_binary_arithmetic_operations.
  """

  OPERATION_NAME = "chlo.broadcast_divide"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if broadcast_dimensions is not None: attributes["broadcast_dimensions"] = (broadcast_dimensions if (
        isinstance(broadcast_dimensions, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(broadcast_dimensions, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def broadcast_dimensions(self) -> _Optional[_ods_ir.DenseI64ArrayAttr]:
    if "broadcast_dimensions" not in self.operation.attributes:
      return None
    return self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.setter
  def broadcast_dimensions(self, value: _Optional[_ods_ir.DenseI64ArrayAttr]):
    if value is not None:
      self.operation.attributes["broadcast_dimensions"] = value
    elif "broadcast_dimensions" in self.operation.attributes:
      del self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.deleter
  def broadcast_dimensions(self):
    del self.operation.attributes["broadcast_dimensions"]

def broadcast_divide(lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return BroadcastDivOp(lhs=lhs, rhs=rhs, broadcast_dimensions=broadcast_dimensions, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BroadcastMaxOp(_ods_ir.OpView):
  r"""
  Returns `max(lhs, rhs)` element-wise.
  
  See
  https://www.tensorflow.org/xla/operation_semantics#element-wise_binary_arithmetic_operations.
  """

  OPERATION_NAME = "chlo.broadcast_maximum"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if broadcast_dimensions is not None: attributes["broadcast_dimensions"] = (broadcast_dimensions if (
        isinstance(broadcast_dimensions, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(broadcast_dimensions, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def broadcast_dimensions(self) -> _Optional[_ods_ir.DenseI64ArrayAttr]:
    if "broadcast_dimensions" not in self.operation.attributes:
      return None
    return self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.setter
  def broadcast_dimensions(self, value: _Optional[_ods_ir.DenseI64ArrayAttr]):
    if value is not None:
      self.operation.attributes["broadcast_dimensions"] = value
    elif "broadcast_dimensions" in self.operation.attributes:
      del self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.deleter
  def broadcast_dimensions(self):
    del self.operation.attributes["broadcast_dimensions"]

def broadcast_maximum(lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return BroadcastMaxOp(lhs=lhs, rhs=rhs, broadcast_dimensions=broadcast_dimensions, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BroadcastMinOp(_ods_ir.OpView):
  r"""
  Returns `min(lhs, rhs)` element-wise.
  
  See
  https://www.tensorflow.org/xla/operation_semantics#element-wise_binary_arithmetic_operations.
  """

  OPERATION_NAME = "chlo.broadcast_minimum"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if broadcast_dimensions is not None: attributes["broadcast_dimensions"] = (broadcast_dimensions if (
        isinstance(broadcast_dimensions, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(broadcast_dimensions, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def broadcast_dimensions(self) -> _Optional[_ods_ir.DenseI64ArrayAttr]:
    if "broadcast_dimensions" not in self.operation.attributes:
      return None
    return self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.setter
  def broadcast_dimensions(self, value: _Optional[_ods_ir.DenseI64ArrayAttr]):
    if value is not None:
      self.operation.attributes["broadcast_dimensions"] = value
    elif "broadcast_dimensions" in self.operation.attributes:
      del self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.deleter
  def broadcast_dimensions(self):
    del self.operation.attributes["broadcast_dimensions"]

def broadcast_minimum(lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return BroadcastMinOp(lhs=lhs, rhs=rhs, broadcast_dimensions=broadcast_dimensions, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BroadcastMulOp(_ods_ir.OpView):
  r"""
  Returns `lhs * rhs` element-wise.
  
  See
  https://www.tensorflow.org/xla/operation_semantics#element-wise_binary_arithmetic_operations.
  """

  OPERATION_NAME = "chlo.broadcast_multiply"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if broadcast_dimensions is not None: attributes["broadcast_dimensions"] = (broadcast_dimensions if (
        isinstance(broadcast_dimensions, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(broadcast_dimensions, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def broadcast_dimensions(self) -> _Optional[_ods_ir.DenseI64ArrayAttr]:
    if "broadcast_dimensions" not in self.operation.attributes:
      return None
    return self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.setter
  def broadcast_dimensions(self, value: _Optional[_ods_ir.DenseI64ArrayAttr]):
    if value is not None:
      self.operation.attributes["broadcast_dimensions"] = value
    elif "broadcast_dimensions" in self.operation.attributes:
      del self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.deleter
  def broadcast_dimensions(self):
    del self.operation.attributes["broadcast_dimensions"]

def broadcast_multiply(lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return BroadcastMulOp(lhs=lhs, rhs=rhs, broadcast_dimensions=broadcast_dimensions, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BroadcastNextAfterOp(_ods_ir.OpView):
  r"""
  Returns the next representable value of `lhs` in the direction of `rhs`,
  element-wise. It can also return a subnormal number.
  
  Equivalent to the C++ std::nextafter function.
  """

  OPERATION_NAME = "chlo.broadcast_next_after"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if broadcast_dimensions is not None: attributes["broadcast_dimensions"] = (broadcast_dimensions if (
        isinstance(broadcast_dimensions, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(broadcast_dimensions, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def broadcast_dimensions(self) -> _Optional[_ods_ir.DenseI64ArrayAttr]:
    if "broadcast_dimensions" not in self.operation.attributes:
      return None
    return self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.setter
  def broadcast_dimensions(self, value: _Optional[_ods_ir.DenseI64ArrayAttr]):
    if value is not None:
      self.operation.attributes["broadcast_dimensions"] = value
    elif "broadcast_dimensions" in self.operation.attributes:
      del self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.deleter
  def broadcast_dimensions(self):
    del self.operation.attributes["broadcast_dimensions"]

def broadcast_next_after(lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return BroadcastNextAfterOp(lhs=lhs, rhs=rhs, broadcast_dimensions=broadcast_dimensions, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BroadcastOrOp(_ods_ir.OpView):
  r"""
  Returns `logical_or(lhs, rhs)` element-wise.
  
  See
  https://www.tensorflow.org/xla/operation_semantics#element-wise_binary_arithmetic_operations.
  """

  OPERATION_NAME = "chlo.broadcast_or"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if broadcast_dimensions is not None: attributes["broadcast_dimensions"] = (broadcast_dimensions if (
        isinstance(broadcast_dimensions, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(broadcast_dimensions, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def broadcast_dimensions(self) -> _Optional[_ods_ir.DenseI64ArrayAttr]:
    if "broadcast_dimensions" not in self.operation.attributes:
      return None
    return self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.setter
  def broadcast_dimensions(self, value: _Optional[_ods_ir.DenseI64ArrayAttr]):
    if value is not None:
      self.operation.attributes["broadcast_dimensions"] = value
    elif "broadcast_dimensions" in self.operation.attributes:
      del self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.deleter
  def broadcast_dimensions(self):
    del self.operation.attributes["broadcast_dimensions"]

def broadcast_or(lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return BroadcastOrOp(lhs=lhs, rhs=rhs, broadcast_dimensions=broadcast_dimensions, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BroadcastPolygammaOp(_ods_ir.OpView):
  r"""
  Returns `Polygamma(operand, operand)` element-wise.
  """

  OPERATION_NAME = "chlo.broadcast_polygamma"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if broadcast_dimensions is not None: attributes["broadcast_dimensions"] = (broadcast_dimensions if (
        isinstance(broadcast_dimensions, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(broadcast_dimensions, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def broadcast_dimensions(self) -> _Optional[_ods_ir.DenseI64ArrayAttr]:
    if "broadcast_dimensions" not in self.operation.attributes:
      return None
    return self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.setter
  def broadcast_dimensions(self, value: _Optional[_ods_ir.DenseI64ArrayAttr]):
    if value is not None:
      self.operation.attributes["broadcast_dimensions"] = value
    elif "broadcast_dimensions" in self.operation.attributes:
      del self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.deleter
  def broadcast_dimensions(self):
    del self.operation.attributes["broadcast_dimensions"]

def broadcast_polygamma(lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return BroadcastPolygammaOp(lhs=lhs, rhs=rhs, broadcast_dimensions=broadcast_dimensions, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BroadcastPowOp(_ods_ir.OpView):
  r"""
  Returns `lhs ^ rhs` element-wise.
  
  See
  https://www.tensorflow.org/xla/operation_semantics#element-wise_binary_arithmetic_operations.
  """

  OPERATION_NAME = "chlo.broadcast_power"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if broadcast_dimensions is not None: attributes["broadcast_dimensions"] = (broadcast_dimensions if (
        isinstance(broadcast_dimensions, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(broadcast_dimensions, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def broadcast_dimensions(self) -> _Optional[_ods_ir.DenseI64ArrayAttr]:
    if "broadcast_dimensions" not in self.operation.attributes:
      return None
    return self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.setter
  def broadcast_dimensions(self, value: _Optional[_ods_ir.DenseI64ArrayAttr]):
    if value is not None:
      self.operation.attributes["broadcast_dimensions"] = value
    elif "broadcast_dimensions" in self.operation.attributes:
      del self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.deleter
  def broadcast_dimensions(self):
    del self.operation.attributes["broadcast_dimensions"]

def broadcast_power(lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return BroadcastPowOp(lhs=lhs, rhs=rhs, broadcast_dimensions=broadcast_dimensions, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BroadcastRemOp(_ods_ir.OpView):
  r"""
  Returns `lhs % rhs` element-wise.
  
  See
  https://www.tensorflow.org/xla/operation_semantics#element-wise_binary_arithmetic_operations.
  """

  OPERATION_NAME = "chlo.broadcast_remainder"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if broadcast_dimensions is not None: attributes["broadcast_dimensions"] = (broadcast_dimensions if (
        isinstance(broadcast_dimensions, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(broadcast_dimensions, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def broadcast_dimensions(self) -> _Optional[_ods_ir.DenseI64ArrayAttr]:
    if "broadcast_dimensions" not in self.operation.attributes:
      return None
    return self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.setter
  def broadcast_dimensions(self, value: _Optional[_ods_ir.DenseI64ArrayAttr]):
    if value is not None:
      self.operation.attributes["broadcast_dimensions"] = value
    elif "broadcast_dimensions" in self.operation.attributes:
      del self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.deleter
  def broadcast_dimensions(self):
    del self.operation.attributes["broadcast_dimensions"]

def broadcast_remainder(lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return BroadcastRemOp(lhs=lhs, rhs=rhs, broadcast_dimensions=broadcast_dimensions, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BroadcastSelectOp(_ods_ir.OpView):
  r"""
  Constructs an output array from elements of two input arrays, based on the
  values of a predicate array.
  
  See https://www.tensorflow.org/xla/operation_semantics#select
  """

  OPERATION_NAME = "chlo.broadcast_select"

  _ODS_REGIONS = (0, True)

  def __init__(self, pred, on_true, on_false, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(pred)
    operands.append(on_true)
    operands.append(on_false)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def pred(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def on_true(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def on_false(self) -> _ods_ir.Value:
    return self.operation.operands[2]

def broadcast_select(pred, on_true, on_false, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return BroadcastSelectOp(pred=pred, on_true=on_true, on_false=on_false, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BroadcastShiftLeftOp(_ods_ir.OpView):
  r"""
  Returns `lhs << rhs` element-wise.
  
  See
  https://www.tensorflow.org/xla/operation_semantics#element-wise_binary_arithmetic_operations.
  """

  OPERATION_NAME = "chlo.broadcast_shift_left"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if broadcast_dimensions is not None: attributes["broadcast_dimensions"] = (broadcast_dimensions if (
        isinstance(broadcast_dimensions, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(broadcast_dimensions, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def broadcast_dimensions(self) -> _Optional[_ods_ir.DenseI64ArrayAttr]:
    if "broadcast_dimensions" not in self.operation.attributes:
      return None
    return self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.setter
  def broadcast_dimensions(self, value: _Optional[_ods_ir.DenseI64ArrayAttr]):
    if value is not None:
      self.operation.attributes["broadcast_dimensions"] = value
    elif "broadcast_dimensions" in self.operation.attributes:
      del self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.deleter
  def broadcast_dimensions(self):
    del self.operation.attributes["broadcast_dimensions"]

def broadcast_shift_left(lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return BroadcastShiftLeftOp(lhs=lhs, rhs=rhs, broadcast_dimensions=broadcast_dimensions, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BroadcastShiftRightArithmeticOp(_ods_ir.OpView):
  r"""
  Returns `lhs >> rhs` element-wise.
  
  See
  https://www.tensorflow.org/xla/operation_semantics#element-wise_binary_arithmetic_operations.
  """

  OPERATION_NAME = "chlo.broadcast_shift_right_arithmetic"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if broadcast_dimensions is not None: attributes["broadcast_dimensions"] = (broadcast_dimensions if (
        isinstance(broadcast_dimensions, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(broadcast_dimensions, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def broadcast_dimensions(self) -> _Optional[_ods_ir.DenseI64ArrayAttr]:
    if "broadcast_dimensions" not in self.operation.attributes:
      return None
    return self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.setter
  def broadcast_dimensions(self, value: _Optional[_ods_ir.DenseI64ArrayAttr]):
    if value is not None:
      self.operation.attributes["broadcast_dimensions"] = value
    elif "broadcast_dimensions" in self.operation.attributes:
      del self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.deleter
  def broadcast_dimensions(self):
    del self.operation.attributes["broadcast_dimensions"]

def broadcast_shift_right_arithmetic(lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return BroadcastShiftRightArithmeticOp(lhs=lhs, rhs=rhs, broadcast_dimensions=broadcast_dimensions, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BroadcastShiftRightLogicalOp(_ods_ir.OpView):
  r"""
  Returns `lhs >> rhs` element-wise.
  
  See
  https://www.tensorflow.org/xla/operation_semantics#element-wise_binary_arithmetic_operations.
  """

  OPERATION_NAME = "chlo.broadcast_shift_right_logical"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if broadcast_dimensions is not None: attributes["broadcast_dimensions"] = (broadcast_dimensions if (
        isinstance(broadcast_dimensions, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(broadcast_dimensions, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def broadcast_dimensions(self) -> _Optional[_ods_ir.DenseI64ArrayAttr]:
    if "broadcast_dimensions" not in self.operation.attributes:
      return None
    return self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.setter
  def broadcast_dimensions(self, value: _Optional[_ods_ir.DenseI64ArrayAttr]):
    if value is not None:
      self.operation.attributes["broadcast_dimensions"] = value
    elif "broadcast_dimensions" in self.operation.attributes:
      del self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.deleter
  def broadcast_dimensions(self):
    del self.operation.attributes["broadcast_dimensions"]

def broadcast_shift_right_logical(lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return BroadcastShiftRightLogicalOp(lhs=lhs, rhs=rhs, broadcast_dimensions=broadcast_dimensions, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BroadcastSubOp(_ods_ir.OpView):
  r"""
  Returns `lhs - rhs` element-wise.
  
  See
  https://www.tensorflow.org/xla/operation_semantics#element-wise_binary_arithmetic_operations.
  """

  OPERATION_NAME = "chlo.broadcast_subtract"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if broadcast_dimensions is not None: attributes["broadcast_dimensions"] = (broadcast_dimensions if (
        isinstance(broadcast_dimensions, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(broadcast_dimensions, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def broadcast_dimensions(self) -> _Optional[_ods_ir.DenseI64ArrayAttr]:
    if "broadcast_dimensions" not in self.operation.attributes:
      return None
    return self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.setter
  def broadcast_dimensions(self, value: _Optional[_ods_ir.DenseI64ArrayAttr]):
    if value is not None:
      self.operation.attributes["broadcast_dimensions"] = value
    elif "broadcast_dimensions" in self.operation.attributes:
      del self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.deleter
  def broadcast_dimensions(self):
    del self.operation.attributes["broadcast_dimensions"]

def broadcast_subtract(lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return BroadcastSubOp(lhs=lhs, rhs=rhs, broadcast_dimensions=broadcast_dimensions, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BroadcastXorOp(_ods_ir.OpView):
  r"""
  Returns `logical_xor(lhs, rhs)` element-wise.
  
  See
  https://www.tensorflow.org/xla/operation_semantics#element-wise_binary_arithmetic_operations.
  """

  OPERATION_NAME = "chlo.broadcast_xor"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if broadcast_dimensions is not None: attributes["broadcast_dimensions"] = (broadcast_dimensions if (
        isinstance(broadcast_dimensions, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(broadcast_dimensions, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def broadcast_dimensions(self) -> _Optional[_ods_ir.DenseI64ArrayAttr]:
    if "broadcast_dimensions" not in self.operation.attributes:
      return None
    return self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.setter
  def broadcast_dimensions(self, value: _Optional[_ods_ir.DenseI64ArrayAttr]):
    if value is not None:
      self.operation.attributes["broadcast_dimensions"] = value
    elif "broadcast_dimensions" in self.operation.attributes:
      del self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.deleter
  def broadcast_dimensions(self):
    del self.operation.attributes["broadcast_dimensions"]

def broadcast_xor(lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return BroadcastXorOp(lhs=lhs, rhs=rhs, broadcast_dimensions=broadcast_dimensions, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BroadcastZetaOp(_ods_ir.OpView):
  r"""
  Returns `Zeta(operand, operand)` element-wise.
  
  $$
  \(\zeta(x, q) = \sum_{n=0}^{\infty} (q + n)^{-x}\)
  $$
  """

  OPERATION_NAME = "chlo.broadcast_zeta"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if broadcast_dimensions is not None: attributes["broadcast_dimensions"] = (broadcast_dimensions if (
        isinstance(broadcast_dimensions, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(broadcast_dimensions, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def broadcast_dimensions(self) -> _Optional[_ods_ir.DenseI64ArrayAttr]:
    if "broadcast_dimensions" not in self.operation.attributes:
      return None
    return self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.setter
  def broadcast_dimensions(self, value: _Optional[_ods_ir.DenseI64ArrayAttr]):
    if value is not None:
      self.operation.attributes["broadcast_dimensions"] = value
    elif "broadcast_dimensions" in self.operation.attributes:
      del self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.deleter
  def broadcast_dimensions(self):
    del self.operation.attributes["broadcast_dimensions"]

def broadcast_zeta(lhs, rhs, *, broadcast_dimensions=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return BroadcastZetaOp(lhs=lhs, rhs=rhs, broadcast_dimensions=broadcast_dimensions, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ConjOp(_ods_ir.OpView):
  r"""
  Returns `Conj(operand)` element-wise.
  
  $$
  \conj(x) = (\real(x), \neg(\imag(x)))
  $$
  """

  OPERATION_NAME = "chlo.conj"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def conj(operand, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return ConjOp(operand=operand, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ConstantLikeOp(_ods_ir.OpView):
  r"""
  Returns a splat constant of the same shape as the operand.
  """

  OPERATION_NAME = "chlo.constant_like"

  _ODS_REGIONS = (0, True)

  def __init__(self, value, operand, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["value"] = (value if (
    isinstance(value, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TypedAttrInterface')) else
      _ods_ir.AttrBuilder.get('TypedAttrInterface')(value, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def value(self) -> _ods_ir.Attribute:
    return self.operation.attributes["value"]

  @value.setter
  def value(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["value"] = value

def constant_like(value, operand, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return ConstantLikeOp(value=value, operand=operand, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ConstantOp(_ods_ir.OpView):
  r"""
  Represents a constant value.
  """

  OPERATION_NAME = "chlo.constant"

  _ODS_REGIONS = (0, True)

  def __init__(self, value, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["value"] = (value if (
    isinstance(value, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('ElementsAttr')) else
      _ods_ir.AttrBuilder.get('ElementsAttr')(value, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def value(self) -> _ods_ir.Attribute:
    return self.operation.attributes["value"]

  @value.setter
  def value(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["value"] = value

  @builtins.property
  def output(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def constant(value, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return ConstantOp(value=value, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class CoshOp(_ods_ir.OpView):
  r"""
  Returns `Cosh(operand)` element-wise.
  
  $$
  \cosh(x) = (e^x + e^-x) / 2
  $$
  """

  OPERATION_NAME = "chlo.cosh"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def cosh(operand, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return CoshOp(operand=operand, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class DigammaOp(_ods_ir.OpView):
  r"""
  Returns `Digamma(operand)` element-wise.
  """

  OPERATION_NAME = "chlo.digamma"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def digamma(operand, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return DigammaOp(operand=operand, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ErfInvOp(_ods_ir.OpView):
  r"""
  Returns `ErfInv(operand)` element-wise.
  """

  OPERATION_NAME = "chlo.erf_inv"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def erf_inv(operand, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return ErfInvOp(operand=operand, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ErfOp(_ods_ir.OpView):
  r"""
  Computes the Gauss error function of `x` element-wise.
  
  erf(x) = erf_impl(x)            if |x| < 1
         = 1 - erfc_impl(x)       otherwise
  """

  OPERATION_NAME = "chlo.erf"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def erf(operand, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return ErfOp(operand=operand, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ErfcOp(_ods_ir.OpView):
  r"""
  Computes an approximation of the error function complement (1 - erf(x)).
  
  erfc(x) = erfc_impl(x)           if |x| > 1
          = 1 - erf_impl(x)        otherwise
  """

  OPERATION_NAME = "chlo.erfc"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def erfc(operand, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return ErfcOp(operand=operand, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class IsInfOp(_ods_ir.OpView):
  r"""
  Returns if a value is +/-inf element-wise.
  """

  OPERATION_NAME = "chlo.is_inf"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def is_inf(operand, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return IsInfOp(operand=operand, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class IsNegInfOp(_ods_ir.OpView):
  r"""
  Returns if a value is -inf element-wise.
  """

  OPERATION_NAME = "chlo.is_neg_inf"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def is_neg_inf(operand, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return IsNegInfOp(operand=operand, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class IsPosInfOp(_ods_ir.OpView):
  r"""
  Returns if a value is +inf element-wise.
  """

  OPERATION_NAME = "chlo.is_pos_inf"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def is_pos_inf(operand, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return IsPosInfOp(operand=operand, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class LgammaOp(_ods_ir.OpView):
  r"""
  Returns `Lgamma(operand)` element-wise.
  """

  OPERATION_NAME = "chlo.lgamma"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def lgamma(operand, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return LgammaOp(operand=operand, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class NextAfterOp(_ods_ir.OpView):
  r"""
  Returns the next representable value of `x` in the direction of `y`,
  element-wise. It can also return a subnormal number.
  
  Equivalent to the C++ std::nextafter function.
  """

  OPERATION_NAME = "chlo.next_after"

  _ODS_REGIONS = (0, True)

  def __init__(self, x, y, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(x)
    operands.append(y)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def x(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def y(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def next_after(x, y, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return NextAfterOp(x=x, y=y, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class PolygammaOp(_ods_ir.OpView):
  r"""
  Returns `Polygamma(operand, operand)` element-wise.
  """

  OPERATION_NAME = "chlo.polygamma"

  _ODS_REGIONS = (0, True)

  def __init__(self, n, x, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(n)
    operands.append(x)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def n(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def x(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def polygamma(n, x, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return PolygammaOp(n=n, x=x, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class RaggedDotOp(_ods_ir.OpView):
  r"""
  This operation takes three tensor args---lhs, rhs, and group_sizes---and
  a "ragged_dot_dimension_numbers" attribute. Like dot_general, the lhs and
  rhs are allowed arbitrary batch and contracting dimensions. Additionally,
  the lhs is required to have one ragged dimension, and the rhs may have at
  most one group dimension. The op has three modes, depending on the kind of
  the lhs ragged dimension.
  
  In mode 1, the shape-signature is `[b,m,k], [g,b,k,n], [b,g] -> [b,m,n]`.
  Here the ragged dimension is an lhs non-contracting dimension (`m`). The
  dimensions `b` and `k` represent batch and contracting dimensions
  respectively. The rhs is required to have a group dimension (`g`).
  
  In mode 2, the shape-signature is `[b,m,k], [b,k,n], [b,g] -> [g,b,m,n]`.
  Here the ragged dimension is an lhs/rhs contracting dimension (`k`).
  
  In mode 3, the shape-signature is `[b,m,k], [b,k,n], [g] -> [b,m,n]`. Here
  the ragged dimension is an lhs/rhs batch dimension (`b`).
  
  """

  OPERATION_NAME = "chlo.ragged_dot"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, lhs, rhs, group_sizes, ragged_dot_dimension_numbers, *, precision_config=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    operands.append(group_sizes)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["ragged_dot_dimension_numbers"] = (ragged_dot_dimension_numbers if (
    isinstance(ragged_dot_dimension_numbers, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('CHLO_RaggedDotDimensionNumbers')) else
      _ods_ir.AttrBuilder.get('CHLO_RaggedDotDimensionNumbers')(ragged_dot_dimension_numbers, context=_ods_context))
    if precision_config is not None: attributes["precision_config"] = (precision_config if (
        isinstance(precision_config, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('CHLO_PrecisionConfigAttr')) else
          _ods_ir.AttrBuilder.get('CHLO_PrecisionConfigAttr')(precision_config, context=_ods_context))
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def group_sizes(self) -> _ods_ir.Value:
    return self.operation.operands[2]

  @builtins.property
  def ragged_dot_dimension_numbers(self) -> _ods_ir.Attribute:
    return self.operation.attributes["ragged_dot_dimension_numbers"]

  @ragged_dot_dimension_numbers.setter
  def ragged_dot_dimension_numbers(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["ragged_dot_dimension_numbers"] = value

  @builtins.property
  def precision_config(self) -> _Optional[_ods_ir.ArrayAttr]:
    if "precision_config" not in self.operation.attributes:
      return None
    return self.operation.attributes["precision_config"]

  @precision_config.setter
  def precision_config(self, value: _Optional[_ods_ir.ArrayAttr]):
    if value is not None:
      self.operation.attributes["precision_config"] = value
    elif "precision_config" in self.operation.attributes:
      del self.operation.attributes["precision_config"]

  @precision_config.deleter
  def precision_config(self):
    del self.operation.attributes["precision_config"]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def ragged_dot(result, lhs, rhs, group_sizes, ragged_dot_dimension_numbers, *, precision_config=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return RaggedDotOp(result=result, lhs=lhs, rhs=rhs, group_sizes=group_sizes, ragged_dot_dimension_numbers=ragged_dot_dimension_numbers, precision_config=precision_config, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class SinhOp(_ods_ir.OpView):
  r"""
  Returns `Sinh(operand)` element-wise.
  
  $$
  \sinh(x) = (e^x - e^-x) / 2                     if |x| < 1
           = e^(x + log(1/2)) - e^(-x + log(1/2)) otherwise.
  $$
  """

  OPERATION_NAME = "chlo.sinh"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def sinh(operand, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return SinhOp(operand=operand, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class SquareOp(_ods_ir.OpView):
  r"""
  Returns `Square(operand)` element-wise.
  
  $$
  \square(x) = complex((x.real - x.imag) * (x.real + x.imag), x.real * x.imag * 2) if x is a complex number
             = x * x                                                               otherwise
  $$
  """

  OPERATION_NAME = "chlo.square"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def square(operand, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return SquareOp(operand=operand, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class TanOp(_ods_ir.OpView):
  r"""
  Returns `Tan(operand)` element-wise.
  
  $$
  \tan(x) = \sin(x) / \cos(x)
  $$
  """

  OPERATION_NAME = "chlo.tan"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def tan(operand, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return TanOp(operand=operand, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class TopKOp(_ods_ir.OpView):
  r"""
  If the input is a vector (rank-1), finds the `k` largest entries in the
  vector and outputs their values and indices as vectors.  Thus `values[j]` is
  the `j`-th largest entry in `input`, and its index is `indices[j]`.
  
  For matrices (resp. higher rank input), computes the top `k` entries in each
  row (resp. vector along the last dimension).  Thus,
  
  ```
  values.shape = indices.shape = input.shape[:-1] + [k]
  ```
  
  If two elements are equal, the lower-index element appears first.
  """

  OPERATION_NAME = "chlo.top_k"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, k, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["k"] = (k if (
    isinstance(k, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(k, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def k(self) -> _ods_ir.IntegerAttr:
    return self.operation.attributes["k"]

  @k.setter
  def k(self, value: _ods_ir.IntegerAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["k"] = value

  @builtins.property
  def values(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

  @builtins.property
  def indices(self) -> _ods_ir.OpResult:
    return self.operation.results[1]

def top_k(operand, k, *, results=None, loc=None, ip=None) -> _ods_ir.OpResultList:
  return TopKOp(operand=operand, k=k, results=results, loc=loc, ip=ip).results

@_ods_cext.register_operation(_Dialect)
class ZetaOp(_ods_ir.OpView):
  r"""
  Returns `Zeta(operand, operand)` element-wise.
  
  $$
  \(\zeta(x, q) = \sum_{n=0}^{\infty} (q + n)^{-x}\)
  $$
  """

  OPERATION_NAME = "chlo.zeta"

  _ODS_REGIONS = (0, True)

  def __init__(self, x, q, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(x)
    operands.append(q)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def x(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def q(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def zeta(x, q, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return ZetaOp(x=x, q=q, results=results, loc=loc, ip=ip).result
