# pytype: skip-file

# Autogenerated by mlir-tblgen; don't manually edit.

from jaxlib.mlir.dialects._ods_common import _cext as _ods_cext
from jaxlib.mlir.dialects._ods_common import (
    equally_sized_accessor as _ods_equally_sized_accessor,
    get_default_loc_context as _ods_get_default_loc_context,
    get_op_results_or_values as _get_op_results_or_values,
    segmented_accessor as _ods_segmented_accessor,
)
_ods_ir = _ods_cext.ir
_ods_cext.globals.register_traceback_file_exclusion(__file__)

import builtins
from typing import Sequence as _Sequence, Union as _Union, Optional as _Optional


@_ods_cext.register_dialect
class _Dialect(_ods_ir.Dialect):
  DIALECT_NAMESPACE = "tt"

@_ods_cext.register_operation(_Dialect)
class CallOp(_ods_ir.OpView):
  r"""
  The `tt.call` operation represents a direct call to a function that is
  within the same symbol scope as the call. The operands and result types of
  the call must match the specified function type. The callee is encoded as a
  symbol reference attribute named "callee".
  
  Example:
  
  ```mlir
  %2 = tt.call @my_add(%0, %1) : (f32, f32) -> f32
  ```
  """

  OPERATION_NAME = "tt.call"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, callee, operands_, *, arg_attrs=None, res_attrs=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(operands_))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["callee"] = (callee if (
    isinstance(callee, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('FlatSymbolRefAttr')) else
      _ods_ir.AttrBuilder.get('FlatSymbolRefAttr')(callee, context=_ods_context))
    if arg_attrs is not None: attributes["arg_attrs"] = (arg_attrs if (
        isinstance(arg_attrs, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DictArrayAttr')) else
          _ods_ir.AttrBuilder.get('DictArrayAttr')(arg_attrs, context=_ods_context))
    if res_attrs is not None: attributes["res_attrs"] = (res_attrs if (
        isinstance(res_attrs, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DictArrayAttr')) else
          _ods_ir.AttrBuilder.get('DictArrayAttr')(res_attrs, context=_ods_context))
    results = []
    results.extend(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operands_(self) -> _ods_ir.OpOperandList:
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def callee(self) -> _ods_ir.FlatSymbolRefAttr:
    return self.operation.attributes["callee"]

  @callee.setter
  def callee(self, value: _ods_ir.FlatSymbolRefAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["callee"] = value

  @builtins.property
  def arg_attrs(self) -> _Optional[_ods_ir.ArrayAttr]:
    if "arg_attrs" not in self.operation.attributes:
      return None
    return self.operation.attributes["arg_attrs"]

  @arg_attrs.setter
  def arg_attrs(self, value: _Optional[_ods_ir.ArrayAttr]):
    if value is not None:
      self.operation.attributes["arg_attrs"] = value
    elif "arg_attrs" in self.operation.attributes:
      del self.operation.attributes["arg_attrs"]

  @arg_attrs.deleter
  def arg_attrs(self):
    del self.operation.attributes["arg_attrs"]

  @builtins.property
  def res_attrs(self) -> _Optional[_ods_ir.ArrayAttr]:
    if "res_attrs" not in self.operation.attributes:
      return None
    return self.operation.attributes["res_attrs"]

  @res_attrs.setter
  def res_attrs(self, value: _Optional[_ods_ir.ArrayAttr]):
    if value is not None:
      self.operation.attributes["res_attrs"] = value
    elif "res_attrs" in self.operation.attributes:
      del self.operation.attributes["res_attrs"]

  @res_attrs.deleter
  def res_attrs(self):
    del self.operation.attributes["res_attrs"]

def call(result, callee, operands_, *, arg_attrs=None, res_attrs=None, loc=None, ip=None) -> _Union[_ods_ir.OpResult, _ods_ir.OpResultList, CallOp]:
  op = CallOp(result=result, callee=callee, operands_=operands_, arg_attrs=arg_attrs, res_attrs=res_attrs, loc=loc, ip=ip); results = op.results
  return results if len(results) > 1 else (results[0] if len(results) == 1 else op)

@_ods_cext.register_operation(_Dialect)
class FuncOp(_ods_ir.OpView):
  r"""
  Operations within the function cannot implicitly capture values defined
  outside of the function, i.e. Functions are `IsolatedFromAbove`. All
  external references must use function arguments or attributes that establish
  a symbolic connection (e.g. symbols referenced by name via a string
  attribute like SymbolRefAttr). An external function declaration (used when
  referring to a function declared in some other module) has no body. While
  the MLIR textual form provides a nice inline syntax for function arguments,
  they are internally represented as “block arguments” to the first block in
  the region.
  
  Only dialect attribute names may be specified in the attribute dictionaries
  for function arguments, results, or the function itself.
  
  Example:
  
  ```mlir
  // External function definitions.
  tt.func @abort()
  tt.func @scribble(i32, i64, memref<? x 128 x f32, #layout_map0>) -> f64
  
  // A function that returns its argument twice:
  tt.func @count(%x: i64) -> (i64, i64)
    attributes {fruit: "banana"} {
    return %x, %x: i64, i64
  }
  
  // A function with an argument attribute
  tt.func @example_fn_arg(%x: i32 {swift.self = unit})
  
  // A function with a result attribute
  tt.func @example_fn_result() -> (f64 {dialectName.attrName = 0 : i64})
  
  // A function with an attribute
  tt.func @example_fn_attr() attributes {dialectName.attrName = false}
  ```
  """

  OPERATION_NAME = "tt.func"

  _ODS_REGIONS = (1, True)

  def __init__(self, sym_name, function_type, *, sym_visibility=None, arg_attrs=None, res_attrs=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    isinstance(sym_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    attributes["function_type"] = (function_type if (
    isinstance(function_type, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('anonymous_713')) else
      _ods_ir.AttrBuilder.get('anonymous_713')(function_type, context=_ods_context))
    if sym_visibility is not None: attributes["sym_visibility"] = (sym_visibility if (
        isinstance(sym_visibility, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(sym_visibility, context=_ods_context))
    if arg_attrs is not None: attributes["arg_attrs"] = (arg_attrs if (
        isinstance(arg_attrs, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DictArrayAttr')) else
          _ods_ir.AttrBuilder.get('DictArrayAttr')(arg_attrs, context=_ods_context))
    if res_attrs is not None: attributes["res_attrs"] = (res_attrs if (
        isinstance(res_attrs, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DictArrayAttr')) else
          _ods_ir.AttrBuilder.get('DictArrayAttr')(res_attrs, context=_ods_context))
    results = []
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def sym_name(self) -> _ods_ir.StringAttr:
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value: _ods_ir.StringAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def function_type(self) -> _ods_ir.TypeAttr:
    return self.operation.attributes["function_type"]

  @function_type.setter
  def function_type(self, value: _ods_ir.TypeAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["function_type"] = value

  @builtins.property
  def sym_visibility(self) -> _Optional[_ods_ir.StringAttr]:
    if "sym_visibility" not in self.operation.attributes:
      return None
    return self.operation.attributes["sym_visibility"]

  @sym_visibility.setter
  def sym_visibility(self, value: _Optional[_ods_ir.StringAttr]):
    if value is not None:
      self.operation.attributes["sym_visibility"] = value
    elif "sym_visibility" in self.operation.attributes:
      del self.operation.attributes["sym_visibility"]

  @sym_visibility.deleter
  def sym_visibility(self):
    del self.operation.attributes["sym_visibility"]

  @builtins.property
  def arg_attrs(self) -> _Optional[_ods_ir.ArrayAttr]:
    if "arg_attrs" not in self.operation.attributes:
      return None
    return self.operation.attributes["arg_attrs"]

  @arg_attrs.setter
  def arg_attrs(self, value: _Optional[_ods_ir.ArrayAttr]):
    if value is not None:
      self.operation.attributes["arg_attrs"] = value
    elif "arg_attrs" in self.operation.attributes:
      del self.operation.attributes["arg_attrs"]

  @arg_attrs.deleter
  def arg_attrs(self):
    del self.operation.attributes["arg_attrs"]

  @builtins.property
  def res_attrs(self) -> _Optional[_ods_ir.ArrayAttr]:
    if "res_attrs" not in self.operation.attributes:
      return None
    return self.operation.attributes["res_attrs"]

  @res_attrs.setter
  def res_attrs(self, value: _Optional[_ods_ir.ArrayAttr]):
    if value is not None:
      self.operation.attributes["res_attrs"] = value
    elif "res_attrs" in self.operation.attributes:
      del self.operation.attributes["res_attrs"]

  @res_attrs.deleter
  def res_attrs(self):
    del self.operation.attributes["res_attrs"]

  @builtins.property
  def body(self) -> _ods_ir.Region:
    return self.regions[0]

def func(sym_name, function_type, *, sym_visibility=None, arg_attrs=None, res_attrs=None, loc=None, ip=None) -> FuncOp:
  return FuncOp(sym_name=sym_name, function_type=function_type, sym_visibility=sym_visibility, arg_attrs=arg_attrs, res_attrs=res_attrs, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class ReturnOp(_ods_ir.OpView):
  r"""
  The `tt.return` operation represents a return operation within a function.
  The operation takes variable number of operands and produces no results.
  The operand number and types must match the signature of the function
  that contains the operation.
  
  Example:
  
  ```mlir
  tt.func @foo() : (i32, f8) {
    ...
    tt.return %0, %1 : i32, f8
  }
  ```
  """

  OPERATION_NAME = "tt.return"

  _ODS_REGIONS = (0, True)

  def __init__(self, srcs, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(srcs))
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def srcs(self) -> _ods_ir.OpOperandList:
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

def return_(srcs, *, loc=None, ip=None) -> ReturnOp:
  return ReturnOp(srcs=srcs, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class AddPtrOp(_ods_ir.OpView):
  OPERATION_NAME = "tt.addptr"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, ptr, offset, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(ptr)
    operands.append(offset)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def ptr(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def offset(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def addptr(result, ptr, offset, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return AddPtrOp(result=result, ptr=ptr, offset=offset, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class AdvanceOp(_ods_ir.OpView):
  OPERATION_NAME = "tt.advance"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, ptr, offsets, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(ptr)
    operands.extend(_get_op_results_or_values(offsets))
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def ptr(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def offsets(self) -> _ods_ir.OpOperandList:
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def advance(result, ptr, offsets, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return AdvanceOp(result=result, ptr=ptr, offsets=offsets, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class AssertOp(_ods_ir.OpView):
  r"""
  `tt.assert` takes a condition tensor and a message string.
  If the condition is false, the message is printed, and the program is aborted.
  """

  OPERATION_NAME = "tt.assert"

  _ODS_REGIONS = (0, True)

  def __init__(self, condition, message, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(condition)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["message"] = (message if (
    isinstance(message, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(message, context=_ods_context))
    results = []
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def condition(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def message(self) -> _ods_ir.StringAttr:
    return self.operation.attributes["message"]

  @message.setter
  def message(self, value: _ods_ir.StringAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["message"] = value

def assert_(condition, message, *, loc=None, ip=None) -> AssertOp:
  return AssertOp(condition=condition, message=message, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class AtomicCASOp(_ods_ir.OpView):
  r"""
  compare $cmp with data $old at location $ptr,
  
  if $old == $cmp, store $val to $ptr,
  
  else store $old to $ptr,
  
  return $old
  """

  OPERATION_NAME = "tt.atomic_cas"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, ptr, cmp, val, sem, scope, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(ptr)
    operands.append(cmp)
    operands.append(val)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sem"] = (sem if (
    isinstance(sem, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TT_MemSemanticAttr')) else
      _ods_ir.AttrBuilder.get('TT_MemSemanticAttr')(sem, context=_ods_context))
    attributes["scope"] = (scope if (
    isinstance(scope, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TT_MemSyncScopeAttr')) else
      _ods_ir.AttrBuilder.get('TT_MemSyncScopeAttr')(scope, context=_ods_context))
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def ptr(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def cmp(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def val(self) -> _ods_ir.Value:
    return self.operation.operands[2]

  @builtins.property
  def sem(self) -> _ods_ir.Attribute:
    return self.operation.attributes["sem"]

  @sem.setter
  def sem(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sem"] = value

  @builtins.property
  def scope(self) -> _ods_ir.Attribute:
    return self.operation.attributes["scope"]

  @scope.setter
  def scope(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["scope"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def atomic_cas(result, ptr, cmp, val, sem, scope, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return AtomicCASOp(result=result, ptr=ptr, cmp=cmp, val=val, sem=sem, scope=scope, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class AtomicRMWOp(_ods_ir.OpView):
  r"""
  load data at $ptr, do $rmw_op with $val, and store result to $ptr.
  
  return old value at $ptr
  """

  OPERATION_NAME = "tt.atomic_rmw"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, atomic_rmw_op, ptr, val, sem, scope, *, mask=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(ptr)
    operands.append(val)
    if mask is not None: operands.append(mask)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["atomic_rmw_op"] = (atomic_rmw_op if (
    isinstance(atomic_rmw_op, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TT_AtomicRMWAttr')) else
      _ods_ir.AttrBuilder.get('TT_AtomicRMWAttr')(atomic_rmw_op, context=_ods_context))
    attributes["sem"] = (sem if (
    isinstance(sem, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TT_MemSemanticAttr')) else
      _ods_ir.AttrBuilder.get('TT_MemSemanticAttr')(sem, context=_ods_context))
    attributes["scope"] = (scope if (
    isinstance(scope, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TT_MemSyncScopeAttr')) else
      _ods_ir.AttrBuilder.get('TT_MemSyncScopeAttr')(scope, context=_ods_context))
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def ptr(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def val(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def mask(self) -> _Optional[_ods_ir.Value]:
    return None if len(self.operation.operands) < 3 else self.operation.operands[2]

  @builtins.property
  def atomic_rmw_op(self) -> _ods_ir.Attribute:
    return self.operation.attributes["atomic_rmw_op"]

  @atomic_rmw_op.setter
  def atomic_rmw_op(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["atomic_rmw_op"] = value

  @builtins.property
  def sem(self) -> _ods_ir.Attribute:
    return self.operation.attributes["sem"]

  @sem.setter
  def sem(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sem"] = value

  @builtins.property
  def scope(self) -> _ods_ir.Attribute:
    return self.operation.attributes["scope"]

  @scope.setter
  def scope(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["scope"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def atomic_rmw(result, atomic_rmw_op, ptr, val, sem, scope, *, mask=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return AtomicRMWOp(result=result, atomic_rmw_op=atomic_rmw_op, ptr=ptr, val=val, sem=sem, scope=scope, mask=mask, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BitcastOp(_ods_ir.OpView):
  OPERATION_NAME = "tt.bitcast"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, src, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(src)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def src(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def bitcast(result, src, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return BitcastOp(result=result, src=src, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BroadcastOp(_ods_ir.OpView):
  r"""
  For a given tensor, broadcast changes one or more dimensions with size 1
  to a new size, e.g. tensor<1x32x1xf32> -> tensor<2x32x4xf32>.  You cannot
  change the size of a non-1 dimension.
  """

  OPERATION_NAME = "tt.broadcast"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, src, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(src)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def src(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def broadcast(result, src, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return BroadcastOp(result=result, src=src, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class CatOp(_ods_ir.OpView):
  OPERATION_NAME = "tt.cat"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, lhs, rhs, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def cat(result, lhs, rhs, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return CatOp(result=result, lhs=lhs, rhs=rhs, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ClampFOp(_ods_ir.OpView):
  r"""
  Clamp operation for floating point types.
  
  The operation takes three arguments: x, min, and max. It returns a tensor of the same shape as x with its values clamped to the range [min, max].
  """

  OPERATION_NAME = "tt.clampf"

  _ODS_REGIONS = (0, True)

  def __init__(self, x, min, max, propagateNan, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(x)
    operands.append(min)
    operands.append(max)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["propagateNan"] = (propagateNan if (
    isinstance(propagateNan, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TT_PropagateNanAttr')) else
      _ods_ir.AttrBuilder.get('TT_PropagateNanAttr')(propagateNan, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def x(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def min(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def max(self) -> _ods_ir.Value:
    return self.operation.operands[2]

  @builtins.property
  def propagateNan(self) -> _ods_ir.Attribute:
    return self.operation.attributes["propagateNan"]

  @propagateNan.setter
  def propagateNan(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["propagateNan"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def clampf(x, min, max, propagate_nan, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return ClampFOp(x=x, min=min, max=max, propagateNan=propagate_nan, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class DescriptorGatherOp(_ods_ir.OpView):
  r"""
  The `tt.descriptor_gather` op will be lowered to NVIDIA TMA
  gather operations on targets that support it.
  
  `desc_ptr` is a pointer to the TMA descriptor allocated in global memory.
  The descriptor block must have 1 row and the indices must be a 1D tensor.
  Accordingly, the result is a 2D tensor multiple rows.
  """

  OPERATION_NAME = "tt.descriptor_gather"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, desc, x_offsets, y_offset, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(desc)
    operands.append(x_offsets)
    operands.append(y_offset)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def desc(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def x_offsets(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def y_offset(self) -> _ods_ir.Value:
    return self.operation.operands[2]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def descriptor_gather(result, desc, x_offsets, y_offset, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return DescriptorGatherOp(result=result, desc=desc, x_offsets=x_offsets, y_offset=y_offset, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class DescriptorLoadOp(_ods_ir.OpView):
  r"""
  This operation will be lowered to Nvidia TMA load operation on targets supporting it.
  `desc` is a tensor descriptor object.
  The destination tensor type and shape must match the descriptor otherwise the result is undefined.
  """

  OPERATION_NAME = "tt.descriptor_load"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, desc, indices, *, cache=None, evict=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(desc)
    operands.extend(_get_op_results_or_values(indices))
    _ods_context = _ods_get_default_loc_context(loc)
    if cache is not None: attributes["cache"] = (cache if (
        isinstance(cache, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('TT_CacheModifierAttr')) else
          _ods_ir.AttrBuilder.get('TT_CacheModifierAttr')(cache, context=_ods_context))
    if evict is not None: attributes["evict"] = (evict if (
        isinstance(evict, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('TT_EvictionPolicyAttr')) else
          _ods_ir.AttrBuilder.get('TT_EvictionPolicyAttr')(evict, context=_ods_context))
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def desc(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def indices(self) -> _ods_ir.OpOperandList:
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def cache(self) -> _ods_ir.Attribute:
    return self.operation.attributes["cache"]

  @cache.setter
  def cache(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["cache"] = value

  @builtins.property
  def evict(self) -> _ods_ir.Attribute:
    return self.operation.attributes["evict"]

  @evict.setter
  def evict(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["evict"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def descriptor_load(result, desc, indices, *, cache=None, evict=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return DescriptorLoadOp(result=result, desc=desc, indices=indices, cache=cache, evict=evict, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class DescriptorReduceOp(_ods_ir.OpView):
  r"""
  This operation will be lowered to Nvidia TMA store operation on targets supporting it.
  `desc` is a tensor descriptor object.
  The shape and types of `src` must match the descriptor otherwise the result is undefined.
  """

  OPERATION_NAME = "tt.descriptor_reduce"

  _ODS_REGIONS = (0, True)

  def __init__(self, kind, desc, src, indices, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(desc)
    operands.append(src)
    operands.extend(_get_op_results_or_values(indices))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["kind"] = (kind if (
    isinstance(kind, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TT_DescriptorReduceKindAttr')) else
      _ods_ir.AttrBuilder.get('TT_DescriptorReduceKindAttr')(kind, context=_ods_context))
    results = []
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def desc(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def src(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def indices(self) -> _ods_ir.OpOperandList:
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[2:2 + _ods_variadic_group_length]

  @builtins.property
  def kind(self) -> _ods_ir.Attribute:
    return self.operation.attributes["kind"]

  @kind.setter
  def kind(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["kind"] = value

def descriptor_reduce(kind, desc, src, indices, *, loc=None, ip=None) -> DescriptorReduceOp:
  return DescriptorReduceOp(kind=kind, desc=desc, src=src, indices=indices, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class DescriptorScatterOp(_ods_ir.OpView):
  r"""
  The `tt.descriptor_scatter` op will be lowered to NVIDIA TMA
  scatter operations on targets that support it.
  
  `desc_ptr` is a pointer to the TMA descriptor allocated in global memory.
  The descriptor block must have 1 row and the indices must be a 1D tensor.
  Accordingly, the result is a 2D tensor multiple rows.
  """

  OPERATION_NAME = "tt.descriptor_scatter"

  _ODS_REGIONS = (0, True)

  def __init__(self, desc, x_offsets, y_offset, src, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(desc)
    operands.append(x_offsets)
    operands.append(y_offset)
    operands.append(src)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def desc(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def x_offsets(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def y_offset(self) -> _ods_ir.Value:
    return self.operation.operands[2]

  @builtins.property
  def src(self) -> _ods_ir.Value:
    return self.operation.operands[3]

def descriptor_scatter(desc, x_offsets, y_offset, src, *, loc=None, ip=None) -> DescriptorScatterOp:
  return DescriptorScatterOp(desc=desc, x_offsets=x_offsets, y_offset=y_offset, src=src, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class DescriptorStoreOp(_ods_ir.OpView):
  r"""
  This operation will be lowered to Nvidia TMA store operation on targets supporting it.
  `desc` is a tensor descriptor object.
  The shape and types of `src` must match the descriptor otherwise the result is undefined.
  """

  OPERATION_NAME = "tt.descriptor_store"

  _ODS_REGIONS = (0, True)

  def __init__(self, desc, src, indices, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(desc)
    operands.append(src)
    operands.extend(_get_op_results_or_values(indices))
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def desc(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def src(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def indices(self) -> _ods_ir.OpOperandList:
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[2:2 + _ods_variadic_group_length]

def descriptor_store(desc, src, indices, *, loc=None, ip=None) -> DescriptorStoreOp:
  return DescriptorStoreOp(desc=desc, src=src, indices=indices, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class DotOp(_ods_ir.OpView):
  r"""
  $d = matrix_multiply($a, $b) + $c. $inputPrecision describes how to exercise the TC
  when the inputs are f32. It can be one of: tf32, tf32x3, ieee.
  tf32: use TC with tf32 ops.
  tf32x3: implement the 3xTF32 trick. For more info see the pass in F32DotTC.cpp
  ieee: don't use TC, implement dot in software.
  If the GPU does not have Tensor cores or the inputs are not f32, this flag is ignored.
  """

  OPERATION_NAME = "tt.dot"

  _ODS_REGIONS = (0, True)

  def __init__(self, a, b, c, *, inputPrecision=None, maxNumImpreciseAcc=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(a)
    operands.append(b)
    operands.append(c)
    _ods_context = _ods_get_default_loc_context(loc)
    if inputPrecision is not None: attributes["inputPrecision"] = (inputPrecision if (
        isinstance(inputPrecision, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('TT_InputPrecisionAttr')) else
          _ods_ir.AttrBuilder.get('TT_InputPrecisionAttr')(inputPrecision, context=_ods_context))
    if maxNumImpreciseAcc is not None: attributes["maxNumImpreciseAcc"] = (maxNumImpreciseAcc if (
        isinstance(maxNumImpreciseAcc, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I32Attr')) else
          _ods_ir.AttrBuilder.get('I32Attr')(maxNumImpreciseAcc, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def a(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def b(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def c(self) -> _ods_ir.Value:
    return self.operation.operands[2]

  @builtins.property
  def inputPrecision(self) -> _ods_ir.Attribute:
    return self.operation.attributes["inputPrecision"]

  @inputPrecision.setter
  def inputPrecision(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["inputPrecision"] = value

  @builtins.property
  def maxNumImpreciseAcc(self) -> _ods_ir.IntegerAttr:
    return self.operation.attributes["maxNumImpreciseAcc"]

  @maxNumImpreciseAcc.setter
  def maxNumImpreciseAcc(self, value: _ods_ir.IntegerAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["maxNumImpreciseAcc"] = value

  @builtins.property
  def d(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def dot(a, b, c, *, input_precision=None, max_num_imprecise_acc=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return DotOp(a=a, b=b, c=c, inputPrecision=input_precision, maxNumImpreciseAcc=max_num_imprecise_acc, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class DotScaledOp(_ods_ir.OpView):
  r"""
  $d = matrix_multiply(scale($a, $a_scale), scale($b, $b_scale)) + $c.
  Where scale(x, s) is a function that applies the scale per block following microscaling spec.
  """

  OPERATION_NAME = "tt.dot_scaled"

  _ODS_OPERAND_SEGMENTS = [1,1,1,0,0,]

  _ODS_REGIONS = (0, True)

  def __init__(self, d, a, b, c, a_elem_type, b_elem_type, fastMath, *, a_scale=None, b_scale=None, lhs_k_pack=None, rhs_k_pack=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(a)
    operands.append(b)
    operands.append(c)
    operands.append(a_scale)
    operands.append(b_scale)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["a_elem_type"] = (a_elem_type if (
    isinstance(a_elem_type, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TT_ScaleDotElemTypeAttr')) else
      _ods_ir.AttrBuilder.get('TT_ScaleDotElemTypeAttr')(a_elem_type, context=_ods_context))
    attributes["b_elem_type"] = (b_elem_type if (
    isinstance(b_elem_type, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TT_ScaleDotElemTypeAttr')) else
      _ods_ir.AttrBuilder.get('TT_ScaleDotElemTypeAttr')(b_elem_type, context=_ods_context))
    attributes["fastMath"] = (fastMath if (
    isinstance(fastMath, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('BoolAttr')) else
      _ods_ir.AttrBuilder.get('BoolAttr')(fastMath, context=_ods_context))
    if lhs_k_pack is not None: attributes["lhs_k_pack"] = (lhs_k_pack if (
        isinstance(lhs_k_pack, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(lhs_k_pack, context=_ods_context))
    if rhs_k_pack is not None: attributes["rhs_k_pack"] = (rhs_k_pack if (
        isinstance(rhs_k_pack, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(rhs_k_pack, context=_ods_context))
    results = []
    results.append(d)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def a(self) -> _ods_ir.Value:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def b(self) -> _ods_ir.Value:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0]

  @builtins.property
  def c(self) -> _ods_ir.Value:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range[0]

  @builtins.property
  def a_scale(self) -> _Optional[_ods_ir.Value]:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def b_scale(self) -> _Optional[_ods_ir.Value]:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 4)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def a_elem_type(self) -> _ods_ir.Attribute:
    return self.operation.attributes["a_elem_type"]

  @a_elem_type.setter
  def a_elem_type(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["a_elem_type"] = value

  @builtins.property
  def b_elem_type(self) -> _ods_ir.Attribute:
    return self.operation.attributes["b_elem_type"]

  @b_elem_type.setter
  def b_elem_type(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["b_elem_type"] = value

  @builtins.property
  def fastMath(self) -> _ods_ir.BoolAttr:
    return self.operation.attributes["fastMath"]

  @fastMath.setter
  def fastMath(self, value: _ods_ir.BoolAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastMath"] = value

  @builtins.property
  def lhs_k_pack(self) -> _ods_ir.BoolAttr:
    return self.operation.attributes["lhs_k_pack"]

  @lhs_k_pack.setter
  def lhs_k_pack(self, value: _ods_ir.BoolAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["lhs_k_pack"] = value

  @builtins.property
  def rhs_k_pack(self) -> _ods_ir.BoolAttr:
    return self.operation.attributes["rhs_k_pack"]

  @rhs_k_pack.setter
  def rhs_k_pack(self, value: _ods_ir.BoolAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["rhs_k_pack"] = value

  @builtins.property
  def d(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def dot_scaled(d, a, b, c, a_elem_type, b_elem_type, fast_math, *, a_scale=None, b_scale=None, lhs_k_pack=None, rhs_k_pack=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return DotScaledOp(d=d, a=a, b=b, c=c, a_elem_type=a_elem_type, b_elem_type=b_elem_type, fastMath=fast_math, a_scale=a_scale, b_scale=b_scale, lhs_k_pack=lhs_k_pack, rhs_k_pack=rhs_k_pack, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ElementwiseInlineAsmOp(_ods_ir.OpView):
  r"""
  Runs an inline asm block to generate one or more tensors.
  
  The asm block is given `packed_element` elements at a time.  Exactly which
  elems it receives is unspecified.
  """

  OPERATION_NAME = "tt.elementwise_inline_asm"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, asm_string, constraints, pure, packed_element, args, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(args))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["asm_string"] = (asm_string if (
    isinstance(asm_string, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(asm_string, context=_ods_context))
    attributes["constraints"] = (constraints if (
    isinstance(constraints, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(constraints, context=_ods_context))
    attributes["pure"] = (pure if (
    isinstance(pure, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('BoolAttr')) else
      _ods_ir.AttrBuilder.get('BoolAttr')(pure, context=_ods_context))
    attributes["packed_element"] = (packed_element if (
    isinstance(packed_element, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(packed_element, context=_ods_context))
    results = []
    results.extend(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def args(self) -> _ods_ir.OpOperandList:
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def asm_string(self) -> _ods_ir.StringAttr:
    return self.operation.attributes["asm_string"]

  @asm_string.setter
  def asm_string(self, value: _ods_ir.StringAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["asm_string"] = value

  @builtins.property
  def constraints(self) -> _ods_ir.StringAttr:
    return self.operation.attributes["constraints"]

  @constraints.setter
  def constraints(self, value: _ods_ir.StringAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["constraints"] = value

  @builtins.property
  def pure(self) -> _ods_ir.BoolAttr:
    return self.operation.attributes["pure"]

  @pure.setter
  def pure(self, value: _ods_ir.BoolAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["pure"] = value

  @builtins.property
  def packed_element(self) -> _ods_ir.IntegerAttr:
    return self.operation.attributes["packed_element"]

  @packed_element.setter
  def packed_element(self, value: _ods_ir.IntegerAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["packed_element"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResultList:
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

def elementwise_inline_asm(result, asm_string, constraints, pure, packed_element, args, *, loc=None, ip=None) -> _Union[_ods_ir.OpResult, _ods_ir.OpResultList, ElementwiseInlineAsmOp]:
  op = ElementwiseInlineAsmOp(result=result, asm_string=asm_string, constraints=constraints, pure=pure, packed_element=packed_element, args=args, loc=loc, ip=ip); results = op.results
  return results if len(results) > 1 else (results[0] if len(results) == 1 else op)

@_ods_cext.register_operation(_Dialect)
class ExpandDimsOp(_ods_ir.OpView):
  OPERATION_NAME = "tt.expand_dims"

  _ODS_REGIONS = (0, True)

  def __init__(self, src, axis, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(src)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["axis"] = (axis if (
    isinstance(axis, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(axis, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def src(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def axis(self) -> _ods_ir.IntegerAttr:
    return self.operation.attributes["axis"]

  @axis.setter
  def axis(self, value: _ods_ir.IntegerAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["axis"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def expand_dims(src, axis, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return ExpandDimsOp(src=src, axis=axis, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ExternElementwiseOp(_ods_ir.OpView):
  r"""
  call an external function $symbol implemented in $libpath/$libname with $args
  return $libpath/$libname:$symbol($args...)
  """

  OPERATION_NAME = "tt.extern_elementwise"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, srcs, libname, libpath, symbol, pure, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(srcs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["libname"] = (libname if (
    isinstance(libname, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(libname, context=_ods_context))
    attributes["libpath"] = (libpath if (
    isinstance(libpath, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(libpath, context=_ods_context))
    attributes["symbol"] = (symbol if (
    isinstance(symbol, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(symbol, context=_ods_context))
    attributes["pure"] = (pure if (
    isinstance(pure, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('BoolAttr')) else
      _ods_ir.AttrBuilder.get('BoolAttr')(pure, context=_ods_context))
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def srcs(self) -> _ods_ir.OpOperandList:
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def libname(self) -> _ods_ir.StringAttr:
    return self.operation.attributes["libname"]

  @libname.setter
  def libname(self, value: _ods_ir.StringAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["libname"] = value

  @builtins.property
  def libpath(self) -> _ods_ir.StringAttr:
    return self.operation.attributes["libpath"]

  @libpath.setter
  def libpath(self, value: _ods_ir.StringAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["libpath"] = value

  @builtins.property
  def symbol(self) -> _ods_ir.StringAttr:
    return self.operation.attributes["symbol"]

  @symbol.setter
  def symbol(self, value: _ods_ir.StringAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["symbol"] = value

  @builtins.property
  def pure(self) -> _ods_ir.BoolAttr:
    return self.operation.attributes["pure"]

  @pure.setter
  def pure(self, value: _ods_ir.BoolAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["pure"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def extern_elementwise(result, srcs, libname, libpath, symbol, pure, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return ExternElementwiseOp(result=result, srcs=srcs, libname=libname, libpath=libpath, symbol=symbol, pure=pure, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class FpToFpOp(_ods_ir.OpView):
  r"""
  Floating point casting for custom types (F8), and non-default rounding modes.
  
  F8 <-> FP16, BF16, FP32, FP64
  """

  OPERATION_NAME = "tt.fp_to_fp"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, src, *, rounding=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(src)
    _ods_context = _ods_get_default_loc_context(loc)
    if rounding is not None: attributes["rounding"] = (rounding if (
        isinstance(rounding, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('TT_RoundingModeAttr')) else
          _ods_ir.AttrBuilder.get('TT_RoundingModeAttr')(rounding, context=_ods_context))
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def src(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rounding(self) -> _Optional[_ods_ir.Attribute]:
    if "rounding" not in self.operation.attributes:
      return None
    return self.operation.attributes["rounding"]

  @rounding.setter
  def rounding(self, value: _Optional[_ods_ir.Attribute]):
    if value is not None:
      self.operation.attributes["rounding"] = value
    elif "rounding" in self.operation.attributes:
      del self.operation.attributes["rounding"]

  @rounding.deleter
  def rounding(self):
    del self.operation.attributes["rounding"]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def fp_to_fp(result, src, *, rounding=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return FpToFpOp(result=result, src=src, rounding=rounding, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class GatherOp(_ods_ir.OpView):
  r"""
  Gather elements from the input tensor using the indices tensor along a
  single specified axis. The output tensor has the same shape as the indices
  tensor. The input and indices tensors must have the same number of
  dimension, and each dimension of the indices tensor that is not the gather
  dimension cannot be greater than the corresponding dimension in the input
  tensor.
  
  The `efficient_layout` attribute is set when the compiler has determined an
  optimized layout for the operation, indicating that it should not be
  changed.
  """

  OPERATION_NAME = "tt.gather"

  _ODS_REGIONS = (0, True)

  def __init__(self, src, indices, axis, *, efficient_layout=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(src)
    operands.append(indices)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["axis"] = (axis if (
    isinstance(axis, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(axis, context=_ods_context))
    if bool(efficient_layout): attributes["efficient_layout"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def src(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def indices(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def axis(self) -> _ods_ir.IntegerAttr:
    return self.operation.attributes["axis"]

  @axis.setter
  def axis(self, value: _ods_ir.IntegerAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["axis"] = value

  @builtins.property
  def efficient_layout(self) -> bool:
    return "efficient_layout" in self.operation.attributes

  @efficient_layout.setter
  def efficient_layout(self, value):
    if bool(value):
      self.operation.attributes["efficient_layout"] = _ods_ir.UnitAttr.get()
    elif "efficient_layout" in self.operation.attributes:
      del self.operation.attributes["efficient_layout"]

  @efficient_layout.deleter
  def efficient_layout(self):
    del self.operation.attributes["efficient_layout"]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def gather(src, indices, axis, *, efficient_layout=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return GatherOp(src=src, indices=indices, axis=axis, efficient_layout=efficient_layout, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class GetNumProgramsOp(_ods_ir.OpView):
  OPERATION_NAME = "tt.get_num_programs"

  _ODS_REGIONS = (0, True)

  def __init__(self, axis, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["axis"] = (axis if (
    isinstance(axis, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TT_ProgramDim')) else
      _ods_ir.AttrBuilder.get('TT_ProgramDim')(axis, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def axis(self) -> _ods_ir.Attribute:
    return self.operation.attributes["axis"]

  @axis.setter
  def axis(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["axis"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def get_num_programs(axis, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return GetNumProgramsOp(axis=axis, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class GetProgramIdOp(_ods_ir.OpView):
  OPERATION_NAME = "tt.get_program_id"

  _ODS_REGIONS = (0, True)

  def __init__(self, axis, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["axis"] = (axis if (
    isinstance(axis, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TT_ProgramDim')) else
      _ods_ir.AttrBuilder.get('TT_ProgramDim')(axis, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def axis(self) -> _ods_ir.Attribute:
    return self.operation.attributes["axis"]

  @axis.setter
  def axis(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["axis"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def get_program_id(axis, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return GetProgramIdOp(axis=axis, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class HistogramOp(_ods_ir.OpView):
  r"""
  Return the histogram of the input tensor. The number of bins is equal to
  the dimension of the output tensor. Each bins has a width of 1 and bins
  start at 0.
  """

  OPERATION_NAME = "tt.histogram"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, src, *, mask=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(src)
    if mask is not None: operands.append(mask)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def src(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def mask(self) -> _Optional[_ods_ir.Value]:
    return None if len(self.operation.operands) < 2 else self.operation.operands[1]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def histogram(result, src, *, mask=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return HistogramOp(result=result, src=src, mask=mask, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class IntToPtrOp(_ods_ir.OpView):
  OPERATION_NAME = "tt.int_to_ptr"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, src, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(src)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def src(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def int_to_ptr(result, src, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return IntToPtrOp(result=result, src=src, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class JoinOp(_ods_ir.OpView):
  r"""
  For example, if the two input tensors are 4x8xf32, returns a tensor of
  shape 4x8x2xf32.
  
  Because Triton tensors always have a power-of-two number of elements,
  the two input tensors must have the same shape.
  """

  OPERATION_NAME = "tt.join"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, lhs, rhs, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def join(result, lhs, rhs, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return JoinOp(result=result, lhs=lhs, rhs=rhs, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class LoadOp(_ods_ir.OpView):
  OPERATION_NAME = "tt.load"

  _ODS_OPERAND_SEGMENTS = [1,0,0,]

  _ODS_REGIONS = (0, True)

  def __init__(self, ptr, *, mask=None, other=None, boundaryCheck=None, padding=None, cache=None, evict=None, isVolatile=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(ptr)
    operands.append(mask)
    operands.append(other)
    _ods_context = _ods_get_default_loc_context(loc)
    if boundaryCheck is not None: attributes["boundaryCheck"] = (boundaryCheck if (
        isinstance(boundaryCheck, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(boundaryCheck, context=_ods_context))
    if padding is not None: attributes["padding"] = (padding if (
        isinstance(padding, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('TT_PaddingOptionAttr')) else
          _ods_ir.AttrBuilder.get('TT_PaddingOptionAttr')(padding, context=_ods_context))
    if cache is not None: attributes["cache"] = (cache if (
        isinstance(cache, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('TT_CacheModifierAttr')) else
          _ods_ir.AttrBuilder.get('TT_CacheModifierAttr')(cache, context=_ods_context))
    if evict is not None: attributes["evict"] = (evict if (
        isinstance(evict, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('TT_EvictionPolicyAttr')) else
          _ods_ir.AttrBuilder.get('TT_EvictionPolicyAttr')(evict, context=_ods_context))
    if isVolatile is not None: attributes["isVolatile"] = (isVolatile if (
        isinstance(isVolatile, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(isVolatile, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def ptr(self) -> _ods_ir.Value:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def mask(self) -> _Optional[_ods_ir.Value]:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def other(self) -> _Optional[_ods_ir.Value]:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def boundaryCheck(self) -> _ods_ir.DenseI32ArrayAttr:
    return self.operation.attributes["boundaryCheck"]

  @boundaryCheck.setter
  def boundaryCheck(self, value: _ods_ir.DenseI32ArrayAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["boundaryCheck"] = value

  @builtins.property
  def padding(self) -> _Optional[_ods_ir.Attribute]:
    if "padding" not in self.operation.attributes:
      return None
    return self.operation.attributes["padding"]

  @padding.setter
  def padding(self, value: _Optional[_ods_ir.Attribute]):
    if value is not None:
      self.operation.attributes["padding"] = value
    elif "padding" in self.operation.attributes:
      del self.operation.attributes["padding"]

  @padding.deleter
  def padding(self):
    del self.operation.attributes["padding"]

  @builtins.property
  def cache(self) -> _ods_ir.Attribute:
    return self.operation.attributes["cache"]

  @cache.setter
  def cache(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["cache"] = value

  @builtins.property
  def evict(self) -> _ods_ir.Attribute:
    return self.operation.attributes["evict"]

  @evict.setter
  def evict(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["evict"] = value

  @builtins.property
  def isVolatile(self) -> _ods_ir.BoolAttr:
    return self.operation.attributes["isVolatile"]

  @isVolatile.setter
  def isVolatile(self, value: _ods_ir.BoolAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["isVolatile"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def load(ptr, *, mask=None, other=None, boundary_check=None, padding=None, cache=None, evict=None, is_volatile=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return LoadOp(ptr=ptr, mask=mask, other=other, boundaryCheck=boundary_check, padding=padding, cache=cache, evict=evict, isVolatile=is_volatile, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MakeRangeOp(_ods_ir.OpView):
  r"""
  Returns an 1D int32 tensor.
  
  Values span from $start to $end (exclusive), with step = 1
  """

  OPERATION_NAME = "tt.make_range"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, start, end, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["start"] = (start if (
    isinstance(start, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(start, context=_ods_context))
    attributes["end"] = (end if (
    isinstance(end, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(end, context=_ods_context))
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def start(self) -> _ods_ir.IntegerAttr:
    return self.operation.attributes["start"]

  @start.setter
  def start(self, value: _ods_ir.IntegerAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["start"] = value

  @builtins.property
  def end(self) -> _ods_ir.IntegerAttr:
    return self.operation.attributes["end"]

  @end.setter
  def end(self, value: _ods_ir.IntegerAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["end"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def make_range(result, start, end, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return MakeRangeOp(result=result, start=start, end=end, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MakeTensorDescOp(_ods_ir.OpView):
  r"""
  `tt.make_tensor_descriptor` takes both meta information of the parent tensor and the block size,
  and returns a descriptor object which can be used to load/store from the tensor in global memory.
  """

  OPERATION_NAME = "tt.make_tensor_descriptor"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, base, shape, strides, *, padding=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(base)
    operands.extend(_get_op_results_or_values(shape))
    operands.extend(_get_op_results_or_values(strides))
    _ods_context = _ods_get_default_loc_context(loc)
    if padding is not None: attributes["padding"] = (padding if (
        isinstance(padding, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('TT_PaddingOptionAttr')) else
          _ods_ir.AttrBuilder.get('TT_PaddingOptionAttr')(padding, context=_ods_context))
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def base(self) -> _ods_ir.Value:
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.operands, 1, 2, 0, 0)
    return self.operation.operands[start]

  @builtins.property
  def shape(self) -> _ods_ir.OpOperandList:
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.operands, 1, 2, 1, 0)
    return self.operation.operands[start:start + elements_per_group]

  @builtins.property
  def strides(self) -> _ods_ir.OpOperandList:
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.operands, 1, 2, 1, 1)
    return self.operation.operands[start:start + elements_per_group]

  @builtins.property
  def padding(self) -> _ods_ir.Attribute:
    return self.operation.attributes["padding"]

  @padding.setter
  def padding(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["padding"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def make_tensor_descriptor(result, base, shape, strides, *, padding=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return MakeTensorDescOp(result=result, base=base, shape=shape, strides=strides, padding=padding, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MakeTensorPtrOp(_ods_ir.OpView):
  r"""
  `tt.make_tensor_ptr` takes both meta information of the parent tensor and the block tensor, then it returns a
  pointer to the block tensor, e.g. returns a type of `tt.ptr<tensor<8x8xf16>>`.
  """

  OPERATION_NAME = "tt.make_tensor_ptr"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, base, shape, strides, offsets, order, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(base)
    operands.extend(_get_op_results_or_values(shape))
    operands.extend(_get_op_results_or_values(strides))
    operands.extend(_get_op_results_or_values(offsets))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["order"] = (order if (
    isinstance(order, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(order, context=_ods_context))
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def base(self) -> _ods_ir.Value:
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.operands, 1, 3, 0, 0)
    return self.operation.operands[start]

  @builtins.property
  def shape(self) -> _ods_ir.OpOperandList:
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.operands, 1, 3, 1, 0)
    return self.operation.operands[start:start + elements_per_group]

  @builtins.property
  def strides(self) -> _ods_ir.OpOperandList:
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.operands, 1, 3, 1, 1)
    return self.operation.operands[start:start + elements_per_group]

  @builtins.property
  def offsets(self) -> _ods_ir.OpOperandList:
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.operands, 1, 3, 1, 2)
    return self.operation.operands[start:start + elements_per_group]

  @builtins.property
  def order(self) -> _ods_ir.DenseI32ArrayAttr:
    return self.operation.attributes["order"]

  @order.setter
  def order(self, value: _ods_ir.DenseI32ArrayAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["order"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def make_tensor_ptr(result, base, shape, strides, offsets, order, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return MakeTensorPtrOp(result=result, base=base, shape=shape, strides=strides, offsets=offsets, order=order, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MapElementwiseOp(_ods_ir.OpView):
  OPERATION_NAME = "tt.map_elementwise"

  _ODS_REGIONS = (1, True)

  def __init__(self, result, srcs, pack, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(srcs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["pack"] = (pack if (
    isinstance(pack, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(pack, context=_ods_context))
    results = []
    results.extend(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def srcs(self) -> _ods_ir.OpOperandList:
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def pack(self) -> _ods_ir.IntegerAttr:
    return self.operation.attributes["pack"]

  @pack.setter
  def pack(self, value: _ods_ir.IntegerAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["pack"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResultList:
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def scalarOp(self) -> _ods_ir.Region:
    return self.regions[0]

def map_elementwise(result, srcs, pack, *, loc=None, ip=None) -> _Union[_ods_ir.OpResult, _ods_ir.OpResultList, MapElementwiseOp]:
  op = MapElementwiseOp(result=result, srcs=srcs, pack=pack, loc=loc, ip=ip); results = op.results
  return results if len(results) > 1 else (results[0] if len(results) == 1 else op)

@_ods_cext.register_operation(_Dialect)
class MapElementwiseReturnOp(_ods_ir.OpView):
  OPERATION_NAME = "tt.map_elementwise.return"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(result))
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def result(self) -> _ods_ir.OpOperandList:
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

def map_elementwise_return(result, *, loc=None, ip=None) -> MapElementwiseReturnOp:
  return MapElementwiseReturnOp(result=result, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class MulhiUIOp(_ods_ir.OpView):
  r"""
  Most significant N bits of the 2N-bit product of two integers.
  """

  OPERATION_NAME = "tt.mulhiui"

  _ODS_REGIONS = (0, True)

  def __init__(self, x, y, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(x)
    operands.append(y)
    _ods_context = _ods_get_default_loc_context(loc)
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def x(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def y(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def mulhiui(x, y, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return MulhiUIOp(x=x, y=y, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class PreciseDivFOp(_ods_ir.OpView):
  r"""
  Precise div for floating point types.
  """

  OPERATION_NAME = "tt.precise_divf"

  _ODS_REGIONS = (0, True)

  def __init__(self, x, y, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(x)
    operands.append(y)
    _ods_context = _ods_get_default_loc_context(loc)
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def x(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def y(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def precise_divf(x, y, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return PreciseDivFOp(x=x, y=y, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class PreciseSqrtOp(_ods_ir.OpView):
  r"""
  Precise sqrt for floating point types.
  """

  OPERATION_NAME = "tt.precise_sqrt"

  _ODS_REGIONS = (0, True)

  def __init__(self, x, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(x)
    _ods_context = _ods_get_default_loc_context(loc)
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def x(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def precise_sqrt(x, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return PreciseSqrtOp(x=x, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class PrintOp(_ods_ir.OpView):
  r"""
  `tt.print` takes a literal string prefix and an arbitrary number of scalar or tensor arguments that should be printed.
  format are generated automatically from the arguments.
  """

  OPERATION_NAME = "tt.print"

  _ODS_REGIONS = (0, True)

  def __init__(self, prefix, hex, args, isSigned, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(args))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["prefix"] = (prefix if (
    isinstance(prefix, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(prefix, context=_ods_context))
    attributes["hex"] = (hex if (
    isinstance(hex, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('BoolAttr')) else
      _ods_ir.AttrBuilder.get('BoolAttr')(hex, context=_ods_context))
    attributes["isSigned"] = (isSigned if (
    isinstance(isSigned, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(isSigned, context=_ods_context))
    results = []
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def args(self) -> _ods_ir.OpOperandList:
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def prefix(self) -> _ods_ir.StringAttr:
    return self.operation.attributes["prefix"]

  @prefix.setter
  def prefix(self, value: _ods_ir.StringAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["prefix"] = value

  @builtins.property
  def hex(self) -> _ods_ir.BoolAttr:
    return self.operation.attributes["hex"]

  @hex.setter
  def hex(self, value: _ods_ir.BoolAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["hex"] = value

  @builtins.property
  def isSigned(self) -> _ods_ir.DenseI32ArrayAttr:
    return self.operation.attributes["isSigned"]

  @isSigned.setter
  def isSigned(self, value: _ods_ir.DenseI32ArrayAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["isSigned"] = value

def print_(prefix, hex, args, is_signed, *, loc=None, ip=None) -> PrintOp:
  return PrintOp(prefix=prefix, hex=hex, args=args, isSigned=is_signed, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class PtrToIntOp(_ods_ir.OpView):
  OPERATION_NAME = "tt.ptr_to_int"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, src, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(src)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def src(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def ptr_to_int(result, src, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return PtrToIntOp(result=result, src=src, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ReduceOp(_ods_ir.OpView):
  OPERATION_NAME = "tt.reduce"

  _ODS_REGIONS = (1, True)

  def __init__(self, result, srcs, axis, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(srcs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["axis"] = (axis if (
    isinstance(axis, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(axis, context=_ods_context))
    results = []
    results.extend(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def srcs(self) -> _ods_ir.OpOperandList:
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def axis(self) -> _ods_ir.IntegerAttr:
    return self.operation.attributes["axis"]

  @axis.setter
  def axis(self, value: _ods_ir.IntegerAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["axis"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResultList:
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def combineOp(self) -> _ods_ir.Region:
    return self.regions[0]

def reduce(result, srcs, axis, *, loc=None, ip=None) -> _Union[_ods_ir.OpResult, _ods_ir.OpResultList, ReduceOp]:
  op = ReduceOp(result=result, srcs=srcs, axis=axis, loc=loc, ip=ip); results = op.results
  return results if len(results) > 1 else (results[0] if len(results) == 1 else op)

@_ods_cext.register_operation(_Dialect)
class ReduceReturnOp(_ods_ir.OpView):
  OPERATION_NAME = "tt.reduce.return"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(result))
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def result(self) -> _ods_ir.OpOperandList:
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

def reduce_return(result, *, loc=None, ip=None) -> ReduceReturnOp:
  return ReduceReturnOp(result=result, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class ReshapeOp(_ods_ir.OpView):
  r"""
  reinterpret a tensor to a different shape.
  
  If allow_reorder is set the compiler is free to change the order of
  elements to generate more efficient code.
  
  If efficient_layout is set, this is a hint that the destination layout should be kept for performance reason.
  The compiler is still free to change it for better performance.
  """

  OPERATION_NAME = "tt.reshape"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, src, *, allow_reorder=None, efficient_layout=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(src)
    _ods_context = _ods_get_default_loc_context(loc)
    if bool(allow_reorder): attributes["allow_reorder"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if bool(efficient_layout): attributes["efficient_layout"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def src(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def allow_reorder(self) -> bool:
    return "allow_reorder" in self.operation.attributes

  @allow_reorder.setter
  def allow_reorder(self, value):
    if bool(value):
      self.operation.attributes["allow_reorder"] = _ods_ir.UnitAttr.get()
    elif "allow_reorder" in self.operation.attributes:
      del self.operation.attributes["allow_reorder"]

  @allow_reorder.deleter
  def allow_reorder(self):
    del self.operation.attributes["allow_reorder"]

  @builtins.property
  def efficient_layout(self) -> bool:
    return "efficient_layout" in self.operation.attributes

  @efficient_layout.setter
  def efficient_layout(self, value):
    if bool(value):
      self.operation.attributes["efficient_layout"] = _ods_ir.UnitAttr.get()
    elif "efficient_layout" in self.operation.attributes:
      del self.operation.attributes["efficient_layout"]

  @efficient_layout.deleter
  def efficient_layout(self):
    del self.operation.attributes["efficient_layout"]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def reshape(result, src, *, allow_reorder=None, efficient_layout=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return ReshapeOp(result=result, src=src, allow_reorder=allow_reorder, efficient_layout=efficient_layout, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ScanOp(_ods_ir.OpView):
  OPERATION_NAME = "tt.scan"

  _ODS_REGIONS = (1, True)

  def __init__(self, result, srcs, axis, reverse, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(srcs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["axis"] = (axis if (
    isinstance(axis, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(axis, context=_ods_context))
    attributes["reverse"] = (reverse if (
    isinstance(reverse, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('BoolAttr')) else
      _ods_ir.AttrBuilder.get('BoolAttr')(reverse, context=_ods_context))
    results = []
    results.extend(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def srcs(self) -> _ods_ir.OpOperandList:
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def axis(self) -> _ods_ir.IntegerAttr:
    return self.operation.attributes["axis"]

  @axis.setter
  def axis(self, value: _ods_ir.IntegerAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["axis"] = value

  @builtins.property
  def reverse(self) -> _ods_ir.BoolAttr:
    return self.operation.attributes["reverse"]

  @reverse.setter
  def reverse(self, value: _ods_ir.BoolAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["reverse"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResultList:
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def combineOp(self) -> _ods_ir.Region:
    return self.regions[0]

def scan(result, srcs, axis, reverse, *, loc=None, ip=None) -> _Union[_ods_ir.OpResult, _ods_ir.OpResultList, ScanOp]:
  op = ScanOp(result=result, srcs=srcs, axis=axis, reverse=reverse, loc=loc, ip=ip); results = op.results
  return results if len(results) > 1 else (results[0] if len(results) == 1 else op)

@_ods_cext.register_operation(_Dialect)
class ScanReturnOp(_ods_ir.OpView):
  OPERATION_NAME = "tt.scan.return"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(result))
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def result(self) -> _ods_ir.OpOperandList:
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

def scan_return(result, *, loc=None, ip=None) -> ScanReturnOp:
  return ScanReturnOp(result=result, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class SplatOp(_ods_ir.OpView):
  OPERATION_NAME = "tt.splat"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, src, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(src)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def src(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def splat(result, src, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return SplatOp(result=result, src=src, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class SplitOp(_ods_ir.OpView):
  r"""
  The input must be a tensor whose last dimension has size 2.  Returns two
  tensors, src[..., 0] and src[..., 1].
  
  For example, if the input shape is 4x8x2xf32, returns two tensors of
  shape 4x8xf32.
  """

  OPERATION_NAME = "tt.split"

  _ODS_REGIONS = (0, True)

  def __init__(self, src, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(src)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def src(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def outLHS(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

  @builtins.property
  def outRHS(self) -> _ods_ir.OpResult:
    return self.operation.results[1]

def split(src, *, results=None, loc=None, ip=None) -> _ods_ir.OpResultList:
  return SplitOp(src=src, results=results, loc=loc, ip=ip).results

@_ods_cext.register_operation(_Dialect)
class StoreOp(_ods_ir.OpView):
  OPERATION_NAME = "tt.store"

  _ODS_REGIONS = (0, True)

  def __init__(self, ptr, value, *, mask=None, boundaryCheck=None, cache=None, evict=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(ptr)
    operands.append(value)
    if mask is not None: operands.append(mask)
    _ods_context = _ods_get_default_loc_context(loc)
    if boundaryCheck is not None: attributes["boundaryCheck"] = (boundaryCheck if (
        isinstance(boundaryCheck, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
          _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(boundaryCheck, context=_ods_context))
    if cache is not None: attributes["cache"] = (cache if (
        isinstance(cache, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('TT_CacheModifierAttr')) else
          _ods_ir.AttrBuilder.get('TT_CacheModifierAttr')(cache, context=_ods_context))
    if evict is not None: attributes["evict"] = (evict if (
        isinstance(evict, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('TT_EvictionPolicyAttr')) else
          _ods_ir.AttrBuilder.get('TT_EvictionPolicyAttr')(evict, context=_ods_context))
    results = []
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def ptr(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def value(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def mask(self) -> _Optional[_ods_ir.Value]:
    return None if len(self.operation.operands) < 3 else self.operation.operands[2]

  @builtins.property
  def boundaryCheck(self) -> _ods_ir.DenseI32ArrayAttr:
    return self.operation.attributes["boundaryCheck"]

  @boundaryCheck.setter
  def boundaryCheck(self, value: _ods_ir.DenseI32ArrayAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["boundaryCheck"] = value

  @builtins.property
  def cache(self) -> _ods_ir.Attribute:
    return self.operation.attributes["cache"]

  @cache.setter
  def cache(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["cache"] = value

  @builtins.property
  def evict(self) -> _ods_ir.Attribute:
    return self.operation.attributes["evict"]

  @evict.setter
  def evict(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["evict"] = value

def store(ptr, value, *, mask=None, boundary_check=None, cache=None, evict=None, loc=None, ip=None) -> StoreOp:
  return StoreOp(ptr=ptr, value=value, mask=mask, boundaryCheck=boundary_check, cache=cache, evict=evict, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class TransOp(_ods_ir.OpView):
  r"""
  For example, given a tensor x with shape [1,2,4], transpose(x) with
  order=[2,0,1] rearranges the tensor to have shape [4,1,2].
  
  Although this op is called "trans", it implements both tl.trans() and
  tl.permute().  ("permute" might be a better name, but it's called "trans"
  because originally it only supported 2D tensors.)
  
  ## Implementation note on encodings:
  
  In the TritonGPU dialect (and probably others), an encoding is chosen for
  this op's output so it's a nop from the perspective of code generation.
  
  For example, suppose tensor x has an encoding such that GPU thread [i,j,k]
  has a register containing element [i,j,k] of the tensor.  Now we transpose
  x with order [2,1,0], i.e. we reverse the order of its dimensions.  In
  TritonGPU, we will choose a layout for the output of the transpose so that
  GPU thread [i,j,k] has element [k,j,i] of transpose(x).  But this is the
  same element it had before!  All we've done is "rename" the element that
  thread [i,j,k] has.
  
  The "real" transpose -- i.e. moving data between GPU threads -- occurs in
  convertLayout ops that appear before and/or after the operation.
  
  We do this so that you can chain multiple data-movement ops (e.g.
  transpose+reshape+concat) without going to shared memory after each one.
  """

  OPERATION_NAME = "tt.trans"

  _ODS_REGIONS = (0, True)

  def __init__(self, src, order, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(src)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["order"] = (order if (
    isinstance(order, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(order, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def src(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def order(self) -> _ods_ir.DenseI32ArrayAttr:
    return self.operation.attributes["order"]

  @order.setter
  def order(self, value: _ods_ir.DenseI32ArrayAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["order"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def trans(src, order, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return TransOp(src=src, order=order, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class UnsplatOp(_ods_ir.OpView):
  OPERATION_NAME = "tt.unsplat"

  _ODS_REGIONS = (0, True)

  def __init__(self, src, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(src)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def src(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def unsplat(src, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return UnsplatOp(src=src, results=results, loc=loc, ip=ip).result
