
# Autogenerated by mlir-tblgen; don't manually edit.

from enum import IntEnum, auto, IntFlag
from ._ods_common import _cext as _ods_cext
from ..ir import register_attribute_builder
_ods_ir = _ods_cext.ir

class CrdTransDirectionKind(IntEnum):
    """sparse tensor coordinate translation direction"""

    dim2lvl = 0
    lvl2dim = 1

    def __str__(self):
        if self is CrdTransDirectionKind.dim2lvl:
            return "dim_to_lvl"
        if self is CrdTransDirectionKind.lvl2dim:
            return "lvl_to_dim"
        raise ValueError("Unknown CrdTransDirectionKind enum entry.")



@register_attribute_builder("SparseTensorCrdTransDirectionEnum")
def _sparsetensorcrdtransdirectionenum(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class SparseTensorSortKind(IntEnum):
    """sparse tensor sort algorithm"""

    HybridQuickSort = 0
    InsertionSortStable = 1
    QuickSort = 2
    HeapSort = 3

    def __str__(self):
        if self is SparseTensorSortKind.HybridQuickSort:
            return "hybrid_quick_sort"
        if self is SparseTensorSortKind.InsertionSortStable:
            return "insertion_sort_stable"
        if self is SparseTensorSortKind.QuickSort:
            return "quick_sort"
        if self is SparseTensorSortKind.HeapSort:
            return "heap_sort"
        raise ValueError("Unknown SparseTensorSortKind enum entry.")



@register_attribute_builder("SparseTensorSortKindEnum")
def _sparsetensorsortkindenum(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class StorageSpecifierKind(IntEnum):
    """sparse tensor storage specifier kind"""

    LvlSize = 0
    PosMemSize = 1
    CrdMemSize = 2
    ValMemSize = 3
    DimOffset = 4
    DimStride = 5

    def __str__(self):
        if self is StorageSpecifierKind.LvlSize:
            return "lvl_sz"
        if self is StorageSpecifierKind.PosMemSize:
            return "pos_mem_sz"
        if self is StorageSpecifierKind.CrdMemSize:
            return "crd_mem_sz"
        if self is StorageSpecifierKind.ValMemSize:
            return "val_mem_sz"
        if self is StorageSpecifierKind.DimOffset:
            return "dim_offset"
        if self is StorageSpecifierKind.DimStride:
            return "dim_stride"
        raise ValueError("Unknown StorageSpecifierKind enum entry.")



@register_attribute_builder("SparseTensorStorageSpecifierKindEnum")
def _sparsetensorstoragespecifierkindenum(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

@register_attribute_builder("SparseTensorCrdTransDirectionAttr")
def _sparsetensorcrdtransdirectionattr(x, context):
    return _ods_ir.Attribute.parse(f'#sparse_tensor<CrdTransDirection {str(x)}>', context=context)

@register_attribute_builder("SparseTensorSortKindAttr")
def _sparsetensorsortkindattr(x, context):
    return _ods_ir.Attribute.parse(f'#sparse_tensor<SparseTensorSortAlgorithm {str(x)}>', context=context)

@register_attribute_builder("SparseTensorStorageSpecifierKindAttr")
def _sparsetensorstoragespecifierkindattr(x, context):
    return _ods_ir.Attribute.parse(f'#sparse_tensor<kind {str(x)}>', context=context)

