
# Autogenerated by mlir-tblgen; don't manually edit.

from jaxlib.mlir.dialects._ods_common import _cext as _ods_cext
from jaxlib.mlir.dialects._ods_common import (
    equally_sized_accessor as _ods_equally_sized_accessor,
    get_default_loc_context as _ods_get_default_loc_context,
    get_op_results_or_values as _get_op_results_or_values,
    segmented_accessor as _ods_segmented_accessor,
)
_ods_ir = _ods_cext.ir
_ods_cext.globals.register_traceback_file_exclusion(__file__)

import builtins
from typing import Sequence as _Sequence, Union as _Union, Optional as _Optional


@_ods_cext.register_dialect
class _Dialect(_ods_ir.Dialect):
  DIALECT_NAMESPACE = "tpu"

@_ods_cext.register_operation(_Dialect)
class AllReduceOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.all_reduce"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input, dim, kind, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dim"] = (dim if (
    isinstance(dim, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(dim, context=_ods_context))
    attributes["kind"] = (kind if (
    isinstance(kind, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TPU_ReductionKindAttr')) else
      _ods_ir.AttrBuilder.get('TPU_ReductionKindAttr')(kind, context=_ods_context))
    results = []
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[0]

  @builtins.property
  def dim(self) -> _ods_ir.IntegerAttr:
    return self.operation.attributes["dim"]

  @dim.setter
  def dim(self, value: _ods_ir.IntegerAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dim"] = value

  @builtins.property
  def kind(self) -> _ods_ir.Attribute:
    return self.operation.attributes["kind"]

  @kind.setter
  def kind(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["kind"] = value

  @builtins.property
  def output(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

def all_reduce(output, input, dim, kind, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return AllReduceOp(output=output, input=input, dim=dim, kind=kind, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class AllocaSemaphoreOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.sem_alloc"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def result(self) -> _ods_ir.OpResult[_ods_ir.MemRefType]:
    return self.operation.results[0]

def sem_alloc(result, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return AllocaSemaphoreOp(result=result, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class AssumeLayoutOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.assume_layout"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, input, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def assume_layout(result, input, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return AssumeLayoutOp(result=result, input=input, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class AssumeMultipleOp(_ods_ir.OpView):
  r"""
  This operation is a hint to the compiler that the input `value` is guaranteed
  to be a multiple of `multiple`. This can be used to satisfy divisibility checks
  in some compiler passes.
  
  The result is the same as the input `value`.
  
  Example:
  
  ```mlir
  %val = tpu.assume_multiple %arg0, 16 : index
  ```
  """

  OPERATION_NAME = "tpu.assume_multiple"

  _ODS_REGIONS = (0, True)

  def __init__(self, value, multiple, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(value)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["multiple"] = (multiple if (
    isinstance(multiple, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(multiple, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def value(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def multiple(self) -> _ods_ir.IntegerAttr:
    return self.operation.attributes["multiple"]

  @multiple.setter
  def multiple(self, value: _ods_ir.IntegerAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["multiple"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def assume_multiple(value, multiple, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return AssumeMultipleOp(value=value, multiple=multiple, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BarrierOp(_ods_ir.OpView):
  r"""
  Performs barrier synchronization across all SC vector subcores at the
  specified barrier id.
  """

  OPERATION_NAME = "tpu.barrier"

  _ODS_REGIONS = (0, True)

  def __init__(self, barrier_id, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(barrier_id)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def barrier_id(self) -> _ods_ir.Value[_ods_ir.IndexType]:
    return self.operation.operands[0]

def barrier(barrier_id, *, loc=None, ip=None) -> BarrierOp:
  return BarrierOp(barrier_id=barrier_id, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class BitcastOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.bitcast"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[0]

  @builtins.property
  def output(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

def bitcast(output, input, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return BitcastOp(output=output, input=input, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BitcastVregOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.bitcast_vreg"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[0]

  @builtins.property
  def output(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

def bitcast_vreg(output, input, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return BitcastVregOp(output=output, input=input, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BroadcastInSublanesOp(_ods_ir.OpView):
  r"""
  For each sublane `i`, broadcasts the value in lane `lane + i` along the
  entire sublane. For packed type, imagine the data is compressed unpacked
  along sublane dimension, and the sublane count is multiplied by the packing
  factor.
  For example, for i16 with sublane count 8, `i` above is in [0, 8 * 2).
  If `lane + i` is not in [0, lane_count), then the value in sublane `i` is
  not defined (can be anything).
  """

  OPERATION_NAME = "tpu.broadcast_in_sublanes"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, source, lane, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(source)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["lane"] = (lane if (
    isinstance(lane, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(lane, context=_ods_context))
    results = []
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def source(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[0]

  @builtins.property
  def lane(self) -> _ods_ir.IntegerAttr:
    return self.operation.attributes["lane"]

  @lane.setter
  def lane(self, value: _ods_ir.IntegerAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["lane"] = value

  @builtins.property
  def output(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

def broadcast_in_sublanes(output, source, lane, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return BroadcastInSublanesOp(output=output, source=source, lane=lane, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ConcatenateOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.concatenate"

  _ODS_REGIONS = (0, True)

  def __init__(self, sources, dimension, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(sources))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dimension"] = (dimension if (
    isinstance(dimension, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(dimension, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def sources(self) -> _ods_ir.OpOperandList:
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def dimension(self) -> _ods_ir.IntegerAttr:
    return self.operation.attributes["dimension"]

  @dimension.setter
  def dimension(self, value: _ods_ir.IntegerAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dimension"] = value

  @builtins.property
  def output(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

def concatenate(sources, dimension, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return ConcatenateOp(sources=sources, dimension=dimension, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class CreateMaskOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.create_mask"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, low, high, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(low))
    operands.extend(_get_op_results_or_values(high))
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def low(self) -> _ods_ir.OpOperandList:
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.operands, 0, 2, 0, 0)
    return self.operation.operands[start:start + elements_per_group]

  @builtins.property
  def high(self) -> _ods_ir.OpOperandList:
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.operands, 0, 2, 0, 1)
    return self.operation.operands[start:start + elements_per_group]

  @builtins.property
  def output(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def create_mask(output, low, high, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return CreateMaskOp(output=output, low=low, high=high, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class CreateSubelementMaskOp(_ods_ir.OpView):
  r"""
  The "half-sublanes", "quarter-sublanes", etc. (unit is determined by
  the type of `output`) of the mask are masked in the range specified by
  `from` and `to`.
  
  - If `from <= to`, the range `[from, to)` is set and the rest is unset.
  - If `to <= from`, the range `[to, from)` is unset and the rest is set.
  
  All lanes are set identically.
  
  Example:
  
  ```mlir
  %msk = tpu.create_subelement_mask 3, 9 : vector<8x128x2xi1>
  ```
  
  This creates a mask `%msk` where, for all `lane`s, `%msk[*][lane][*]` is:
  
  ```
  [[0, 0], [0, 1], [1, 1], [1, 1], [1, 0], [0, 0], [0, 0], [0, 0]]
  ```
  
  It is currently only supported:
  - In TPU v4, for `num_subelems` of 1 and 2.
  - In TPU v5, for `num_subelems` of 1, 2, and 4.
  """

  OPERATION_NAME = "tpu.create_subelement_mask"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, from_, to, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["from"] = (from_ if (
    isinstance(from_, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(from_, context=_ods_context))
    attributes["to"] = (to if (
    isinstance(to, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(to, context=_ods_context))
    results = []
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def from_(self) -> _ods_ir.IntegerAttr:
    return self.operation.attributes["from"]

  @from_.setter
  def from_(self, value: _ods_ir.IntegerAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["from"] = value

  @builtins.property
  def to(self) -> _ods_ir.IntegerAttr:
    return self.operation.attributes["to"]

  @to.setter
  def to(self, value: _ods_ir.IntegerAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["to"] = value

  @builtins.property
  def output(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def create_subelement_mask(output, from_, to, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return CreateSubelementMaskOp(output=output, from_=from_, to=to, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class DelayOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.delay"

  _ODS_REGIONS = (0, True)

  def __init__(self, nanos, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(nanos)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def nanos(self) -> _ods_ir.Value[_ods_ir.IntegerType]:
    return self.operation.operands[0]

def delay(nanos, *, loc=None, ip=None) -> DelayOp:
  return DelayOp(nanos=nanos, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class DeviceIdOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.device_id"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def result(self) -> _ods_ir.OpResult[_ods_ir.IntegerType]:
    return self.operation.results[0]

def device_id(*, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return DeviceIdOp(results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class DynamicGatherOp(_ods_ir.OpView):
  r"""
  Gathers elements from `source` using `indices`.
  
  The specified `dimensions` of `source` are collapsed together and indexed by
  `indices`.
  
  Given a shape `N0 x N1 x ...`,  the `output[i0, i1, ...]` is given by
  `collapsed_source[j0, j1, ..., indices[i0, i1, ...] mod M]` where
  - `collapsed_source` is the result of collapsing `dimensions` of `source`
    into a new trailing dimension of size `M`.
  - `jk` is the subsequence of `in` for `n` not in `dimensions`.
  
  When a single dimension is specified, this is similar to
  `np.take_along_axis`.
  """

  OPERATION_NAME = "tpu.dynamic_gather"

  _ODS_REGIONS = (0, True)

  def __init__(self, source, indices, dimensions, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(source)
    operands.append(indices)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dimensions"] = (dimensions if (
    isinstance(dimensions, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(dimensions, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def source(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[0]

  @builtins.property
  def indices(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[1]

  @builtins.property
  def dimensions(self) -> _ods_ir.DenseI32ArrayAttr:
    return self.operation.attributes["dimensions"]

  @dimensions.setter
  def dimensions(self, value: _ods_ir.DenseI32ArrayAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dimensions"] = value

  @builtins.property
  def output(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

def dynamic_gather(source, indices, dimensions, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return DynamicGatherOp(source=source, indices=indices, dimensions=dimensions, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class DynamicRotateOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.dynamic_rotate"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, value, amount, dimension, *, stride=None, stride_dimension=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(value)
    operands.append(amount)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dimension"] = (dimension if (
    isinstance(dimension, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SI32Attr')) else
      _ods_ir.AttrBuilder.get('SI32Attr')(dimension, context=_ods_context))
    if stride is not None: attributes["stride"] = (stride if (
        isinstance(stride, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SI32Attr')) else
          _ods_ir.AttrBuilder.get('SI32Attr')(stride, context=_ods_context))
    if stride_dimension is not None: attributes["stride_dimension"] = (stride_dimension if (
        isinstance(stride_dimension, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SI32Attr')) else
          _ods_ir.AttrBuilder.get('SI32Attr')(stride_dimension, context=_ods_context))
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def value(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[0]

  @builtins.property
  def amount(self) -> _ods_ir.Value[_ods_ir.IntegerType]:
    return self.operation.operands[1]

  @builtins.property
  def dimension(self) -> _ods_ir.IntegerAttr:
    return self.operation.attributes["dimension"]

  @dimension.setter
  def dimension(self, value: _ods_ir.IntegerAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dimension"] = value

  @builtins.property
  def stride(self) -> _Optional[_ods_ir.IntegerAttr]:
    if "stride" not in self.operation.attributes:
      return None
    return self.operation.attributes["stride"]

  @stride.setter
  def stride(self, value: _Optional[_ods_ir.IntegerAttr]):
    if value is not None:
      self.operation.attributes["stride"] = value
    elif "stride" in self.operation.attributes:
      del self.operation.attributes["stride"]

  @stride.deleter
  def stride(self):
    del self.operation.attributes["stride"]

  @builtins.property
  def stride_dimension(self) -> _Optional[_ods_ir.IntegerAttr]:
    if "stride_dimension" not in self.operation.attributes:
      return None
    return self.operation.attributes["stride_dimension"]

  @stride_dimension.setter
  def stride_dimension(self, value: _Optional[_ods_ir.IntegerAttr]):
    if value is not None:
      self.operation.attributes["stride_dimension"] = value
    elif "stride_dimension" in self.operation.attributes:
      del self.operation.attributes["stride_dimension"]

  @stride_dimension.deleter
  def stride_dimension(self):
    del self.operation.attributes["stride_dimension"]

  @builtins.property
  def result(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

def dynamic_rotate(result, value, amount, dimension, *, stride=None, stride_dimension=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return DynamicRotateOp(result=result, value=value, amount=amount, dimension=dimension, stride=stride, stride_dimension=stride_dimension, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class EnqueueDMAOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.enqueue_dma"

  _ODS_OPERAND_SEGMENTS = [1,0,1,1,0,0,]

  _ODS_REGIONS = (0, True)

  def __init__(self, source, target, target_semaphore, *, source_semaphore=None, device_id=None, core_id=None, priority=None, strict_ordering=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(source)
    operands.append(source_semaphore)
    operands.append(target)
    operands.append(target_semaphore)
    operands.append(device_id)
    operands.append(core_id)
    _ods_context = _ods_get_default_loc_context(loc)
    if priority is not None: attributes["priority"] = (priority if (
        isinstance(priority, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I32Attr')) else
          _ods_ir.AttrBuilder.get('I32Attr')(priority, context=_ods_context))
    if strict_ordering is not None: attributes["strict_ordering"] = (strict_ordering if (
        isinstance(strict_ordering, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(strict_ordering, context=_ods_context))
    results = []
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def source(self) -> _ods_ir.Value[_ods_ir.MemRefType]:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def source_semaphore(self) -> _Optional[_ods_ir.Value[_ods_ir.MemRefType]]:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def target(self) -> _ods_ir.Value[_ods_ir.MemRefType]:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range[0]

  @builtins.property
  def target_semaphore(self) -> _ods_ir.Value[_ods_ir.MemRefType]:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range[0]

  @builtins.property
  def device_id(self) -> _Optional[_ods_ir.Value[_ods_ir.IntegerType]]:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 4)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def core_id(self) -> _Optional[_ods_ir.Value[_ods_ir.IntegerType]]:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 5)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def priority(self) -> _ods_ir.IntegerAttr:
    return self.operation.attributes["priority"]

  @priority.setter
  def priority(self, value: _ods_ir.IntegerAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["priority"] = value

  @builtins.property
  def strict_ordering(self) -> _ods_ir.BoolAttr:
    return self.operation.attributes["strict_ordering"]

  @strict_ordering.setter
  def strict_ordering(self, value: _ods_ir.BoolAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["strict_ordering"] = value

def enqueue_dma(source, target, target_semaphore, *, source_semaphore=None, device_id=None, core_id=None, priority=None, strict_ordering=None, loc=None, ip=None) -> EnqueueDMAOp:
  return EnqueueDMAOp(source=source, target=target, target_semaphore=target_semaphore, source_semaphore=source_semaphore, device_id=device_id, core_id=core_id, priority=priority, strict_ordering=strict_ordering, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class EnqueueIndirectDMAOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.enqueue_indirect_dma"

  _ODS_REGIONS = (0, True)

  def __init__(self, source, target, offsets, semaphore, *, offset_filter=None, add=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(source)
    operands.append(target)
    operands.append(offsets)
    operands.append(semaphore)
    if offset_filter is not None: operands.append(offset_filter)
    _ods_context = _ods_get_default_loc_context(loc)
    if add is not None: attributes["add"] = (add if (
        isinstance(add, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(add, context=_ods_context))
    results = []
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def source(self) -> _ods_ir.Value[_ods_ir.MemRefType]:
    return self.operation.operands[0]

  @builtins.property
  def target(self) -> _ods_ir.Value[_ods_ir.MemRefType]:
    return self.operation.operands[1]

  @builtins.property
  def offsets(self) -> _ods_ir.Value:
    return self.operation.operands[2]

  @builtins.property
  def semaphore(self) -> _ods_ir.Value[_ods_ir.MemRefType]:
    return self.operation.operands[3]

  @builtins.property
  def offset_filter(self) -> _Optional[_ods_ir.Value[_ods_ir.IntegerType]]:
    return None if len(self.operation.operands) < 5 else self.operation.operands[4]

  @builtins.property
  def add(self) -> _ods_ir.BoolAttr:
    return self.operation.attributes["add"]

  @add.setter
  def add(self, value: _ods_ir.BoolAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["add"] = value

def enqueue_indirect_dma(source, target, offsets, semaphore, *, offset_filter=None, add=None, loc=None, ip=None) -> EnqueueIndirectDMAOp:
  return EnqueueIndirectDMAOp(source=source, target=target, offsets=offsets, semaphore=semaphore, offset_filter=offset_filter, add=add, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class EraseLayoutOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.erase_memref_layout"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value[_ods_ir.MemRefType]:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult[_ods_ir.MemRefType]:
    return self.operation.results[0]

def erase_memref_layout(operand, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return EraseLayoutOp(operand=operand, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ExtFOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.extf"

  _ODS_REGIONS = (0, True)

  def __init__(self, out, in_, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(in_)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(out)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def in_(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def out(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def extf(out, in_, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return ExtFOp(out=out, in_=in_, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class FPToSIOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.fptosi"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input, rounding_mode, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["rounding_mode"] = (rounding_mode if (
    isinstance(rounding_mode, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TPU_RoundingModeEnum')) else
      _ods_ir.AttrBuilder.get('TPU_RoundingModeEnum')(rounding_mode, context=_ods_context))
    results = []
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[0]

  @builtins.property
  def rounding_mode(self) -> _ods_ir.Attribute:
    return self.operation.attributes["rounding_mode"]

  @rounding_mode.setter
  def rounding_mode(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["rounding_mode"] = value

  @builtins.property
  def output(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

def fptosi(output, input, rounding_mode, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return FPToSIOp(output=output, input=input, rounding_mode=rounding_mode, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class GatherOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.gather"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, source, indices, dimension, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(source)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["indices"] = (indices if (
    isinstance(indices, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(indices, context=_ods_context))
    attributes["dimension"] = (dimension if (
    isinstance(dimension, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(dimension, context=_ods_context))
    results = []
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def source(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[0]

  @builtins.property
  def indices(self) -> _ods_ir.DenseI32ArrayAttr:
    return self.operation.attributes["indices"]

  @indices.setter
  def indices(self, value: _ods_ir.DenseI32ArrayAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["indices"] = value

  @builtins.property
  def dimension(self) -> _ods_ir.IntegerAttr:
    return self.operation.attributes["dimension"]

  @dimension.setter
  def dimension(self, value: _ods_ir.IntegerAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dimension"] = value

  @builtins.property
  def output(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

def gather(output, source, indices, dimension, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return GatherOp(output=output, source=source, indices=indices, dimension=dimension, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class GetBarrierSemaphoreOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.sem_barrier"

  _ODS_REGIONS = (0, True)

  def __init__(self, semaphore, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(semaphore)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def semaphore(self) -> _ods_ir.OpResult[_ods_ir.MemRefType]:
    return self.operation.results[0]

def sem_barrier(semaphore, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return GetBarrierSemaphoreOp(semaphore=semaphore, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class GetInternalScratchOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.internal_scratch"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def result(self) -> _ods_ir.OpResult[_ods_ir.MemRefType]:
    return self.operation.results[0]

def internal_scratch(result, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return GetInternalScratchOp(result=result, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class GetIterationBoundOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.iteration_bound"

  _ODS_REGIONS = (0, True)

  def __init__(self, dim, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dim"] = (dim if (
    isinstance(dim, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(dim, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def dim(self) -> _ods_ir.IntegerAttr:
    return self.operation.attributes["dim"]

  @dim.setter
  def dim(self, value: _ods_ir.IntegerAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dim"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult[_ods_ir.IntegerType]:
    return self.operation.results[0]

def iteration_bound(dim, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return GetIterationBoundOp(dim=dim, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class IotaOp(_ods_ir.OpView):
  r"""
  Creates a vector that with values that start at 0 and increase along a
  dimension resulting from collapsing the given `dimensions` together in
  row-major order.
  
  Example:
  ```
  tpu.iota {dimensions = array<i32: 2, 0>} : vector<4x3x2xi16>
  ```
  This produces a vector with the following values:
  ```
  [[[0, 4], [0, 4], [0, 4]]
   [[1, 5], [1, 5], [1, 5]]
   [[2, 6], [2, 6], [2, 6]]
   [[3, 7], [3, 7], [3, 7]]]
  ```
  """

  OPERATION_NAME = "tpu.iota"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, dimensions, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dimensions"] = (dimensions if (
    isinstance(dimensions, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(dimensions, context=_ods_context))
    results = []
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def dimensions(self) -> _ods_ir.DenseI32ArrayAttr:
    return self.operation.attributes["dimensions"]

  @dimensions.setter
  def dimensions(self, value: _ods_ir.DenseI32ArrayAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dimensions"] = value

  @builtins.property
  def output(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

def iota(output, dimensions, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return IotaOp(output=output, dimensions=dimensions, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class LoadOp(_ods_ir.OpView):
  r"""
  Similar to `vector::LoadOp` but with `sublane_mask` and `sublane_stride`.
  When `indices` are negative, it means loading from negative offset
  of `base` address.
  """

  OPERATION_NAME = "tpu.load"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, base, indices, sublane_mask, *, sublane_stride=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(base)
    operands.extend(_get_op_results_or_values(indices))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sublane_mask"] = (sublane_mask if (
    isinstance(sublane_mask, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseBoolArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseBoolArrayAttr')(sublane_mask, context=_ods_context))
    if sublane_stride is not None: attributes["sublane_stride"] = (sublane_stride if (
        isinstance(sublane_stride, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I32Attr')) else
          _ods_ir.AttrBuilder.get('I32Attr')(sublane_stride, context=_ods_context))
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def base(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def indices(self) -> _ods_ir.OpOperandList:
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def sublane_mask(self) -> _ods_ir.DenseBoolArrayAttr:
    return self.operation.attributes["sublane_mask"]

  @sublane_mask.setter
  def sublane_mask(self, value: _ods_ir.DenseBoolArrayAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sublane_mask"] = value

  @builtins.property
  def sublane_stride(self) -> _Optional[_ods_ir.IntegerAttr]:
    if "sublane_stride" not in self.operation.attributes:
      return None
    return self.operation.attributes["sublane_stride"]

  @sublane_stride.setter
  def sublane_stride(self, value: _Optional[_ods_ir.IntegerAttr]):
    if value is not None:
      self.operation.attributes["sublane_stride"] = value
    elif "sublane_stride" in self.operation.attributes:
      del self.operation.attributes["sublane_stride"]

  @sublane_stride.deleter
  def sublane_stride(self):
    del self.operation.attributes["sublane_stride"]

  @builtins.property
  def result(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

def load(result, base, indices, sublane_mask, *, sublane_stride=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return LoadOp(result=result, base=base, indices=indices, sublane_mask=sublane_mask, sublane_stride=sublane_stride, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class LogBufferOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.log_buffer"

  _ODS_REGIONS = (0, True)

  def __init__(self, input, shape, tag, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["shape"] = (shape if (
    isinstance(shape, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(shape, context=_ods_context))
    attributes["tag"] = (tag if (
    isinstance(tag, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(tag, context=_ods_context))
    results = []
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self) -> _ods_ir.Value[_ods_ir.MemRefType]:
    return self.operation.operands[0]

  @builtins.property
  def shape(self) -> _ods_ir.DenseI64ArrayAttr:
    return self.operation.attributes["shape"]

  @shape.setter
  def shape(self, value: _ods_ir.DenseI64ArrayAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["shape"] = value

  @builtins.property
  def tag(self) -> _ods_ir.StringAttr:
    return self.operation.attributes["tag"]

  @tag.setter
  def tag(self, value: _ods_ir.StringAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["tag"] = value

def log_buffer(input, shape, tag, *, loc=None, ip=None) -> LogBufferOp:
  return LogBufferOp(input=input, shape=shape, tag=tag, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class LogOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.log"

  _ODS_REGIONS = (0, True)

  def __init__(self, inputs, tag, *, formatted=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(inputs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["tag"] = (tag if (
    isinstance(tag, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(tag, context=_ods_context))
    if formatted is not None: attributes["formatted"] = (formatted if (
        isinstance(formatted, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(formatted, context=_ods_context))
    results = []
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def inputs(self) -> _ods_ir.OpOperandList:
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def tag(self) -> _ods_ir.StringAttr:
    return self.operation.attributes["tag"]

  @tag.setter
  def tag(self, value: _ods_ir.StringAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["tag"] = value

  @builtins.property
  def formatted(self) -> _ods_ir.BoolAttr:
    return self.operation.attributes["formatted"]

  @formatted.setter
  def formatted(self, value: _ods_ir.BoolAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["formatted"] = value

def log(inputs, tag, *, formatted=None, loc=None, ip=None) -> LogOp:
  return LogOp(inputs=inputs, tag=tag, formatted=formatted, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class MaskCastOp(_ods_ir.OpView):
  r"""
  Cast a mask register into a different packing.
  
  If casting to a type with smaller packing, then values being packed together
  must be identical. For example, for 8x128x4xi1 -> 8x128x2xi1,
  input[i, j, 0] == input[i, j, 1] and input[i, j, 2] == input[i, j, 3] must
  hold for all i, j. Otherwise, the result is undefined.
  """

  OPERATION_NAME = "tpu.mask_cast"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, input, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

def mask_cast(result, input, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return MaskCastOp(result=result, input=input, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MatmulOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.matmul"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, lhs, rhs, acc, *, transpose_lhs=None, transpose_rhs=None, precision=None, dimension_numbers=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    operands.append(acc)
    _ods_context = _ods_get_default_loc_context(loc)
    if transpose_lhs is not None: attributes["transpose_lhs"] = (transpose_lhs if (
        isinstance(transpose_lhs, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(transpose_lhs, context=_ods_context))
    if transpose_rhs is not None: attributes["transpose_rhs"] = (transpose_rhs if (
        isinstance(transpose_rhs, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(transpose_rhs, context=_ods_context))
    if precision is not None: attributes["precision"] = (precision if (
        isinstance(precision, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('TPU_ContractPrecisionEnum')) else
          _ods_ir.AttrBuilder.get('TPU_ContractPrecisionEnum')(precision, context=_ods_context))
    if dimension_numbers is not None: attributes["dimension_numbers"] = (dimension_numbers if (
        isinstance(dimension_numbers, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('TPU_DotDimensionNumbersAttr')) else
          _ods_ir.AttrBuilder.get('TPU_DotDimensionNumbersAttr')(dimension_numbers, context=_ods_context))
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[1]

  @builtins.property
  def acc(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[2]

  @builtins.property
  def transpose_lhs(self) -> _ods_ir.BoolAttr:
    return self.operation.attributes["transpose_lhs"]

  @transpose_lhs.setter
  def transpose_lhs(self, value: _ods_ir.BoolAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["transpose_lhs"] = value

  @builtins.property
  def transpose_rhs(self) -> _ods_ir.BoolAttr:
    return self.operation.attributes["transpose_rhs"]

  @transpose_rhs.setter
  def transpose_rhs(self, value: _ods_ir.BoolAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["transpose_rhs"] = value

  @builtins.property
  def precision(self) -> _Optional[_ods_ir.Attribute]:
    if "precision" not in self.operation.attributes:
      return None
    return self.operation.attributes["precision"]

  @precision.setter
  def precision(self, value: _Optional[_ods_ir.Attribute]):
    if value is not None:
      self.operation.attributes["precision"] = value
    elif "precision" in self.operation.attributes:
      del self.operation.attributes["precision"]

  @precision.deleter
  def precision(self):
    del self.operation.attributes["precision"]

  @builtins.property
  def dimension_numbers(self) -> _Optional[_ods_ir.Attribute]:
    if "dimension_numbers" not in self.operation.attributes:
      return None
    return self.operation.attributes["dimension_numbers"]

  @dimension_numbers.setter
  def dimension_numbers(self, value: _Optional[_ods_ir.Attribute]):
    if value is not None:
      self.operation.attributes["dimension_numbers"] = value
    elif "dimension_numbers" in self.operation.attributes:
      del self.operation.attributes["dimension_numbers"]

  @dimension_numbers.deleter
  def dimension_numbers(self):
    del self.operation.attributes["dimension_numbers"]

  @builtins.property
  def result(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

def matmul(result, lhs, rhs, acc, *, transpose_lhs=None, transpose_rhs=None, precision=None, dimension_numbers=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return MatmulOp(result=result, lhs=lhs, rhs=rhs, acc=acc, transpose_lhs=transpose_lhs, transpose_rhs=transpose_rhs, precision=precision, dimension_numbers=dimension_numbers, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MemRefBitcastOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.memref_bitcast"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, input, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self) -> _ods_ir.Value[_ods_ir.MemRefType]:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult[_ods_ir.MemRefType]:
    return self.operation.results[0]

def memref_bitcast(result, input, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return MemRefBitcastOp(result=result, input=input, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MemRefReshapeOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.memref_reshape"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, input, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self) -> _ods_ir.Value[_ods_ir.MemRefType]:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult[_ods_ir.MemRefType]:
    return self.operation.results[0]

def memref_reshape(result, input, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return MemRefReshapeOp(result=result, input=input, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MemRefSliceOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.memref_slice"

  _ODS_OPERAND_SEGMENTS = [1,-1,-1,]

  _ODS_REGIONS = (0, True)

  def __init__(self, result, mem_ref, base_idx, dynamic_sizes, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(mem_ref)
    operands.append(_get_op_results_or_values(base_idx))
    operands.append(_get_op_results_or_values(dynamic_sizes))
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def mem_ref(self) -> _ods_ir.Value[_ods_ir.MemRefType]:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def base_idx(self) -> _ods_ir.OpOperandList:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def dynamic_sizes(self) -> _ods_ir.OpOperandList:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def result(self) -> _ods_ir.OpResult[_ods_ir.MemRefType]:
    return self.operation.results[0]

def memref_slice(result, mem_ref, base_idx, dynamic_sizes, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return MemRefSliceOp(result=result, mem_ref=mem_ref, base_idx=base_idx, dynamic_sizes=dynamic_sizes, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MemRefSqueezeOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.memref_squeeze"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, input, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self) -> _ods_ir.Value[_ods_ir.MemRefType]:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult[_ods_ir.MemRefType]:
    return self.operation.results[0]

def memref_squeeze(result, input, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return MemRefSqueezeOp(result=result, input=input, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class PRNGRandomBitsOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.prng_random_bits"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def output(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

def prng_random_bits(output, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return PRNGRandomBitsOp(output=output, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class PRNGSeed32Op(_ods_ir.OpView):
  OPERATION_NAME = "tpu.prng_set_seed_32"

  _ODS_REGIONS = (0, True)

  def __init__(self, seeds, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(seeds))
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def seeds(self) -> _ods_ir.OpOperandList:
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

def prng_set_seed_32(seeds, *, loc=None, ip=None) -> PRNGSeed32Op:
  return PRNGSeed32Op(seeds=seeds, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class PackElementwiseOp(_ods_ir.OpView):
  r"""
  Packs multiple `sources` elementwise into a single vector of a narrower `target_type`.
  
  The number of `sources` must equal the packing factor, which is the ratio of
  the element bitwidth of the `sources` to the element bitwidth of the
  `target_type`. Elements from the `sources` are interleaved and packed into
  each word of the `output`, ordered from lowest to highest bits,
  corresponding to their order in the `sources`.
  """

  OPERATION_NAME = "tpu.pack_elementwise"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, sources, target_type, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(sources))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["target_type"] = (target_type if (
    isinstance(target_type, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TypeAttr')) else
      _ods_ir.AttrBuilder.get('TypeAttr')(target_type, context=_ods_context))
    results = []
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def sources(self) -> _ods_ir.OpOperandList:
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def target_type(self) -> _ods_ir.TypeAttr:
    return self.operation.attributes["target_type"]

  @target_type.setter
  def target_type(self, value: _ods_ir.TypeAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["target_type"] = value

  @builtins.property
  def output(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

def pack_elementwise(output, sources, target_type, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return PackElementwiseOp(output=output, sources=sources, target_type=target_type, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class PackMaskOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.pack_vmsk"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, low, high, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(low)
    operands.append(high)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def low(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[0]

  @builtins.property
  def high(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[1]

  @builtins.property
  def output(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

def pack_vmsk(output, low, high, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return PackMaskOp(output=output, low=low, high=high, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class PackSubelementsOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.pack_subelements"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, sources, positions, pack_format, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(sources))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["positions"] = (positions if (
    isinstance(positions, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(positions, context=_ods_context))
    attributes["pack_format"] = (pack_format if (
    isinstance(pack_format, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TPU_PackFormatEnum')) else
      _ods_ir.AttrBuilder.get('TPU_PackFormatEnum')(pack_format, context=_ods_context))
    results = []
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def sources(self) -> _ods_ir.OpOperandList:
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def positions(self) -> _ods_ir.DenseI32ArrayAttr:
    return self.operation.attributes["positions"]

  @positions.setter
  def positions(self, value: _ods_ir.DenseI32ArrayAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["positions"] = value

  @builtins.property
  def pack_format(self) -> _ods_ir.Attribute:
    return self.operation.attributes["pack_format"]

  @pack_format.setter
  def pack_format(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["pack_format"] = value

  @builtins.property
  def output(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

def pack_subelements(output, sources, positions, pack_format, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return PackSubelementsOp(output=output, sources=sources, positions=positions, pack_format=pack_format, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ReciprocalOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.reciprocal"

  _ODS_REGIONS = (0, True)

  def __init__(self, input, *, approx=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    if approx is not None: attributes["approx"] = (approx if (
        isinstance(approx, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(approx, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[0]

  @builtins.property
  def approx(self) -> _ods_ir.BoolAttr:
    return self.operation.attributes["approx"]

  @approx.setter
  def approx(self, value: _ods_ir.BoolAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["approx"] = value

  @builtins.property
  def output(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

def reciprocal(input, *, approx=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return ReciprocalOp(input=input, approx=approx, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ReduceIndexOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.reduce_index"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input, axis, kind, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["axis"] = (axis if (
    isinstance(axis, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(axis, context=_ods_context))
    attributes["kind"] = (kind if (
    isinstance(kind, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TPU_ReductionKindAttr')) else
      _ods_ir.AttrBuilder.get('TPU_ReductionKindAttr')(kind, context=_ods_context))
    results = []
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[0]

  @builtins.property
  def axis(self) -> _ods_ir.IntegerAttr:
    return self.operation.attributes["axis"]

  @axis.setter
  def axis(self, value: _ods_ir.IntegerAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["axis"] = value

  @builtins.property
  def kind(self) -> _ods_ir.Attribute:
    return self.operation.attributes["kind"]

  @kind.setter
  def kind(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["kind"] = value

  @builtins.property
  def output(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

def reduce_index(output, input, axis, kind, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return ReduceIndexOp(output=output, input=input, axis=axis, kind=kind, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class RegionOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.region"

  _ODS_REGIONS = (1, True)

  def __init__(self, results_, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.extend(results_)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def results_(self) -> _ods_ir.OpResultList:
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self) -> _ods_ir.Region:
    return self.regions[0]

def region(results_, *, loc=None, ip=None) -> _Union[_ods_ir.OpResult, _ods_ir.OpResultList, RegionOp]:
  op = RegionOp(results_=results_, loc=loc, ip=ip); results = op.results
  return results if len(results) > 1 else (results[0] if len(results) == 1 else op)

@_ods_cext.register_operation(_Dialect)
class ReinterpretCastOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.reinterpret_cast"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, input, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self) -> _ods_ir.Value[_ods_ir.MemRefType]:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult[_ods_ir.MemRefType]:
    return self.operation.results[0]

def reinterpret_cast(result, input, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return ReinterpretCastOp(result=result, input=input, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class RelayoutOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.relayout"

  _ODS_REGIONS = (0, True)

  def __init__(self, input, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[0]

  @builtins.property
  def output(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

def relayout(input, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return RelayoutOp(input=input, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class RepeatOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.repeat"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, source, dimension, times, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(source)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dimension"] = (dimension if (
    isinstance(dimension, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(dimension, context=_ods_context))
    attributes["times"] = (times if (
    isinstance(times, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(times, context=_ods_context))
    results = []
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def source(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[0]

  @builtins.property
  def dimension(self) -> _ods_ir.IntegerAttr:
    return self.operation.attributes["dimension"]

  @dimension.setter
  def dimension(self, value: _ods_ir.IntegerAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dimension"] = value

  @builtins.property
  def times(self) -> _ods_ir.IntegerAttr:
    return self.operation.attributes["times"]

  @times.setter
  def times(self, value: _ods_ir.IntegerAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["times"] = value

  @builtins.property
  def output(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

def repeat(output, source, dimension, times, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return RepeatOp(output=output, source=source, dimension=dimension, times=times, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ReshapeOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.reshape"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, source, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(source)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def source(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

def reshape(result, source, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return ReshapeOp(result=result, source=source, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class RollVectorsOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.roll_vectors"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(input))
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self) -> _ods_ir.OpOperandList:
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def output(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

def roll_vectors(output, input, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return RollVectorsOp(output=output, input=input, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class RotateOp(_ods_ir.OpView):
  r"""
  Rotates the given vector by the given amount in the given dimension, i.e.,
  for a 2D vector of shape (m, n), rotating dim 0 by `amount` will shift a row
  at index `i` to index `(i + amount) % m`
  """

  OPERATION_NAME = "tpu.rotate"

  _ODS_REGIONS = (0, True)

  def __init__(self, value, amount, dimension, *, stride=None, stride_dimension=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(value)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["amount"] = (amount if (
    isinstance(amount, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SI32Attr')) else
      _ods_ir.AttrBuilder.get('SI32Attr')(amount, context=_ods_context))
    attributes["dimension"] = (dimension if (
    isinstance(dimension, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SI32Attr')) else
      _ods_ir.AttrBuilder.get('SI32Attr')(dimension, context=_ods_context))
    if stride is not None: attributes["stride"] = (stride if (
        isinstance(stride, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SI32Attr')) else
          _ods_ir.AttrBuilder.get('SI32Attr')(stride, context=_ods_context))
    if stride_dimension is not None: attributes["stride_dimension"] = (stride_dimension if (
        isinstance(stride_dimension, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('SI32Attr')) else
          _ods_ir.AttrBuilder.get('SI32Attr')(stride_dimension, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def value(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[0]

  @builtins.property
  def amount(self) -> _ods_ir.IntegerAttr:
    return self.operation.attributes["amount"]

  @amount.setter
  def amount(self, value: _ods_ir.IntegerAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["amount"] = value

  @builtins.property
  def dimension(self) -> _ods_ir.IntegerAttr:
    return self.operation.attributes["dimension"]

  @dimension.setter
  def dimension(self, value: _ods_ir.IntegerAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dimension"] = value

  @builtins.property
  def stride(self) -> _Optional[_ods_ir.IntegerAttr]:
    if "stride" not in self.operation.attributes:
      return None
    return self.operation.attributes["stride"]

  @stride.setter
  def stride(self, value: _Optional[_ods_ir.IntegerAttr]):
    if value is not None:
      self.operation.attributes["stride"] = value
    elif "stride" in self.operation.attributes:
      del self.operation.attributes["stride"]

  @stride.deleter
  def stride(self):
    del self.operation.attributes["stride"]

  @builtins.property
  def stride_dimension(self) -> _Optional[_ods_ir.IntegerAttr]:
    if "stride_dimension" not in self.operation.attributes:
      return None
    return self.operation.attributes["stride_dimension"]

  @stride_dimension.setter
  def stride_dimension(self, value: _Optional[_ods_ir.IntegerAttr]):
    if value is not None:
      self.operation.attributes["stride_dimension"] = value
    elif "stride_dimension" in self.operation.attributes:
      del self.operation.attributes["stride_dimension"]

  @stride_dimension.deleter
  def stride_dimension(self):
    del self.operation.attributes["stride_dimension"]

  @builtins.property
  def result(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

def rotate(value, amount, dimension, *, stride=None, stride_dimension=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return RotateOp(value=value, amount=amount, dimension=dimension, stride=stride, stride_dimension=stride_dimension, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class SIToFPOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.sitofp"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, in_, rounding_mode, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(in_)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["rounding_mode"] = (rounding_mode if (
    isinstance(rounding_mode, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TPU_RoundingModeEnum')) else
      _ods_ir.AttrBuilder.get('TPU_RoundingModeEnum')(rounding_mode, context=_ods_context))
    results = []
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def in_(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rounding_mode(self) -> _ods_ir.Attribute:
    return self.operation.attributes["rounding_mode"]

  @rounding_mode.setter
  def rounding_mode(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["rounding_mode"] = value

  @builtins.property
  def output(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def sitofp(output, in_, rounding_mode, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return SIToFPOp(output=output, in_=in_, rounding_mode=rounding_mode, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ScanCountOp(_ods_ir.OpView):
  r"""
  ScanCountOp calculates the running duplicate occurrence count of the elements
  in the input vector, %values. The output vector, %counts, contains the running
  duplicate occurrence count for the corresponding element in
  the input vector, where the count is performed in ascending order of element
  indices. For example, if the elements of %values at indices 0, 5, and 7 had
  duplicate values, then the elements of %counts at indices 0, 5, and 7 would
  be 1, 2, and 3, respectively.
  
  A mask vector, %in_mask, specifies which of the elements in the input vector
  are eligible for counting. An element in %values that has its mask set to 0
  will always have a count of 1 in %counts, regardless of the position in the
  vector, or whether there were duplicates or not.
  """

  OPERATION_NAME = "tpu.scan_count"

  _ODS_REGIONS = (0, True)

  def __init__(self, in_mask, values, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(in_mask)
    operands.append(values)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def in_mask(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[0]

  @builtins.property
  def values(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[1]

  @builtins.property
  def out_mask(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

  @builtins.property
  def counts(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[1]

def scan_count(in_mask, values, *, results=None, loc=None, ip=None) -> _ods_ir.OpResultList:
  return ScanCountOp(in_mask=in_mask, values=values, results=results, loc=loc, ip=ip).results

@_ods_cext.register_operation(_Dialect)
class ScanOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.scan"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input, kind, *, mask=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(input)
    if mask is not None: operands.append(mask)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["kind"] = (kind if (
    isinstance(kind, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TPU_ReductionKindAttr')) else
      _ods_ir.AttrBuilder.get('TPU_ReductionKindAttr')(kind, context=_ods_context))
    results = []
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[0]

  @builtins.property
  def mask(self) -> _Optional[_ods_ir.Value[_ods_ir.VectorType]]:
    return None if len(self.operation.operands) < 2 else self.operation.operands[1]

  @builtins.property
  def kind(self) -> _ods_ir.Attribute:
    return self.operation.attributes["kind"]

  @kind.setter
  def kind(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["kind"] = value

  @builtins.property
  def output(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

def scan(output, input, kind, *, mask=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return ScanOp(output=output, input=input, kind=kind, mask=mask, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class SemaphoreReadOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.sem_read"

  _ODS_REGIONS = (0, True)

  def __init__(self, semaphore, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(semaphore)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def semaphore(self) -> _ods_ir.Value[_ods_ir.MemRefType]:
    return self.operation.operands[0]

  @builtins.property
  def result(self) -> _ods_ir.OpResult[_ods_ir.IntegerType]:
    return self.operation.results[0]

def sem_read(semaphore, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return SemaphoreReadOp(semaphore=semaphore, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class SemaphoreSignalOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.sem_signal"

  _ODS_OPERAND_SEGMENTS = [1,1,0,0,]

  _ODS_REGIONS = (0, True)

  def __init__(self, semaphore, amount, *, device_id=None, core_id=None, core_type=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(semaphore)
    operands.append(amount)
    operands.append(device_id)
    operands.append(core_id)
    _ods_context = _ods_get_default_loc_context(loc)
    if core_type is not None: attributes["core_type"] = (core_type if (
        isinstance(core_type, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('TPU_CoreTypeEnum')) else
          _ods_ir.AttrBuilder.get('TPU_CoreTypeEnum')(core_type, context=_ods_context))
    results = []
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def semaphore(self) -> _ods_ir.Value[_ods_ir.MemRefType]:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def amount(self) -> _ods_ir.Value[_ods_ir.IntegerType]:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0]

  @builtins.property
  def device_id(self) -> _Optional[_ods_ir.Value[_ods_ir.IntegerType]]:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def core_id(self) -> _Optional[_ods_ir.Value[_ods_ir.IntegerType]]:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def core_type(self) -> _Optional[_ods_ir.Attribute]:
    if "core_type" not in self.operation.attributes:
      return None
    return self.operation.attributes["core_type"]

  @core_type.setter
  def core_type(self, value: _Optional[_ods_ir.Attribute]):
    if value is not None:
      self.operation.attributes["core_type"] = value
    elif "core_type" in self.operation.attributes:
      del self.operation.attributes["core_type"]

  @core_type.deleter
  def core_type(self):
    del self.operation.attributes["core_type"]

def sem_signal(semaphore, amount, *, device_id=None, core_id=None, core_type=None, loc=None, ip=None) -> SemaphoreSignalOp:
  return SemaphoreSignalOp(semaphore=semaphore, amount=amount, device_id=device_id, core_id=core_id, core_type=core_type, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class SemaphoreWaitOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.sem_wait"

  _ODS_REGIONS = (0, True)

  def __init__(self, semaphore, amount, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(semaphore)
    operands.append(amount)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def semaphore(self) -> _ods_ir.Value[_ods_ir.MemRefType]:
    return self.operation.operands[0]

  @builtins.property
  def amount(self) -> _ods_ir.Value[_ods_ir.IntegerType]:
    return self.operation.operands[1]

def sem_wait(semaphore, amount, *, loc=None, ip=None) -> SemaphoreWaitOp:
  return SemaphoreWaitOp(semaphore=semaphore, amount=amount, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class ShuffledLoadOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.shuffled_load"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, base, indices, sublane_mask, sublane_offsets, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(base)
    operands.extend(_get_op_results_or_values(indices))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sublane_mask"] = (sublane_mask if (
    isinstance(sublane_mask, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseBoolArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseBoolArrayAttr')(sublane_mask, context=_ods_context))
    attributes["sublane_offsets"] = (sublane_offsets if (
    isinstance(sublane_offsets, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(sublane_offsets, context=_ods_context))
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def base(self) -> _ods_ir.Value[_ods_ir.MemRefType]:
    return self.operation.operands[0]

  @builtins.property
  def indices(self) -> _ods_ir.OpOperandList:
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def sublane_mask(self) -> _ods_ir.DenseBoolArrayAttr:
    return self.operation.attributes["sublane_mask"]

  @sublane_mask.setter
  def sublane_mask(self, value: _ods_ir.DenseBoolArrayAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sublane_mask"] = value

  @builtins.property
  def sublane_offsets(self) -> _ods_ir.DenseI32ArrayAttr:
    return self.operation.attributes["sublane_offsets"]

  @sublane_offsets.setter
  def sublane_offsets(self, value: _ods_ir.DenseI32ArrayAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sublane_offsets"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

def shuffled_load(result, base, indices, sublane_mask, sublane_offsets, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return ShuffledLoadOp(result=result, base=base, indices=indices, sublane_mask=sublane_mask, sublane_offsets=sublane_offsets, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ShuffledStoreOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.shuffled_store"

  _ODS_REGIONS = (0, True)

  def __init__(self, valueToStore, base, indices, sublane_mask, sublane_offsets, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(valueToStore)
    operands.append(base)
    operands.extend(_get_op_results_or_values(indices))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sublane_mask"] = (sublane_mask if (
    isinstance(sublane_mask, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseBoolArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseBoolArrayAttr')(sublane_mask, context=_ods_context))
    attributes["sublane_offsets"] = (sublane_offsets if (
    isinstance(sublane_offsets, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(sublane_offsets, context=_ods_context))
    results = []
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def valueToStore(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[0]

  @builtins.property
  def base(self) -> _ods_ir.Value[_ods_ir.MemRefType]:
    return self.operation.operands[1]

  @builtins.property
  def indices(self) -> _ods_ir.OpOperandList:
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[2:2 + _ods_variadic_group_length]

  @builtins.property
  def sublane_mask(self) -> _ods_ir.DenseBoolArrayAttr:
    return self.operation.attributes["sublane_mask"]

  @sublane_mask.setter
  def sublane_mask(self, value: _ods_ir.DenseBoolArrayAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sublane_mask"] = value

  @builtins.property
  def sublane_offsets(self) -> _ods_ir.DenseI32ArrayAttr:
    return self.operation.attributes["sublane_offsets"]

  @sublane_offsets.setter
  def sublane_offsets(self, value: _ods_ir.DenseI32ArrayAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sublane_offsets"] = value

def shuffled_store(value_to_store, base, indices, sublane_mask, sublane_offsets, *, loc=None, ip=None) -> ShuffledStoreOp:
  return ShuffledStoreOp(valueToStore=value_to_store, base=base, indices=indices, sublane_mask=sublane_mask, sublane_offsets=sublane_offsets, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class SortOp(_ods_ir.OpView):
  r"""
  tpu.sort performs a stable sort of key/value pairs in ascending or
  descending order based on keys. Masked-out keys and values are placed at the
  end of the output vectors. An output mask indicates which outputs
  correspond to the valid inputs.
  """

  OPERATION_NAME = "tpu.sort"

  _ODS_REGIONS = (0, True)

  def __init__(self, output_mask, sorted_keys, sorted_values, keys, values, *, mask=None, descending=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(keys)
    operands.append(values)
    if mask is not None: operands.append(mask)
    _ods_context = _ods_get_default_loc_context(loc)
    if descending is not None: attributes["descending"] = (descending if (
        isinstance(descending, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(descending, context=_ods_context))
    results = []
    results.append(output_mask)
    results.append(sorted_keys)
    results.append(sorted_values)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def keys(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[0]

  @builtins.property
  def values(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[1]

  @builtins.property
  def mask(self) -> _Optional[_ods_ir.Value[_ods_ir.VectorType]]:
    return None if len(self.operation.operands) < 3 else self.operation.operands[2]

  @builtins.property
  def descending(self) -> _ods_ir.BoolAttr:
    return self.operation.attributes["descending"]

  @descending.setter
  def descending(self, value: _ods_ir.BoolAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["descending"] = value

  @builtins.property
  def output_mask(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

  @builtins.property
  def sorted_keys(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[1]

  @builtins.property
  def sorted_values(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[2]

def sort(output_mask, sorted_keys, sorted_values, keys, values, *, mask=None, descending=None, loc=None, ip=None) -> _ods_ir.OpResultList:
  return SortOp(output_mask=output_mask, sorted_keys=sorted_keys, sorted_values=sorted_values, keys=keys, values=values, mask=mask, descending=descending, loc=loc, ip=ip).results

@_ods_cext.register_operation(_Dialect)
class StochasticConvertElementwiseOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.stochastic_convert_elementwise"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input, random, dst_type, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(input)
    operands.append(random)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["dst_type"] = (dst_type if (
    isinstance(dst_type, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TypeAttr')) else
      _ods_ir.AttrBuilder.get('TypeAttr')(dst_type, context=_ods_context))
    results = []
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[0]

  @builtins.property
  def random(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[1]

  @builtins.property
  def dst_type(self) -> _ods_ir.TypeAttr:
    return self.operation.attributes["dst_type"]

  @dst_type.setter
  def dst_type(self, value: _ods_ir.TypeAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["dst_type"] = value

  @builtins.property
  def output(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

def stochastic_convert_elementwise(output, input, random, dst_type, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return StochasticConvertElementwiseOp(output=output, input=input, random=random, dst_type=dst_type, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class StochasticConvertOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.stochastic_convert"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input, random, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(input)
    operands.append(random)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[0]

  @builtins.property
  def random(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[1]

  @builtins.property
  def output(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

def stochastic_convert(output, input, random, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return StochasticConvertOp(output=output, input=input, random=random, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class StoreOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.store"

  _ODS_OPERAND_SEGMENTS = [1,1,-1,0,]

  _ODS_REGIONS = (0, True)

  def __init__(self, valueToStore, base, indices, sublane_mask, *, mask=None, sublane_stride=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(valueToStore)
    operands.append(base)
    operands.append(_get_op_results_or_values(indices))
    operands.append(mask)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sublane_mask"] = (sublane_mask if (
    isinstance(sublane_mask, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseBoolArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseBoolArrayAttr')(sublane_mask, context=_ods_context))
    if sublane_stride is not None: attributes["sublane_stride"] = (sublane_stride if (
        isinstance(sublane_stride, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I32Attr')) else
          _ods_ir.AttrBuilder.get('I32Attr')(sublane_stride, context=_ods_context))
    results = []
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def valueToStore(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def base(self) -> _ods_ir.Value:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0]

  @builtins.property
  def indices(self) -> _ods_ir.OpOperandList:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def mask(self) -> _Optional[_ods_ir.Value]:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def sublane_mask(self) -> _ods_ir.DenseBoolArrayAttr:
    return self.operation.attributes["sublane_mask"]

  @sublane_mask.setter
  def sublane_mask(self, value: _ods_ir.DenseBoolArrayAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sublane_mask"] = value

  @builtins.property
  def sublane_stride(self) -> _Optional[_ods_ir.IntegerAttr]:
    if "sublane_stride" not in self.operation.attributes:
      return None
    return self.operation.attributes["sublane_stride"]

  @sublane_stride.setter
  def sublane_stride(self, value: _Optional[_ods_ir.IntegerAttr]):
    if value is not None:
      self.operation.attributes["sublane_stride"] = value
    elif "sublane_stride" in self.operation.attributes:
      del self.operation.attributes["sublane_stride"]

  @sublane_stride.deleter
  def sublane_stride(self):
    del self.operation.attributes["sublane_stride"]

def store(value_to_store, base, indices, sublane_mask, *, mask=None, sublane_stride=None, loc=None, ip=None) -> StoreOp:
  return StoreOp(valueToStore=value_to_store, base=base, indices=indices, sublane_mask=sublane_mask, mask=mask, sublane_stride=sublane_stride, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class StridedLoadOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.strided_load"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, base, indices, strides, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(base)
    operands.extend(_get_op_results_or_values(indices))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["strides"] = (strides if (
    isinstance(strides, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(strides, context=_ods_context))
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def base(self) -> _ods_ir.Value[_ods_ir.MemRefType]:
    return self.operation.operands[0]

  @builtins.property
  def indices(self) -> _ods_ir.OpOperandList:
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def strides(self) -> _ods_ir.DenseI32ArrayAttr:
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value: _ods_ir.DenseI32ArrayAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["strides"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

def strided_load(result, base, indices, strides, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return StridedLoadOp(result=result, base=base, indices=indices, strides=strides, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class StridedStoreOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.strided_store"

  _ODS_REGIONS = (0, True)

  def __init__(self, valueToStore, base, indices, strides, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(valueToStore)
    operands.append(base)
    operands.extend(_get_op_results_or_values(indices))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["strides"] = (strides if (
    isinstance(strides, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(strides, context=_ods_context))
    results = []
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def valueToStore(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[0]

  @builtins.property
  def base(self) -> _ods_ir.Value[_ods_ir.MemRefType]:
    return self.operation.operands[1]

  @builtins.property
  def indices(self) -> _ods_ir.OpOperandList:
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[2:2 + _ods_variadic_group_length]

  @builtins.property
  def strides(self) -> _ods_ir.DenseI32ArrayAttr:
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value: _ods_ir.DenseI32ArrayAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["strides"] = value

def strided_store(value_to_store, base, indices, strides, *, loc=None, ip=None) -> StridedStoreOp:
  return StridedStoreOp(valueToStore=value_to_store, base=base, indices=indices, strides=strides, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class SublaneShuffleOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.sublane_shuffle"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, pattern, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["pattern"] = (pattern if (
    isinstance(pattern, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(pattern, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[1]

  @builtins.property
  def pattern(self) -> _ods_ir.DenseI32ArrayAttr:
    return self.operation.attributes["pattern"]

  @pattern.setter
  def pattern(self, value: _ods_ir.DenseI32ArrayAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["pattern"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

def sublane_shuffle(lhs, rhs, pattern, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return SublaneShuffleOp(lhs=lhs, rhs=rhs, pattern=pattern, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class TraceOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.trace"

  _ODS_REGIONS = (1, True)

  def __init__(self, results_, message, level, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["message"] = (message if (
    isinstance(message, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(message, context=_ods_context))
    attributes["level"] = (level if (
    isinstance(level, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(level, context=_ods_context))
    results = []
    results.extend(results_)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def message(self) -> _ods_ir.StringAttr:
    return self.operation.attributes["message"]

  @message.setter
  def message(self, value: _ods_ir.StringAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["message"] = value

  @builtins.property
  def level(self) -> _ods_ir.IntegerAttr:
    return self.operation.attributes["level"]

  @level.setter
  def level(self, value: _ods_ir.IntegerAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["level"] = value

  @builtins.property
  def results_(self) -> _ods_ir.OpResultList:
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def region(self) -> _ods_ir.Region:
    return self.regions[0]

def trace(results_, message, level, *, loc=None, ip=None) -> _Union[_ods_ir.OpResult, _ods_ir.OpResultList, TraceOp]:
  op = TraceOp(results_=results_, message=message, level=level, loc=loc, ip=ip); results = op.results
  return results if len(results) > 1 else (results[0] if len(results) == 1 else op)

@_ods_cext.register_operation(_Dialect)
class TraceStartOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.trace_start"

  _ODS_REGIONS = (0, True)

  def __init__(self, message, level, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["message"] = (message if (
    isinstance(message, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(message, context=_ods_context))
    attributes["level"] = (level if (
    isinstance(level, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(level, context=_ods_context))
    results = []
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def message(self) -> _ods_ir.StringAttr:
    return self.operation.attributes["message"]

  @message.setter
  def message(self, value: _ods_ir.StringAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["message"] = value

  @builtins.property
  def level(self) -> _ods_ir.IntegerAttr:
    return self.operation.attributes["level"]

  @level.setter
  def level(self, value: _ods_ir.IntegerAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["level"] = value

def trace_start(message, level, *, loc=None, ip=None) -> TraceStartOp:
  return TraceStartOp(message=message, level=level, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class TraceStopOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.trace_stop"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

def trace_stop(*, loc=None, ip=None) -> TraceStopOp:
  return TraceStopOp(loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class TransposeOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.transpose"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, vector, permutation, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(vector)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["permutation"] = (permutation if (
    isinstance(permutation, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(permutation, context=_ods_context))
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def vector(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[0]

  @builtins.property
  def permutation(self) -> _ods_ir.DenseI64ArrayAttr:
    return self.operation.attributes["permutation"]

  @permutation.setter
  def permutation(self, value: _ods_ir.DenseI64ArrayAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["permutation"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

def transpose(result, vector, permutation, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return TransposeOp(result=result, vector=vector, permutation=permutation, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class TruncFOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.truncf"

  _ODS_REGIONS = (0, True)

  def __init__(self, out, in_, rounding_mode, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(in_)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["rounding_mode"] = (rounding_mode if (
    isinstance(rounding_mode, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TPU_RoundingModeEnum')) else
      _ods_ir.AttrBuilder.get('TPU_RoundingModeEnum')(rounding_mode, context=_ods_context))
    results = []
    results.append(out)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def in_(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rounding_mode(self) -> _ods_ir.Attribute:
    return self.operation.attributes["rounding_mode"]

  @rounding_mode.setter
  def rounding_mode(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["rounding_mode"] = value

  @builtins.property
  def out(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def truncf(out, in_, rounding_mode, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return TruncFOp(out=out, in_=in_, rounding_mode=rounding_mode, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class UnpackElementwiseOp(_ods_ir.OpView):
  r"""
  Unpacks a single vector from `source`, which contains multiple `source_type`
  vectors packed elementwise.
  
  The `index` selects which packed value to extract from each word of `source`.
  An `index` of 0 corresponds to the lowest bits. The extracted values are
  cast to the output element type.
  """

  OPERATION_NAME = "tpu.unpack_elementwise"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, source, source_type, index, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(source)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["source_type"] = (source_type if (
    isinstance(source_type, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TypeAttr')) else
      _ods_ir.AttrBuilder.get('TypeAttr')(source_type, context=_ods_context))
    attributes["index"] = (index if (
    isinstance(index, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(index, context=_ods_context))
    results = []
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def source(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[0]

  @builtins.property
  def source_type(self) -> _ods_ir.TypeAttr:
    return self.operation.attributes["source_type"]

  @source_type.setter
  def source_type(self, value: _ods_ir.TypeAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["source_type"] = value

  @builtins.property
  def index(self) -> _ods_ir.IntegerAttr:
    return self.operation.attributes["index"]

  @index.setter
  def index(self, value: _ods_ir.IntegerAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["index"] = value

  @builtins.property
  def output(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

def unpack_elementwise(output, source, source_type, index, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return UnpackElementwiseOp(output=output, source=source, source_type=source_type, index=index, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class UnpackSubelementsOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.unpack_subelements"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, source, index, pack_format, *, sign_extended=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(source)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["index"] = (index if (
    isinstance(index, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(index, context=_ods_context))
    attributes["pack_format"] = (pack_format if (
    isinstance(pack_format, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TPU_PackFormatEnum')) else
      _ods_ir.AttrBuilder.get('TPU_PackFormatEnum')(pack_format, context=_ods_context))
    if sign_extended is not None: attributes["sign_extended"] = (sign_extended if (
        isinstance(sign_extended, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(sign_extended, context=_ods_context))
    results = []
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def source(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[0]

  @builtins.property
  def index(self) -> _ods_ir.IntegerAttr:
    return self.operation.attributes["index"]

  @index.setter
  def index(self, value: _ods_ir.IntegerAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["index"] = value

  @builtins.property
  def pack_format(self) -> _ods_ir.Attribute:
    return self.operation.attributes["pack_format"]

  @pack_format.setter
  def pack_format(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["pack_format"] = value

  @builtins.property
  def sign_extended(self) -> _ods_ir.BoolAttr:
    return self.operation.attributes["sign_extended"]

  @sign_extended.setter
  def sign_extended(self, value: _ods_ir.BoolAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sign_extended"] = value

  @builtins.property
  def output(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

def unpack_subelements(output, source, index, pack_format, *, sign_extended=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return UnpackSubelementsOp(output=output, source=source, index=index, pack_format=pack_format, sign_extended=sign_extended, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class UnrollVectorsOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.unroll_vectors"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.extend(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    return self.operation.operands[0]

  @builtins.property
  def output(self) -> _ods_ir.OpResultList:
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

def unroll_vectors(output, input, *, loc=None, ip=None) -> _Union[_ods_ir.OpResult, _ods_ir.OpResultList, UnrollVectorsOp]:
  op = UnrollVectorsOp(output=output, input=input, loc=loc, ip=ip); results = op.results
  return results if len(results) > 1 else (results[0] if len(results) == 1 else op)

@_ods_cext.register_operation(_Dialect)
class VectorLoadIdxOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.vector_load_idx"

  _ODS_OPERAND_SEGMENTS = [1,-1,0,]

  _ODS_REGIONS = (0, True)

  def __init__(self, value, base, indices, *, mask=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(base)
    operands.append(_get_op_results_or_values(indices))
    operands.append(mask)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(value)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def base(self) -> _ods_ir.Value[_ods_ir.MemRefType]:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def indices(self) -> _ods_ir.OpOperandList:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def mask(self) -> _Optional[_ods_ir.Value[_ods_ir.VectorType]]:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def value(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

def vector_load_idx(value, base, indices, *, mask=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return VectorLoadIdxOp(value=value, base=base, indices=indices, mask=mask, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class VectorLoadOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.vector_load"

  _ODS_OPERAND_SEGMENTS = [1,-1,0,]

  _ODS_REGIONS = (0, True)

  def __init__(self, result, base, indices, strides, *, mask=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(base)
    operands.append(_get_op_results_or_values(indices))
    operands.append(mask)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["strides"] = (strides if (
    isinstance(strides, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(strides, context=_ods_context))
    results = []
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def base(self) -> _ods_ir.Value[_ods_ir.MemRefType]:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def indices(self) -> _ods_ir.OpOperandList:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def mask(self) -> _Optional[_ods_ir.Value[_ods_ir.VectorType]]:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def strides(self) -> _ods_ir.DenseI32ArrayAttr:
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value: _ods_ir.DenseI32ArrayAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["strides"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult[_ods_ir.VectorType]:
    return self.operation.results[0]

def vector_load(result, base, indices, strides, *, mask=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return VectorLoadOp(result=result, base=base, indices=indices, strides=strides, mask=mask, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class VectorStoreIdxOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.vector_store_idx"

  _ODS_OPERAND_SEGMENTS = [1,1,-1,0,]

  _ODS_REGIONS = (0, True)

  def __init__(self, valueToStore, base, indices, *, mask=None, add=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(valueToStore)
    operands.append(base)
    operands.append(_get_op_results_or_values(indices))
    operands.append(mask)
    _ods_context = _ods_get_default_loc_context(loc)
    if add is not None: attributes["add"] = (add if (
        isinstance(add, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(add, context=_ods_context))
    results = []
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def valueToStore(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def base(self) -> _ods_ir.Value[_ods_ir.MemRefType]:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0]

  @builtins.property
  def indices(self) -> _ods_ir.OpOperandList:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def mask(self) -> _Optional[_ods_ir.Value[_ods_ir.VectorType]]:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def add(self) -> _ods_ir.BoolAttr:
    return self.operation.attributes["add"]

  @add.setter
  def add(self, value: _ods_ir.BoolAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["add"] = value

def vector_store_idx(value_to_store, base, indices, *, mask=None, add=None, loc=None, ip=None) -> VectorStoreIdxOp:
  return VectorStoreIdxOp(valueToStore=value_to_store, base=base, indices=indices, mask=mask, add=add, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class VectorStoreOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.vector_store"

  _ODS_OPERAND_SEGMENTS = [1,1,-1,0,]

  _ODS_REGIONS = (0, True)

  def __init__(self, valueToStore, base, indices, strides, *, mask=None, add=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(valueToStore)
    operands.append(base)
    operands.append(_get_op_results_or_values(indices))
    operands.append(mask)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["strides"] = (strides if (
    isinstance(strides, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI32ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI32ArrayAttr')(strides, context=_ods_context))
    if add is not None: attributes["add"] = (add if (
        isinstance(add, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(add, context=_ods_context))
    results = []
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def valueToStore(self) -> _ods_ir.Value[_ods_ir.VectorType]:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def base(self) -> _ods_ir.Value[_ods_ir.MemRefType]:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0]

  @builtins.property
  def indices(self) -> _ods_ir.OpOperandList:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def mask(self) -> _Optional[_ods_ir.Value[_ods_ir.VectorType]]:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def strides(self) -> _ods_ir.DenseI32ArrayAttr:
    return self.operation.attributes["strides"]

  @strides.setter
  def strides(self, value: _ods_ir.DenseI32ArrayAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["strides"] = value

  @builtins.property
  def add(self) -> _ods_ir.BoolAttr:
    return self.operation.attributes["add"]

  @add.setter
  def add(self, value: _ods_ir.BoolAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["add"] = value

def vector_store(value_to_store, base, indices, strides, *, mask=None, add=None, loc=None, ip=None) -> VectorStoreOp:
  return VectorStoreOp(valueToStore=value_to_store, base=base, indices=indices, strides=strides, mask=mask, add=add, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class WaitDMA2Op(_ods_ir.OpView):
  OPERATION_NAME = "tpu.wait_dma2"

  _ODS_OPERAND_SEGMENTS = [1,1,1,0,0,]

  _ODS_REGIONS = (0, True)

  def __init__(self, semaphore, src, dst, *, device_id=None, core_id=None, strict_ordering=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(semaphore)
    operands.append(src)
    operands.append(dst)
    operands.append(device_id)
    operands.append(core_id)
    _ods_context = _ods_get_default_loc_context(loc)
    if strict_ordering is not None: attributes["strict_ordering"] = (strict_ordering if (
        isinstance(strict_ordering, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(strict_ordering, context=_ods_context))
    results = []
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def semaphore(self) -> _ods_ir.Value[_ods_ir.MemRefType]:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def src(self) -> _ods_ir.Value[_ods_ir.MemRefType]:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0]

  @builtins.property
  def dst(self) -> _ods_ir.Value[_ods_ir.MemRefType]:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range[0]

  @builtins.property
  def device_id(self) -> _Optional[_ods_ir.Value[_ods_ir.IntegerType]]:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def core_id(self) -> _Optional[_ods_ir.Value[_ods_ir.IntegerType]]:
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 4)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def strict_ordering(self) -> _ods_ir.BoolAttr:
    return self.operation.attributes["strict_ordering"]

  @strict_ordering.setter
  def strict_ordering(self, value: _ods_ir.BoolAttr):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["strict_ordering"] = value

def wait_dma2(semaphore, src, dst, *, device_id=None, core_id=None, strict_ordering=None, loc=None, ip=None) -> WaitDMA2Op:
  return WaitDMA2Op(semaphore=semaphore, src=src, dst=dst, device_id=device_id, core_id=core_id, strict_ordering=strict_ordering, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class WaitDMAOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.wait_dma"

  _ODS_REGIONS = (0, True)

  def __init__(self, semaphore, ref, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(semaphore)
    operands.append(ref)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def semaphore(self) -> _ods_ir.Value[_ods_ir.MemRefType]:
    return self.operation.operands[0]

  @builtins.property
  def ref(self) -> _ods_ir.Value[_ods_ir.MemRefType]:
    return self.operation.operands[1]

def wait_dma(semaphore, ref, *, loc=None, ip=None) -> WaitDMAOp:
  return WaitDMAOp(semaphore=semaphore, ref=ref, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class WaitIndirectDMAOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.wait_indirect_dma"

  _ODS_REGIONS = (0, True)

  def __init__(self, semaphore, src, dst, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(semaphore)
    operands.append(src)
    operands.append(dst)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def semaphore(self) -> _ods_ir.Value[_ods_ir.MemRefType]:
    return self.operation.operands[0]

  @builtins.property
  def src(self) -> _ods_ir.Value[_ods_ir.MemRefType]:
    return self.operation.operands[1]

  @builtins.property
  def dst(self) -> _ods_ir.Value[_ods_ir.MemRefType]:
    return self.operation.operands[2]

def wait_indirect_dma(semaphore, src, dst, *, loc=None, ip=None) -> WaitIndirectDMAOp:
  return WaitIndirectDMAOp(semaphore=semaphore, src=src, dst=dst, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class WeirdOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.weird"

  _ODS_REGIONS = (0, True)

  def __init__(self, output, input, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(output)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def output(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def weird(output, input, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return WeirdOp(output=output, input=input, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class YieldOp(_ods_ir.OpView):
  OPERATION_NAME = "tpu.yield"

  _ODS_REGIONS = (0, True)

  def __init__(self, results_, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(results_))
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def results_(self) -> _ods_ir.OpOperandList:
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

def yield_(results_, *, loc=None, ip=None) -> YieldOp:
  return YieldOp(results_=results_, loc=loc, ip=ip)
