"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import collections_pb2
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import json_with_int_pb2
import qdrant_common_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _WriteOrderingType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _WriteOrderingTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_WriteOrderingType.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    Weak: _WriteOrderingType.ValueType  # 0
    """Write operations may be reordered, works faster, default"""
    Medium: _WriteOrderingType.ValueType  # 1
    """Write operations go through dynamically selected leader, may be inconsistent for a short period of time in case of leader change"""
    Strong: _WriteOrderingType.ValueType  # 2
    """Write operations go through the permanent leader, consistent, but may be unavailable if leader is down"""

class WriteOrderingType(_WriteOrderingType, metaclass=_WriteOrderingTypeEnumTypeWrapper): ...

Weak: WriteOrderingType.ValueType  # 0
"""Write operations may be reordered, works faster, default"""
Medium: WriteOrderingType.ValueType  # 1
"""Write operations go through dynamically selected leader, may be inconsistent for a short period of time in case of leader change"""
Strong: WriteOrderingType.ValueType  # 2
"""Write operations go through the permanent leader, consistent, but may be unavailable if leader is down"""
global___WriteOrderingType = WriteOrderingType

class _ReadConsistencyType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ReadConsistencyTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ReadConsistencyType.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    All: _ReadConsistencyType.ValueType  # 0
    """Send request to all nodes and return points which are present on all of them"""
    Majority: _ReadConsistencyType.ValueType  # 1
    """Send requests to all nodes and return points which are present on majority of them"""
    Quorum: _ReadConsistencyType.ValueType  # 2
    """Send requests to half + 1 nodes, return points which are present on all of them"""

class ReadConsistencyType(_ReadConsistencyType, metaclass=_ReadConsistencyTypeEnumTypeWrapper): ...

All: ReadConsistencyType.ValueType  # 0
"""Send request to all nodes and return points which are present on all of them"""
Majority: ReadConsistencyType.ValueType  # 1
"""Send requests to all nodes and return points which are present on majority of them"""
Quorum: ReadConsistencyType.ValueType  # 2
"""Send requests to half + 1 nodes, return points which are present on all of them"""
global___ReadConsistencyType = ReadConsistencyType

class _FieldType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _FieldTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_FieldType.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    FieldTypeKeyword: _FieldType.ValueType  # 0
    FieldTypeInteger: _FieldType.ValueType  # 1
    FieldTypeFloat: _FieldType.ValueType  # 2
    FieldTypeGeo: _FieldType.ValueType  # 3
    FieldTypeText: _FieldType.ValueType  # 4
    FieldTypeBool: _FieldType.ValueType  # 5
    FieldTypeDatetime: _FieldType.ValueType  # 6
    FieldTypeUuid: _FieldType.ValueType  # 7

class FieldType(_FieldType, metaclass=_FieldTypeEnumTypeWrapper): ...

FieldTypeKeyword: FieldType.ValueType  # 0
FieldTypeInteger: FieldType.ValueType  # 1
FieldTypeFloat: FieldType.ValueType  # 2
FieldTypeGeo: FieldType.ValueType  # 3
FieldTypeText: FieldType.ValueType  # 4
FieldTypeBool: FieldType.ValueType  # 5
FieldTypeDatetime: FieldType.ValueType  # 6
FieldTypeUuid: FieldType.ValueType  # 7
global___FieldType = FieldType

class _Direction:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _DirectionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Direction.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    Asc: _Direction.ValueType  # 0
    Desc: _Direction.ValueType  # 1

class Direction(_Direction, metaclass=_DirectionEnumTypeWrapper): ...

Asc: Direction.ValueType  # 0
Desc: Direction.ValueType  # 1
global___Direction = Direction

class _RecommendStrategy:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _RecommendStrategyEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_RecommendStrategy.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    AverageVector: _RecommendStrategy.ValueType  # 0
    """Average positive and negative vectors and create a single query with the formula
    `query = avg_pos + avg_pos - avg_neg`. Then performs normal search.
    """
    BestScore: _RecommendStrategy.ValueType  # 1
    """Uses custom search objective. Each candidate is compared against all
    examples, its score is then chosen from the `max(max_pos_score, max_neg_score)`.
    If the `max_neg_score` is chosen then it is squared and negated.
    """
    SumScores: _RecommendStrategy.ValueType  # 2
    """Uses custom search objective. Compares against all inputs, sums all the scores.
    Scores against positive vectors are added, against negatives are subtracted.
    """

class RecommendStrategy(_RecommendStrategy, metaclass=_RecommendStrategyEnumTypeWrapper):
    """How to use positive and negative vectors to find the results, default is `AverageVector`."""

AverageVector: RecommendStrategy.ValueType  # 0
"""Average positive and negative vectors and create a single query with the formula
`query = avg_pos + avg_pos - avg_neg`. Then performs normal search.
"""
BestScore: RecommendStrategy.ValueType  # 1
"""Uses custom search objective. Each candidate is compared against all
examples, its score is then chosen from the `max(max_pos_score, max_neg_score)`.
If the `max_neg_score` is chosen then it is squared and negated.
"""
SumScores: RecommendStrategy.ValueType  # 2
"""Uses custom search objective. Compares against all inputs, sums all the scores.
Scores against positive vectors are added, against negatives are subtracted.
"""
global___RecommendStrategy = RecommendStrategy

class _Fusion:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _FusionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Fusion.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    RRF: _Fusion.ValueType  # 0
    """Reciprocal Rank Fusion (with default parameters)"""
    DBSF: _Fusion.ValueType  # 1
    """Distribution-Based Score Fusion"""

class Fusion(_Fusion, metaclass=_FusionEnumTypeWrapper): ...

RRF: Fusion.ValueType  # 0
"""Reciprocal Rank Fusion (with default parameters)"""
DBSF: Fusion.ValueType  # 1
"""Distribution-Based Score Fusion"""
global___Fusion = Fusion

class _Sample:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _SampleEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Sample.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    Random: _Sample.ValueType  # 0

class Sample(_Sample, metaclass=_SampleEnumTypeWrapper):
    """Sample points from the collection

    Available sampling methods:

    * `random` - Random sampling
    """

Random: Sample.ValueType  # 0
global___Sample = Sample

class _UpdateStatus:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _UpdateStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_UpdateStatus.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    UnknownUpdateStatus: _UpdateStatus.ValueType  # 0
    Acknowledged: _UpdateStatus.ValueType  # 1
    """Update is received, but not processed yet"""
    Completed: _UpdateStatus.ValueType  # 2
    """Update is applied and ready for search"""
    ClockRejected: _UpdateStatus.ValueType  # 3
    """Internal: update is rejected due to an outdated clock"""

class UpdateStatus(_UpdateStatus, metaclass=_UpdateStatusEnumTypeWrapper): ...

UnknownUpdateStatus: UpdateStatus.ValueType  # 0
Acknowledged: UpdateStatus.ValueType  # 1
"""Update is received, but not processed yet"""
Completed: UpdateStatus.ValueType  # 2
"""Update is applied and ready for search"""
ClockRejected: UpdateStatus.ValueType  # 3
"""Internal: update is rejected due to an outdated clock"""
global___UpdateStatus = UpdateStatus

class WriteOrdering(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TYPE_FIELD_NUMBER: builtins.int
    type: global___WriteOrderingType.ValueType
    """Write ordering guarantees"""
    def __init__(
        self,
        *,
        type: global___WriteOrderingType.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["type", b"type"]) -> None: ...

global___WriteOrdering = WriteOrdering

class ReadConsistency(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TYPE_FIELD_NUMBER: builtins.int
    FACTOR_FIELD_NUMBER: builtins.int
    type: global___ReadConsistencyType.ValueType
    """Common read consistency configurations"""
    factor: builtins.int
    """Send request to a specified number of nodes, and return points which are present on all of them"""
    def __init__(
        self,
        *,
        type: global___ReadConsistencyType.ValueType = ...,
        factor: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["factor", b"factor", "type", b"type", "value", b"value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["factor", b"factor", "type", b"type", "value", b"value"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["value", b"value"]) -> typing_extensions.Literal["type", "factor"] | None: ...

global___ReadConsistency = ReadConsistency

class SparseIndices(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATA_FIELD_NUMBER: builtins.int
    @property
    def data(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(
        self,
        *,
        data: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["data", b"data"]) -> None: ...

global___SparseIndices = SparseIndices

class Document(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class OptionsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> json_with_int_pb2.Value: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: json_with_int_pb2.Value | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    TEXT_FIELD_NUMBER: builtins.int
    MODEL_FIELD_NUMBER: builtins.int
    OPTIONS_FIELD_NUMBER: builtins.int
    text: builtins.str
    """Text of the document"""
    model: builtins.str
    """Model name"""
    @property
    def options(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, json_with_int_pb2.Value]:
        """Model options"""
    def __init__(
        self,
        *,
        text: builtins.str = ...,
        model: builtins.str = ...,
        options: collections.abc.Mapping[builtins.str, json_with_int_pb2.Value] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model", "options", b"options", "text", b"text"]) -> None: ...

global___Document = Document

class Image(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class OptionsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> json_with_int_pb2.Value: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: json_with_int_pb2.Value | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    IMAGE_FIELD_NUMBER: builtins.int
    MODEL_FIELD_NUMBER: builtins.int
    OPTIONS_FIELD_NUMBER: builtins.int
    @property
    def image(self) -> json_with_int_pb2.Value:
        """Image data, either base64 encoded or URL"""
    model: builtins.str
    """Model name"""
    @property
    def options(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, json_with_int_pb2.Value]:
        """Model options"""
    def __init__(
        self,
        *,
        image: json_with_int_pb2.Value | None = ...,
        model: builtins.str = ...,
        options: collections.abc.Mapping[builtins.str, json_with_int_pb2.Value] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["image", b"image"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["image", b"image", "model", b"model", "options", b"options"]) -> None: ...

global___Image = Image

class InferenceObject(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class OptionsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> json_with_int_pb2.Value: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: json_with_int_pb2.Value | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    OBJECT_FIELD_NUMBER: builtins.int
    MODEL_FIELD_NUMBER: builtins.int
    OPTIONS_FIELD_NUMBER: builtins.int
    @property
    def object(self) -> json_with_int_pb2.Value:
        """Object to infer"""
    model: builtins.str
    """Model name"""
    @property
    def options(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, json_with_int_pb2.Value]:
        """Model options"""
    def __init__(
        self,
        *,
        object: json_with_int_pb2.Value | None = ...,
        model: builtins.str = ...,
        options: collections.abc.Mapping[builtins.str, json_with_int_pb2.Value] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["object", b"object"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model", "object", b"object", "options", b"options"]) -> None: ...

global___InferenceObject = InferenceObject

class Vector(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATA_FIELD_NUMBER: builtins.int
    INDICES_FIELD_NUMBER: builtins.int
    VECTORS_COUNT_FIELD_NUMBER: builtins.int
    DENSE_FIELD_NUMBER: builtins.int
    SPARSE_FIELD_NUMBER: builtins.int
    MULTI_DENSE_FIELD_NUMBER: builtins.int
    DOCUMENT_FIELD_NUMBER: builtins.int
    IMAGE_FIELD_NUMBER: builtins.int
    OBJECT_FIELD_NUMBER: builtins.int
    @property
    def data(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
        """Vector data (flatten for multi vectors), deprecated"""
    @property
    def indices(self) -> global___SparseIndices:
        """Sparse indices for sparse vectors, deprecated"""
    vectors_count: builtins.int
    """Number of vectors per multi vector, deprecated"""
    @property
    def dense(self) -> global___DenseVector:
        """Dense vector"""
    @property
    def sparse(self) -> global___SparseVector:
        """Sparse vector"""
    @property
    def multi_dense(self) -> global___MultiDenseVector:
        """Multi dense vector"""
    @property
    def document(self) -> global___Document: ...
    @property
    def image(self) -> global___Image: ...
    @property
    def object(self) -> global___InferenceObject: ...
    def __init__(
        self,
        *,
        data: collections.abc.Iterable[builtins.float] | None = ...,
        indices: global___SparseIndices | None = ...,
        vectors_count: builtins.int | None = ...,
        dense: global___DenseVector | None = ...,
        sparse: global___SparseVector | None = ...,
        multi_dense: global___MultiDenseVector | None = ...,
        document: global___Document | None = ...,
        image: global___Image | None = ...,
        object: global___InferenceObject | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_indices", b"_indices", "_vectors_count", b"_vectors_count", "dense", b"dense", "document", b"document", "image", b"image", "indices", b"indices", "multi_dense", b"multi_dense", "object", b"object", "sparse", b"sparse", "vector", b"vector", "vectors_count", b"vectors_count"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_indices", b"_indices", "_vectors_count", b"_vectors_count", "data", b"data", "dense", b"dense", "document", b"document", "image", b"image", "indices", b"indices", "multi_dense", b"multi_dense", "object", b"object", "sparse", b"sparse", "vector", b"vector", "vectors_count", b"vectors_count"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_indices", b"_indices"]) -> typing_extensions.Literal["indices"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_vectors_count", b"_vectors_count"]) -> typing_extensions.Literal["vectors_count"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["vector", b"vector"]) -> typing_extensions.Literal["dense", "sparse", "multi_dense", "document", "image", "object"] | None: ...

global___Vector = Vector

class VectorOutput(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATA_FIELD_NUMBER: builtins.int
    INDICES_FIELD_NUMBER: builtins.int
    VECTORS_COUNT_FIELD_NUMBER: builtins.int
    DENSE_FIELD_NUMBER: builtins.int
    SPARSE_FIELD_NUMBER: builtins.int
    MULTI_DENSE_FIELD_NUMBER: builtins.int
    @property
    def data(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
        """Vector data (flatten for multi vectors), deprecated"""
    @property
    def indices(self) -> global___SparseIndices:
        """Sparse indices for sparse vectors, deprecated"""
    vectors_count: builtins.int
    """Number of vectors per multi vector, deprecated"""
    @property
    def dense(self) -> global___DenseVector:
        """Dense vector"""
    @property
    def sparse(self) -> global___SparseVector:
        """Sparse vector"""
    @property
    def multi_dense(self) -> global___MultiDenseVector:
        """Multi dense vector"""
    def __init__(
        self,
        *,
        data: collections.abc.Iterable[builtins.float] | None = ...,
        indices: global___SparseIndices | None = ...,
        vectors_count: builtins.int | None = ...,
        dense: global___DenseVector | None = ...,
        sparse: global___SparseVector | None = ...,
        multi_dense: global___MultiDenseVector | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_indices", b"_indices", "_vectors_count", b"_vectors_count", "dense", b"dense", "indices", b"indices", "multi_dense", b"multi_dense", "sparse", b"sparse", "vector", b"vector", "vectors_count", b"vectors_count"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_indices", b"_indices", "_vectors_count", b"_vectors_count", "data", b"data", "dense", b"dense", "indices", b"indices", "multi_dense", b"multi_dense", "sparse", b"sparse", "vector", b"vector", "vectors_count", b"vectors_count"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_indices", b"_indices"]) -> typing_extensions.Literal["indices"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_vectors_count", b"_vectors_count"]) -> typing_extensions.Literal["vectors_count"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["vector", b"vector"]) -> typing_extensions.Literal["dense", "sparse", "multi_dense"] | None: ...

global___VectorOutput = VectorOutput

class DenseVector(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATA_FIELD_NUMBER: builtins.int
    @property
    def data(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]: ...
    def __init__(
        self,
        *,
        data: collections.abc.Iterable[builtins.float] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["data", b"data"]) -> None: ...

global___DenseVector = DenseVector

class SparseVector(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALUES_FIELD_NUMBER: builtins.int
    INDICES_FIELD_NUMBER: builtins.int
    @property
    def values(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]: ...
    @property
    def indices(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(
        self,
        *,
        values: collections.abc.Iterable[builtins.float] | None = ...,
        indices: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["indices", b"indices", "values", b"values"]) -> None: ...

global___SparseVector = SparseVector

class MultiDenseVector(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VECTORS_FIELD_NUMBER: builtins.int
    @property
    def vectors(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DenseVector]: ...
    def __init__(
        self,
        *,
        vectors: collections.abc.Iterable[global___DenseVector] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["vectors", b"vectors"]) -> None: ...

global___MultiDenseVector = MultiDenseVector

class VectorInput(google.protobuf.message.Message):
    """Vector type to be used in queries. Ids will be substituted with their corresponding vectors from the collection."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    DENSE_FIELD_NUMBER: builtins.int
    SPARSE_FIELD_NUMBER: builtins.int
    MULTI_DENSE_FIELD_NUMBER: builtins.int
    DOCUMENT_FIELD_NUMBER: builtins.int
    IMAGE_FIELD_NUMBER: builtins.int
    OBJECT_FIELD_NUMBER: builtins.int
    @property
    def id(self) -> qdrant_common_pb2.PointId: ...
    @property
    def dense(self) -> global___DenseVector: ...
    @property
    def sparse(self) -> global___SparseVector: ...
    @property
    def multi_dense(self) -> global___MultiDenseVector: ...
    @property
    def document(self) -> global___Document: ...
    @property
    def image(self) -> global___Image: ...
    @property
    def object(self) -> global___InferenceObject: ...
    def __init__(
        self,
        *,
        id: qdrant_common_pb2.PointId | None = ...,
        dense: global___DenseVector | None = ...,
        sparse: global___SparseVector | None = ...,
        multi_dense: global___MultiDenseVector | None = ...,
        document: global___Document | None = ...,
        image: global___Image | None = ...,
        object: global___InferenceObject | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["dense", b"dense", "document", b"document", "id", b"id", "image", b"image", "multi_dense", b"multi_dense", "object", b"object", "sparse", b"sparse", "variant", b"variant"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["dense", b"dense", "document", b"document", "id", b"id", "image", b"image", "multi_dense", b"multi_dense", "object", b"object", "sparse", b"sparse", "variant", b"variant"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["variant", b"variant"]) -> typing_extensions.Literal["id", "dense", "sparse", "multi_dense", "document", "image", "object"] | None: ...

global___VectorInput = VectorInput

class ShardKeySelector(google.protobuf.message.Message):
    """---------------------------------------------
    ----------------- ShardKeySelector ----------
    ---------------------------------------------
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SHARD_KEYS_FIELD_NUMBER: builtins.int
    FALLBACK_FIELD_NUMBER: builtins.int
    @property
    def shard_keys(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[collections_pb2.ShardKey]:
        """List of shard keys which should be used in the request"""
    @property
    def fallback(self) -> collections_pb2.ShardKey: ...
    def __init__(
        self,
        *,
        shard_keys: collections.abc.Iterable[collections_pb2.ShardKey] | None = ...,
        fallback: collections_pb2.ShardKey | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_fallback", b"_fallback", "fallback", b"fallback"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_fallback", b"_fallback", "fallback", b"fallback", "shard_keys", b"shard_keys"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_fallback", b"_fallback"]) -> typing_extensions.Literal["fallback"] | None: ...

global___ShardKeySelector = ShardKeySelector

class UpsertPoints(google.protobuf.message.Message):
    """---------------------------------------------
    ---------------- RPC Requests ---------------
    ---------------------------------------------
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COLLECTION_NAME_FIELD_NUMBER: builtins.int
    WAIT_FIELD_NUMBER: builtins.int
    POINTS_FIELD_NUMBER: builtins.int
    ORDERING_FIELD_NUMBER: builtins.int
    SHARD_KEY_SELECTOR_FIELD_NUMBER: builtins.int
    UPDATE_FILTER_FIELD_NUMBER: builtins.int
    collection_name: builtins.str
    """name of the collection"""
    wait: builtins.bool
    """Wait until the changes have been applied?"""
    @property
    def points(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PointStruct]: ...
    @property
    def ordering(self) -> global___WriteOrdering:
        """Write ordering guarantees"""
    @property
    def shard_key_selector(self) -> global___ShardKeySelector:
        """Option for custom sharding to specify used shard keys"""
    @property
    def update_filter(self) -> qdrant_common_pb2.Filter:
        """If specified, only points that match this filter will be updated, others will be inserted"""
    def __init__(
        self,
        *,
        collection_name: builtins.str = ...,
        wait: builtins.bool | None = ...,
        points: collections.abc.Iterable[global___PointStruct] | None = ...,
        ordering: global___WriteOrdering | None = ...,
        shard_key_selector: global___ShardKeySelector | None = ...,
        update_filter: qdrant_common_pb2.Filter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_ordering", b"_ordering", "_shard_key_selector", b"_shard_key_selector", "_update_filter", b"_update_filter", "_wait", b"_wait", "ordering", b"ordering", "shard_key_selector", b"shard_key_selector", "update_filter", b"update_filter", "wait", b"wait"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_ordering", b"_ordering", "_shard_key_selector", b"_shard_key_selector", "_update_filter", b"_update_filter", "_wait", b"_wait", "collection_name", b"collection_name", "ordering", b"ordering", "points", b"points", "shard_key_selector", b"shard_key_selector", "update_filter", b"update_filter", "wait", b"wait"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_ordering", b"_ordering"]) -> typing_extensions.Literal["ordering"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector"]) -> typing_extensions.Literal["shard_key_selector"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_update_filter", b"_update_filter"]) -> typing_extensions.Literal["update_filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_wait", b"_wait"]) -> typing_extensions.Literal["wait"] | None: ...

global___UpsertPoints = UpsertPoints

class DeletePoints(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COLLECTION_NAME_FIELD_NUMBER: builtins.int
    WAIT_FIELD_NUMBER: builtins.int
    POINTS_FIELD_NUMBER: builtins.int
    ORDERING_FIELD_NUMBER: builtins.int
    SHARD_KEY_SELECTOR_FIELD_NUMBER: builtins.int
    collection_name: builtins.str
    """name of the collection"""
    wait: builtins.bool
    """Wait until the changes have been applied?"""
    @property
    def points(self) -> global___PointsSelector:
        """Affected points"""
    @property
    def ordering(self) -> global___WriteOrdering:
        """Write ordering guarantees"""
    @property
    def shard_key_selector(self) -> global___ShardKeySelector:
        """Option for custom sharding to specify used shard keys"""
    def __init__(
        self,
        *,
        collection_name: builtins.str = ...,
        wait: builtins.bool | None = ...,
        points: global___PointsSelector | None = ...,
        ordering: global___WriteOrdering | None = ...,
        shard_key_selector: global___ShardKeySelector | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_ordering", b"_ordering", "_shard_key_selector", b"_shard_key_selector", "_wait", b"_wait", "ordering", b"ordering", "points", b"points", "shard_key_selector", b"shard_key_selector", "wait", b"wait"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_ordering", b"_ordering", "_shard_key_selector", b"_shard_key_selector", "_wait", b"_wait", "collection_name", b"collection_name", "ordering", b"ordering", "points", b"points", "shard_key_selector", b"shard_key_selector", "wait", b"wait"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_ordering", b"_ordering"]) -> typing_extensions.Literal["ordering"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector"]) -> typing_extensions.Literal["shard_key_selector"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_wait", b"_wait"]) -> typing_extensions.Literal["wait"] | None: ...

global___DeletePoints = DeletePoints

class GetPoints(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COLLECTION_NAME_FIELD_NUMBER: builtins.int
    IDS_FIELD_NUMBER: builtins.int
    WITH_PAYLOAD_FIELD_NUMBER: builtins.int
    WITH_VECTORS_FIELD_NUMBER: builtins.int
    READ_CONSISTENCY_FIELD_NUMBER: builtins.int
    SHARD_KEY_SELECTOR_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    collection_name: builtins.str
    """name of the collection"""
    @property
    def ids(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[qdrant_common_pb2.PointId]:
        """List of points to retrieve"""
    @property
    def with_payload(self) -> global___WithPayloadSelector:
        """Options for specifying which payload to include or not"""
    @property
    def with_vectors(self) -> global___WithVectorsSelector:
        """Options for specifying which vectors to include into response"""
    @property
    def read_consistency(self) -> global___ReadConsistency:
        """Options for specifying read consistency guarantees"""
    @property
    def shard_key_selector(self) -> global___ShardKeySelector:
        """Specify in which shards to look for the points, if not specified - look in all shards"""
    timeout: builtins.int
    """If set, overrides global timeout setting for this request. Unit is seconds."""
    def __init__(
        self,
        *,
        collection_name: builtins.str = ...,
        ids: collections.abc.Iterable[qdrant_common_pb2.PointId] | None = ...,
        with_payload: global___WithPayloadSelector | None = ...,
        with_vectors: global___WithVectorsSelector | None = ...,
        read_consistency: global___ReadConsistency | None = ...,
        shard_key_selector: global___ShardKeySelector | None = ...,
        timeout: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_read_consistency", b"_read_consistency", "_shard_key_selector", b"_shard_key_selector", "_timeout", b"_timeout", "_with_vectors", b"_with_vectors", "read_consistency", b"read_consistency", "shard_key_selector", b"shard_key_selector", "timeout", b"timeout", "with_payload", b"with_payload", "with_vectors", b"with_vectors"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_read_consistency", b"_read_consistency", "_shard_key_selector", b"_shard_key_selector", "_timeout", b"_timeout", "_with_vectors", b"_with_vectors", "collection_name", b"collection_name", "ids", b"ids", "read_consistency", b"read_consistency", "shard_key_selector", b"shard_key_selector", "timeout", b"timeout", "with_payload", b"with_payload", "with_vectors", b"with_vectors"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_read_consistency", b"_read_consistency"]) -> typing_extensions.Literal["read_consistency"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector"]) -> typing_extensions.Literal["shard_key_selector"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_timeout", b"_timeout"]) -> typing_extensions.Literal["timeout"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_with_vectors", b"_with_vectors"]) -> typing_extensions.Literal["with_vectors"] | None: ...

global___GetPoints = GetPoints

class UpdatePointVectors(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COLLECTION_NAME_FIELD_NUMBER: builtins.int
    WAIT_FIELD_NUMBER: builtins.int
    POINTS_FIELD_NUMBER: builtins.int
    ORDERING_FIELD_NUMBER: builtins.int
    SHARD_KEY_SELECTOR_FIELD_NUMBER: builtins.int
    UPDATE_FILTER_FIELD_NUMBER: builtins.int
    collection_name: builtins.str
    """name of the collection"""
    wait: builtins.bool
    """Wait until the changes have been applied?"""
    @property
    def points(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PointVectors]:
        """List of points and vectors to update"""
    @property
    def ordering(self) -> global___WriteOrdering:
        """Write ordering guarantees"""
    @property
    def shard_key_selector(self) -> global___ShardKeySelector:
        """Option for custom sharding to specify used shard keys"""
    @property
    def update_filter(self) -> qdrant_common_pb2.Filter:
        """If specified, only points that match this filter will be updated"""
    def __init__(
        self,
        *,
        collection_name: builtins.str = ...,
        wait: builtins.bool | None = ...,
        points: collections.abc.Iterable[global___PointVectors] | None = ...,
        ordering: global___WriteOrdering | None = ...,
        shard_key_selector: global___ShardKeySelector | None = ...,
        update_filter: qdrant_common_pb2.Filter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_ordering", b"_ordering", "_shard_key_selector", b"_shard_key_selector", "_update_filter", b"_update_filter", "_wait", b"_wait", "ordering", b"ordering", "shard_key_selector", b"shard_key_selector", "update_filter", b"update_filter", "wait", b"wait"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_ordering", b"_ordering", "_shard_key_selector", b"_shard_key_selector", "_update_filter", b"_update_filter", "_wait", b"_wait", "collection_name", b"collection_name", "ordering", b"ordering", "points", b"points", "shard_key_selector", b"shard_key_selector", "update_filter", b"update_filter", "wait", b"wait"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_ordering", b"_ordering"]) -> typing_extensions.Literal["ordering"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector"]) -> typing_extensions.Literal["shard_key_selector"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_update_filter", b"_update_filter"]) -> typing_extensions.Literal["update_filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_wait", b"_wait"]) -> typing_extensions.Literal["wait"] | None: ...

global___UpdatePointVectors = UpdatePointVectors

class PointVectors(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    VECTORS_FIELD_NUMBER: builtins.int
    @property
    def id(self) -> qdrant_common_pb2.PointId:
        """ID to update vectors for"""
    @property
    def vectors(self) -> global___Vectors:
        """Named vectors to update, leave others intact"""
    def __init__(
        self,
        *,
        id: qdrant_common_pb2.PointId | None = ...,
        vectors: global___Vectors | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["id", b"id", "vectors", b"vectors"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id", "vectors", b"vectors"]) -> None: ...

global___PointVectors = PointVectors

class DeletePointVectors(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COLLECTION_NAME_FIELD_NUMBER: builtins.int
    WAIT_FIELD_NUMBER: builtins.int
    POINTS_SELECTOR_FIELD_NUMBER: builtins.int
    VECTORS_FIELD_NUMBER: builtins.int
    ORDERING_FIELD_NUMBER: builtins.int
    SHARD_KEY_SELECTOR_FIELD_NUMBER: builtins.int
    collection_name: builtins.str
    """name of the collection"""
    wait: builtins.bool
    """Wait until the changes have been applied?"""
    @property
    def points_selector(self) -> global___PointsSelector:
        """Affected points"""
    @property
    def vectors(self) -> global___VectorsSelector:
        """List of vector names to delete"""
    @property
    def ordering(self) -> global___WriteOrdering:
        """Write ordering guarantees"""
    @property
    def shard_key_selector(self) -> global___ShardKeySelector:
        """Option for custom sharding to specify used shard keys"""
    def __init__(
        self,
        *,
        collection_name: builtins.str = ...,
        wait: builtins.bool | None = ...,
        points_selector: global___PointsSelector | None = ...,
        vectors: global___VectorsSelector | None = ...,
        ordering: global___WriteOrdering | None = ...,
        shard_key_selector: global___ShardKeySelector | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_ordering", b"_ordering", "_shard_key_selector", b"_shard_key_selector", "_wait", b"_wait", "ordering", b"ordering", "points_selector", b"points_selector", "shard_key_selector", b"shard_key_selector", "vectors", b"vectors", "wait", b"wait"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_ordering", b"_ordering", "_shard_key_selector", b"_shard_key_selector", "_wait", b"_wait", "collection_name", b"collection_name", "ordering", b"ordering", "points_selector", b"points_selector", "shard_key_selector", b"shard_key_selector", "vectors", b"vectors", "wait", b"wait"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_ordering", b"_ordering"]) -> typing_extensions.Literal["ordering"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector"]) -> typing_extensions.Literal["shard_key_selector"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_wait", b"_wait"]) -> typing_extensions.Literal["wait"] | None: ...

global___DeletePointVectors = DeletePointVectors

class SetPayloadPoints(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class PayloadEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> json_with_int_pb2.Value: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: json_with_int_pb2.Value | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    COLLECTION_NAME_FIELD_NUMBER: builtins.int
    WAIT_FIELD_NUMBER: builtins.int
    PAYLOAD_FIELD_NUMBER: builtins.int
    POINTS_SELECTOR_FIELD_NUMBER: builtins.int
    ORDERING_FIELD_NUMBER: builtins.int
    SHARD_KEY_SELECTOR_FIELD_NUMBER: builtins.int
    KEY_FIELD_NUMBER: builtins.int
    collection_name: builtins.str
    """name of the collection"""
    wait: builtins.bool
    """Wait until the changes have been applied?"""
    @property
    def payload(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, json_with_int_pb2.Value]:
        """New payload values"""
    @property
    def points_selector(self) -> global___PointsSelector:
        """Affected points"""
    @property
    def ordering(self) -> global___WriteOrdering:
        """Write ordering guarantees"""
    @property
    def shard_key_selector(self) -> global___ShardKeySelector:
        """Option for custom sharding to specify used shard keys"""
    key: builtins.str
    """Option for indicate property of payload"""
    def __init__(
        self,
        *,
        collection_name: builtins.str = ...,
        wait: builtins.bool | None = ...,
        payload: collections.abc.Mapping[builtins.str, json_with_int_pb2.Value] | None = ...,
        points_selector: global___PointsSelector | None = ...,
        ordering: global___WriteOrdering | None = ...,
        shard_key_selector: global___ShardKeySelector | None = ...,
        key: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_key", b"_key", "_ordering", b"_ordering", "_points_selector", b"_points_selector", "_shard_key_selector", b"_shard_key_selector", "_wait", b"_wait", "key", b"key", "ordering", b"ordering", "points_selector", b"points_selector", "shard_key_selector", b"shard_key_selector", "wait", b"wait"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_key", b"_key", "_ordering", b"_ordering", "_points_selector", b"_points_selector", "_shard_key_selector", b"_shard_key_selector", "_wait", b"_wait", "collection_name", b"collection_name", "key", b"key", "ordering", b"ordering", "payload", b"payload", "points_selector", b"points_selector", "shard_key_selector", b"shard_key_selector", "wait", b"wait"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_key", b"_key"]) -> typing_extensions.Literal["key"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_ordering", b"_ordering"]) -> typing_extensions.Literal["ordering"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_points_selector", b"_points_selector"]) -> typing_extensions.Literal["points_selector"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector"]) -> typing_extensions.Literal["shard_key_selector"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_wait", b"_wait"]) -> typing_extensions.Literal["wait"] | None: ...

global___SetPayloadPoints = SetPayloadPoints

class DeletePayloadPoints(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COLLECTION_NAME_FIELD_NUMBER: builtins.int
    WAIT_FIELD_NUMBER: builtins.int
    KEYS_FIELD_NUMBER: builtins.int
    POINTS_SELECTOR_FIELD_NUMBER: builtins.int
    ORDERING_FIELD_NUMBER: builtins.int
    SHARD_KEY_SELECTOR_FIELD_NUMBER: builtins.int
    collection_name: builtins.str
    """name of the collection"""
    wait: builtins.bool
    """Wait until the changes have been applied?"""
    @property
    def keys(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of keys to delete"""
    @property
    def points_selector(self) -> global___PointsSelector:
        """Affected points"""
    @property
    def ordering(self) -> global___WriteOrdering:
        """Write ordering guarantees"""
    @property
    def shard_key_selector(self) -> global___ShardKeySelector:
        """Option for custom sharding to specify used shard keys"""
    def __init__(
        self,
        *,
        collection_name: builtins.str = ...,
        wait: builtins.bool | None = ...,
        keys: collections.abc.Iterable[builtins.str] | None = ...,
        points_selector: global___PointsSelector | None = ...,
        ordering: global___WriteOrdering | None = ...,
        shard_key_selector: global___ShardKeySelector | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_ordering", b"_ordering", "_points_selector", b"_points_selector", "_shard_key_selector", b"_shard_key_selector", "_wait", b"_wait", "ordering", b"ordering", "points_selector", b"points_selector", "shard_key_selector", b"shard_key_selector", "wait", b"wait"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_ordering", b"_ordering", "_points_selector", b"_points_selector", "_shard_key_selector", b"_shard_key_selector", "_wait", b"_wait", "collection_name", b"collection_name", "keys", b"keys", "ordering", b"ordering", "points_selector", b"points_selector", "shard_key_selector", b"shard_key_selector", "wait", b"wait"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_ordering", b"_ordering"]) -> typing_extensions.Literal["ordering"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_points_selector", b"_points_selector"]) -> typing_extensions.Literal["points_selector"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector"]) -> typing_extensions.Literal["shard_key_selector"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_wait", b"_wait"]) -> typing_extensions.Literal["wait"] | None: ...

global___DeletePayloadPoints = DeletePayloadPoints

class ClearPayloadPoints(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COLLECTION_NAME_FIELD_NUMBER: builtins.int
    WAIT_FIELD_NUMBER: builtins.int
    POINTS_FIELD_NUMBER: builtins.int
    ORDERING_FIELD_NUMBER: builtins.int
    SHARD_KEY_SELECTOR_FIELD_NUMBER: builtins.int
    collection_name: builtins.str
    """name of the collection"""
    wait: builtins.bool
    """Wait until the changes have been applied?"""
    @property
    def points(self) -> global___PointsSelector:
        """Affected points"""
    @property
    def ordering(self) -> global___WriteOrdering:
        """Write ordering guarantees"""
    @property
    def shard_key_selector(self) -> global___ShardKeySelector:
        """Option for custom sharding to specify used shard keys"""
    def __init__(
        self,
        *,
        collection_name: builtins.str = ...,
        wait: builtins.bool | None = ...,
        points: global___PointsSelector | None = ...,
        ordering: global___WriteOrdering | None = ...,
        shard_key_selector: global___ShardKeySelector | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_ordering", b"_ordering", "_shard_key_selector", b"_shard_key_selector", "_wait", b"_wait", "ordering", b"ordering", "points", b"points", "shard_key_selector", b"shard_key_selector", "wait", b"wait"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_ordering", b"_ordering", "_shard_key_selector", b"_shard_key_selector", "_wait", b"_wait", "collection_name", b"collection_name", "ordering", b"ordering", "points", b"points", "shard_key_selector", b"shard_key_selector", "wait", b"wait"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_ordering", b"_ordering"]) -> typing_extensions.Literal["ordering"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector"]) -> typing_extensions.Literal["shard_key_selector"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_wait", b"_wait"]) -> typing_extensions.Literal["wait"] | None: ...

global___ClearPayloadPoints = ClearPayloadPoints

class CreateFieldIndexCollection(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COLLECTION_NAME_FIELD_NUMBER: builtins.int
    WAIT_FIELD_NUMBER: builtins.int
    FIELD_NAME_FIELD_NUMBER: builtins.int
    FIELD_TYPE_FIELD_NUMBER: builtins.int
    FIELD_INDEX_PARAMS_FIELD_NUMBER: builtins.int
    ORDERING_FIELD_NUMBER: builtins.int
    collection_name: builtins.str
    """name of the collection"""
    wait: builtins.bool
    """Wait until the changes have been applied?"""
    field_name: builtins.str
    """Field name to index"""
    field_type: global___FieldType.ValueType
    """Field type."""
    @property
    def field_index_params(self) -> collections_pb2.PayloadIndexParams:
        """Payload index params."""
    @property
    def ordering(self) -> global___WriteOrdering:
        """Write ordering guarantees"""
    def __init__(
        self,
        *,
        collection_name: builtins.str = ...,
        wait: builtins.bool | None = ...,
        field_name: builtins.str = ...,
        field_type: global___FieldType.ValueType | None = ...,
        field_index_params: collections_pb2.PayloadIndexParams | None = ...,
        ordering: global___WriteOrdering | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_field_index_params", b"_field_index_params", "_field_type", b"_field_type", "_ordering", b"_ordering", "_wait", b"_wait", "field_index_params", b"field_index_params", "field_type", b"field_type", "ordering", b"ordering", "wait", b"wait"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_field_index_params", b"_field_index_params", "_field_type", b"_field_type", "_ordering", b"_ordering", "_wait", b"_wait", "collection_name", b"collection_name", "field_index_params", b"field_index_params", "field_name", b"field_name", "field_type", b"field_type", "ordering", b"ordering", "wait", b"wait"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_field_index_params", b"_field_index_params"]) -> typing_extensions.Literal["field_index_params"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_field_type", b"_field_type"]) -> typing_extensions.Literal["field_type"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_ordering", b"_ordering"]) -> typing_extensions.Literal["ordering"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_wait", b"_wait"]) -> typing_extensions.Literal["wait"] | None: ...

global___CreateFieldIndexCollection = CreateFieldIndexCollection

class DeleteFieldIndexCollection(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COLLECTION_NAME_FIELD_NUMBER: builtins.int
    WAIT_FIELD_NUMBER: builtins.int
    FIELD_NAME_FIELD_NUMBER: builtins.int
    ORDERING_FIELD_NUMBER: builtins.int
    collection_name: builtins.str
    """name of the collection"""
    wait: builtins.bool
    """Wait until the changes have been applied?"""
    field_name: builtins.str
    """Field name to delete"""
    @property
    def ordering(self) -> global___WriteOrdering:
        """Write ordering guarantees"""
    def __init__(
        self,
        *,
        collection_name: builtins.str = ...,
        wait: builtins.bool | None = ...,
        field_name: builtins.str = ...,
        ordering: global___WriteOrdering | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_ordering", b"_ordering", "_wait", b"_wait", "ordering", b"ordering", "wait", b"wait"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_ordering", b"_ordering", "_wait", b"_wait", "collection_name", b"collection_name", "field_name", b"field_name", "ordering", b"ordering", "wait", b"wait"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_ordering", b"_ordering"]) -> typing_extensions.Literal["ordering"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_wait", b"_wait"]) -> typing_extensions.Literal["wait"] | None: ...

global___DeleteFieldIndexCollection = DeleteFieldIndexCollection

class PayloadIncludeSelector(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIELDS_FIELD_NUMBER: builtins.int
    @property
    def fields(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of payload keys to include into result"""
    def __init__(
        self,
        *,
        fields: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["fields", b"fields"]) -> None: ...

global___PayloadIncludeSelector = PayloadIncludeSelector

class PayloadExcludeSelector(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIELDS_FIELD_NUMBER: builtins.int
    @property
    def fields(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of payload keys to exclude from the result"""
    def __init__(
        self,
        *,
        fields: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["fields", b"fields"]) -> None: ...

global___PayloadExcludeSelector = PayloadExcludeSelector

class WithPayloadSelector(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENABLE_FIELD_NUMBER: builtins.int
    INCLUDE_FIELD_NUMBER: builtins.int
    EXCLUDE_FIELD_NUMBER: builtins.int
    enable: builtins.bool
    """If `true` - return all payload, if `false` - none"""
    @property
    def include(self) -> global___PayloadIncludeSelector: ...
    @property
    def exclude(self) -> global___PayloadExcludeSelector: ...
    def __init__(
        self,
        *,
        enable: builtins.bool = ...,
        include: global___PayloadIncludeSelector | None = ...,
        exclude: global___PayloadExcludeSelector | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["enable", b"enable", "exclude", b"exclude", "include", b"include", "selector_options", b"selector_options"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["enable", b"enable", "exclude", b"exclude", "include", b"include", "selector_options", b"selector_options"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["selector_options", b"selector_options"]) -> typing_extensions.Literal["enable", "include", "exclude"] | None: ...

global___WithPayloadSelector = WithPayloadSelector

class NamedVectors(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class VectorsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___Vector: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___Vector | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    VECTORS_FIELD_NUMBER: builtins.int
    @property
    def vectors(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___Vector]: ...
    def __init__(
        self,
        *,
        vectors: collections.abc.Mapping[builtins.str, global___Vector] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["vectors", b"vectors"]) -> None: ...

global___NamedVectors = NamedVectors

class NamedVectorsOutput(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class VectorsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___VectorOutput: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___VectorOutput | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    VECTORS_FIELD_NUMBER: builtins.int
    @property
    def vectors(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___VectorOutput]: ...
    def __init__(
        self,
        *,
        vectors: collections.abc.Mapping[builtins.str, global___VectorOutput] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["vectors", b"vectors"]) -> None: ...

global___NamedVectorsOutput = NamedVectorsOutput

class Vectors(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VECTOR_FIELD_NUMBER: builtins.int
    VECTORS_FIELD_NUMBER: builtins.int
    @property
    def vector(self) -> global___Vector: ...
    @property
    def vectors(self) -> global___NamedVectors: ...
    def __init__(
        self,
        *,
        vector: global___Vector | None = ...,
        vectors: global___NamedVectors | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["vector", b"vector", "vectors", b"vectors", "vectors_options", b"vectors_options"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["vector", b"vector", "vectors", b"vectors", "vectors_options", b"vectors_options"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["vectors_options", b"vectors_options"]) -> typing_extensions.Literal["vector", "vectors"] | None: ...

global___Vectors = Vectors

class VectorsOutput(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VECTOR_FIELD_NUMBER: builtins.int
    VECTORS_FIELD_NUMBER: builtins.int
    @property
    def vector(self) -> global___VectorOutput: ...
    @property
    def vectors(self) -> global___NamedVectorsOutput: ...
    def __init__(
        self,
        *,
        vector: global___VectorOutput | None = ...,
        vectors: global___NamedVectorsOutput | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["vector", b"vector", "vectors", b"vectors", "vectors_options", b"vectors_options"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["vector", b"vector", "vectors", b"vectors", "vectors_options", b"vectors_options"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["vectors_options", b"vectors_options"]) -> typing_extensions.Literal["vector", "vectors"] | None: ...

global___VectorsOutput = VectorsOutput

class VectorsSelector(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMES_FIELD_NUMBER: builtins.int
    @property
    def names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of vectors to include into result"""
    def __init__(
        self,
        *,
        names: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["names", b"names"]) -> None: ...

global___VectorsSelector = VectorsSelector

class WithVectorsSelector(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENABLE_FIELD_NUMBER: builtins.int
    INCLUDE_FIELD_NUMBER: builtins.int
    enable: builtins.bool
    """If `true` - return all vectors, if `false` - none"""
    @property
    def include(self) -> global___VectorsSelector:
        """List of payload keys to include into result"""
    def __init__(
        self,
        *,
        enable: builtins.bool = ...,
        include: global___VectorsSelector | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["enable", b"enable", "include", b"include", "selector_options", b"selector_options"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["enable", b"enable", "include", b"include", "selector_options", b"selector_options"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["selector_options", b"selector_options"]) -> typing_extensions.Literal["enable", "include"] | None: ...

global___WithVectorsSelector = WithVectorsSelector

class QuantizationSearchParams(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IGNORE_FIELD_NUMBER: builtins.int
    RESCORE_FIELD_NUMBER: builtins.int
    OVERSAMPLING_FIELD_NUMBER: builtins.int
    ignore: builtins.bool
    """
    If set to true, search will ignore quantized vector data
    """
    rescore: builtins.bool
    """
    If true, use original vectors to re-score top-k results. If ignored, qdrant decides automatically does rescore enabled or not.
    """
    oversampling: builtins.float
    """
    Oversampling factor for quantization.

    Defines how many extra vectors should be pre-selected using quantized index,
    and then re-scored using original vectors.

    For example, if `oversampling` is 2.4 and `limit` is 100, then 240 vectors will be pre-selected using quantized index,
    and then top-100 will be returned after re-scoring.
    """
    def __init__(
        self,
        *,
        ignore: builtins.bool | None = ...,
        rescore: builtins.bool | None = ...,
        oversampling: builtins.float | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_ignore", b"_ignore", "_oversampling", b"_oversampling", "_rescore", b"_rescore", "ignore", b"ignore", "oversampling", b"oversampling", "rescore", b"rescore"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_ignore", b"_ignore", "_oversampling", b"_oversampling", "_rescore", b"_rescore", "ignore", b"ignore", "oversampling", b"oversampling", "rescore", b"rescore"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_ignore", b"_ignore"]) -> typing_extensions.Literal["ignore"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_oversampling", b"_oversampling"]) -> typing_extensions.Literal["oversampling"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_rescore", b"_rescore"]) -> typing_extensions.Literal["rescore"] | None: ...

global___QuantizationSearchParams = QuantizationSearchParams

class AcornSearchParams(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENABLE_FIELD_NUMBER: builtins.int
    MAX_SELECTIVITY_FIELD_NUMBER: builtins.int
    enable: builtins.bool
    """
    If true, then ACORN may be used for the HNSW search based on filters
    selectivity.

    Improves search recall for searches with multiple low-selectivity
    payload filters, at cost of performance.
    """
    max_selectivity: builtins.float
    """
    Maximum selectivity of filters to enable ACORN.

    If estimated filters selectivity is higher than this value,
    ACORN will not be used. Selectivity is estimated as:
    `estimated number of points satisfying the filters / total number of points`.

    0.0 for never, 1.0 for always. Default is 0.4.
    """
    def __init__(
        self,
        *,
        enable: builtins.bool | None = ...,
        max_selectivity: builtins.float | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_enable", b"_enable", "_max_selectivity", b"_max_selectivity", "enable", b"enable", "max_selectivity", b"max_selectivity"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_enable", b"_enable", "_max_selectivity", b"_max_selectivity", "enable", b"enable", "max_selectivity", b"max_selectivity"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_enable", b"_enable"]) -> typing_extensions.Literal["enable"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_max_selectivity", b"_max_selectivity"]) -> typing_extensions.Literal["max_selectivity"] | None: ...

global___AcornSearchParams = AcornSearchParams

class SearchParams(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HNSW_EF_FIELD_NUMBER: builtins.int
    EXACT_FIELD_NUMBER: builtins.int
    QUANTIZATION_FIELD_NUMBER: builtins.int
    INDEXED_ONLY_FIELD_NUMBER: builtins.int
    ACORN_FIELD_NUMBER: builtins.int
    hnsw_ef: builtins.int
    """
    Params relevant to HNSW index. Size of the beam in a beam-search.
    Larger the value - more accurate the result, more time required for search.
    """
    exact: builtins.bool
    """
    Search without approximation. If set to true, search may run long but with exact results.
    """
    @property
    def quantization(self) -> global___QuantizationSearchParams:
        """
        If set to true, search will ignore quantized vector data
        """
    indexed_only: builtins.bool
    """
    If enabled, the engine will only perform search among indexed or small segments.
    Using this option prevents slow searches in case of delayed index, but does not
    guarantee that all uploaded vectors will be included in search results
    """
    @property
    def acorn(self) -> global___AcornSearchParams:
        """
        ACORN search params
        """
    def __init__(
        self,
        *,
        hnsw_ef: builtins.int | None = ...,
        exact: builtins.bool | None = ...,
        quantization: global___QuantizationSearchParams | None = ...,
        indexed_only: builtins.bool | None = ...,
        acorn: global___AcornSearchParams | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_acorn", b"_acorn", "_exact", b"_exact", "_hnsw_ef", b"_hnsw_ef", "_indexed_only", b"_indexed_only", "_quantization", b"_quantization", "acorn", b"acorn", "exact", b"exact", "hnsw_ef", b"hnsw_ef", "indexed_only", b"indexed_only", "quantization", b"quantization"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_acorn", b"_acorn", "_exact", b"_exact", "_hnsw_ef", b"_hnsw_ef", "_indexed_only", b"_indexed_only", "_quantization", b"_quantization", "acorn", b"acorn", "exact", b"exact", "hnsw_ef", b"hnsw_ef", "indexed_only", b"indexed_only", "quantization", b"quantization"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_acorn", b"_acorn"]) -> typing_extensions.Literal["acorn"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_exact", b"_exact"]) -> typing_extensions.Literal["exact"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_hnsw_ef", b"_hnsw_ef"]) -> typing_extensions.Literal["hnsw_ef"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_indexed_only", b"_indexed_only"]) -> typing_extensions.Literal["indexed_only"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_quantization", b"_quantization"]) -> typing_extensions.Literal["quantization"] | None: ...

global___SearchParams = SearchParams

class SearchPoints(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COLLECTION_NAME_FIELD_NUMBER: builtins.int
    VECTOR_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    WITH_PAYLOAD_FIELD_NUMBER: builtins.int
    PARAMS_FIELD_NUMBER: builtins.int
    SCORE_THRESHOLD_FIELD_NUMBER: builtins.int
    OFFSET_FIELD_NUMBER: builtins.int
    VECTOR_NAME_FIELD_NUMBER: builtins.int
    WITH_VECTORS_FIELD_NUMBER: builtins.int
    READ_CONSISTENCY_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    SHARD_KEY_SELECTOR_FIELD_NUMBER: builtins.int
    SPARSE_INDICES_FIELD_NUMBER: builtins.int
    collection_name: builtins.str
    """name of the collection"""
    @property
    def vector(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
        """vector"""
    @property
    def filter(self) -> qdrant_common_pb2.Filter:
        """Filter conditions - return only those points that satisfy the specified conditions"""
    limit: builtins.int
    """Max number of result"""
    @property
    def with_payload(self) -> global___WithPayloadSelector:
        """Options for specifying which payload to include or not"""
    @property
    def params(self) -> global___SearchParams:
        """Search config"""
    score_threshold: builtins.float
    """If provided - cut off results with worse scores"""
    offset: builtins.int
    """Offset of the result"""
    vector_name: builtins.str
    """Which vector to use for search, if not specified - use default vector"""
    @property
    def with_vectors(self) -> global___WithVectorsSelector:
        """Options for specifying which vectors to include into response"""
    @property
    def read_consistency(self) -> global___ReadConsistency:
        """Options for specifying read consistency guarantees"""
    timeout: builtins.int
    """If set, overrides global timeout setting for this request. Unit is seconds."""
    @property
    def shard_key_selector(self) -> global___ShardKeySelector:
        """Specify in which shards to look for the points, if not specified - look in all shards"""
    @property
    def sparse_indices(self) -> global___SparseIndices: ...
    def __init__(
        self,
        *,
        collection_name: builtins.str = ...,
        vector: collections.abc.Iterable[builtins.float] | None = ...,
        filter: qdrant_common_pb2.Filter | None = ...,
        limit: builtins.int = ...,
        with_payload: global___WithPayloadSelector | None = ...,
        params: global___SearchParams | None = ...,
        score_threshold: builtins.float | None = ...,
        offset: builtins.int | None = ...,
        vector_name: builtins.str | None = ...,
        with_vectors: global___WithVectorsSelector | None = ...,
        read_consistency: global___ReadConsistency | None = ...,
        timeout: builtins.int | None = ...,
        shard_key_selector: global___ShardKeySelector | None = ...,
        sparse_indices: global___SparseIndices | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_offset", b"_offset", "_read_consistency", b"_read_consistency", "_score_threshold", b"_score_threshold", "_shard_key_selector", b"_shard_key_selector", "_sparse_indices", b"_sparse_indices", "_timeout", b"_timeout", "_vector_name", b"_vector_name", "_with_vectors", b"_with_vectors", "filter", b"filter", "offset", b"offset", "params", b"params", "read_consistency", b"read_consistency", "score_threshold", b"score_threshold", "shard_key_selector", b"shard_key_selector", "sparse_indices", b"sparse_indices", "timeout", b"timeout", "vector_name", b"vector_name", "with_payload", b"with_payload", "with_vectors", b"with_vectors"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_offset", b"_offset", "_read_consistency", b"_read_consistency", "_score_threshold", b"_score_threshold", "_shard_key_selector", b"_shard_key_selector", "_sparse_indices", b"_sparse_indices", "_timeout", b"_timeout", "_vector_name", b"_vector_name", "_with_vectors", b"_with_vectors", "collection_name", b"collection_name", "filter", b"filter", "limit", b"limit", "offset", b"offset", "params", b"params", "read_consistency", b"read_consistency", "score_threshold", b"score_threshold", "shard_key_selector", b"shard_key_selector", "sparse_indices", b"sparse_indices", "timeout", b"timeout", "vector", b"vector", "vector_name", b"vector_name", "with_payload", b"with_payload", "with_vectors", b"with_vectors"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_offset", b"_offset"]) -> typing_extensions.Literal["offset"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_read_consistency", b"_read_consistency"]) -> typing_extensions.Literal["read_consistency"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_score_threshold", b"_score_threshold"]) -> typing_extensions.Literal["score_threshold"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector"]) -> typing_extensions.Literal["shard_key_selector"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_sparse_indices", b"_sparse_indices"]) -> typing_extensions.Literal["sparse_indices"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_timeout", b"_timeout"]) -> typing_extensions.Literal["timeout"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_vector_name", b"_vector_name"]) -> typing_extensions.Literal["vector_name"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_with_vectors", b"_with_vectors"]) -> typing_extensions.Literal["with_vectors"] | None: ...

global___SearchPoints = SearchPoints

class SearchBatchPoints(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COLLECTION_NAME_FIELD_NUMBER: builtins.int
    SEARCH_POINTS_FIELD_NUMBER: builtins.int
    READ_CONSISTENCY_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    collection_name: builtins.str
    """Name of the collection"""
    @property
    def search_points(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SearchPoints]: ...
    @property
    def read_consistency(self) -> global___ReadConsistency:
        """Options for specifying read consistency guarantees"""
    timeout: builtins.int
    """If set, overrides global timeout setting for this request. Unit is seconds."""
    def __init__(
        self,
        *,
        collection_name: builtins.str = ...,
        search_points: collections.abc.Iterable[global___SearchPoints] | None = ...,
        read_consistency: global___ReadConsistency | None = ...,
        timeout: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_read_consistency", b"_read_consistency", "_timeout", b"_timeout", "read_consistency", b"read_consistency", "timeout", b"timeout"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_read_consistency", b"_read_consistency", "_timeout", b"_timeout", "collection_name", b"collection_name", "read_consistency", b"read_consistency", "search_points", b"search_points", "timeout", b"timeout"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_read_consistency", b"_read_consistency"]) -> typing_extensions.Literal["read_consistency"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_timeout", b"_timeout"]) -> typing_extensions.Literal["timeout"] | None: ...

global___SearchBatchPoints = SearchBatchPoints

class WithLookup(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COLLECTION_FIELD_NUMBER: builtins.int
    WITH_PAYLOAD_FIELD_NUMBER: builtins.int
    WITH_VECTORS_FIELD_NUMBER: builtins.int
    collection: builtins.str
    """Name of the collection to use for points lookup"""
    @property
    def with_payload(self) -> global___WithPayloadSelector:
        """Options for specifying which payload to include (or not)"""
    @property
    def with_vectors(self) -> global___WithVectorsSelector:
        """Options for specifying which vectors to include (or not)"""
    def __init__(
        self,
        *,
        collection: builtins.str = ...,
        with_payload: global___WithPayloadSelector | None = ...,
        with_vectors: global___WithVectorsSelector | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_with_payload", b"_with_payload", "_with_vectors", b"_with_vectors", "with_payload", b"with_payload", "with_vectors", b"with_vectors"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_with_payload", b"_with_payload", "_with_vectors", b"_with_vectors", "collection", b"collection", "with_payload", b"with_payload", "with_vectors", b"with_vectors"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_with_payload", b"_with_payload"]) -> typing_extensions.Literal["with_payload"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_with_vectors", b"_with_vectors"]) -> typing_extensions.Literal["with_vectors"] | None: ...

global___WithLookup = WithLookup

class SearchPointGroups(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COLLECTION_NAME_FIELD_NUMBER: builtins.int
    VECTOR_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    WITH_PAYLOAD_FIELD_NUMBER: builtins.int
    PARAMS_FIELD_NUMBER: builtins.int
    SCORE_THRESHOLD_FIELD_NUMBER: builtins.int
    VECTOR_NAME_FIELD_NUMBER: builtins.int
    WITH_VECTORS_FIELD_NUMBER: builtins.int
    GROUP_BY_FIELD_NUMBER: builtins.int
    GROUP_SIZE_FIELD_NUMBER: builtins.int
    READ_CONSISTENCY_FIELD_NUMBER: builtins.int
    WITH_LOOKUP_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    SHARD_KEY_SELECTOR_FIELD_NUMBER: builtins.int
    SPARSE_INDICES_FIELD_NUMBER: builtins.int
    collection_name: builtins.str
    """Name of the collection"""
    @property
    def vector(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
        """Vector to compare against"""
    @property
    def filter(self) -> qdrant_common_pb2.Filter:
        """Filter conditions - return only those points that satisfy the specified conditions"""
    limit: builtins.int
    """Max number of result"""
    @property
    def with_payload(self) -> global___WithPayloadSelector:
        """Options for specifying which payload to include or not"""
    @property
    def params(self) -> global___SearchParams:
        """Search config"""
    score_threshold: builtins.float
    """If provided - cut off results with worse scores"""
    vector_name: builtins.str
    """Which vector to use for search, if not specified - use default vector"""
    @property
    def with_vectors(self) -> global___WithVectorsSelector:
        """Options for specifying which vectors to include into response"""
    group_by: builtins.str
    """Payload field to group by, must be a string or number field. If there are multiple values for the field, all of them will be used. One point can be in multiple groups."""
    group_size: builtins.int
    """Maximum amount of points to return per group"""
    @property
    def read_consistency(self) -> global___ReadConsistency:
        """Options for specifying read consistency guarantees"""
    @property
    def with_lookup(self) -> global___WithLookup:
        """Options for specifying how to use the group id to lookup points in another collection"""
    timeout: builtins.int
    """If set, overrides global timeout setting for this request. Unit is seconds."""
    @property
    def shard_key_selector(self) -> global___ShardKeySelector:
        """Specify in which shards to look for the points, if not specified - look in all shards"""
    @property
    def sparse_indices(self) -> global___SparseIndices: ...
    def __init__(
        self,
        *,
        collection_name: builtins.str = ...,
        vector: collections.abc.Iterable[builtins.float] | None = ...,
        filter: qdrant_common_pb2.Filter | None = ...,
        limit: builtins.int = ...,
        with_payload: global___WithPayloadSelector | None = ...,
        params: global___SearchParams | None = ...,
        score_threshold: builtins.float | None = ...,
        vector_name: builtins.str | None = ...,
        with_vectors: global___WithVectorsSelector | None = ...,
        group_by: builtins.str = ...,
        group_size: builtins.int = ...,
        read_consistency: global___ReadConsistency | None = ...,
        with_lookup: global___WithLookup | None = ...,
        timeout: builtins.int | None = ...,
        shard_key_selector: global___ShardKeySelector | None = ...,
        sparse_indices: global___SparseIndices | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_read_consistency", b"_read_consistency", "_score_threshold", b"_score_threshold", "_shard_key_selector", b"_shard_key_selector", "_sparse_indices", b"_sparse_indices", "_timeout", b"_timeout", "_vector_name", b"_vector_name", "_with_lookup", b"_with_lookup", "_with_vectors", b"_with_vectors", "filter", b"filter", "params", b"params", "read_consistency", b"read_consistency", "score_threshold", b"score_threshold", "shard_key_selector", b"shard_key_selector", "sparse_indices", b"sparse_indices", "timeout", b"timeout", "vector_name", b"vector_name", "with_lookup", b"with_lookup", "with_payload", b"with_payload", "with_vectors", b"with_vectors"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_read_consistency", b"_read_consistency", "_score_threshold", b"_score_threshold", "_shard_key_selector", b"_shard_key_selector", "_sparse_indices", b"_sparse_indices", "_timeout", b"_timeout", "_vector_name", b"_vector_name", "_with_lookup", b"_with_lookup", "_with_vectors", b"_with_vectors", "collection_name", b"collection_name", "filter", b"filter", "group_by", b"group_by", "group_size", b"group_size", "limit", b"limit", "params", b"params", "read_consistency", b"read_consistency", "score_threshold", b"score_threshold", "shard_key_selector", b"shard_key_selector", "sparse_indices", b"sparse_indices", "timeout", b"timeout", "vector", b"vector", "vector_name", b"vector_name", "with_lookup", b"with_lookup", "with_payload", b"with_payload", "with_vectors", b"with_vectors"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_read_consistency", b"_read_consistency"]) -> typing_extensions.Literal["read_consistency"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_score_threshold", b"_score_threshold"]) -> typing_extensions.Literal["score_threshold"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector"]) -> typing_extensions.Literal["shard_key_selector"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_sparse_indices", b"_sparse_indices"]) -> typing_extensions.Literal["sparse_indices"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_timeout", b"_timeout"]) -> typing_extensions.Literal["timeout"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_vector_name", b"_vector_name"]) -> typing_extensions.Literal["vector_name"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_with_lookup", b"_with_lookup"]) -> typing_extensions.Literal["with_lookup"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_with_vectors", b"_with_vectors"]) -> typing_extensions.Literal["with_vectors"] | None: ...

global___SearchPointGroups = SearchPointGroups

class StartFrom(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FLOAT_FIELD_NUMBER: builtins.int
    INTEGER_FIELD_NUMBER: builtins.int
    TIMESTAMP_FIELD_NUMBER: builtins.int
    DATETIME_FIELD_NUMBER: builtins.int
    float: builtins.float
    integer: builtins.int
    @property
    def timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    datetime: builtins.str
    def __init__(
        self,
        *,
        float: builtins.float = ...,
        integer: builtins.int = ...,
        timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        datetime: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["datetime", b"datetime", "float", b"float", "integer", b"integer", "timestamp", b"timestamp", "value", b"value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["datetime", b"datetime", "float", b"float", "integer", b"integer", "timestamp", b"timestamp", "value", b"value"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["value", b"value"]) -> typing_extensions.Literal["float", "integer", "timestamp", "datetime"] | None: ...

global___StartFrom = StartFrom

class OrderBy(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    DIRECTION_FIELD_NUMBER: builtins.int
    START_FROM_FIELD_NUMBER: builtins.int
    key: builtins.str
    """Payload key to order by"""
    direction: global___Direction.ValueType
    """Ascending or descending order"""
    @property
    def start_from(self) -> global___StartFrom:
        """Start from this value"""
    def __init__(
        self,
        *,
        key: builtins.str = ...,
        direction: global___Direction.ValueType | None = ...,
        start_from: global___StartFrom | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_direction", b"_direction", "_start_from", b"_start_from", "direction", b"direction", "start_from", b"start_from"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_direction", b"_direction", "_start_from", b"_start_from", "direction", b"direction", "key", b"key", "start_from", b"start_from"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_direction", b"_direction"]) -> typing_extensions.Literal["direction"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_start_from", b"_start_from"]) -> typing_extensions.Literal["start_from"] | None: ...

global___OrderBy = OrderBy

class ScrollPoints(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COLLECTION_NAME_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    OFFSET_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    WITH_PAYLOAD_FIELD_NUMBER: builtins.int
    WITH_VECTORS_FIELD_NUMBER: builtins.int
    READ_CONSISTENCY_FIELD_NUMBER: builtins.int
    SHARD_KEY_SELECTOR_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    collection_name: builtins.str
    @property
    def filter(self) -> qdrant_common_pb2.Filter:
        """Filter conditions - return only those points that satisfy the specified conditions"""
    @property
    def offset(self) -> qdrant_common_pb2.PointId:
        """Start with this ID"""
    limit: builtins.int
    """Max number of result"""
    @property
    def with_payload(self) -> global___WithPayloadSelector:
        """Options for specifying which payload to include or not"""
    @property
    def with_vectors(self) -> global___WithVectorsSelector:
        """Options for specifying which vectors to include into response"""
    @property
    def read_consistency(self) -> global___ReadConsistency:
        """Options for specifying read consistency guarantees"""
    @property
    def shard_key_selector(self) -> global___ShardKeySelector:
        """Specify in which shards to look for the points, if not specified - look in all shards"""
    @property
    def order_by(self) -> global___OrderBy:
        """Order the records by a payload field"""
    timeout: builtins.int
    """If set, overrides global timeout setting for this request. Unit is seconds."""
    def __init__(
        self,
        *,
        collection_name: builtins.str = ...,
        filter: qdrant_common_pb2.Filter | None = ...,
        offset: qdrant_common_pb2.PointId | None = ...,
        limit: builtins.int | None = ...,
        with_payload: global___WithPayloadSelector | None = ...,
        with_vectors: global___WithVectorsSelector | None = ...,
        read_consistency: global___ReadConsistency | None = ...,
        shard_key_selector: global___ShardKeySelector | None = ...,
        order_by: global___OrderBy | None = ...,
        timeout: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_limit", b"_limit", "_offset", b"_offset", "_order_by", b"_order_by", "_read_consistency", b"_read_consistency", "_shard_key_selector", b"_shard_key_selector", "_timeout", b"_timeout", "_with_vectors", b"_with_vectors", "filter", b"filter", "limit", b"limit", "offset", b"offset", "order_by", b"order_by", "read_consistency", b"read_consistency", "shard_key_selector", b"shard_key_selector", "timeout", b"timeout", "with_payload", b"with_payload", "with_vectors", b"with_vectors"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_limit", b"_limit", "_offset", b"_offset", "_order_by", b"_order_by", "_read_consistency", b"_read_consistency", "_shard_key_selector", b"_shard_key_selector", "_timeout", b"_timeout", "_with_vectors", b"_with_vectors", "collection_name", b"collection_name", "filter", b"filter", "limit", b"limit", "offset", b"offset", "order_by", b"order_by", "read_consistency", b"read_consistency", "shard_key_selector", b"shard_key_selector", "timeout", b"timeout", "with_payload", b"with_payload", "with_vectors", b"with_vectors"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_limit", b"_limit"]) -> typing_extensions.Literal["limit"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_offset", b"_offset"]) -> typing_extensions.Literal["offset"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_order_by", b"_order_by"]) -> typing_extensions.Literal["order_by"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_read_consistency", b"_read_consistency"]) -> typing_extensions.Literal["read_consistency"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector"]) -> typing_extensions.Literal["shard_key_selector"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_timeout", b"_timeout"]) -> typing_extensions.Literal["timeout"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_with_vectors", b"_with_vectors"]) -> typing_extensions.Literal["with_vectors"] | None: ...

global___ScrollPoints = ScrollPoints

class LookupLocation(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COLLECTION_NAME_FIELD_NUMBER: builtins.int
    VECTOR_NAME_FIELD_NUMBER: builtins.int
    SHARD_KEY_SELECTOR_FIELD_NUMBER: builtins.int
    collection_name: builtins.str
    vector_name: builtins.str
    """Which vector to use for search, if not specified - use default vector"""
    @property
    def shard_key_selector(self) -> global___ShardKeySelector:
        """Specify in which shards to look for the points, if not specified - look in all shards"""
    def __init__(
        self,
        *,
        collection_name: builtins.str = ...,
        vector_name: builtins.str | None = ...,
        shard_key_selector: global___ShardKeySelector | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector", "_vector_name", b"_vector_name", "shard_key_selector", b"shard_key_selector", "vector_name", b"vector_name"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector", "_vector_name", b"_vector_name", "collection_name", b"collection_name", "shard_key_selector", b"shard_key_selector", "vector_name", b"vector_name"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector"]) -> typing_extensions.Literal["shard_key_selector"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_vector_name", b"_vector_name"]) -> typing_extensions.Literal["vector_name"] | None: ...

global___LookupLocation = LookupLocation

class RecommendPoints(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COLLECTION_NAME_FIELD_NUMBER: builtins.int
    POSITIVE_FIELD_NUMBER: builtins.int
    NEGATIVE_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    WITH_PAYLOAD_FIELD_NUMBER: builtins.int
    PARAMS_FIELD_NUMBER: builtins.int
    SCORE_THRESHOLD_FIELD_NUMBER: builtins.int
    OFFSET_FIELD_NUMBER: builtins.int
    USING_FIELD_NUMBER: builtins.int
    WITH_VECTORS_FIELD_NUMBER: builtins.int
    LOOKUP_FROM_FIELD_NUMBER: builtins.int
    READ_CONSISTENCY_FIELD_NUMBER: builtins.int
    STRATEGY_FIELD_NUMBER: builtins.int
    POSITIVE_VECTORS_FIELD_NUMBER: builtins.int
    NEGATIVE_VECTORS_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    SHARD_KEY_SELECTOR_FIELD_NUMBER: builtins.int
    collection_name: builtins.str
    """name of the collection"""
    @property
    def positive(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[qdrant_common_pb2.PointId]:
        """Look for vectors closest to the vectors from these points"""
    @property
    def negative(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[qdrant_common_pb2.PointId]:
        """Try to avoid vectors like the vector from these points"""
    @property
    def filter(self) -> qdrant_common_pb2.Filter:
        """Filter conditions - return only those points that satisfy the specified conditions"""
    limit: builtins.int
    """Max number of result"""
    @property
    def with_payload(self) -> global___WithPayloadSelector:
        """Options for specifying which payload to include or not"""
    @property
    def params(self) -> global___SearchParams:
        """Search config"""
    score_threshold: builtins.float
    """If provided - cut off results with worse scores"""
    offset: builtins.int
    """Offset of the result"""
    using: builtins.str
    """Define which vector to use for recommendation, if not specified - default vector"""
    @property
    def with_vectors(self) -> global___WithVectorsSelector:
        """Options for specifying which vectors to include into response"""
    @property
    def lookup_from(self) -> global___LookupLocation:
        """Name of the collection to use for points lookup, if not specified - use current collection"""
    @property
    def read_consistency(self) -> global___ReadConsistency:
        """Options for specifying read consistency guarantees"""
    strategy: global___RecommendStrategy.ValueType
    """How to use the example vectors to find the results"""
    @property
    def positive_vectors(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Vector]:
        """Look for vectors closest to those"""
    @property
    def negative_vectors(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Vector]:
        """Try to avoid vectors like this"""
    timeout: builtins.int
    """If set, overrides global timeout setting for this request. Unit is seconds."""
    @property
    def shard_key_selector(self) -> global___ShardKeySelector:
        """Specify in which shards to look for the points, if not specified - look in all shards"""
    def __init__(
        self,
        *,
        collection_name: builtins.str = ...,
        positive: collections.abc.Iterable[qdrant_common_pb2.PointId] | None = ...,
        negative: collections.abc.Iterable[qdrant_common_pb2.PointId] | None = ...,
        filter: qdrant_common_pb2.Filter | None = ...,
        limit: builtins.int = ...,
        with_payload: global___WithPayloadSelector | None = ...,
        params: global___SearchParams | None = ...,
        score_threshold: builtins.float | None = ...,
        offset: builtins.int | None = ...,
        using: builtins.str | None = ...,
        with_vectors: global___WithVectorsSelector | None = ...,
        lookup_from: global___LookupLocation | None = ...,
        read_consistency: global___ReadConsistency | None = ...,
        strategy: global___RecommendStrategy.ValueType | None = ...,
        positive_vectors: collections.abc.Iterable[global___Vector] | None = ...,
        negative_vectors: collections.abc.Iterable[global___Vector] | None = ...,
        timeout: builtins.int | None = ...,
        shard_key_selector: global___ShardKeySelector | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_lookup_from", b"_lookup_from", "_offset", b"_offset", "_read_consistency", b"_read_consistency", "_score_threshold", b"_score_threshold", "_shard_key_selector", b"_shard_key_selector", "_strategy", b"_strategy", "_timeout", b"_timeout", "_using", b"_using", "_with_vectors", b"_with_vectors", "filter", b"filter", "lookup_from", b"lookup_from", "offset", b"offset", "params", b"params", "read_consistency", b"read_consistency", "score_threshold", b"score_threshold", "shard_key_selector", b"shard_key_selector", "strategy", b"strategy", "timeout", b"timeout", "using", b"using", "with_payload", b"with_payload", "with_vectors", b"with_vectors"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_lookup_from", b"_lookup_from", "_offset", b"_offset", "_read_consistency", b"_read_consistency", "_score_threshold", b"_score_threshold", "_shard_key_selector", b"_shard_key_selector", "_strategy", b"_strategy", "_timeout", b"_timeout", "_using", b"_using", "_with_vectors", b"_with_vectors", "collection_name", b"collection_name", "filter", b"filter", "limit", b"limit", "lookup_from", b"lookup_from", "negative", b"negative", "negative_vectors", b"negative_vectors", "offset", b"offset", "params", b"params", "positive", b"positive", "positive_vectors", b"positive_vectors", "read_consistency", b"read_consistency", "score_threshold", b"score_threshold", "shard_key_selector", b"shard_key_selector", "strategy", b"strategy", "timeout", b"timeout", "using", b"using", "with_payload", b"with_payload", "with_vectors", b"with_vectors"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_lookup_from", b"_lookup_from"]) -> typing_extensions.Literal["lookup_from"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_offset", b"_offset"]) -> typing_extensions.Literal["offset"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_read_consistency", b"_read_consistency"]) -> typing_extensions.Literal["read_consistency"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_score_threshold", b"_score_threshold"]) -> typing_extensions.Literal["score_threshold"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector"]) -> typing_extensions.Literal["shard_key_selector"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_strategy", b"_strategy"]) -> typing_extensions.Literal["strategy"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_timeout", b"_timeout"]) -> typing_extensions.Literal["timeout"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_using", b"_using"]) -> typing_extensions.Literal["using"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_with_vectors", b"_with_vectors"]) -> typing_extensions.Literal["with_vectors"] | None: ...

global___RecommendPoints = RecommendPoints

class RecommendBatchPoints(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COLLECTION_NAME_FIELD_NUMBER: builtins.int
    RECOMMEND_POINTS_FIELD_NUMBER: builtins.int
    READ_CONSISTENCY_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    collection_name: builtins.str
    """Name of the collection"""
    @property
    def recommend_points(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RecommendPoints]: ...
    @property
    def read_consistency(self) -> global___ReadConsistency:
        """Options for specifying read consistency guarantees"""
    timeout: builtins.int
    """If set, overrides global timeout setting for this request. Unit is seconds."""
    def __init__(
        self,
        *,
        collection_name: builtins.str = ...,
        recommend_points: collections.abc.Iterable[global___RecommendPoints] | None = ...,
        read_consistency: global___ReadConsistency | None = ...,
        timeout: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_read_consistency", b"_read_consistency", "_timeout", b"_timeout", "read_consistency", b"read_consistency", "timeout", b"timeout"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_read_consistency", b"_read_consistency", "_timeout", b"_timeout", "collection_name", b"collection_name", "read_consistency", b"read_consistency", "recommend_points", b"recommend_points", "timeout", b"timeout"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_read_consistency", b"_read_consistency"]) -> typing_extensions.Literal["read_consistency"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_timeout", b"_timeout"]) -> typing_extensions.Literal["timeout"] | None: ...

global___RecommendBatchPoints = RecommendBatchPoints

class RecommendPointGroups(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COLLECTION_NAME_FIELD_NUMBER: builtins.int
    POSITIVE_FIELD_NUMBER: builtins.int
    NEGATIVE_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    WITH_PAYLOAD_FIELD_NUMBER: builtins.int
    PARAMS_FIELD_NUMBER: builtins.int
    SCORE_THRESHOLD_FIELD_NUMBER: builtins.int
    USING_FIELD_NUMBER: builtins.int
    WITH_VECTORS_FIELD_NUMBER: builtins.int
    LOOKUP_FROM_FIELD_NUMBER: builtins.int
    GROUP_BY_FIELD_NUMBER: builtins.int
    GROUP_SIZE_FIELD_NUMBER: builtins.int
    READ_CONSISTENCY_FIELD_NUMBER: builtins.int
    WITH_LOOKUP_FIELD_NUMBER: builtins.int
    STRATEGY_FIELD_NUMBER: builtins.int
    POSITIVE_VECTORS_FIELD_NUMBER: builtins.int
    NEGATIVE_VECTORS_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    SHARD_KEY_SELECTOR_FIELD_NUMBER: builtins.int
    collection_name: builtins.str
    """Name of the collection"""
    @property
    def positive(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[qdrant_common_pb2.PointId]:
        """Look for vectors closest to the vectors from these points"""
    @property
    def negative(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[qdrant_common_pb2.PointId]:
        """Try to avoid vectors like the vector from these points"""
    @property
    def filter(self) -> qdrant_common_pb2.Filter:
        """Filter conditions - return only those points that satisfy the specified conditions"""
    limit: builtins.int
    """Max number of groups in result"""
    @property
    def with_payload(self) -> global___WithPayloadSelector:
        """Options for specifying which payload to include or not"""
    @property
    def params(self) -> global___SearchParams:
        """Search config"""
    score_threshold: builtins.float
    """If provided - cut off results with worse scores"""
    using: builtins.str
    """Define which vector to use for recommendation, if not specified - default vector"""
    @property
    def with_vectors(self) -> global___WithVectorsSelector:
        """Options for specifying which vectors to include into response"""
    @property
    def lookup_from(self) -> global___LookupLocation:
        """Name of the collection to use for points lookup, if not specified - use current collection"""
    group_by: builtins.str
    """Payload field to group by, must be a string or number field. If there are multiple values for the field, all of them will be used. One point can be in multiple groups."""
    group_size: builtins.int
    """Maximum amount of points to return per group"""
    @property
    def read_consistency(self) -> global___ReadConsistency:
        """Options for specifying read consistency guarantees"""
    @property
    def with_lookup(self) -> global___WithLookup:
        """Options for specifying how to use the group id to lookup points in another collection"""
    strategy: global___RecommendStrategy.ValueType
    """How to use the example vectors to find the results"""
    @property
    def positive_vectors(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Vector]:
        """Look for vectors closest to those"""
    @property
    def negative_vectors(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Vector]:
        """Try to avoid vectors like this"""
    timeout: builtins.int
    """If set, overrides global timeout setting for this request. Unit is seconds."""
    @property
    def shard_key_selector(self) -> global___ShardKeySelector:
        """Specify in which shards to look for the points, if not specified - look in all shards"""
    def __init__(
        self,
        *,
        collection_name: builtins.str = ...,
        positive: collections.abc.Iterable[qdrant_common_pb2.PointId] | None = ...,
        negative: collections.abc.Iterable[qdrant_common_pb2.PointId] | None = ...,
        filter: qdrant_common_pb2.Filter | None = ...,
        limit: builtins.int = ...,
        with_payload: global___WithPayloadSelector | None = ...,
        params: global___SearchParams | None = ...,
        score_threshold: builtins.float | None = ...,
        using: builtins.str | None = ...,
        with_vectors: global___WithVectorsSelector | None = ...,
        lookup_from: global___LookupLocation | None = ...,
        group_by: builtins.str = ...,
        group_size: builtins.int = ...,
        read_consistency: global___ReadConsistency | None = ...,
        with_lookup: global___WithLookup | None = ...,
        strategy: global___RecommendStrategy.ValueType | None = ...,
        positive_vectors: collections.abc.Iterable[global___Vector] | None = ...,
        negative_vectors: collections.abc.Iterable[global___Vector] | None = ...,
        timeout: builtins.int | None = ...,
        shard_key_selector: global___ShardKeySelector | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_lookup_from", b"_lookup_from", "_read_consistency", b"_read_consistency", "_score_threshold", b"_score_threshold", "_shard_key_selector", b"_shard_key_selector", "_strategy", b"_strategy", "_timeout", b"_timeout", "_using", b"_using", "_with_lookup", b"_with_lookup", "_with_vectors", b"_with_vectors", "filter", b"filter", "lookup_from", b"lookup_from", "params", b"params", "read_consistency", b"read_consistency", "score_threshold", b"score_threshold", "shard_key_selector", b"shard_key_selector", "strategy", b"strategy", "timeout", b"timeout", "using", b"using", "with_lookup", b"with_lookup", "with_payload", b"with_payload", "with_vectors", b"with_vectors"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_lookup_from", b"_lookup_from", "_read_consistency", b"_read_consistency", "_score_threshold", b"_score_threshold", "_shard_key_selector", b"_shard_key_selector", "_strategy", b"_strategy", "_timeout", b"_timeout", "_using", b"_using", "_with_lookup", b"_with_lookup", "_with_vectors", b"_with_vectors", "collection_name", b"collection_name", "filter", b"filter", "group_by", b"group_by", "group_size", b"group_size", "limit", b"limit", "lookup_from", b"lookup_from", "negative", b"negative", "negative_vectors", b"negative_vectors", "params", b"params", "positive", b"positive", "positive_vectors", b"positive_vectors", "read_consistency", b"read_consistency", "score_threshold", b"score_threshold", "shard_key_selector", b"shard_key_selector", "strategy", b"strategy", "timeout", b"timeout", "using", b"using", "with_lookup", b"with_lookup", "with_payload", b"with_payload", "with_vectors", b"with_vectors"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_lookup_from", b"_lookup_from"]) -> typing_extensions.Literal["lookup_from"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_read_consistency", b"_read_consistency"]) -> typing_extensions.Literal["read_consistency"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_score_threshold", b"_score_threshold"]) -> typing_extensions.Literal["score_threshold"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector"]) -> typing_extensions.Literal["shard_key_selector"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_strategy", b"_strategy"]) -> typing_extensions.Literal["strategy"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_timeout", b"_timeout"]) -> typing_extensions.Literal["timeout"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_using", b"_using"]) -> typing_extensions.Literal["using"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_with_lookup", b"_with_lookup"]) -> typing_extensions.Literal["with_lookup"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_with_vectors", b"_with_vectors"]) -> typing_extensions.Literal["with_vectors"] | None: ...

global___RecommendPointGroups = RecommendPointGroups

class TargetVector(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SINGLE_FIELD_NUMBER: builtins.int
    @property
    def single(self) -> global___VectorExample: ...
    def __init__(
        self,
        *,
        single: global___VectorExample | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["single", b"single", "target", b"target"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["single", b"single", "target", b"target"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["target", b"target"]) -> typing_extensions.Literal["single"] | None: ...

global___TargetVector = TargetVector

class VectorExample(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    VECTOR_FIELD_NUMBER: builtins.int
    @property
    def id(self) -> qdrant_common_pb2.PointId: ...
    @property
    def vector(self) -> global___Vector: ...
    def __init__(
        self,
        *,
        id: qdrant_common_pb2.PointId | None = ...,
        vector: global___Vector | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["example", b"example", "id", b"id", "vector", b"vector"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["example", b"example", "id", b"id", "vector", b"vector"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["example", b"example"]) -> typing_extensions.Literal["id", "vector"] | None: ...

global___VectorExample = VectorExample

class ContextExamplePair(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POSITIVE_FIELD_NUMBER: builtins.int
    NEGATIVE_FIELD_NUMBER: builtins.int
    @property
    def positive(self) -> global___VectorExample: ...
    @property
    def negative(self) -> global___VectorExample: ...
    def __init__(
        self,
        *,
        positive: global___VectorExample | None = ...,
        negative: global___VectorExample | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["negative", b"negative", "positive", b"positive"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["negative", b"negative", "positive", b"positive"]) -> None: ...

global___ContextExamplePair = ContextExamplePair

class DiscoverPoints(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COLLECTION_NAME_FIELD_NUMBER: builtins.int
    TARGET_FIELD_NUMBER: builtins.int
    CONTEXT_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    WITH_PAYLOAD_FIELD_NUMBER: builtins.int
    PARAMS_FIELD_NUMBER: builtins.int
    OFFSET_FIELD_NUMBER: builtins.int
    USING_FIELD_NUMBER: builtins.int
    WITH_VECTORS_FIELD_NUMBER: builtins.int
    LOOKUP_FROM_FIELD_NUMBER: builtins.int
    READ_CONSISTENCY_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    SHARD_KEY_SELECTOR_FIELD_NUMBER: builtins.int
    collection_name: builtins.str
    """name of the collection"""
    @property
    def target(self) -> global___TargetVector:
        """Use this as the primary search objective"""
    @property
    def context(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ContextExamplePair]:
        """Search will be constrained by these pairs of examples"""
    @property
    def filter(self) -> qdrant_common_pb2.Filter:
        """Filter conditions - return only those points that satisfy the specified conditions"""
    limit: builtins.int
    """Max number of result"""
    @property
    def with_payload(self) -> global___WithPayloadSelector:
        """Options for specifying which payload to include or not"""
    @property
    def params(self) -> global___SearchParams:
        """Search config"""
    offset: builtins.int
    """Offset of the result"""
    using: builtins.str
    """Define which vector to use for recommendation, if not specified - default vector"""
    @property
    def with_vectors(self) -> global___WithVectorsSelector:
        """Options for specifying which vectors to include into response"""
    @property
    def lookup_from(self) -> global___LookupLocation:
        """Name of the collection to use for points lookup, if not specified - use current collection"""
    @property
    def read_consistency(self) -> global___ReadConsistency:
        """Options for specifying read consistency guarantees"""
    timeout: builtins.int
    """If set, overrides global timeout setting for this request. Unit is seconds."""
    @property
    def shard_key_selector(self) -> global___ShardKeySelector:
        """Specify in which shards to look for the points, if not specified - look in all shards"""
    def __init__(
        self,
        *,
        collection_name: builtins.str = ...,
        target: global___TargetVector | None = ...,
        context: collections.abc.Iterable[global___ContextExamplePair] | None = ...,
        filter: qdrant_common_pb2.Filter | None = ...,
        limit: builtins.int = ...,
        with_payload: global___WithPayloadSelector | None = ...,
        params: global___SearchParams | None = ...,
        offset: builtins.int | None = ...,
        using: builtins.str | None = ...,
        with_vectors: global___WithVectorsSelector | None = ...,
        lookup_from: global___LookupLocation | None = ...,
        read_consistency: global___ReadConsistency | None = ...,
        timeout: builtins.int | None = ...,
        shard_key_selector: global___ShardKeySelector | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_lookup_from", b"_lookup_from", "_offset", b"_offset", "_read_consistency", b"_read_consistency", "_shard_key_selector", b"_shard_key_selector", "_timeout", b"_timeout", "_using", b"_using", "_with_vectors", b"_with_vectors", "filter", b"filter", "lookup_from", b"lookup_from", "offset", b"offset", "params", b"params", "read_consistency", b"read_consistency", "shard_key_selector", b"shard_key_selector", "target", b"target", "timeout", b"timeout", "using", b"using", "with_payload", b"with_payload", "with_vectors", b"with_vectors"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_lookup_from", b"_lookup_from", "_offset", b"_offset", "_read_consistency", b"_read_consistency", "_shard_key_selector", b"_shard_key_selector", "_timeout", b"_timeout", "_using", b"_using", "_with_vectors", b"_with_vectors", "collection_name", b"collection_name", "context", b"context", "filter", b"filter", "limit", b"limit", "lookup_from", b"lookup_from", "offset", b"offset", "params", b"params", "read_consistency", b"read_consistency", "shard_key_selector", b"shard_key_selector", "target", b"target", "timeout", b"timeout", "using", b"using", "with_payload", b"with_payload", "with_vectors", b"with_vectors"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_lookup_from", b"_lookup_from"]) -> typing_extensions.Literal["lookup_from"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_offset", b"_offset"]) -> typing_extensions.Literal["offset"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_read_consistency", b"_read_consistency"]) -> typing_extensions.Literal["read_consistency"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector"]) -> typing_extensions.Literal["shard_key_selector"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_timeout", b"_timeout"]) -> typing_extensions.Literal["timeout"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_using", b"_using"]) -> typing_extensions.Literal["using"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_with_vectors", b"_with_vectors"]) -> typing_extensions.Literal["with_vectors"] | None: ...

global___DiscoverPoints = DiscoverPoints

class DiscoverBatchPoints(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COLLECTION_NAME_FIELD_NUMBER: builtins.int
    DISCOVER_POINTS_FIELD_NUMBER: builtins.int
    READ_CONSISTENCY_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    collection_name: builtins.str
    """Name of the collection"""
    @property
    def discover_points(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DiscoverPoints]: ...
    @property
    def read_consistency(self) -> global___ReadConsistency:
        """Options for specifying read consistency guarantees"""
    timeout: builtins.int
    """If set, overrides global timeout setting for this request. Unit is seconds."""
    def __init__(
        self,
        *,
        collection_name: builtins.str = ...,
        discover_points: collections.abc.Iterable[global___DiscoverPoints] | None = ...,
        read_consistency: global___ReadConsistency | None = ...,
        timeout: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_read_consistency", b"_read_consistency", "_timeout", b"_timeout", "read_consistency", b"read_consistency", "timeout", b"timeout"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_read_consistency", b"_read_consistency", "_timeout", b"_timeout", "collection_name", b"collection_name", "discover_points", b"discover_points", "read_consistency", b"read_consistency", "timeout", b"timeout"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_read_consistency", b"_read_consistency"]) -> typing_extensions.Literal["read_consistency"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_timeout", b"_timeout"]) -> typing_extensions.Literal["timeout"] | None: ...

global___DiscoverBatchPoints = DiscoverBatchPoints

class CountPoints(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COLLECTION_NAME_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    EXACT_FIELD_NUMBER: builtins.int
    READ_CONSISTENCY_FIELD_NUMBER: builtins.int
    SHARD_KEY_SELECTOR_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    collection_name: builtins.str
    """Name of the collection"""
    @property
    def filter(self) -> qdrant_common_pb2.Filter:
        """Filter conditions - return only those points that satisfy the specified conditions"""
    exact: builtins.bool
    """If `true` - return exact count, if `false` - return approximate count"""
    @property
    def read_consistency(self) -> global___ReadConsistency:
        """Options for specifying read consistency guarantees"""
    @property
    def shard_key_selector(self) -> global___ShardKeySelector:
        """Specify in which shards to look for the points, if not specified - look in all shards"""
    timeout: builtins.int
    """If set, overrides global timeout setting for this request. Unit is seconds."""
    def __init__(
        self,
        *,
        collection_name: builtins.str = ...,
        filter: qdrant_common_pb2.Filter | None = ...,
        exact: builtins.bool | None = ...,
        read_consistency: global___ReadConsistency | None = ...,
        shard_key_selector: global___ShardKeySelector | None = ...,
        timeout: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_exact", b"_exact", "_read_consistency", b"_read_consistency", "_shard_key_selector", b"_shard_key_selector", "_timeout", b"_timeout", "exact", b"exact", "filter", b"filter", "read_consistency", b"read_consistency", "shard_key_selector", b"shard_key_selector", "timeout", b"timeout"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_exact", b"_exact", "_read_consistency", b"_read_consistency", "_shard_key_selector", b"_shard_key_selector", "_timeout", b"_timeout", "collection_name", b"collection_name", "exact", b"exact", "filter", b"filter", "read_consistency", b"read_consistency", "shard_key_selector", b"shard_key_selector", "timeout", b"timeout"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_exact", b"_exact"]) -> typing_extensions.Literal["exact"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_read_consistency", b"_read_consistency"]) -> typing_extensions.Literal["read_consistency"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector"]) -> typing_extensions.Literal["shard_key_selector"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_timeout", b"_timeout"]) -> typing_extensions.Literal["timeout"] | None: ...

global___CountPoints = CountPoints

class RecommendInput(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POSITIVE_FIELD_NUMBER: builtins.int
    NEGATIVE_FIELD_NUMBER: builtins.int
    STRATEGY_FIELD_NUMBER: builtins.int
    @property
    def positive(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___VectorInput]:
        """Look for vectors closest to the vectors from these points"""
    @property
    def negative(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___VectorInput]:
        """Try to avoid vectors like the vector from these points"""
    strategy: global___RecommendStrategy.ValueType
    """How to use the provided vectors to find the results"""
    def __init__(
        self,
        *,
        positive: collections.abc.Iterable[global___VectorInput] | None = ...,
        negative: collections.abc.Iterable[global___VectorInput] | None = ...,
        strategy: global___RecommendStrategy.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_strategy", b"_strategy", "strategy", b"strategy"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_strategy", b"_strategy", "negative", b"negative", "positive", b"positive", "strategy", b"strategy"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_strategy", b"_strategy"]) -> typing_extensions.Literal["strategy"] | None: ...

global___RecommendInput = RecommendInput

class ContextInputPair(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POSITIVE_FIELD_NUMBER: builtins.int
    NEGATIVE_FIELD_NUMBER: builtins.int
    @property
    def positive(self) -> global___VectorInput:
        """A positive vector"""
    @property
    def negative(self) -> global___VectorInput:
        """Repel from this vector"""
    def __init__(
        self,
        *,
        positive: global___VectorInput | None = ...,
        negative: global___VectorInput | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["negative", b"negative", "positive", b"positive"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["negative", b"negative", "positive", b"positive"]) -> None: ...

global___ContextInputPair = ContextInputPair

class DiscoverInput(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TARGET_FIELD_NUMBER: builtins.int
    CONTEXT_FIELD_NUMBER: builtins.int
    @property
    def target(self) -> global___VectorInput:
        """Use this as the primary search objective"""
    @property
    def context(self) -> global___ContextInput:
        """Search space will be constrained by these pairs of vectors"""
    def __init__(
        self,
        *,
        target: global___VectorInput | None = ...,
        context: global___ContextInput | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["context", b"context", "target", b"target"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["context", b"context", "target", b"target"]) -> None: ...

global___DiscoverInput = DiscoverInput

class ContextInput(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAIRS_FIELD_NUMBER: builtins.int
    @property
    def pairs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ContextInputPair]:
        """Search space will be constrained by these pairs of vectors"""
    def __init__(
        self,
        *,
        pairs: collections.abc.Iterable[global___ContextInputPair] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["pairs", b"pairs"]) -> None: ...

global___ContextInput = ContextInput

class Formula(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class DefaultsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> json_with_int_pb2.Value: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: json_with_int_pb2.Value | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    EXPRESSION_FIELD_NUMBER: builtins.int
    DEFAULTS_FIELD_NUMBER: builtins.int
    @property
    def expression(self) -> global___Expression: ...
    @property
    def defaults(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, json_with_int_pb2.Value]: ...
    def __init__(
        self,
        *,
        expression: global___Expression | None = ...,
        defaults: collections.abc.Mapping[builtins.str, json_with_int_pb2.Value] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["expression", b"expression"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["defaults", b"defaults", "expression", b"expression"]) -> None: ...

global___Formula = Formula

class Expression(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONSTANT_FIELD_NUMBER: builtins.int
    VARIABLE_FIELD_NUMBER: builtins.int
    CONDITION_FIELD_NUMBER: builtins.int
    GEO_DISTANCE_FIELD_NUMBER: builtins.int
    DATETIME_FIELD_NUMBER: builtins.int
    DATETIME_KEY_FIELD_NUMBER: builtins.int
    MULT_FIELD_NUMBER: builtins.int
    SUM_FIELD_NUMBER: builtins.int
    DIV_FIELD_NUMBER: builtins.int
    NEG_FIELD_NUMBER: builtins.int
    ABS_FIELD_NUMBER: builtins.int
    SQRT_FIELD_NUMBER: builtins.int
    POW_FIELD_NUMBER: builtins.int
    EXP_FIELD_NUMBER: builtins.int
    LOG10_FIELD_NUMBER: builtins.int
    LN_FIELD_NUMBER: builtins.int
    EXP_DECAY_FIELD_NUMBER: builtins.int
    GAUSS_DECAY_FIELD_NUMBER: builtins.int
    LIN_DECAY_FIELD_NUMBER: builtins.int
    constant: builtins.float
    variable: builtins.str
    """Payload key or reference to score."""
    @property
    def condition(self) -> qdrant_common_pb2.Condition:
        """Payload condition. If true, becomes 1.0; otherwise 0.0"""
    @property
    def geo_distance(self) -> global___GeoDistance:
        """Geographic distance in meters"""
    datetime: builtins.str
    """Date-time constant"""
    datetime_key: builtins.str
    """Payload key with date-time values"""
    @property
    def mult(self) -> global___MultExpression:
        """Multiply"""
    @property
    def sum(self) -> global___SumExpression:
        """Sum"""
    @property
    def div(self) -> global___DivExpression:
        """Divide"""
    @property
    def neg(self) -> global___Expression:
        """Negate"""
    @property
    def abs(self) -> global___Expression:
        """Absolute value"""
    @property
    def sqrt(self) -> global___Expression:
        """Square root"""
    @property
    def pow(self) -> global___PowExpression:
        """Power"""
    @property
    def exp(self) -> global___Expression:
        """Exponential"""
    @property
    def log10(self) -> global___Expression:
        """Logarithm"""
    @property
    def ln(self) -> global___Expression:
        """Natural logarithm"""
    @property
    def exp_decay(self) -> global___DecayParamsExpression:
        """Exponential decay"""
    @property
    def gauss_decay(self) -> global___DecayParamsExpression:
        """Gaussian decay"""
    @property
    def lin_decay(self) -> global___DecayParamsExpression:
        """Linear decay"""
    def __init__(
        self,
        *,
        constant: builtins.float = ...,
        variable: builtins.str = ...,
        condition: qdrant_common_pb2.Condition | None = ...,
        geo_distance: global___GeoDistance | None = ...,
        datetime: builtins.str = ...,
        datetime_key: builtins.str = ...,
        mult: global___MultExpression | None = ...,
        sum: global___SumExpression | None = ...,
        div: global___DivExpression | None = ...,
        neg: global___Expression | None = ...,
        abs: global___Expression | None = ...,
        sqrt: global___Expression | None = ...,
        pow: global___PowExpression | None = ...,
        exp: global___Expression | None = ...,
        log10: global___Expression | None = ...,
        ln: global___Expression | None = ...,
        exp_decay: global___DecayParamsExpression | None = ...,
        gauss_decay: global___DecayParamsExpression | None = ...,
        lin_decay: global___DecayParamsExpression | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["abs", b"abs", "condition", b"condition", "constant", b"constant", "datetime", b"datetime", "datetime_key", b"datetime_key", "div", b"div", "exp", b"exp", "exp_decay", b"exp_decay", "gauss_decay", b"gauss_decay", "geo_distance", b"geo_distance", "lin_decay", b"lin_decay", "ln", b"ln", "log10", b"log10", "mult", b"mult", "neg", b"neg", "pow", b"pow", "sqrt", b"sqrt", "sum", b"sum", "variable", b"variable", "variant", b"variant"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["abs", b"abs", "condition", b"condition", "constant", b"constant", "datetime", b"datetime", "datetime_key", b"datetime_key", "div", b"div", "exp", b"exp", "exp_decay", b"exp_decay", "gauss_decay", b"gauss_decay", "geo_distance", b"geo_distance", "lin_decay", b"lin_decay", "ln", b"ln", "log10", b"log10", "mult", b"mult", "neg", b"neg", "pow", b"pow", "sqrt", b"sqrt", "sum", b"sum", "variable", b"variable", "variant", b"variant"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["variant", b"variant"]) -> typing_extensions.Literal["constant", "variable", "condition", "geo_distance", "datetime", "datetime_key", "mult", "sum", "div", "neg", "abs", "sqrt", "pow", "exp", "log10", "ln", "exp_decay", "gauss_decay", "lin_decay"] | None: ...

global___Expression = Expression

class GeoDistance(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORIGIN_FIELD_NUMBER: builtins.int
    TO_FIELD_NUMBER: builtins.int
    @property
    def origin(self) -> qdrant_common_pb2.GeoPoint: ...
    to: builtins.str
    def __init__(
        self,
        *,
        origin: qdrant_common_pb2.GeoPoint | None = ...,
        to: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["origin", b"origin"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["origin", b"origin", "to", b"to"]) -> None: ...

global___GeoDistance = GeoDistance

class MultExpression(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MULT_FIELD_NUMBER: builtins.int
    @property
    def mult(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Expression]: ...
    def __init__(
        self,
        *,
        mult: collections.abc.Iterable[global___Expression] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["mult", b"mult"]) -> None: ...

global___MultExpression = MultExpression

class SumExpression(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUM_FIELD_NUMBER: builtins.int
    @property
    def sum(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Expression]: ...
    def __init__(
        self,
        *,
        sum: collections.abc.Iterable[global___Expression] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["sum", b"sum"]) -> None: ...

global___SumExpression = SumExpression

class DivExpression(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LEFT_FIELD_NUMBER: builtins.int
    RIGHT_FIELD_NUMBER: builtins.int
    BY_ZERO_DEFAULT_FIELD_NUMBER: builtins.int
    @property
    def left(self) -> global___Expression: ...
    @property
    def right(self) -> global___Expression: ...
    by_zero_default: builtins.float
    def __init__(
        self,
        *,
        left: global___Expression | None = ...,
        right: global___Expression | None = ...,
        by_zero_default: builtins.float | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_by_zero_default", b"_by_zero_default", "by_zero_default", b"by_zero_default", "left", b"left", "right", b"right"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_by_zero_default", b"_by_zero_default", "by_zero_default", b"by_zero_default", "left", b"left", "right", b"right"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_by_zero_default", b"_by_zero_default"]) -> typing_extensions.Literal["by_zero_default"] | None: ...

global___DivExpression = DivExpression

class PowExpression(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BASE_FIELD_NUMBER: builtins.int
    EXPONENT_FIELD_NUMBER: builtins.int
    @property
    def base(self) -> global___Expression: ...
    @property
    def exponent(self) -> global___Expression: ...
    def __init__(
        self,
        *,
        base: global___Expression | None = ...,
        exponent: global___Expression | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["base", b"base", "exponent", b"exponent"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["base", b"base", "exponent", b"exponent"]) -> None: ...

global___PowExpression = PowExpression

class DecayParamsExpression(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    X_FIELD_NUMBER: builtins.int
    TARGET_FIELD_NUMBER: builtins.int
    SCALE_FIELD_NUMBER: builtins.int
    MIDPOINT_FIELD_NUMBER: builtins.int
    @property
    def x(self) -> global___Expression:
        """The variable to decay"""
    @property
    def target(self) -> global___Expression:
        """The target value to start decaying from. Defaults to 0."""
    scale: builtins.float
    """The scale factor of the decay, in terms of `x`. Defaults to 1.0. Must be a non-zero positive number."""
    midpoint: builtins.float
    """The midpoint of the decay. Should be between 0 and 1. Defaults to 0.5. Output will be this value when `|x - target| == scale`."""
    def __init__(
        self,
        *,
        x: global___Expression | None = ...,
        target: global___Expression | None = ...,
        scale: builtins.float | None = ...,
        midpoint: builtins.float | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_midpoint", b"_midpoint", "_scale", b"_scale", "_target", b"_target", "midpoint", b"midpoint", "scale", b"scale", "target", b"target", "x", b"x"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_midpoint", b"_midpoint", "_scale", b"_scale", "_target", b"_target", "midpoint", b"midpoint", "scale", b"scale", "target", b"target", "x", b"x"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_midpoint", b"_midpoint"]) -> typing_extensions.Literal["midpoint"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_scale", b"_scale"]) -> typing_extensions.Literal["scale"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_target", b"_target"]) -> typing_extensions.Literal["target"] | None: ...

global___DecayParamsExpression = DecayParamsExpression

class NearestInputWithMmr(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NEAREST_FIELD_NUMBER: builtins.int
    MMR_FIELD_NUMBER: builtins.int
    @property
    def nearest(self) -> global___VectorInput:
        """The vector to search for nearest neighbors."""
    @property
    def mmr(self) -> global___Mmr:
        """Perform MMR (Maximal Marginal Relevance) reranking after search,
        using the same vector in this query to calculate relevance.
        """
    def __init__(
        self,
        *,
        nearest: global___VectorInput | None = ...,
        mmr: global___Mmr | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["mmr", b"mmr", "nearest", b"nearest"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["mmr", b"mmr", "nearest", b"nearest"]) -> None: ...

global___NearestInputWithMmr = NearestInputWithMmr

class Mmr(google.protobuf.message.Message):
    """Maximal Marginal Relevance (MMR) algorithm for re-ranking the points."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DIVERSITY_FIELD_NUMBER: builtins.int
    CANDIDATES_LIMIT_FIELD_NUMBER: builtins.int
    diversity: builtins.float
    """Tunable parameter for the MMR algorithm.
    Determines the balance between diversity and relevance.

    A higher value favors diversity (dissimilarity to selected results),
    while a lower value favors relevance (similarity to the query vector).

    Must be in the range [0, 1].
    Default value is 0.5.
    """
    candidates_limit: builtins.int
    """The maximum number of candidates to consider for re-ranking.

    If not specified, the `limit` value is used.
    """
    def __init__(
        self,
        *,
        diversity: builtins.float | None = ...,
        candidates_limit: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_candidates_limit", b"_candidates_limit", "_diversity", b"_diversity", "candidates_limit", b"candidates_limit", "diversity", b"diversity"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_candidates_limit", b"_candidates_limit", "_diversity", b"_diversity", "candidates_limit", b"candidates_limit", "diversity", b"diversity"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_candidates_limit", b"_candidates_limit"]) -> typing_extensions.Literal["candidates_limit"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_diversity", b"_diversity"]) -> typing_extensions.Literal["diversity"] | None: ...

global___Mmr = Mmr

class Rrf(google.protobuf.message.Message):
    """Parameterized reciprocal rank fusion"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    K_FIELD_NUMBER: builtins.int
    k: builtins.int
    """K parameter for reciprocal rank fusion"""
    def __init__(
        self,
        *,
        k: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_k", b"_k", "k", b"k"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_k", b"_k", "k", b"k"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_k", b"_k"]) -> typing_extensions.Literal["k"] | None: ...

global___Rrf = Rrf

class Query(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NEAREST_FIELD_NUMBER: builtins.int
    RECOMMEND_FIELD_NUMBER: builtins.int
    DISCOVER_FIELD_NUMBER: builtins.int
    CONTEXT_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    FUSION_FIELD_NUMBER: builtins.int
    SAMPLE_FIELD_NUMBER: builtins.int
    FORMULA_FIELD_NUMBER: builtins.int
    NEAREST_WITH_MMR_FIELD_NUMBER: builtins.int
    RRF_FIELD_NUMBER: builtins.int
    @property
    def nearest(self) -> global___VectorInput:
        """Find the nearest neighbors to this vector."""
    @property
    def recommend(self) -> global___RecommendInput:
        """Use multiple positive and negative vectors to find the results."""
    @property
    def discover(self) -> global___DiscoverInput:
        """Search for nearest points, but constrain the search space with context"""
    @property
    def context(self) -> global___ContextInput:
        """Return points that live in positive areas."""
    @property
    def order_by(self) -> global___OrderBy:
        """Order the points by a payload field."""
    fusion: global___Fusion.ValueType
    """Fuse the results of multiple prefetches."""
    sample: global___Sample.ValueType
    """Sample points from the collection."""
    @property
    def formula(self) -> global___Formula:
        """Score boosting via an arbitrary formula"""
    @property
    def nearest_with_mmr(self) -> global___NearestInputWithMmr:
        """Search nearest neighbors, but re-rank based on the Maximal Marginal Relevance algorithm."""
    @property
    def rrf(self) -> global___Rrf:
        """Parameterized reciprocal rank fusion"""
    def __init__(
        self,
        *,
        nearest: global___VectorInput | None = ...,
        recommend: global___RecommendInput | None = ...,
        discover: global___DiscoverInput | None = ...,
        context: global___ContextInput | None = ...,
        order_by: global___OrderBy | None = ...,
        fusion: global___Fusion.ValueType = ...,
        sample: global___Sample.ValueType = ...,
        formula: global___Formula | None = ...,
        nearest_with_mmr: global___NearestInputWithMmr | None = ...,
        rrf: global___Rrf | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["context", b"context", "discover", b"discover", "formula", b"formula", "fusion", b"fusion", "nearest", b"nearest", "nearest_with_mmr", b"nearest_with_mmr", "order_by", b"order_by", "recommend", b"recommend", "rrf", b"rrf", "sample", b"sample", "variant", b"variant"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["context", b"context", "discover", b"discover", "formula", b"formula", "fusion", b"fusion", "nearest", b"nearest", "nearest_with_mmr", b"nearest_with_mmr", "order_by", b"order_by", "recommend", b"recommend", "rrf", b"rrf", "sample", b"sample", "variant", b"variant"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["variant", b"variant"]) -> typing_extensions.Literal["nearest", "recommend", "discover", "context", "order_by", "fusion", "sample", "formula", "nearest_with_mmr", "rrf"] | None: ...

global___Query = Query

class PrefetchQuery(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PREFETCH_FIELD_NUMBER: builtins.int
    QUERY_FIELD_NUMBER: builtins.int
    USING_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    PARAMS_FIELD_NUMBER: builtins.int
    SCORE_THRESHOLD_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    LOOKUP_FROM_FIELD_NUMBER: builtins.int
    @property
    def prefetch(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PrefetchQuery]:
        """Sub-requests to perform first. If present, the query will be performed on the results of the prefetches."""
    @property
    def query(self) -> global___Query:
        """Query to perform. If missing, returns points ordered by their IDs."""
    using: builtins.str
    """Define which vector to use for querying. If missing, the default vector is is used."""
    @property
    def filter(self) -> qdrant_common_pb2.Filter:
        """Filter conditions - return only those points that satisfy the specified conditions."""
    @property
    def params(self) -> global___SearchParams:
        """Search params for when there is no prefetch."""
    score_threshold: builtins.float
    """Return points with scores better than this threshold."""
    limit: builtins.int
    """Max number of points. Default is 10"""
    @property
    def lookup_from(self) -> global___LookupLocation:
        """The location to use for IDs lookup, if not specified - use the current collection and the 'using' vector"""
    def __init__(
        self,
        *,
        prefetch: collections.abc.Iterable[global___PrefetchQuery] | None = ...,
        query: global___Query | None = ...,
        using: builtins.str | None = ...,
        filter: qdrant_common_pb2.Filter | None = ...,
        params: global___SearchParams | None = ...,
        score_threshold: builtins.float | None = ...,
        limit: builtins.int | None = ...,
        lookup_from: global___LookupLocation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_limit", b"_limit", "_lookup_from", b"_lookup_from", "_params", b"_params", "_query", b"_query", "_score_threshold", b"_score_threshold", "_using", b"_using", "filter", b"filter", "limit", b"limit", "lookup_from", b"lookup_from", "params", b"params", "query", b"query", "score_threshold", b"score_threshold", "using", b"using"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_limit", b"_limit", "_lookup_from", b"_lookup_from", "_params", b"_params", "_query", b"_query", "_score_threshold", b"_score_threshold", "_using", b"_using", "filter", b"filter", "limit", b"limit", "lookup_from", b"lookup_from", "params", b"params", "prefetch", b"prefetch", "query", b"query", "score_threshold", b"score_threshold", "using", b"using"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_limit", b"_limit"]) -> typing_extensions.Literal["limit"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_lookup_from", b"_lookup_from"]) -> typing_extensions.Literal["lookup_from"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_params", b"_params"]) -> typing_extensions.Literal["params"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_query", b"_query"]) -> typing_extensions.Literal["query"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_score_threshold", b"_score_threshold"]) -> typing_extensions.Literal["score_threshold"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_using", b"_using"]) -> typing_extensions.Literal["using"] | None: ...

global___PrefetchQuery = PrefetchQuery

class QueryPoints(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COLLECTION_NAME_FIELD_NUMBER: builtins.int
    PREFETCH_FIELD_NUMBER: builtins.int
    QUERY_FIELD_NUMBER: builtins.int
    USING_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    PARAMS_FIELD_NUMBER: builtins.int
    SCORE_THRESHOLD_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    OFFSET_FIELD_NUMBER: builtins.int
    WITH_VECTORS_FIELD_NUMBER: builtins.int
    WITH_PAYLOAD_FIELD_NUMBER: builtins.int
    READ_CONSISTENCY_FIELD_NUMBER: builtins.int
    SHARD_KEY_SELECTOR_FIELD_NUMBER: builtins.int
    LOOKUP_FROM_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    collection_name: builtins.str
    """Name of the collection"""
    @property
    def prefetch(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PrefetchQuery]:
        """Sub-requests to perform first. If present, the query will be performed on the results of the prefetches."""
    @property
    def query(self) -> global___Query:
        """Query to perform. If missing, returns points ordered by their IDs."""
    using: builtins.str
    """Define which vector to use for querying. If missing, the default vector is used."""
    @property
    def filter(self) -> qdrant_common_pb2.Filter:
        """Filter conditions - return only those points that satisfy the specified conditions."""
    @property
    def params(self) -> global___SearchParams:
        """Search params for when there is no prefetch."""
    score_threshold: builtins.float
    """Return points with scores better than this threshold."""
    limit: builtins.int
    """Max number of points. Default is 10."""
    offset: builtins.int
    """Offset of the result. Skip this many points. Default is 0."""
    @property
    def with_vectors(self) -> global___WithVectorsSelector:
        """Options for specifying which vectors to include into the response."""
    @property
    def with_payload(self) -> global___WithPayloadSelector:
        """Options for specifying which payload to include or not."""
    @property
    def read_consistency(self) -> global___ReadConsistency:
        """Options for specifying read consistency guarantees."""
    @property
    def shard_key_selector(self) -> global___ShardKeySelector:
        """Specify in which shards to look for the points, if not specified - look in all shards."""
    @property
    def lookup_from(self) -> global___LookupLocation:
        """The location to use for IDs lookup, if not specified - use the current collection and the 'using' vector"""
    timeout: builtins.int
    """If set, overrides global timeout setting for this request. Unit is seconds."""
    def __init__(
        self,
        *,
        collection_name: builtins.str = ...,
        prefetch: collections.abc.Iterable[global___PrefetchQuery] | None = ...,
        query: global___Query | None = ...,
        using: builtins.str | None = ...,
        filter: qdrant_common_pb2.Filter | None = ...,
        params: global___SearchParams | None = ...,
        score_threshold: builtins.float | None = ...,
        limit: builtins.int | None = ...,
        offset: builtins.int | None = ...,
        with_vectors: global___WithVectorsSelector | None = ...,
        with_payload: global___WithPayloadSelector | None = ...,
        read_consistency: global___ReadConsistency | None = ...,
        shard_key_selector: global___ShardKeySelector | None = ...,
        lookup_from: global___LookupLocation | None = ...,
        timeout: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_limit", b"_limit", "_lookup_from", b"_lookup_from", "_offset", b"_offset", "_params", b"_params", "_query", b"_query", "_read_consistency", b"_read_consistency", "_score_threshold", b"_score_threshold", "_shard_key_selector", b"_shard_key_selector", "_timeout", b"_timeout", "_using", b"_using", "_with_payload", b"_with_payload", "_with_vectors", b"_with_vectors", "filter", b"filter", "limit", b"limit", "lookup_from", b"lookup_from", "offset", b"offset", "params", b"params", "query", b"query", "read_consistency", b"read_consistency", "score_threshold", b"score_threshold", "shard_key_selector", b"shard_key_selector", "timeout", b"timeout", "using", b"using", "with_payload", b"with_payload", "with_vectors", b"with_vectors"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_limit", b"_limit", "_lookup_from", b"_lookup_from", "_offset", b"_offset", "_params", b"_params", "_query", b"_query", "_read_consistency", b"_read_consistency", "_score_threshold", b"_score_threshold", "_shard_key_selector", b"_shard_key_selector", "_timeout", b"_timeout", "_using", b"_using", "_with_payload", b"_with_payload", "_with_vectors", b"_with_vectors", "collection_name", b"collection_name", "filter", b"filter", "limit", b"limit", "lookup_from", b"lookup_from", "offset", b"offset", "params", b"params", "prefetch", b"prefetch", "query", b"query", "read_consistency", b"read_consistency", "score_threshold", b"score_threshold", "shard_key_selector", b"shard_key_selector", "timeout", b"timeout", "using", b"using", "with_payload", b"with_payload", "with_vectors", b"with_vectors"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_limit", b"_limit"]) -> typing_extensions.Literal["limit"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_lookup_from", b"_lookup_from"]) -> typing_extensions.Literal["lookup_from"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_offset", b"_offset"]) -> typing_extensions.Literal["offset"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_params", b"_params"]) -> typing_extensions.Literal["params"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_query", b"_query"]) -> typing_extensions.Literal["query"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_read_consistency", b"_read_consistency"]) -> typing_extensions.Literal["read_consistency"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_score_threshold", b"_score_threshold"]) -> typing_extensions.Literal["score_threshold"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector"]) -> typing_extensions.Literal["shard_key_selector"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_timeout", b"_timeout"]) -> typing_extensions.Literal["timeout"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_using", b"_using"]) -> typing_extensions.Literal["using"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_with_payload", b"_with_payload"]) -> typing_extensions.Literal["with_payload"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_with_vectors", b"_with_vectors"]) -> typing_extensions.Literal["with_vectors"] | None: ...

global___QueryPoints = QueryPoints

class QueryBatchPoints(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COLLECTION_NAME_FIELD_NUMBER: builtins.int
    QUERY_POINTS_FIELD_NUMBER: builtins.int
    READ_CONSISTENCY_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    collection_name: builtins.str
    @property
    def query_points(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___QueryPoints]: ...
    @property
    def read_consistency(self) -> global___ReadConsistency:
        """Options for specifying read consistency guarantees"""
    timeout: builtins.int
    """If set, overrides global timeout setting for this request. Unit is seconds."""
    def __init__(
        self,
        *,
        collection_name: builtins.str = ...,
        query_points: collections.abc.Iterable[global___QueryPoints] | None = ...,
        read_consistency: global___ReadConsistency | None = ...,
        timeout: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_read_consistency", b"_read_consistency", "_timeout", b"_timeout", "read_consistency", b"read_consistency", "timeout", b"timeout"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_read_consistency", b"_read_consistency", "_timeout", b"_timeout", "collection_name", b"collection_name", "query_points", b"query_points", "read_consistency", b"read_consistency", "timeout", b"timeout"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_read_consistency", b"_read_consistency"]) -> typing_extensions.Literal["read_consistency"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_timeout", b"_timeout"]) -> typing_extensions.Literal["timeout"] | None: ...

global___QueryBatchPoints = QueryBatchPoints

class QueryPointGroups(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COLLECTION_NAME_FIELD_NUMBER: builtins.int
    PREFETCH_FIELD_NUMBER: builtins.int
    QUERY_FIELD_NUMBER: builtins.int
    USING_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    PARAMS_FIELD_NUMBER: builtins.int
    SCORE_THRESHOLD_FIELD_NUMBER: builtins.int
    WITH_PAYLOAD_FIELD_NUMBER: builtins.int
    WITH_VECTORS_FIELD_NUMBER: builtins.int
    LOOKUP_FROM_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    GROUP_SIZE_FIELD_NUMBER: builtins.int
    GROUP_BY_FIELD_NUMBER: builtins.int
    READ_CONSISTENCY_FIELD_NUMBER: builtins.int
    WITH_LOOKUP_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    SHARD_KEY_SELECTOR_FIELD_NUMBER: builtins.int
    collection_name: builtins.str
    """Name of the collection"""
    @property
    def prefetch(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PrefetchQuery]:
        """Sub-requests to perform first. If present, the query will be performed on the results of the prefetches."""
    @property
    def query(self) -> global___Query:
        """Query to perform. If missing, returns points ordered by their IDs."""
    using: builtins.str
    """Define which vector to use for querying. If missing, the default vector is used."""
    @property
    def filter(self) -> qdrant_common_pb2.Filter:
        """Filter conditions - return only those points that satisfy the specified conditions."""
    @property
    def params(self) -> global___SearchParams:
        """Search params for when there is no prefetch."""
    score_threshold: builtins.float
    """Return points with scores better than this threshold."""
    @property
    def with_payload(self) -> global___WithPayloadSelector:
        """Options for specifying which payload to include or not"""
    @property
    def with_vectors(self) -> global___WithVectorsSelector:
        """Options for specifying which vectors to include into response"""
    @property
    def lookup_from(self) -> global___LookupLocation:
        """The location to use for IDs lookup, if not specified - use the current collection and the 'using' vector"""
    limit: builtins.int
    """Max number of points. Default is 3."""
    group_size: builtins.int
    """Maximum amount of points to return per group. Default to 10."""
    group_by: builtins.str
    """Payload field to group by, must be a string or number field. If there are multiple values for the field, all of them will be used. One point can be in multiple groups."""
    @property
    def read_consistency(self) -> global___ReadConsistency:
        """Options for specifying read consistency guarantees"""
    @property
    def with_lookup(self) -> global___WithLookup:
        """Options for specifying how to use the group id to lookup points in another collection"""
    timeout: builtins.int
    """If set, overrides global timeout setting for this request. Unit is seconds."""
    @property
    def shard_key_selector(self) -> global___ShardKeySelector:
        """Specify in which shards to look for the points, if not specified - look in all shards"""
    def __init__(
        self,
        *,
        collection_name: builtins.str = ...,
        prefetch: collections.abc.Iterable[global___PrefetchQuery] | None = ...,
        query: global___Query | None = ...,
        using: builtins.str | None = ...,
        filter: qdrant_common_pb2.Filter | None = ...,
        params: global___SearchParams | None = ...,
        score_threshold: builtins.float | None = ...,
        with_payload: global___WithPayloadSelector | None = ...,
        with_vectors: global___WithVectorsSelector | None = ...,
        lookup_from: global___LookupLocation | None = ...,
        limit: builtins.int | None = ...,
        group_size: builtins.int | None = ...,
        group_by: builtins.str = ...,
        read_consistency: global___ReadConsistency | None = ...,
        with_lookup: global___WithLookup | None = ...,
        timeout: builtins.int | None = ...,
        shard_key_selector: global___ShardKeySelector | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_group_size", b"_group_size", "_limit", b"_limit", "_lookup_from", b"_lookup_from", "_params", b"_params", "_query", b"_query", "_read_consistency", b"_read_consistency", "_score_threshold", b"_score_threshold", "_shard_key_selector", b"_shard_key_selector", "_timeout", b"_timeout", "_using", b"_using", "_with_lookup", b"_with_lookup", "_with_vectors", b"_with_vectors", "filter", b"filter", "group_size", b"group_size", "limit", b"limit", "lookup_from", b"lookup_from", "params", b"params", "query", b"query", "read_consistency", b"read_consistency", "score_threshold", b"score_threshold", "shard_key_selector", b"shard_key_selector", "timeout", b"timeout", "using", b"using", "with_lookup", b"with_lookup", "with_payload", b"with_payload", "with_vectors", b"with_vectors"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_group_size", b"_group_size", "_limit", b"_limit", "_lookup_from", b"_lookup_from", "_params", b"_params", "_query", b"_query", "_read_consistency", b"_read_consistency", "_score_threshold", b"_score_threshold", "_shard_key_selector", b"_shard_key_selector", "_timeout", b"_timeout", "_using", b"_using", "_with_lookup", b"_with_lookup", "_with_vectors", b"_with_vectors", "collection_name", b"collection_name", "filter", b"filter", "group_by", b"group_by", "group_size", b"group_size", "limit", b"limit", "lookup_from", b"lookup_from", "params", b"params", "prefetch", b"prefetch", "query", b"query", "read_consistency", b"read_consistency", "score_threshold", b"score_threshold", "shard_key_selector", b"shard_key_selector", "timeout", b"timeout", "using", b"using", "with_lookup", b"with_lookup", "with_payload", b"with_payload", "with_vectors", b"with_vectors"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_group_size", b"_group_size"]) -> typing_extensions.Literal["group_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_limit", b"_limit"]) -> typing_extensions.Literal["limit"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_lookup_from", b"_lookup_from"]) -> typing_extensions.Literal["lookup_from"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_params", b"_params"]) -> typing_extensions.Literal["params"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_query", b"_query"]) -> typing_extensions.Literal["query"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_read_consistency", b"_read_consistency"]) -> typing_extensions.Literal["read_consistency"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_score_threshold", b"_score_threshold"]) -> typing_extensions.Literal["score_threshold"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector"]) -> typing_extensions.Literal["shard_key_selector"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_timeout", b"_timeout"]) -> typing_extensions.Literal["timeout"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_using", b"_using"]) -> typing_extensions.Literal["using"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_with_lookup", b"_with_lookup"]) -> typing_extensions.Literal["with_lookup"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_with_vectors", b"_with_vectors"]) -> typing_extensions.Literal["with_vectors"] | None: ...

global___QueryPointGroups = QueryPointGroups

class FacetCounts(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COLLECTION_NAME_FIELD_NUMBER: builtins.int
    KEY_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    EXACT_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    READ_CONSISTENCY_FIELD_NUMBER: builtins.int
    SHARD_KEY_SELECTOR_FIELD_NUMBER: builtins.int
    collection_name: builtins.str
    """Name of the collection"""
    key: builtins.str
    """Payload key of the facet"""
    @property
    def filter(self) -> qdrant_common_pb2.Filter:
        """Filter conditions - return only those points that satisfy the specified conditions."""
    limit: builtins.int
    """Max number of facets. Default is 10."""
    exact: builtins.bool
    """If true, return exact counts, slower but useful for debugging purposes. Default is false."""
    timeout: builtins.int
    """If set, overrides global timeout setting for this request. Unit is seconds."""
    @property
    def read_consistency(self) -> global___ReadConsistency:
        """Options for specifying read consistency guarantees"""
    @property
    def shard_key_selector(self) -> global___ShardKeySelector:
        """Specify in which shards to look for the points, if not specified - look in all shards"""
    def __init__(
        self,
        *,
        collection_name: builtins.str = ...,
        key: builtins.str = ...,
        filter: qdrant_common_pb2.Filter | None = ...,
        limit: builtins.int | None = ...,
        exact: builtins.bool | None = ...,
        timeout: builtins.int | None = ...,
        read_consistency: global___ReadConsistency | None = ...,
        shard_key_selector: global___ShardKeySelector | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_exact", b"_exact", "_filter", b"_filter", "_limit", b"_limit", "_read_consistency", b"_read_consistency", "_shard_key_selector", b"_shard_key_selector", "_timeout", b"_timeout", "exact", b"exact", "filter", b"filter", "limit", b"limit", "read_consistency", b"read_consistency", "shard_key_selector", b"shard_key_selector", "timeout", b"timeout"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_exact", b"_exact", "_filter", b"_filter", "_limit", b"_limit", "_read_consistency", b"_read_consistency", "_shard_key_selector", b"_shard_key_selector", "_timeout", b"_timeout", "collection_name", b"collection_name", "exact", b"exact", "filter", b"filter", "key", b"key", "limit", b"limit", "read_consistency", b"read_consistency", "shard_key_selector", b"shard_key_selector", "timeout", b"timeout"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_exact", b"_exact"]) -> typing_extensions.Literal["exact"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_limit", b"_limit"]) -> typing_extensions.Literal["limit"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_read_consistency", b"_read_consistency"]) -> typing_extensions.Literal["read_consistency"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector"]) -> typing_extensions.Literal["shard_key_selector"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_timeout", b"_timeout"]) -> typing_extensions.Literal["timeout"] | None: ...

global___FacetCounts = FacetCounts

class FacetValue(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STRING_VALUE_FIELD_NUMBER: builtins.int
    INTEGER_VALUE_FIELD_NUMBER: builtins.int
    BOOL_VALUE_FIELD_NUMBER: builtins.int
    string_value: builtins.str
    """String value from the facet"""
    integer_value: builtins.int
    """Integer value from the facet"""
    bool_value: builtins.bool
    """Boolean value from the facet"""
    def __init__(
        self,
        *,
        string_value: builtins.str = ...,
        integer_value: builtins.int = ...,
        bool_value: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["bool_value", b"bool_value", "integer_value", b"integer_value", "string_value", b"string_value", "variant", b"variant"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["bool_value", b"bool_value", "integer_value", b"integer_value", "string_value", b"string_value", "variant", b"variant"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["variant", b"variant"]) -> typing_extensions.Literal["string_value", "integer_value", "bool_value"] | None: ...

global___FacetValue = FacetValue

class FacetHit(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALUE_FIELD_NUMBER: builtins.int
    COUNT_FIELD_NUMBER: builtins.int
    @property
    def value(self) -> global___FacetValue:
        """Value from the facet"""
    count: builtins.int
    """Number of points with this value"""
    def __init__(
        self,
        *,
        value: global___FacetValue | None = ...,
        count: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["count", b"count", "value", b"value"]) -> None: ...

global___FacetHit = FacetHit

class SearchMatrixPoints(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COLLECTION_NAME_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    SAMPLE_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    USING_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    READ_CONSISTENCY_FIELD_NUMBER: builtins.int
    SHARD_KEY_SELECTOR_FIELD_NUMBER: builtins.int
    collection_name: builtins.str
    """Name of the collection"""
    @property
    def filter(self) -> qdrant_common_pb2.Filter:
        """Filter conditions - return only those points that satisfy the specified conditions."""
    sample: builtins.int
    """How many points to select and search within. Default is 10."""
    limit: builtins.int
    """How many neighbours per sample to find. Default is 3."""
    using: builtins.str
    """Define which vector to use for querying. If missing, the default vector is is used."""
    timeout: builtins.int
    """If set, overrides global timeout setting for this request. Unit is seconds."""
    @property
    def read_consistency(self) -> global___ReadConsistency:
        """Options for specifying read consistency guarantees"""
    @property
    def shard_key_selector(self) -> global___ShardKeySelector:
        """Specify in which shards to look for the points, if not specified - look in all shards"""
    def __init__(
        self,
        *,
        collection_name: builtins.str = ...,
        filter: qdrant_common_pb2.Filter | None = ...,
        sample: builtins.int | None = ...,
        limit: builtins.int | None = ...,
        using: builtins.str | None = ...,
        timeout: builtins.int | None = ...,
        read_consistency: global___ReadConsistency | None = ...,
        shard_key_selector: global___ShardKeySelector | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_limit", b"_limit", "_read_consistency", b"_read_consistency", "_sample", b"_sample", "_shard_key_selector", b"_shard_key_selector", "_timeout", b"_timeout", "_using", b"_using", "filter", b"filter", "limit", b"limit", "read_consistency", b"read_consistency", "sample", b"sample", "shard_key_selector", b"shard_key_selector", "timeout", b"timeout", "using", b"using"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_limit", b"_limit", "_read_consistency", b"_read_consistency", "_sample", b"_sample", "_shard_key_selector", b"_shard_key_selector", "_timeout", b"_timeout", "_using", b"_using", "collection_name", b"collection_name", "filter", b"filter", "limit", b"limit", "read_consistency", b"read_consistency", "sample", b"sample", "shard_key_selector", b"shard_key_selector", "timeout", b"timeout", "using", b"using"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_limit", b"_limit"]) -> typing_extensions.Literal["limit"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_read_consistency", b"_read_consistency"]) -> typing_extensions.Literal["read_consistency"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_sample", b"_sample"]) -> typing_extensions.Literal["sample"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector"]) -> typing_extensions.Literal["shard_key_selector"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_timeout", b"_timeout"]) -> typing_extensions.Literal["timeout"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_using", b"_using"]) -> typing_extensions.Literal["using"] | None: ...

global___SearchMatrixPoints = SearchMatrixPoints

class SearchMatrixPairs(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAIRS_FIELD_NUMBER: builtins.int
    @property
    def pairs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SearchMatrixPair]:
        """List of pairs of points with scores"""
    def __init__(
        self,
        *,
        pairs: collections.abc.Iterable[global___SearchMatrixPair] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["pairs", b"pairs"]) -> None: ...

global___SearchMatrixPairs = SearchMatrixPairs

class SearchMatrixPair(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    A_FIELD_NUMBER: builtins.int
    B_FIELD_NUMBER: builtins.int
    SCORE_FIELD_NUMBER: builtins.int
    @property
    def a(self) -> qdrant_common_pb2.PointId:
        """first id of the pair"""
    @property
    def b(self) -> qdrant_common_pb2.PointId:
        """second id of the pair"""
    score: builtins.float
    """score of the pair"""
    def __init__(
        self,
        *,
        a: qdrant_common_pb2.PointId | None = ...,
        b: qdrant_common_pb2.PointId | None = ...,
        score: builtins.float = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["a", b"a", "b", b"b"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["a", b"a", "b", b"b", "score", b"score"]) -> None: ...

global___SearchMatrixPair = SearchMatrixPair

class SearchMatrixOffsets(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OFFSETS_ROW_FIELD_NUMBER: builtins.int
    OFFSETS_COL_FIELD_NUMBER: builtins.int
    SCORES_FIELD_NUMBER: builtins.int
    IDS_FIELD_NUMBER: builtins.int
    @property
    def offsets_row(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Row indices of the matrix"""
    @property
    def offsets_col(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Column indices of the matrix"""
    @property
    def scores(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
        """Scores associated with matrix coordinates"""
    @property
    def ids(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[qdrant_common_pb2.PointId]:
        """Ids of the points in order"""
    def __init__(
        self,
        *,
        offsets_row: collections.abc.Iterable[builtins.int] | None = ...,
        offsets_col: collections.abc.Iterable[builtins.int] | None = ...,
        scores: collections.abc.Iterable[builtins.float] | None = ...,
        ids: collections.abc.Iterable[qdrant_common_pb2.PointId] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["ids", b"ids", "offsets_col", b"offsets_col", "offsets_row", b"offsets_row", "scores", b"scores"]) -> None: ...

global___SearchMatrixOffsets = SearchMatrixOffsets

class PointsUpdateOperation(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class PointStructList(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        POINTS_FIELD_NUMBER: builtins.int
        SHARD_KEY_SELECTOR_FIELD_NUMBER: builtins.int
        UPDATE_FILTER_FIELD_NUMBER: builtins.int
        @property
        def points(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PointStruct]: ...
        @property
        def shard_key_selector(self) -> global___ShardKeySelector:
            """Option for custom sharding to specify used shard keys"""
        @property
        def update_filter(self) -> qdrant_common_pb2.Filter:
            """If specified, only points that match this filter will be updated, others will be inserted"""
        def __init__(
            self,
            *,
            points: collections.abc.Iterable[global___PointStruct] | None = ...,
            shard_key_selector: global___ShardKeySelector | None = ...,
            update_filter: qdrant_common_pb2.Filter | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector", "_update_filter", b"_update_filter", "shard_key_selector", b"shard_key_selector", "update_filter", b"update_filter"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector", "_update_filter", b"_update_filter", "points", b"points", "shard_key_selector", b"shard_key_selector", "update_filter", b"update_filter"]) -> None: ...
        @typing.overload
        def WhichOneof(self, oneof_group: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector"]) -> typing_extensions.Literal["shard_key_selector"] | None: ...
        @typing.overload
        def WhichOneof(self, oneof_group: typing_extensions.Literal["_update_filter", b"_update_filter"]) -> typing_extensions.Literal["update_filter"] | None: ...

    class SetPayload(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class PayloadEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: builtins.str
            @property
            def value(self) -> json_with_int_pb2.Value: ...
            def __init__(
                self,
                *,
                key: builtins.str = ...,
                value: json_with_int_pb2.Value | None = ...,
            ) -> None: ...
            def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

        PAYLOAD_FIELD_NUMBER: builtins.int
        POINTS_SELECTOR_FIELD_NUMBER: builtins.int
        SHARD_KEY_SELECTOR_FIELD_NUMBER: builtins.int
        KEY_FIELD_NUMBER: builtins.int
        @property
        def payload(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, json_with_int_pb2.Value]: ...
        @property
        def points_selector(self) -> global___PointsSelector:
            """Affected points"""
        @property
        def shard_key_selector(self) -> global___ShardKeySelector:
            """Option for custom sharding to specify used shard keys"""
        key: builtins.str
        """Option for indicate property of payload"""
        def __init__(
            self,
            *,
            payload: collections.abc.Mapping[builtins.str, json_with_int_pb2.Value] | None = ...,
            points_selector: global___PointsSelector | None = ...,
            shard_key_selector: global___ShardKeySelector | None = ...,
            key: builtins.str | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["_key", b"_key", "_points_selector", b"_points_selector", "_shard_key_selector", b"_shard_key_selector", "key", b"key", "points_selector", b"points_selector", "shard_key_selector", b"shard_key_selector"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["_key", b"_key", "_points_selector", b"_points_selector", "_shard_key_selector", b"_shard_key_selector", "key", b"key", "payload", b"payload", "points_selector", b"points_selector", "shard_key_selector", b"shard_key_selector"]) -> None: ...
        @typing.overload
        def WhichOneof(self, oneof_group: typing_extensions.Literal["_key", b"_key"]) -> typing_extensions.Literal["key"] | None: ...
        @typing.overload
        def WhichOneof(self, oneof_group: typing_extensions.Literal["_points_selector", b"_points_selector"]) -> typing_extensions.Literal["points_selector"] | None: ...
        @typing.overload
        def WhichOneof(self, oneof_group: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector"]) -> typing_extensions.Literal["shard_key_selector"] | None: ...

    class OverwritePayload(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class PayloadEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: builtins.str
            @property
            def value(self) -> json_with_int_pb2.Value: ...
            def __init__(
                self,
                *,
                key: builtins.str = ...,
                value: json_with_int_pb2.Value | None = ...,
            ) -> None: ...
            def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

        PAYLOAD_FIELD_NUMBER: builtins.int
        POINTS_SELECTOR_FIELD_NUMBER: builtins.int
        SHARD_KEY_SELECTOR_FIELD_NUMBER: builtins.int
        KEY_FIELD_NUMBER: builtins.int
        @property
        def payload(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, json_with_int_pb2.Value]: ...
        @property
        def points_selector(self) -> global___PointsSelector:
            """Affected points"""
        @property
        def shard_key_selector(self) -> global___ShardKeySelector:
            """Option for custom sharding to specify used shard keys"""
        key: builtins.str
        """Option for indicate property of payload"""
        def __init__(
            self,
            *,
            payload: collections.abc.Mapping[builtins.str, json_with_int_pb2.Value] | None = ...,
            points_selector: global___PointsSelector | None = ...,
            shard_key_selector: global___ShardKeySelector | None = ...,
            key: builtins.str | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["_key", b"_key", "_points_selector", b"_points_selector", "_shard_key_selector", b"_shard_key_selector", "key", b"key", "points_selector", b"points_selector", "shard_key_selector", b"shard_key_selector"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["_key", b"_key", "_points_selector", b"_points_selector", "_shard_key_selector", b"_shard_key_selector", "key", b"key", "payload", b"payload", "points_selector", b"points_selector", "shard_key_selector", b"shard_key_selector"]) -> None: ...
        @typing.overload
        def WhichOneof(self, oneof_group: typing_extensions.Literal["_key", b"_key"]) -> typing_extensions.Literal["key"] | None: ...
        @typing.overload
        def WhichOneof(self, oneof_group: typing_extensions.Literal["_points_selector", b"_points_selector"]) -> typing_extensions.Literal["points_selector"] | None: ...
        @typing.overload
        def WhichOneof(self, oneof_group: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector"]) -> typing_extensions.Literal["shard_key_selector"] | None: ...

    class DeletePayload(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEYS_FIELD_NUMBER: builtins.int
        POINTS_SELECTOR_FIELD_NUMBER: builtins.int
        SHARD_KEY_SELECTOR_FIELD_NUMBER: builtins.int
        @property
        def keys(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
        @property
        def points_selector(self) -> global___PointsSelector:
            """Affected points"""
        @property
        def shard_key_selector(self) -> global___ShardKeySelector:
            """Option for custom sharding to specify used shard keys"""
        def __init__(
            self,
            *,
            keys: collections.abc.Iterable[builtins.str] | None = ...,
            points_selector: global___PointsSelector | None = ...,
            shard_key_selector: global___ShardKeySelector | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["_points_selector", b"_points_selector", "_shard_key_selector", b"_shard_key_selector", "points_selector", b"points_selector", "shard_key_selector", b"shard_key_selector"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["_points_selector", b"_points_selector", "_shard_key_selector", b"_shard_key_selector", "keys", b"keys", "points_selector", b"points_selector", "shard_key_selector", b"shard_key_selector"]) -> None: ...
        @typing.overload
        def WhichOneof(self, oneof_group: typing_extensions.Literal["_points_selector", b"_points_selector"]) -> typing_extensions.Literal["points_selector"] | None: ...
        @typing.overload
        def WhichOneof(self, oneof_group: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector"]) -> typing_extensions.Literal["shard_key_selector"] | None: ...

    class UpdateVectors(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        POINTS_FIELD_NUMBER: builtins.int
        SHARD_KEY_SELECTOR_FIELD_NUMBER: builtins.int
        UPDATE_FILTER_FIELD_NUMBER: builtins.int
        @property
        def points(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PointVectors]:
            """List of points and vectors to update"""
        @property
        def shard_key_selector(self) -> global___ShardKeySelector:
            """Option for custom sharding to specify used shard keys"""
        @property
        def update_filter(self) -> qdrant_common_pb2.Filter:
            """If specified, only points that match this filter will be updated"""
        def __init__(
            self,
            *,
            points: collections.abc.Iterable[global___PointVectors] | None = ...,
            shard_key_selector: global___ShardKeySelector | None = ...,
            update_filter: qdrant_common_pb2.Filter | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector", "_update_filter", b"_update_filter", "shard_key_selector", b"shard_key_selector", "update_filter", b"update_filter"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector", "_update_filter", b"_update_filter", "points", b"points", "shard_key_selector", b"shard_key_selector", "update_filter", b"update_filter"]) -> None: ...
        @typing.overload
        def WhichOneof(self, oneof_group: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector"]) -> typing_extensions.Literal["shard_key_selector"] | None: ...
        @typing.overload
        def WhichOneof(self, oneof_group: typing_extensions.Literal["_update_filter", b"_update_filter"]) -> typing_extensions.Literal["update_filter"] | None: ...

    class DeleteVectors(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        POINTS_SELECTOR_FIELD_NUMBER: builtins.int
        VECTORS_FIELD_NUMBER: builtins.int
        SHARD_KEY_SELECTOR_FIELD_NUMBER: builtins.int
        @property
        def points_selector(self) -> global___PointsSelector:
            """Affected points"""
        @property
        def vectors(self) -> global___VectorsSelector:
            """List of vector names to delete"""
        @property
        def shard_key_selector(self) -> global___ShardKeySelector:
            """Option for custom sharding to specify used shard keys"""
        def __init__(
            self,
            *,
            points_selector: global___PointsSelector | None = ...,
            vectors: global___VectorsSelector | None = ...,
            shard_key_selector: global___ShardKeySelector | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector", "points_selector", b"points_selector", "shard_key_selector", b"shard_key_selector", "vectors", b"vectors"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector", "points_selector", b"points_selector", "shard_key_selector", b"shard_key_selector", "vectors", b"vectors"]) -> None: ...
        def WhichOneof(self, oneof_group: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector"]) -> typing_extensions.Literal["shard_key_selector"] | None: ...

    class DeletePoints(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        POINTS_FIELD_NUMBER: builtins.int
        SHARD_KEY_SELECTOR_FIELD_NUMBER: builtins.int
        @property
        def points(self) -> global___PointsSelector:
            """Affected points"""
        @property
        def shard_key_selector(self) -> global___ShardKeySelector:
            """Option for custom sharding to specify used shard keys"""
        def __init__(
            self,
            *,
            points: global___PointsSelector | None = ...,
            shard_key_selector: global___ShardKeySelector | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector", "points", b"points", "shard_key_selector", b"shard_key_selector"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector", "points", b"points", "shard_key_selector", b"shard_key_selector"]) -> None: ...
        def WhichOneof(self, oneof_group: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector"]) -> typing_extensions.Literal["shard_key_selector"] | None: ...

    class ClearPayload(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        POINTS_FIELD_NUMBER: builtins.int
        SHARD_KEY_SELECTOR_FIELD_NUMBER: builtins.int
        @property
        def points(self) -> global___PointsSelector:
            """Affected points"""
        @property
        def shard_key_selector(self) -> global___ShardKeySelector:
            """Option for custom sharding to specify used shard keys"""
        def __init__(
            self,
            *,
            points: global___PointsSelector | None = ...,
            shard_key_selector: global___ShardKeySelector | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector", "points", b"points", "shard_key_selector", b"shard_key_selector"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector", "points", b"points", "shard_key_selector", b"shard_key_selector"]) -> None: ...
        def WhichOneof(self, oneof_group: typing_extensions.Literal["_shard_key_selector", b"_shard_key_selector"]) -> typing_extensions.Literal["shard_key_selector"] | None: ...

    UPSERT_FIELD_NUMBER: builtins.int
    DELETE_DEPRECATED_FIELD_NUMBER: builtins.int
    SET_PAYLOAD_FIELD_NUMBER: builtins.int
    OVERWRITE_PAYLOAD_FIELD_NUMBER: builtins.int
    DELETE_PAYLOAD_FIELD_NUMBER: builtins.int
    CLEAR_PAYLOAD_DEPRECATED_FIELD_NUMBER: builtins.int
    UPDATE_VECTORS_FIELD_NUMBER: builtins.int
    DELETE_VECTORS_FIELD_NUMBER: builtins.int
    DELETE_POINTS_FIELD_NUMBER: builtins.int
    CLEAR_PAYLOAD_FIELD_NUMBER: builtins.int
    @property
    def upsert(self) -> global___PointsUpdateOperation.PointStructList: ...
    @property
    def delete_deprecated(self) -> global___PointsSelector: ...
    @property
    def set_payload(self) -> global___PointsUpdateOperation.SetPayload: ...
    @property
    def overwrite_payload(self) -> global___PointsUpdateOperation.OverwritePayload: ...
    @property
    def delete_payload(self) -> global___PointsUpdateOperation.DeletePayload: ...
    @property
    def clear_payload_deprecated(self) -> global___PointsSelector: ...
    @property
    def update_vectors(self) -> global___PointsUpdateOperation.UpdateVectors: ...
    @property
    def delete_vectors(self) -> global___PointsUpdateOperation.DeleteVectors: ...
    @property
    def delete_points(self) -> global___PointsUpdateOperation.DeletePoints: ...
    @property
    def clear_payload(self) -> global___PointsUpdateOperation.ClearPayload: ...
    def __init__(
        self,
        *,
        upsert: global___PointsUpdateOperation.PointStructList | None = ...,
        delete_deprecated: global___PointsSelector | None = ...,
        set_payload: global___PointsUpdateOperation.SetPayload | None = ...,
        overwrite_payload: global___PointsUpdateOperation.OverwritePayload | None = ...,
        delete_payload: global___PointsUpdateOperation.DeletePayload | None = ...,
        clear_payload_deprecated: global___PointsSelector | None = ...,
        update_vectors: global___PointsUpdateOperation.UpdateVectors | None = ...,
        delete_vectors: global___PointsUpdateOperation.DeleteVectors | None = ...,
        delete_points: global___PointsUpdateOperation.DeletePoints | None = ...,
        clear_payload: global___PointsUpdateOperation.ClearPayload | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["clear_payload", b"clear_payload", "clear_payload_deprecated", b"clear_payload_deprecated", "delete_deprecated", b"delete_deprecated", "delete_payload", b"delete_payload", "delete_points", b"delete_points", "delete_vectors", b"delete_vectors", "operation", b"operation", "overwrite_payload", b"overwrite_payload", "set_payload", b"set_payload", "update_vectors", b"update_vectors", "upsert", b"upsert"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["clear_payload", b"clear_payload", "clear_payload_deprecated", b"clear_payload_deprecated", "delete_deprecated", b"delete_deprecated", "delete_payload", b"delete_payload", "delete_points", b"delete_points", "delete_vectors", b"delete_vectors", "operation", b"operation", "overwrite_payload", b"overwrite_payload", "set_payload", b"set_payload", "update_vectors", b"update_vectors", "upsert", b"upsert"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["operation", b"operation"]) -> typing_extensions.Literal["upsert", "delete_deprecated", "set_payload", "overwrite_payload", "delete_payload", "clear_payload_deprecated", "update_vectors", "delete_vectors", "delete_points", "clear_payload"] | None: ...

global___PointsUpdateOperation = PointsUpdateOperation

class UpdateBatchPoints(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COLLECTION_NAME_FIELD_NUMBER: builtins.int
    WAIT_FIELD_NUMBER: builtins.int
    OPERATIONS_FIELD_NUMBER: builtins.int
    ORDERING_FIELD_NUMBER: builtins.int
    collection_name: builtins.str
    """name of the collection"""
    wait: builtins.bool
    """Wait until the changes have been applied?"""
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PointsUpdateOperation]: ...
    @property
    def ordering(self) -> global___WriteOrdering:
        """Write ordering guarantees"""
    def __init__(
        self,
        *,
        collection_name: builtins.str = ...,
        wait: builtins.bool | None = ...,
        operations: collections.abc.Iterable[global___PointsUpdateOperation] | None = ...,
        ordering: global___WriteOrdering | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_ordering", b"_ordering", "_wait", b"_wait", "ordering", b"ordering", "wait", b"wait"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_ordering", b"_ordering", "_wait", b"_wait", "collection_name", b"collection_name", "operations", b"operations", "ordering", b"ordering", "wait", b"wait"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_ordering", b"_ordering"]) -> typing_extensions.Literal["ordering"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_wait", b"_wait"]) -> typing_extensions.Literal["wait"] | None: ...

global___UpdateBatchPoints = UpdateBatchPoints

class PointsOperationResponse(google.protobuf.message.Message):
    """---------------------------------------------
    ---------------- RPC Response ---------------
    ---------------------------------------------
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESULT_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    USAGE_FIELD_NUMBER: builtins.int
    @property
    def result(self) -> global___UpdateResult: ...
    time: builtins.float
    """Time spent to process"""
    @property
    def usage(self) -> global___Usage: ...
    def __init__(
        self,
        *,
        result: global___UpdateResult | None = ...,
        time: builtins.float = ...,
        usage: global___Usage | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_usage", b"_usage", "result", b"result", "usage", b"usage"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_usage", b"_usage", "result", b"result", "time", b"time", "usage", b"usage"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_usage", b"_usage"]) -> typing_extensions.Literal["usage"] | None: ...

global___PointsOperationResponse = PointsOperationResponse

class UpdateResult(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    operation_id: builtins.int
    """Number of operation"""
    status: global___UpdateStatus.ValueType
    """Operation status"""
    def __init__(
        self,
        *,
        operation_id: builtins.int | None = ...,
        status: global___UpdateStatus.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_operation_id", b"_operation_id", "operation_id", b"operation_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_operation_id", b"_operation_id", "operation_id", b"operation_id", "status", b"status"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_operation_id", b"_operation_id"]) -> typing_extensions.Literal["operation_id"] | None: ...

global___UpdateResult = UpdateResult

class OrderValue(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INT_FIELD_NUMBER: builtins.int
    FLOAT_FIELD_NUMBER: builtins.int
    int: builtins.int
    float: builtins.float
    def __init__(
        self,
        *,
        int: builtins.int = ...,
        float: builtins.float = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["float", b"float", "int", b"int", "variant", b"variant"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["float", b"float", "int", b"int", "variant", b"variant"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["variant", b"variant"]) -> typing_extensions.Literal["int", "float"] | None: ...

global___OrderValue = OrderValue

class ScoredPoint(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class PayloadEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> json_with_int_pb2.Value: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: json_with_int_pb2.Value | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    PAYLOAD_FIELD_NUMBER: builtins.int
    SCORE_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    VECTORS_FIELD_NUMBER: builtins.int
    SHARD_KEY_FIELD_NUMBER: builtins.int
    ORDER_VALUE_FIELD_NUMBER: builtins.int
    @property
    def id(self) -> qdrant_common_pb2.PointId:
        """Point id"""
    @property
    def payload(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, json_with_int_pb2.Value]:
        """Payload"""
    score: builtins.float
    """Similarity score"""
    version: builtins.int
    """Last update operation applied to this point"""
    @property
    def vectors(self) -> global___VectorsOutput:
        """Vectors to search"""
    @property
    def shard_key(self) -> collections_pb2.ShardKey:
        """Shard key"""
    @property
    def order_value(self) -> global___OrderValue:
        """Order by value"""
    def __init__(
        self,
        *,
        id: qdrant_common_pb2.PointId | None = ...,
        payload: collections.abc.Mapping[builtins.str, json_with_int_pb2.Value] | None = ...,
        score: builtins.float = ...,
        version: builtins.int = ...,
        vectors: global___VectorsOutput | None = ...,
        shard_key: collections_pb2.ShardKey | None = ...,
        order_value: global___OrderValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_order_value", b"_order_value", "_shard_key", b"_shard_key", "_vectors", b"_vectors", "id", b"id", "order_value", b"order_value", "shard_key", b"shard_key", "vectors", b"vectors"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_order_value", b"_order_value", "_shard_key", b"_shard_key", "_vectors", b"_vectors", "id", b"id", "order_value", b"order_value", "payload", b"payload", "score", b"score", "shard_key", b"shard_key", "vectors", b"vectors", "version", b"version"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_order_value", b"_order_value"]) -> typing_extensions.Literal["order_value"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_shard_key", b"_shard_key"]) -> typing_extensions.Literal["shard_key"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_vectors", b"_vectors"]) -> typing_extensions.Literal["vectors"] | None: ...

global___ScoredPoint = ScoredPoint

class GroupId(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UNSIGNED_VALUE_FIELD_NUMBER: builtins.int
    INTEGER_VALUE_FIELD_NUMBER: builtins.int
    STRING_VALUE_FIELD_NUMBER: builtins.int
    unsigned_value: builtins.int
    """Represents a double value."""
    integer_value: builtins.int
    """Represents an integer value"""
    string_value: builtins.str
    """Represents a string value."""
    def __init__(
        self,
        *,
        unsigned_value: builtins.int = ...,
        integer_value: builtins.int = ...,
        string_value: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["integer_value", b"integer_value", "kind", b"kind", "string_value", b"string_value", "unsigned_value", b"unsigned_value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["integer_value", b"integer_value", "kind", b"kind", "string_value", b"string_value", "unsigned_value", b"unsigned_value"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["kind", b"kind"]) -> typing_extensions.Literal["unsigned_value", "integer_value", "string_value"] | None: ...

global___GroupId = GroupId

class PointGroup(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    HITS_FIELD_NUMBER: builtins.int
    LOOKUP_FIELD_NUMBER: builtins.int
    @property
    def id(self) -> global___GroupId:
        """Group id"""
    @property
    def hits(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ScoredPoint]:
        """Points in the group"""
    @property
    def lookup(self) -> global___RetrievedPoint:
        """Point(s) from the lookup collection that matches the group id"""
    def __init__(
        self,
        *,
        id: global___GroupId | None = ...,
        hits: collections.abc.Iterable[global___ScoredPoint] | None = ...,
        lookup: global___RetrievedPoint | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["id", b"id", "lookup", b"lookup"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["hits", b"hits", "id", b"id", "lookup", b"lookup"]) -> None: ...

global___PointGroup = PointGroup

class GroupsResult(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GROUPS_FIELD_NUMBER: builtins.int
    @property
    def groups(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PointGroup]:
        """Groups"""
    def __init__(
        self,
        *,
        groups: collections.abc.Iterable[global___PointGroup] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["groups", b"groups"]) -> None: ...

global___GroupsResult = GroupsResult

class SearchResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESULT_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    USAGE_FIELD_NUMBER: builtins.int
    @property
    def result(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ScoredPoint]: ...
    time: builtins.float
    """Time spent to process"""
    @property
    def usage(self) -> global___Usage: ...
    def __init__(
        self,
        *,
        result: collections.abc.Iterable[global___ScoredPoint] | None = ...,
        time: builtins.float = ...,
        usage: global___Usage | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_usage", b"_usage", "usage", b"usage"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_usage", b"_usage", "result", b"result", "time", b"time", "usage", b"usage"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_usage", b"_usage"]) -> typing_extensions.Literal["usage"] | None: ...

global___SearchResponse = SearchResponse

class QueryResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESULT_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    USAGE_FIELD_NUMBER: builtins.int
    @property
    def result(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ScoredPoint]: ...
    time: builtins.float
    """Time spent to process"""
    @property
    def usage(self) -> global___Usage: ...
    def __init__(
        self,
        *,
        result: collections.abc.Iterable[global___ScoredPoint] | None = ...,
        time: builtins.float = ...,
        usage: global___Usage | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_usage", b"_usage", "usage", b"usage"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_usage", b"_usage", "result", b"result", "time", b"time", "usage", b"usage"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_usage", b"_usage"]) -> typing_extensions.Literal["usage"] | None: ...

global___QueryResponse = QueryResponse

class QueryBatchResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESULT_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    USAGE_FIELD_NUMBER: builtins.int
    @property
    def result(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BatchResult]: ...
    time: builtins.float
    """Time spent to process"""
    @property
    def usage(self) -> global___Usage: ...
    def __init__(
        self,
        *,
        result: collections.abc.Iterable[global___BatchResult] | None = ...,
        time: builtins.float = ...,
        usage: global___Usage | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_usage", b"_usage", "usage", b"usage"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_usage", b"_usage", "result", b"result", "time", b"time", "usage", b"usage"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_usage", b"_usage"]) -> typing_extensions.Literal["usage"] | None: ...

global___QueryBatchResponse = QueryBatchResponse

class QueryGroupsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESULT_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    USAGE_FIELD_NUMBER: builtins.int
    @property
    def result(self) -> global___GroupsResult: ...
    time: builtins.float
    """Time spent to process"""
    @property
    def usage(self) -> global___Usage: ...
    def __init__(
        self,
        *,
        result: global___GroupsResult | None = ...,
        time: builtins.float = ...,
        usage: global___Usage | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_usage", b"_usage", "result", b"result", "usage", b"usage"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_usage", b"_usage", "result", b"result", "time", b"time", "usage", b"usage"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_usage", b"_usage"]) -> typing_extensions.Literal["usage"] | None: ...

global___QueryGroupsResponse = QueryGroupsResponse

class BatchResult(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESULT_FIELD_NUMBER: builtins.int
    @property
    def result(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ScoredPoint]: ...
    def __init__(
        self,
        *,
        result: collections.abc.Iterable[global___ScoredPoint] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["result", b"result"]) -> None: ...

global___BatchResult = BatchResult

class SearchBatchResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESULT_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    USAGE_FIELD_NUMBER: builtins.int
    @property
    def result(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BatchResult]: ...
    time: builtins.float
    """Time spent to process"""
    @property
    def usage(self) -> global___Usage: ...
    def __init__(
        self,
        *,
        result: collections.abc.Iterable[global___BatchResult] | None = ...,
        time: builtins.float = ...,
        usage: global___Usage | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_usage", b"_usage", "usage", b"usage"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_usage", b"_usage", "result", b"result", "time", b"time", "usage", b"usage"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_usage", b"_usage"]) -> typing_extensions.Literal["usage"] | None: ...

global___SearchBatchResponse = SearchBatchResponse

class SearchGroupsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESULT_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    USAGE_FIELD_NUMBER: builtins.int
    @property
    def result(self) -> global___GroupsResult: ...
    time: builtins.float
    """Time spent to process"""
    @property
    def usage(self) -> global___Usage: ...
    def __init__(
        self,
        *,
        result: global___GroupsResult | None = ...,
        time: builtins.float = ...,
        usage: global___Usage | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_usage", b"_usage", "result", b"result", "usage", b"usage"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_usage", b"_usage", "result", b"result", "time", b"time", "usage", b"usage"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_usage", b"_usage"]) -> typing_extensions.Literal["usage"] | None: ...

global___SearchGroupsResponse = SearchGroupsResponse

class CountResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESULT_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    USAGE_FIELD_NUMBER: builtins.int
    @property
    def result(self) -> global___CountResult: ...
    time: builtins.float
    """Time spent to process"""
    @property
    def usage(self) -> global___Usage: ...
    def __init__(
        self,
        *,
        result: global___CountResult | None = ...,
        time: builtins.float = ...,
        usage: global___Usage | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_usage", b"_usage", "result", b"result", "usage", b"usage"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_usage", b"_usage", "result", b"result", "time", b"time", "usage", b"usage"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_usage", b"_usage"]) -> typing_extensions.Literal["usage"] | None: ...

global___CountResponse = CountResponse

class ScrollResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NEXT_PAGE_OFFSET_FIELD_NUMBER: builtins.int
    RESULT_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    USAGE_FIELD_NUMBER: builtins.int
    @property
    def next_page_offset(self) -> qdrant_common_pb2.PointId:
        """Use this offset for the next query"""
    @property
    def result(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RetrievedPoint]: ...
    time: builtins.float
    """Time spent to process"""
    @property
    def usage(self) -> global___Usage: ...
    def __init__(
        self,
        *,
        next_page_offset: qdrant_common_pb2.PointId | None = ...,
        result: collections.abc.Iterable[global___RetrievedPoint] | None = ...,
        time: builtins.float = ...,
        usage: global___Usage | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_next_page_offset", b"_next_page_offset", "_usage", b"_usage", "next_page_offset", b"next_page_offset", "usage", b"usage"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_next_page_offset", b"_next_page_offset", "_usage", b"_usage", "next_page_offset", b"next_page_offset", "result", b"result", "time", b"time", "usage", b"usage"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_next_page_offset", b"_next_page_offset"]) -> typing_extensions.Literal["next_page_offset"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_usage", b"_usage"]) -> typing_extensions.Literal["usage"] | None: ...

global___ScrollResponse = ScrollResponse

class CountResult(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COUNT_FIELD_NUMBER: builtins.int
    count: builtins.int
    def __init__(
        self,
        *,
        count: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["count", b"count"]) -> None: ...

global___CountResult = CountResult

class RetrievedPoint(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class PayloadEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> json_with_int_pb2.Value: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: json_with_int_pb2.Value | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    PAYLOAD_FIELD_NUMBER: builtins.int
    VECTORS_FIELD_NUMBER: builtins.int
    SHARD_KEY_FIELD_NUMBER: builtins.int
    ORDER_VALUE_FIELD_NUMBER: builtins.int
    @property
    def id(self) -> qdrant_common_pb2.PointId: ...
    @property
    def payload(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, json_with_int_pb2.Value]: ...
    @property
    def vectors(self) -> global___VectorsOutput: ...
    @property
    def shard_key(self) -> collections_pb2.ShardKey:
        """Shard key"""
    @property
    def order_value(self) -> global___OrderValue:
        """Order-by value"""
    def __init__(
        self,
        *,
        id: qdrant_common_pb2.PointId | None = ...,
        payload: collections.abc.Mapping[builtins.str, json_with_int_pb2.Value] | None = ...,
        vectors: global___VectorsOutput | None = ...,
        shard_key: collections_pb2.ShardKey | None = ...,
        order_value: global___OrderValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_order_value", b"_order_value", "_shard_key", b"_shard_key", "_vectors", b"_vectors", "id", b"id", "order_value", b"order_value", "shard_key", b"shard_key", "vectors", b"vectors"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_order_value", b"_order_value", "_shard_key", b"_shard_key", "_vectors", b"_vectors", "id", b"id", "order_value", b"order_value", "payload", b"payload", "shard_key", b"shard_key", "vectors", b"vectors"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_order_value", b"_order_value"]) -> typing_extensions.Literal["order_value"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_shard_key", b"_shard_key"]) -> typing_extensions.Literal["shard_key"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_vectors", b"_vectors"]) -> typing_extensions.Literal["vectors"] | None: ...

global___RetrievedPoint = RetrievedPoint

class GetResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESULT_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    USAGE_FIELD_NUMBER: builtins.int
    @property
    def result(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RetrievedPoint]: ...
    time: builtins.float
    """Time spent to process"""
    @property
    def usage(self) -> global___Usage: ...
    def __init__(
        self,
        *,
        result: collections.abc.Iterable[global___RetrievedPoint] | None = ...,
        time: builtins.float = ...,
        usage: global___Usage | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_usage", b"_usage", "usage", b"usage"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_usage", b"_usage", "result", b"result", "time", b"time", "usage", b"usage"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_usage", b"_usage"]) -> typing_extensions.Literal["usage"] | None: ...

global___GetResponse = GetResponse

class RecommendResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESULT_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    USAGE_FIELD_NUMBER: builtins.int
    @property
    def result(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ScoredPoint]: ...
    time: builtins.float
    """Time spent to process"""
    @property
    def usage(self) -> global___Usage: ...
    def __init__(
        self,
        *,
        result: collections.abc.Iterable[global___ScoredPoint] | None = ...,
        time: builtins.float = ...,
        usage: global___Usage | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_usage", b"_usage", "usage", b"usage"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_usage", b"_usage", "result", b"result", "time", b"time", "usage", b"usage"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_usage", b"_usage"]) -> typing_extensions.Literal["usage"] | None: ...

global___RecommendResponse = RecommendResponse

class RecommendBatchResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESULT_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    USAGE_FIELD_NUMBER: builtins.int
    @property
    def result(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BatchResult]: ...
    time: builtins.float
    """Time spent to process"""
    @property
    def usage(self) -> global___Usage: ...
    def __init__(
        self,
        *,
        result: collections.abc.Iterable[global___BatchResult] | None = ...,
        time: builtins.float = ...,
        usage: global___Usage | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_usage", b"_usage", "usage", b"usage"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_usage", b"_usage", "result", b"result", "time", b"time", "usage", b"usage"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_usage", b"_usage"]) -> typing_extensions.Literal["usage"] | None: ...

global___RecommendBatchResponse = RecommendBatchResponse

class DiscoverResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESULT_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    USAGE_FIELD_NUMBER: builtins.int
    @property
    def result(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ScoredPoint]: ...
    time: builtins.float
    """Time spent to process"""
    @property
    def usage(self) -> global___Usage: ...
    def __init__(
        self,
        *,
        result: collections.abc.Iterable[global___ScoredPoint] | None = ...,
        time: builtins.float = ...,
        usage: global___Usage | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_usage", b"_usage", "usage", b"usage"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_usage", b"_usage", "result", b"result", "time", b"time", "usage", b"usage"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_usage", b"_usage"]) -> typing_extensions.Literal["usage"] | None: ...

global___DiscoverResponse = DiscoverResponse

class DiscoverBatchResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESULT_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    USAGE_FIELD_NUMBER: builtins.int
    @property
    def result(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BatchResult]: ...
    time: builtins.float
    """Time spent to process"""
    @property
    def usage(self) -> global___Usage: ...
    def __init__(
        self,
        *,
        result: collections.abc.Iterable[global___BatchResult] | None = ...,
        time: builtins.float = ...,
        usage: global___Usage | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_usage", b"_usage", "usage", b"usage"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_usage", b"_usage", "result", b"result", "time", b"time", "usage", b"usage"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_usage", b"_usage"]) -> typing_extensions.Literal["usage"] | None: ...

global___DiscoverBatchResponse = DiscoverBatchResponse

class RecommendGroupsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESULT_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    USAGE_FIELD_NUMBER: builtins.int
    @property
    def result(self) -> global___GroupsResult: ...
    time: builtins.float
    """Time spent to process"""
    @property
    def usage(self) -> global___Usage: ...
    def __init__(
        self,
        *,
        result: global___GroupsResult | None = ...,
        time: builtins.float = ...,
        usage: global___Usage | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_usage", b"_usage", "result", b"result", "usage", b"usage"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_usage", b"_usage", "result", b"result", "time", b"time", "usage", b"usage"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_usage", b"_usage"]) -> typing_extensions.Literal["usage"] | None: ...

global___RecommendGroupsResponse = RecommendGroupsResponse

class UpdateBatchResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESULT_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    USAGE_FIELD_NUMBER: builtins.int
    @property
    def result(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___UpdateResult]: ...
    time: builtins.float
    """Time spent to process"""
    @property
    def usage(self) -> global___Usage: ...
    def __init__(
        self,
        *,
        result: collections.abc.Iterable[global___UpdateResult] | None = ...,
        time: builtins.float = ...,
        usage: global___Usage | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_usage", b"_usage", "usage", b"usage"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_usage", b"_usage", "result", b"result", "time", b"time", "usage", b"usage"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_usage", b"_usage"]) -> typing_extensions.Literal["usage"] | None: ...

global___UpdateBatchResponse = UpdateBatchResponse

class FacetResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HITS_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    USAGE_FIELD_NUMBER: builtins.int
    @property
    def hits(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FacetHit]: ...
    time: builtins.float
    """Time spent to process"""
    @property
    def usage(self) -> global___Usage: ...
    def __init__(
        self,
        *,
        hits: collections.abc.Iterable[global___FacetHit] | None = ...,
        time: builtins.float = ...,
        usage: global___Usage | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_usage", b"_usage", "usage", b"usage"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_usage", b"_usage", "hits", b"hits", "time", b"time", "usage", b"usage"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_usage", b"_usage"]) -> typing_extensions.Literal["usage"] | None: ...

global___FacetResponse = FacetResponse

class SearchMatrixPairsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESULT_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    USAGE_FIELD_NUMBER: builtins.int
    @property
    def result(self) -> global___SearchMatrixPairs: ...
    time: builtins.float
    """Time spent to process"""
    @property
    def usage(self) -> global___Usage: ...
    def __init__(
        self,
        *,
        result: global___SearchMatrixPairs | None = ...,
        time: builtins.float = ...,
        usage: global___Usage | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_usage", b"_usage", "result", b"result", "usage", b"usage"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_usage", b"_usage", "result", b"result", "time", b"time", "usage", b"usage"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_usage", b"_usage"]) -> typing_extensions.Literal["usage"] | None: ...

global___SearchMatrixPairsResponse = SearchMatrixPairsResponse

class SearchMatrixOffsetsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESULT_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    USAGE_FIELD_NUMBER: builtins.int
    @property
    def result(self) -> global___SearchMatrixOffsets: ...
    time: builtins.float
    """Time spent to process"""
    @property
    def usage(self) -> global___Usage: ...
    def __init__(
        self,
        *,
        result: global___SearchMatrixOffsets | None = ...,
        time: builtins.float = ...,
        usage: global___Usage | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_usage", b"_usage", "result", b"result", "usage", b"usage"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_usage", b"_usage", "result", b"result", "time", b"time", "usage", b"usage"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_usage", b"_usage"]) -> typing_extensions.Literal["usage"] | None: ...

global___SearchMatrixOffsetsResponse = SearchMatrixOffsetsResponse

class PointsSelector(google.protobuf.message.Message):
    """---------------------------------------------
    -------------- Points Selector --------------
    ---------------------------------------------
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POINTS_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    @property
    def points(self) -> global___PointsIdsList: ...
    @property
    def filter(self) -> qdrant_common_pb2.Filter: ...
    def __init__(
        self,
        *,
        points: global___PointsIdsList | None = ...,
        filter: qdrant_common_pb2.Filter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["filter", b"filter", "points", b"points", "points_selector_one_of", b"points_selector_one_of"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["filter", b"filter", "points", b"points", "points_selector_one_of", b"points_selector_one_of"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["points_selector_one_of", b"points_selector_one_of"]) -> typing_extensions.Literal["points", "filter"] | None: ...

global___PointsSelector = PointsSelector

class PointsIdsList(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IDS_FIELD_NUMBER: builtins.int
    @property
    def ids(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[qdrant_common_pb2.PointId]: ...
    def __init__(
        self,
        *,
        ids: collections.abc.Iterable[qdrant_common_pb2.PointId] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["ids", b"ids"]) -> None: ...

global___PointsIdsList = PointsIdsList

class PointStruct(google.protobuf.message.Message):
    """---------------------------------------------
    ------------------- Point -------------------
    ---------------------------------------------
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class PayloadEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> json_with_int_pb2.Value: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: json_with_int_pb2.Value | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    PAYLOAD_FIELD_NUMBER: builtins.int
    VECTORS_FIELD_NUMBER: builtins.int
    @property
    def id(self) -> qdrant_common_pb2.PointId: ...
    @property
    def payload(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, json_with_int_pb2.Value]: ...
    @property
    def vectors(self) -> global___Vectors: ...
    def __init__(
        self,
        *,
        id: qdrant_common_pb2.PointId | None = ...,
        payload: collections.abc.Mapping[builtins.str, json_with_int_pb2.Value] | None = ...,
        vectors: global___Vectors | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_vectors", b"_vectors", "id", b"id", "vectors", b"vectors"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_vectors", b"_vectors", "id", b"id", "payload", b"payload", "vectors", b"vectors"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_vectors", b"_vectors"]) -> typing_extensions.Literal["vectors"] | None: ...

global___PointStruct = PointStruct

class Usage(google.protobuf.message.Message):
    """---------------------------------------------
    ----------- Measurements collector ----------
    ---------------------------------------------
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HARDWARE_FIELD_NUMBER: builtins.int
    INFERENCE_FIELD_NUMBER: builtins.int
    @property
    def hardware(self) -> global___HardwareUsage: ...
    @property
    def inference(self) -> global___InferenceUsage: ...
    def __init__(
        self,
        *,
        hardware: global___HardwareUsage | None = ...,
        inference: global___InferenceUsage | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_hardware", b"_hardware", "_inference", b"_inference", "hardware", b"hardware", "inference", b"inference"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_hardware", b"_hardware", "_inference", b"_inference", "hardware", b"hardware", "inference", b"inference"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_hardware", b"_hardware"]) -> typing_extensions.Literal["hardware"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_inference", b"_inference"]) -> typing_extensions.Literal["inference"] | None: ...

global___Usage = Usage

class InferenceUsage(google.protobuf.message.Message):
    """---------------------------------------------
    ------------ Inference measurements ----------
    ---------------------------------------------
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class ModelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___ModelUsage: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___ModelUsage | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    MODELS_FIELD_NUMBER: builtins.int
    @property
    def models(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___ModelUsage]: ...
    def __init__(
        self,
        *,
        models: collections.abc.Mapping[builtins.str, global___ModelUsage] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["models", b"models"]) -> None: ...

global___InferenceUsage = InferenceUsage

class ModelUsage(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOKENS_FIELD_NUMBER: builtins.int
    tokens: builtins.int
    def __init__(
        self,
        *,
        tokens: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["tokens", b"tokens"]) -> None: ...

global___ModelUsage = ModelUsage

class HardwareUsage(google.protobuf.message.Message):
    """---------------------------------------------
    ------------ Hardware measurements ----------
    ---------------------------------------------
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CPU_FIELD_NUMBER: builtins.int
    PAYLOAD_IO_READ_FIELD_NUMBER: builtins.int
    PAYLOAD_IO_WRITE_FIELD_NUMBER: builtins.int
    PAYLOAD_INDEX_IO_READ_FIELD_NUMBER: builtins.int
    PAYLOAD_INDEX_IO_WRITE_FIELD_NUMBER: builtins.int
    VECTOR_IO_READ_FIELD_NUMBER: builtins.int
    VECTOR_IO_WRITE_FIELD_NUMBER: builtins.int
    cpu: builtins.int
    payload_io_read: builtins.int
    payload_io_write: builtins.int
    payload_index_io_read: builtins.int
    payload_index_io_write: builtins.int
    vector_io_read: builtins.int
    vector_io_write: builtins.int
    def __init__(
        self,
        *,
        cpu: builtins.int = ...,
        payload_io_read: builtins.int = ...,
        payload_io_write: builtins.int = ...,
        payload_index_io_read: builtins.int = ...,
        payload_index_io_write: builtins.int = ...,
        vector_io_read: builtins.int = ...,
        vector_io_write: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["cpu", b"cpu", "payload_index_io_read", b"payload_index_io_read", "payload_index_io_write", b"payload_index_io_write", "payload_io_read", b"payload_io_read", "payload_io_write", b"payload_io_write", "vector_io_read", b"vector_io_read", "vector_io_write", b"vector_io_write"]) -> None: ...

global___HardwareUsage = HardwareUsage
