/*
InfCloud - the open source CalDAV/CardDAV Web Client
Copyright (C) 2011-2015
    Jan Mate <jan.mate@inf-it.com>
    Andrej Lezo <andrej.lezo@inf-it.com>
    Matej Mihalik <matej.mihalik@inf-it.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as
published by the Free Software Foundation, either version 3 of the
License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

// NOTE: console.log(...) messages are not translated
var localization = new Object();

localization['cs_CZ']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	txtResources: 'Prostředky',
	txtNote: 'Poznámky',

	errUnableSync: 'Chyba: \'nepodařilo se synchronizovat prostředek\': zkuste to později!',

	loadingResources: 'Načítání prostředků (%act% z %total%) ...',
	loadingCollectionList: 'Načítání zoznamu prostředků',

	txtCacheText: 'Na serveru byla nalezena aktualizace, prosím znovu načtěte stránku!',
	txtCacheButton: 'Znovu načíst'
};

localization['da_DK']=	/* thanks Niels Bo Andersen and Michael Rasmussen */
{
	txtResources: 'Ressourcer',
	txtNote: 'Note',

	errUnableSync: 'Fejl: \'kunne ikke synkronisere ressource\': prøv igen senere!',

	loadingResources: 'Henter ressourcer (%act% af %total%) ...',
	loadingCollectionList: 'Indlæser ressource listen',

	txtCacheText: 'En opdatering er klar på serveren, genindlæs derfor siden!',
	txtCacheButton: 'Genindlæs'
};

localization['de_DE']=	/* thanks Marten Gajda and Thomas Scheel */
{
	txtResources: 'Ressourcen',
	txtNote: 'Notiz',

	errUnableSync: 'Fehler: \'Ressource konnte nicht syncronisiert werden\': Versuchen Sie es später noch einmal!',

	loadingResources: 'Lade Ressourcen (%act% von %total%) ...',
	loadingCollectionList: 'Lade Ressourcenliste',

	txtCacheText: 'Auf dem Server ist ein Update verfügbar. Bitte laden Sie die Seite neu!',
	txtCacheButton: 'Seite neu laden'
};

localization['en_US']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	txtResources: 'Resources',
	txtNote: 'Note',

	errUnableSync: 'Error: \'unable to sync resource\': try again later!',

	loadingResources: 'Loading resources (%act% of %total%) ...',
	loadingCollectionList: 'Loading resource list',

	txtCacheText: 'There is an update available on the server, please reload the page!',
	txtCacheButton: 'Reload'
};

localization['es_ES']=	/* Damian Vila <damianvila@gmail.com> */
{
	txtResources: 'Recursos',
	txtNote: 'Nota',

	errUnableSync: 'Error: \'imposible sincronizar con el recurso\': inténtelo más tarde!',

	loadingResources: 'Cargando recursos (%act% de %total%) ...',
	loadingCollectionList: 'Cargando la lista de recursos',

	txtCacheText: 'Hay una actualización disponible en el servidor, por favor, recarga la página!',
	txtCacheButton: 'Recargar'
};

localization['fr_FR']=	/* thanks John Fischer and Jean-Christophe Bach */
{
	txtResources: 'Ressources',
	txtNote: 'Note',

	errUnableSync: 'Erreur : \'impossible de synchroniser la ressource\' : réessayez plus tard !',

	loadingResources: 'Chargement des ressources (%act% sur %total%)...',
	loadingCollectionList: 'Chargement de la liste des ressources',

	txtCacheText: 'Il y a une mise à jour disponible sur le serveur, veuillez recharger la page s\'il vous plaît !',
	txtCacheButton: 'Recharger'
};

localization['hu_HU']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	txtResources: 'Források',
	txtNote: 'Jegyzetek',

	errUnableSync: 'Hiba: \'nem sikerült a forrás szinkronizálása\': próbálkozzon később!',

	loadingResources: 'Források betöltése (%act%/%total%) ...',
	loadingCollectionList: 'Forrás lista betöltése',

	txtCacheText: 'Frissítés elérhető a szerveren, kérjük töltse be újra az oldalt!',
	txtCacheButton: 'Újratöltés'
};

localization['it_IT']=	/* thanks Luca Ferrario */
{
	txtResources: 'Risorse',
	txtNote: 'Note',

	errUnableSync: 'Errore: \'impossibile sincronizzare la risorsa\': riprovare!',

	loadingResources: 'Caricamento risorse (%act% di %total%) ...',
	loadingCollectionList: 'Caricamento della lista delle risorse',

	txtCacheText: 'La voce è stata aggiornata sul server, per favore ricarica la pagina!',
	txtCacheButton: 'Reload'
};

localization['ja_JP']=	/* Muimu Nakayama */
{
	txtResources: 'リソース',
	txtNote: 'メモ',

	errUnableSync: 'エラー: \'リソースと同期できません\': 後で再度試してみてください!',

	loadingResources: 'リソースを読み込み中 (%total% 個中 %act% 個) ...',
	loadingCollectionList: 'リソースリストを読み込み中',

	txtCacheText: 'サーバ上で更新があります。ページを再読み込みしてください!',
	txtCacheButton: '再読み込み'
};

localization['nb_NO']=	/* thanks Tore Ørpetveit */
{
	txtResources: 'Ressurser',
	txtNote: 'Notat',

	errUnableSync: 'Feil: \'kunne ikke synkronisere ressurs\': prøv igjen senere!',

	loadingResources: 'Henter ressurser (%act% av %total%) ...',
	loadingCollectionList: 'Leser inn ressursliste',

	txtCacheText: 'En oppdatering er klar på serveren. Last inn siden på ny!',
	txtCacheButton: 'Last inn på ny'
};

localization['nl_NL']=	/* thanks Johan Vromans */
{
	txtResources: 'Bronnen',
	txtNote: 'Opmerking',

	errUnableSync: 'Fout: Synchronisatie mislukt, probeer later nog eens!',

	loadingResources: 'Laden (%act% van %total%) ...',
	loadingCollectionList: 'Laden (Bronnenlijst) ...',

	txtCacheText: 'Er zijn updates beschikbaar op de server. Gelieve deze pagina te verversen.',
	txtCacheButton: 'Verversen'
};

localization['sk_SK']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	txtResources: 'Prostriedky',
	txtNote: 'Poznámky',

	errUnableSync: 'Chyba: \'nepodarilo sa synchronizovať prostriedok\': skúste to neskôr!',

	loadingResources: 'Načítavanie prostriedkov (%act% z %total%) ...',
	loadingCollectionList: 'Načítavanie prostriedkov',

	txtCacheText: 'Na servery bola nájdená aktualizácia, prosím znova načítajte stránku!',
	txtCacheButton: 'Znovu načítať'
};

localization['tr_TR']=	/* thanks Selcuk Pultar */
{
	txtResources: 'Kaynaklar',
	txtNote: 'Not',

	errUnableSync: 'Hata: \'kaynak eşlenememiştir\': sonra yeniden deneyin!',

	loadingResources: 'Kaynaklar yükleniyor (%total% taneden %act%) ...',
	loadingCollectionList: 'Kaynak listesi yükleniyor',

	txtCacheText: 'Sunucuda bir güncelleme mevcut, lütfen sayfayı yeniden yükleyin!',
	txtCacheButton: 'Yeniden yükle'
};

localization['ru_RU']=	/* thanks Александр Симонов */
{
	txtResources: 'Ресурсы',
	txtNote: 'Примечание',

	errUnableSync: 'Ошибка: \'невозможно синхронизировать ресурс\': попробуйте позже!',

	loadingResources: 'Загрузка ресурсов (%act% из %total%)...',
	loadingCollectionList: 'Загрузка списка ресурсов',

	txtCacheText: 'На сервере доступно обновление. Перезагрузите страницу!',
	txtCacheButton: 'Перезагрузить'
};

localization['uk_UA']=	/* Serge Yakimchuck <yakim@yakim.org.ua> */
{
	txtResources: 'Ресурси',
	txtNote: 'Примітки',

	errUnableSync: 'Помилка: \'неможливо синхронізувати ресурс\': спробуйте пізніше!',

	loadingResources: 'завантаження ресурсів (%act% з %total%) ...',
	loadingCollectionList: 'Завантаження списку ресурсів',

	txtCacheText: 'на сервері доступне оновлення, перезавантажте, будь ласка, сторінку!',
	txtCacheButton: 'Перезавантаження'
};

localization['zh_CN']=	/* thanks Fandy */
{
	txtResources: '资源',
	txtNote: '备注',

	errUnableSync: '错误: \'不能同步信息\': 请稍后重试!',

	loadingResources: '加载中，请稍等 (%act% of %total%) ...',
	loadingCollectionList: '加载中',

	txtCacheText: '服务器有更新, 请重新加载页面!',
	txtCacheButton: '刷新'
};
var localizationShared = new Object();

localizationShared['cs_CZ']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	_name_: 'Čeština',
	_default_datepicker_format_: 'dd.mm.yy',
	_default_AMPM_format_: false,

	altLogo: 'Logo',
	altLogout: 'Odhlásit',
	buttonLogin: 'Přihlásit',
	pholderUsername: 'Přihlašovací jméno',
	pholderPassword: 'Heslo',
	txtSearch: 'Hledat',
	txtError: 'Chyba',
	txtRefresh: 'Obnovit',

	buttonEdit: 'Editovat',
	buttonSave: 'Uložit',
	buttonReset: 'Reset',
	buttonCancel: 'Storno',
	buttonDelete: 'Vymazat',

	errCollectionLoad: 'Nepodařilo se uložit nastavení!',
	errHttpCommon: 'chybový kód %%',
	errHttp401: 'neautorizovaný',
	errHttp403: 'přístup zamítnut',
	errHttp405: 'nepovolená metoda',
	errHttp408: 'vypršení doby požadavku',
	errHttp412: 'někdo jiný ho právě změnil na serveru',
	errHttp500: 'vnitřní chyba serveru',
	errHttp501: 'neimplementováno',

	unsupportedBrowser: 'Upozornění: Váš prohlížeč je nepodporovaný!',
	updateNotification: '%name% %new_ver% dostupný (používáte %curr_ver%) - %url%'
};

localizationShared['da_DK']=	/* thanks Niels Bo Andersen and Michael Rasmussen */
{
	_name_: 'Dansk',
	_default_datepicker_format_: 'dd-mm-yy',
	_default_AMPM_format_: false,

	altLogo: 'Logo',
	altLogout: 'Log ud',
	buttonLogin: 'Log ind',
	pholderUsername: 'Brugernavn',
	pholderPassword: 'Kodeord',
	txtSearch: 'Søg',
	txtError: 'Fejl',
	txtRefresh: 'Opdater',

	buttonEdit: 'Rediger',
	buttonSave: 'Gem',
	buttonReset: 'Fortryd',
	buttonCancel: 'Annuller',
	buttonDelete: 'Slet',

	errCollectionLoad: 'Fejl: \'Kunne ikke gemme konfiguration\'!',
	errHttpCommon: 'fejlkode %%',
	errHttp401: 'uautoriseret',
	errHttp403: 'forbudt',
	errHttp405: 'metode ikke tilladt',
	errHttp408: 'forespørgsels-timeout',
	errHttp412: 'emnet er ændret af en anden på serveren',
	errHttp500: 'intern serverfejl',
	errHttp501: 'ikke implementeret',

	unsupportedBrowser: 'Bemærk: Din browser er ikke understøttet!',
	updateNotification: '%name% %new_ver% er frigivet (du har %curr_ver%) - %url%'
};

localizationShared['de_DE']=	/* thanks Marten Gajda and Thomas Scheel */
{
	_name_: 'Deutsch',
	_default_datepicker_format_: 'dd.mm.yy',
	_default_AMPM_format_: false,

	altLogo: 'Logo',
	altLogout: 'Abmelden',
	buttonLogin: 'Anmelden',
	pholderUsername: 'Benutzername',
	pholderPassword: 'Passwort',
	txtSearch: 'Suchen',
	txtError: 'Fehler',
	txtRefresh: 'Aktualisieren',

	buttonEdit: 'Bearbeiten',
	buttonSave: 'Speichern',
	buttonReset: 'Verwerfen',
	buttonCancel: 'Abbrechen',
	buttonDelete: 'Löschen',

	errCollectionLoad: 'Fehler: \'Einstellungen konnten nicht gespeichert werden\'!',
	errHttpCommon: 'Fehler Code %%',
	errHttp401: 'nicht berechtigt',
	errHttp403: 'verboten',
	errHttp405: 'Befehl nicht erlaubt',
	errHttp408: 'Anfrage-Timeout',
	errHttp412: 'Kontakt wurde zwischenzeitlich auf der Server geändert',
	errHttp500: 'Interner Server Fehler',
	errHttp501: 'Nicht unterstützt',

	unsupportedBrowser: 'Hinweis: Der verwendete Browser wird nicht unterstützt!',
	updateNotification: '%name% %new_ver% verfügbar (Sie haben %curr_ver%) - %url%'
};

localizationShared['en_US']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	_name_: 'English',
	_default_datepicker_format_: 'yy-mm-dd',
	_default_AMPM_format_: true,

	altLogo: 'Logo',
	altLogout: 'Logout',
	buttonLogin: 'Login',
	pholderUsername: 'Username',
	pholderPassword: 'Password',
	txtSearch: 'Search',
	txtError: 'Error',
	txtRefresh: 'Refresh',

	buttonEdit: 'Edit',
	buttonSave: 'Save',
	buttonReset: 'Revert',
	buttonCancel: 'Cancel',
	buttonDelete: 'Delete',

	errCollectionLoad: 'Error: \'unable to save settings\'!',
	errHttpCommon: 'error code %%',
	errHttp401: 'unauthorized',
	errHttp403: 'forbidden',
	errHttp405: 'method not allowed',
	errHttp408: 'request timeout',
	errHttp412: 'somebody else has already changed it on the server',
	errHttp500: 'internal server error',
	errHttp501: 'not implemented',

	unsupportedBrowser: 'Note: your browser is unsupported!',
	updateNotification: '%name% %new_ver% available (you have %curr_ver%) - %url%'
};

localizationShared['es_ES']=	/* Damian Vila <damianvila@gmail.com> */
{
	_name_: 'Español',
	_default_datepicker_format_: 'dd/mm/yy',
	_default_AMPM_format_: false,

	altLogo: 'Logo',
	altLogout: 'Desconectar',
	buttonLogin: 'Iniciar sesión',
	pholderUsername: 'Usuario',
	pholderPassword: 'Contraseña',
	txtSearch: 'Buscar',
	txtError: 'Error',
	txtRefresh: 'Refrescar',

	buttonEdit: 'Editar',
	buttonSave: 'Guardar',
	buttonReset: 'Revertir',
	buttonCancel: 'Cancelar',
	buttonDelete: 'Borrar',

	errCollectionLoad: 'Error: \'imposible guardar las configuraciones\'!',
	errHttpCommon: 'código de error %%',
	errHttp401: 'no autorizado',
	errHttp403: 'prohibido',
	errHttp405: 'método no permitido',
	errHttp408: 'petición caducada',
	errHttp412: 'alguien lo ha cambiado ya en el servidor',
	errHttp500: 'error interno de servidor',
	errHttp501: 'no implementado',

	unsupportedBrowser: 'Nota: ¡tu navegador no está soportado!',
	updateNotification: '%name% %new_ver% disponible (tu versión es %curr_ver%) - %url%'
};

localizationShared['fr_FR']=	/* thanks John Fischer and Jean-Christophe Bach */
{
	_name_: 'Français',
	_default_datepicker_format_: 'dd/mm/yy',
	_default_AMPM_format_: false,

	altLogo: 'Logo',
	altLogout: 'Déconnexion',
	buttonLogin: 'Connexion',
	pholderUsername: 'Identifiant',
	pholderPassword: 'Mot de Passe',
	txtSearch: 'Rechercher',
	txtError: 'Erreur',
	txtRefresh: 'Rafraîchir',

	buttonEdit: 'Éditer',
	buttonSave: 'Sauvegarder',
	buttonReset: 'Revenir',
	buttonCancel: 'Annuler',
	buttonDelete: 'Supprimer',

	errCollectionLoad: 'Impossible de sauvegarder les paramètres !',
	errHttpCommon: 'code d\'erreur %%',
	errHttp401: 'non autorisé',
	errHttp403: 'interdit',
	errHttp405: 'méthode non autorisée',
	errHttp408: 'expiration du délai de la requête',
	errHttp412: 'quelqu\'un d\'autre l\'a déjà modifié sur le serveur',
	errHttp500: 'erreur interne du serveur',
	errHttp501: 'non implémenté',

	unsupportedBrowser: 'Note : votre navigateur n\'est pas supporté !',
	updateNotification: '%name% %new_ver% est disponible (vous êtes actuellement en version %curr_ver%) - %url%'
};

localizationShared['hu_HU']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	_name_: 'Magyar',
	_default_datepicker_format_: 'yy.mm.dd',
	_default_AMPM_format_: false,

	altLogo: 'Logó',
	altLogout: 'Kijelentkezés',
	buttonLogin: 'Bejelentkezés',
	pholderUsername: 'Felhasználónév',
	pholderPassword: 'Jelszó',
	txtSearch: 'Keresés',
	txtError: 'Hiba',
	txtRefresh: 'Frissítés',

	buttonEdit: 'Szerkesztés',
	buttonSave: 'Mentés',
	buttonReset: 'Visszaállítás',
	buttonCancel: 'Mégse',
	buttonDelete: 'Törlés',

	errCollectionLoad: 'Hiba: \'nem sikerült elmenteni a beállításokat\'!',
	errHttpCommon: 'hiba kód %%',
	errHttp401: 'nincs hitelesítve',
	errHttp403: 'tiltva',
	errHttp405: 'nem engedélyezett módszer',
	errHttp408: 'kérelem időtúllépése',
	errHttp412: 'valaki más már megváltoztatta a szerveren',
	errHttp500: 'belső szerverhiba',
	errHttp501: 'nincs megvalósítva',

	unsupportedBrowser: 'Figyelmeztetés: A böngészője nem támogatott!',
	updateNotification: '%name% %new_ver% elérhető (jelenlegi verzió: %curr_ver%) - %url%'
};

localizationShared['it_IT']=	/* thanks Luca Ferrario */
{
	_name_: 'Italiano',
	_default_datepicker_format_: 'dd/mm/yy',
	_default_AMPM_format_: false,

	altLogo: 'Logo',
	altLogout: 'Logout',
	buttonLogin: 'Login',
	pholderUsername: 'Nome Utente',
	pholderPassword: 'Password',
	txtSearch: 'Cerca',
	txtError: 'Errore',
	txtRefresh: 'Aggiorna',

	buttonEdit: 'Modifica',
	buttonSave: 'Salva',
	buttonReset: 'Annulla',
	buttonCancel: 'Annulla',
	buttonDelete: 'Elimina',

	errCollectionLoad: 'Errore: \'impossibile salvare le impostazioni\'!',
	errHttpCommon: 'codice errore %%',
	errHttp401: 'non autorizzato',
	errHttp403: 'proibito',
	errHttp405: 'metodo non consentito',
	errHttp408: 'timeout della richiesta',
	errHttp412: 'qualcun altro l\'ha già modificato sul server',
	errHttp500: 'errore interno del server',
	errHttp501: 'non implementato',

	unsupportedBrowser: 'Attenzione: browser non supportato!',
	updateNotification: '%name% %new_ver% disponibile (versione attuale: %curr_ver%) - %url%'
};

localizationShared['ja_JP']=	/* Muimu Nakayama */
{
	_name_: '日本語',
	_default_datepicker_format_: 'yy-mm-dd',
	_default_AMPM_format_: true,

	altLogo: 'Logo',
	altLogout: 'ログアウト',
	buttonLogin: 'ログイン',
	pholderUsername: 'ユーザ名',
	pholderPassword: 'パスワード',
	txtSearch: '検索',
	txtError: 'エラー',
	txtRefresh: 'リフレッシュ',

	buttonEdit: '編集',
	buttonSave: '保存',
	buttonReset: '戻す',
	buttonCancel: 'キャンセル',
	buttonDelete: '削除',

	errCollectionLoad: 'エラー: \'設定を保存できません\'!',
	errHttpCommon: 'エラーコード %%',
	errHttp401: '認証失敗',
	errHttp403: 'アクセス不可',
	errHttp405: '許可されないメソッド',
	errHttp408: 'タイムアウト',
	errHttp412: 'サーバ上で他の人によりすでに変更済み',
	errHttp500: 'サーバ内部エラー',
	errHttp501: '実装されていません',

	unsupportedBrowser: '注意: あなたのブラウザはサポートされていません!',
	updateNotification: '%name% %new_ver% が利用できます (現在は %curr_ver%) - %url%'
};

localizationShared['nb_NO']=	/* thanks Tore Ørpetveit */
{
	_name_: 'Norsk (bokmål)',
	_default_datepicker_format_: 'dd-mm-yy',
	_default_AMPM_format_: false,

	altLogo: 'Logo',
	altLogout: 'Logg ut',
	buttonLogin: 'Logg inn',
	pholderUsername: 'Brukernavn',
	pholderPassword: 'Passord',
	txtSearch: 'Søk',
	txtError: 'Feil',
	txtRefresh: 'Oppdater',

	buttonEdit: 'Rediger',
	buttonSave: 'Lagre',
	buttonReset: 'Nullstill',
	buttonCancel: 'Avbryt',
	buttonDelete: 'Slett',

	errCollectionLoad: 'Feil: \'kunne ikke lagre innstillinger\'!',
	errHttpCommon: 'feilkode %%',
	errHttp401: 'uautorisert',
	errHttp403: 'ikke tillatt',
	errHttp405: 'metode ikke tillatt',
	errHttp408: 'timeout forespørsel',
	errHttp412: 'emnet er endret av en annen på serveren',
	errHttp500: 'intern serverfeil',
	errHttp501: 'ikke implementert',

	unsupportedBrowser: 'Merk: Nettleseren din er ikke støttet!',
	updateNotification: '%name% %new_ver% er lansert (du har %curr_ver%) - %url%'
};

localizationShared['nl_NL']=	/* thanks Johan Vromans */
{
	_name_: 'Nederlands',
	_default_datepicker_format_: 'dd-mm-yy',
	_default_AMPM_format_: false,

	altLogo: 'Logo',
	altLogout: 'Uitloggen',
	buttonLogin: 'Inloggen',
	pholderUsername: 'Gebruikersnaam',
	pholderPassword: 'Wachtwoord',
	txtSearch: 'Zoeken',
	txtError: 'Fout',
	txtRefresh: 'Herladen',

	buttonEdit: 'Wijzigen',
	buttonSave: 'Opslaan',
	buttonReset: 'Herstellen',
	buttonCancel: 'Annuleren',
	buttonDelete: 'Verwijderen',

	errCollectionLoad: 'Fout: Opslaan van de instellingen is niet gelukt!',
	errHttpCommon: 'Foutcode %%',
	errHttp401: 'geen toegang',
	errHttp403: 'verboden',
	errHttp405: 'bewerking niet toegestaan',
	errHttp408: 'verwerking afgebroken wegens timeout',
	errHttp412: 'iemand anders heeft dit reeds gewijzigd op de server',
	errHttp500: 'interne serverfout',
	errHttp501: 'niet geïmplementeerd',

	unsupportedBrowser: 'Attentie: uw browser wordt niet ondersteund!',
	updateNotification: 'Er is een nieuwe versie van %name% beschikbaar: %new_ver% (u heeft nu %curr_ver%) - %url%'
};

localizationShared['sk_SK']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	_name_: 'Slovenčina',
	_default_datepicker_format_: 'dd.mm.yy',
	_default_AMPM_format_: false,

	altLogo: 'Logo',
	altLogout: 'Odhlásiť',
	buttonLogin: 'Prihlásiť',
	pholderUsername: 'Prihlasovacie meno',
	pholderPassword: 'Heslo',
	txtSearch: 'Vyhľadať',
	txtError: 'Chyba',
	txtRefresh: 'Obnoviť',

	buttonEdit: 'Editovať',
	buttonSave: 'Uložiť',
	buttonReset: 'Reset',
	buttonCancel: 'Storno',
	buttonDelete: 'Vymazať',

	errCollectionLoad: 'Nepodarilo sa uložiť nastavenia!',
	errHttpCommon: 'chybový kód %%',
	errHttp401: 'neautorizovaný',
	errHttp403: 'prístup zamietnutý',
	errHttp405: 'nepovolená metóda',
	errHttp408: 'časový limit vypršal',
	errHttp412: 'niekto iný ho práve zmenil na serveri',
	errHttp500: 'vnútorná chyba servera',
	errHttp501: 'neimplementované',

	unsupportedBrowser: 'Upozornenie: Váš prehliadač je nepodporovaný!',
	updateNotification: '%name% %new_ver% dostupný (používate %curr_ver%) - %url%'
};

localizationShared['tr_TR']=	/* thanks Selcuk Pultar */
{
	_name_: 'Türkçe',
	_default_datepicker_format_: 'dd.mm.yy',
	_default_AMPM_format_: false,

	altLogo: 'Logo',
	altLogout: 'Çıkış',
	buttonLogin: 'Giriş',
	pholderUsername: 'Kullanıcı Adı',
	pholderPassword: 'Parola',
	txtSearch: 'Ara',
	txtError: 'Hata',
	txtRefresh: 'Yenile',

	buttonEdit: 'Düzenle',
	buttonSave: 'Kaydet',
	buttonReset: 'Geri döndür',
	buttonCancel: 'Vazgeç',
	buttonDelete: 'Sil',

	errCollectionLoad: 'Hata: \'ayarlar kaydedilemedi\'!',
	errHttpCommon: 'hata kodu %%',
	errHttp401: 'yetkisiz',
	errHttp403: 'yasak',
	errHttp405: 'metoda izin verilmemiştir',
	errHttp408: 'istek zaman aşımı',
	errHttp412: 'başkası sunucuda zaten değiştirmiş',
	errHttp500: 'dahili sunucu hatası',
	errHttp501: 'henüz uygulamaya geçirilmemiştir',

	unsupportedBrowser: 'Not: tarayıcınız desteklenmemektedir!',
	updateNotification: '%name% %new_ver% hazır (sizde %curr_ver% var) - %url%'
};

localizationShared['ru_RU']=	/* thanks Александр Симонов */
{
	_name_: 'Русский',
	_default_datepicker_format_: 'dd.mm.yy',
	_default_AMPM_format_: false,

	altLogo: 'Лого',
	altLogout: 'Выход',
	buttonLogin: 'Вход',
	pholderUsername: 'Имя',
	pholderPassword: 'Пароль',
	txtSearch: 'Поиск',
	txtError: 'Ошибка',
	txtRefresh: 'Обновить',

	buttonEdit: 'Изменить',
	buttonSave: 'Сохранить',
	buttonReset: 'Отменить',
	buttonCancel: 'Отмена',
	buttonDelete: 'Удалить',

	errCollectionLoad: 'Ошибка: \'невозможно сохранить настройки\'!',
	errHttpCommon: 'код ошибки %%',
	errHttp401: 'не авторизован',
	errHttp403: 'запрещен',
	errHttp405: 'метод не разрешен',
	errHttp408: 'таймаут запроса',
	errHttp412: 'кто-то другой уже произвел изменения на сервере',
	errHttp500: 'внутренняя ошибка сервера',
	errHttp501: 'не реализовано',

	unsupportedBrowser: 'Ваш браузер не поддерживается!',
	updateNotification: '%name% версии %new_ver% доступен (сейчас у вас версия %curr_ver%) - %url%'
};

localizationShared['uk_UA']=	/* Serge Yakimchuck <yakim@yakim.org.ua> */
{
	_name_: 'Українська',
	_default_datepicker_format_: 'dd.mm.yy',
	_default_AMPM_format_: false,

	altLogo: 'Лого',
	altLogout: 'Вийти',
	buttonLogin: 'Увійти',
	pholderUsername: 'Користувач',
	pholderPassword: 'Пароль',
	txtSearch: 'Пошук',
	txtError: 'Помилка',
	txtRefresh: 'Оновити',

	buttonEdit: 'Правити',
	buttonSave: 'Зберегти',
	buttonReset: 'Скасувати',
	buttonCancel: 'Скасувати',
	buttonDelete: 'Видалити',

	errCollectionLoad: 'Помилка: \'неможливо зберегти настройки\'!',
	errHttpCommon: 'код помилки %%',
	errHttp401: 'не авторизовано',
	errHttp403: 'заборонено',
	errHttp405: 'метод не дозволений',
	errHttp408: 'перевищено час запиту',
	errHttp412: 'хтось ще якраз це змінює на сервері',
	errHttp500: 'внутрішня помилка сервера',
	errHttp501: 'не реалізовано',

	unsupportedBrowser: 'Увага: Ваш браузер не підтримується!',
	updateNotification: '%name% %new_ver% доступна (у вас %curr_ver%) - %url%'
};

localizationShared['zh_CN']=	/* thanks Fandy */
{
	_name_: '中国',
	_default_datepicker_format_: 'yy-mm-dd',
	_default_AMPM_format_: false,

	altLogo: '图标',
	altLogout: '退出',
	buttonLogin: '登录',
	pholderUsername: '用户名',
	pholderPassword: '密码',
	txtSearch: '检索',
	txtError: '错误',
	txtRefresh: '刷新',

	buttonEdit: '编辑',
	buttonSave: '保存',
	buttonReset: '恢复',
	buttonCancel: '取消',
	buttonDelete: '删除',

	errCollectionLoad: '错误: \'不能保持设置\'!',
	errHttpCommon: '错误代码 %%',
	errHttp401: '未认证的',
	errHttp403: '禁止',
	errHttp405: '方法不被允许',
	errHttp408: '请求超时',
	errHttp412: '服务器已更新',
	errHttp500: '内部服务器错误',
	errHttp501: '未实施',

	unsupportedBrowser: '注意：您的浏览器不支持！',
	updateNotification: '%name% %new_ver% 最新版本 (你的系统当前版本 %curr_ver%) - %url%'
};

$.extend(true, localization, localizationShared);
var localizationSharedCalDAV = new Object();

localizationSharedCalDAV['cs_CZ']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	txtCalendars: 'Kalendáře',
	txtTodos: 'Připomínky',
	localTime: 'Lokální čas',
	fullCalendarMonth: 'měsíc',
	fullCalendarMultiWeek: 'mtýden',
	fullCalendarAgendaWeek: 'týden',
	fullCalendarAgendaDay: 'den',

	monthNames: ['Leden','Únor','Březen','Duben','Květen','Červen',
	'Červenec','Srpen','Září','Říjen','Listopad','Prosinec'],
	monthNamesShort: ['Led','Úno','Bře','Dub','Kvě','Čer',
	'Čvc','Srp','Zář','Říj','Lis','Pro'],
	dayNames: ['Neděle', 'Pondělí', 'Úterý', 'Středa', 'Čtvrtek', 'Pátek', 'Sobota'],
	dayNamesShort: ['Ne', 'Po', 'Út', 'St', 'Čt', 'Pá', 'So'],
	dayNamesMin: ['Ne','Po','Út','St','Čt','Pá','So']
};

localizationSharedCalDAV['da_DK']=	/* thanks Niels Bo Andersen and Michael Rasmussen */
{
	txtCalendars: 'Kalendere',
	txtTodos: 'Opgaver',
	localTime: 'Lokal tid',
	fullCalendarMonth: 'måned',
	fullCalendarMultiWeek: 'uger',
	fullCalendarAgendaWeek: 'uge',
	fullCalendarAgendaDay: 'dag',

	monthNames: ['Januar','Februar','Marts','April','Maj','Juni',
	'Juli','August','September','Oktober','November','December'],
	monthNamesShort: ['Jan', 'Feb', 'Mar', 'Apr', 'Maj', 'Jun',
	'Jul', 'Aug', 'Sep', 'Okt', 'Nov', 'Dec'],
	dayNames: ['Søndag', 'Mandag', 'Tirsdag', 'Onsdag', 'Torsdag', 'Fredag', 'Lørdag'],
	dayNamesShort: ['Søn', 'Man', 'Tir', 'Ons', 'Tor', 'Fre', 'Lør'],
	dayNamesMin: ['Sø','Ma','Ti','On','To','Fr','Lø']
};

localizationSharedCalDAV['de_DE']=	/* thanks Marten Gajda and Thomas Scheel */
{
	txtCalendars: 'Kalender',
	txtTodos: 'Aufgaben',
	localTime: 'Lokale Zeit',
	fullCalendarMonth: 'Monat',
	fullCalendarMultiWeek: 'Wochen',
	fullCalendarAgendaWeek: 'Woche',
	fullCalendarAgendaDay: 'Tag',

	monthNames: ['Januar','Februar','März','April','Mai','Juni',
	'Juli','August','September','Oktober','November','Dezember'],
	monthNamesShort: ['Jan','Feb','Mär','Apr','Mai','Jun',
	'Jul','Aug','Sep','Okt','Nov','Dez'],
	dayNames: ['Sonntag','Montag','Dienstag','Mittwoch','Donnerstag','Freitag','Samstag'],
	dayNamesShort: ['So','Mo','Di','Mi','Do','Fr','Sa'],
	dayNamesMin: ['So','Mo','Di','Mi','Do','Fr','Sa']
};

localizationSharedCalDAV['en_US']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	txtCalendars: 'Calendars',
	txtTodos: 'Todos',
	localTime: 'Local Time',
	fullCalendarMonth: 'month',
	fullCalendarMultiWeek: 'mweek',
	fullCalendarAgendaWeek: 'week',
	fullCalendarAgendaDay: 'day',

	monthNames: ['January','February','March','April','May','June',
	'July','August','September','October','November','December'],
	monthNamesShort: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',
	'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
	dayNames: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'],
	dayNamesShort: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
	dayNamesMin: ['Su','Mo','Tu','We','Th','Fr','Sa']
};

localizationSharedCalDAV['es_ES']=	/* Damian Vila <damianvila@gmail.com> */
{
	txtCalendars: 'Calendarios',
	txtTodos: 'Tareas',
	localTime: 'Tiempo local',
	fullCalendarMonth: 'mes',
	fullCalendarMultiWeek: 'msemana',
	fullCalendarAgendaWeek: 'semana',
	fullCalendarAgendaDay: 'día',

	monthNames: ['Enero','Febrero','Marzo','Abril','Mayo','Junio',
	'Julio','Agosto','Septiembre','Octubre','Noviembre','Deciembre'],
	monthNamesShort: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun',
	'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
	dayNames: ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
	dayNamesShort: ['Dom', 'Lun', 'Mar', 'Mie', 'Jue', 'Vie', 'Sáb'],
	dayNamesMin: ['D','L','M','X','J','V','S']
};

localizationSharedCalDAV['fr_FR']=	/* thanks John Fischer and Jean-Christophe Bach */
{
	txtCalendars: 'Calendriers',
	txtTodos: 'Tâches',
	localTime: 'Heure locale',
	fullCalendarMonth: 'mois',
	fullCalendarMultiWeek: 'multisem.',
	fullCalendarAgendaWeek: 'semaine',
	fullCalendarAgendaDay: 'jour',

	monthNames: ['janvier','février','mars','avril','mai','juin',
	'juillet','août','septembre','octobre','novembre','décembre'],
	monthNamesShort: ['jan', 'fév', 'mar', 'avr', 'mai', 'jun',
	'jul', 'aoû', 'sep', 'oct', 'nov', 'déc'],
	dayNames: ['dimanche', 'lundi', 'mardi', 'mercredi', 'jeudi', 'vendredi', 'samedi'],
	dayNamesShort: ['dim', 'lun', 'mar', 'mer', 'jeu', 'ven', 'sam'],
	dayNamesMin: ['di','lu','ma','me','je','ve','sa']
};

localizationSharedCalDAV['hu_HU']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	txtCalendars: 'Naptárak',
	txtTodos: 'Feladatok',
	localTime: 'Helyi idő',
	fullCalendarMonth: 'hónap',
	fullCalendarMultiWeek: 'több hét',
	fullCalendarAgendaWeek: 'hét',
	fullCalendarAgendaDay: 'nap',

	monthNames: ['Január', 'Február', 'Március', 'Április', 'Május', 'Június',
	'Július', 'Augusztus', 'Szeptember', 'Október', 'November', 'December'],
	monthNamesShort: ['Jan', 'Feb', 'Már', 'Ápr', 'Máj', 'Jún',
	'Júl', 'Aug', 'Szep', 'Okt', 'Nov', 'Dec'],
	dayNames: ['Vasárnap', 'Hétfő', 'Kedd', 'Szerda', 'Csütörtök', 'Péntek', 'Szombat'],
	dayNamesShort: ['Vas', 'Hét', 'Ked', 'Sze', 'Csü', 'Pén', 'Szo'],
	dayNamesMin: ['V', 'H', 'K', 'Sze', 'Cs', 'P', 'Szo']
};

localizationSharedCalDAV['it_IT']=	/* thanks Luca Ferrario */
{
	txtCalendars: 'Calendari',
	txtTodos: 'Attività',
	localTime: 'Ora Locale',
	fullCalendarMonth: 'mese',
	fullCalendarMultiWeek: 'msett.',
	fullCalendarAgendaWeek: 'sett.',
	fullCalendarAgendaDay: 'giorno',

	monthNames: ['Gennaio','Febbraio','Marzo','Aprile','Maggio','Giugno',
	'Luglio','Agosto','Settembre','Ottobre','Novembre','Dicembre'],
	monthNamesShort: ['Gen', 'Feb', 'Mar', 'Apr', 'Mag', 'Giu',
	'Lug', 'Ago', 'Set', 'Ott', 'Nov', 'Dic'],
	dayNames: ['Domenica', 'Lunedì', 'Martedì', 'Mercoledì', 'Giovedì', 'Venerdì', 'Sabato'],
	dayNamesShort: ['Dom', 'Lun', 'Mar', 'Mer', 'Gio', 'Ven', 'Sab'],
	dayNamesMin: ['Do','Lu','Ma','Me','Gi','Ve','Sa']
};

localizationSharedCalDAV['ja_JP']=	/* Muimu Nakayama */
{
	txtCalendars: 'カレンダー',
	txtTodos: 'ToDo',
	localTime: 'ローカルタイム',
	fullCalendarMonth: '月',
	fullCalendarMultiWeek: '複数週',
	fullCalendarAgendaWeek: '週',
	fullCalendarAgendaDay: '日',

	monthNames: ['1月','2月','3月','4月','5月','6月',
	'7月','8月','9月','10月','11月','12月'],
	monthNamesShort: ['1月','2月','3月','4月','5月','6月',
	'7月','8月','9月','10月','11月','12月'],
	dayNames: ['日曜日', '月曜日', '火曜日', '水曜日', '木曜日', '金曜日', '土曜日'],
	dayNamesShort: ['日', '月', '火', '水', '木', '金', '土'],
	dayNamesMin: ['日','月','火','水','木','金','土']
};

localizationSharedCalDAV['nb_NO']=	/* thanks Tore Ørpetveit */
{
	txtCalendars: 'Kalendere',
	txtTodos: 'Oppgaver',
	localTime: 'Lokal tid',
	fullCalendarMonth: 'måned',
	fullCalendarMultiWeek: 'uker',
	fullCalendarAgendaWeek: 'uke',
	fullCalendarAgendaDay: 'dag',

	monthNames: ['Januar','Februar','Mars','April','Mai','Juni',
	'Juli','August','September','Oktober','November','Desember'],
	monthNamesShort: ['Jan', 'Feb', 'Mar', 'Apr', 'Mai', 'Jun',
	'Jul', 'Aug', 'Sep', 'Okt', 'Nov', 'Des'],
	dayNames: ['Søndag', 'Mandag', 'Tirsdag', 'Onsdag', 'Torsdag', 'Fredag', 'Lørdag'],
	dayNamesShort: ['Søn', 'Man', 'Tir', 'Ons', 'Tor', 'Fre', 'Lør'],
	dayNamesMin: ['Sø','Ma','Ti','On','To','Fr','Lø']
};

localizationSharedCalDAV['nl_NL']=	/* thanks Johan Vromans */
{
	txtCalendars: 'Agenda’s',
	txtTodos: 'Taken',
	localTime: 'Plaatselijke tijd',
	fullCalendarMonth: 'maand',
	fullCalendarMultiWeek: 'weken',
	fullCalendarAgendaWeek: 'week',
	fullCalendarAgendaDay: 'dag',

	monthNames: ['Januari','Februari','Maart','April','Mei','Juni',
	'Juli','Augustus','September','Oktober','November','December'],
	monthNamesShort: ['Jan', 'Feb', 'Mrt', 'Apr', 'Mei', 'Jun',
	'Jul', 'Aug', 'Sep', 'Okt', 'Nov', 'Dec'],
	dayNames: ['Zondag', 'Maandag', 'Dinsdag', 'Woensdag', 'Donderdag', 'Vrijdag', 'Zaterdag'],
	dayNamesShort: ['Zon', 'Maa', 'Din', 'Woe', 'Don', 'Vrij', 'Zat'],
	dayNamesMin: ['Zo', 'Ma', 'Di', 'Wo', 'Do', 'Vr', 'Za']
};

localizationSharedCalDAV['sk_SK']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	txtCalendars: 'Kalendáre',
	txtTodos: 'Pripomienky',
	localTime: 'Lokálny čas',
	fullCalendarMonth: 'mesiac',
	fullCalendarMultiWeek: 'mtýždeň',
	fullCalendarAgendaWeek: 'týždeň',
	fullCalendarAgendaDay: 'deň',

	monthNames: ['Január','Február','Marec','Apríl','Máj','Jún',
	'Júl','August','September','Október','November','December'],
	monthNamesShort: ['Jan','Feb','Mar','Apr','Máj','Jún',
	'Júl','Aug','Sep','Okt','Nov','Dec'],
	dayNames: ['Nedeľa','Pondelok','Utorok','Streda','Štvrtok','Piatok','Sobota'],
	dayNamesShort: ['Ned','Pon','Uto','Str','Štv','Pia','Sob'],
	dayNamesMin: ['Ne','Po','Ut','St','Št','Pia','So']
};

localizationSharedCalDAV['tr_TR']=	/* thanks Selcuk Pultar */
{
	txtCalendars: 'Takvimler',
	txtTodos: 'Yapılacaklar',
	localTime: 'Yerel Saat',
	fullCalendarMonth: 'ay',
	fullCalendarMultiWeek: 'çokluhafta',
	fullCalendarAgendaWeek: 'hafta',
	fullCalendarAgendaDay: 'gün',

	monthNames: ['Ocak','Şubat','Mart','Nisan','Mayıs','Haziran',
	'Temmuz','Ağustos','Eylül','Ekim','Kasım','Aralık'],
	monthNamesShort: ['Oca', 'Şub', 'Mar', 'Nis', 'May', 'Haz',
	'Tem', 'Ağu', 'Eyl', 'Eki', 'Kas', 'Ara'],
	dayNames: ['Pazar', 'Pazartesi', 'Salı', 'Çarşamba', 'Perşembe', 'Cuma', 'Cumartesi'],
	dayNamesShort: ['Paz', 'Pts', 'Sal', 'Çar', 'Per', 'Cum', 'Cts'],
	dayNamesMin: ['Pz','Pt','Sa','Ça','Pe','Cu','Ct']
};

localizationSharedCalDAV['ru_RU']=	/* thanks Александр Симонов */
{
	txtCalendars: 'Календари',
	txtTodos: 'Задачи',
	localTime: 'Местное время',
	fullCalendarMonth: 'Шесть недель',
	fullCalendarMultiWeek: 'Три недели',
	fullCalendarAgendaWeek: 'Неделя',
	fullCalendarAgendaDay: 'День',

	monthNames: ['Январь','Февраль','Март','Апрель','Май','Июнь',
	'Июль','Август','Сентябрь','Октябрь','Ноябрь','Декабрь'],
	monthNamesShort: ['янв', 'фев', 'мар', 'апр', 'мая', 'июн',
	'июл', 'авг', 'сен', 'окт', 'ноя', 'дек'],
	dayNames: ['Воскресенье', 'Понедельник', 'Вторник', 'Среда', 'Четверг', 'Пятница', 'Суббота'],
	dayNamesShort: ['Вск', 'Пон', 'Втр', 'Срд', 'Чтв', 'Птн', 'Суб'],
	dayNamesMin: ['Вс','Пн','Вт','Ср','Чт','Пт','Сб']
};

localizationSharedCalDAV['uk_UA']=	/* Serge Yakimchuck <yakim@yakim.org.ua> */
{
	txtCalendars: 'Календарі',
	txtTodos: 'Завдання',
	localTime: 'Локальний час',
	fullCalendarMonth: 'місяць',
	fullCalendarMultiWeek: 'тижні',
	fullCalendarAgendaWeek: 'тиждень',
	fullCalendarAgendaDay: 'день',

	monthNames: ['Січень','Лютий','Березень','Квітень','Травень','Червень',
	'Липень','Серпень','Вересень','Жовтень','Листопад','Грудень'],
	monthNamesShort: ['Січ', 'Лют', 'Бер', 'Кві', 'Тра', 'Чер',
	'Лип', 'Сер', 'Вер', 'Жов', 'Лис', 'Гру'],
	dayNames: ['Неділя', 'Понеділок', 'Вівторок', 'Середа', 'Четвер', 'П\'ятниця', 'Субота'],
	dayNamesShort: ['Нед', 'Пон', 'Вівт', 'Сер', 'Чет', 'П\'ят', 'Суб'],
	dayNamesMin: ['Нд','Пн','Вт','Ср','Чт','Пт','Сб']
};

localizationSharedCalDAV['zh_CN']=	/* thanks Fandy */
{
	txtCalendars: '日程',
	txtTodos: '待办事宜',
	localTime: '本地时间',
	fullCalendarMonth: '月',
	fullCalendarMultiWeek: '三周',
	fullCalendarAgendaWeek: '周',
	fullCalendarAgendaDay: '日',

	monthNames: ['1月','2月','3月','4月','5月','6月',
	'7月','8月','9月','10月','11月','12月'],
	monthNamesShort: ['1', '2', '3', '4', '5', '6',
	'7', '8', '9', '10', '11', '12'],
	dayNames: ['星期日', '星期一', '星期二', '星期三', '星期四', '星期五', '星期六'],
	dayNamesShort: ['周日', '周一', '周二', '周三', '周四', '周五', '周六'],
	dayNamesMin: ['周日', '周一', '周二', '周三', '周四', '周五', '周六']
};

$.extend(true, localization, localizationSharedCalDAV);
var localizationSharedCardDAV = new Object();

localizationSharedCardDAV['cs_CZ']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	txtContacts: 'Kontakty',

	pholderGiven: 'Jméno',
	pholderFamily: 'Příjmení',
	pholderMiddle: 'Druhé jméno',
	pholderPrefix: 'Před jménem',
	pholderSuffix: 'Za jménem',

	txtAddressCountryAF: 'Afghánistán',
	txtAddressCountryAL: 'Albánie',
	txtAddressCountryDZ: 'Alžírsko',
	txtAddressCountryAD: 'Andorra',
	txtAddressCountryAO: 'Angola',
	txtAddressCountryAG: 'Antigua a Barbuda',
	txtAddressCountryAR: 'Argentina',
	txtAddressCountryAM: 'Arménie',
	txtAddressCountryAU: 'Austrálie',
	txtAddressCountryAT: 'Rakousko',
	txtAddressCountryAZ: 'Ázerbajdžán',
	txtAddressCountryBS: 'Bahamy',
	txtAddressCountryBH: 'Bahrajn',
	txtAddressCountryBD: 'Bangladéš',
	txtAddressCountryBB: 'Barbados',
	txtAddressCountryBY: 'Bělorusko',
	txtAddressCountryBE: 'Belgie',
	txtAddressCountryBZ: 'Belize',
	txtAddressCountryBJ: 'Benin',
	txtAddressCountryBM: 'Bermudy',
	txtAddressCountryBT: 'Bhútán',
	txtAddressCountryBO: 'Bolívie',
	txtAddressCountryBA: 'Bosna a Hercegovina',
	txtAddressCountryBW: 'Botswana',
	txtAddressCountryBR: 'Brazílie',
	txtAddressCountryBN: 'Brunej',
	txtAddressCountryBG: 'Bulharsko',
	txtAddressCountryBF: 'Burkina Faso',
	txtAddressCountryBI: 'Burundi',
	txtAddressCountryKH: 'Kambodža',
	txtAddressCountryCM: 'Kamerun',
	txtAddressCountryCA: 'Kanada',
	txtAddressCountryCV: 'Kapverdy',
	txtAddressCountryKY: 'Kajmanské ostrovy',
	txtAddressCountryCF: 'Středoafrická republika',
	txtAddressCountryTD: 'Čad',
	txtAddressCountryCL: 'Chile',
	txtAddressCountryCN: 'Čína',
	txtAddressCountryCO: 'Kolumbie',
	txtAddressCountryKM: 'Komory',
	txtAddressCountryCD: 'Demokratická republika Kongo',
	txtAddressCountryCG: 'Kongo - Brazzaville',
	txtAddressCountryCR: 'Kostarika',
	txtAddressCountryCI: 'Pobřeží slonoviny',
	txtAddressCountryHR: 'Chorvatsko',
	txtAddressCountryCU: 'Kuba',
	txtAddressCountryCY: 'Kypr',
	txtAddressCountryCZ: 'Česká republika',
	txtAddressCountryDK: 'Dánsko',
	txtAddressCountryDJ: 'Džibutsko',
	txtAddressCountryDM: 'Dominika',
	txtAddressCountryDO: 'Dominikánská republika',
	txtAddressCountryEC: 'Ekvádor',
	txtAddressCountryEG: 'Egypt',
	txtAddressCountrySV: 'El Salvador',
	txtAddressCountryGQ: 'Rovníková Guinea',
	txtAddressCountryER: 'Eritrea',
	txtAddressCountryEE: 'Estonsko',
	txtAddressCountryET: 'Etiopie',
	txtAddressCountryFK: 'Falklandské ostrovy',
	txtAddressCountryFO: 'Faerské ostrovy',
	txtAddressCountryFJ: 'Fidži',
	txtAddressCountryFI: 'Finsko',
	txtAddressCountryFR: 'Francie',
	txtAddressCountryPF: 'Francouzská Polynésie',
	txtAddressCountryGA: 'Gabon',
	txtAddressCountryGM: 'Gambie',
	txtAddressCountryGE: 'Gruzie',
	txtAddressCountryDE: 'Německo',
	txtAddressCountryGH: 'Ghana',
	txtAddressCountryGR: 'Řecko',
	txtAddressCountryGL: 'Grónsko',
	txtAddressCountryGD: 'Grenada',
	txtAddressCountryGP: 'Guadeloupe',
	txtAddressCountryGT: 'Guatemala',
	txtAddressCountryGN: 'Rovníková Guinea',
	txtAddressCountryGW: 'Guinea-Bissau',
	txtAddressCountryGY: 'Guyana',
	txtAddressCountryHT: 'Haiti',
	txtAddressCountryHN: 'Honduras',
	txtAddressCountryHK: 'Hongkong',
	txtAddressCountryHU: 'Maďarsko',
	txtAddressCountryIS: 'Island',
	txtAddressCountryIN: 'Indie',
	txtAddressCountryID: 'Indonésie',
	txtAddressCountryIR: 'Írán',
	txtAddressCountryIQ: 'Irák',
	txtAddressCountryIE: 'Irsko',
	txtAddressCountryIM: 'Ostrov Man',
	txtAddressCountryIL: 'Izrael',
	txtAddressCountryIT: 'Itálie',
	txtAddressCountryJM: 'Jamajka',
	txtAddressCountryJP: 'Japonsko',
	txtAddressCountryJO: 'Jordánsko',
	txtAddressCountryKZ: 'Kazachstán',
	txtAddressCountryKE: 'Keňa',
	txtAddressCountryKI: 'Kiribati',
	txtAddressCountryKP: 'Severní Korea',
	txtAddressCountryKR: 'Jižní Korea',
	txtAddressCountryKW: 'Kuvajt',
	txtAddressCountryKG: 'Kyrgyzstán',
	txtAddressCountryLA: 'Laos',
	txtAddressCountryLV: 'Lotyšsko',
	txtAddressCountryLB: 'Libanon',
	txtAddressCountryLS: 'Lesotho',
	txtAddressCountryLR: 'Libérie',
	txtAddressCountryLY: 'Libye',
	txtAddressCountryLI: 'Lichtenštejnsko',
	txtAddressCountryLT: 'Litva',
	txtAddressCountryLU: 'Lucembursko',
	txtAddressCountryMO: 'Macao',
	txtAddressCountryMK: 'Makedonie',
	txtAddressCountryMG: 'Madagaskar',
	txtAddressCountryMW: 'Malawi',
	txtAddressCountryMY: 'Malajsie',
	txtAddressCountryMV: 'Maledivy',
	txtAddressCountryML: 'Mali',
	txtAddressCountryMT: 'Malta',
	txtAddressCountryMH: 'Marshallovy ostrovy',
	txtAddressCountryMQ: 'Martinik',
	txtAddressCountryMR: 'Mauretánie',
	txtAddressCountryMU: 'Mauricius',
	txtAddressCountryMX: 'Mexiko',
	txtAddressCountryFM: 'Mikronésie',
	txtAddressCountryMD: 'Moldavsko',
	txtAddressCountryMC: 'Monako',
	txtAddressCountryMN: 'Mongolsko',
	txtAddressCountryME: 'Černá hora',
	txtAddressCountryMA: 'Maroko',
	txtAddressCountryMZ: 'Mozambik',
	txtAddressCountryMM: 'Myanmar',
	txtAddressCountryNA: 'Namibie',
	txtAddressCountryNR: 'Nauru',
	txtAddressCountryNP: 'Nepál',
	txtAddressCountryNL: 'Nizozemsko',
	txtAddressCountryNC: 'Nová Kaledonie',
	txtAddressCountryNZ: 'Nový Zéland',
	txtAddressCountryNI: 'Nikaragua',
	txtAddressCountryNE: 'Niger',
	txtAddressCountryNG: 'Nigérie',
	txtAddressCountryNO: 'Norsko',
	txtAddressCountryOM: 'Omán',
	txtAddressCountryPK: 'Pákistán',
	txtAddressCountryPW: 'Palau',
	txtAddressCountryPS: 'Palestinská autonomie',
	txtAddressCountryPA: 'Panama',
	txtAddressCountryPG: 'Papua-Nová Guinea',
	txtAddressCountryPY: 'Paraguay',
	txtAddressCountryPE: 'Peru',
	txtAddressCountryPH: 'Filipíny',
	txtAddressCountryPL: 'Polsko',
	txtAddressCountryPT: 'Portugalsko',
	txtAddressCountryPR: 'Portoriko',
	txtAddressCountryQA: 'Katar',
	txtAddressCountryRE: 'Réunion',
	txtAddressCountryRO: 'Rumunsko',
	txtAddressCountryRU: 'Rusko',
	txtAddressCountryRW: 'Rwanda',
	txtAddressCountryBL: 'Svatý Bartoloměj',
	txtAddressCountrySH: 'Svatá Helena',
	txtAddressCountryKN: 'Svatý Kryštof and Nevis',
	txtAddressCountryLC: 'Svatá Lucie',
	txtAddressCountryMF: 'Svatý Martin',
	txtAddressCountryVC: 'Svatý Vincenc a Grenadiny',
	txtAddressCountryWS: 'Samoa',
	txtAddressCountrySM: 'San Marino',
	txtAddressCountryST: 'Svatý Tomáš a Princův ostrov',
	txtAddressCountrySA: 'Saúdská Arábie',
	txtAddressCountrySN: 'Senegal',
	txtAddressCountryRS: 'Srbsko',
	txtAddressCountrySC: 'Seychely',
	txtAddressCountrySL: 'Sierra Leone',
	txtAddressCountrySG: 'Singapur',
	txtAddressCountrySK: 'Slovensko',
	txtAddressCountrySI: 'Slovinsko',
	txtAddressCountrySB: 'Šalamounovy ostrovy',
	txtAddressCountrySO: 'Somálsko',
	txtAddressCountryZA: 'Jihoafrická republika',
	txtAddressCountryGS: 'Jižní Georgie a Jižní Sandwichovy ostrovy',
	txtAddressCountryES: 'Španělsko',
	txtAddressCountryLK: 'Šrí Lanka',
	txtAddressCountrySD: 'Súdán',
	txtAddressCountrySR: 'Surinam',
	txtAddressCountrySZ: 'Svazijsko',
	txtAddressCountrySE: 'Švédsko',
	txtAddressCountryCH: 'Švýcarsko',
	txtAddressCountrySY: 'Sýrie',
	txtAddressCountryTW: 'Tchaj-wan',
	txtAddressCountryTJ: 'Tádžikistán',
	txtAddressCountryTZ: 'Tanzanie',
	txtAddressCountryTH: 'Thajsko',
	txtAddressCountryTL: 'Východní Timor',
	txtAddressCountryTG: 'Togo',
	txtAddressCountryTO: 'Tonga',
	txtAddressCountryTT: 'Trinidad a Tobago',
	txtAddressCountryTN: 'Tunisko',
	txtAddressCountryTR: 'Turecko',
	txtAddressCountryTM: 'Turkmenistán',
	txtAddressCountryTV: 'Tuvalu',
	txtAddressCountryVI: 'Panenské ostrovy (USA)',
	txtAddressCountryUG: 'Uganda',
	txtAddressCountryUA: 'Ukrajina',
	txtAddressCountryAE: 'Spojené arabské emiráty',
	txtAddressCountryGB: 'Velká Británie',
	txtAddressCountryUS: 'Spojené štáty',
	txtAddressCountryUY: 'Uruguay',
	txtAddressCountryUZ: 'Uzbekistán',
	txtAddressCountryVU: 'Vanuatu',
	txtAddressCountryVA: 'Vatikán',
	txtAddressCountryVE: 'Venezuela',
	txtAddressCountryVN: 'Vietnam',
	txtAddressCountryYE: 'Jemen',
	txtAddressCountryZM: 'Zambie',
	txtAddressCountryZW: 'Zimbabwe'
};

localizationSharedCardDAV['da_DK']=	/* thanks Niels Bo Andersen and Michael Rasmussen */
{
	txtContacts: 'Kontakter',

	pholderGiven: 'Fornavn',
	pholderFamily: 'Efternavn',
	pholderMiddle: 'Mellemnavn',
	pholderNickname: 'Kaldenavn',
	pholderPrefix: 'Præfiks',
	pholderSuffix: 'Suffiks',

	txtAddressCountryAF: 'Afghanistan',
	txtAddressCountryAL: 'Albanien',
	txtAddressCountryDZ: 'Algeriet',
	txtAddressCountryAD: 'Andorra',
	txtAddressCountryAO: 'Angola',
	txtAddressCountryAG: 'Antigua og Barbuda',
	txtAddressCountryAR: 'Argentina',
	txtAddressCountryAM: 'Armenien',
	txtAddressCountryAU: 'Australien',
	txtAddressCountryAT: 'Østrig',
	txtAddressCountryAZ: 'Aserbajdsjan',
	txtAddressCountryBS: 'Bahamas',
	txtAddressCountryBH: 'Bahrain',
	txtAddressCountryBD: 'Bangladesh',
	txtAddressCountryBB: 'Barbados',
	txtAddressCountryBY: 'Belarus',
	txtAddressCountryBE: 'Belgien',
	txtAddressCountryBZ: 'Belize',
	txtAddressCountryBJ: 'Benin',
	txtAddressCountryBM: 'Bermuda',
	txtAddressCountryBT: 'Bhutan',
	txtAddressCountryBO: 'Bolivia',
	txtAddressCountryBA: 'Bosnien og Hercegovina',
	txtAddressCountryBW: 'Botswana',
	txtAddressCountryBR: 'Brasilien',
	txtAddressCountryBN: 'Brunei',
	txtAddressCountryBG: 'Bulgarien',
	txtAddressCountryBF: 'Burkina Faso',
	txtAddressCountryBI: 'Burundi',
	txtAddressCountryKH: 'Cambodja',
	txtAddressCountryCM: 'Cameroun',
	txtAddressCountryCA: 'Canada',
	txtAddressCountryCV: 'Kap Verde',
	txtAddressCountryKY: 'Cayman Islands',
	txtAddressCountryCF: 'Centralafrikanske Republik',
	txtAddressCountryTD: 'Tchad',
	txtAddressCountryCL: 'Chile',
	txtAddressCountryCN: 'Kina',
	txtAddressCountryCO: 'Colombia',
	txtAddressCountryKM: 'Comorerne',
	txtAddressCountryCD: 'Den Demokratiske Republik Congo',
	txtAddressCountryCG: 'Republik Congo',
	txtAddressCountryCR: 'Costa Rica',
	txtAddressCountryCI: 'Elfenbenskysten',
	txtAddressCountryHR: 'Kroatien',
	txtAddressCountryCU: 'Cuba',
	txtAddressCountryCY: 'Cypern',
	txtAddressCountryCZ: 'Den Tjekkiske Republik',
	txtAddressCountryDK: 'Danmark',
	txtAddressCountryDJ: 'Djibouti',
	txtAddressCountryDM: 'Dominica',
	txtAddressCountryDO: 'Den Dominikanske Republik',
	txtAddressCountryEC: 'Ecuador',
	txtAddressCountryEG: 'Egypten',
	txtAddressCountrySV: 'El Salvador',
	txtAddressCountryGQ: 'Ækvatorial Guinea',
	txtAddressCountryER: 'Eritrea',
	txtAddressCountryEE: 'Estland',
	txtAddressCountryET: 'Etiopien',
	txtAddressCountryFK: 'Falklandsøerne',
	txtAddressCountryFO: 'Færøerne',
	txtAddressCountryFJ: 'Fiji',
	txtAddressCountryFI: 'Finland',
	txtAddressCountryFR: 'Frankrig',
	txtAddressCountryPF: 'Fransk Polynesien',
	txtAddressCountryGA: 'Gabon',
	txtAddressCountryGM: 'Gambia',
	txtAddressCountryGE: 'Georgien',
	txtAddressCountryDE: 'Tyskland',
	txtAddressCountryGH: 'Ghana',
	txtAddressCountryGR: 'Grækenland',
	txtAddressCountryGL: 'Grønland',
	txtAddressCountryGD: 'Grenada',
	txtAddressCountryGP: 'Guadeloupe',
	txtAddressCountryGT: 'Guatemala',
	txtAddressCountryGN: 'Guinea',
	txtAddressCountryGW: 'Guinea-Bissau',
	txtAddressCountryGY: 'Guyana',
	txtAddressCountryHT: 'Haiti',
	txtAddressCountryHN: 'Honduras',
	txtAddressCountryHK: 'Hong Kong',
	txtAddressCountryHU: 'Ungarn',
	txtAddressCountryIS: 'Island',
	txtAddressCountryIN: 'Indien',
	txtAddressCountryID: 'Indonesien',
	txtAddressCountryIR: 'Iran',
	txtAddressCountryIQ: 'Irak',
	txtAddressCountryIE: 'Irland',
	txtAddressCountryIM: 'Isle of Man',
	txtAddressCountryIL: 'Israel',
	txtAddressCountryIT: 'Italien',
	txtAddressCountryJM: 'Jamaica',
	txtAddressCountryJP: 'Japan',
	txtAddressCountryJO: 'Jordan',
	txtAddressCountryKZ: 'Kasakhstan',
	txtAddressCountryKE: 'Kenya',
	txtAddressCountryKI: 'Kiribati',
	txtAddressCountryKP: 'Nordkorea',
	txtAddressCountryKR: 'Sydkorea',
	txtAddressCountryKW: 'Kuwait',
	txtAddressCountryKG: 'Kirgisistan',
	txtAddressCountryLA: 'Laos',
	txtAddressCountryLV: 'Letland',
	txtAddressCountryLB: 'Libanon',
	txtAddressCountryLS: 'Lesotho',
	txtAddressCountryLR: 'Liberia',
	txtAddressCountryLY: 'Libyen',
	txtAddressCountryLI: 'Liechtenstein',
	txtAddressCountryLT: 'Litauen',
	txtAddressCountryLU: 'Luxembourg',
	txtAddressCountryMO: 'Macao',
	txtAddressCountryMK: 'Makedonien',
	txtAddressCountryMG: 'Madagaskar',
	txtAddressCountryMW: 'Malawi',
	txtAddressCountryMY: 'Malaysia',
	txtAddressCountryMV: 'Maldiverne',
	txtAddressCountryML: 'Mali',
	txtAddressCountryMT: 'Malta',
	txtAddressCountryMH: 'Marshalløerne',
	txtAddressCountryMQ: 'Martinique',
	txtAddressCountryMR: 'Mauretanien',
	txtAddressCountryMU: 'Mauritius',
	txtAddressCountryMX: 'Mexico',
	txtAddressCountryFM: 'Mikronesien',
	txtAddressCountryMD: 'Moldova',
	txtAddressCountryMC: 'Monaco',
	txtAddressCountryMN: 'Mongoliet',
	txtAddressCountryME: 'Montenegro',
	txtAddressCountryMA: 'Marokko',
	txtAddressCountryMZ: 'Mozambique',
	txtAddressCountryMM: 'Myanmar',
	txtAddressCountryNA: 'Namibia',
	txtAddressCountryNR: 'Nauru',
	txtAddressCountryNP: 'Nepal',
	txtAddressCountryNL: 'Holland',
	txtAddressCountryNC: 'Ny Kaledonien',
	txtAddressCountryNZ: 'New Zealand',
	txtAddressCountryNI: 'Nicaragua',
	txtAddressCountryNE: 'Niger',
	txtAddressCountryNG: 'Nigeria',
	txtAddressCountryNO: 'Norge',
	txtAddressCountryOM: 'Oman',
	txtAddressCountryPK: 'Pakistan',
	txtAddressCountryPW: 'Palau',
	txtAddressCountryPS: 'Palæstinensiske områder',
	txtAddressCountryPA: 'Panama',
	txtAddressCountryPG: 'Papua Ny Guinea',
	txtAddressCountryPY: 'Paraguay',
	txtAddressCountryPE: 'Peru',
	txtAddressCountryPH: 'Filippinerne',
	txtAddressCountryPL: 'Polen',
	txtAddressCountryPT: 'Portugal',
	txtAddressCountryPR: 'Puerto Rico',
	txtAddressCountryQA: 'Qatar',
	txtAddressCountryRE: 'Réunion',
	txtAddressCountryRO: 'Rumænien',
	txtAddressCountryRU: 'Rusland',
	txtAddressCountryRW: 'Rwanda',
	txtAddressCountryBL: 'Saint-Barthélemy',
	txtAddressCountrySH: 'Saint Helena',
	txtAddressCountryKN: 'Saint Kitts og Nevis',
	txtAddressCountryLC: 'Saint Lucia',
	txtAddressCountryMF: 'Saint Martin',
	txtAddressCountryVC: 'Saint Vincent og Grenadinerne',
	txtAddressCountryWS: 'Samoa',
	txtAddressCountrySM: 'San Marino',
	txtAddressCountryST: 'Sao Tome og Principe',
	txtAddressCountrySA: 'Saudi-Arabien',
	txtAddressCountrySN: 'Senegal',
	txtAddressCountryRS: 'Serbien',
	txtAddressCountrySC: 'Seychellerne',
	txtAddressCountrySL: 'Sierra Leone',
	txtAddressCountrySG: 'Singapore',
	txtAddressCountrySK: 'Slovakiske Republik',
	txtAddressCountrySI: 'Slovenien',
	txtAddressCountrySB: 'Salomonøerne',
	txtAddressCountrySO: 'Somalia',
	txtAddressCountryZA: 'Sydafrika',
	txtAddressCountryGS: 'South Georgia og De Sydlige Sandwichøer',
	txtAddressCountryES: 'Spanien',
	txtAddressCountryLK: 'Sri Lanka',
	txtAddressCountrySD: 'Sudan',
	txtAddressCountrySR: 'Surinam',
	txtAddressCountrySZ: 'Swaziland',
	txtAddressCountrySE: 'Sverige',
	txtAddressCountryCH: 'Schweiz',
	txtAddressCountrySY: 'Syrien',
	txtAddressCountryTW: 'Taiwan',
	txtAddressCountryTJ: 'Tadsjikistan',
	txtAddressCountryTZ: 'Tanzania',
	txtAddressCountryTH: 'Thailand',
	txtAddressCountryTL: 'Timor-Leste',
	txtAddressCountryTG: 'Togo',
	txtAddressCountryTO: 'Tonga',
	txtAddressCountryTT: 'Trinidad og Tobago',
	txtAddressCountryTN: 'Tunesien',
	txtAddressCountryTR: 'Tyrkiet',
	txtAddressCountryTM: 'Turkmenistan',
	txtAddressCountryTV: 'Tuvalu',
	txtAddressCountryVI: 'Jomfruøerne',
	txtAddressCountryUG: 'Uganda',
	txtAddressCountryUA: 'Ukraine',
	txtAddressCountryAE: 'De Forenede Arabiske Emirater',
	txtAddressCountryGB: 'Storbritannien',
	txtAddressCountryUS: 'USA',
	txtAddressCountryUY: 'Uruguay',
	txtAddressCountryUZ: 'Usbekistan',
	txtAddressCountryVU: 'Vanuatu',
	txtAddressCountryVA: 'Vatikanet',
	txtAddressCountryVE: 'Venezuela',
	txtAddressCountryVN: 'Vietnam',
	txtAddressCountryYE: 'Yemen',
	txtAddressCountryZM: 'Zambia',
	txtAddressCountryZW: 'Zimbabwe'
};

localizationSharedCardDAV['de_DE']=	/* thanks Marten Gajda and Thomas Scheel */
{
	txtContacts: 'Kontakte',

	pholderGiven: 'Vorname',
	pholderFamily: 'Nachname',
	pholderMiddle: 'Weitere Vornamen',
	pholderNickname: 'Spitzname',
	pholderPrefix: 'Titel',
	pholderSuffix: 'Namenszusatz',

	txtAddressCountryAF: 'Afghanistan',
	txtAddressCountryAL: 'Albanien',
	txtAddressCountryDZ: 'Algerien',
	txtAddressCountryAD: 'Andorra',
	txtAddressCountryAO: 'Angola',
	txtAddressCountryAG: 'Antigua und Barbuda',
	txtAddressCountryAR: 'Argentinien',
	txtAddressCountryAM: 'Armenien',
	txtAddressCountryAU: 'Australien',
	txtAddressCountryAT: 'Österreich',
	txtAddressCountryAZ: 'Aserbaidschan',
	txtAddressCountryBS: 'Bahamas',
	txtAddressCountryBH: 'Bahrain',
	txtAddressCountryBD: 'Bangladesch',
	txtAddressCountryBB: 'Barbados',
	txtAddressCountryBY: 'Weißussland',
	txtAddressCountryBE: 'Belgien',
	txtAddressCountryBZ: 'Belize',
	txtAddressCountryBJ: 'Benin',
	txtAddressCountryBM: 'Bermuda',
	txtAddressCountryBT: 'Bhutan',
	txtAddressCountryBO: 'Bolivien',
	txtAddressCountryBA: 'Bosnien-Herzegowina',
	txtAddressCountryBW: 'Botsuana',
	txtAddressCountryBR: 'Brasilen',
	txtAddressCountryBN: 'Brunei Darussalam',
	txtAddressCountryBG: 'Bulgarien',
	txtAddressCountryBF: 'Burkina Faso',
	txtAddressCountryBI: 'Burundi',
	txtAddressCountryKH: 'Kambodscha',
	txtAddressCountryCM: 'Kamerun',
	txtAddressCountryCA: 'Kanada',
	txtAddressCountryCV: 'Kap Verde',
	txtAddressCountryKY: 'Kaimaninseln',
	txtAddressCountryCF: 'Zentralafrikanische Republik',
	txtAddressCountryTD: 'Tschad',
	txtAddressCountryCL: 'Chile',
	txtAddressCountryCN: 'China',
	txtAddressCountryCO: 'Kolumbien',
	txtAddressCountryKM: 'Komoren',
	txtAddressCountryCD: 'Demokratische Republik Kongo',
	txtAddressCountryCG: 'Kongo',
	txtAddressCountryCR: 'Costa Rica',
	txtAddressCountryCI: 'Côte d’Ivoire',
	txtAddressCountryHR: 'Kroatien',
	txtAddressCountryCU: 'Kuba',
	txtAddressCountryCY: 'Zypern',
	txtAddressCountryCZ: 'Tschechische Republik',
	txtAddressCountryDK: 'Dänemark',
	txtAddressCountryDJ: 'Dschibuti',
	txtAddressCountryDM: 'Dominica',
	txtAddressCountryDO: 'Dominikanische Republik',
	txtAddressCountryEC: 'Ecuador',
	txtAddressCountryEG: 'Ägypten',
	txtAddressCountrySV: 'El Salvador',
	txtAddressCountryGQ: 'Äquatorialguinea',
	txtAddressCountryER: 'Eritrea',
	txtAddressCountryEE: 'Estland',
	txtAddressCountryET: 'Äthiopien',
	txtAddressCountryFK: 'Falklandinseln',
	txtAddressCountryFO: 'Färöer',
	txtAddressCountryFJ: 'Fidschi',
	txtAddressCountryFI: 'Finnland',
	txtAddressCountryFR: 'Frankreich',
	txtAddressCountryPF: 'Französisch-Polynesien',
	txtAddressCountryGA: 'Gabun',
	txtAddressCountryGM: 'Gambia',
	txtAddressCountryGE: 'Georgien',
	txtAddressCountryDE: 'Deutschland',
	txtAddressCountryGH: 'Ghana',
	txtAddressCountryGR: 'Griechenland',
	txtAddressCountryGL: 'Grönland',
	txtAddressCountryGD: 'Grenada',
	txtAddressCountryGP: 'Guadeloupe',
	txtAddressCountryGT: 'Guatemala',
	txtAddressCountryGN: 'Guinea',
	txtAddressCountryGW: 'Guinea-Bissau',
	txtAddressCountryGY: 'Guyana',
	txtAddressCountryHT: 'Haiti',
	txtAddressCountryHN: 'Honduras',
	txtAddressCountryHK: 'Hong Kong',
	txtAddressCountryHU: 'Ungarn',
	txtAddressCountryIS: 'Island',
	txtAddressCountryIN: 'Indien',
	txtAddressCountryID: 'Indonesien',
	txtAddressCountryIR: 'Iran',
	txtAddressCountryIQ: 'Irak',
	txtAddressCountryIE: 'Irland',
	txtAddressCountryIM: 'Isle of Man',
	txtAddressCountryIL: 'Israel',
	txtAddressCountryIT: 'Italien',
	txtAddressCountryJM: 'Jamaika',
	txtAddressCountryJP: 'Japan',
	txtAddressCountryJO: 'Jordanien',
	txtAddressCountryKZ: 'Kasachstan',
	txtAddressCountryKE: 'Kenya',
	txtAddressCountryKI: 'Kiribati',
	txtAddressCountryKP: 'Nordkorea',
	txtAddressCountryKR: 'Südkorea',
	txtAddressCountryKW: 'Kuwait',
	txtAddressCountryKG: 'Kirgisistan',
	txtAddressCountryLA: 'Laos',
	txtAddressCountryLV: 'Lettland',
	txtAddressCountryLB: 'Libanon',
	txtAddressCountryLS: 'Lesotho',
	txtAddressCountryLR: 'Liberia',
	txtAddressCountryLY: 'Libyen',
	txtAddressCountryLI: 'Liechtenstein',
	txtAddressCountryLT: 'Litauen',
	txtAddressCountryLU: 'Luxemburg',
	txtAddressCountryMO: 'Macau',
	txtAddressCountryMK: 'Mazedonien',
	txtAddressCountryMG: 'Madagaskar',
	txtAddressCountryMW: 'Malawi',
	txtAddressCountryMY: 'Malaysia',
	txtAddressCountryMV: 'Malediven',
	txtAddressCountryML: 'Mali',
	txtAddressCountryMT: 'Malta',
	txtAddressCountryMH: 'Marshallinseln',
	txtAddressCountryMQ: 'Martinique',
	txtAddressCountryMR: 'Mauretanien',
	txtAddressCountryMU: 'Mauritius',
	txtAddressCountryMX: 'Mexiko',
	txtAddressCountryFM: 'Mikronesien',
	txtAddressCountryMD: 'Moldawien',
	txtAddressCountryMC: 'Monaco',
	txtAddressCountryMN: 'Mongolei',
	txtAddressCountryME: 'Montenegro',
	txtAddressCountryMA: 'Marokko',
	txtAddressCountryMZ: 'Mosambik',
	txtAddressCountryMM: 'Myanmar',
	txtAddressCountryNA: 'Namibia',
	txtAddressCountryNR: 'Nauru',
	txtAddressCountryNP: 'Nepal',
	txtAddressCountryNL: 'Niederlande',
	txtAddressCountryNC: 'Neukaledonien',
	txtAddressCountryNZ: 'Neuseeland',
	txtAddressCountryNI: 'Nicaragua',
	txtAddressCountryNE: 'Niger',
	txtAddressCountryNG: 'Nigeria',
	txtAddressCountryNO: 'Norwegen',
	txtAddressCountryOM: 'Oman',
	txtAddressCountryPK: 'Pakistan',
	txtAddressCountryPW: 'Palau',
	txtAddressCountryPS: 'Palestinensische Autonomiegebiete',
	txtAddressCountryPA: 'Panama',
	txtAddressCountryPG: 'Papua-Neuguinea',
	txtAddressCountryPY: 'Paraguay',
	txtAddressCountryPE: 'Peru',
	txtAddressCountryPH: 'Philippinen',
	txtAddressCountryPL: 'Polen',
	txtAddressCountryPT: 'Portugal',
	txtAddressCountryPR: 'Puerto Rico',
	txtAddressCountryQA: 'Katar',
	txtAddressCountryRE: 'Réunion',
	txtAddressCountryRO: 'Rumänien',
	txtAddressCountryRU: 'Russische Förderation',
	txtAddressCountryRW: 'Ruanda',
	txtAddressCountryBL: 'St. Barthélemy',
	txtAddressCountrySH: 'St. Helena',
	txtAddressCountryKN: 'St. Kitts and Nevis',
	txtAddressCountryLC: 'St. Lucia',
	txtAddressCountryMF: 'St. Martin',
	txtAddressCountryVC: 'St. Vincent und die Grenadinen',
	txtAddressCountryWS: 'Samoa',
	txtAddressCountrySM: 'San Marino',
	txtAddressCountryST: 'São Tomé und Príncipe',
	txtAddressCountrySA: 'Saudi-Arabien',
	txtAddressCountrySN: 'Senegal',
	txtAddressCountryRS: 'Serbien',
	txtAddressCountrySC: 'Seychellen',
	txtAddressCountrySL: 'Sierra Leone',
	txtAddressCountrySG: 'Singapur',
	txtAddressCountrySK: 'Slowakei',
	txtAddressCountrySI: 'Slovenien',
	txtAddressCountrySB: 'Salomonen',
	txtAddressCountrySO: 'Somalia',
	txtAddressCountryZA: 'Südafrica',
	txtAddressCountryGS: 'Südgeorgien und die südlichen Sandwichinseln',
	txtAddressCountryES: 'Spanien',
	txtAddressCountryLK: 'Sri Lanka',
	txtAddressCountrySD: 'Sudan',
	txtAddressCountrySR: 'Suriname',
	txtAddressCountrySZ: 'Swasiland',
	txtAddressCountrySE: 'Schweden',
	txtAddressCountryCH: 'Schweiz',
	txtAddressCountrySY: 'Syrien',
	txtAddressCountryTW: 'Taiwan',
	txtAddressCountryTJ: 'Tadschikistan',
	txtAddressCountryTZ: 'Tansania',
	txtAddressCountryTH: 'Thailand',
	txtAddressCountryTL: 'Timor-Leste',
	txtAddressCountryTG: 'Togo',
	txtAddressCountryTO: 'Tonga',
	txtAddressCountryTT: 'Trinidad and Tobago',
	txtAddressCountryTN: 'Tunesien',
	txtAddressCountryTR: 'Türkei',
	txtAddressCountryTM: 'Turkmenistan',
	txtAddressCountryTV: 'Tuvalu',
	txtAddressCountryVI: 'Amerikanische Jungferninseln',
	txtAddressCountryUG: 'Uganda',
	txtAddressCountryUA: 'Ukraine',
	txtAddressCountryAE: 'Vereinigte Arabische Emirate',
	txtAddressCountryGB: 'Vereinigtes Königreich',
	txtAddressCountryUS: 'Vereinigte Staaten',
	txtAddressCountryUY: 'Uruguay',
	txtAddressCountryUZ: 'Usbekistan',
	txtAddressCountryVU: 'Vanuatu',
	txtAddressCountryVA: 'Vatikanstadt',
	txtAddressCountryVE: 'Venezuela',
	txtAddressCountryVN: 'Vietnam',
	txtAddressCountryYE: 'Jemen',
	txtAddressCountryZM: 'Sambia',
	txtAddressCountryZW: 'Simbabwe'
};

localizationSharedCardDAV['en_US']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	txtContacts: 'Contacts',

	pholderGiven: 'FirstName',
	pholderFamily: 'LastName',
	pholderMiddle: 'MiddleName',
	pholderPrefix: 'Prefix',
	pholderSuffix: 'Suffix',

	txtAddressCountryAF: 'Afghanistan',
	txtAddressCountryAL: 'Albania',
	txtAddressCountryDZ: 'Algeria',
	txtAddressCountryAD: 'Andorra',
	txtAddressCountryAO: 'Angola',
	txtAddressCountryAG: 'Antigua and Barbuda',
	txtAddressCountryAR: 'Argentina',
	txtAddressCountryAM: 'Armenia',
	txtAddressCountryAU: 'Australia',
	txtAddressCountryAT: 'Austria',
	txtAddressCountryAZ: 'Azerbaijan',
	txtAddressCountryBS: 'The Bahamas',
	txtAddressCountryBH: 'Bahrain',
	txtAddressCountryBD: 'Bangladesh',
	txtAddressCountryBB: 'Barbados',
	txtAddressCountryBY: 'Belarus',
	txtAddressCountryBE: 'Belgium',
	txtAddressCountryBZ: 'Belize',
	txtAddressCountryBJ: 'Benin',
	txtAddressCountryBM: 'Bermuda',
	txtAddressCountryBT: 'Bhutan',
	txtAddressCountryBO: 'Bolivia',
	txtAddressCountryBA: 'Bosnia and Herzegovina',
	txtAddressCountryBW: 'Botswana',
	txtAddressCountryBR: 'Brazil',
	txtAddressCountryBN: 'Brunei Darussalam',
	txtAddressCountryBG: 'Bulgaria',
	txtAddressCountryBF: 'Burkina Faso',
	txtAddressCountryBI: 'Burundi',
	txtAddressCountryKH: 'Cambodia',
	txtAddressCountryCM: 'Cameroon',
	txtAddressCountryCA: 'Canada',
	txtAddressCountryCV: 'Cape Verde',
	txtAddressCountryKY: 'Cayman Islands',
	txtAddressCountryCF: 'Central African Republic',
	txtAddressCountryTD: 'Chad',
	txtAddressCountryCL: 'Chile',
	txtAddressCountryCN: 'China',
	txtAddressCountryCO: 'Colombia',
	txtAddressCountryKM: 'Comoros',
	txtAddressCountryCD: 'Democratic Republic of the Congo',
	txtAddressCountryCG: 'Republic of the Congo',
	txtAddressCountryCR: 'Costa Rica',
	txtAddressCountryCI: 'Côte d’Ivoire',
	txtAddressCountryHR: 'Croatia',
	txtAddressCountryCU: 'Cuba',
	txtAddressCountryCY: 'Cyprus',
	txtAddressCountryCZ: 'Czech Republic',
	txtAddressCountryDK: 'Denmark',
	txtAddressCountryDJ: 'Djibouti',
	txtAddressCountryDM: 'Dominica',
	txtAddressCountryDO: 'Dominican Republic',
	txtAddressCountryEC: 'Ecuador',
	txtAddressCountryEG: 'Egypt',
	txtAddressCountrySV: 'El Salvador',
	txtAddressCountryGQ: 'Equatorial Guinea',
	txtAddressCountryER: 'Eritrea',
	txtAddressCountryEE: 'Estonia',
	txtAddressCountryET: 'Ethiopia',
	txtAddressCountryFK: 'Falkland Islands',
	txtAddressCountryFO: 'Faroe Islands',
	txtAddressCountryFJ: 'Fiji',
	txtAddressCountryFI: 'Finland',
	txtAddressCountryFR: 'France',
	txtAddressCountryPF: 'French Polynesia',
	txtAddressCountryGA: 'Gabon',
	txtAddressCountryGM: 'The Gambia',
	txtAddressCountryGE: 'Georgia',
	txtAddressCountryDE: 'Germany',
	txtAddressCountryGH: 'Ghana',
	txtAddressCountryGR: 'Greece',
	txtAddressCountryGL: 'Greenland',
	txtAddressCountryGD: 'Grenada',
	txtAddressCountryGP: 'Guadeloupe',
	txtAddressCountryGT: 'Guatemala',
	txtAddressCountryGN: 'Guinea',
	txtAddressCountryGW: 'Guinea-Bissau',
	txtAddressCountryGY: 'Guyana',
	txtAddressCountryHT: 'Haiti',
	txtAddressCountryHN: 'Honduras',
	txtAddressCountryHK: 'Hong Kong',
	txtAddressCountryHU: 'Hungary',
	txtAddressCountryIS: 'Iceland',
	txtAddressCountryIN: 'India',
	txtAddressCountryID: 'Indonesia',
	txtAddressCountryIR: 'Iran',
	txtAddressCountryIQ: 'Iraq',
	txtAddressCountryIE: 'Ireland',
	txtAddressCountryIM: 'Isle of Man',
	txtAddressCountryIL: 'Israel',
	txtAddressCountryIT: 'Italy',
	txtAddressCountryJM: 'Jamaica',
	txtAddressCountryJP: 'Japan',
	txtAddressCountryJO: 'Jordan',
	txtAddressCountryKZ: 'Kazakhstan',
	txtAddressCountryKE: 'Kenya',
	txtAddressCountryKI: 'Kiribati',
	txtAddressCountryKP: 'North Korea',
	txtAddressCountryKR: 'South Korea',
	txtAddressCountryKW: 'Kuwait',
	txtAddressCountryKG: 'Kyrgyzstan',
	txtAddressCountryLA: 'Laos',
	txtAddressCountryLV: 'Latvia',
	txtAddressCountryLB: 'Lebanon',
	txtAddressCountryLS: 'Lesotho',
	txtAddressCountryLR: 'Liberia',
	txtAddressCountryLY: 'Libya',
	txtAddressCountryLI: 'Liechtenstein',
	txtAddressCountryLT: 'Lithuania',
	txtAddressCountryLU: 'Luxembourg',
	txtAddressCountryMO: 'Macau',
	txtAddressCountryMK: 'Macedonia',
	txtAddressCountryMG: 'Madagascar',
	txtAddressCountryMW: 'Malawi',
	txtAddressCountryMY: 'Malaysia',
	txtAddressCountryMV: 'Maldives',
	txtAddressCountryML: 'Mali',
	txtAddressCountryMT: 'Malta',
	txtAddressCountryMH: 'Marshall Islands',
	txtAddressCountryMQ: 'Martinique',
	txtAddressCountryMR: 'Mauritania',
	txtAddressCountryMU: 'Mauritius',
	txtAddressCountryMX: 'Mexico',
	txtAddressCountryFM: 'Micronesia',
	txtAddressCountryMD: 'Moldova',
	txtAddressCountryMC: 'Monaco',
	txtAddressCountryMN: 'Mongolia',
	txtAddressCountryME: 'Montenegro',
	txtAddressCountryMA: 'Morocco',
	txtAddressCountryMZ: 'Mozambique',
	txtAddressCountryMM: 'Myanmar',
	txtAddressCountryNA: 'Namibia',
	txtAddressCountryNR: 'Nauru',
	txtAddressCountryNP: 'Nepal',
	txtAddressCountryNL: 'Netherlands',
	txtAddressCountryNC: 'New Caledonia',
	txtAddressCountryNZ: 'New Zealand',
	txtAddressCountryNI: 'Nicaragua',
	txtAddressCountryNE: 'Niger',
	txtAddressCountryNG: 'Nigeria',
	txtAddressCountryNO: 'Norway',
	txtAddressCountryOM: 'Oman',
	txtAddressCountryPK: 'Pakistan',
	txtAddressCountryPW: 'Palau',
	txtAddressCountryPS: 'Palestinian Territories',
	txtAddressCountryPA: 'Panama',
	txtAddressCountryPG: 'Papua New Guinea',
	txtAddressCountryPY: 'Paraguay',
	txtAddressCountryPE: 'Peru',
	txtAddressCountryPH: 'Philippines',
	txtAddressCountryPL: 'Poland',
	txtAddressCountryPT: 'Portugal',
	txtAddressCountryPR: 'Puerto Rico',
	txtAddressCountryQA: 'Qatar',
	txtAddressCountryRE: 'Réunion',
	txtAddressCountryRO: 'Romania',
	txtAddressCountryRU: 'Russia',
	txtAddressCountryRW: 'Rwanda',
	txtAddressCountryBL: 'Saint Barthélemy',
	txtAddressCountrySH: 'Saint Helena',
	txtAddressCountryKN: 'Saint Kitts and Nevis',
	txtAddressCountryLC: 'Saint Lucia',
	txtAddressCountryMF: 'Saint Martin',
	txtAddressCountryVC: 'Saint Vincent and the Grenadines',
	txtAddressCountryWS: 'Samoa',
	txtAddressCountrySM: 'San Marino',
	txtAddressCountryST: 'Sao Tome and Principe',
	txtAddressCountrySA: 'Saudi Arabia',
	txtAddressCountrySN: 'Senegal',
	txtAddressCountryRS: 'Serbia',
	txtAddressCountrySC: 'Seychelles',
	txtAddressCountrySL: 'Sierra Leone',
	txtAddressCountrySG: 'Singapore',
	txtAddressCountrySK: 'Slovak Republic',
	txtAddressCountrySI: 'Slovenia',
	txtAddressCountrySB: 'Solomon Islands',
	txtAddressCountrySO: 'Somalia',
	txtAddressCountryZA: 'South Africa',
	txtAddressCountryGS: 'South Georgia and South Sandwich Islands',
	txtAddressCountryES: 'Spain',
	txtAddressCountryLK: 'Sri Lanka',
	txtAddressCountrySD: 'Sudan',
	txtAddressCountrySR: 'Suriname',
	txtAddressCountrySZ: 'Swaziland',
	txtAddressCountrySE: 'Sweden',
	txtAddressCountryCH: 'Switzerland',
	txtAddressCountrySY: 'Syria',
	txtAddressCountryTW: 'Taiwan',
	txtAddressCountryTJ: 'Tajikistan',
	txtAddressCountryTZ: 'Tanzania',
	txtAddressCountryTH: 'Thailand',
	txtAddressCountryTL: 'Timor-Leste',
	txtAddressCountryTG: 'Togo',
	txtAddressCountryTO: 'Tonga',
	txtAddressCountryTT: 'Trinidad and Tobago',
	txtAddressCountryTN: 'Tunisia',
	txtAddressCountryTR: 'Turkey',
	txtAddressCountryTM: 'Turkmenistan',
	txtAddressCountryTV: 'Tuvalu',
	txtAddressCountryVI: 'U.S. Virgin Islands',
	txtAddressCountryUG: 'Uganda',
	txtAddressCountryUA: 'Ukraine',
	txtAddressCountryAE: 'United Arab Emirates',
	txtAddressCountryGB: 'United Kingdom',
	txtAddressCountryUS: 'United States',
	txtAddressCountryUY: 'Uruguay',
	txtAddressCountryUZ: 'Uzbekistan',
	txtAddressCountryVU: 'Vanuatu',
	txtAddressCountryVA: 'Vatican',
	txtAddressCountryVE: 'Venezuela',
	txtAddressCountryVN: 'Vietnam',
	txtAddressCountryYE: 'Yemen',
	txtAddressCountryZM: 'Zambia',
	txtAddressCountryZW: 'Zimbabwe'
};

localizationSharedCardDAV['es_ES']=	/* Damian Vila <damianvila@gmail.com> */
{
	txtContacts: 'Contactos',

	pholderGiven: 'Nombre',
	pholderFamily: 'Apellido',
	pholderMiddle: 'Segundo nombre',
	pholderPrefix: 'Prefijo',
	pholderSuffix: 'Sufijo',

	txtAddressCountryAF: 'Afganistán',
	txtAddressCountryAL: 'Albania',
	txtAddressCountryDZ: 'Algeria',
	txtAddressCountryAD: 'Andorra',
	txtAddressCountryAO: 'Angola',
	txtAddressCountryAG: 'Antigua y Barbuda',
	txtAddressCountryAR: 'Argentina',
	txtAddressCountryAM: 'Armenia',
	txtAddressCountryAU: 'Australia',
	txtAddressCountryAT: 'Austria',
	txtAddressCountryAZ: 'Azerbaiyán',
	txtAddressCountryBS: 'Bahamas',
	txtAddressCountryBH: 'Bahrein',
	txtAddressCountryBD: 'Bangladesh',
	txtAddressCountryBB: 'Barbados',
	txtAddressCountryBY: 'Bielorrusia',
	txtAddressCountryBE: 'Bélgica',
	txtAddressCountryBZ: 'Belice',
	txtAddressCountryBJ: 'Benín',
	txtAddressCountryBM: 'Bermudas',
	txtAddressCountryBT: 'Bután',
	txtAddressCountryBO: 'Bolivia',
	txtAddressCountryBA: 'Bosnia-Herzegovina',
	txtAddressCountryBW: 'Botswana',
	txtAddressCountryBR: 'Brasil',
	txtAddressCountryBN: 'Brunei Darussalam',
	txtAddressCountryBG: 'Bulgaria',
	txtAddressCountryBF: 'Burkina Faso',
	txtAddressCountryBI: 'Burundi',
	txtAddressCountryKH: 'Camboya',
	txtAddressCountryCM: 'Camerún',
	txtAddressCountryCA: 'Canadá',
	txtAddressCountryCV: 'Cabo Verde',
	txtAddressCountryKY: 'Islas Caimán',
	txtAddressCountryCF: 'República Centroafricana',
	txtAddressCountryTD: 'Chad',
	txtAddressCountryCL: 'Chile',
	txtAddressCountryCN: 'China',
	txtAddressCountryCO: 'Colombia',
	txtAddressCountryKM: 'Comores',
	txtAddressCountryCD: 'República Democrática del Congo',
	txtAddressCountryCG: 'República del Congo',
	txtAddressCountryCR: 'Costa Rica',
	txtAddressCountryCI: 'Costa de Marfil',
	txtAddressCountryHR: 'Croacia',
	txtAddressCountryCU: 'Cuba',
	txtAddressCountryCY: 'Chipre',
	txtAddressCountryCZ: 'República Checa',
	txtAddressCountryDK: 'Dinamarca',
	txtAddressCountryDJ: 'Yibuti',
	txtAddressCountryDM: 'Dominica',
	txtAddressCountryDO: 'República Dominicana',
	txtAddressCountryEC: 'Ecuador',
	txtAddressCountryEG: 'Egipto',
	txtAddressCountrySV: 'El Salvador',
	txtAddressCountryGQ: 'Guinea Ecuatorial',
	txtAddressCountryER: 'Eritrea',
	txtAddressCountryEE: 'Estonia',
	txtAddressCountryET: 'Etiopiía',
	txtAddressCountryFK: 'Islas Malvinas',
	txtAddressCountryFO: 'Islas Feroe',
	txtAddressCountryFJ: 'Fiyi',
	txtAddressCountryFI: 'Finlandia',
	txtAddressCountryFR: 'Francia',
	txtAddressCountryPF: 'Polinesia Francesa',
	txtAddressCountryGA: 'Gabón',
	txtAddressCountryGM: 'Gambia',
	txtAddressCountryGE: 'Georgia',
	txtAddressCountryDE: 'Alemania',
	txtAddressCountryGH: 'Ghana',
	txtAddressCountryGR: 'Grecia',
	txtAddressCountryGL: 'Groenlandia',
	txtAddressCountryGD: 'Granada',
	txtAddressCountryGP: 'Guadalupe',
	txtAddressCountryGT: 'Guatemala',
	txtAddressCountryGN: 'República Guinea',
	txtAddressCountryGW: 'Guinea Bissau',
	txtAddressCountryGY: 'Guyana',
	txtAddressCountryHT: 'Haiti',
	txtAddressCountryHN: 'Honduras',
	txtAddressCountryHK: 'Hong Kong',
	txtAddressCountryHU: 'Hungría',
	txtAddressCountryIS: 'Islandia',
	txtAddressCountryIN: 'India',
	txtAddressCountryID: 'Indonesia',
	txtAddressCountryIR: 'Irán',
	txtAddressCountryIQ: 'Irak',
	txtAddressCountryIE: 'Irlanda',
	txtAddressCountryIM: 'Isla de Man',
	txtAddressCountryIL: 'Israel',
	txtAddressCountryIT: 'Italia',
	txtAddressCountryJM: 'Jamaica',
	txtAddressCountryJP: 'Japón',
	txtAddressCountryJO: 'Jordania',
	txtAddressCountryKZ: 'Kazajstán',
	txtAddressCountryKE: 'Kenia',
	txtAddressCountryKI: 'Kiribati',
	txtAddressCountryKP: 'Corea del Norte',
	txtAddressCountryKR: 'Corea del Sur',
	txtAddressCountryKW: 'Kuwait',
	txtAddressCountryKG: 'Kirguistán',
	txtAddressCountryLA: 'Laos',
	txtAddressCountryLV: 'Letonia',
	txtAddressCountryLB: 'Líbano',
	txtAddressCountryLS: 'Lesotho',
	txtAddressCountryLR: 'Liberia',
	txtAddressCountryLY: 'Libia',
	txtAddressCountryLI: 'Liechtenstein',
	txtAddressCountryLT: 'Lituania',
	txtAddressCountryLU: 'Luxemburgo',
	txtAddressCountryMO: 'Macao',
	txtAddressCountryMK: 'Macedonia',
	txtAddressCountryMG: 'Madagascar',
	txtAddressCountryMW: 'Malawi',
	txtAddressCountryMY: 'Malasia',
	txtAddressCountryMV: 'Maldivas',
	txtAddressCountryML: 'Mali',
	txtAddressCountryMT: 'Malta',
	txtAddressCountryMH: 'Islas Marshall',
	txtAddressCountryMQ: 'Martinica',
	txtAddressCountryMR: 'Mauritania',
	txtAddressCountryMU: 'Mauricio',
	txtAddressCountryMX: 'México',
	txtAddressCountryFM: 'Micronesia',
	txtAddressCountryMD: 'Moldavia',
	txtAddressCountryMC: 'Mónaco',
	txtAddressCountryMN: 'Mongolia',
	txtAddressCountryME: 'Montenegro',
	txtAddressCountryMA: 'Marruecos',
	txtAddressCountryMZ: 'Mozambique',
	txtAddressCountryMM: 'Myanmar',
	txtAddressCountryNA: 'Namibia',
	txtAddressCountryNR: 'Nauru',
	txtAddressCountryNP: 'Nepal',
	txtAddressCountryNL: 'Países Bajos',
	txtAddressCountryNC: 'Nueva Caledonia',
	txtAddressCountryNZ: 'Nueva Zelanda',
	txtAddressCountryNI: 'Nicaragua',
	txtAddressCountryNE: 'Niger',
	txtAddressCountryNG: 'Nigeria',
	txtAddressCountryNO: 'Noruega',
	txtAddressCountryOM: 'Omán',
	txtAddressCountryPK: 'Pakistán',
	txtAddressCountryPW: 'Palau',
	txtAddressCountryPS: 'Territorios Palestinos',
	txtAddressCountryPA: 'Panamá',
	txtAddressCountryPG: 'Papúa-Nueba Guinea',
	txtAddressCountryPY: 'Paraguay',
	txtAddressCountryPE: 'Perú',
	txtAddressCountryPH: 'Filipinas',
	txtAddressCountryPL: 'Polonia',
	txtAddressCountryPT: 'Portugal',
	txtAddressCountryPR: 'Puerto Rico',
	txtAddressCountryQA: 'Catar',
	txtAddressCountryRE: 'Réunion',
	txtAddressCountryRO: 'Rumanía',
	txtAddressCountryRU: 'Rusia',
	txtAddressCountryRW: 'Ruanda',
	txtAddressCountryBL: 'San Bartolomé',
	txtAddressCountrySH: 'Isla Santa Elena',
	txtAddressCountryKN: 'San Cristobal y Nevis',
	txtAddressCountryLC: 'Santa Lucía',
	txtAddressCountryMF: 'Isla de San Martín',
	txtAddressCountryVC: 'San Vincente y Granadinas',
	txtAddressCountryWS: 'Samoa',
	txtAddressCountrySM: 'San Marino',
	txtAddressCountryST: 'Santo Tomé y Príncipe',
	txtAddressCountrySA: 'Arabia Saudita',
	txtAddressCountrySN: 'Senegal',
	txtAddressCountryRS: 'Serbia',
	txtAddressCountrySC: 'Seychelles',
	txtAddressCountrySL: 'Sierra Leona',
	txtAddressCountrySG: 'Singapur',
	txtAddressCountrySK: 'Eslovaquia',
	txtAddressCountrySI: 'Eslovenia',
	txtAddressCountrySB: 'Islas Salomón',
	txtAddressCountrySO: 'Somalia',
	txtAddressCountryZA: 'Sudáfrica',
	txtAddressCountryGS: 'Islas Georgias del Sur y Sandwich del Sur',
	txtAddressCountryES: 'España',
	txtAddressCountryLK: 'Sri Lanka',
	txtAddressCountrySD: 'Sudán',
	txtAddressCountrySR: 'Surinam',
	txtAddressCountrySZ: 'Swazilandia',
	txtAddressCountrySE: 'Suecia',
	txtAddressCountryCH: 'Suiza',
	txtAddressCountrySY: 'Siria',
	txtAddressCountryTW: 'Taiwan',
	txtAddressCountryTJ: 'Tadjikistan',
	txtAddressCountryTZ: 'Tanzania',
	txtAddressCountryTH: 'Tailandia',
	txtAddressCountryTL: 'Timor Oriental',
	txtAddressCountryTG: 'Togo',
	txtAddressCountryTO: 'Tonga',
	txtAddressCountryTT: 'Trinidad y Tobago',
	txtAddressCountryTN: 'Túnez',
	txtAddressCountryTR: 'Turquía',
	txtAddressCountryTM: 'Turkmenistan',
	txtAddressCountryTV: 'Tuvalu',
	txtAddressCountryVI: 'Islas Virgenes Americanas',
	txtAddressCountryUG: 'Uganda',
	txtAddressCountryUA: 'Ucrania',
	txtAddressCountryAE: 'Emiratos Árabes Unidos',
	txtAddressCountryGB: 'Reino Unido',
	txtAddressCountryUS: 'Estados Unidos',
	txtAddressCountryUY: 'Uruguay',
	txtAddressCountryUZ: 'Uzbekistán',
	txtAddressCountryVU: 'Vanuatu',
	txtAddressCountryVA: 'Ciudad del Vaticano',
	txtAddressCountryVE: 'Venezuela',
	txtAddressCountryVN: 'Vietnam',
	txtAddressCountryYE: 'Yemen',
	txtAddressCountryZM: 'Zambia',
	txtAddressCountryZW: 'Zimbabwe'
};

localizationSharedCardDAV['fr_FR']=	/* thanks John Fischer and Jean-Christophe Bach */
{
	txtContacts: 'Contacts',

	pholderGiven: 'Prénom',
	pholderFamily: 'Nom',
	pholderMiddle: 'Second prénom',
	pholderPrefix: 'Préfixe',
	pholderSuffix: 'Suffixe',

	txtAddressCountryAF: 'Afghanistan',
	txtAddressCountryAL: 'Albanie',
	txtAddressCountryDZ: 'Algérie',
	txtAddressCountryAD: 'Andorre',
	txtAddressCountryAO: 'Angola',
	txtAddressCountryAG: 'Antigua-et-Barbuda',
	txtAddressCountryAR: 'Argentine',
	txtAddressCountryAM: 'Arménie',
	txtAddressCountryAU: 'Australia',
	txtAddressCountryAT: 'Autriche',
	txtAddressCountryAZ: 'Azerbaïdjan',
	txtAddressCountryBS: 'Les Bahamas',
	txtAddressCountryBH: 'Bahreïn',
	txtAddressCountryBD: 'Bangladesh',
	txtAddressCountryBB: 'Barbade',
	txtAddressCountryBY: 'Biélorussie',
	txtAddressCountryBE: 'Belgique',
	txtAddressCountryBZ: 'Belize',
	txtAddressCountryBJ: 'Bénin',
	txtAddressCountryBM: 'Bermuda',
	txtAddressCountryBT: 'Bhoutan',
	txtAddressCountryBO: 'Bolivie',
	txtAddressCountryBA: 'Bosnie-Herzégovine',
	txtAddressCountryBW: 'Botswana',
	txtAddressCountryBR: 'Brésil',
	txtAddressCountryBN: 'Brunéi Darussalam',
	txtAddressCountryBG: 'Bulgarie',
	txtAddressCountryBF: 'Burkina Faso',
	txtAddressCountryBI: 'Burundi',
	txtAddressCountryKH: 'Cambodge',
	txtAddressCountryCM: 'Cameroun',
	txtAddressCountryCA: 'Canada',
	txtAddressCountryCV: 'Le Cap-Vert',
	txtAddressCountryKY: 'Iles Caïmans',
	txtAddressCountryCF: 'République centrafricaine',
	txtAddressCountryTD: 'Tchad',
	txtAddressCountryCL: 'Chili',
	txtAddressCountryCN: 'Chine',
	txtAddressCountryCO: 'Colombie',
	txtAddressCountryKM: 'Comores',
	txtAddressCountryCD: 'République démocratique du Congo',
	txtAddressCountryCG: 'République du Congo',
	txtAddressCountryCR: 'Costa Rica',
	txtAddressCountryCI: 'Côte d`Ivoire',
	txtAddressCountryHR: 'Croatie',
	txtAddressCountryCU: 'Cuba',
	txtAddressCountryCY: 'Chypre',
	txtAddressCountryCZ: 'République tchèque',
	txtAddressCountryDK: 'Danemark',
	txtAddressCountryDJ: 'Djibouti',
	txtAddressCountryDM: 'Dominique',
	txtAddressCountryDO: 'La République dominicaine',
	txtAddressCountryEC: 'Équateur',
	txtAddressCountryEG: 'Égypte',
	txtAddressCountrySV: 'El Salvador',
	txtAddressCountryGQ: 'Guinée équatoriale',
	txtAddressCountryER: 'Erythrée',
	txtAddressCountryEE: 'Estonie',
	txtAddressCountryET: 'Ethiopie',
	txtAddressCountryFK: 'Îles Falkland',
	txtAddressCountryFO: 'Îles Féroé',
	txtAddressCountryFJ: 'Fidji',
	txtAddressCountryFI: 'Finlande',
	txtAddressCountryFR: 'France',
	txtAddressCountryPF: 'Polynésie française',
	txtAddressCountryGA: 'Gabon',
	txtAddressCountryGM: 'La Gambie',
	txtAddressCountryGE: 'Georgia',
	txtAddressCountryDE: 'Allemagne',
	txtAddressCountryGH: 'Ghana',
	txtAddressCountryGR: 'Grèce',
	txtAddressCountryGL: 'Groenland',
	txtAddressCountryGD: 'Grenade',
	txtAddressCountryGP: 'Guadeloupe',
	txtAddressCountryGT: "Guatemala",
	txtAddressCountryGN: 'Guinée',
	txtAddressCountryGW: 'Guinée-Bissau',
	txtAddressCountryGY: 'Guyane',
	txtAddressCountryHT: 'Haïti',
	txtAddressCountryHN: 'Honduras',
	txtAddressCountryHK: 'Hong Kong',
	txtAddressCountryHU: 'Hongrie',
	txtAddressCountryIS: 'Islande',
	txtAddressCountryIN: 'Inde',
	txtAddressCountryID: 'Indonésie',
	txtAddressCountryIR: 'Iran',
	txtAddressCountryIQ: 'Irak',
	txtAddressCountryIE: 'Irlande',
	txtAddressCountryIM: 'Île de Man ',
	txtAddressCountryIL: 'Israël',
	txtAddressCountryIT: 'Italie',
	txtAddressCountryJM: 'Jamaïque',
	txtAddressCountryJP: 'Japon',
	txtAddressCountryJO: 'Jordan',
	txtAddressCountryKZ: 'Kazakhstan',
	txtAddressCountryKE: 'Kenya',
	txtAddressCountryKI: 'Kiribati',
	txtAddressCountryKP: 'Corée du Nord',
	txtAddressCountryKR: 'La Corée du Sud',
	txtAddressCountryKW: 'Koweït',
	txtAddressCountryKG: 'Kirghizstan',
	txtAddressCountryLA: 'Laos',
	txtAddressCountryLV: 'Lettonie',
	txtAddressCountryLB: 'Liban',
	txtAddressCountryLS: 'Lesotho',
	txtAddressCountryLR: 'Liberia',
	txtAddressCountryLY: 'Libye',
	txtAddressCountryLI: 'Liechtenstein',
	txtAddressCountryLT: 'Lituanie',
	txtAddressCountryLU: 'Luxembourg',
	txtAddressCountryMO: 'Macao',
	txtAddressCountryMK: 'Macédoine',
	txtAddressCountryMG: 'Madagascar',
	txtAddressCountryMW: 'Malawi',
	txtAddressCountryMY: 'Malaisie',
	txtAddressCountryMV: 'Maldives',
	txtAddressCountryML: 'Le Mali',
	txtAddressCountryMT: 'Malte',
	txtAddressCountryMH: 'Iles Marshall',
	txtAddressCountryMQ: 'Martinique',
	txtAddressCountryMR: 'Mauritanie',
	txtAddressCountryMU: 'Maurice',
	txtAddressCountryMX: 'Mexique',
	txtAddressCountryFM: 'Micronésie',
	txtAddressCountryMD: 'Moldavie',
	txtAddressCountryMC: 'Monaco',
	txtAddressCountryMN: 'Mongolie',
	txtAddressCountryME: 'Monténégro',
	txtAddressCountryMA: 'Maroc',
	txtAddressCountryMZ: 'Mozambique',
	txtAddressCountryMM: 'Myanmar',
	txtAddressCountryNA: 'Namibie',
	txtAddressCountryNR: 'Nauru',
	txtAddressCountryNP: 'Népal',
	txtAddressCountryNL: 'Pays-Bas',
	txtAddressCountryNC: 'Nouvelle-Calédonie',
	txtAddressCountryNZ: 'Nouvelle-Zélande',
	txtAddressCountryNI: 'Nicaragua',
	txtAddressCountryNE: 'Niger',
	txtAddressCountryNG: 'Nigeria',
	txtAddressCountryNO: 'Norvège',
	txtAddressCountryOM: 'Oman',
	txtAddressCountryPK: 'Pakistan',
	txtAddressCountryPW: 'Palau',
	txtAddressCountryPS: 'Territoires palestiniens',
	txtAddressCountryPA: 'Panama',
	txtAddressCountryPG: 'Papouasie-Nouvelle-Guinée',
	txtAddressCountryPY: 'Paraguay',
	txtAddressCountryPE: 'Pérou',
	txtAddressCountryPH: 'Philippines',
	txtAddressCountryPL: 'Pologne',
	txtAddressCountryPT: 'Portugal',
	txtAddressCountryPR: 'Puerto Rico',
	txtAddressCountryQA: 'Qatar',
	txtAddressCountryRE: 'La Réunion',
	txtAddressCountryRO: 'Roumanie',
	txtAddressCountryRU: 'Russie',
	txtAddressCountryRW: 'Rwanda',
	txtAddressCountryBL: 'Saint-Barthélemy',
	txtAddressCountrySH: 'Sainte-Hélène',
	txtAddressCountryKN: 'Saint-Kitts-et-Nevis',
	txtAddressCountryLC: 'Sainte-Lucie',
	txtAddressCountryMF: 'Saint Martin',
	txtAddressCountryVC: 'Saint-Vincent-et-les Grenadines',
	txtAddressCountryWS: 'Samoa',
	txtAddressCountrySM: 'San Marino',
	txtAddressCountryST: 'Sao Tomé et Principe',
	txtAddressCountrySA: 'L`Arabie Saoudite',
	txtAddressCountrySN: 'Sénégal',
	txtAddressCountryRS: 'Serbie',
	txtAddressCountrySC: 'Seychelles',
	txtAddressCountrySL: 'Sierra Leone',
	txtAddressCountrySG: 'Singapour',
	txtAddressCountrySK: 'République slovaque',
	txtAddressCountrySI: 'Slovénie',
	txtAddressCountrySB: 'Îles Salomon',
	txtAddressCountrySO: 'Somalie',
	txtAddressCountryZA: 'Afrique du Sud',
	txtAddressCountryGS: 'Géorgie du Sud et îles Sandwich du Sud',
	txtAddressCountryES: 'Espagne',
	txtAddressCountryLK: 'Sri Lanka',
	txtAddressCountrySD: 'Soudan',
	txtAddressCountrySR: 'Suriname',
	txtAddressCountrySZ: 'Swaziland',
	txtAddressCountrySE: 'Suède',
	txtAddressCountryCH: 'Suisse',
	txtAddressCountrySY: 'Syrie',
	txtAddressCountryTW: 'Taiwan',
	txtAddressCountryTJ: 'Tadjikistan',
	txtAddressCountryTZ: 'Tanzanie',
	txtAddressCountryTH: 'Thaïlande',
	txtAddressCountryTL: 'Timor-Leste',
	txtAddressCountryTG: 'Togo',
	txtAddressCountryTO: 'Tonga',
	txtAddressCountryTT: 'Trinidad et Tobago',
	txtAddressCountryTN: 'Tunisie',
	txtAddressCountryTR: 'Turquie',
	txtAddressCountryTM: 'Turkménistan',
	txtAddressCountryTV: 'Tuvalu',
	txtAddressCountryVI: 'Etats-Unis Îles Vierges ',
	txtAddressCountryUG: 'Ouganda',
	txtAddressCountryUA: 'Ukraine',
	txtAddressCountryAE: 'Émirats Arabes Unis',
	txtAddressCountryGB: 'Royaume-Uni ',
	txtAddressCountryUS: 'Les États-Unis',
	txtAddressCountryUY: 'Uruguay',
	txtAddressCountryUZ: 'Ouzbékistan',
	txtAddressCountryVU: 'Vanuatu',
	txtAddressCountryVA: 'Vatican II',
	txtAddressCountryVE: 'Venezuela',
	txtAddressCountryVN: 'Vietnam',
	txtAddressCountryYE: 'Yémen',
	txtAddressCountryZM: 'Zambie',
	txtAddressCountryZW: 'Zimbabwe'
};

localizationSharedCardDAV['hu_HU']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	txtContacts: 'Kapcsolatok',

	pholderGiven: 'Utó',
	pholderFamily: 'Családi',
	pholderMiddle: 'Középső',
	pholderPrefix: 'Előtag',
	pholderSuffix: 'Utótag',

	txtAddressCountryAF: 'Afganisztán',
	txtAddressCountryAL: 'Albánia',
	txtAddressCountryDZ: 'Algéria',
	txtAddressCountryAD: 'Andorra',
	txtAddressCountryAO: 'Angola',
	txtAddressCountryAG: 'Antigua és Barbuda',
	txtAddressCountryAR: 'Argentína',
	txtAddressCountryAM: 'Örményország',
	txtAddressCountryAU: 'Ausztrália',
	txtAddressCountryAT: 'Ausztria',
	txtAddressCountryAZ: 'Azerbajdzsán',
	txtAddressCountryBS: 'Bahamák',
	txtAddressCountryBH: 'Bahrein',
	txtAddressCountryBD: 'Banglades',
	txtAddressCountryBB: 'Barbados',
	txtAddressCountryBY: 'Fehéroroszország',
	txtAddressCountryBE: 'Belgium',
	txtAddressCountryBZ: 'Belize',
	txtAddressCountryBJ: 'Benin',
	txtAddressCountryBM: 'Bermuda',
	txtAddressCountryBT: 'Bhutan',
	txtAddressCountryBO: 'Bolívia',
	txtAddressCountryBA: 'Bosznia-Hercegovina',
	txtAddressCountryBW: 'Botswana',
	txtAddressCountryBR: 'Brazília',
	txtAddressCountryBN: 'Brunei Darussalam',
	txtAddressCountryBG: 'Bulgária',
	txtAddressCountryBF: 'Burkina Faso',
	txtAddressCountryBI: 'Burundi',
	txtAddressCountryKH: 'Kambodzsa',
	txtAddressCountryCM: 'Kamerun',
	txtAddressCountryCA: 'Kanada',
	txtAddressCountryCV: 'Cape Verde',
	txtAddressCountryKY: 'Kajmán-szigetek',
	txtAddressCountryCF: 'Közép-afrikai Köztársaság',
	txtAddressCountryTD: 'Csád',
	txtAddressCountryCL: 'Chile',
	txtAddressCountryCN: 'Kína',
	txtAddressCountryCO: 'Kolumbia',
	txtAddressCountryKM: 'Comore-szigetek',
	txtAddressCountryCD: 'Kongói Demokratikus Köztársaság',
	txtAddressCountryCG: 'Kongói Köztársaság',
	txtAddressCountryCR: 'Costa Rica',
	txtAddressCountryCI: 'Elefántcsontpart',
	txtAddressCountryHR: 'Horvátország',
	txtAddressCountryCU: 'Kuba',
	txtAddressCountryCY: 'Ciprus',
	txtAddressCountryCZ: 'Csehország',
	txtAddressCountryDK: 'Dánia',
	txtAddressCountryDJ: 'Dzsibuti',
	txtAddressCountryDM: 'Dominika',
	txtAddressCountryDO: 'Dominikai Köztársaság',
	txtAddressCountryEC: 'Ecuador',
	txtAddressCountryEG: 'Egyiptom',
	txtAddressCountrySV: 'Salvador',
	txtAddressCountryGQ: 'Egyenlítiői Guinea',
	txtAddressCountryER: 'Eritrea',
	txtAddressCountryEE: 'Észtország',
	txtAddressCountryET: 'Etiópia',
	txtAddressCountryFK: 'Falkland-szigetek',
	txtAddressCountryFO: 'Feröer-szigetek',
	txtAddressCountryFJ: 'Fidzsi',
	txtAddressCountryFI: 'Finnország',
	txtAddressCountryFR: 'Franciaország',
	txtAddressCountryPF: 'Francia Polinézia',
	txtAddressCountryGA: 'Gabon',
	txtAddressCountryGM: 'Gambia',
	txtAddressCountryGE: 'Grúzia',
	txtAddressCountryDE: 'Németország',
	txtAddressCountryGH: 'Ghána',
	txtAddressCountryGR: 'Görögország',
	txtAddressCountryGL: 'Grönland',
	txtAddressCountryGD: 'Grenada',
	txtAddressCountryGP: 'Guadeloupe',
	txtAddressCountryGT: 'Guatemala',
	txtAddressCountryGN: 'Guinea',
	txtAddressCountryGW: 'Guinea-Bissau',
	txtAddressCountryGY: 'Guyana',
	txtAddressCountryHT: 'Haiti',
	txtAddressCountryHN: 'Honduras',
	txtAddressCountryHK: 'Hongkong',
	txtAddressCountryHU: 'Magyarország',
	txtAddressCountryIS: 'Izland',
	txtAddressCountryIN: 'India',
	txtAddressCountryID: 'Indonézia',
	txtAddressCountryIR: 'Irán',
	txtAddressCountryIQ: 'Irak',
	txtAddressCountryIE: 'Írország',
	txtAddressCountryIM: 'Man-sziget',
	txtAddressCountryIL: 'Izrael',
	txtAddressCountryIT: 'Olaszország',
	txtAddressCountryJM: 'Jamaica',
	txtAddressCountryJP: 'Japán',
	txtAddressCountryJO: 'Jordánia',
	txtAddressCountryKZ: 'Kazahsztán',
	txtAddressCountryKE: 'Kenya',
	txtAddressCountryKI: 'Kiribati',
	txtAddressCountryKP: 'Észak-Korea',
	txtAddressCountryKR: 'Dél-Korea',
	txtAddressCountryKW: 'Kuvait',
	txtAddressCountryKG: 'Kirgizisztán',
	txtAddressCountryLA: 'Laosz',
	txtAddressCountryLV: 'Lettország',
	txtAddressCountryLB: 'Libanon',
	txtAddressCountryLS: 'Lesotho',
	txtAddressCountryLR: 'Libéria',
	txtAddressCountryLY: 'Líbia',
	txtAddressCountryLI: 'Liechtenstein',
	txtAddressCountryLT: 'Litvánia',
	txtAddressCountryLU: 'Luxemburg',
	txtAddressCountryMO: 'Makaó',
	txtAddressCountryMK: 'Macedónia',
	txtAddressCountryMG: 'Madagaszkár',
	txtAddressCountryMW: 'Malawi',
	txtAddressCountryMY: 'Malajzia',
	txtAddressCountryMV: 'Maldív-szigetek',
	txtAddressCountryML: 'Mali',
	txtAddressCountryMT: 'Málta',
	txtAddressCountryMH: 'Marshall-szigetek',
	txtAddressCountryMQ: 'Martinique',
	txtAddressCountryMR: 'Mauritánia',
	txtAddressCountryMU: 'Mauritius',
	txtAddressCountryMX: 'Mexikó',
	txtAddressCountryFM: 'Mikronézia',
	txtAddressCountryMD: 'Moldova',
	txtAddressCountryMC: 'Monaco',
	txtAddressCountryMN: 'Mongólia',
	txtAddressCountryME: 'Montenegro',
	txtAddressCountryMA: 'Marokkó',
	txtAddressCountryMZ: 'Mozambik',
	txtAddressCountryMM: 'Myanmar',
	txtAddressCountryNA: 'Namíbia',
	txtAddressCountryNR: 'Nauru',
	txtAddressCountryNP: 'Nepál',
	txtAddressCountryNL: 'Hollandia',
	txtAddressCountryNC: 'Új-Kaledónia',
	txtAddressCountryNZ: 'Új-Zéland',
	txtAddressCountryNI: 'Nicaragua',
	txtAddressCountryNE: 'Niger',
	txtAddressCountryNG: 'Nigéria',
	txtAddressCountryNO: 'Norvégia',
	txtAddressCountryOM: 'Omán',
	txtAddressCountryPK: 'Pakisztán',
	txtAddressCountryPW: 'Palau',
	txtAddressCountryPS: 'Palesztin Területek',
	txtAddressCountryPA: 'Panama',
	txtAddressCountryPG: 'Pápua Új-Guinea',
	txtAddressCountryPY: 'Paraguay',
	txtAddressCountryPE: 'Peru',
	txtAddressCountryPH: 'Fülöp-szigetek',
	txtAddressCountryPL: 'Lengyelország',
	txtAddressCountryPT: 'Portugália',
	txtAddressCountryPR: 'Puerto Rico',
	txtAddressCountryQA: 'Katar',
	txtAddressCountryRE: 'Réunion',
	txtAddressCountryRO: 'Románia',
	txtAddressCountryRU: 'Oroszország',
	txtAddressCountryRW: 'Ruanda',
	txtAddressCountryBL: 'Saint-Barthélemy',
	txtAddressCountrySH: 'Saint Helena',
	txtAddressCountryKN: 'Saint Kitts és Nevis',
	txtAddressCountryLC: 'Saint Lucia',
	txtAddressCountryMF: 'Saint Martin',
	txtAddressCountryVC: 'Saint Vincent és Granadák',
	txtAddressCountryWS: 'Szamoa',
	txtAddressCountrySM: 'San Marino',
	txtAddressCountryST: 'Sao Tome és Principe',
	txtAddressCountrySA: 'Szaúd-Arábia',
	txtAddressCountrySN: 'Szenegál',
	txtAddressCountryRS: 'Szerbia',
	txtAddressCountrySC: 'Seychelle-szigetek',
	txtAddressCountrySL: 'Sierra Leone',
	txtAddressCountrySG: 'Szingapúr',
	txtAddressCountrySK: 'Szlovákia',
	txtAddressCountrySI: 'Szlovénia',
	txtAddressCountrySB: 'Salamon-szigetek',
	txtAddressCountrySO: 'Szomália',
	txtAddressCountryZA: 'Dél-Afrika',
	txtAddressCountryGS: 'Dél-Georgia és Déli Sandwich-szigetek',
	txtAddressCountryES: 'Spanyolország',
	txtAddressCountryLK: 'Sri Lanka',
	txtAddressCountrySD: 'Szudán',
	txtAddressCountrySR: 'Suriname',
	txtAddressCountrySZ: 'Szváziföld',
	txtAddressCountrySE: 'Švédország',
	txtAddressCountryCH: 'Švájc',
	txtAddressCountrySY: 'Szíria',
	txtAddressCountryTW: 'Tajvan',
	txtAddressCountryTJ: 'Tadzsikisztán',
	txtAddressCountryTZ: 'Tanzánia',
	txtAddressCountryTH: 'Thaiföld',
	txtAddressCountryTL: 'Timor-Leste',
	txtAddressCountryTG: 'Togo',
	txtAddressCountryTO: 'Tonga',
	txtAddressCountryTT: 'Trinidad és Tobago',
	txtAddressCountryTN: 'Tunézia',
	txtAddressCountryTR: 'Törökország',
	txtAddressCountryTM: 'Türkmenisztán',
	txtAddressCountryTV: 'Tuvalu',
	txtAddressCountryVI: 'USA Virgin-szigetek',
	txtAddressCountryUG: 'Uganda',
	txtAddressCountryUA: 'Ukrajna',
	txtAddressCountryAE: 'Egyesült Arab Emírségek',
	txtAddressCountryGB: 'Egyesült Királyság',
	txtAddressCountryUS: 'Egyesült Államok',
	txtAddressCountryUY: 'Uruguay',
	txtAddressCountryUZ: 'Üzbegisztán',
	txtAddressCountryVU: 'Vanuatu',
	txtAddressCountryVA: 'Vatikán',
	txtAddressCountryVE: 'Venezuela',
	txtAddressCountryVN: 'Vietnam',
	txtAddressCountryYE: 'Jemen',
	txtAddressCountryZM: 'Zambia',
	txtAddressCountryZW: 'Zimbabwe'
};

localizationSharedCardDAV['it_IT']=	/* thanks Luca Ferrario */
{
	txtContacts: 'Contatti',

	pholderGiven: 'Nome',
	pholderFamily: 'Cognome',
	pholderMiddle: 'Altro Nome',
	pholderPrefix: 'Prefisso',
	pholderSuffix: 'Suffisso',

	txtAddressCountryAF: 'Afghanistan',
	txtAddressCountryAL: 'Albania',
	txtAddressCountryDZ: 'Algeria',
	txtAddressCountryAD: 'Andorra',
	txtAddressCountryAO: 'Angola',
	txtAddressCountryAG: 'Antigua e Barbuda',
	txtAddressCountryAR: 'Argentina',
	txtAddressCountryAM: 'Armenia',
	txtAddressCountryAU: 'Australia',
	txtAddressCountryAT: 'Austria',
	txtAddressCountryAZ: 'Azerbaijan',
	txtAddressCountryBS: 'Bahamas',
	txtAddressCountryBH: 'Bahrain',
	txtAddressCountryBD: 'Bangladesh',
	txtAddressCountryBB: 'Barbados',
	txtAddressCountryBY: 'Belarus',
	txtAddressCountryBE: 'Belgio',
	txtAddressCountryBZ: 'Belize',
	txtAddressCountryBJ: 'Benin',
	txtAddressCountryBM: 'Bermuda',
	txtAddressCountryBT: 'Bhutan',
	txtAddressCountryBO: 'Bolivia',
	txtAddressCountryBA: 'Bosnia Herzegovina',
	txtAddressCountryBW: 'Botswana',
	txtAddressCountryBR: 'Brasile',
	txtAddressCountryBN: 'Brunei Darussalam',
	txtAddressCountryBG: 'Bulgaria',
	txtAddressCountryBF: 'Burkina Faso',
	txtAddressCountryBI: 'Burundi',
	txtAddressCountryKH: 'Cambogia',
	txtAddressCountryCM: 'Camerun',
	txtAddressCountryCA: 'Canada',
	txtAddressCountryCV: 'Capo Verde',
	txtAddressCountryKY: 'Isole Cayman',
	txtAddressCountryCF: 'Repubblica Centrafricana',
	txtAddressCountryTD: 'Ciad',
	txtAddressCountryCL: 'Cile',
	txtAddressCountryCN: 'Cina',
	txtAddressCountryCO: 'Colombia',
	txtAddressCountryKM: 'Comore',
	txtAddressCountryCD: 'Repubblica Democratica del Congo',
	txtAddressCountryCG: 'Repubblica del Congo',
	txtAddressCountryCR: 'Costa Rica',
	txtAddressCountryCI: 'Costa d\'Avorio',
	txtAddressCountryHR: 'Croazia',
	txtAddressCountryCU: 'Cuba',
	txtAddressCountryCY: 'Cipro',
	txtAddressCountryCZ: 'Repubblica Ceca',
	txtAddressCountryDK: 'Danimarca',
	txtAddressCountryDJ: 'Djibouti',
	txtAddressCountryDM: 'Dominica',
	txtAddressCountryDO: 'Repubblica Dominicana',
	txtAddressCountryEC: 'Ecuador',
	txtAddressCountryEG: 'Egitto',
	txtAddressCountrySV: 'El Salvador',
	txtAddressCountryGQ: 'Guinea Equatoriale',
	txtAddressCountryER: 'Eritrea',
	txtAddressCountryEE: 'Estonia',
	txtAddressCountryET: 'Etiopia',
	txtAddressCountryFK: 'Isole Falkland',
	txtAddressCountryFO: 'Isole Faroe',
	txtAddressCountryFJ: 'Fiji',
	txtAddressCountryFI: 'Finlandia',
	txtAddressCountryFR: 'Francia',
	txtAddressCountryPF: 'Polinesia Francese',
	txtAddressCountryGA: 'Gabon',
	txtAddressCountryGM: 'Gambia',
	txtAddressCountryGE: 'Georgia',
	txtAddressCountryDE: 'Germania',
	txtAddressCountryGH: 'Ghana',
	txtAddressCountryGR: 'Grecia',
	txtAddressCountryGL: 'Groenlandia',
	txtAddressCountryGD: 'Grenada',
	txtAddressCountryGP: 'Guadeloupe',
	txtAddressCountryGT: 'Guatemala',
	txtAddressCountryGN: 'Guinea',
	txtAddressCountryGW: 'Guinea-Bissau',
	txtAddressCountryGY: 'Guyana',
	txtAddressCountryHT: 'Haiti',
	txtAddressCountryHN: 'Honduras',
	txtAddressCountryHK: 'Hong Kong',
	txtAddressCountryHU: 'Ungheria',
	txtAddressCountryIS: 'Islanda',
	txtAddressCountryIN: 'India',
	txtAddressCountryID: 'Indonesia',
	txtAddressCountryIR: 'Iran',
	txtAddressCountryIQ: 'Iraq',
	txtAddressCountryIE: 'Irlanda',
	txtAddressCountryIM: 'Isle of Man',
	txtAddressCountryIL: 'Israele',
	txtAddressCountryIT: 'Italia',
	txtAddressCountryJM: 'Jamaica',
	txtAddressCountryJP: 'Giappone',
	txtAddressCountryJO: 'Giordania',
	txtAddressCountryKZ: 'Kazakhstan',
	txtAddressCountryKE: 'Kenya',
	txtAddressCountryKI: 'Kiribati',
	txtAddressCountryKP: 'Korea del Nord',
	txtAddressCountryKR: 'Korea del Sud',
	txtAddressCountryKW: 'Kuwait',
	txtAddressCountryKG: 'Kyrgyzstan',
	txtAddressCountryLA: 'Laos',
	txtAddressCountryLV: 'Lettonia',
	txtAddressCountryLB: 'Libano',
	txtAddressCountryLS: 'Lesotho',
	txtAddressCountryLR: 'Liberia',
	txtAddressCountryLY: 'Libia',
	txtAddressCountryLI: 'Liechtenstein',
	txtAddressCountryLT: 'Lituania',
	txtAddressCountryLU: 'Lussemburgo',
	txtAddressCountryMO: 'Macau',
	txtAddressCountryMK: 'Macedonia',
	txtAddressCountryMG: 'Madagascar',
	txtAddressCountryMW: 'Malawi',
	txtAddressCountryMY: 'Malesia',
	txtAddressCountryMV: 'Maldive',
	txtAddressCountryML: 'Mali',
	txtAddressCountryMT: 'Malta',
	txtAddressCountryMH: 'Isole Marshall',
	txtAddressCountryMQ: 'Martinica',
	txtAddressCountryMR: 'Mauritania',
	txtAddressCountryMU: 'Mauritius',
	txtAddressCountryMX: 'Messico',
	txtAddressCountryFM: 'Micronesia',
	txtAddressCountryMD: 'Moldavia',
	txtAddressCountryMC: 'Monaco',
	txtAddressCountryMN: 'Mongolia',
	txtAddressCountryME: 'Montenegro',
	txtAddressCountryMA: 'Marocco',
	txtAddressCountryMZ: 'Mozambico',
	txtAddressCountryMM: 'Myanmar',
	txtAddressCountryNA: 'Namibia',
	txtAddressCountryNR: 'Nauru',
	txtAddressCountryNP: 'Nepal',
	txtAddressCountryNL: 'Olanda',
	txtAddressCountryNC: 'Nuova Caledonia',
	txtAddressCountryNZ: 'Nuova Zelanda',
	txtAddressCountryNI: 'Nicaragua',
	txtAddressCountryNE: 'Niger',
	txtAddressCountryNG: 'Nigeria',
	txtAddressCountryNO: 'Norvegia',
	txtAddressCountryOM: 'Oman',
	txtAddressCountryPK: 'Pakistan',
	txtAddressCountryPW: 'Palau',
	txtAddressCountryPS: 'Territori Palestinesi',
	txtAddressCountryPA: 'Panama',
	txtAddressCountryPG: 'Papua Nuova Guinea',
	txtAddressCountryPY: 'Paraguay',
	txtAddressCountryPE: 'Peru',
	txtAddressCountryPH: 'Flippine',
	txtAddressCountryPL: 'Polonia',
	txtAddressCountryPT: 'Portogallo',
	txtAddressCountryPR: 'Porto Rico',
	txtAddressCountryQA: 'Qatar',
	txtAddressCountryRE: 'Réunion',
	txtAddressCountryRO: 'Romania',
	txtAddressCountryRU: 'Russia',
	txtAddressCountryRW: 'Rwanda',
	txtAddressCountryBL: 'Saint Barthélemy',
	txtAddressCountrySH: 'Saint Helena',
	txtAddressCountryKN: 'Saint Kitts and Nevis',
	txtAddressCountryLC: 'Saint Lucia',
	txtAddressCountryMF: 'Saint Martin',
	txtAddressCountryVC: 'Saint Vincent and the Grenadines',
	txtAddressCountryWS: 'Samoa',
	txtAddressCountrySM: 'San Marino',
	txtAddressCountryST: 'Sao Tome e Principe',
	txtAddressCountrySA: 'Arabia Saudita',
	txtAddressCountrySN: 'Senegal',
	txtAddressCountryRS: 'Serbia',
	txtAddressCountrySC: 'Seychelles',
	txtAddressCountrySL: 'Sierra Leone',
	txtAddressCountrySG: 'Singapore',
	txtAddressCountrySK: 'Repubblica Slovacca',
	txtAddressCountrySI: 'Slovenia',
	txtAddressCountrySB: 'Isole Salomone',
	txtAddressCountrySO: 'Somalia',
	txtAddressCountryZA: 'Sudafrica',
	txtAddressCountryGS: 'South Georgia and South Sandwich Islands',
	txtAddressCountryES: 'Spagna',
	txtAddressCountryLK: 'Sri Lanka',
	txtAddressCountrySD: 'Sudan',
	txtAddressCountrySR: 'Suriname',
	txtAddressCountrySZ: 'Swaziland',
	txtAddressCountrySE: 'Svezia',
	txtAddressCountryCH: 'Svizzera',
	txtAddressCountrySY: 'Siria',
	txtAddressCountryTW: 'Taiwan',
	txtAddressCountryTJ: 'Tajikistan',
	txtAddressCountryTZ: 'Tanzania',
	txtAddressCountryTH: 'Tailandia',
	txtAddressCountryTL: 'Timor-Leste',
	txtAddressCountryTG: 'Togo',
	txtAddressCountryTO: 'Tonga',
	txtAddressCountryTT: 'Trinidad e Tobago',
	txtAddressCountryTN: 'Tunisia',
	txtAddressCountryTR: 'Turchia',
	txtAddressCountryTM: 'Turkmenistan',
	txtAddressCountryTV: 'Tuvalu',
	txtAddressCountryVI: 'Isole Vergini degli USA',
	txtAddressCountryUG: 'Uganda',
	txtAddressCountryUA: 'Ucraina',
	txtAddressCountryAE: 'Emirati Arabi Uniti',
	txtAddressCountryGB: 'Regno Unito',
	txtAddressCountryUS: 'Stati uniti d\'America',
	txtAddressCountryUY: 'Uruguay',
	txtAddressCountryUZ: 'Uzbekistan',
	txtAddressCountryVU: 'Vanuatu',
	txtAddressCountryVA: 'Vaticano',
	txtAddressCountryVE: 'Venezuela',
	txtAddressCountryVN: 'Vietnam',
	txtAddressCountryYE: 'Yemen',
	txtAddressCountryZM: 'Zambia',
	txtAddressCountryZW: 'Zimbabwe'
};

localizationSharedCardDAV['ja_JP']=	/* Muimu Nakayama */
{
	txtContacts: '連絡先',

	pholderGiven: '名',
	pholderFamily: '姓',
	pholderMiddle: 'ミドルネーム',
	pholderPrefix: '敬称（前置）',
	pholderSuffix: '敬称（後置）',

	txtAddressCountryAF: 'アフガニスタン',
	txtAddressCountryAL: 'アルバニア',
	txtAddressCountryDZ: 'アルジェリア',
	txtAddressCountryAD: 'アンドラ',
	txtAddressCountryAO: 'アンゴラ',
	txtAddressCountryAG: 'アンティグア・バーブーダ',
	txtAddressCountryAR: 'アルゼンチン',
	txtAddressCountryAM: 'アルメニア',
	txtAddressCountryAU: 'オーストラリア',
	txtAddressCountryAT: 'オーストリア',
	txtAddressCountryAZ: 'アゼルバイジャン',
	txtAddressCountryBS: 'バハマ',
	txtAddressCountryBH: 'バーレーン',
	txtAddressCountryBD: 'バングラデシュ',
	txtAddressCountryBB: 'バルバドス',
	txtAddressCountryBY: 'ベラルーシ',
	txtAddressCountryBE: 'ベルギー',
	txtAddressCountryBZ: 'ベリーズ',
	txtAddressCountryBJ: 'ベナン',
	txtAddressCountryBM: 'バーミューダ諸島',
	txtAddressCountryBT: 'ブータン',
	txtAddressCountryBO: 'ボリビア',
	txtAddressCountryBA: 'ボスニア・ヘルツェゴビナ',
	txtAddressCountryBW: 'ボツワナ',
	txtAddressCountryBR: 'ブラジル',
	txtAddressCountryBN: 'ブルネイ',
	txtAddressCountryBG: 'ブルガリア',
	txtAddressCountryBF: 'ブルキナファソ',
	txtAddressCountryBI: 'ブルンジ',
	txtAddressCountryKH: 'カンボジア',
	txtAddressCountryCM: 'カメルーン',
	txtAddressCountryCA: 'カナダ',
	txtAddressCountryCV: 'カーボヴェルデ',
	txtAddressCountryKY: 'ケイマン諸島',
	txtAddressCountryCF: '中央アフリカ共和国',
	txtAddressCountryTD: 'チャド',
	txtAddressCountryCL: 'チリ',
	txtAddressCountryCN: '中国',
	txtAddressCountryCO: 'コロンビア',
	txtAddressCountryKM: 'コモロ',
	txtAddressCountryCD: 'コンゴ民主共和国',
	txtAddressCountryCG: 'コンゴ共和国',
	txtAddressCountryCR: 'コスタリカ',
	txtAddressCountryCI: 'コートジボワール',
	txtAddressCountryHR: 'クロアチア',
	txtAddressCountryCU: 'キューバ',
	txtAddressCountryCY: 'キプロス',
	txtAddressCountryCZ: 'チェコ',
	txtAddressCountryDK: 'デンマーク',
	txtAddressCountryDJ: 'ジブチ',
	txtAddressCountryDM: 'ドミニカ',
	txtAddressCountryDO: 'ドミニカ共和国',
	txtAddressCountryEC: 'エクアドル',
	txtAddressCountryEG: 'エジプト',
	txtAddressCountrySV: 'エルサルバドル',
	txtAddressCountryGQ: '赤道ギニア',
	txtAddressCountryER: 'エリトリア',
	txtAddressCountryEE: 'エストニア',
	txtAddressCountryET: 'エチオピア',
	txtAddressCountryFK: 'フォークランド諸島',
	txtAddressCountryFO: 'フェロー諸島',
	txtAddressCountryFJ: 'フィジー',
	txtAddressCountryFI: 'フィンランド',
	txtAddressCountryFR: 'フランス',
	txtAddressCountryPF: '仏領ポリネシア',
	txtAddressCountryGA: 'ガボン',
	txtAddressCountryGM: 'ガンビア',
	txtAddressCountryGE: 'グルジア',
	txtAddressCountryDE: 'ドイツ',
	txtAddressCountryGH: 'ガーナ',
	txtAddressCountryGR: 'ギリシア',
	txtAddressCountryGL: 'グリーンランド',
	txtAddressCountryGD: 'グレナダ',
	txtAddressCountryGP: 'グアドループ',
	txtAddressCountryGT: 'グアテマラ',
	txtAddressCountryGN: 'ギニア',
	txtAddressCountryGW: 'ギニアビサウ',
	txtAddressCountryGY: 'ガイアナ',
	txtAddressCountryHT: 'ハイチ',
	txtAddressCountryHN: 'ホンジュラス',
	txtAddressCountryHK: '香港',
	txtAddressCountryHU: 'ハンガリー',
	txtAddressCountryIS: 'アイスランド',
	txtAddressCountryIN: 'インド',
	txtAddressCountryID: 'インドネシア',
	txtAddressCountryIR: 'イラン',
	txtAddressCountryIQ: 'イラク',
	txtAddressCountryIE: 'アイルランド',
	txtAddressCountryIM: 'マン島',
	txtAddressCountryIL: 'イスラエル',
	txtAddressCountryIT: 'イタリア',
	txtAddressCountryJM: 'ジャマイカ',
	txtAddressCountryJP: '日本',
	txtAddressCountryJO: 'ヨルダン',
	txtAddressCountryKZ: 'カザフスタン',
	txtAddressCountryKE: 'ケニア',
	txtAddressCountryKI: 'キリバス',
	txtAddressCountryKP: '朝鮮民主主義人民共和国',
	txtAddressCountryKR: '大韓民国',
	txtAddressCountryKW: 'クウェート',
	txtAddressCountryKG: 'キルギス',
	txtAddressCountryLA: 'ラオス',
	txtAddressCountryLV: 'ラトビア',
	txtAddressCountryLB: 'レバノン',
	txtAddressCountryLS: 'レソト',
	txtAddressCountryLR: 'リベリア',
	txtAddressCountryLY: 'リビア',
	txtAddressCountryLI: 'リヒテンシュタイン',
	txtAddressCountryLT: 'リトアニア',
	txtAddressCountryLU: 'ルクセンブルク',
	txtAddressCountryMO: 'マカオ',
	txtAddressCountryMK: 'マケドニア',
	txtAddressCountryMG: 'マダガスカル',
	txtAddressCountryMW: 'マラウイ',
	txtAddressCountryMY: 'マレーシア',
	txtAddressCountryMV: 'モルジブ',
	txtAddressCountryML: 'マリ',
	txtAddressCountryMT: 'マルタ',
	txtAddressCountryMH: 'マーシャル諸島',
	txtAddressCountryMQ: 'マルティニーク',
	txtAddressCountryMR: 'モーリタニア',
	txtAddressCountryMU: 'モーリシャス',
	txtAddressCountryMX: 'メキシコ',
	txtAddressCountryFM: 'ミクロネシア',
	txtAddressCountryMD: 'モルドバ',
	txtAddressCountryMC: 'モナコ',
	txtAddressCountryMN: 'モンゴル',
	txtAddressCountryME: 'モンテネグロ',
	txtAddressCountryMA: 'モロッコ',
	txtAddressCountryMZ: 'モザンビーク',
	txtAddressCountryMM: 'ミャンマー',
	txtAddressCountryNA: 'ナミビア',
	txtAddressCountryNR: 'ナウル',
	txtAddressCountryNP: 'ネパール',
	txtAddressCountryNL: 'オランダ',
	txtAddressCountryNC: 'ニューカレドニア',
	txtAddressCountryNZ: 'ニュージーランド',
	txtAddressCountryNI: 'ニカラグア',
	txtAddressCountryNE: 'ニジェール',
	txtAddressCountryNG: 'ナイジェリア',
	txtAddressCountryNO: 'ノルウェイ',
	txtAddressCountryOM: 'オマーン',
	txtAddressCountryPK: 'パキスタン',
	txtAddressCountryPW: 'パラオ',
	txtAddressCountryPS: 'パレスチナ自治区',
	txtAddressCountryPA: 'パナマ',
	txtAddressCountryPG: 'パプアニューギニア',
	txtAddressCountryPY: 'パラグアイ',
	txtAddressCountryPE: 'ペルー',
	txtAddressCountryPH: 'フィリピン',
	txtAddressCountryPL: 'ポーランド',
	txtAddressCountryPT: 'ポルトガル',
	txtAddressCountryPR: 'プエルトリコ',
	txtAddressCountryQA: 'カタール',
	txtAddressCountryRE: 'レユニオン',
	txtAddressCountryRO: 'ルーマニア',
	txtAddressCountryRU: 'ロシア',
	txtAddressCountryRW: 'ルワンダ',
	txtAddressCountryBL: 'サン・バルテルミー',
	txtAddressCountrySH: 'セントヘレナ',
	txtAddressCountryKN: 'セントクリストファー・ネイビス',
	txtAddressCountryLC: 'セントルシア',
	txtAddressCountryMF: 'セント・マーチン',
	txtAddressCountryVC: 'セントビンセント・グレナディーン',
	txtAddressCountryWS: 'サモア',
	txtAddressCountrySM: 'サンマリノ',
	txtAddressCountryST: 'サントメ・プリンシペ',
	txtAddressCountrySA: 'サウジアラビア',
	txtAddressCountrySN: 'セネガル',
	txtAddressCountryRS: 'セルビア',
	txtAddressCountrySC: 'セイシェル',
	txtAddressCountrySL: 'シエラレオネ',
	txtAddressCountrySG: 'シンガポール',
	txtAddressCountrySK: 'スロバキア',
	txtAddressCountrySI: 'スロベニア',
	txtAddressCountrySB: 'ソロモン諸島',
	txtAddressCountrySO: 'ソマリア',
	txtAddressCountryZA: '南アフリカ',
	txtAddressCountryGS: 'サウスジョージア・サウスサンドウィッチ諸島',
	txtAddressCountryES: 'スペイン',
	txtAddressCountryLK: 'スリランカ',
	txtAddressCountrySD: 'スーダン',
	txtAddressCountrySR: 'スリナム',
	txtAddressCountrySZ: 'スワジランド',
	txtAddressCountrySE: 'スウェーデン',
	txtAddressCountryCH: 'スイス',
	txtAddressCountrySY: 'シリア',
	txtAddressCountryTW: '台湾',
	txtAddressCountryTJ: 'タジキスタン',
	txtAddressCountryTZ: 'タンザニア',
	txtAddressCountryTH: 'タイ',
	txtAddressCountryTL: '東ティモール',
	txtAddressCountryTG: 'トーゴ',
	txtAddressCountryTO: 'トンガ',
	txtAddressCountryTT: 'トリニダード・トバゴ',
	txtAddressCountryTN: 'チュニジア',
	txtAddressCountryTR: 'トルコ',
	txtAddressCountryTM: 'トルクメニスタン',
	txtAddressCountryTV: 'ツバル',
	txtAddressCountryVI: '米領ヴァージン諸島',
	txtAddressCountryUG: 'ウガンダ',
	txtAddressCountryUA: 'ウクライナ',
	txtAddressCountryAE: 'アラブ首長国連邦',
	txtAddressCountryGB: 'イギリス',
	txtAddressCountryUS: 'アメリカ合衆国',
	txtAddressCountryUY: 'ウルグアイ',
	txtAddressCountryUZ: 'ウズベキスタン',
	txtAddressCountryVU: 'バヌアツ',
	txtAddressCountryVA: 'バチカン',
	txtAddressCountryVE: 'ベネズエラ',
	txtAddressCountryVN: 'ベトナム',
	txtAddressCountryYE: 'イエメン',
	txtAddressCountryZM: 'ザンビア',
	txtAddressCountryZW: 'ジンバブエ'
};

localizationSharedCardDAV['nb_NO']=	/* thanks Tore Ørpetveit */
{
	txtContacts: 'Kontakter',

	pholderGiven: 'Fornavn',
	pholderFamily: 'Etternavn',
	pholderMiddle: 'Mellomnavn',
	pholderPrefix: 'Prefiks',
	pholderSuffix: 'Suffiks',

	txtAddressCountryAF: 'Afghanistan',
	txtAddressCountryAL: 'Albania',
	txtAddressCountryDZ: 'Algerie',
	txtAddressCountryAD: 'Andorra',
	txtAddressCountryAO: 'Angola',
	txtAddressCountryAG: 'Antigua og Barbuda',
	txtAddressCountryAR: 'Argentina',
	txtAddressCountryAM: 'Armenia',
	txtAddressCountryAU: 'Australia',
	txtAddressCountryAT: 'Østerrike',
	txtAddressCountryAZ: 'Aserbajdsjan',
	txtAddressCountryBS: 'Bahamas',
	txtAddressCountryBH: 'Bahrain',
	txtAddressCountryBD: 'Bangladesh',
	txtAddressCountryBB: 'Barbados',
	txtAddressCountryBY: 'Belarus',
	txtAddressCountryBE: 'Belgia',
	txtAddressCountryBZ: 'Belize',
	txtAddressCountryBJ: 'Benin',
	txtAddressCountryBM: 'Bermuda',
	txtAddressCountryBT: 'Bhutan',
	txtAddressCountryBO: 'Bolivia',
	txtAddressCountryBA: 'Bosnia og Hercegovina',
	txtAddressCountryBW: 'Botswana',
	txtAddressCountryBR: 'Brasilia',
	txtAddressCountryBN: 'Brunei',
	txtAddressCountryBG: 'Bulgaria',
	txtAddressCountryBF: 'Burkina Faso',
	txtAddressCountryBI: 'Burundi',
	txtAddressCountryKH: 'Cambodja',
	txtAddressCountryCM: 'Camerun',
	txtAddressCountryCA: 'Canada',
	txtAddressCountryCV: 'Kapp Verde',
	txtAddressCountryKY: 'Cayman Islands',
	txtAddressCountryCF: 'Den Sentralafrikanske Republikk',
	txtAddressCountryTD: 'Tsjad',
	txtAddressCountryCL: 'Chile',
	txtAddressCountryCN: 'Kina',
	txtAddressCountryCO: 'Colombia',
	txtAddressCountryKM: 'Komorene',
	txtAddressCountryCD: 'Den Demokratiske Republikk Kongo',
	txtAddressCountryCG: 'Republikk Kongo',
	txtAddressCountryCR: 'Costa Rica',
	txtAddressCountryCI: 'Elfenbenskysten',
	txtAddressCountryHR: 'Kroatia',
	txtAddressCountryCU: 'Cuba',
	txtAddressCountryCY: 'Kypros',
	txtAddressCountryCZ: 'Tsjekkia',
	txtAddressCountryDK: 'Danmark',
	txtAddressCountryDJ: 'Djibouti',
	txtAddressCountryDM: 'Dominica',
	txtAddressCountryDO: 'Den Dominikanske Republikk',
	txtAddressCountryEC: 'Ecuador',
	txtAddressCountryEG: 'Egypt',
	txtAddressCountrySV: 'El Salvador',
	txtAddressCountryGQ: 'Ekvatorial-Guinea',
	txtAddressCountryER: 'Eritrea',
	txtAddressCountryEE: 'Estland',
	txtAddressCountryET: 'Etiopi',
	txtAddressCountryFK: 'Falklandsøyene',
	txtAddressCountryFO: 'Færøyene',
	txtAddressCountryFJ: 'Fiji',
	txtAddressCountryFI: 'Finland',
	txtAddressCountryFR: 'Frankrike',
	txtAddressCountryPF: 'Fransk Polynesia',
	txtAddressCountryGA: 'Gabon',
	txtAddressCountryGM: 'Gambia',
	txtAddressCountryGE: 'Georgia',
	txtAddressCountryDE: 'Tyskland',
	txtAddressCountryGH: 'Ghana',
	txtAddressCountryGR: 'Hellas',
	txtAddressCountryGL: 'Grønland',
	txtAddressCountryGD: 'Grenada',
	txtAddressCountryGP: 'Guadeloupe',
	txtAddressCountryGT: 'Guatemala',
	txtAddressCountryGN: 'Guinea',
	txtAddressCountryGW: 'Guinea-Bissau',
	txtAddressCountryGY: 'Guyana',
	txtAddressCountryHT: 'Haiti',
	txtAddressCountryHN: 'Honduras',
	txtAddressCountryHK: 'Hong Kong',
	txtAddressCountryHU: 'Ungarn',
	txtAddressCountryIS: 'Island',
	txtAddressCountryIN: 'India',
	txtAddressCountryID: 'Indonesia',
	txtAddressCountryIR: 'Iran',
	txtAddressCountryIQ: 'Irak',
	txtAddressCountryIE: 'Irland',
	txtAddressCountryIM: 'Isle of Man',
	txtAddressCountryIL: 'Israel',
	txtAddressCountryIT: 'Italia',
	txtAddressCountryJM: 'Jamaica',
	txtAddressCountryJP: 'Japan',
	txtAddressCountryJO: 'Jordan',
	txtAddressCountryKZ: 'Kasakhstan',
	txtAddressCountryKE: 'Kenya',
	txtAddressCountryKI: 'Kiribati',
	txtAddressCountryKP: 'Nordkorea',
	txtAddressCountryKR: 'Sydkorea',
	txtAddressCountryKW: 'Kuwait',
	txtAddressCountryKG: 'Kirgisistan',
	txtAddressCountryLA: 'Laos',
	txtAddressCountryLV: 'Letland',
	txtAddressCountryLB: 'Libanon',
	txtAddressCountryLS: 'Lesotho',
	txtAddressCountryLR: 'Liberia',
	txtAddressCountryLY: 'Libya',
	txtAddressCountryLI: 'Liechtenstein',
	txtAddressCountryLT: 'Litauen',
	txtAddressCountryLU: 'Luxembourg',
	txtAddressCountryMO: 'Macao',
	txtAddressCountryMK: 'Makedonia',
	txtAddressCountryMG: 'Madagaskar',
	txtAddressCountryMW: 'Malawi',
	txtAddressCountryMY: 'Malaysia',
	txtAddressCountryMV: 'Maldivene',
	txtAddressCountryML: 'Mali',
	txtAddressCountryMT: 'Malta',
	txtAddressCountryMH: 'Marshalløyene',
	txtAddressCountryMQ: 'Martinique',
	txtAddressCountryMR: 'Mauretania',
	txtAddressCountryMU: 'Mauritius',
	txtAddressCountryMX: 'Mexico',
	txtAddressCountryFM: 'Mikronesiaføderasjonen',
	txtAddressCountryMD: 'Moldova',
	txtAddressCountryMC: 'Monaco',
	txtAddressCountryMN: 'Mongolia',
	txtAddressCountryME: 'Montenegro',
	txtAddressCountryMA: 'Marokko',
	txtAddressCountryMZ: 'Mozambik',
	txtAddressCountryMM: 'Myanmar',
	txtAddressCountryNA: 'Namibia',
	txtAddressCountryNR: 'Nauru',
	txtAddressCountryNP: 'Nepal',
	txtAddressCountryNL: 'Holland',
	txtAddressCountryNC: 'Ny-Kaledonia',
	txtAddressCountryNZ: 'New Zealand',
	txtAddressCountryNI: 'Nicaragua',
	txtAddressCountryNE: 'Niger',
	txtAddressCountryNG: 'Nigeria',
	txtAddressCountryNO: 'Norge',
	txtAddressCountryOM: 'Oman',
	txtAddressCountryPK: 'Pakistan',
	txtAddressCountryPW: 'Palau',
	txtAddressCountryPS: 'Palestina',
	txtAddressCountryPA: 'Panama',
	txtAddressCountryPG: 'Papua Ny Guinea',
	txtAddressCountryPY: 'Paraguay',
	txtAddressCountryPE: 'Peru',
	txtAddressCountryPH: 'Filippinene',
	txtAddressCountryPL: 'Polen',
	txtAddressCountryPT: 'Portugal',
	txtAddressCountryPR: 'Puerto Rico',
	txtAddressCountryQA: 'Qatar',
	txtAddressCountryRE: 'Reunion',
	txtAddressCountryRO: 'Romania',
	txtAddressCountryRU: 'Russland',
	txtAddressCountryRW: 'Rwanda',
	txtAddressCountryBL: 'Saint-Barthelemy',
	txtAddressCountrySH: 'Saint Helena',
	txtAddressCountryKN: 'Saint Kitts og Nevis',
	txtAddressCountryLC: 'Saint Lucia',
	txtAddressCountryMF: 'Saint Martin',
	txtAddressCountryVC: 'Saint Vincent og Grenadinene',
	txtAddressCountryWS: 'Samoa',
	txtAddressCountrySM: 'San Marino',
	txtAddressCountryST: 'Sao Tome og Principe',
	txtAddressCountrySA: 'Saudi-Arabia',
	txtAddressCountrySN: 'Senegal',
	txtAddressCountryRS: 'Serbia',
	txtAddressCountrySC: 'Seychellene',
	txtAddressCountrySL: 'Sierra Leone',
	txtAddressCountrySG: 'Singapore',
	txtAddressCountrySK: 'Slovakia',
	txtAddressCountrySI: 'Slovenia',
	txtAddressCountrySB: 'Salomonøyene',
	txtAddressCountrySO: 'Somalia',
	txtAddressCountryZA: 'Sørafrika',
	txtAddressCountryGS: 'Sør-Georgia og Sør-Sandwichøyene',
	txtAddressCountryES: 'Spania',
	txtAddressCountryLK: 'Sri Lanka',
	txtAddressCountrySD: 'Sudan',
	txtAddressCountrySR: 'Surinam',
	txtAddressCountrySZ: 'Swaziland',
	txtAddressCountrySE: 'Sverige',
	txtAddressCountryCH: 'Sveits',
	txtAddressCountrySY: 'Syria',
	txtAddressCountryTW: 'Taiwan',
	txtAddressCountryTJ: 'Tadsjikistan',
	txtAddressCountryTZ: 'Tanzania',
	txtAddressCountryTH: 'Thailand',
	txtAddressCountryTL: 'Timor-Leste',
	txtAddressCountryTG: 'Togo',
	txtAddressCountryTO: 'Tonga',
	txtAddressCountryTT: 'Trinidad og Tobago',
	txtAddressCountryTN: 'Tunesia',
	txtAddressCountryTR: 'Tyrkia',
	txtAddressCountryTM: 'Turkmenistan',
	txtAddressCountryTV: 'Tuvalu',
	txtAddressCountryVI: 'Jomfruøyene',
	txtAddressCountryUG: 'Uganda',
	txtAddressCountryUA: 'Ukraina',
	txtAddressCountryAE: 'De Forente Arabiske Emirater',
	txtAddressCountryGB: 'Storbritannia',
	txtAddressCountryUS: 'USA',
	txtAddressCountryUY: 'Uruguay',
	txtAddressCountryUZ: 'Usbekistan',
	txtAddressCountryVU: 'Vanuatu',
	txtAddressCountryVA: 'Vatikanet',
	txtAddressCountryVE: 'Venezuela',
	txtAddressCountryVN: 'Vietnam',
	txtAddressCountryYE: 'Yemen',
	txtAddressCountryZM: 'Zambia',
	txtAddressCountryZW: 'Zimbabwe'
};

localizationSharedCardDAV['nl_NL']=	/* thanks Johan Vromans */
{
	txtContacts: 'Contacten',

	pholderGiven: 'Voornaam',
	pholderFamily: 'Achternaam',
	pholderMiddle: 'Tussenvoegsel',
	pholderPrefix: 'Voorvoegsel',
	pholderSuffix: 'Achtervoegsel',

	txtAddressCountryAF: 'Afghanistan',
	txtAddressCountryAL: 'Albanië',
	txtAddressCountryDZ: 'Algerije',
	txtAddressCountryAD: 'Andorra',
	txtAddressCountryAO: 'Angola',
	txtAddressCountryAG: 'Antigua en Barbuda',
	txtAddressCountryAR: 'Argentinië',
	txtAddressCountryAM: 'Armenië',
	txtAddressCountryAU: 'Australië',
	txtAddressCountryAT: 'Oostenrijk',
	txtAddressCountryAZ: 'Azerbeidzjan',
	txtAddressCountryBS: 'Bahama’s',
	txtAddressCountryBH: 'Bahrein',
	txtAddressCountryBD: 'Bangladesh',
	txtAddressCountryBB: 'Barbados',
	txtAddressCountryBY: 'Wit-Rusland',
	txtAddressCountryBE: 'België',
	txtAddressCountryBZ: 'Belize (land)',
	txtAddressCountryBJ: 'Benin',
	txtAddressCountryBM: 'Bermuda',
	txtAddressCountryBT: 'Bhutan',
	txtAddressCountryBO: 'Bolivia',
	txtAddressCountryBA: 'Bosnië-Herzegovina',
	txtAddressCountryBW: 'Botswana',
	txtAddressCountryBR: 'Brazilië',
	txtAddressCountryBN: 'Brunei',
	txtAddressCountryBG: 'Bulgarije',
	txtAddressCountryBF: 'Burkina Faso',
	txtAddressCountryBI: 'Burundi',
	txtAddressCountryKH: 'Cambodja',
	txtAddressCountryCM: 'Kameroen',
	txtAddressCountryCA: 'Canada',
	txtAddressCountryCV: 'Kaapverdië',
	txtAddressCountryKY: 'Caymaneilanden',
	txtAddressCountryCF: 'Centraal-Afrikaanse Republiek',
	txtAddressCountryTD: 'Tsjaad',
	txtAddressCountryCL: 'Chili',
	txtAddressCountryCN: 'Volksrepubliek China',
	txtAddressCountryCO: 'Colombia',
	txtAddressCountryKM: 'Comoren',
	txtAddressCountryCD: 'Congo-Kinshasa',
	txtAddressCountryCG: 'Congo-Brazzaville',
	txtAddressCountryCR: 'Costa Rica',
	txtAddressCountryCI: 'Ivoorkust',
	txtAddressCountryHR: 'Kroatië',
	txtAddressCountryCU: 'Cuba',
	txtAddressCountryCY: 'Cyprus',
	txtAddressCountryCZ: 'Tsjechië',
	txtAddressCountryDK: 'Denemarken',
	txtAddressCountryDJ: 'Djibouti',
	txtAddressCountryDM: 'Dominica',
	txtAddressCountryDO: 'Dominicaanse Republiek',
	txtAddressCountryEC: 'Ecuador',
	txtAddressCountryEG: 'Egypte',
	txtAddressCountrySV: 'El Salvador',
	txtAddressCountryGQ: 'Equatoriaal-Guinea',
	txtAddressCountryER: 'Eritrea',
	txtAddressCountryEE: 'Estland',
	txtAddressCountryET: 'Ethiopië',
	txtAddressCountryFK: 'Falklandeilanden',
	txtAddressCountryFO: 'Faeröer',
	txtAddressCountryFJ: 'Fiji',
	txtAddressCountryFI: 'Finland',
	txtAddressCountryFR: 'Frankrijk',
	txtAddressCountryPF: 'Frans-Polynesië',
	txtAddressCountryGA: 'Gabon',
	txtAddressCountryGM: 'Gambia (land)',
	txtAddressCountryGE: 'Georgië',
	txtAddressCountryDE: 'Duitsland',
	txtAddressCountryGH: 'Ghana',
	txtAddressCountryGR: 'Griekenland',
	txtAddressCountryGL: 'Groenland',
	txtAddressCountryGD: 'Grenada',
	txtAddressCountryGP: 'Guadeloupe',
	txtAddressCountryGT: 'Guatemala',
	txtAddressCountryGN: 'Guinee',
	txtAddressCountryGW: 'Guinee-Bissau',
	txtAddressCountryGY: 'Guyana',
	txtAddressCountryHT: 'Haïti',
	txtAddressCountryHN: 'Honduras',
	txtAddressCountryHK: 'Hongkong',
	txtAddressCountryHU: 'Hongarije',
	txtAddressCountryIS: 'IJsland',
	txtAddressCountryIN: 'India',
	txtAddressCountryID: 'Indonesië',
	txtAddressCountryIR: 'Iran',
	txtAddressCountryIQ: 'Irak',
	txtAddressCountryIE: 'Ierse Republiek',
	txtAddressCountryIM: 'Isle of Man',
	txtAddressCountryIL: 'Israël',
	txtAddressCountryIT: 'Italië',
	txtAddressCountryJM: 'Jamaica',
	txtAddressCountryJP: 'Japan',
	txtAddressCountryJO: 'Jordanië',
	txtAddressCountryKZ: 'Kazachstan',
	txtAddressCountryKE: 'Kenia',
	txtAddressCountryKI: 'Kiribati',
	txtAddressCountryKP: 'Noord-Korea',
	txtAddressCountryKR: 'Zuid-Korea',
	txtAddressCountryKW: 'Koeweit',
	txtAddressCountryKG: 'Kirgizië',
	txtAddressCountryLA: 'Laos',
	txtAddressCountryLV: 'Letland',
	txtAddressCountryLB: 'Libanon',
	txtAddressCountryLS: 'Lesotho',
	txtAddressCountryLR: 'Liberia',
	txtAddressCountryLY: 'Libië',
	txtAddressCountryLI: 'Liechtenstein',
	txtAddressCountryLT: 'Litouwen',
	txtAddressCountryLU: 'Luxemburg',
	txtAddressCountryMO: 'Macao',
	txtAddressCountryMK: 'Macedonië',
	txtAddressCountryMG: 'Madagaskar',
	txtAddressCountryMW: 'Malawi',
	txtAddressCountryMY: 'Maleisië',
	txtAddressCountryMV: 'Maldiven',
	txtAddressCountryML: 'Mali',
	txtAddressCountryMT: 'Malta',
	txtAddressCountryMH: 'Marshalleilanden',
	txtAddressCountryMQ: 'Martinique',
	txtAddressCountryMR: 'Mauritanië',
	txtAddressCountryMU: 'Mauritius',
	txtAddressCountryMX: 'Mexico (land)',
	txtAddressCountryFM: 'Micronesia',
	txtAddressCountryMD: 'Moldavië',
	txtAddressCountryMC: 'Monaco',
	txtAddressCountryMN: 'Mongolië',
	txtAddressCountryMA: 'Marokko',
	txtAddressCountryMZ: 'Mozambique',
	txtAddressCountryMM: 'Myanmar',
	txtAddressCountryNA: 'Namibië',
	txtAddressCountryNR: 'Nauru',
	txtAddressCountryNP: 'Nepal',
	txtAddressCountryNL: 'Nederland',
	txtAddressCountryNC: 'Nieuw-Caledonië',
	txtAddressCountryNZ: 'Nieuw-Zeeland',
	txtAddressCountryNI: 'Nicaragua',
	txtAddressCountryNE: 'Niger (land)',
	txtAddressCountryNG: 'Nigeria',
	txtAddressCountryNO: 'Noorwegen',
	txtAddressCountryOM: 'Oman',
	txtAddressCountryPK: 'Pakistan',
	txtAddressCountryPW: 'Palau (land)',
	txtAddressCountryPS: 'Palestina',
	txtAddressCountryPA: 'Panama (land)',
	txtAddressCountryPG: 'Papoea-Nieuw-Guinea',
	txtAddressCountryPY: 'Paraguay',
	txtAddressCountryPE: 'Peru',
	txtAddressCountryPH: 'Filipijnen',
	txtAddressCountryPL: 'Polen',
	txtAddressCountryPT: 'Portugal',
	txtAddressCountryPR: 'Puerto Rico',
	txtAddressCountryQA: 'Qatar',
	txtAddressCountryRE: 'Réunion',
	txtAddressCountryRO: 'Roemenië',
	txtAddressCountryRU: 'Rusland',
	txtAddressCountryRW: 'Rwanda',
	txtAddressCountrySH: 'Sint Helena',
	txtAddressCountryKN: 'Saint Kitts en Nevis',
	txtAddressCountryLC: 'Saint Lucia',
	txtAddressCountryVC: 'Saint Vincent en de Grenadines',
	txtAddressCountryWS: 'Samoa',
	txtAddressCountrySM: 'San Marino',
	txtAddressCountryST: 'São Tomé en Principe',
	txtAddressCountrySA: 'Saoedi-Arabië',
	txtAddressCountrySN: 'Servië',
	txtAddressCountrySC: 'Seychellen',
	txtAddressCountrySL: 'Sierra Leone',
	txtAddressCountrySG: 'Singapore',
	txtAddressCountrySK: 'Slowakije',
	txtAddressCountrySI: 'Slovenië',
	txtAddressCountrySB: 'Solomon Eilanden',
	txtAddressCountrySO: 'Somalië',
	txtAddressCountryZA: 'Zuid-Afrika',
	txtAddressCountryGS: 'Sandwich Eilanden',
	txtAddressCountryES: 'Spanje',
	txtAddressCountryLK: 'Sri Lanka',
	txtAddressCountrySD: 'Soedan',
	txtAddressCountrySR: 'Suriname',
	txtAddressCountrySZ: 'Swaziland',
	txtAddressCountrySE: 'Zweden',
	txtAddressCountryCH: 'Zwitserland',
	txtAddressCountrySY: 'Syrië',
	txtAddressCountryTW: 'Taiwan',
	txtAddressCountryTJ: 'Tadzjikistan',
	txtAddressCountryTZ: 'Tanzania',
	txtAddressCountryTH: 'Thailand',
	txtAddressCountryTL: 'Oost-Timor',
	txtAddressCountryTG: 'Togo',
	txtAddressCountryTO: 'Tonga (land)',
	txtAddressCountryTT: 'Trinidad en Tobago',
	txtAddressCountryTN: 'Tunesië',
	txtAddressCountryTR: 'Turkije',
	txtAddressCountryTM: 'Turkmenistan',
	txtAddressCountryTV: 'Tuvalu',
	txtAddressCountryVI: 'Amerikaanse Maagdeneilanden',
	txtAddressCountryUG: 'Oeganda',
	txtAddressCountryUA: 'Oekraïne',
	txtAddressCountryAE: 'Verenigde Arabische Emiraten',
	txtAddressCountryGB: 'Verenigd Koninkrijk',
	txtAddressCountryUS: 'Verenigde Staten van Amerika',
	txtAddressCountryUY: 'Uruguay',
	txtAddressCountryUZ: 'Oezbekistan',
	txtAddressCountryVU: 'Vanuatu',
	txtAddressCountryVA: 'Vaticaanstad',
	txtAddressCountryVE: 'Venezuela',
	txtAddressCountryVN: 'Vietnam',
	txtAddressCountryYE: 'Jemen',
	txtAddressCountryZM: 'Zambia',
	txtAddressCountryZW: 'Zimbabwe',
	txtAddressCountryME: 'Montenegro',
	txtAddressCountryBL: 'Saint Barthélemy',
	txtAddressCountryMF: 'Saint Martin',
	txtAddressCountryRS: 'Serbia'
};

localizationSharedCardDAV['sk_SK']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	txtContacts: 'Kontakty',

	pholderGiven: 'Meno',
	pholderFamily: 'Priezvisko',
	pholderMiddle: 'Stredné meno',
	pholderPrefix: 'Titul pred',
	pholderSuffix: 'Titul za',

	txtAddressCountryAF: 'Afganistan',
	txtAddressCountryAL: 'Albánsko',
	txtAddressCountryDZ: 'Alžírsko',
	txtAddressCountryAD: 'Andora',
	txtAddressCountryAO: 'Angola',
	txtAddressCountryAG: 'Antigua a Barbuda',
	txtAddressCountryAR: 'Argentína',
	txtAddressCountryAM: 'Arménsko',
	txtAddressCountryAU: 'Austrália',
	txtAddressCountryAT: 'Rakúsko',
	txtAddressCountryAZ: 'Azerbajdžan',
	txtAddressCountryBS: 'Bahamy',
	txtAddressCountryBH: 'Bahrajn',
	txtAddressCountryBD: 'Bangladéš',
	txtAddressCountryBB: 'Barbados',
	txtAddressCountryBY: 'Bielorusko',
	txtAddressCountryBE: 'Belgicko',
	txtAddressCountryBZ: 'Belize',
	txtAddressCountryBJ: 'Benin',
	txtAddressCountryBM: 'Bermudy',
	txtAddressCountryBT: 'Bután',
	txtAddressCountryBO: 'Bolívia',
	txtAddressCountryBA: 'Bosna a Hercegovina',
	txtAddressCountryBW: 'Botswana',
	txtAddressCountryBR: 'Brazília',
	txtAddressCountryBN: 'Brunei Darussalam',
	txtAddressCountryBG: 'Bulharsko',
	txtAddressCountryBF: 'Burkina Faso',
	txtAddressCountryBI: 'Burundi',
	txtAddressCountryKH: 'Kambodža',
	txtAddressCountryCM: 'Kamerun',
	txtAddressCountryCA: 'Kanada',
	txtAddressCountryCV: 'Kapverdy',
	txtAddressCountryKY: 'Kajmanské ostrovy',
	txtAddressCountryCF: 'Stredoafrická republika',
	txtAddressCountryTD: 'Čad',
	txtAddressCountryCL: 'Čile',
	txtAddressCountryCN: 'Čína',
	txtAddressCountryCO: 'Kolumbia',
	txtAddressCountryKM: 'Komory',
	txtAddressCountryCD: 'Demokratická republika Kongo',
	txtAddressCountryCG: 'Konžská republika',
	txtAddressCountryCR: 'Kostarika',
	txtAddressCountryCI: 'Pobrežie slonoviny',
	txtAddressCountryHR: 'Chorvátsko',
	txtAddressCountryCU: 'Kuba',
	txtAddressCountryCY: 'Cyprus',
	txtAddressCountryCZ: 'Česká republika',
	txtAddressCountryDK: 'Dánsko',
	txtAddressCountryDJ: 'Džibuti',
	txtAddressCountryDM: 'Dominika',
	txtAddressCountryDO: 'Dominikánska republika',
	txtAddressCountryEC: 'Ekvádor',
	txtAddressCountryEG: 'Egypt',
	txtAddressCountrySV: 'Salvador',
	txtAddressCountryGQ: 'Rovníková Guinea',
	txtAddressCountryER: 'Eritrea',
	txtAddressCountryEE: 'Estónsko',
	txtAddressCountryET: 'Etiópia',
	txtAddressCountryFK: 'Falklandy',
	txtAddressCountryFO: 'Faerské ostrovy',
	txtAddressCountryFJ: 'Fidži',
	txtAddressCountryFI: 'Fínsko',
	txtAddressCountryFR: 'Francúzsko',
	txtAddressCountryPF: 'Francúzska Polynézia',
	txtAddressCountryGA: 'Gabon',
	txtAddressCountryGM: 'Gambia',
	txtAddressCountryGE: 'Gruzínsko',
	txtAddressCountryDE: 'Nemecko',
	txtAddressCountryGH: 'Ghana',
	txtAddressCountryGR: 'Grécko',
	txtAddressCountryGL: 'Grónsko',
	txtAddressCountryGD: 'Grenada',
	txtAddressCountryGP: 'Guadeloupe',
	txtAddressCountryGT: 'Guatemala',
	txtAddressCountryGN: 'Guinea',
	txtAddressCountryGW: 'Guinea-Bissau',
	txtAddressCountryGY: 'Guyana',
	txtAddressCountryHT: 'Haiti',
	txtAddressCountryHN: 'Honduras',
	txtAddressCountryHK: 'Hong Kong',
	txtAddressCountryHU: 'Maďarsko',
	txtAddressCountryIS: 'Island',
	txtAddressCountryIN: 'India',
	txtAddressCountryID: 'Indonézia',
	txtAddressCountryIR: 'Irán',
	txtAddressCountryIQ: 'Irak',
	txtAddressCountryIE: 'Írsko',
	txtAddressCountryIM: 'Ostrov Man',
	txtAddressCountryIL: 'Izrael',
	txtAddressCountryIT: 'Taliansko',
	txtAddressCountryJM: 'Jamajka',
	txtAddressCountryJP: 'Japonsko',
	txtAddressCountryJO: 'Jordánsko',
	txtAddressCountryKZ: 'Kazachstan',
	txtAddressCountryKE: 'Keňa',
	txtAddressCountryKI: 'Kiribati',
	txtAddressCountryKP: 'Severná Kórea',
	txtAddressCountryKR: 'Južná Kórea',
	txtAddressCountryKW: 'Kuvajt',
	txtAddressCountryKG: 'Kyrgyzstan',
	txtAddressCountryLA: 'Laos',
	txtAddressCountryLV: 'Lotyšsko',
	txtAddressCountryLB: 'Libanon',
	txtAddressCountryLS: 'Lesoto',
	txtAddressCountryLR: 'Libéria',
	txtAddressCountryLY: 'Líbya',
	txtAddressCountryLI: 'Lichtenštajnsko',
	txtAddressCountryLT: 'Litva',
	txtAddressCountryLU: 'Luxembursko',
	txtAddressCountryMO: 'Macau',
	txtAddressCountryMK: 'Macedónsko',
	txtAddressCountryMG: 'Madagaskar',
	txtAddressCountryMW: 'Malawi',
	txtAddressCountryMY: 'Malajzia',
	txtAddressCountryMV: 'Maledivy',
	txtAddressCountryML: 'Mali',
	txtAddressCountryMT: 'Malta',
	txtAddressCountryMH: 'Marshallove ostrovy',
	txtAddressCountryMQ: 'Martinik',
	txtAddressCountryMR: 'Mauretánia',
	txtAddressCountryMU: 'Maurícius',
	txtAddressCountryMX: 'Mexiko',
	txtAddressCountryFM: 'Mikronézia',
	txtAddressCountryMD: 'Moldavsko',
	txtAddressCountryMC: 'Monako',
	txtAddressCountryMN: 'Mongolsko',
	txtAddressCountryME: 'Čierna hora',
	txtAddressCountryMA: 'Maroko',
	txtAddressCountryMZ: 'Mozambik',
	txtAddressCountryMM: 'Mjanmarsko',
	txtAddressCountryNA: 'Namíbia',
	txtAddressCountryNR: 'Nauru',
	txtAddressCountryNP: 'Nepál',
	txtAddressCountryNL: 'Holandsko',
	txtAddressCountryNC: 'Nová Kaledónia',
	txtAddressCountryNZ: 'Nový Zéland',
	txtAddressCountryNI: 'Nikaragua',
	txtAddressCountryNE: 'Niger',
	txtAddressCountryNG: 'Nigéria',
	txtAddressCountryNO: 'Nórsko',
	txtAddressCountryOM: 'Omán',
	txtAddressCountryPK: 'Pakistan',
	txtAddressCountryPW: 'Palau',
	txtAddressCountryPS: 'Palestínske územia',
	txtAddressCountryPA: 'Panama',
	txtAddressCountryPG: 'Papua-Nová Guinea',
	txtAddressCountryPY: 'Paraguaj',
	txtAddressCountryPE: 'Peru',
	txtAddressCountryPH: 'Filipíny',
	txtAddressCountryPL: 'Poľsko',
	txtAddressCountryPT: 'Portugalsko',
	txtAddressCountryPR: 'Portoriko',
	txtAddressCountryQA: 'Katar',
	txtAddressCountryRE: 'Réunion',
	txtAddressCountryRO: 'Rumunsko',
	txtAddressCountryRU: 'Rusko',
	txtAddressCountryRW: 'Rwanda',
	txtAddressCountryBL: 'Sv. Bartolomej',
	txtAddressCountrySH: 'Sv. Helena',
	txtAddressCountryKN: 'Svätý Krištof and Nevis',
	txtAddressCountryLC: 'Sv. Lucia',
	txtAddressCountryMF: 'Sv. Martin',
	txtAddressCountryVC: 'Sv. Vincent a Grenadíny',
	txtAddressCountryWS: 'Samoa',
	txtAddressCountrySM: 'San Maríno',
	txtAddressCountryST: 'Sao Tome a Principe',
	txtAddressCountrySA: 'Saudská Arábia',
	txtAddressCountrySN: 'Senegal',
	txtAddressCountryRS: 'Srbsko',
	txtAddressCountrySC: 'Seychely',
	txtAddressCountrySL: 'Siera Leone',
	txtAddressCountrySG: 'Singapur',
	txtAddressCountrySK: 'Slovensko',
	txtAddressCountrySI: 'Slovinsko',
	txtAddressCountrySB: 'Šalamúnove ostrovy',
	txtAddressCountrySO: 'Somálsko',
	txtAddressCountryZA: 'Južná Afrika',
	txtAddressCountryGS: 'Južná Georgia a južné Sandwichove ostrovy',
	txtAddressCountryES: 'Španielsko',
	txtAddressCountryLK: 'Srí Lanka',
	txtAddressCountrySD: 'Sudán',
	txtAddressCountrySR: 'Surinam',
	txtAddressCountrySZ: 'Swahilsko',
	txtAddressCountrySE: 'Švédsko',
	txtAddressCountryCH: 'Švajčiarsko',
	txtAddressCountrySY: 'Sýria',
	txtAddressCountryTW: 'Taiwan',
	txtAddressCountryTJ: 'Tadžikistan',
	txtAddressCountryTZ: 'Tanzánia',
	txtAddressCountryTH: 'Thajsko',
	txtAddressCountryTL: 'Timor-Leste',
	txtAddressCountryTG: 'Togo',
	txtAddressCountryTO: 'Tonga',
	txtAddressCountryTT: 'Trinidad a Tobago',
	txtAddressCountryTN: 'Tunisko',
	txtAddressCountryTR: 'Turecko',
	txtAddressCountryTM: 'Turkmenistan',
	txtAddressCountryTV: 'Tuvalu',
	txtAddressCountryVI: 'Americké panenské ostrovy',
	txtAddressCountryUG: 'Uganda',
	txtAddressCountryUA: 'Ukrajina',
	txtAddressCountryAE: 'Spojené arabské emiráty',
	txtAddressCountryGB: 'Spojené kráľovstvo',
	txtAddressCountryUS: 'Spojené štáty americké',
	txtAddressCountryUY: 'Uruguaj',
	txtAddressCountryUZ: 'Uzbekistan',
	txtAddressCountryVU: 'Vanuatu',
	txtAddressCountryVA: 'Vatikán',
	txtAddressCountryVE: 'Venezuela',
	txtAddressCountryVN: 'Vietnam',
	txtAddressCountryYE: 'Jemen',
	txtAddressCountryZM: 'Zambia',
	txtAddressCountryZW: 'Zimbabwe'
};

localizationSharedCardDAV['tr_TR']=	/* thanks Selcuk Pultar */
{
	txtContacts: 'İrtibatlar',

	pholderGiven: 'Adı',
	pholderFamily: 'Soyadı',
	pholderMiddle: 'Göbekadı',
	pholderPrefix: 'Önek',
	pholderSuffix: 'Sonek',

	txtAddressCountryAF: 'Afganistan',
	txtAddressCountryAL: 'Arnavutluk',
	txtAddressCountryDZ: 'Cezayir',
	txtAddressCountryAD: 'Andorra',
	txtAddressCountryAO: 'Angola',
	txtAddressCountryAG: 'Antigua ve Barbuda',
	txtAddressCountryAR: 'Arjantin',
	txtAddressCountryAM: 'Ermenistan',
	txtAddressCountryAU: 'Avusturalya',
	txtAddressCountryAT: 'Avusturya',
	txtAddressCountryAZ: 'Azerbaycan',
	txtAddressCountryBS: 'Bahamalar',
	txtAddressCountryBH: 'Bahreyn',
	txtAddressCountryBD: 'Bangladeş',
	txtAddressCountryBB: 'Barbados',
	txtAddressCountryBY: 'Beyaz Rusya',
	txtAddressCountryBE: 'Belçika',
	txtAddressCountryBZ: 'Beliz',
	txtAddressCountryBJ: 'Benin',
	txtAddressCountryBM: 'Bermuda',
	txtAddressCountryBT: 'Bhutan',
	txtAddressCountryBO: 'Bolivya',
	txtAddressCountryBA: 'Bosna and Hersek',
	txtAddressCountryBW: 'Botsvana',
	txtAddressCountryBR: 'Brezilya',
	txtAddressCountryBN: 'Bruney Darüsselam',
	txtAddressCountryBG: 'Bulgaristan',
	txtAddressCountryBF: 'Burkina Faso',
	txtAddressCountryBI: 'Burundi',
	txtAddressCountryKH: 'Kamboçya',
	txtAddressCountryCM: 'Kamerun',
	txtAddressCountryCA: 'Kanada',
	txtAddressCountryCV: 'Kap Verde',
	txtAddressCountryKY: 'Kayman Adaları',
	txtAddressCountryCF: 'Orta Afrika Cumhuriyeti',
	txtAddressCountryTD: 'Çad',
	txtAddressCountryCL: 'Şili',
	txtAddressCountryCN: 'Çin',
	txtAddressCountryCO: 'kolombiya',
	txtAddressCountryKM: 'Comoros',
	txtAddressCountryCD: 'Congo Demokratik Cumhuriyeti',
	txtAddressCountryCG: 'Congo Cumhuriyeti',
	txtAddressCountryCR: 'Kosta Rika',
	txtAddressCountryCI: 'Fildişi Sahili',
	txtAddressCountryHR: 'Hırvatistan',
	txtAddressCountryCU: 'Küba',
	txtAddressCountryCY: 'Kıbrıs',
	txtAddressCountryCZ: 'Çek Cumhuriyeti',
	txtAddressCountryDK: 'Danimarka',
	txtAddressCountryDJ: 'Djibouti',
	txtAddressCountryDM: 'Dominica',
	txtAddressCountryDO: 'Dominik Cumhuriyeti',
	txtAddressCountryEC: 'Ekvator',
	txtAddressCountryEG: 'Mısır',
	txtAddressCountrySV: 'El Salvador',
	txtAddressCountryGQ: 'Ekvatoryal Guinea',
	txtAddressCountryER: 'Eritrea',
	txtAddressCountryEE: 'Estonya',
	txtAddressCountryET: 'Etiyopya',
	txtAddressCountryFK: 'Falkland Adaları',
	txtAddressCountryFO: 'Faroe Adaları',
	txtAddressCountryFJ: 'Fiji',
	txtAddressCountryFI: 'Finlandiya',
	txtAddressCountryFR: 'Fransa',
	txtAddressCountryPF: 'Fransız Polinezyası',
	txtAddressCountryGA: 'Gabon',
	txtAddressCountryGM: 'Gambiya',
	txtAddressCountryGE: 'Gürcistan',
	txtAddressCountryDE: 'Almanya',
	txtAddressCountryGH: 'Ghana',
	txtAddressCountryGR: 'Yunanistan',
	txtAddressCountryGL: 'Grönland',
	txtAddressCountryGD: 'Grenada',
	txtAddressCountryGP: 'Guadeloupe',
	txtAddressCountryGT: 'Guatemala',
	txtAddressCountryGN: 'Gine',
	txtAddressCountryGW: 'Guinea-Bissau',
	txtAddressCountryGY: 'Guyana',
	txtAddressCountryHT: 'Haiti',
	txtAddressCountryHN: 'Honduras',
	txtAddressCountryHK: 'Hong Kong',
	txtAddressCountryHU: 'Macaristan',
	txtAddressCountryIS: 'İzlanda',
	txtAddressCountryIN: 'Hindistan',
	txtAddressCountryID: 'Endonezya',
	txtAddressCountryIR: 'İran',
	txtAddressCountryIQ: 'Irak',
	txtAddressCountryIE: 'Irlanda',
	txtAddressCountryIM: 'Man Adası',
	txtAddressCountryIL: 'Israil',
	txtAddressCountryIT: 'Italya',
	txtAddressCountryJM: 'Jamaica',
	txtAddressCountryJP: 'Japonya',
	txtAddressCountryJO: 'Ürdün',
	txtAddressCountryKZ: 'Kazakistan',
	txtAddressCountryKE: 'Kenya',
	txtAddressCountryKI: 'Kiribati',
	txtAddressCountryKP: 'Kuzey Kore',
	txtAddressCountryKR: 'Güney Kore',
	txtAddressCountryKW: 'Kuveyt',
	txtAddressCountryKG: 'Kırgızistan',
	txtAddressCountryLA: 'Laos',
	txtAddressCountryLV: 'Latviya',
	txtAddressCountryLB: 'Lübnan',
	txtAddressCountryLS: 'Lesotho',
	txtAddressCountryLR: 'Liberia',
	txtAddressCountryLY: 'Libya',
	txtAddressCountryLI: 'Liechtenstein',
	txtAddressCountryLT: 'Litvanya',
	txtAddressCountryLU: 'Lüksemburg',
	txtAddressCountryMO: 'Makau',
	txtAddressCountryMK: 'Makedonya',
	txtAddressCountryMG: 'Madagaskar',
	txtAddressCountryMW: 'Malavi',
	txtAddressCountryMY: 'Malezya',
	txtAddressCountryMV: 'Maldiveler',
	txtAddressCountryML: 'Mali',
	txtAddressCountryMT: 'Malta',
	txtAddressCountryMH: 'Marshall Adaları',
	txtAddressCountryMQ: 'Martinik',
	txtAddressCountryMR: 'Mauritanya',
	txtAddressCountryMU: 'Maurityus',
	txtAddressCountryMX: 'Meksika',
	txtAddressCountryFM: 'Micronesya',
	txtAddressCountryMD: 'Moldovya',
	txtAddressCountryMC: 'Monako',
	txtAddressCountryMN: 'Moğolistan',
	txtAddressCountryME: 'Karadağ',
	txtAddressCountryMA: 'Fas',
	txtAddressCountryMZ: 'Mozambik',
	txtAddressCountryMM: 'Myanmar',
	txtAddressCountryNA: 'Namibya',
	txtAddressCountryNR: 'Nauru',
	txtAddressCountryNP: 'Nepal',
	txtAddressCountryNL: 'Hollanda',
	txtAddressCountryNC: 'Yeni Kaledonya',
	txtAddressCountryNZ: 'Yeni Zellanda',
	txtAddressCountryNI: 'Nikaragua',
	txtAddressCountryNE: 'Niger',
	txtAddressCountryNG: 'Nijerya',
	txtAddressCountryNO: 'Norveç',
	txtAddressCountryOM: 'Oman',
	txtAddressCountryPK: 'Pakistan',
	txtAddressCountryPW: 'Palau',
	txtAddressCountryPS: 'Filistin',
	txtAddressCountryPA: 'Panama',
	txtAddressCountryPG: 'Papua Yeni Gine',
	txtAddressCountryPY: 'Paraguay',
	txtAddressCountryPE: 'Peru',
	txtAddressCountryPH: 'Filipinler',
	txtAddressCountryPL: 'Polonya',
	txtAddressCountryPT: 'Portekiz',
	txtAddressCountryPR: 'Porto Rico',
	txtAddressCountryQA: 'Katar',
	txtAddressCountryRE: 'Réunion',
	txtAddressCountryRO: 'Romanya',
	txtAddressCountryRU: 'Rusya',
	txtAddressCountryRW: 'Ruvanda',
	txtAddressCountryBL: 'Aziz Barthélemy',
	txtAddressCountrySH: 'Aziz Helena',
	txtAddressCountryKN: 'Aziz Kitts ve Nevis',
	txtAddressCountryLC: 'Aziz Lusya',
	txtAddressCountryMF: 'Aziz Martin',
	txtAddressCountryVC: 'Aziz Vincent ve Grenadinler',
	txtAddressCountryWS: 'Samoa',
	txtAddressCountrySM: 'San Marino',
	txtAddressCountryST: 'Sao Tome ve Principe',
	txtAddressCountrySA: 'Sudi Arabistan',
	txtAddressCountrySN: 'Senegal',
	txtAddressCountryRS: 'Sırbistan',
	txtAddressCountrySC: 'Seyşeller',
	txtAddressCountrySL: 'Sierra Leon',
	txtAddressCountrySG: 'Singapur',
	txtAddressCountrySK: 'Slovak Cumhuriyeti',
	txtAddressCountrySI: 'Slovenya',
	txtAddressCountrySB: 'Solomon Adaları',
	txtAddressCountrySO: 'Somalya',
	txtAddressCountryZA: 'Güney Africa',
	txtAddressCountryGS: 'Güney Georgia and Güney Sandwich Adaları',
	txtAddressCountryES: 'İspanya',
	txtAddressCountryLK: 'Sri Lanka',
	txtAddressCountrySD: 'Sudan',
	txtAddressCountrySR: 'Surinam',
	txtAddressCountrySZ: 'Swaziland',
	txtAddressCountrySE: 'İşveç',
	txtAddressCountryCH: 'İşviçre',
	txtAddressCountrySY: 'Suriye',
	txtAddressCountryTW: 'Tayvan',
	txtAddressCountryTJ: 'Tacikistan',
	txtAddressCountryTZ: 'Tanzanya',
	txtAddressCountryTH: 'Thayland',
	txtAddressCountryTL: 'Timor-Leste',
	txtAddressCountryTG: 'Togo',
	txtAddressCountryTO: 'Tonga',
	txtAddressCountryTT: 'Trinidad ve Tobago',
	txtAddressCountryTN: 'Tunus',
	txtAddressCountryTR: 'Türkiye',
	txtAddressCountryTM: 'Türkmenistan',
	txtAddressCountryTV: 'Tuvalu',
	txtAddressCountryVI: 'ABD Virgin Adaları',
	txtAddressCountryUG: 'Uganda',
	txtAddressCountryUA: 'Ukrayna',
	txtAddressCountryAE: 'Birleşik Arap Emirlikleri',
	txtAddressCountryGB: 'Birleşik Krallık',
	txtAddressCountryUS: 'Amerika Birleşik Devletleri',
	txtAddressCountryUY: 'Uruguay',
	txtAddressCountryUZ: 'Özbekistan',
	txtAddressCountryVU: 'Vanuatu',
	txtAddressCountryVA: 'Vatikan',
	txtAddressCountryVE: 'Venezuella',
	txtAddressCountryVN: 'Vietnam',
	txtAddressCountryYE: 'Yemen',
	txtAddressCountryZM: 'Zambiya',
	txtAddressCountryZW: 'Zimbabve'
};

localizationSharedCardDAV['ru_RU']=	/* thanks Александр Симонов */
{
	txtContacts: 'Контакты',

	pholderGiven: 'Имя',
	pholderFamily: 'Фамилия',
	pholderMiddle: 'Отчество',
	pholderPrefix: 'Приставка',
	pholderSuffix: 'Суффикс',

	txtAddressCountryAF: 'Афганистан',
	txtAddressCountryAL: 'Албания',
	txtAddressCountryDZ: 'Алжирия',
	txtAddressCountryAD: 'Андорра',
	txtAddressCountryAO: 'Ангола',
	txtAddressCountryAG: 'Антигуа и Барбуда',
	txtAddressCountryAR: 'Аргентина',
	txtAddressCountryAM: 'Армения',
	txtAddressCountryAU: 'Австралия',
	txtAddressCountryAT: 'Австрия',
	txtAddressCountryAZ: 'Азербайджан',
	txtAddressCountryBS: 'Багамы',
	txtAddressCountryBH: 'Бахрейн',
	txtAddressCountryBD: 'Бангладеш',
	txtAddressCountryBB: 'Барбадос',
	txtAddressCountryBY: 'Беларусь',
	txtAddressCountryBE: 'Бельгия',
	txtAddressCountryBZ: 'Белиз',
	txtAddressCountryBJ: 'Бенин',
	txtAddressCountryBM: 'Бермуды',
	txtAddressCountryBT: 'Бутан',
	txtAddressCountryBO: 'Боливия',
	txtAddressCountryBA: 'Босния и Герцоговина',
	txtAddressCountryBW: 'Ботсвана',
	txtAddressCountryBR: 'Бразилия',
	txtAddressCountryBN: 'Бруней-Даруссалам',
	txtAddressCountryBG: 'Болгария',
	txtAddressCountryBF: 'Буркина-Фасо',
	txtAddressCountryBI: 'Бурунди',
	txtAddressCountryKH: 'Камбоджия',
	txtAddressCountryCM: 'Камерун',
	txtAddressCountryCA: 'Канада',
	txtAddressCountryCV: 'Кабо-Верде',
	txtAddressCountryKY: 'Кайманские острова',
	txtAddressCountryCF: 'ЦАР',
	txtAddressCountryTD: 'Чад',
	txtAddressCountryCL: 'Чили',
	txtAddressCountryCN: 'Китай',
	txtAddressCountryCO: 'Колумбия',
	txtAddressCountryKM: 'Коморы',
	txtAddressCountryCD: 'Демократическая республика Конго',
	txtAddressCountryCG: 'Республика Конго',
	txtAddressCountryCR: 'Коста-Рика',
	txtAddressCountryCI: 'Кот-д-Ивуар',
	txtAddressCountryHR: 'Хорватия',
	txtAddressCountryCU: 'Куба',
	txtAddressCountryCY: 'Кипр',
	txtAddressCountryCZ: 'Чехия',
	txtAddressCountryDK: 'Дания',
	txtAddressCountryDJ: 'Джибути',
	txtAddressCountryDM: 'Доминика',
	txtAddressCountryDO: 'Доминиканская республика',
	txtAddressCountryEC: 'Эквадор',
	txtAddressCountryEG: 'Египет',
	txtAddressCountrySV: 'Сальвадор',
	txtAddressCountryGQ: 'Экваториальная Гвинея',
	txtAddressCountryER: 'Эритрея',
	txtAddressCountryEE: 'Эстония',
	txtAddressCountryET: 'Эфиопия',
	txtAddressCountryFK: 'Фолклэндские острова',
	txtAddressCountryFO: 'Фарерские острова',
	txtAddressCountryFJ: 'Фиджи',
	txtAddressCountryFI: 'Финляндия',
	txtAddressCountryFR: 'Франция',
	txtAddressCountryPF: 'Французская Полинезия',
	txtAddressCountryGA: 'Габон',
	txtAddressCountryGM: 'Гамбия',
	txtAddressCountryGE: 'Грузия',
	txtAddressCountryDE: 'Германия',
	txtAddressCountryGH: 'Гана',
	txtAddressCountryGR: 'Греция',
	txtAddressCountryGL: 'Гренландия',
	txtAddressCountryGD: 'Гренада',
	txtAddressCountryGP: 'Гваделупа',
	txtAddressCountryGT: 'Гватемала',
	txtAddressCountryGN: 'Гвинея',
	txtAddressCountryGW: 'Гвиная-Бисау',
	txtAddressCountryGY: 'Гайана',
	txtAddressCountryHT: 'Гаити',
	txtAddressCountryHN: 'Гондурас',
	txtAddressCountryHK: 'Гонконг',
	txtAddressCountryHU: 'Венгрия',
	txtAddressCountryIS: 'Исландия',
	txtAddressCountryIN: 'Индия',
	txtAddressCountryID: 'Индонезия',
	txtAddressCountryIR: 'Иран',
	txtAddressCountryIQ: 'Ирак',
	txtAddressCountryIE: 'Ирландия',
	txtAddressCountryIM: 'Остров Мэн',
	txtAddressCountryIL: 'Израиль',
	txtAddressCountryIT: 'Италия',
	txtAddressCountryJM: 'Ямайка',
	txtAddressCountryJP: 'Япония',
	txtAddressCountryJO: 'Иордания',
	txtAddressCountryKZ: 'Казахстран',
	txtAddressCountryKE: 'Кения',
	txtAddressCountryKI: 'Кирибати',
	txtAddressCountryKP: 'Северная Корея',
	txtAddressCountryKR: 'Южная Корея',
	txtAddressCountryKW: 'Кувейт',
	txtAddressCountryKG: 'Киргизстан',
	txtAddressCountryLA: 'Лаос',
	txtAddressCountryLV: 'Латвия',
	txtAddressCountryLB: 'Ливан',
	txtAddressCountryLS: 'Лесото',
	txtAddressCountryLR: 'Либерия',
	txtAddressCountryLY: 'Ливия',
	txtAddressCountryLI: 'Лихтенштейн',
	txtAddressCountryLT: 'Литва',
	txtAddressCountryLU: 'Люксембург',
	txtAddressCountryMO: 'Макао',
	txtAddressCountryMK: 'Македония',
	txtAddressCountryMG: 'Мадагаскар',
	txtAddressCountryMW: 'Малави',
	txtAddressCountryMY: 'Малайзия',
	txtAddressCountryMV: 'Мальдивы',
	txtAddressCountryML: 'Мали',
	txtAddressCountryMT: 'Мальта',
	txtAddressCountryMH: 'Маршалловы острова',
	txtAddressCountryMQ: 'Мартиника',
	txtAddressCountryMR: 'Мавритания',
	txtAddressCountryMU: 'Маврикий',
	txtAddressCountryMX: 'Мексика',
	txtAddressCountryFM: 'Микронезия',
	txtAddressCountryMD: 'Молдова',
	txtAddressCountryMC: 'Монако',
	txtAddressCountryMN: 'Монголия',
	txtAddressCountryME: 'Монтенегро',
	txtAddressCountryMA: 'Морокко',
	txtAddressCountryMZ: 'Мозамбик',
	txtAddressCountryMM: 'Мьянма',
	txtAddressCountryNA: 'Намибия',
	txtAddressCountryNR: 'Науру',
	txtAddressCountryNP: 'Непал',
	txtAddressCountryNL: 'Нидерланды',
	txtAddressCountryNC: 'Новая Каледония',
	txtAddressCountryNZ: 'Новая Зеландия',
	txtAddressCountryNI: 'Никарагуа',
	txtAddressCountryNE: 'Нигер',
	txtAddressCountryNG: 'Нигерия',
	txtAddressCountryNO: 'Норвегия',
	txtAddressCountryOM: 'Оман',
	txtAddressCountryPK: 'Пакистан',
	txtAddressCountryPW: 'Палау',
	txtAddressCountryPS: 'Палестина',
	txtAddressCountryPA: 'Панама',
	txtAddressCountryPG: 'Папуа - Новая Гвинея',
	txtAddressCountryPY: 'Парагвай',
	txtAddressCountryPE: 'Перу',
	txtAddressCountryPH: 'Филлипины',
	txtAddressCountryPL: 'Польша',
	txtAddressCountryPT: 'Португалия',
	txtAddressCountryPR: 'Пуэрто-Рико',
	txtAddressCountryQA: 'Катар',
	txtAddressCountryRE: 'Реюньон',
	txtAddressCountryRO: 'Румыния',
	txtAddressCountryRU: 'Россия',
	txtAddressCountryRW: 'Руанда',
	txtAddressCountryBL: 'Сен-Бартелеми',
	txtAddressCountrySH: 'Остров Святой Елены',
	txtAddressCountryKN: 'Сен-Киттс и Невис',
	txtAddressCountryLC: 'Сент-Люсия',
	txtAddressCountryMF: 'Сен-Мартен',
	txtAddressCountryVC: 'Сен-Винсент и Гренадины',
	txtAddressCountryWS: 'Самоа',
	txtAddressCountrySM: 'Сан-Марино',
	txtAddressCountryST: 'Сан-Томе и Принсипи',
	txtAddressCountrySA: 'Саудовская Аравия',
	txtAddressCountrySN: 'Сенегал',
	txtAddressCountryRS: 'Сербия',
	txtAddressCountrySC: 'Сейшеллы',
	txtAddressCountrySL: 'Сьерра-Леоне',
	txtAddressCountrySG: 'Сингапур',
	txtAddressCountrySK: 'Словакия',
	txtAddressCountrySI: 'Словения',
	txtAddressCountrySB: 'Соломоновы острова',
	txtAddressCountrySO: 'Сомали',
	txtAddressCountryZA: 'ЮАР',
	txtAddressCountryGS: 'Южная Георгия и Южные Сандвичевы острова',
	txtAddressCountryES: 'Испания',
	txtAddressCountryLK: 'Шри-Ланка',
	txtAddressCountrySD: 'Судан',
	txtAddressCountrySR: 'Суринам',
	txtAddressCountrySZ: 'Свазилэнд',
	txtAddressCountrySE: 'Швеция',
	txtAddressCountryCH: 'Швейцария',
	txtAddressCountrySY: 'Сирия',
	txtAddressCountryTW: 'Тайвань',
	txtAddressCountryTJ: 'Таджикистан',
	txtAddressCountryTZ: 'Танзания',
	txtAddressCountryTH: 'Тайланд',
	txtAddressCountryTL: 'Восточный Тимор',
	txtAddressCountryTG: 'Того',
	txtAddressCountryTO: 'Тонга',
	txtAddressCountryTT: 'Тринидад и Тобаго',
	txtAddressCountryTN: 'Тунис',
	txtAddressCountryTR: 'Турция',
	txtAddressCountryTM: 'Туркменистан',
	txtAddressCountryTV: 'Тувалу',
	txtAddressCountryVI: 'Виргинские острова (США)',
	txtAddressCountryUG: 'Уганда',
	txtAddressCountryUA: 'Украина',
	txtAddressCountryAE: 'ОАЭ',
	txtAddressCountryGB: 'Великобритания',
  	txtAddressCountryUS: 'США',
	txtAddressCountryUY: 'Уругвай',
	txtAddressCountryUZ: 'Узбекистан',
	txtAddressCountryVU: 'Вануату',
	txtAddressCountryVA: 'Ватикан',
	txtAddressCountryVE: 'Венесуэла',
	txtAddressCountryVN: 'Вьетнам',
	txtAddressCountryYE: 'Йемен',
	txtAddressCountryZM: 'Замбия',
	txtAddressCountryZW: 'Зимбабве'
};

localizationSharedCardDAV['uk_UA']=	/* Serge Yakimchuck <yakim@yakim.org.ua> */
{
	txtContacts: 'Контакти',

	pholderGiven: 'Ім\'я',
	pholderFamily: 'Прізвище',
	pholderMiddle: 'По батькові',
	pholderPrefix: 'Префікс',
	pholderSuffix: 'Суфікс',

	txtAddressCountryAF: 'Афганістан',
	txtAddressCountryAL: 'Албанія',
	txtAddressCountryDZ: 'Алжир',
	txtAddressCountryAD: 'Андорра',
	txtAddressCountryAO: 'Ангола',
	txtAddressCountryAG: 'Антігуа і Барбуда',
	txtAddressCountryAR: 'Аргентіна',
	txtAddressCountryAM: 'Арменія',
	txtAddressCountryAU: 'Австралія',
	txtAddressCountryAT: 'Австрія',
	txtAddressCountryAZ: 'Азербайджан',
	txtAddressCountryBS: 'Багами',
	txtAddressCountryBH: 'Бахрейн',
	txtAddressCountryBD: 'Бангладеш',
	txtAddressCountryBB: 'Барбадос',
	txtAddressCountryBY: 'Беларусь',
	txtAddressCountryBE: 'Бельгія',
	txtAddressCountryBZ: 'Беліз',
	txtAddressCountryBJ: 'Бенін',
	txtAddressCountryBM: 'Бермуди',
	txtAddressCountryBT: 'Бутан',
	txtAddressCountryBO: 'Болівія',
	txtAddressCountryBA: 'Боснія і Герцеговіна',
	txtAddressCountryBW: 'Ботсвана',
	txtAddressCountryBR: 'Бразилія',
	txtAddressCountryBN: 'Бруней Даруссалам',
	txtAddressCountryBG: 'Болгарія',
	txtAddressCountryBF: 'Буркіна Фасо',
	txtAddressCountryBI: 'Бурунді',
	txtAddressCountryKH: 'Камбоджа',
	txtAddressCountryCM: 'Камерун',
	txtAddressCountryCA: 'Канада',
	txtAddressCountryCV: 'Капо Верде',
	txtAddressCountryKY: 'Кайманові острови',
	txtAddressCountryCF: 'Центрально-Африканська Республіка',
	txtAddressCountryTD: 'Чад',
	txtAddressCountryCL: 'Чілі',
	txtAddressCountryCN: 'Китай',
	txtAddressCountryCO: 'Колумбія',
	txtAddressCountryKM: 'Коморські острови',
	txtAddressCountryCD: 'Демократична республіка Конго',
	txtAddressCountryCG: 'Республіка Конго',
	txtAddressCountryCR: 'Коста Ріка',
	txtAddressCountryCI: 'Кот д\'Івуар',
	txtAddressCountryHR: 'Хорватія',
	txtAddressCountryCU: 'Куба',
	txtAddressCountryCY: 'Кіпр',
	txtAddressCountryCZ: 'Чеська Республіка',
	txtAddressCountryDK: 'Данія',
	txtAddressCountryDJ: 'Джибуті',
	txtAddressCountryDM: 'Домініка',
	txtAddressCountryDO: 'Домініканська Республіка',
	txtAddressCountryEC: 'Еквадор',
	txtAddressCountryEG: 'Єгипет',
	txtAddressCountrySV: 'Сальвадор',
	txtAddressCountryGQ: 'Екваторіальна Гвінея',
	txtAddressCountryER: 'Еритрея',
	txtAddressCountryEE: 'Естонія',
	txtAddressCountryET: 'Ефіопія',
	txtAddressCountryFK: 'Фолклендські острови',
	txtAddressCountryFO: 'Фарерські острови',
	txtAddressCountryFJ: 'Фіджі',
	txtAddressCountryFI: 'Фінляндія',
	txtAddressCountryFR: 'Франція',
	txtAddressCountryPF: 'Французька полінезія',
	txtAddressCountryGA: 'Габон',
	txtAddressCountryGM: 'Гамбія',
	txtAddressCountryGE: 'Грузія',
	txtAddressCountryDE: 'Германія',
	txtAddressCountryGH: 'Гана',
	txtAddressCountryGR: 'Греція',
	txtAddressCountryGL: 'Гренландія',
	txtAddressCountryGD: 'Гренада',
	txtAddressCountryGP: 'Гваделупа',
	txtAddressCountryGT: 'Гватемала',
	txtAddressCountryGN: 'Гвінея',
	txtAddressCountryGW: 'Гвінея-Біссау',
	txtAddressCountryGY: 'Гайана',
	txtAddressCountryHT: 'Гаіті',
	txtAddressCountryHN: 'Гондурас',
	txtAddressCountryHK: 'Гонг Лонг',
	txtAddressCountryHU: 'Угорщина',
	txtAddressCountryIS: 'Ісландія',
	txtAddressCountryIN: 'Індія',
	txtAddressCountryID: 'Індонезія',
	txtAddressCountryIR: 'Іран',
	txtAddressCountryIQ: 'Ірак',
	txtAddressCountryIE: 'Ірландія',
	txtAddressCountryIM: 'Острів Мен',
	txtAddressCountryIL: 'Ізраїль',
	txtAddressCountryIT: 'Італія',
	txtAddressCountryJM: 'Ямайка',
	txtAddressCountryJP: 'Японія',
	txtAddressCountryJO: 'Йорданія',
	txtAddressCountryKZ: 'Казахстан',
	txtAddressCountryKE: 'Кенія',
	txtAddressCountryKI: 'Кірібаті',
	txtAddressCountryKP: 'Північна Корея',
	txtAddressCountryKR: 'Південна Корея',
	txtAddressCountryKW: 'Кувейт',
	txtAddressCountryKG: 'Киргизстан',
	txtAddressCountryLA: 'Лаос',
	txtAddressCountryLV: 'Латвія',
	txtAddressCountryLB: 'Ливан',
	txtAddressCountryLS: 'Лесото',
	txtAddressCountryLR: 'Ліберія',
	txtAddressCountryLY: 'Лівія',
	txtAddressCountryLI: 'Ліхтенштейн',
	txtAddressCountryLT: 'Литва',
	txtAddressCountryLU: 'Люксембург',
	txtAddressCountryMO: 'Мокао',
	txtAddressCountryMK: 'Македонія',
	txtAddressCountryMG: 'Мадагаскар',
	txtAddressCountryMW: 'Малаві',
	txtAddressCountryMY: 'Малайзія',
	txtAddressCountryMV: 'Мальдіви',
	txtAddressCountryML: 'Малі',
	txtAddressCountryMT: 'Мальта',
	txtAddressCountryMH: 'Маршалові острови',
	txtAddressCountryMQ: 'Мартиніка',
	txtAddressCountryMR: 'Мавританія',
	txtAddressCountryMU: 'Маврикій',
	txtAddressCountryMX: 'Мексіка',
	txtAddressCountryFM: 'Мікронезія',
	txtAddressCountryMD: 'Молдова',
	txtAddressCountryMC: 'Монако',
	txtAddressCountryMN: 'Монголія',
	txtAddressCountryME: 'Чорногорія',
	txtAddressCountryMA: 'Марокко',
	txtAddressCountryMZ: 'Мозамбік',
	txtAddressCountryMM: 'М\'янма',
	txtAddressCountryNA: 'Намібія',
	txtAddressCountryNR: 'Науру',
	txtAddressCountryNP: 'Непал',
	txtAddressCountryNL: 'Нідерланди',
	txtAddressCountryNC: 'Нова Каледонія',
	txtAddressCountryNZ: 'Нова Зеландія',
	txtAddressCountryNI: 'Нікарагуа',
	txtAddressCountryNE: 'Нігер',
	txtAddressCountryNG: 'Нігерія',
	txtAddressCountryNO: 'Норвегія',
	txtAddressCountryOM: 'Оман',
	txtAddressCountryPK: 'Пакістан',
	txtAddressCountryPW: 'Палау',
	txtAddressCountryPS: 'Палестинські території',
	txtAddressCountryPA: 'Панама',
	txtAddressCountryPG: 'Папуа Нова Гвінея',
	txtAddressCountryPY: 'Парагвай',
	txtAddressCountryPE: 'Перу',
	txtAddressCountryPH: 'Філіпіни',
	txtAddressCountryPL: 'Польща',
	txtAddressCountryPT: 'Португалія',
	txtAddressCountryPR: 'Пуерто Ріко',
	txtAddressCountryQA: 'Катар',
	txtAddressCountryRE: 'Реюньйон',
	txtAddressCountryRO: 'Румунія',
	txtAddressCountryRU: 'Росія',
	txtAddressCountryRW: 'Руанра',
	txtAddressCountryBL: 'Сен-Бартелемі',
	txtAddressCountrySH: 'Острів святої Єлени',
	txtAddressCountryKN: 'Сент-Кіттс і Невіс',
	txtAddressCountryLC: 'Сент-Люсія',
	txtAddressCountryMF: 'Сен-Мартен',
	txtAddressCountryVC: 'Сент-Вінсент і Гренадини',
	txtAddressCountryWS: 'Самоа',
	txtAddressCountrySM: 'Сан Маріно',
	txtAddressCountryST: 'Сан-Томе і Принсіпі',
	txtAddressCountrySA: 'Саудівська Аравія',
	txtAddressCountrySN: 'Сенегал',
	txtAddressCountryRS: 'Сербія',
	txtAddressCountrySC: 'Сейшели',
	txtAddressCountrySL: 'Сьєрра-Леоне',
	txtAddressCountrySG: 'Сінгапур',
	txtAddressCountrySK: 'Словацька Республіка',
	txtAddressCountrySI: 'Словенія',
	txtAddressCountrySB: 'Соломонові острови',
	txtAddressCountrySO: 'Сомалі',
	txtAddressCountryZA: 'Південна Африка',
	txtAddressCountryGS: 'Південна Джорджія та Південні Сандвічеві острови',
	txtAddressCountryES: 'Іспанія',
	txtAddressCountryLK: 'Шрі Ланка',
	txtAddressCountrySD: 'Судан',
	txtAddressCountrySR: 'Сурінам',
	txtAddressCountrySZ: 'Свазіленд',
	txtAddressCountrySE: 'Швеція',
	txtAddressCountryCH: 'Швейцарія',
	txtAddressCountrySY: 'Сирія',
	txtAddressCountryTW: 'Тайвань',
	txtAddressCountryTJ: 'Таджикістан',
	txtAddressCountryTZ: 'Танзанія',
	txtAddressCountryTH: 'Таїланд',
	txtAddressCountryTL: 'Тимор-Лешти',
	txtAddressCountryTG: 'Того',
	txtAddressCountryTO: 'Тонга',
	txtAddressCountryTT: 'Тринідід і Тобаго',
	txtAddressCountryTN: 'Туніс',
	txtAddressCountryTR: 'Турція',
	txtAddressCountryTM: 'Туркменістан',
	txtAddressCountryTV: 'Тувалу',
	txtAddressCountryVI: 'Віргінські Острови США',
	txtAddressCountryUG: 'Уганда',
	txtAddressCountryUA: 'Україна',
	txtAddressCountryAE: 'Сполучені Арабські Емірати',
	txtAddressCountryGB: 'Сполучене Королівство',
	txtAddressCountryUS: 'Сполучені Штати Америки',
	txtAddressCountryUY: 'Уругвай',
	txtAddressCountryUZ: 'Узбекістан',
	txtAddressCountryVU: 'Вануату',
	txtAddressCountryVA: 'Ватікан',
	txtAddressCountryVE: 'Венесуела',
	txtAddressCountryVN: 'В\'єтнам',
	txtAddressCountryYE: 'Йемен',
	txtAddressCountryZM: 'Замбія',
	txtAddressCountryZW: 'Зімбабве'
};

localizationSharedCardDAV['zh_CN']=	/* thanks Fandy */
{
	txtContacts: '联系方式',

	pholderGiven: '名',
	pholderFamily: '姓',
	pholderMiddle: '中间字',
	pholderPrefix: '前缀',
	pholderSuffix: '后缀',

	txtAddressCountryAF: '阿富汗',
	txtAddressCountryAL: '阿尔巴尼亚',
	txtAddressCountryDZ: '阿尔及利亚',
	txtAddressCountryAD: '安道尔',
	txtAddressCountryAO: '安哥拉',
	txtAddressCountryAG: '安提瓜和巴布达',
	txtAddressCountryAR: '阿根廷',
	txtAddressCountryAM: '亚美尼亚',
	txtAddressCountryAU: '澳大利亚',
	txtAddressCountryAT: '奥地利',
	txtAddressCountryAZ: '阿塞拜疆',
	txtAddressCountryBS: '巴哈马',
	txtAddressCountryBH: '巴林',
	txtAddressCountryBD: '孟加拉国',
	txtAddressCountryBB: '巴巴多斯',
	txtAddressCountryBY: '白俄罗斯',
	txtAddressCountryBE: '比利时',
	txtAddressCountryBZ: '伯利兹',
	txtAddressCountryBJ: '贝宁',
	txtAddressCountryBM: '百慕大群岛',
	txtAddressCountryBT: '不丹',
	txtAddressCountryBO: '玻利维亚',
	txtAddressCountryBA: '波斯尼亚和黑塞哥维那',
	txtAddressCountryBW: '博茨瓦纳',
	txtAddressCountryBR: '巴西',
	txtAddressCountryBN: '文莱达鲁萨兰国',
	txtAddressCountryBG: '保加利亚',
	txtAddressCountryBF: '布基纳法索',
	txtAddressCountryBI: '布隆迪',
	txtAddressCountryKH: '柬埔寨',
	txtAddressCountryCM: '喀麦隆',
	txtAddressCountryCA: '加拿大',
	txtAddressCountryCV: '佛得角',
	txtAddressCountryKY: '开曼群岛',
	txtAddressCountryCF: '中非共和国',
	txtAddressCountryTD: '乍得',
	txtAddressCountryCL: '智利',
	txtAddressCountryCN: '中国',
	txtAddressCountryCO: '哥伦比亚',
	txtAddressCountryKM: '科摩罗',
	txtAddressCountryCD: '刚果民主共和国',
	txtAddressCountryCG: '刚果共和国',
	txtAddressCountryCR: '哥斯达黎加',
	txtAddressCountryCI: '科特迪瓦',
	txtAddressCountryHR: '克罗地亚',
	txtAddressCountryCU: '古巴',
	txtAddressCountryCY: '塞浦路斯',
	txtAddressCountryCZ: '捷克共和国',
	txtAddressCountryDK: '丹麦',
	txtAddressCountryDJ: '吉布提',
	txtAddressCountryDM: '多米尼加',
	txtAddressCountryDO: '多米尼加共和国',
	txtAddressCountryEC: '厄瓜多尔',
	txtAddressCountryEG: '埃及',
	txtAddressCountrySV: '萨尔瓦多',
	txtAddressCountryGQ: '赤道几内亚',
	txtAddressCountryER: '厄立特里亚',
	txtAddressCountryEE: '爱沙尼亚',
	txtAddressCountryET: '埃塞俄比亚',
	txtAddressCountryFK: '福克兰群岛',
	txtAddressCountryFO: '法罗群岛',
	txtAddressCountryFJ: '斐济',
	txtAddressCountryFI: '芬兰',
	txtAddressCountryFR: '法国',
	txtAddressCountryPF: '法属波利尼西亚',
	txtAddressCountryGA: '加蓬',
	txtAddressCountryGM: '冈比亚',
	txtAddressCountryGE: '乔治亚州',
	txtAddressCountryDE: '德国',
	txtAddressCountryGH: '加纳',
	txtAddressCountryGR: '希腊',
	txtAddressCountryGL: '格陵兰岛',
	txtAddressCountryGD: '格林纳达',
	txtAddressCountryGP: '瓜德罗普岛',
	txtAddressCountryGT: '危地马拉',
	txtAddressCountryGN: '几内亚',
	txtAddressCountryGW: '几内亚比绍',
	txtAddressCountryGY: '圭亚那',
	txtAddressCountryHT: '海地',
	txtAddressCountryHN: '洪都拉斯',
	txtAddressCountryHK: '中国香港',
	txtAddressCountryHU: '匈牙利',
	txtAddressCountryIS: '冰岛',
	txtAddressCountryIN: '印度',
	txtAddressCountryID: '印尼',
	txtAddressCountryIR: '伊朗',
	txtAddressCountryIQ: '伊拉克',
	txtAddressCountryIE: '爱尔兰',
	txtAddressCountryIM: '英属马恩岛',
	txtAddressCountryIL: '以色列',
	txtAddressCountryIT: '意大利',
	txtAddressCountryJM: '牙买加',
	txtAddressCountryJP: '日本',
	txtAddressCountryJO: '约旦',
	txtAddressCountryKZ: '哈萨克斯坦',
	txtAddressCountryKE: '肯尼亚',
	txtAddressCountryKI: '基里巴斯',
	txtAddressCountryKP: '朝鲜',
	txtAddressCountryKR: '韩国',
	txtAddressCountryKW: '科威特',
	txtAddressCountryKG: '吉尔吉斯斯坦',
	txtAddressCountryLA: '老挝',
	txtAddressCountryLV: '拉脱维亚',
	txtAddressCountryLB: '黎巴嫩',
	txtAddressCountryLS: '莱索托',
	txtAddressCountryLR: '利比里亚',
	txtAddressCountryLY: '利比亚',
	txtAddressCountryLI: '列支敦斯登',
	txtAddressCountryLT: '立陶宛',
	txtAddressCountryLU: '卢森堡',
	txtAddressCountryMO: '中国澳门',
	txtAddressCountryMK: '马其顿',
	txtAddressCountryMG: '马达加斯加',
	txtAddressCountryMW: '马拉维',
	txtAddressCountryMY: '马来西亚',
	txtAddressCountryMV: '马尔代夫',
	txtAddressCountryML: '马里',
	txtAddressCountryMT: '马耳他',
	txtAddressCountryMH: '马绍尔群岛',
	txtAddressCountryMQ: '马提尼克岛',
	txtAddressCountryMR: '毛利塔尼亚',
	txtAddressCountryMU: '毛里求斯',
	txtAddressCountryMX: '墨西哥',
	txtAddressCountryFM: '密克罗尼西亚',
	txtAddressCountryMD: '摩尔多瓦',
	txtAddressCountryMC: '摩纳哥',
	txtAddressCountryMN: '蒙古',
	txtAddressCountryME: '黑山共和国',
	txtAddressCountryMA: '摩洛哥',
	txtAddressCountryMZ: '莫桑比克',
	txtAddressCountryMM: '缅甸',
	txtAddressCountryNA: '纳米比亚',
	txtAddressCountryNR: '瑙鲁',
	txtAddressCountryNP: '尼泊尔',
	txtAddressCountryNL: '荷兰',
	txtAddressCountryNC: '新喀里多尼亚',
	txtAddressCountryNZ: '新西兰',
	txtAddressCountryNI: '尼加拉瓜',
	txtAddressCountryNE: '尼日尔',
	txtAddressCountryNG: '尼日利亚',
	txtAddressCountryNO: '挪威',
	txtAddressCountryOM: '阿曼',
	txtAddressCountryPK: '巴基斯坦',
	txtAddressCountryPW: '帕劳',
	txtAddressCountryPS: '巴勒斯坦',
	txtAddressCountryPA: '巴拿马',
	txtAddressCountryPG: '巴布亚新几内亚',
	txtAddressCountryPY: '巴拉圭',
	txtAddressCountryPE: '秘鲁',
	txtAddressCountryPH: '菲律宾',
	txtAddressCountryPL: '波兰',
	txtAddressCountryPT: '葡萄牙',
	txtAddressCountryPR: '波多黎各',
	txtAddressCountryQA: '卡塔尔',
	txtAddressCountryRE: '法国留尼汪岛',
	txtAddressCountryRO: '罗马尼亚',
	txtAddressCountryRU: '俄罗斯',
	txtAddressCountryRW: '卢旺达',
	txtAddressCountryBL: '圣巴特尔米',
	txtAddressCountrySH: '圣赫勒拿',
	txtAddressCountryKN: '圣基茨和尼维斯',
	txtAddressCountryLC: '圣卢西亚岛',
	txtAddressCountryMF: '圣马丁',
	txtAddressCountryVC: '圣文森特和格林纳丁斯',
	txtAddressCountryWS: '萨摩亚',
	txtAddressCountrySM: '圣马力诺',
	txtAddressCountryST: '圣多美和普林西比',
	txtAddressCountrySA: '沙特阿拉伯',
	txtAddressCountrySN: '塞内加尔',
	txtAddressCountryRS: '塞尔维亚',
	txtAddressCountrySC: '塞舌尔',
	txtAddressCountrySL: '塞拉利昂',
	txtAddressCountrySG: '新加坡',
	txtAddressCountrySK: '斯洛伐克共和国',
	txtAddressCountrySI: '斯洛文尼亚',
	txtAddressCountrySB: '所罗门群岛',
	txtAddressCountrySO: '索马里',
	txtAddressCountryZA: '南非',
	txtAddressCountryGS: '南乔治亚岛和南桑威奇群岛',
	txtAddressCountryES: '西班牙',
	txtAddressCountryLK: '斯里兰卡',
	txtAddressCountrySD: '苏丹',
	txtAddressCountrySR: '苏里南',
	txtAddressCountrySZ: '斯威士兰',
	txtAddressCountrySE: '瑞典',
	txtAddressCountryCH: '瑞士',
	txtAddressCountrySY: '叙利亚',
	txtAddressCountryTW: '中国台湾',
	txtAddressCountryTJ: '塔吉克斯坦',
	txtAddressCountryTZ: '坦桑尼亚',
	txtAddressCountryTH: '泰国',
	txtAddressCountryTL: '东帝汶',
	txtAddressCountryTG: '多哥',
	txtAddressCountryTO: '汤加',
	txtAddressCountryTT: '特立尼达和多巴哥',
	txtAddressCountryTN: '突尼斯',
	txtAddressCountryTR: '土耳其',
	txtAddressCountryTM: '土库曼斯坦',
	txtAddressCountryTV: '图瓦卢',
	txtAddressCountryVI: '美属维尔京群岛',
	txtAddressCountryUG: '乌干达',
	txtAddressCountryUA: '乌克兰',
	txtAddressCountryAE: '阿拉伯联合酋长国',
	txtAddressCountryGB: '联合王国',
	txtAddressCountryUS: '美国',
	txtAddressCountryUY: '乌拉圭',
	txtAddressCountryUZ: '乌兹别克斯坦',
	txtAddressCountryVU: '瓦努阿图',
	txtAddressCountryVA: '梵蒂冈',
	txtAddressCountryVE: '委内瑞拉',
	txtAddressCountryVN: '越南',
	txtAddressCountryYE: '也门',
	txtAddressCountryZM: '赞比亚',
	txtAddressCountryZW: '津巴布韦'
};

$.extend(true, localization, localizationSharedCardDAV);

var localizationCalDAV = new Object();

localizationCalDAV['cs_CZ']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	_default_title_format_month_: 'MMM yyyy',
	_default_title_format_week_: 'd[ MMM][ yyyy]{ \'–\' d MMM yyyy}',
	_default_title_format_day_: 'ddd, d MMM yyyy',
	_default_title_format_table_: 'ddd, MMM yyyy',
	_default_column_format_agenda_: 'ddd, d MMM',

	txtCalendar: 'Kalendář',
	txtEnabledCalendars: 'Zapnuté Kalendáře',
	txtTodo: 'Připomínka',
	txtTodoList: 'Seznam',
	txtTodoLists: 'Seznamy Připomínek',
	txtEnabledTodoLists: 'Zapnuté Seznamy Připomínek',
	txtSubscribed: 'Odběry',
	fullCalendarTable: 'tabulka',
	fullCalendarTodayButton: 'dnes',
	fullCalendarAllDay: 'celej den',
	CalDAVsearch: 'Hledat',
	resourceEnable: 'Zobrazit všechnyy kalendáře v daném prostředku',
	resourceDisable: 'Schovat všechny kalendáře v daném prostředku',
	allEnable: 'Zobrazit všechny kalendáře',
	allDisable: 'Schovat všechny kalendáře',
	timezone: 'Časové pásmo',
	txtTimezonePicker: 'Pásmo:',
	loadingRList: 'Načítaní zoznamu prostředků ...',
	renderingE: 'Vykreslování kalendářů ...',
	timezoneChange: 'Aplikování změny časového pásma ...',
	customTimezone: 'Vlastní (Lokální čas)',
	customRepeat: 'Jiní (změna není podporována)',
	loadPrevMonth: 'Načíst předchádzející měsíc',
	loadNextMonth: 'Načíst následující měsíc',
	repeatBoxButton: 'Opakování',
	repeatBoxContent: 'je opakovací událost.',
	repeatBoxQuestion: 'Se kterými událostmi chcete pracovat?',
	allEvsButton: 'Všechny události',
	allFutureButton: 'Tahle a všechny budoucí události',
	eventOnlyButton: 'Pouze tahle událost',
	repeatBoxContentTODO: 'je opakovací připomínka.',
	repeatBoxQuestionTODO: 'Se kterými připomínkami chcete pracovat?',
	allEvsButtonTODO: 'Všechny připomínky',
	allFutureButtonTODO: 'Tahle a všechny budoucí připomínky',
	eventOnlyButtonTODO: 'Pouze tahle připomínka',
	txtStatus: 'Stav',
	eventAvailability : 'Dostupnost',
	eventAvailabilityBusy : 'Zaneprázdněnej',
	eventAvailabilityFree : 'Volnej',
	eventType: 'Soukromí',
	eventTypePublic: 'Veřejná',
	eventTypePrivate: 'Soukromá',
	eventTypeConfidential: 'Důvěrní',
	txtPriority: 'Priorita',
	txtPriorityNone: 'Žádná',
	txtPriorityLow: 'Nízká',
	txtPriorityMedium: 'Střední',
	txtPriorityHigh: 'Vysoká',
	eventURL : 'URL',
	repeatInterval: 'každých',
	repeatDays: 'dnů',
	repeatWeeks: 'týdnů',
	repeatMonths: 'měsíců',
	repeatYears: 'let',
	repeatChangeTxt: 'byl změnen na serveru!',
	repeatChangeTxtClose: 'Zavřete formulář a otevřte událost znovu',
	repeatTodoChangeTxtClose: 'Zavřete formulář a otevřte připomínku znovu.',
	calendarLoader: 'Znovunačítání ...',
	resizeLoader: 'Přepočítávání velikosti ...',

	// TODOS
	pholderNameTODO: 'Název',
	pholderNewTODO: 'Nová připomínka',
	txtTypeTODO: 'Typ',
	txtTypeTODONone: 'Jednoduchá',
	txtTypeTODOStart: 'S časem začátku',
	txtTypeTODODue: 'S časem konce',
	txtTypeTODOBoth: 'S časmi začátku i konce',
	txtDateFromTODO: 'Od',
	txtDateToTODO: 'Do',
	txtCompletedOn: 'Dokončeno ke',

	pholderDateFromTODO: 'Den od',
	pholderTimeFromTODO: 'Čas od',
	pholderDateToTODO: 'Den do',
	pholderTimeToTODO: 'Čas do',
	pholderCompletedOnDate: 'Den',
	pholderCompletedOnTime: 'Čas',

	txtStatusFiltersHeaderTODO: 'Filtry',
	txtStatusFiltersFooterTODO: '* dokončeno %date% a později',
	txtStatusNeedsActionTODO: 'Potřebuje akci',
	txtStatusCompletedTODO: 'Dokončena',
	txtStatusInProcessTODO: 'Řešená',
	txtStatusCancelledTODO: 'Zrušena',
	txtPercentCompletedTODO: 'Dokončeno',

	txtCalendarTODO: 'Kalendář',
	txtSelectCalendarTODO: 'Vyberte kalendář',
	txtAlertTODO: 'Alarm',
	txtAlertNoneTODO: 'Žádný',
	txtAlertMessageTODO: 'Správa',
	txtAlertOnDateTODO: 'Na datum',
	txtAlertWeeksBeforeTODO: 'Týdnů před',
	txtAlertDaysBeforeTODO: 'Dnů před',
	txtAlertHoursBeforeTODO: 'Hodin před',
	txtAlertMinutesBeforeTODO: 'Minut před',
	txtAlertSecondsBeforeTODO: 'Sekund před',
	txtAlertWeeksAfterTODO: 'Týdnů po',
	txtAlertDaysAfterTODO: 'Dnů po',
	txtAlertHoursAfterTODO: 'Sekund po',
	txtAlertMinutesAfterTODO: 'Minut po',
	txtAlertSecondsAfterTODO: 'Sekund po',

	pholderAfterBeforeValTODO: 'Hodnota',
	pholderAlarmDateTODO: 'Den alarmu',
	pholderAlarmTimeTODO: 'Čas alarmu',

	pholderNoteTODO: 'Poznámka',
	txtNoteTODO: 'Poznámka',

	todoPrevNav: 'Zobrazit předešlou instanci',
	todoNextNav: 'Zobrazit následující instanci',
	todoUncompletedPrevNav: 'Zobrazit předešlou nedokončenou instanci',
	todoUncompletedNextNav: 'Zobrazit následující nedokončenou instanci',

	buttonSaveTODO: 'Uložit',
	buttonEditTODO: 'Editovat',
	buttonDuplicateTODO: 'Duplikovat',
	buttonResetTODO: 'Reset',
	buttonCloseTODO: 'Zavřít',
	buttonDeleteTODO: 'Vymazat',

	// EVENTS
	pholderName: 'Název',
	pholderNewEvent: 'Nová událost',
	txtLocation: 'Místo',
	pholderLocation: 'Místo',

	txtAllDay: 'Celý den',
	from: 'Od',
	to: 'Do',

	pholderDateFrom: 'Den od',
	pholderTimeFrom: 'Čas od',
	pholderDateTo: 'Den do',
	pholderTimeTo: 'Čas do',

	txtStatusNone: 'Nespecifikován',
	txtStatusTentative: 'Předběžná',
	txtStatusConfirmed: 'Potvrzena',
	txtStatusCancelled: 'Zrušena',

	txtRepeat: 'Opakovat',
	txtNoRepeat: 'Neopakovat',
	txtRepeatDay: 'Denně',
	txtRepeatWeek: 'Týdenně',
	txtRepeatWeekend: 'Každý víkend',
	txtRepeatMonth: 'Měsíčně',
	txtRepeatTwoWeek: 'Dvoutýdenně',
	txtRepeatYear: 'Ročně',
	txtRepeatCustomWeek: 'Týdenně vlastní',
	txtRepeatCustomMonth: 'Měsíčně vlastní',
	txtRepeatCustomYear: 'Ročně vlastní',
	txtRepeatWork: 'Každý pracovný den',
	txtRepeatOnDate: 'Do dátumu',
	txtRepeatAfter: 'Výskytů',
	txtRepeatNever: 'Nikdy',
	pholderUntilDate: 'Do dne',
	pholderRepeatCount: 'Počet opakování',
	txtRepeatCustomWeekLabel: 'den',
	txtRepeatCustomMonthLabel: 've dnech',
	txtRepeatCustomMonthEvery: 'Každý',
	txtRepeatCustomMonthFirst: 'První',
	txtRepeatCustomMonthSecond: 'Druhej',
	txtRepeatCustomMonthThird: 'Třetí',
	txtRepeatCustomMonthFourth: 'Čtvrtý',
	txtRepeatCustomMonthFifth: 'Pátý',
	txtRepeatCustomMonthLast: 'Poslední',
	txtRepeatCustomMonthCustom: 'Vlastní',
	txtRepeatCustomMonthMonth: 'Den v měsíci',
	txtRepeatCustomYearLabel1: 'každý',
	txtRepeatCustomYearLabel2: 'v měsíci',

	txtRepeatEnd: 'konec',
	txtEventCalendar: 'Kalendář',
	txtSelectCalendar: 'Vyberte kalendář',
	txtAlert: 'Alarm',
	txtAlertNone: 'Žádný',
	txtAlertMessage: 'Správa',
	txtAlertOnDate: 'Na datum',
	txtAlertWeeksBefore: 'Týdnů před',
	txtAlertDaysBefore: 'Dnů před',
	txtAlertHoursBefore: 'Hodin před',
	txtAlertMinutesBefore: 'Minut před',
	txtAlertSecondsBefore: 'Sekund před',
	txtAlertWeeksAfter: 'Týdnů po',
	txtAlertDaysAfter: 'Dnů po',
	txtAlertHoursAfter: 'Sekund po',
	txtAlertMinutesAfter: 'Minut po',
	txtAlertSecondsAfter: 'Sekund po',

	pholderAfterBeforeVal: 'Hodnota',
	pholderAlarmDate: 'Den alarmu',
	pholderAlarmTime: 'Čas alarmu',

	pholderNote: 'Poznámka',

	eventPrevNav: 'Zobrazit předešlou instanci',
	eventNextNav: 'Zobrazit následující instanci',

	buttonClose: 'Zavřít',
	buttonDuplicate: 'Duplikovat',

	txtAllSavedTodo: 'Připomínka úspěšně uložena!',
	txtAllSaved: 'Událost úspěšně uložena!',

	txtAllDeletedTodo: 'Připomínka úspěšně vymazána!',
	txtAllDeleted: 'Událost úspěšně vymazána!',

	txtNotChooseTodo: 'Chyba: Musíte zvolit kalendář!',
	txtNotChoose: 'Chyba: Musíte zvolit kalendář!',

	txtErorInputTodo: 'Chyba: opravte chybné hodnoty!',
	txtDateTimeErrorTodo: 'Chyba: Musíte zvolit den a čas!',

	txtErrorDates: 'Chyba: Čas začátku musí být před koncem!',
	txtErrorDatesTodo: 'Chyba: Čas začátku musí být před koncem!',

	txtErorInput: 'Chyba: opravte vyznačené chybné hodnoty!',

	txtAlertsH: 'Alarmy',
	buttonAlert: 'Smazat alarmy',

	altAddEvent: 'Přidat událost',
	altAddTodo: 'Přidat připomínku',

	loadingCalendars: 'Načítavání kalendářů (%act% z %total%) ...',
	unloadingCalendars: 'Odčítavání kalendářů ...',

	errUnableSaveBeginCalDAV: 'Chyba: \'nepodařilo sa uložit událost\': %%!',
	errUnableDeleteBeginCalDAV: 'Chyba: \'nepodařilo sa vymazat událost\': %%!',
	CalDAVerrHttp410: 'Událost již není dostupná na serveru',
	errUnableSaveTodoBeginCalDAV: 'Chyba: \'nepodařilo sa uložit připomínku \': %%!',
	errUnableDeleteTodoBeginCalDAV: 'Chyba: \'nepodařilo sa vymazat připomínku\': %%!',
	CalDAVerrTodoHttp410: 'Připomínka již není dostupná na serveru'
};

localizationCalDAV['da_DK']=	/* thanks Niels Bo Andersen and Michael Rasmussen */
{
	_default_title_format_month_: 'MMM yyyy',
	_default_title_format_week_: 'd[ MMM][ yyyy]{ \'–\' d MMM yyyy}',
	_default_title_format_day_: 'ddd, d MMM yyyy',
	_default_title_format_table_: 'ddd, MMM yyyy',
	_default_column_format_agenda_: 'ddd, d MMM',

	txtCalendar: 'Kalender',
	txtEnabledCalendars: 'Aktiver kalendere',
	txtTodo: 'Opgave',
	txtTodoList: 'Opgaveliste',
	txtTodoLists: 'Opgavelister',
	txtEnabledTodoLists: 'Aktiver opgavelister',
	txtSubscribed: 'Abonnementer',
	fullCalendarTable: 'tabel',
	fullCalendarTodayButton: 'i dag',
	fullCalendarAllDay: 'hele dagen',
	CalDAVsearch: 'Søg',
	resourceEnable: 'Aktiver alle kalendere i denne ressource',
	resourceDisable: 'Deaktiver alle kalendere i denne ressource',
	allEnable: 'Aktiver alle kalendere',
	allDisable: 'Deaktiver alle kalendere',
	timezone: 'Tidszone',
	txtTimezonePicker: 'Tidszone:',
	loadingRList: 'Henter ressourceliste ...',
	renderingE: 'Klargør kalendere ...',
	timezoneChange: 'Udfører tidszoneskift ...',
	customTimezone: 'Brugerdefineret (Lokal tid)',
	customRepeat: 'Andet (kan ikke redigeres)',
	loadPrevMonth: 'Hent forrige måned',
	loadNextMonth: 'Hent næste måned',
	repeatBoxButton: 'Gentagelse',
	repeatBoxContent: 'er en gentaget begivenhed.',
	repeatBoxQuestion: 'Hvilke forekomster vil du åbne?',
	allEvsButton: 'Alle forekomster',
	allFutureButton: 'Denne og alle fremtidige forekomster',
	eventOnlyButton: 'Kun denne forekomst',
	repeatBoxContentTODO: 'er en tilbagevendende todo.',
	repeatBoxQuestionTODO: 'Hvilke todos vil du arbejde med',
	allEvsButtonTODO: 'Alle todos',
	allFutureButtonTODO: 'Denne og alle fremtidige todos',
	eventOnlyButtonTODO: 'Kun denne todo',
	txtStatus: 'Status',
	eventAvailability : 'Vis som',
	eventAvailabilityBusy : 'Optaget',
	eventAvailabilityFree : 'Ledig',
	eventType: 'Fortrolighed',
	eventTypePublic: 'Offentlig',
	eventTypePrivate: 'Privat',
	eventTypeConfidential: 'Fortrolig',
	txtPriority: 'Prioritet',
	txtPriorityNone: 'Ingen',
	txtPriorityLow: 'Lav',
	txtPriorityMedium: 'Mellem',
	txtPriorityHigh: 'Høj',
	eventURL : 'URL',
	repeatInterval: 'Hver',
	repeatDays: 'dag(e)',
	repeatWeeks: 'uge(r)',
	repeatMonths: 'måned(er)',
	repeatYears: 'år',
	repeatChangeTxt: 'blev ændret på serveren!',
	repeatChangeTxtClose: 'Luk formularen og åbn begivenheden igen',
	repeatTodoChangeTxtClose: 'Close the form and open the todo again',
	calendarLoader: 'Genindlæser ...',
	resizeLoader: 'Tilpasser størrelse ...',

	// TODOS
	pholderNameTODO: 'Emne',
	pholderNewTODO: 'Ny opgave',
	txtTypeTODO: 'Type',
	txtTypeTODONone: 'Simpel',
	txtTypeTODOStart: 'Med startdato',
	txtTypeTODODue: 'Med forfaldsdato',
	txtTypeTODOBoth: 'Med både startdato og forfaldsdato',
	txtDateFromTODO: 'Fra',
	txtDateToTODO: 'Til',
	txtCompletedOn: 'Færdiggjort den',

	pholderDateFromTODO: 'Fra dato',
	pholderTimeFromTODO: 'Fra kl.',
	pholderDateToTODO: 'Til dato',
	pholderTimeToTODO: 'Til kl.',
	pholderCompletedOnDate: 'Dato',
	pholderCompletedOnTime: 'Time',

	txtStatusFiltersHeaderTODO: 'Filtre',
	txtStatusFiltersFooterTODO: '* afsluttet %date% eller senere',
	txtStatusNeedsActionTODO: 'Kræver opfølgning',
	txtStatusCompletedTODO: 'Fuldført',
	txtStatusInProcessTODO: 'Under udførelse',
	txtStatusCancelledTODO: 'Annulleret',
	txtPercentCompletedTODO: 'Fuldført',

	txtCalendarTODO: 'Kalender',
	txtSelectCalendarTODO: 'Vælg kalender',
	txtAlertTODO: 'Påmindelse',
	txtAlertNoneTODO: 'None',
	txtAlertMessageTODO: 'Besked',
	txtAlertOnDateTODO: 'På dagen',
	txtAlertWeeksBeforeTODO: 'Uger før',
	txtAlertDaysBeforeTODO: 'Dage før',
	txtAlertHoursBeforeTODO: 'Timer før',
	txtAlertMinutesBeforeTODO: 'Minutter før',
	txtAlertSecondsBeforeTODO: 'Sekunder før',
	txtAlertWeeksAfterTODO: 'Uger efter',
	txtAlertDaysAfterTODO: 'Dage efter',
	txtAlertHoursAfterTODO: 'Timer efter',
	txtAlertMinutesAfterTODO: 'Minutter efter',
	txtAlertSecondsAfterTODO: 'Sekunder efter',

	pholderAfterBeforeValTODO: 'Værdi',
	pholderAlarmDateTODO: 'Alarmdato',
	pholderAlarmTimeTODO: 'Alarmtid',

	pholderNoteTODO: 'Note',
	txtNoteTODO: 'Note',

	todoPrevNav: 'Vis forrige',
	todoNextNav: 'Vis næste',
	todoUncompletedPrevNav: 'Vis forrige uafsluttede',
	todoUncompletedNextNav: 'Vis næste uafsluttede',

	buttonSaveTODO: 'Gem',
	buttonEditTODO: 'Rediger',
	buttonDuplicateTODO: 'Kopier',
	buttonResetTODO: 'Fortryd',
	buttonCloseTODO: 'Luk',
	buttonDeleteTODO: 'Slet',

	// EVENTS
	pholderName: 'Emne',
	pholderNewEvent: 'Ny begivenhed',
	txtLocation: 'Sted',
	pholderLocation: 'Sted',

	txtAllDay: 'Hele dagen',
	from: 'Fra',
	to: 'Til',

	pholderDateFrom: 'Fra dato',
	pholderTimeFrom: 'Fra kl.',
	pholderDateTo: 'Til dato',
	pholderTimeTo: 'Til kl.',

	txtStatusNone: 'Uspecifiseret',
	txtStatusTentative: 'Usikker',
	txtStatusConfirmed: 'Bekræftet',
	txtStatusCancelled: 'Annulleret',

	txtRepeat: 'Gentagelse',
	txtNoRepeat: 'Ingen gentagelse',
	txtRepeatDay: 'Dagligt',
	txtRepeatWeek: 'Ugentligt',
	txtRepeatWeekend: 'Hver weekend',
	txtRepeatMonth: 'Månedligt',
	txtRepeatTwoWeek: 'Hver anden uge',
	txtRepeatYear: 'Årligt',
	txtRepeatCustomWeek: 'Ugentligt (avanceret)',
	txtRepeatCustomMonth: 'Månedligt (avanceret)',
	txtRepeatCustomYear: 'Årligt (avanceret)',
	txtRepeatWork: 'På arbejdsdage',
	txtRepeatOnDate: 'På dato',
	txtRepeatAfter: 'Forekomster',
	txtRepeatNever: 'Aldrig',
	pholderUntilDate: 'Indtil dato',
	pholderRepeatCount: 'Antal gentagelser',
	txtRepeatCustomWeekLabel: 'På',
	txtRepeatCustomMonthLabel: 'På dage',
	txtRepeatCustomMonthEvery: 'Hver',
	txtRepeatCustomMonthFirst: 'Første',
	txtRepeatCustomMonthSecond: 'Anden',
	txtRepeatCustomMonthThird: 'Tredie',
	txtRepeatCustomMonthFourth: 'Fjerde',
	txtRepeatCustomMonthFifth: 'Femte',
	txtRepeatCustomMonthLast: 'Sidste',
	txtRepeatCustomMonthCustom: 'Valgfri',
	txtRepeatCustomMonthMonth: 'Dag i måneden',
	txtRepeatCustomYearLabel1: 'Hver',
	txtRepeatCustomYearLabel2: 'i',

	txtRepeatEnd: 'Slut',
	txtEventCalendar: 'Kalender',
	txtSelectCalendar: 'Vælg kalender',
	txtAlert: 'Påmindelse',
	txtAlertNone: 'Ingen',
	txtAlertMessage: 'Besked',
	txtAlertOnDate: 'På dato',
	txtAlertWeeksBefore: 'Uger før',
	txtAlertDaysBefore: 'Dage før',
	txtAlertHoursBefore: 'Timer før',
	txtAlertMinutesBefore: 'Minutter før',
	txtAlertSecondsBefore: 'Sekunder før',
	txtAlertWeeksAfter: 'Uger efter',
	txtAlertDaysAfter: 'Dage efter',
	txtAlertHoursAfter: 'Timer efter',
	txtAlertMinutesAfter: 'Minutter efter',
	txtAlertSecondsAfter: 'Sekunder efter',

	pholderAfterBeforeVal: 'Værdi',
	pholderAlarmDate: 'Alarmdato',
	pholderAlarmTime: 'Alarmtid',

	pholderNote: 'Note',

	eventPrevNav: 'Vis forrige',
	eventNextNav: 'Vis næste',

	buttonClose: 'Luk',
	buttonDuplicate: 'Kopier',

	txtAllSavedTodo: 'Opgave gemt!',
	txtAllSaved: 'Begivenhed gemt!',

	txtAllDeletedTodo: 'Opgave slettet!',
	txtAllDeleted: 'Begivenhed slettet!',

	txtNotChooseTodo: 'Fejl: Vælg en kalender!',
	txtNotChoose: 'Fejl: Vælg en kalender!',

	txtErrorDates: 'Fejl: Startdatoen skal komme før slutdatoen!',
	txtErrorDatesTodo: 'Fejl: Startdatoen skal komme før forfaldsdatoen!',

	txtErorInputTodo: 'Kunne ikke gemme: ret de ugyldige værdier!',
	txtDateTimeErrorTodo: 'Der skal vælges dato og tid!',

	txtErorInput: 'Fejl: \'kunne ikke gemme\': ret de markerede ugyldige værdier!',

	txtAlertsH: 'Påmindelser',
	buttonAlert: 'Fjern påmindelser',

	altAddEvent: 'Tilføj begivenhed',
	altAddTodo: 'Tilføj opgave',

	loadingCalendars: 'Indlæser kalendere (%act% af %total%) ...',
	unloadingCalendars: 'Gemmer kalendere ...',

	errUnableSaveBeginCalDAV: 'Fejl: \'kunne ikke gemme begivenheden\': %%!',
	errUnableDeleteBeginCalDAV: 'Fejl: \'kunne ikke slette begivenheden\': %%!',
	CalDAVerrHttp410: 'Begivenheden er ikke længere tilgængelig på serveren',
	errUnableSaveTodoBeginCalDAV: 'Fejl: \'Kunne ikke gemme todo\': %%!',
	errUnableDeleteTodoBeginCalDAV: 'Fejl: \'Kunne ikke slette todo\': %%!',
	CalDAVerrTodoHttp410: 'Todo findes ikke længere på serveren'
};

localizationCalDAV['de_DE']=	/* thanks Marten Gajda and Thomas Scheel */
{
	_default_title_format_month_: 'MMM yyyy',
	_default_title_format_week_: 'd[ MMM][ yyyy]{ \'–\' d MMM yyyy}',
	_default_title_format_day_: 'ddd, d MMM yyyy',
	_default_title_format_table_: 'ddd, MMM yyyy',
	_default_column_format_agenda_: 'ddd, d MMM',

	txtCalendar: 'Kalender',
	txtEnabledCalendars: 'Aktive Kalender',
	txtTodo: 'Aufgabe',
	txtTodoList: 'Aufgabenliste',
	txtTodoLists: 'Aufgabenlisten',
	txtEnabledTodoLists: 'Aktive Aufgabenlisten',
	txtSubscribed: 'Abonnements',
	fullCalendarTable: 'Liste', /* is this an Agenda? */
	fullCalendarTodayButton: 'Heute',
	fullCalendarAllDay: 'ganztägig',
	CalDAVsearch: 'Suchen',
	resourceEnable: 'Aktiviere alle Kalender in dieser Ressource',
	resourceDisable: 'Deaktiviere alle Kalender in dieser Ressource',
	allEnable: 'Aktiviere alle Kalender',
	allDisable: 'Deaktiviere alle Kalender',
	timezone: 'Zeitzone',
	txtTimezonePicker: 'Zeitzone:',
	loadingRList: 'Lade Ressourcenliste ...',
	renderingE: 'Bereite Ansicht vor ...',
	timezoneChange: 'Anwenden der Zeitzonenänderung ...',
	customTimezone: 'Unbekannt (lokale Zeit)',
	customRepeat: 'Sonstige (nicht änderbar)',
	loadPrevMonth: 'Zeige vorherigen Monat',
	loadNextMonth: 'Zeige nächsten Monat',
	repeatBoxButton: 'Wiederholung',
	repeatBoxContent: 'ist ein Serientermin.',
	repeatBoxQuestion: 'Welche Termine sollen bearbeitet werden?',
	allEvsButton: 'Alle Termine',
	allFutureButton: 'Dieser und alle zukünftigen Termine',
	eventOnlyButton: 'Nur diesen Termin',
	repeatBoxContentTODO: 'ist eine Serienaufgabe.',
	repeatBoxQuestionTODO: 'Welche Aufgaben möchten Sie bearbeiten?',
	allEvsButtonTODO: 'Alle Aufgaben',
	allFutureButtonTODO: 'Diese und alle zukünftigen Aufgaben',
	eventOnlyButtonTODO: 'Nur diese Aufgabe',
	txtStatus: 'Status',
	eventAvailability : 'Verfügbarkeit',
	eventAvailabilityBusy : 'beschäftigt',
	eventAvailabilityFree : 'verfügbar',
	eventType: 'Privatsphäre',
	eventTypePublic: 'öffentlich',
	eventTypePrivate: 'privat',
	eventTypeConfidential: 'vertraulich',
	txtPriority: 'Priorität',
	txtPriorityNone: 'Ohne',
	txtPriorityLow: 'Niedrig',
	txtPriorityMedium: 'Mittel',
	txtPriorityHigh: 'Hoch',
	eventURL : 'URL',
	repeatInterval: 'Alle',
	repeatDays: 'Tage',
	repeatWeeks: 'Wochen',
	repeatMonths: 'Monate',
	repeatYears: 'Jahre',
	repeatChangeTxt: 'wurde auf dem Server geändert!',
	repeatChangeTxtClose: 'Fenster schließen und Termin erneut öffnen',
	repeatTodoChangeTxtClose: 'Fenster schließen und Aufgabe erneut öffnen',
	calendarLoader: 'Lade ...',
	resizeLoader: 'Größe anpassen ...',

	// TODOS
	pholderNameTODO: 'Titel',
	pholderNewTODO: 'Neue Aufgabe',
	txtTypeTODO: 'Aufgabentyp',
	txtTypeTODONone: 'einfach',
	txtTypeTODOStart: 'mit Startzeit',
	txtTypeTODODue: 'mit Fälligkeit',
	txtTypeTODOBoth: 'mit Startzeit und Fälligkeit',
	txtDateFromTODO: 'Von',
	txtDateToTODO: 'Bis',
	txtCompletedOn: 'Fertiggestellt',

	pholderDateFromTODO: 'Startdatum',
	pholderTimeFromTODO: 'Startzeit',
	pholderDateToTODO: 'Enddatum',
	pholderTimeToTODO: 'Endzeit',
	pholderCompletedOnDate: 'Datum',
	pholderCompletedOnTime: 'Zeit',

	txtStatusFiltersHeaderTODO: 'Filter',
	txtStatusFiltersFooterTODO: '* am oder nach dem %date% fertiggestellt.',
	txtStatusNeedsActionTODO: 'offen', /* Lightning translates it to 'Benötigt Eingriff' */
	txtStatusCompletedTODO: 'erledigt',
	txtStatusInProcessTODO: 'in Bearbeitung',
	txtStatusCancelledTODO: 'abgebrochen',
	txtPercentCompletedTODO: 'erledigt',

	txtCalendarTODO: 'Kalender',
	txtSelectCalendarTODO: 'Kalender auswählen',
	txtAlertTODO: 'Alarm',
	txtAlertNoneTODO: 'ohne',
	txtAlertMessageTODO: 'Benachrichtigung',
	txtAlertOnDateTODO: 'am',
	txtAlertWeeksBeforeTODO: 'Wochen vorher',
	txtAlertDaysBeforeTODO: 'Tage vorher',
	txtAlertHoursBeforeTODO: 'Stunden vorher',
	txtAlertMinutesBeforeTODO: 'Minuten vorher',
	txtAlertSecondsBeforeTODO: 'Sekunden vorher',
	txtAlertWeeksAfterTODO: 'Wochen danach',
	txtAlertDaysAfterTODO: 'Tage danach',
	txtAlertHoursAfterTODO: 'Stunden danach',
	txtAlertMinutesAfterTODO: 'Minuten danach',
	txtAlertSecondsAfterTODO: 'Sekunden danach',

	pholderAfterBeforeValTODO: 'Wert', /* is this used anywhere */
	pholderAlarmDateTODO: 'Alarmdatum',
	pholderAlarmTimeTODO: 'Alarmzeit',

	pholderNoteTODO: 'Notiz',
	txtNoteTODO: 'Notiz',

	todoPrevNav: 'Zeige vorherige Instanz',
	todoNextNav: 'Zeige nächste Instanz',
	todoUncompletedPrevNav: 'Zeige vorherige unerledigte Instanz',
	todoUncompletedNextNav: 'Zeige nächste unerledigte Instanz',

	buttonSaveTODO: 'Speichern',
	buttonEditTODO: 'Bearbeiten',
	buttonDuplicateTODO: 'Duplizieren',
	buttonResetTODO: 'Verwerfen',
	buttonCloseTODO: 'Schließen',
	buttonDeleteTODO: 'Löschen',

	// EVENTS
	pholderName: 'Titel',
	pholderNewEvent: 'Neuer Termin',
	txtLocation: 'Ort',
	pholderLocation: 'Ort',

	txtAllDay: 'ganztägig',
	from: 'von',
	to: 'bis',

	pholderDateFrom: 'Startdatum',
	pholderTimeFrom: 'Startzeit',
	pholderDateTo: 'Enddatum',
	pholderTimeTo: 'Endzeit',

	txtStatusNone: 'Nicht angegeben',
	txtStatusTentative: 'Vorläufig',
	txtStatusConfirmed: 'Bestätigt',
	txtStatusCancelled: 'Abgebrochen',

	txtRepeat: 'Wiederholung',
	txtNoRepeat: 'ohne',
	txtRepeatDay: 'täglich',
	txtRepeatWeek: 'wöchentlich',
	txtRepeatWeekend: 'jedes Wochenende',
	txtRepeatMonth: 'monatlich',
	txtRepeatTwoWeek: '14-tägig',
	txtRepeatYear: 'jährlich',
	txtRepeatCustomWeek: 'wöchentlich (benutzerdefiniert)',
	txtRepeatCustomMonth: 'monatlich (benutzerdefiniert)',
	txtRepeatCustomYear: 'jährlich (benutzerdefiniert)',
	txtRepeatWork: 'werktags',
	txtRepeatOnDate: 'am',
	txtRepeatAfter: 'Wiederholungen',
	txtRepeatNever: 'nie',
	pholderUntilDate: 'bis Datum',
	pholderRepeatCount: 'Wiederholungen',
	txtRepeatCustomWeekLabel: 'am',
	txtRepeatCustomMonthLabel: 'an Tagen',
	txtRepeatCustomMonthEvery: 'jeden',
	txtRepeatCustomMonthFirst: 'ersten',
	txtRepeatCustomMonthSecond: 'zweiten',
	txtRepeatCustomMonthThird: 'dritten',
	txtRepeatCustomMonthFourth: 'vierten',
	txtRepeatCustomMonthFifth: 'fünften',
	txtRepeatCustomMonthLast: 'letzten',
	txtRepeatCustomMonthCustom: 'benutzerdefiniert',
	txtRepeatCustomMonthMonth: 'Tag des Monats',
	txtRepeatCustomYearLabel1: 'jeden',
	txtRepeatCustomYearLabel2: 'von',

	txtRepeatEnd: 'Ende',
	txtEventCalendar: 'Kalender',
	txtSelectCalendar: 'Kalender auswählen',
	txtAlert: 'Alarm',
	txtAlertNone: 'ohne',
	txtAlertMessage: 'Benachrichtigung',
	txtAlertOnDate: 'am',
	txtAlertWeeksBefore: 'Wochen vorher',
	txtAlertDaysBefore: 'Tage vorher',
	txtAlertHoursBefore: 'Stunden vorher',
	txtAlertMinutesBefore: 'Minuten vorher',
	txtAlertSecondsBefore: 'Sekunden vorher',
	txtAlertWeeksAfter: 'Wochen danach',
	txtAlertDaysAfter: 'Tage danach',
	txtAlertHoursAfter: 'Stunden danach',
	txtAlertMinutesAfter: 'Minuten danach',
	txtAlertSecondsAfter: 'Sekunden danach',

	pholderAfterBeforeVal: 'Wert',
	pholderAlarmDate: 'Alarmdatum',
	pholderAlarmTime: 'Alarmzeit',

	pholderNote: 'Notiz',

	eventPrevNav: 'Zeige vorherige Instanz',
	eventNextNav: 'Zeige nächste Instanz',

	buttonClose: 'Schließen',
	buttonDuplicate: 'Duplizieren',

	txtAllSavedTodo: 'Aufgabe erfolgreich gespeichert!',
	txtAllSaved: 'Termin erfolgreich gespeichert!',

	txtAllDeletedTodo: 'Aufgabe erfolgreich gelöscht!',
	txtAllDeleted: 'Termin erfolgreich gelöscht!',

	txtNotChooseTodo: 'Fehler: Kalender auswählen!',
	txtNotChoose: 'Fehler: Kalender auswählen!',

	txtErrorDates: 'Fehler: Startdatum muss vor dem Enddatum liegen!',
	txtErrorDatesTodo: 'Fehler: Startdatum muss vor dem Enddatum liegen!',

	txtErorInputTodo: 'Fehler beim Speichern: fehlerhafte Werte korrigieren!',
	txtDateTimeErrorTodo: 'Datum und Uhrzeit wählen!',

	txtErorInput: 'Fehler: \'Speichern nicht möglich\': Hervorgehobenen Werte korrigieren!',

	txtAlertsH: 'Alarme',
	buttonAlert: 'Lösche Alarme',

	altAddEvent: 'Termin hinzufügen',
	altAddTodo: 'Aufgabe hinzufügen',

	loadingCalendars: 'Lade Kalender (%act% von %total%) ...',
	unloadingCalendars: 'Entlade Kalender ...',

	errUnableSaveBeginCalDAV: 'Fehler: \'Termin konnte nicht gespeichert werden\': %%!',
	errUnableDeleteBeginCalDAV: 'Fehler: \'Termin konnte nicht gelöscht werden\': %%!',
	CalDAVerrHttp410: 'Der Termin existiert auf dem Server nicht mehr.',
	errUnableSaveTodoBeginCalDAV: 'Fehler: \'Aufgabe konnte nicht gespeichert werden\': %%!',
	errUnableDeleteTodoBeginCalDAV: 'Fehler: \'Aufgabe konnte nicht gelöscht werden\': %%!',
	CalDAVerrTodoHttp410: 'Die Aufgabe existiert auf dem Server nicht mehr.'
};

localizationCalDAV['en_US']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	_default_title_format_month_: 'yyyy MMM',
	_default_title_format_week_: 'yyyy MMM d{ \'–\'[ yyyy][ MMM] d}',
	_default_title_format_day_: 'yyyy MMM d, ddd',
	_default_title_format_table_: 'yyyy MMM, ddd',
	_default_column_format_agenda_: 'ddd, MMM d',

	txtCalendar: 'Calendar',
	txtEnabledCalendars: 'Enabled Calendars',
	txtTodo: 'Todo',
	txtTodoList: 'Todo List',
	txtTodoLists: 'Todo Lists',
	txtEnabledTodoLists: 'Enabled Todo Lists',
	txtSubscribed: 'Subscriptions',
	fullCalendarTable: 'table',
	fullCalendarTodayButton: 'today',
	fullCalendarAllDay: 'all day',
	CalDAVsearch: 'Search',
	resourceEnable: 'Enable all calendars in this resource',
	resourceDisable: 'Disable all calendars in this resource',
	allEnable: 'Enable all calendars',
	allDisable: 'Disable all calendars',
	timezone: 'Timezone',
	txtTimezonePicker: 'Timezone:',
	loadingRList: 'Loading resource list ...',
	renderingE: 'Rendering calendars ...',
	timezoneChange: 'Applying timezone change ...',
	customTimezone: 'Custom (Local Time)',
	customRepeat: 'Other (modification not supported)',
	loadPrevMonth: 'Load previous month',
	loadNextMonth: 'Load next month',
	repeatBoxButton: 'Recurrence',
	repeatBoxContent: 'is a repeating event.',
	repeatBoxQuestion: 'Which events would you like to work with?',
	allEvsButton: 'All events',
	allFutureButton: 'This and all future events',
	eventOnlyButton: 'This event only',
	repeatBoxContentTODO: 'is a repeating todo.',
	repeatBoxQuestionTODO: 'Which todos would you like to work with?',
	allEvsButtonTODO: 'All todos',
	allFutureButtonTODO: 'This and all future todos',
	eventOnlyButtonTODO: 'This todo only',
	txtStatus: 'Status',
	eventAvailability : 'Availability',
	eventAvailabilityBusy : 'Busy',
	eventAvailabilityFree : 'Free',
	eventType: 'Privacy',
	eventTypePublic: 'Public',
	eventTypePrivate: 'Private',
	eventTypeConfidential: 'Confidential',
	txtPriority: 'Priority',
	txtPriorityNone: 'None',
	txtPriorityLow: 'Low',
	txtPriorityMedium: 'Medium',
	txtPriorityHigh: 'High',
	eventURL : 'URL',
	repeatInterval: 'every',
	repeatDays: 'days',
	repeatWeeks: 'weeks',
	repeatMonths: 'months',
	repeatYears: 'years',
	repeatChangeTxt: 'was changed on the server!',
	repeatChangeTxtClose: 'Close the form and open the event again',
	repeatTodoChangeTxtClose: 'Close the form and open the todo again',
	calendarLoader: 'Reloading ...',
	resizeLoader: 'Resizing ...',

	// TODOS
	pholderNameTODO: 'Name',
	pholderNewTODO: 'New Todo',
	txtTypeTODO: 'Type',
	txtTypeTODONone: 'Simple',
	txtTypeTODOStart: 'With start time',
	txtTypeTODODue: 'With due time',
	txtTypeTODOBoth: 'With both start and due times',
	txtDateFromTODO: 'From',
	txtDateToTODO: 'To',
	txtCompletedOn: 'Completed on',

	pholderDateFromTODO: 'Date from',
	pholderTimeFromTODO: 'Time from',
	pholderDateToTODO: 'Date to',
	pholderTimeToTODO: 'Time to',
	pholderCompletedOnDate: 'Date',
	pholderCompletedOnTime: 'Time',

	txtStatusFiltersHeaderTODO: 'Filters',
	txtStatusFiltersFooterTODO: '* completed at or after %date%',
	txtStatusNeedsActionTODO: 'Needs action',
	txtStatusCompletedTODO: 'Completed',
	txtStatusInProcessTODO: 'In progress',
	txtStatusCancelledTODO: 'Canceled',
	txtPercentCompletedTODO: 'Completed',

	txtCalendarTODO: 'Calendar',
	txtSelectCalendarTODO: 'Select a calendar',
	txtAlertTODO: 'Alert',
	txtAlertNoneTODO: 'None',
	txtAlertMessageTODO: 'Message',
	txtAlertOnDateTODO: 'On date',
	txtAlertWeeksBeforeTODO: 'Weeks before',
	txtAlertDaysBeforeTODO: 'Days before',
	txtAlertHoursBeforeTODO: 'Hours before',
	txtAlertMinutesBeforeTODO: 'Minutes before',
	txtAlertSecondsBeforeTODO: 'Seconds before',
	txtAlertWeeksAfterTODO: 'Weeks after',
	txtAlertDaysAfterTODO: 'Days after',
	txtAlertHoursAfterTODO: 'Hours after',
	txtAlertMinutesAfterTODO: 'Minutes after',
	txtAlertSecondsAfterTODO: 'Seconds after',

	pholderAfterBeforeValTODO: 'Value',
	pholderAlarmDateTODO: 'Alarm date',
	pholderAlarmTimeTODO: 'Alarm time',

	pholderNoteTODO: 'Note',
	txtNoteTODO: 'Note',

	todoPrevNav: 'Show previous instance',
	todoNextNav: 'Show next instance',
	todoUncompletedPrevNav: 'Show previous uncompleted instance',
	todoUncompletedNextNav: 'Show next uncompleted instance',

	buttonSaveTODO: 'Save',
	buttonEditTODO: 'Edit',
	buttonDuplicateTODO: 'Duplicate',
	buttonResetTODO: 'Revert',
	buttonCloseTODO: 'Close',
	buttonDeleteTODO: 'Delete',

	// EVENTS
	pholderName: 'Name',
	pholderNewEvent: 'New Event',
	txtLocation: 'Location',
	pholderLocation: 'Location',

	txtAllDay: 'All day',
	from: 'From',
	to: 'To',

	pholderDateFrom: 'Date from',
	pholderTimeFrom: 'Time from',
	pholderDateTo: 'Date to',
	pholderTimeTo: 'Time to',

	txtStatusNone: 'Unspecified',
	txtStatusTentative: 'Tentative',
	txtStatusConfirmed: 'Confirmed',
	txtStatusCancelled: 'Cancelled',

	txtRepeat: 'Repeat',
	txtNoRepeat: 'No repeat',
	txtRepeatDay: 'Daily',
	txtRepeatWeek: 'Weekly',
	txtRepeatWeekend: 'Every weekend',
	txtRepeatMonth: 'Monthly',
	txtRepeatTwoWeek: 'Bi-weekly',
	txtRepeatYear: 'Yearly',
	txtRepeatCustomWeek: 'Custom weekly',
	txtRepeatCustomMonth: 'Custom monthly',
	txtRepeatCustomYear: 'Custom yearly',
	txtRepeatWork: 'Every business day',
	txtRepeatOnDate: 'On date',
	txtRepeatAfter: 'Occurrences',
	txtRepeatNever: 'Never',
	pholderUntilDate: 'Date until',
	pholderRepeatCount: 'Repeat count',
	txtRepeatCustomWeekLabel: 'on',
	txtRepeatCustomMonthLabel: 'on days',
	txtRepeatCustomMonthEvery: 'Every',
	txtRepeatCustomMonthFirst: 'First',
	txtRepeatCustomMonthSecond: 'Second',
	txtRepeatCustomMonthThird: 'Third',
	txtRepeatCustomMonthFourth: 'Fourth',
	txtRepeatCustomMonthFifth: 'Fifth',
	txtRepeatCustomMonthLast: 'Last',
	txtRepeatCustomMonthCustom: 'Custom',
	txtRepeatCustomMonthMonth: 'Day of the month',
	txtRepeatCustomYearLabel1: 'every',
	txtRepeatCustomYearLabel2: 'of',

	txtRepeatEnd: 'end',
	txtEventCalendar: 'Calendar',
	txtSelectCalendar: 'Select a calendar',
	txtAlert: 'Alert',
	txtAlertNone: 'None',
	txtAlertMessage: 'Message',
	txtAlertOnDate: 'On date',
	txtAlertWeeksBefore: 'Weeks before',
	txtAlertDaysBefore: 'Days before',
	txtAlertHoursBefore: 'Hours before',
	txtAlertMinutesBefore: 'Minutes before',
	txtAlertSecondsBefore: 'Seconds before',
	txtAlertWeeksAfter: 'Weeks after',
	txtAlertDaysAfter: 'Days after',
	txtAlertHoursAfter: 'Hours after',
	txtAlertMinutesAfter: 'Minutes after',
	txtAlertSecondsAfter: 'Seconds after',

	pholderAfterBeforeVal: 'Value',
	pholderAlarmDate: 'Alarm date',
	pholderAlarmTime: 'Alarm time',

	pholderNote: 'Note',

	eventPrevNav: 'Show previous instance',
	eventNextNav: 'Show next instance',

	buttonClose: 'Close',
	buttonDuplicate: 'Duplicate',

	txtAllSavedTodo: 'Success: Todo Saved!',
	txtAllSaved: 'Success: Event Saved!',

	txtAllDeletedTodo: 'Success: Todo Deleted!',
	txtAllDeleted: 'Success: Event Deleted!',

	txtNotChooseTodo: 'Error: Have to choose calendar!',
	txtNotChoose: 'Error: Have to choose calendar!',

	txtErrorDates: 'Error: Start date must precede the end date!',
	txtErrorDatesTodo: 'Error: Start date must precede the end date!',

	txtErorInputTodo: 'Unable to save: correct invalid values!',
	txtDateTimeErrorTodo: 'Have to choose date and time!',

	txtErorInput: 'Error: \'unable to save\': correct the highlighted invalid values!',

	txtAlertsH: 'Alerts',
	buttonAlert: 'Clear Alerts',

	altAddEvent: 'Add Event',
	altAddTodo: 'Add Todo',

	loadingCalendars: 'Loading calendars (%act% of %total%) ...',
	unloadingCalendars: 'Unloading calendars ...',

	errUnableSaveBeginCalDAV: 'Error: \'unable to save the event\': %%!',
	errUnableDeleteBeginCalDAV: 'Error: \'unable to delete the event\': %%!',
	CalDAVerrHttp410: 'Event is no longer available at the server',
	errUnableSaveTodoBeginCalDAV: 'Error: \'unable to save the todo\': %%!',
	errUnableDeleteTodoBeginCalDAV: 'Error: \'unable to delete todo\': %%!',
	CalDAVerrTodoHttp410: 'Todo is no longer available at the server'
};

localizationCalDAV['es_ES']=	/* Damian Vila <damianvila@gmail.com> */
{
	_default_title_format_month_: 'MMM yyyy',
	_default_title_format_week_: 'd[ MMM][ yyyy]{ \'–\' d MMM yyyy}',
	_default_title_format_day_: 'ddd, d MMM yyyy',
	_default_title_format_table_: 'ddd, MMM yyyy',
	_default_column_format_agenda_: 'ddd, d MMM',

	txtCalendar: 'Calendario',
	txtEnabledCalendars: 'Calendars habilitados',
	txtTodo: 'Tarea',
	txtTodoList: 'Lista de tareas',
	txtTodoLists: 'Listas de tareas',
	txtEnabledTodoLists: 'Listas de tareas habilitadas',
	txtSubscribed: 'Suscripciones',
	fullCalendarTable: 'tabla',
	fullCalendarTodayButton: 'hoy',
	fullCalendarAllDay: 'todo el día',
	CalDAVsearch: 'Buscar',
	resourceEnable: 'Habilitar todos los calendarios para este recurso',
	resourceDisable: 'Deshabilitar todos los calendarios para este recurso',
	allEnable: 'Habilitar todos los calendarios',
	allDisable: 'Deshabilitar todos los calendarios',
	timezone: 'Zona horaria',
	txtTimezonePicker: 'Z. horaria:',
	loadingRList: 'Cargando lista de recursos ...',
	renderingE: 'Generando calendarios ...',
	timezoneChange: 'Aplicando cambios de zona horaria ...',
	customTimezone: 'Personalizado (Tiempo local)',
	customRepeat: 'Otra (modificación no soportada)',
	loadPrevMonth: 'Cargar mes anterior',
	loadNextMonth: 'Cargar mes siguiente',
	repeatBoxButton: 'Recurrencia',
	repeatBoxContent: 'es un evento repetitivo.',
	repeatBoxQuestion: '¿Con cuáles eventos quieres trabajar?',
	allEvsButton: 'Todos los eventos',
	allFutureButton: 'Este y los eventos siguientes',
	eventOnlyButton: 'Solo este evento',
	repeatBoxContentTODO: 'es una tarea repetitiva.',
	repeatBoxQuestionTODO: '¿Con qué tareas quieres trabajar?',
	allEvsButtonTODO: 'Todas las tareas',
	allFutureButtonTODO: 'Esta y las futuras tareas',
	eventOnlyButtonTODO: 'Solo esta tarea',
	txtStatus: 'Estado',
	eventAvailability : 'Disponible',
	eventAvailabilityBusy : 'Ocupado',
	eventAvailabilityFree : 'Libre',
	eventType: 'Privacidad',
	eventTypePublic: 'Público',
	eventTypePrivate: 'Privado',
	eventTypeConfidential: 'Confidencial',
	txtPriority: 'Prioridad',
	txtPriorityNone: 'Ninguna',
	txtPriorityLow: 'Baja',
	txtPriorityMedium: 'Media',
	txtPriorityHigh: 'Alta',
	eventURL : 'URL',
	repeatInterval: 'cada',
	repeatDays: 'días',
	repeatWeeks: 'semanas',
	repeatMonths: 'meses',
	repeatYears: 'años',
	repeatChangeTxt: 'ha sido cambiado en el servidor!',
	repeatChangeTxtClose: 'Cierra el formulario y vuelve a abrir el evento',
	repeatTodoChangeTxtClose: 'Cierra el formulario y vuelve a abrir la tarea',
	calendarLoader: 'Recargando ...',
	resizeLoader: 'Redimensionando ...',

	// TODOS
	pholderNameTODO: 'Nombre',
	pholderNewTODO: 'Nueva tarea',
	txtTypeTODO: 'Tipo',
	txtTypeTODONone: 'Simple',
	txtTypeTODOStart: 'Con hora de inicio',
	txtTypeTODODue: 'Con hora de fin',
	txtTypeTODOBoth: 'Con hora de inicio y fin',
	txtDateFromTODO: 'Desde',
	txtDateToTODO: 'Hasta',
	txtCompletedOn: 'Completado en',

	pholderDateFromTODO: 'Fecha desde',
	pholderTimeFromTODO: 'Hora desde',
	pholderDateToTODO: 'Fecha hasta',
	pholderTimeToTODO: 'Hora hasta',
	pholderCompletedOnDate: 'Fecha',
	pholderCompletedOnTime: 'Hora',

	txtStatusFiltersHeaderTODO: 'Filtros',
	txtStatusFiltersFooterTODO: '* completado en o después de %date%',
	txtStatusNeedsActionTODO: 'Necesita atención',
	txtStatusCompletedTODO: 'Completado',
	txtStatusInProcessTODO: 'En progreso',
	txtStatusCancelledTODO: 'Cancelado',
	txtPercentCompletedTODO: 'Completado',

	txtCalendarTODO: 'Calendario',
	txtSelectCalendarTODO: 'Selecciona un calendario',
	txtAlertTODO: 'Alerta',
	txtAlertNoneTODO: 'Ninguno',
	txtAlertMessageTODO: 'Mensaje',
	txtAlertOnDateTODO: 'En la fecha',
	txtAlertWeeksBeforeTODO: 'Semanas antes',
	txtAlertDaysBeforeTODO: 'Días antes',
	txtAlertHoursBeforeTODO: 'Horas antes',
	txtAlertMinutesBeforeTODO: 'Minutos antes',
	txtAlertSecondsBeforeTODO: 'Segundos antes',
	txtAlertWeeksAfterTODO: 'Semanas después',
	txtAlertDaysAfterTODO: 'Días después',
	txtAlertHoursAfterTODO: 'Horas después',
	txtAlertMinutesAfterTODO: 'Minutos después',
	txtAlertSecondsAfterTODO: 'Segundos después',

	pholderAfterBeforeValTODO: 'Valor',
	pholderAlarmDateTODO: 'Fecha de alarma',
	pholderAlarmTimeTODO: 'Hora de alarma',

	pholderNoteTODO: 'Nota',
	txtNoteTODO: 'Nota',

	todoPrevNav: 'Mostrar instancia previa',
	todoNextNav: 'Mostrar siguiente instancia',
	todoUncompletedPrevNav: 'Mostrar instancia previa incompleta',
	todoUncompletedNextNav: 'Mostrar siguiente instancia incompleta',

	buttonSaveTODO: 'Guardar',
	buttonEditTODO: 'Editar',
	buttonDuplicateTODO: 'Duplicar',
	buttonResetTODO: 'Revertir',
	buttonCloseTODO: 'Cerrar',
	buttonDeleteTODO: 'Borrar',

	// EVENTS
	pholderName: 'Nombre',
	pholderNewEvent: 'Nuevo evento',
	txtLocation: 'Lugar',
	pholderLocation: 'Lugar',

	txtAllDay: 'Todo el día',
	from: 'Desde',
	to: 'Hasta',

	pholderDateFrom: 'Fecha desde',
	pholderTimeFrom: 'Hora desde',
	pholderDateTo: 'Fecha hasta',
	pholderTimeTo: 'Hora hasta',

	txtStatusNone: 'No especificado',
	txtStatusTentative: 'Tentativo',
	txtStatusConfirmed: 'Confirmado',
	txtStatusCancelled: 'Cancelado',

	txtRepeat: 'Repetir',
	txtNoRepeat: 'No repetir',
	txtRepeatDay: 'Diariamente',
	txtRepeatWeek: 'Semanalmente',
	txtRepeatWeekend: 'Cada fin de semana',
	txtRepeatMonth: 'Mensualmente',
	txtRepeatTwoWeek: 'Bi-semanalmente',
	txtRepeatYear: 'Anualmente',
	txtRepeatCustomWeek: 'Semanalmente personalizado',
	txtRepeatCustomMonth: 'Mensualmente personalizado',
	txtRepeatCustomYear: 'Anualmente personalizado',
	txtRepeatWork: 'En días de semana',
	txtRepeatOnDate: 'En la fecha',
	txtRepeatAfter: 'Ocurrencias',
	txtRepeatNever: 'Nunca',
	pholderUntilDate: 'Fecha hasta',
	pholderRepeatCount: 'Repetir la cuenta',
	txtRepeatCustomWeekLabel: 'en',
	txtRepeatCustomMonthLabel: 'en los días',
	txtRepeatCustomMonthEvery: 'Cada',
	txtRepeatCustomMonthFirst: 'Primer',
	txtRepeatCustomMonthSecond: 'Segundo',
	txtRepeatCustomMonthThird: 'Tercer',
	txtRepeatCustomMonthFourth: 'Cuarto',
	txtRepeatCustomMonthFifth: 'Quinto',
	txtRepeatCustomMonthLast: 'Último',
	txtRepeatCustomMonthCustom: 'Personalizado',
	txtRepeatCustomMonthMonth: 'Día del mes',
	txtRepeatCustomYearLabel1: 'cada',
	txtRepeatCustomYearLabel2: 'de',

	txtRepeatEnd: 'fin',
	txtEventCalendar: 'Calendario',
	txtSelectCalendar: 'Selecciona un calendario',
	txtAlert: 'Alerta',
	txtAlertNone: 'Ninguno',
	txtAlertMessage: 'Mensaje',
	txtAlertOnDate: 'En la fecha',
	txtAlertWeeksBefore: 'Semanas antes',
	txtAlertDaysBefore: 'Días antes',
	txtAlertHoursBefore: 'Horas antes',
	txtAlertMinutesBefore: 'Minutos antes',
	txtAlertSecondsBefore: 'Segundos antes',
	txtAlertWeeksAfter: 'Semanas después',
	txtAlertDaysAfter: 'Días después',
	txtAlertHoursAfter: 'Horas después',
	txtAlertMinutesAfter: 'Minutos después',
	txtAlertSecondsAfter: 'Segundos después',

	pholderAfterBeforeVal: 'Valor',
	pholderAlarmDate: 'Fecha de alarm',
	pholderAlarmTime: 'Hora de alarma',

	pholderNote: 'Nota',

	eventPrevNav: 'Mostrar instancia previa',
	eventNextNav: 'Mostrar siguiente instancia',

	buttonClose: 'Cerrar',
	buttonDuplicate: 'Duplicar',

	txtAllSavedTodo: 'Éxito: Tarea guardada!',
	txtAllSaved: 'Éxito: Evento guardado!',

	txtAllDeletedTodo: 'Éxito: Tarea borrada!',
	txtAllDeleted: 'Éxito: Evento borrado!',

	txtNotChooseTodo: 'Error: Tienes que elegir un calendario!',
	txtNotChoose: 'Error: Tienes que elegir un calendario!',

	txtErrorDates: 'Error: La fecha de comienzo debe ser anterior a la de fin!',
	txtErrorDatesTodo: 'Error: La fecha de comienzo debe ser anterior a la de fin!',

	txtErorInputTodo: 'Imposible guardar: corrige los valores inválidos!',
	txtDateTimeErrorTodo: 'Debes elegir una fecha y hora!',

	txtErorInput: 'Error: \'imposible guardar\': corrige los valores marcados!',

	txtAlertsH: 'Alertas',
	buttonAlert: 'Limpiar alertas',

	altAddEvent: 'Agregar evento',
	altAddTodo: 'Agregar tarea',

	loadingCalendars: 'Cargando calendarios (%act% de %total%) ...',
	unloadingCalendars: 'Quitando calendarios ...',

	errUnableSaveBeginCalDAV: 'Error: \'imposible guardar el evento\': %%!',
	errUnableDeleteBeginCalDAV: 'Error: \'imposible borrar el evento\': %%!',
	CalDAVerrHttp410: 'El evento ya no está disponible en el servidor',
	errUnableSaveTodoBeginCalDAV: 'Error: \'imposible guardar la tarea\': %%!',
	errUnableDeleteTodoBeginCalDAV: 'Error: \'imposible borrar la tarea\': %%!',
	CalDAVerrTodoHttp410: 'La tarea ya no está disponible en el servidor'
};

localizationCalDAV['fr_FR']=	/* thanks John Fischer and Jean-Christophe Bach */
{
	_default_title_format_month_: 'MMM yyyy',
	_default_title_format_week_: 'd[ MMM][ yyyy]{ \'–\' d MMM yyyy}',
	_default_title_format_day_: 'ddd, d MMM yyyy',
	_default_title_format_table_: 'ddd, MMM yyyy',
	_default_column_format_agenda_: 'ddd, d MMM',

	txtCalendar: 'Calendrier',
	txtEnabledCalendars: 'Calendriers activés',
	txtTodo: 'À faire',
	txtTodoList: 'Liste des tâches',
	txtTodoLists: 'Listes des tâches',
	txtEnabledTodoLists: 'Listes des tâches activées',
	txtSubscribed: 'Abonnements',
	fullCalendarTable: 'tableau',
	fullCalendarTodayButton: 'aujourd\'hui',
	fullCalendarAllDay: 'Toute la journée',
	CalDAVsearch: 'Recherche',
	resourceEnable: 'Activer tous les calendriers pour cette ressource',
	resourceDisable: 'Désactiver tous les calendriers pour cette ressource',
	allEnable: 'Activer tous les calendriers',
	allDisable: 'Désactiver tous les calendriers',
	timezone: 'Fuseau horaire',
	txtTimezonePicker: 'Fuseau horaire : ',
	loadingRList: 'Chargement de la liste des ressources...',
	renderingE: 'Prévisualisation des calendriers ...',
	timezoneChange: 'Changement de fuseau horaire...',
	customTimezone: 'Personnalisé (heure locale)',
	customRepeat: 'Autre (changement n\'est pas supporté)',
	loadPrevMonth: 'Charger le mois précédent',
	loadNextMonth: 'Charger le mois suivant',
	repeatBoxButton: 'Récurrence',
	repeatBoxContent: 'est un évènement récurrent.',
	repeatBoxQuestion: 'Avec quels évènements voulez-vous travailler ?',
	allEvsButton: 'Tous les évènements',
	allFutureButton: 'Tous les évènements à venir',
	eventOnlyButton: 'Cet évènement seulement',
	repeatBoxContentTODO: 'est une tâche récurrente.',
	repeatBoxQuestionTODO: 'Quelles tâches désirez-vous associer ?',
	allEvsButtonTODO: 'Toutes les tâches',
	allFutureButtonTODO: 'Toutes les tâches futures à faire',
	eventOnlyButtonTODO: 'Cette tâche seulement',
	txtStatus: 'État',
	eventAvailability : 'Disponibilité',
	eventAvailabilityBusy : 'Occupé',
	eventAvailabilityFree : 'Disponible',
	eventType: 'Confidentialité',
	eventTypePublic: 'Public',
	eventTypePrivate: 'Privé',
	eventTypeConfidential: 'Confidentiel',
	txtPriority: 'Priorité',
	txtPriorityNone: 'Aucune',
	txtPriorityLow: 'Basse',
	txtPriorityMedium: 'Moyenne',
	txtPriorityHigh: 'Haute',
	eventURL : 'URL',
	repeatInterval: 'Tous les',
	repeatDays: 'jours',
	repeatWeeks: 'semaines',
	repeatMonths: 'mois',
	repeatYears: 'ans',
	repeatChangeTxt: 'a été modifié sur le serveur !',
	repeatChangeTxtClose: 'Fermer ce formulaire et rouvrir cet évènement',
	repeatTodoChangeTxtClose: 'Fermer la boîte de dialogue et ouvrir à nouveau la tâche',
	calendarLoader: 'Rechargement...',
	resizeLoader: 'Redimensionnement...',

	// TODOS
	pholderNameTODO: 'Nom',
	pholderNewTODO: 'Nouvelle tâche',
	txtTypeTODO: 'Type',
	txtTypeTODONone: 'Simple',
	txtTypeTODOStart: 'Avec date de début',
	txtTypeTODODue: 'Avec date butoir',
	txtTypeTODOBoth: 'Avec des dates de début et de fin',
	txtDateFromTODO: 'De',
	txtDateToTODO: 'À',
	txtCompletedOn: 'Se termine le',

	pholderDateFromTODO: 'Date de',
	pholderTimeFromTODO: 'Heure de',
	pholderDateToTODO: 'Date à',
	pholderTimeToTODO: 'Heure à',
	pholderCompletedOnDate: 'Date',
	pholderCompletedOnTime: 'Heure',

	txtStatusFiltersHeaderTODO: 'Filtres',
	txtStatusFiltersFooterTODO: '* Se termine à ou après le %date%',
	txtStatusNeedsActionTODO: 'En attente d\'action',
	txtStatusCompletedTODO: 'Terminée',
	txtStatusInProcessTODO: 'En cours',
	txtStatusCancelledTODO: 'Annulée',
	txtPercentCompletedTODO: 'Achevée',

	txtCalendarTODO: 'Calendrier',
	txtSelectCalendarTODO: 'Sélection d\'un calendrier',
	txtAlertTODO: 'Alerte',
	txtAlertNoneTODO: 'Vide',
	txtAlertMessageTODO: 'Message',
	txtAlertOnDateTODO: 'à la date',
	txtAlertWeeksBeforeTODO: 'Semaines avant',
	txtAlertDaysBeforeTODO: 'Jours avant',
	txtAlertHoursBeforeTODO: 'Heures avant',
	txtAlertMinutesBeforeTODO: 'Minutes avant',
	txtAlertSecondsBeforeTODO: 'Secondes avant',
	txtAlertWeeksAfterTODO: 'Semaines après',
	txtAlertDaysAfterTODO: 'Jours après',
	txtAlertHoursAfterTODO: 'Heures après',
	txtAlertMinutesAfterTODO: 'Minutes après',
	txtAlertSecondsAfterTODO: 'Secondes après',

	pholderAfterBeforeValTODO: 'Valeur',
	pholderAlarmDateTODO: 'Date de l\'alarme',
	pholderAlarmTimeTODO: 'Heure de l\'alarme',

	pholderNoteTODO: 'Note',
	txtNoteTODO: 'Note',

	todoPrevNav: 'Montrer l\'instance précédente',
	todoNextNav: 'Montrer l\'instance suivante',
	todoUncompletedPrevNav: 'Montrer la précédente instance incomplète',
	todoUncompletedNextNav: 'Montrer l\'instance suivante incomplète',

	buttonSaveTODO: 'Enregistrer',
	buttonEditTODO: 'Éditer',
	buttonDuplicateTODO: 'Dupliquer',
	buttonResetTODO: 'Revenir',
	buttonCloseTODO: 'Fermer',
	buttonDeleteTODO: 'Effacer',

	// EVENTS
	pholderName: 'Nom',
	pholderNewEvent: 'Nouvel évènement',
	txtLocation: 'Lieu',
	pholderLocation: 'Lieu',

	txtAllDay: 'Toute la journée',
	from: 'De',
	to: 'À',

	pholderDateFrom: 'Date de',
	pholderTimeFrom: 'Heure de',
	pholderDateTo: 'Date à',
	pholderTimeTo: 'Heure à',

	txtStatusNone: 'Non spécifié',
	txtStatusTentative: 'Tentative',
	txtStatusConfirmed: 'Confirmé',
	txtStatusCancelled: 'Annulé',

	txtRepeat: 'Répéter',
	txtNoRepeat: 'Ne pas répéter',
	txtRepeatDay: 'Quotidien',
	txtRepeatWeek: 'Hebdomadaire',
	txtRepeatWeekend: 'Tous les weekends',
	txtRepeatMonth: 'Mensuel',
	txtRepeatTwoWeek: 'Bi-mensuel',
	txtRepeatYear: 'Annuel',
	txtRepeatCustomWeek: 'Hebdomadaire personnalisé',
	txtRepeatCustomMonth: 'Mensuel personnalisé',
	txtRepeatCustomYear: 'Annuel personnalisé',
	txtRepeatWork: 'Tous les jours ouvrables',
	txtRepeatOnDate: 'À la date',
	txtRepeatAfter: 'Occurrences',
	txtRepeatNever: 'Jamais',
	pholderUntilDate: 'Jusqu\'à la date',
	pholderRepeatCount: 'nombre de répétitions',
	txtRepeatCustomWeekLabel: 'Le',
	txtRepeatCustomMonthLabel: 'Les jours',
	txtRepeatCustomMonthEvery: 'Tous',
	txtRepeatCustomMonthFirst: 'Premier',
	txtRepeatCustomMonthSecond: 'Deuxième',
	txtRepeatCustomMonthThird: 'Troisième',
	txtRepeatCustomMonthFourth: 'Quatrième',
	txtRepeatCustomMonthFifth: 'Cinquième',
	txtRepeatCustomMonthLast: 'Dernier',
	txtRepeatCustomMonthCustom: 'Personnalisé',
	txtRepeatCustomMonthMonth: 'Jour du mois',
	txtRepeatCustomYearLabel1: 'Tous',
	txtRepeatCustomYearLabel2: 'De',

	txtRepeatEnd: 'Fin',
	txtEventCalendar: 'Calendrier',
	txtSelectCalendar: 'Selectonner un calendrier',
	txtAlert: 'Alerte',
	txtAlertNone: 'Vide',
	txtAlertMessage: 'Message',
	txtAlertOnDate: 'À la date',
	txtAlertWeeksBefore: 'Semaines avant',
	txtAlertDaysBefore: 'Jours avant',
	txtAlertHoursBefore: 'Heures avant',
	txtAlertMinutesBefore: 'Minutes avant',
	txtAlertSecondsBefore: 'Secondes avant',
	txtAlertWeeksAfter: 'Semaines après',
	txtAlertDaysAfter: 'Jours après',
	txtAlertHoursAfter: 'Heures après',
	txtAlertMinutesAfter: 'Minutes après',
	txtAlertSecondsAfter: 'Secondes après',

	pholderAfterBeforeVal: 'Valeur',
	pholderAlarmDate: 'Date de l\'alarme',
	pholderAlarmTime: 'Heure de l\'alarme',

	pholderNote: 'Note',

	eventPrevNav: 'Montrer la précédente instance',
	eventNextNav: 'Montrer l\'instance suivante',

	buttonClose: 'Fermer',
	buttonDuplicate: 'Dupliquer',

	txtAllSavedTodo: 'Succès : Tâche enregistrée !',
	txtAllSaved: 'Succès : Évènement enregistré !',

	txtAllDeletedTodo: 'Succès : Tâche effacée !',
	txtAllDeleted: 'Succès : Évènement effacé !',

	txtNotChooseTodo: 'Erreur : il faut choisir un calendrier !',
	txtNotChoose: 'Erreur : il faut choisir un calendrier !',

	txtErrorDates: 'Erreur : La date de début doit précéder la date de fin !',
	txtErrorDatesTodo: 'Erreur : La date de début doit précéder la date de fin !',

	txtErorInputTodo: 'Impossible d\'enregistrer : corrigez les valeurs non valides !',
	txtDateTimeErrorTodo: 'Il faut choisir une date et une heure !',

	txtErorInput: 'Erreur : \'Impossible d\'enregistrer\' : corrigez les valeurs surlignées !',

	txtAlertsH: 'Alertes',
	buttonAlert: 'Vider les Alertes',

	altAddEvent: 'Ajouter un évènement',
	altAddTodo: 'Ajouter une tâche',

	loadingCalendars: 'Chargement des calendriers (%act% sur %total%) ...',
	unloadingCalendars: 'Déchargement des calendriers ...',

	errUnableSaveBeginCalDAV: 'Erreur : \'impossible d\'enregistrer l\'évènement\' : %% !',
	errUnableDeleteBeginCalDAV: 'Erreur : \'impossible d\'effacer l\'évènement\' : %% !',
	CalDAVerrHttp410: 'Évènement non présent sur le serveur',
	errUnableSaveTodoBeginCalDAV: 'Erreur : \'impossible de sauvegarder la tâche\' : %% !',
	errUnableDeleteTodoBeginCalDAV: 'Erreur : \'impossible de supprimer la tâche\' : %% !',
	CalDAVerrTodoHttp410: 'La tâche n\'est plus disponible sur le serveur'
};

localizationCalDAV['hu_HU']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	_default_title_format_month_: 'yyyy MMM',
	_default_title_format_week_: 'yyyy MMM d{ \'–\'[ yyyy][ MMM] d}',
	_default_title_format_day_: 'yyyy MMM d, ddd',
	_default_title_format_table_: 'yyyy MMM, ddd',
	_default_column_format_agenda_: 'ddd, MMM d',

	txtCalendar: 'Naptár',
	txtEnabledCalendars: 'Engedélyezett naptárak',
	txtTodo: 'Feladat',
	txtTodoList: 'Feladat lista',
	txtTodoLists: 'Feladat listák',
	txtEnabledTodoLists: 'Engedélyezett feladat listák',
	txtSubscribed: 'Előfizetések',
	fullCalendarTable: 'táblázat',
	fullCalendarTodayButton: 'ma',
	fullCalendarAllDay: 'eg. napi',
	CalDAVsearch: 'Keresés',
	resourceEnable: 'A forrás minden naptára megjelenítése',
	resourceDisable: 'A forrás minden naptára elrejtése',
	allEnable: 'Minden naptár megjelenítése',
	allDisable: 'Minden naptár elrejtése',
	timezone: 'Időzóna',
	txtTimezonePicker: 'Időzóna:',
	loadingRList: 'Forrás lista betöltése ...',
	renderingE: 'Naptárak megjelenítése ...',
	timezoneChange: 'Időzónaváltás alkalmazása ...',
	customTimezone: 'Egyéni (Helyi idő)',
	customRepeat: 'Egyéb (módosítás nem támogatott)',
	loadPrevMonth: 'Előző hónap betöltése',
	loadNextMonth: 'Következő hónap betöltése',
	repeatBoxButton: 'Ismétlődés',
	repeatBoxContent: 'ismétlődő esemény.',
	repeatBoxQuestion: 'Melyik eseménnyel szeretne dolgozni?',
	allEvsButton: 'Minden eseménnyel',
	allFutureButton: 'Ez és az összes jövőbeli eseménnyel',
	eventOnlyButton: 'Csak ezzel az eseménnyel',
	repeatBoxContentTODO: 'ismétlődő feladat.',
	repeatBoxQuestionTODO: 'Melyik feladattal szeretne dolgozni?',
	allEvsButtonTODO: 'Minden feladattal',
	allFutureButtonTODO: 'Ez és az összes jövőbeli feladattal',
	eventOnlyButtonTODO: 'Csak ezzel a feladattal',
	txtStatus: 'Állapot',
	eventAvailability : 'Elérhetőség',
	eventAvailabilityBusy : 'Elfoglalt',
	eventAvailabilityFree : 'Szabad',
	eventType: 'Adatvédelem',
	eventTypePublic: 'Nyilvános',
	eventTypePrivate: 'Magán',
	eventTypeConfidential: 'Bizalmas',
	txtPriority: 'Prioritás',
	txtPriorityNone: 'Semmilyen',
	txtPriorityLow: 'Alacsony',
	txtPriorityMedium: 'Közepes',
	txtPriorityHigh: 'Magas',
	eventURL : 'URL',
	repeatInterval: 'minden',
	repeatDays: 'nap',
	repeatWeeks: 'hét',
	repeatMonths: 'hónap',
	repeatYears: 'év',
	repeatChangeTxt: 'megváltozott a szerveren!',
	repeatChangeTxtClose: 'Zárja be az űrlapot, és nyissa meg az eseményt újra',
	repeatTodoChangeTxtClose: 'Zárja be az űrlapot, és nyissa meg a feladatot újra',
	calendarLoader: 'Újratöltés ...',
	resizeLoader: 'Átméretezés ...',

	// TODOS
	pholderNameTODO: 'Cím',
	pholderNewTODO: 'Új feladat',
	txtTypeTODO: 'Típus',
	txtTypeTODONone: 'Egyszerű',
	txtTypeTODOStart: 'Kezdet időpontal',
	txtTypeTODODue: 'Határidő időpontal',
	txtTypeTODOBoth: 'Kezdet és határidő időpontal',
	txtDateFromTODO: 'Kezdet',
	txtDateToTODO: 'Határidő',
	txtCompletedOn: 'Befejeződött',

	pholderDateFromTODO: 'Kezdet dátum',
	pholderTimeFromTODO: 'Kezdet időpont',
	pholderDateToTODO: 'Határidő dátum',
	pholderTimeToTODO: 'Határidő időpont',
	pholderCompletedOnDate: 'Dátum',
	pholderCompletedOnTime: 'Időpont',

	txtStatusFiltersHeaderTODO: 'Szűrők',
	txtStatusFiltersFooterTODO: '* befejezett feladatok %date% és később',
	txtStatusNeedsActionTODO: 'Foglalkozni kell vele',
	txtStatusCompletedTODO: 'Befejezve',
	txtStatusInProcessTODO: 'Folyamatban',
	txtStatusCancelledTODO: 'Megszakítva',
	txtPercentCompletedTODO: 'Befejezve',

	txtCalendarTODO: 'Naptár',
	txtSelectCalendarTODO: 'Válassz egy naptárat',
	txtAlertTODO: 'Emlékeztető',
	txtAlertNoneTODO: 'Nincs',
	txtAlertMessageTODO: 'Értesítés',
	txtAlertOnDateTODO: 'Egyéni',
	txtAlertWeeksBeforeTODO: 'Héttel előtte',
	txtAlertDaysBeforeTODO: 'Nappal előtte',
	txtAlertHoursBeforeTODO: 'Órával előtte',
	txtAlertMinutesBeforeTODO: 'Perccel előtte',
	txtAlertSecondsBeforeTODO: 'Másodperccel előtte',
	txtAlertWeeksAfterTODO: 'Héttel után',
	txtAlertDaysAfterTODO: 'Nappal után',
	txtAlertHoursAfterTODO: 'Órával után',
	txtAlertMinutesAfterTODO: 'Perccel után',
	txtAlertSecondsAfterTODO: 'Másodperccel után',

	pholderAfterBeforeValTODO: 'Érték',
	pholderAlarmDateTODO: 'Emlékeztető dátum',
	pholderAlarmTimeTODO: 'Emlékeztető időpont',

	pholderNoteTODO: 'Megjegyzés',
	txtNoteTODO: 'Megjegyzés',

	todoPrevNav: 'Mutasd az előző példányt',
	todoNextNav: 'Mutasd a következő példányt',
	todoUncompletedPrevNav: 'Mutasd az előző befejezetlen példányt',
	todoUncompletedNextNav: 'Mutasd a következő befejezetlen példányt',

	buttonSaveTODO: 'Mentés',
	buttonEditTODO: 'Szerkesztés',
	buttonDuplicateTODO: 'Másolat',
	buttonResetTODO: 'Visszaállítás',
	buttonCloseTODO: 'Bezárás',
	buttonDeleteTODO: 'Törlés',

	// EVENTS
	pholderName: 'Cím',
	pholderNewEvent: 'Új esemény',
	txtLocation: 'Hely',
	pholderLocation: 'Hely',

	txtAllDay: 'Egész napos',
	from: 'Kezdet',
	to: 'Vége',

	pholderDateFrom: 'Kezdet dátum',
	pholderTimeFrom: 'Kezdet időpont',
	pholderDateTo: 'Határidő dátum',
	pholderTimeTo: 'Határidő időpont',

	txtStatusNone: 'Nem meghatározott',
	txtStatusTentative: 'Feltételes',
	txtStatusConfirmed: 'Megerősített',
	txtStatusCancelled: 'Törölt',

	txtRepeat: 'Ismétlés',
	txtNoRepeat: 'Nem ismétlődik',
	txtRepeatDay: 'Naponta',
	txtRepeatWeek: 'Hetente',
	txtRepeatWeekend: 'Minden hétköznap',
	txtRepeatMonth: 'Havonta',
	txtRepeatTwoWeek: 'Kéthetente',
	txtRepeatYear: 'Évente',
	txtRepeatCustomWeek: 'Egyéni hetente',
	txtRepeatCustomMonth: 'Egyéni havonta',
	txtRepeatCustomYear: 'Egyéni évente',
	txtRepeatWork: 'Minden munkanapon',
	txtRepeatOnDate: 'Egyéni',
	txtRepeatAfter: 'Ismétlődés után',
	txtRepeatNever: 'Soha',
	pholderUntilDate: 'Dátum-ig',
	pholderRepeatCount: 'Ismétlésszám',
	txtRepeatCustomWeekLabel: '/',
	txtRepeatCustomMonthLabel: '/',
	txtRepeatCustomMonthEvery: 'Minden',
	txtRepeatCustomMonthFirst: 'Első',
	txtRepeatCustomMonthSecond: 'Második',
	txtRepeatCustomMonthThird: 'Harmadik',
	txtRepeatCustomMonthFourth: 'Negyedik',
	txtRepeatCustomMonthFifth: 'Ötodik',
	txtRepeatCustomMonthLast: 'Utolsó',
	txtRepeatCustomMonthCustom: 'Egyéni',
	txtRepeatCustomMonthMonth: 'Nap a hónapban',
	txtRepeatCustomYearLabel1: 'minden',
	txtRepeatCustomYearLabel2: '/',
	txtRepeatEnd: 'vége',

	txtEventCalendar: 'Naptár',
	txtSelectCalendar: 'Válassz egy naptárat',
	txtAlert: 'Emlékeztető',
	txtAlertNone: 'Nincs',
	txtAlertMessage: 'Értesítés',
	txtAlertOnDate: 'Egyéni',
	txtAlertWeeksBefore: 'Héttel előtte',
	txtAlertDaysBefore: 'Nappal előtte',
	txtAlertHoursBefore: 'Órával előtte',
	txtAlertMinutesBefore: 'Perccel előtte',
	txtAlertSecondsBefore: 'Másodperccel előtte',
	txtAlertWeeksAfter: 'Héttel után',
	txtAlertDaysAfter: 'Nappal után',
	txtAlertHoursAfter: 'Órával után',
	txtAlertMinutesAfter: 'Perccel után',
	txtAlertSecondsAfter: 'Másodperccel után',

	pholderAfterBeforeVal: 'Érték',
	pholderAlarmDate: 'Emlékeztető dátum',
	pholderAlarmTime: 'Emlékeztető időpont',

	pholderNote: 'Megjegyzés',

	eventPrevNav: 'Mutasd az előző példányt',
	eventNextNav: 'Mutasd a következő befejezetlen példányt',

	buttonClose: 'Bezárás',
	buttonDuplicate: 'Másolat',

	txtAllSavedTodo: 'A feladat sikeresen elmentve!',
	txtAllSaved: 'Az esemény sikeresen elmentve!',

	txtAllDeletedTodo: 'A feladat sikeresen törölve!',
	txtAllDeleted: 'Az esemény sikeresen törölve!',

	txtNotChooseTodo: 'Hiba: naptárat kell választani!',
	txtNotChoose: 'Hiba: naptárat kell választani!',

	txtErrorDates: 'Hiba: a kezdési dátumnak korábbinak kell lennie a befejezési dátumnál!',
	txtErrorDatesTodo: 'Hiba: a kezdési dátumnak korábbinak kell lennie a befejezési dátumnál!',

	txtErorInputTodo: 'Hiba: javítsa ki a kijelölt érvénytelen értékeket!',
	txtDateTimeErrorTodo: 'Hiba: ki kell választani a dátumot és az időt!',

	txtErorInput: 'Hiba: javítsa ki a kijelölt érvénytelen értékeket!',

	txtAlertsH: 'Emlékeztetők',
	buttonAlert: 'Emlékeztetők eltávolítása',

	altAddEvent: 'Új esemény',
	altAddTodo: 'Új feladat',

	loadingCalendars: 'Naptárak betöltése (%act%/%total%) ...',
	unloadingCalendars: 'Naptárak eltávolítása ...', // better translation?

	errUnableSaveBeginCalDAV: 'Hiba: \'nem sikerült az esemény elmentése\': %%!',
	errUnableDeleteBeginCalDAV: 'Hiba: \'nem sikerült az esemény törlése\': %%!',
	CalDAVerrHttp410: 'az esemény már nem elérhető a szerveren',
	errUnableSaveTodoBeginCalDAV: 'Hiba: \'nem sikerült a feladat elmentése\': %%!',
	errUnableDeleteTodoBeginCalDAV: 'Hiba: \'nem sikerült a feladat törlése\': %%!',
	CalDAVerrTodoHttp410: 'a feladat már nem elérhető a szerveren'
};

localizationCalDAV['it_IT']=	/* thanks Luca Ferrario */
{
	_default_title_format_month_: 'MMM yyyy',
	_default_title_format_week_: 'd[ MMM][ yyyy]{ \'–\' d MMM yyyy}',
	_default_title_format_day_: 'ddd, d MMM yyyy',
	_default_title_format_table_: 'ddd, MMM yyyy',
	_default_column_format_agenda_: 'ddd, d MMM',

	txtCalendar: 'Calendario',
	txtEnabledCalendars: 'Calendari abilitati',
	txtTodo: 'Attività',
	txtTodoList: 'Attività',
	txtTodoLists: 'Liste',
	txtEnabledTodoLists: 'Attività abilitate',
	txtSubscribed: 'Iscrizioni',
	fullCalendarTable: 'tabella',
	fullCalendarTodayButton: 'oggi',
	fullCalendarAllDay: 'tutto il giorno',
	CalDAVsearch: 'Cerca',
	resourceEnable: 'Abilita tutti i calendari in questa risorsa',
	resourceDisable: 'Disabilita tutti i calendari in questa risorsa',
	allEnable: 'Abilita tutti i calendari',
	allDisable: 'Disabilita tutti i calendari',
	timezone: 'Fuso orario',
	txtTimezonePicker: 'Fuso orario:',
	loadingRList: 'Caricamento delle risorse in corso ...',
	renderingE: 'Elaborazione dei calendari in corso ...',
	timezoneChange: 'Applicazione nuovo fuso orario ...',
	customTimezone: 'Personalizzato (Ora Locale)',
	customRepeat: 'Altro (modifica non supportata)',
	loadPrevMonth: 'Carica mese precedente',
	loadNextMonth: 'Carica mese successivo',
	repeatBoxButton: 'Ripeti',
	repeatBoxContent: 'è un evento con ripetizione.',
	repeatBoxQuestion: 'Su quali eventi desideri lavorare?',
	allEvsButton: 'Tutti gli eventi',
	allFutureButton: 'Questo e tutti gli eventi futuri',
	eventOnlyButton: 'Soltanto questo evento',
	repeatBoxContentTODO: 'è un\'attività ripetuta.',
	repeatBoxQuestionTODO: 'Su quali attività vorresti lavorare?',
	allEvsButtonTODO: 'Tutte le attività',
	allFutureButtonTODO: 'Questa e tutte le future attività',
	eventOnlyButtonTODO: 'Soltanto questa attività',
	txtStatus: 'Stato',
	eventAvailability : 'Disponibilità',
	eventAvailabilityBusy : 'Occupato',
	eventAvailabilityFree : 'Libero',
	eventType: 'Privacy',
	eventTypePublic: 'Pubblico',
	eventTypePrivate: 'Privato',
	eventTypeConfidential: 'Confidenziale',
	txtPriority: 'Priorità',
	txtPriorityNone: 'Nessuna',
	txtPriorityLow: 'Bassa',
	txtPriorityMedium: 'Media',
	txtPriorityHigh: 'Alta',
	eventURL : 'URL',
	repeatInterval: 'Tutti',
	repeatDays: 'giorni',
	repeatWeeks: 'settimane',
	repeatMonths: 'mesi',
	repeatYears: 'anni',
	repeatChangeTxt: 'è stato modificato sul server!',
	repeatChangeTxtClose: 'Chiudi il form e apri nuovamente l\'evento',
	repeatTodoChangeTxtClose: 'Chiudi e riapri l\'attività',
	calendarLoader: 'Aggiornamento ...',
	resizeLoader: 'Ridimensionamento ...',

	// TODOS
	pholderNameTODO: 'Nome',
	pholderNewTODO: 'Nuova Attività',
	txtTypeTODO: 'Tipo',
	txtTypeTODONone: 'Semplice',
	txtTypeTODOStart: 'Con orario d\'inizio',
	txtTypeTODODue: 'Con orario di termine',
	txtTypeTODOBoth: 'Con orari di inizio e termine',
	txtDateFromTODO: 'Da',
	txtDateToTODO: 'A',
	txtCompletedOn: 'Completato il',

	pholderDateFromTODO: 'Dal giorno',
	pholderTimeFromTODO: 'Dall ore',
	pholderDateToTODO: 'Al giorno',
	pholderTimeToTODO: 'Alle ore',
	pholderCompletedOnDate: 'Data',
	pholderCompletedOnTime: 'Ora',

	txtStatusFiltersHeaderTODO: 'Filtri',
	txtStatusFiltersFooterTODO: '* completato dal giorno %date%',
	txtStatusNeedsActionTODO: 'Azione richiesta',
	txtStatusCompletedTODO: 'Completato',
	txtStatusInProcessTODO: 'In corso',
	txtStatusCancelledTODO: 'Annullato',
	txtPercentCompletedTODO: 'Completato',

	txtCalendarTODO: 'Calendario',
	txtSelectCalendarTODO: 'Seleziona un calendario',
	txtAlertTODO: 'Avviso',
	txtAlertNoneTODO: 'Nessuno',
	txtAlertMessageTODO: 'Messaggio',
	txtAlertOnDateTODO: 'Il giorno',
	txtAlertWeeksBeforeTODO: 'Settimane prima',
	txtAlertDaysBeforeTODO: 'Giorni prima',
	txtAlertHoursBeforeTODO: 'Ore prima',
	txtAlertMinutesBeforeTODO: 'Minuti prima',
	txtAlertSecondsBeforeTODO: 'Secondi prima',
	txtAlertWeeksAfterTODO: 'Settimane dopo',
	txtAlertDaysAfterTODO: 'Giorni dopo',
	txtAlertHoursAfterTODO: 'Ore dopo',
	txtAlertMinutesAfterTODO: 'Minuti dopo',
	txtAlertSecondsAfterTODO: 'Secondi dopo',

	pholderAfterBeforeValTODO: 'Valore',
	pholderAlarmDateTODO: 'Data sveglia',
	pholderAlarmTimeTODO: 'Orario sveglia',

	pholderNoteTODO: 'Nota',
	txtNoteTODO: 'Nota',

	todoPrevNav: 'Vai all\'attività precedente',
	todoNextNav: 'Vai all\'attività successiva',
	todoUncompletedPrevNav: 'Vai all\'attività non completata precedente',
	todoUncompletedNextNav: 'Vai all\'attività non completata successiva',

	buttonSaveTODO: 'Salva',
	buttonEditTODO: 'Modifica',
	buttonDuplicateTODO: 'Duplica',
	buttonResetTODO: 'Annulla',
	buttonCloseTODO: 'Chiudi',
	buttonDeleteTODO: 'Elimina',

	// EVENTS
	pholderName: 'Nome',
	pholderNewEvent: 'Nuovo Evento',
	txtLocation: 'Luogo',
	pholderLocation: 'Luogo',

	txtAllDay: 'Tutto il giorno',
	from: 'Da',
	to: 'A',

	pholderDateFrom: 'Dal giorno',
	pholderTimeFrom: 'Dalle ore',
	pholderDateTo: 'Al giorno',
	pholderTimeTo: 'Alle ore',

	txtStatusNone: 'Non specificato',
	txtStatusTentative: 'Provvisorio',
	txtStatusConfirmed: 'Confermato',
	txtStatusCancelled: 'Annullato',

	txtRepeat: 'Ripeti',
	txtNoRepeat: 'Non ripetere',
	txtRepeatDay: 'Quotidianamente',
	txtRepeatWeek: 'Settimanalmente',
	txtRepeatWeekend: 'Ogni weekend',
	txtRepeatMonth: 'Mensilmente',
	txtRepeatTwoWeek: 'Bi-settimanalmente',
	txtRepeatYear: 'Annualmente',
	txtRepeatCustomWeek: 'Settimanalmente personalizzato',
	txtRepeatCustomMonth: 'Mensilmente personalizzato',
	txtRepeatCustomYear: 'Annualmente personalizzato',
	txtRepeatWork: 'Tutti i giorni lavorativi',
	txtRepeatOnDate: 'Il giorno',
	txtRepeatAfter: 'Ripetizioni',
	txtRepeatNever: 'Mai',
	pholderUntilDate: 'Fino alla data',
	pholderRepeatCount: 'Numero ripetizioni',
	txtRepeatCustomWeekLabel: 'Il',
	txtRepeatCustomMonthLabel: 'I giorni',
	txtRepeatCustomMonthEvery: 'Ogni',
	txtRepeatCustomMonthFirst: 'Primo',
	txtRepeatCustomMonthSecond: 'Secondo',
	txtRepeatCustomMonthThird: 'Terzo',
	txtRepeatCustomMonthFourth: 'Quarto',
	txtRepeatCustomMonthFifth: 'Quinto',
	txtRepeatCustomMonthLast: 'Ultimo',
	txtRepeatCustomMonthCustom: 'Personalizzato',
	txtRepeatCustomMonthMonth: 'Giorno del mese',
	txtRepeatCustomYearLabel1: 'Ogni',
	txtRepeatCustomYearLabel2: 'Di',

	txtRepeatEnd: 'Fine',
	txtEventCalendar: 'Calendario',
	txtSelectCalendar: 'Seleziona un calendario',
	txtAlert: 'Avviso',
	txtAlertNone: 'Nessuno',
	txtAlertMessage: 'Messaggio',
	txtAlertOnDate: 'Il giorno',
	txtAlertWeeksBefore: 'Settimane prima',
	txtAlertDaysBefore: 'Giorni prima',
	txtAlertHoursBefore: 'Ore prima',
	txtAlertMinutesBefore: 'Minuti prima',
	txtAlertSecondsBefore: 'Secondi prima',
	txtAlertWeeksAfter: 'Settimane dopo',
	txtAlertDaysAfter: 'Giorni dopo',
	txtAlertHoursAfter: 'Ore dopo',
	txtAlertMinutesAfter: 'Minuti dopo',
	txtAlertSecondsAfter: 'Secondi dopo',

	pholderAfterBeforeVal: 'Valore',
	pholderAlarmDate: 'Data sveglia',
	pholderAlarmTime: 'Orario sveglia',

	pholderNote: 'Nota',

	eventPrevNav: 'Vai all\'evento precedente',
	eventNextNav: 'Vai all\'evento successivo',

	buttonClose: 'Chiudi',
	buttonDuplicate: 'Duplica',

	txtAllSavedTodo: 'Successo: Attività Salvata!',
	txtAllSaved: 'Successo: Evento Salvato!',

	txtAllDeletedTodo: 'Successo: Attività Eliminata!',
	txtAllDeleted: 'Successo: Evento Eliminato!',

	txtNotChooseTodo: 'Errore: è necessario selezionare un calendario!',
	txtNotChoose: 'Errore: è necessario selezionare un calendario!',

	txtErrorDates: 'Errore: la data di inizio deve essere antecedente alla data di fine!',
	txtErrorDatesTodo: 'Errore: la data di inizio deve essere antecedente alla data di fine!',

	txtErorInputTodo: 'Impossibile salvare: correggere i valori non validi!',
	txtDateTimeErrorTodo: 'E\' necessario selezionare data e ora',

	txtErorInput: 'Errore: \'impossibile salvare\': correggere i valori non validi evidenziati!',

	txtAlertsH: 'Avvisi',
	buttonAlert: 'Cancella avvisi',

	altAddEvent: 'Aggiungi Evento',
	altAddTodo: 'Aggiungi Attività',

	loadingCalendars: 'Caricamento calendari in corso (%act% di %total%) ...',
	unloadingCalendars: 'Chiusura calendari...',

	errUnableSaveBeginCalDAV: 'Errore: \'impossibile salvare l\'evento\': %%!',
	errUnableDeleteBeginCalDAV: 'Error: \'impossibile eliminare l\'evento\': %%!',
	CalDAVerrHttp410: 'L\'evento non risulta più disponibile sul server',
	errUnableSaveTodoBeginCalDAV: 'Errore: \'impossibile salvare l\'attività\': %%!',
	errUnableDeleteTodoBeginCalDAV: 'Errore: \'impossibile eliminare l\'attività\': %%!',
	CalDAVerrTodoHttp410: 'L\'attività non risulta più disponibile sul server'
};

localizationCalDAV['ja_JP']=	/* Muimu Nakayama */
{
	_default_title_format_month_: 'yyyy年 MMM',
	_default_title_format_week_: 'yyyy年 MMM d日{ \'–\'[ yyyy年][ MMM] d日}',
	_default_title_format_day_: 'yyyy年 MMM d日（dddd）',
	_default_title_format_table_: 'yyyy年 MMM, dddd',
	_default_column_format_agenda_: 'MMM d日（ddd）',

	txtCalendar: 'カレンダー',
	txtEnabledCalendars: '有効なカレンダー',
	txtTodo: 'ToDo',
	txtTodoList: 'ToDoリスト',
	txtTodoLists: 'ToDoリスト',
	txtEnabledTodoLists: '有効なToDoリスト',
	txtSubscribed: '購読',
	fullCalendarTable: '表',
	fullCalendarTodayButton: '今日',
	fullCalendarAllDay: '終日',
	CalDAVsearch: '検索',
	resourceEnable: 'このリソースの全てのカレンダーを有効にする',
	resourceDisable: 'このリソースの全てのカレンダーを無効にする',
	allEnable: '全てのカレンダーを有効にする',
	allDisable: '全てのカレンダーを無効にする',
	timezone: 'タイムゾーン',
	txtTimezonePicker: 'タイムゾーン:',
	loadingRList: 'リソースのリストを読み込み中 ...',
	renderingE: 'カレンダーを表示中 ...',
	timezoneChange: 'タイムゾーンの変更を適用中 ...',
	customTimezone: 'カスタム (ローカルタイム)',
	customRepeat: 'その他（修正はサポートされません）',
	loadPrevMonth: '前月を読み込み',
	loadNextMonth: '次月を読み込み',
	repeatBoxButton: '繰り返し',
	repeatBoxContent: 'は繰り返しの予定です。',
	repeatBoxQuestion: 'どのイベントを処理しますか?',
	allEvsButton: '全てのイベント',
	allFutureButton: 'このイベントと今後の全てのイベント',
	eventOnlyButton: 'このイベントのみ',
	repeatBoxContentTODO: 'は繰り返しのToDoです。',
	repeatBoxQuestionTODO: 'どのToDoを処理しますか?',
	allEvsButtonTODO: 'すべてのToDo',
	allFutureButtonTODO: 'このToDoと今後の全てのToDo',
	eventOnlyButtonTODO: 'このToDoのみ',
	txtStatus: '状態',
	eventAvailability : '空き状況',
	eventAvailabilityBusy : '予定あり',
	eventAvailabilityFree : '空き',
	eventType: 'プライバシー',
	eventTypePublic: '公開',
	eventTypePrivate: '非公開',
	eventTypeConfidential: '限定公開',
	txtPriority: '優先度',
	txtPriorityNone: 'なし',
	txtPriorityLow: '低',
	txtPriorityMedium: '中',
	txtPriorityHigh: '高',
	eventURL : 'URL',
	repeatInterval: '間隔',
	repeatDays: '日毎',
	repeatWeeks: '週毎',
	repeatMonths: '月毎',
	repeatYears: '年毎',
	repeatChangeTxt: 'はサーバ上で変更されました!',
	repeatChangeTxtClose: 'フォームを閉じて，イベントを開き直してください',
	repeatTodoChangeTxtClose: 'フォームを閉じて，ToDoを開き直してください',
	calendarLoader: '再読み込み中 ...',
	resizeLoader: 'サイズ変更中 ...',

	// TODOS
	pholderNameTODO: '名前',
	pholderNewTODO: '新しいToDo',
	txtTypeTODO: '種類',
	txtTypeTODONone: 'なし',
	txtTypeTODOStart: '開始時刻あり',
	txtTypeTODODue: '締切時刻あり',
	txtTypeTODOBoth: '開始・締切時刻あり',
	txtDateFromTODO: '自',
	txtDateToTODO: '至',
	txtCompletedOn: '完了',

	pholderDateFromTODO: '日付 自',
	pholderTimeFromTODO: '時刻 自',
	pholderDateToTODO: '日付 至',
	pholderTimeToTODO: '時刻 至',
	pholderCompletedOnDate: '日付',
	pholderCompletedOnTime: '時刻',

	txtStatusFiltersHeaderTODO: 'フィルター',
	txtStatusFiltersFooterTODO: '* %date% 以降に完了',
	txtStatusNeedsActionTODO: '行動が必要',
	txtStatusCompletedTODO: '完了済',
	txtStatusInProcessTODO: '進行中',
	txtStatusCancelledTODO: 'キャンセル',
	txtPercentCompletedTODO: '完了',

	txtCalendarTODO: 'カレンダー',
	txtSelectCalendarTODO: 'カレンダーを選択',
	txtAlertTODO: '通知',
	txtAlertNoneTODO: 'なし',
	txtAlertMessageTODO: 'メッセージ',
	txtAlertOnDateTODO: '日付指定',
	txtAlertWeeksBeforeTODO: '次の週前',
	txtAlertDaysBeforeTODO: '次の日前',
	txtAlertHoursBeforeTODO: '次の時間前',
	txtAlertMinutesBeforeTODO: '次の分前',
	txtAlertSecondsBeforeTODO: '次の秒前',
	txtAlertWeeksAfterTODO: '次の週後',
	txtAlertDaysAfterTODO: '次の日後',
	txtAlertHoursAfterTODO: '次の時間後',
	txtAlertMinutesAfterTODO: '次の分後',
	txtAlertSecondsAfterTODO: '次の秒後',

	pholderAfterBeforeValTODO: '値',
	pholderAlarmDateTODO: '通知 日付',
	pholderAlarmTimeTODO: '通知 時刻',

	pholderNoteTODO: 'メモ',
	txtNoteTODO: 'メモ',

	todoPrevNav: '１つ前を表示',
	todoNextNav: '１つ後を表示',
	todoUncompletedPrevNav: '１つ前の未完了を表示',
	todoUncompletedNextNav: '１つ後の未完了を表示',

	buttonSaveTODO: '保存',
	buttonEditTODO: '編集',
	buttonDuplicateTODO: '複製',
	buttonResetTODO: '戻す',
	buttonCloseTODO: '閉じる',
	buttonDeleteTODO: '削除',

	// EVENTS
	pholderName: '名前',
	pholderNewEvent: '新しいイベント',
	txtLocation: '場所',
	pholderLocation: '場所',

	txtAllDay: '終日',
	from: '自',
	to: '至',

	pholderDateFrom: '日付 自',
	pholderTimeFrom: '時刻 自',
	pholderDateTo: '日付 至',
	pholderTimeTo: '時刻 至',

	txtStatusNone: '指定なし',
	txtStatusTentative: '仮設定',
	txtStatusConfirmed: '確認済み',
	txtStatusCancelled: 'キャンセル済み',

	txtRepeat: '繰り返し',
	txtNoRepeat: 'なし',
	txtRepeatDay: '毎日',
	txtRepeatWeek: '毎週',
	txtRepeatWeekend: '毎週末',
	txtRepeatMonth: '毎月',
	txtRepeatTwoWeek: '隔週',
	txtRepeatYear: '毎年',
	txtRepeatCustomWeek: 'カスタム 毎週',
	txtRepeatCustomMonth: 'カスタム 毎月',
	txtRepeatCustomYear: 'カスタム 毎年',
	txtRepeatWork: '毎営業日',
	txtRepeatOnDate: '日付指定',
	txtRepeatAfter: '次の回数の後',
	txtRepeatNever: 'なし',
	pholderUntilDate: '日付 迄',
	pholderRepeatCount: '繰り返し数',
	txtRepeatCustomWeekLabel: '曜日',
	txtRepeatCustomMonthLabel: '日付',
	txtRepeatCustomMonthEvery: '毎',
	txtRepeatCustomMonthFirst: '第１',
	txtRepeatCustomMonthSecond: '第２',
	txtRepeatCustomMonthThird: '第３',
	txtRepeatCustomMonthFourth: '第４',
	txtRepeatCustomMonthFifth: '第５',
	txtRepeatCustomMonthLast: '最終',
	txtRepeatCustomMonthCustom: 'カスタム',
	txtRepeatCustomMonthMonth: '日付',
	txtRepeatCustomYearLabel1: '対象日',
	txtRepeatCustomYearLabel2: '対象月',

	txtRepeatEnd: '終了',
	txtEventCalendar: 'カレンダー',
	txtSelectCalendar: 'カレンダーを選択',
	txtAlert: '通知',
	txtAlertNone: 'なし',
	txtAlertMessage: 'メッセージ',
	txtAlertOnDate: '日付指定',
	txtAlertWeeksBefore: '次の週前',
	txtAlertDaysBefore: '次の日前',
	txtAlertHoursBefore: '次の時間前',
	txtAlertMinutesBefore: '次の分前',
	txtAlertSecondsBefore: '次の秒前',
	txtAlertWeeksAfter: '次の週後',
	txtAlertDaysAfter: '次の日後',
	txtAlertHoursAfter: '次の時間後',
	txtAlertMinutesAfter: '次の分後',
	txtAlertSecondsAfter: '次の秒後',

	pholderAfterBeforeVal: '値',
	pholderAlarmDate: '通知 日付',
	pholderAlarmTime: '通知 時刻',

	pholderNote: 'メモ',

	eventPrevNav: '１つ前を表示',
	eventNextNav: '１つ後を表示',

	buttonClose: '閉じる',
	buttonDuplicate: '複製',

	txtAllSavedTodo: '成功: ToDoは保存されました!',
	txtAllSaved: '成功: イベントは保存されました!',

	txtAllDeletedTodo: '成功: ToDoは削除されました!',
	txtAllDeleted: '成功: イベントは削除されました!',

	txtNotChooseTodo: 'エラー: カレンダーを選択する必要があります!',
	txtNotChoose: 'エラー: カレンダーを選択する必要があります!',

	txtErrorDates: 'エラー: 開始日は終了日よりも前でなければなりません!',
	txtErrorDatesTodo: 'エラー: 開始日は終了日よりも前でなければなりません!',

	txtErorInputTodo: '保存できません: 不正な値を直してください!',
	txtDateTimeErrorTodo: '日付と時刻を選択する必要があります!',

	txtErorInput: 'エラー: \'保存できません\': 指定された不正な値を直してください!',

	txtAlertsH: '通知',
	buttonAlert: '通知を消去',

	altAddEvent: 'イベントを追加',
	altAddTodo: 'ToDoを追加',

	loadingCalendars: 'カレンダーを読み込み中 (%total% 個中 %act% 個) ...',
	unloadingCalendars: 'カレンダーの読み込みを解除中 ...',

	errUnableSaveBeginCalDAV: 'エラー: \'イベントを保存できません\': %%!',
	errUnableDeleteBeginCalDAV: 'エラー: \'イベントを削除できません\': %%!',
	CalDAVerrHttp410: 'イベントは既にサーバ上にありません',
	errUnableSaveTodoBeginCalDAV: 'エラー: \'ToDoを保存できません\': %%!',
	errUnableDeleteTodoBeginCalDAV: 'エラー: \'ToDoを削除できません\': %%!',
	CalDAVerrTodoHttp410: 'ToDoは既にサーバ上にありません'
};

localizationCalDAV['nb_NO']=	/* thanks Tore Ørpetveit */
{
	_default_title_format_month_: 'MMM yyyy',
	_default_title_format_week_: 'd[ MMM][ yyyy]{ \'–\' d MMM yyyy}',
	_default_title_format_day_: 'ddd, d MMM yyyy',
	_default_title_format_table_: 'ddd, MMM yyyy',
	_default_column_format_agenda_: 'ddd, d MMM',

	txtCalendar: 'Kalender',
	txtEnabledCalendars: 'Aktive kalendere',
	txtTodo: 'Oppgave',
	txtTodoList: 'Oppgaveliste',
	txtTodoLists: 'Oppgavelister',
	txtEnabledTodoLists: 'Aktive opgavelister',
	txtSubscribed: 'Abonnementer',
	fullCalendarTable: 'tabell',
	fullCalendarTodayButton: 'i dag',
	fullCalendarAllDay: 'hele dagen',
	CalDAVsearch: 'Søk',
	resourceEnable: 'Aktivèr alle kalendere i denne ressursen',
	resourceDisable: 'Deaktivèr alle kalendere i denne ressursen',
	allEnable: 'Aktivèr alle kalendere',
	allDisable: 'Deaktivèr alle kalendere',
	timezone: 'Tidssone',
	txtTimezonePicker: 'Tidssone:',
	loadingRList: 'Henter ressursliste ...',
	renderingE: 'Klargjør kalendere ...',
	timezoneChange: 'Skifter tidssone ...',
	customTimezone: 'Brukerdefinert (Lokal tid)',
	customRepeat: 'Annet (kan ikke redigeres)',
	loadPrevMonth: 'Hent forrige måned',
	loadNextMonth: 'Hent neste måned',
	repeatBoxButton: 'Gjentakelse',
	repeatBoxContent: 'er en begivenhet som gjentas.',
	repeatBoxQuestion: 'Hvilke forekomster vil du åpne?',
	allEvsButton: 'Alle forekomster',
	allFutureButton: 'Denne og alle framtidige forekomster',
	eventOnlyButton: 'Kun denne forekomsten',
	repeatBoxContentTODO: 'er en gjentakende todo.',
	repeatBoxQuestionTODO: 'Hvilke todos vil du behandle',
	allEvsButtonTODO: 'Alle todos',
	allFutureButtonTODO: 'Denne og alle framtidige todos',
	eventOnlyButtonTODO: 'Kun denne todo',
	txtStatus: 'Status',
	eventAvailability : 'Vis som',
	eventAvailabilityBusy : 'Opptatt',
	eventAvailabilityFree : 'Ledig',
	eventType: 'Fortrolighet',
	eventTypePublic: 'Offentlig',
	eventTypePrivate: 'Privat',
	eventTypeConfidential: 'Fortrolig',
	txtPriority: 'Prioritet',
	txtPriorityNone: 'Ingen',
	txtPriorityLow: 'Lav',
	txtPriorityMedium: 'Medium',
	txtPriorityHigh: 'Høy',
	eventURL : 'URL',
	repeatInterval: 'Hver',
	repeatDays: 'dag(er)',
	repeatWeeks: 'uke(r)',
	repeatMonths: 'måned(er)',
	repeatYears: 'år',
	repeatChangeTxt: 'ble endret på serveren!',
	repeatChangeTxtClose: 'Lukk skjemaet og åpne begivenheten på nytt',
	repeatTodoChangeTxtClose: 'Lukk skjemaet og åpne todoen på nytt',
	calendarLoader: 'Leser inn på nytt ...',
	resizeLoader: 'Tilpasser størrelse ...',

	// TODOS
	pholderNameTODO: 'Emne',
	pholderNewTODO: 'Ny oppgave',
	txtTypeTODO: 'Type',
	txtTypeTODONone: 'Enkel',
	txtTypeTODOStart: 'Med startdato',
	txtTypeTODODue: 'Med forfallsdato',
	txtTypeTODOBoth: 'Med både startdato og forfallsdato',
	txtDateFromTODO: 'Fra',
	txtDateToTODO: 'Til',
	txtCompletedOn: 'Ferdig den',

	pholderDateFromTODO: 'Fra dato',
	pholderTimeFromTODO: 'Fra kl.',
	pholderDateToTODO: 'Til dato',
	pholderTimeToTODO: 'Til kl.',
	pholderCompletedOnDate: 'Dato',
	pholderCompletedOnTime: 'Tid',

	txtStatusFiltersHeaderTODO: 'Filtre',
	txtStatusFiltersFooterTODO: '* avsluttet %date% eller senere',
	txtStatusNeedsActionTODO: 'Krever oppfølging',
	txtStatusCompletedTODO: 'Fullført',
	txtStatusInProcessTODO: 'Under utførelse',
	txtStatusCancelledTODO: 'Annullert',
	txtPercentCompletedTODO: 'Fullført',

	txtCalendarTODO: 'Kalender',
	txtSelectCalendarTODO: 'Velg kalender',
	txtAlertTODO: 'Påminnelse',
	txtAlertNoneTODO: 'Ingen',
	txtAlertMessageTODO: 'Beskjed',
	txtAlertOnDateTODO: 'På dagen',
	txtAlertWeeksBeforeTODO: 'Uker før',
	txtAlertDaysBeforeTODO: 'Dager før',
	txtAlertHoursBeforeTODO: 'Timer før',
	txtAlertMinutesBeforeTODO: 'Minutter før',
	txtAlertSecondsBeforeTODO: 'Sekunder før',
	txtAlertWeeksAfterTODO: 'Uker etter',
	txtAlertDaysAfterTODO: 'Dager etter',
	txtAlertHoursAfterTODO: 'Timer etter',
	txtAlertMinutesAfterTODO: 'Minutter etter',
	txtAlertSecondsAfterTODO: 'Sekunder etter',

	pholderAfterBeforeValTODO: 'Verdi',
	pholderAlarmDateTODO: 'Alarmdato',
	pholderAlarmTimeTODO: 'Alarmtid',

	pholderNoteTODO: 'Notat',
	txtNoteTODO: 'Notat',

	todoPrevNav: 'Vis forrige',
	todoNextNav: 'Vis neste',
	todoUncompletedPrevNav: 'Vis forrige ikke avsluttet',
	todoUncompletedNextNav: 'Vis neste ikke avsluttet',

	buttonSaveTODO: 'Lagre',
	buttonEditTODO: 'Rediger',
	buttonDuplicateTODO: 'Kopier',
	buttonResetTODO: 'Nullstill',
	buttonCloseTODO: 'Lukk',
	buttonDeleteTODO: 'Slett',

	// EVENTS
	pholderName: 'Emne',
	pholderNewEvent: 'Ny begivenhet',
	txtLocation: 'Sted',
	pholderLocation: 'Sted',

	txtAllDay: 'Hele dagen',
	from: 'Fra',
	to: 'Til',

	pholderDateFrom: 'Fra dato',
	pholderTimeFrom: 'Fra kl.',
	pholderDateTo: 'Til dato',
	pholderTimeTo: 'Til kl.',

	txtStatusNone: 'Uspesifisert',
	txtStatusTentative: 'Usikker',
	txtStatusConfirmed: 'Bekreftet',
	txtStatusCancelled: 'Annullert',

	txtRepeat: 'Gjentakelse',
	txtNoRepeat: 'Ingen gjentakelse',
	txtRepeatDay: 'Daglig',
	txtRepeatWeek: 'Ugentlig',
	txtRepeatWeekend: 'Hver helg',
	txtRepeatMonth: 'Månedlig',
	txtRepeatTwoWeek: 'Hver annen uke',
	txtRepeatYear: 'Årlig',
	txtRepeatCustomWeek: 'Ukentlig (avansert)',
	txtRepeatCustomMonth: 'Månedlig (avansert)',
	txtRepeatCustomYear: 'Årlig (avansert)',
	txtRepeatWork: 'På virkedager',
	txtRepeatOnDate: 'På dato',
	txtRepeatAfter: 'Forekomster',
	txtRepeatNever: 'Aldri',
	pholderUntilDate: 'Til dato',
	pholderRepeatCount: 'Antall gjentakelser',
	txtRepeatCustomWeekLabel: 'På',
	txtRepeatCustomMonthLabel: 'På dager',
	txtRepeatCustomMonthEvery: 'Hver',
	txtRepeatCustomMonthFirst: 'Første',
	txtRepeatCustomMonthSecond: 'Andre',
	txtRepeatCustomMonthThird: 'Tredje',
	txtRepeatCustomMonthFourth: 'Fjerde',
	txtRepeatCustomMonthFifth: 'Femte',
	txtRepeatCustomMonthLast: 'Siste',
	txtRepeatCustomMonthCustom: 'Valgfri',
	txtRepeatCustomMonthMonth: 'Dag i måneden',
	txtRepeatCustomYearLabel1: 'Hver',
	txtRepeatCustomYearLabel2: 'i',

	txtRepeatEnd: 'Slutt',
	txtEventCalendar: 'Kalender',
	txtSelectCalendar: 'Velg kalender',
	txtAlert: 'Påminnelse',
	txtAlertNone: 'Ingen',
	txtAlertMessage: 'Beskjed',
	txtAlertOnDate: 'På dato',
	txtAlertWeeksBefore: 'Uker før',
	txtAlertDaysBefore: 'Dager før',
	txtAlertHoursBefore: 'Timer før',
	txtAlertMinutesBefore: 'Minutter før',
	txtAlertSecondsBefore: 'Sekunder før',
	txtAlertWeeksAfter: 'Uker etter',
	txtAlertDaysAfter: 'Dager etter',
	txtAlertHoursAfter: 'Timer efter',
	txtAlertMinutesAfter: 'Minutter etter',
	txtAlertSecondsAfter: 'Sekunder etter',

	pholderAfterBeforeVal: 'Verdi',
	pholderAlarmDate: 'Alarmdato',
	pholderAlarmTime: 'Alarmtid',

	pholderNote: 'Notat',

	eventPrevNav: 'Vis forrige',
	eventNextNav: 'Vis neste',

	buttonClose: 'Lukk',
	buttonDuplicate: 'Kopier',

	txtAllSavedTodo: 'Oppgave lagret!',
	txtAllSaved: 'Begivenhet lagret!',

	txtAllDeletedTodo: 'Oppgave slettet!',
	txtAllDeleted: 'Begivenhet slettet!',

	txtNotChooseTodo: 'Feil: Velg en kalender!',
	txtNotChoose: 'Feil: Velg en kalender!',

	txtErrorDates: 'Feil: Startdatoen skal komme før sluttdatoen!',
	txtErrorDatesTodo: 'Feil: Startdatoen skal komme før forfallsdatoen!',

	txtErorInputTodo: 'Kunne ikke lagre: korrigèr ugyldige felt!',
	txtDateTimeErrorTodo: 'Dato og tid må velges!',

	txtErorInput: 'Feil: \'kunne ikke lagre\': korrigèr markerede ugyldige felt!',

	txtAlertsH: 'Påminnelser',
	buttonAlert: 'Fjern påminnelser',

	altAddEvent: 'Legg til begivenhet',
	altAddTodo: 'Legg til oppgave',

	loadingCalendars: 'leser inn kalendere (%act% av %total%) ...',
	unloadingCalendars: 'Lagrer kalendere ...',

	errUnableSaveBeginCalDAV: 'Feil: \'kunne ikke lagre begivenheten\': %%!',
	errUnableDeleteBeginCalDAV: 'Feil: \'kunne ikke slette begivenheten\': %%!',
	CalDAVerrHttp410: 'Begivenheten er ikke lenger tilgjengelig på serveren',
	errUnableSaveTodoBeginCalDAV: 'Feil: \'Kunne ikke lagre todo\': %%!',
	errUnableDeleteTodoBeginCalDAV: 'Feil: \'Kunne ikke slette todo\': %%!',
	CalDAVerrTodoHttp410: 'Todo er ikke lenger tilgjengelig på serveren'
};

localizationCalDAV['nl_NL']=	/* thanks Johan Vromans */
{
	_default_title_format_month_: 'MMM yyyy',
	_default_title_format_week_: 'd[ MMM][ yyyy]{ \'–\' d MMM yyyy}',
	_default_title_format_day_: 'ddd, d MMM yyyy',
	_default_title_format_table_: 'ddd, MMM yyyy',
	_default_column_format_agenda_: 'ddd, d MMM',

	txtCalendar: 'Agenda',
	txtEnabledCalendars: 'Actieve agenda\'s',
	txtTodo: 'Taak',
	txtTodoList: 'Taaklijst',
	txtTodoLists: 'Taaklijsten',
	txtEnabledTodoLists: 'Actieve taaklijsten',
	txtSubscribed: 'Andere bronnen',
	fullCalendarTable: 'tabel',
	fullCalendarTodayButton: 'vandaag',
	fullCalendarAllDay: 'dag-omvattend',
	CalDAVsearch: 'Zoeken',
	resourceEnable: 'Alle agenda’s van deze bron aktiveren',
	resourceDisable: 'Alle agenda’s van deze bron deaktiveren',
	allEnable: 'Alle agenda’s aktiveren',
	allDisable: 'Alle agenda’s deaktiveren',
	timezone: 'Tijdzone',
	txtTimezonePicker: 'Tijdzone:',
	loadingRList: 'Agenda\'s opmaken ...',
	renderingE: 'Kalenders opmaken ...',
	timezoneChange: 'Tijdzonewijziging uitvoeren ...',
	customTimezone: 'Speciaal (Plaatselijke tijd)',
	customRepeat: 'Anders (kan niet worden gewijzigd)',
	loadPrevMonth: 'Vorige maand',
	loadNextMonth: 'Volgende maand',
	repeatBoxButton: 'Herhaling',
	repeatBoxContent: 'is een herhalende afspraak.',
	repeatBoxQuestion: 'Welke afspraken wilt u bewerken?',
	allEvsButton: 'Alle afspraken',
	allFutureButton: 'Deze en alle volgende afspraken',
	eventOnlyButton: 'Alleen deze afspraak',
	repeatBoxContentTODO: 'is een herhalende taak.',
	repeatBoxQuestionTODO: 'Welke taken wilt u aanpassen?',
	allEvsButtonTODO: 'Alle taken',
	allFutureButtonTODO: 'Deze en toekomstige taken',
	eventOnlyButtonTODO: 'Alleen deze taak',
	txtStatus: 'Status',
	eventAvailability : 'Beschikbaarheid',
	eventAvailabilityBusy : 'Bezet',
	eventAvailabilityFree : 'Vrij',
	eventType: 'Privacy',
	eventTypePublic: 'Openbaar',
	eventTypePrivate: 'Besloten',
	eventTypeConfidential: 'Vertrouwelijk',
	txtPriority: 'Prioriteit',
	txtPriorityNone: 'Geen',
	txtPriorityLow: 'Laag',
	txtPriorityMedium: 'Gemiddeld',
	txtPriorityHigh: 'Hoog',
	eventURL : 'URL',
	repeatInterval: 'Elke',
	repeatDays: 'dagen',
	repeatWeeks: 'weken',
	repeatMonths: 'maanden',
	repeatYears: 'jaar',
	repeatChangeTxt: 'is gewijzigd op de server!',
	repeatChangeTxtClose: 'Sluit dit formulier en open het opnieuw',
	repeatTodoChangeTxtClose: 'Sluit het formulier en heropen de taak',
	calendarLoader: 'Opnieuw laden ...',
	resizeLoader: 'Aanpassen ...',	// ???

	// TODOS
	pholderNameTODO: 'Naam',
	pholderNewTODO: 'Nieuwe taak',
	txtTypeTODO: 'Tijdstippen',
	txtTypeTODONone: 'Geen',
	txtTypeTODOStart: 'Met aanvangstijd',
	txtTypeTODODue: 'Met eindtijd',
	txtTypeTODOBoth: 'Met aanvangs- en eindtijd',
	txtDateFromTODO: 'Vanaf',
	txtDateToTODO: 'Tot',	// totaan? tot en met?
	txtCompletedOn: 'Afgehandeld op',

	pholderDateFromTODO: 'Datum vanaf',
	pholderTimeFromTODO: 'Tijd vanaf',
	pholderDateToTODO: 'Datum tot',	// totaan? tot en met?
	pholderTimeToTODO: 'Tijd tot',	// totaan? tot en met?
	pholderCompletedOnDate: 'Datum',
	pholderCompletedOnTime: 'Tijd',

	txtStatusFiltersHeaderTODO: 'Filters',
	txtStatusFiltersFooterTODO: '* afgehandeld op of na %date%',
	txtStatusNeedsActionTODO: 'Aktie nodig',
	txtStatusCompletedTODO: 'Afgewerkt',
	txtStatusInProcessTODO: 'In behandeling',
	txtStatusCancelledTODO: 'Vervallen',
	txtPercentCompletedTODO: 'Afgewerkt', // ???

	txtCalendarTODO: 'Agenda',
	txtSelectCalendarTODO: 'Kies een agenda',
	txtAlertTODO: 'Herinnering',
	txtAlertNoneTODO: 'Geen',
	txtAlertMessageTODO: 'Boodschap',
	txtAlertOnDateTODO: 'Op datum',
	txtAlertWeeksBeforeTODO: 'Weken tevoren',
	txtAlertDaysBeforeTODO: 'Dagen tevoren',
	txtAlertHoursBeforeTODO: 'Uren tevoren',
	txtAlertMinutesBeforeTODO: 'Minuten tevoren',
	txtAlertSecondsBeforeTODO: 'Seconden tevoren',
	txtAlertWeeksAfterTODO: 'Weken erna',
	txtAlertDaysAfterTODO: 'Dagen erna',
	txtAlertHoursAfterTODO: 'Uren erna',
	txtAlertMinutesAfterTODO: 'Minuten erna',
	txtAlertSecondsAfterTODO: 'Seconden erna',

	pholderAfterBeforeValTODO: 'Waarde',
	pholderAlarmDateTODO: 'Alarmdatum',
	pholderAlarmTimeTODO: 'Alarmtijd',

	pholderNoteTODO: 'Boodschap',
	txtNoteTODO: 'Boodschap',

	todoPrevNav: 'Toon vorige',
	todoNextNav: 'Toon volgende',
	todoUncompletedPrevNav: 'Toon eerstvorige onafgewerkte taak',
	todoUncompletedNextNav: 'Toon eerstvolgende onafgewerkte taak',

	buttonSaveTODO: 'Opslaan',
	buttonEditTODO: 'Wijzigen',
	buttonDuplicateTODO: 'Kopieer',
	buttonResetTODO: 'Herstellen',
	buttonCloseTODO: 'Sluiten',
	buttonDeleteTODO: 'Verwijderen',

	// EVENTS
	pholderName: 'Naam',
	pholderNewEvent: 'Nieuwe afspraak',
	txtLocation: 'Plaats',
	pholderLocation: 'Plaats',

	txtAllDay: 'Dag-omvattend',
	from: 'Vanaf',
	to: 'Tot',		// totaan??? tot en met???

	pholderDateFrom: 'Datum vanaf',
	pholderTimeFrom: 'Tijd vanaf',
	pholderDateTo: 'Datum tot',	// totaan??? tot en met???
	pholderTimeTo: 'Tijd tot',	// totaan??? tot en met???

	txtStatusNone: 'Onbekend',
	txtStatusTentative: 'Onbevestigd',
	txtStatusConfirmed: 'Definitief',
	txtStatusCancelled: 'Vervallen',

	txtRepeat: 'Herhalend',
	txtNoRepeat: 'Eenmalig',
	txtRepeatDay: 'Dagelijks',
	txtRepeatWeek: 'Wekelijks',
	txtRepeatWeekend: 'Elk weekend',
	txtRepeatMonth: 'Maandelijks',
	txtRepeatTwoWeek: 'Tweewekelijks',
	txtRepeatYear: 'Jaarlijks',
	txtRepeatCustomWeek: 'Aangepast wekelijks',
	txtRepeatCustomMonth: 'Aangepast maandelijks',
	txtRepeatCustomYear: 'Aangepast jaarlijks',
	txtRepeatWork: 'Elke werkdag',
	txtRepeatOnDate: 'Op datum',
	txtRepeatAfter: 'Herhalingen',
	txtRepeatNever: 'Nooit',
	pholderUntilDate: 'Datum tot',	// totaan??? tot en met???
	pholderRepeatCount: 'Aantal',
	txtRepeatCustomWeekLabel: 'Op',
	txtRepeatCustomMonthLabel: 'Op dag',
	txtRepeatCustomMonthEvery: 'Elke',
	txtRepeatCustomMonthFirst: 'Eerste',
	txtRepeatCustomMonthSecond: 'Tweede',
	txtRepeatCustomMonthThird: 'Derde',
	txtRepeatCustomMonthFourth: 'Vierde',
	txtRepeatCustomMonthFifth: 'Vijfde',
	txtRepeatCustomMonthLast: 'Laatste',
	txtRepeatCustomMonthCustom: 'Aangepast',
	txtRepeatCustomMonthMonth: 'Dag van de maand',
	txtRepeatCustomYearLabel1: 'Elke',
	txtRepeatCustomYearLabel2: 'Van',

	txtRepeatEnd: 'Einde',
	txtEventCalendar: 'Agenda',
	txtSelectCalendar: 'Kies een agenda',
	txtAlert: 'Boodschap',
	txtAlertNone: 'Geen',
	txtAlertMessage: 'Boodschap',
	txtAlertOnDate: 'Op datum',
	txtAlertWeeksBefore: 'Weken tevoren',
	txtAlertDaysBefore: 'Dagen tevoren',
	txtAlertHoursBefore: 'Uren tevoren',
	txtAlertMinutesBefore: 'Minuten tevoren',
	txtAlertSecondsBefore: 'Seconden tevoren',
	txtAlertWeeksAfter: 'Weken erna',
	txtAlertDaysAfter: 'Dagen erna',
	txtAlertHoursAfter: 'Uren erna',
	txtAlertMinutesAfter: 'Minuten erna',
	txtAlertSecondsAfter: 'Seconden erna',

	pholderAfterBeforeVal: 'Waarde',
	pholderAlarmDate: 'Alarmdatum',
	pholderAlarmTime: 'Alarmtijd',

	pholderNote: 'Boodschap',

	eventPrevNav: 'Toon vorige taak',
	eventNextNav: 'Toon volgende taak',

	buttonClose: 'Sluiten',
	buttonDuplicate: 'Kopieer',

	txtAllSavedTodo: 'De taak is opgeslagen',
	txtAllSaved: 'De afspraak is opgeslagen',

	txtAllDeletedTodo: 'De taak is verwijderd',
	txtAllDeleted: 'De afspraak is verwijderd',

	txtNotChooseTodo: 'Fout: Kies eerst een agenda',
	txtNotChoose: 'Fout: Kies eerst een agenda',

	txtErrorDates: 'Fout: De begindatum mag niet na de einddatum vallen',
	txtErrorDatesTodo: 'Fout: De begindatum mag niet na de einddatum vallen',

	txtErorInputTodo: 'opslaan niet mogelijk, corrigeer eerst de foutieve gegevens',
	txtDateTimeErrorTodo: 'Kies eerst een datum en tijd',

	txtErorInput: 'Fout: opslaan niet mogelijk, corrigeer eerst de aangegeven gegevens',

	txtAlertsH: 'Alerts',
	buttonAlert: 'Alerts opheffen',

	altAddEvent: 'Afspraak aanmaken',
	altAddTodo: 'Taak aanmaken',

	loadingCalendars: 'Agenda\'s worden geladen (%act% van %total%) ...',
	unloadingCalendars: 'Agenda\'s worden ontladen ...',

	errUnableSaveBeginCalDAV: 'Fout: de afspraak kon niet worden opgeslagen: %%',
	errUnableDeleteBeginCalDAV: 'Fout: de afspraak kon niet worden verwijderd: %%',
	CalDAVerrHttp410: 'Deze afspraak is niet langer beschikbaar op de server',
	errUnableSaveTodoBeginCalDAV: 'Fout: de taak kon niet worden opgeslagen: %%!',
	errUnableDeleteTodoBeginCalDAV: 'Fout: de taak kon niet worden verwijderd: %%!',
	CalDAVerrTodoHttp410: 'de taak is niet meer beschikbaar op de server'
};

localizationCalDAV['sk_SK']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	_default_title_format_month_: 'MMM yyyy',
	_default_title_format_week_: 'd[ MMM][ yyyy]{ \'–\' d MMM yyyy}',
	_default_title_format_day_: 'ddd, d MMM yyyy',
	_default_title_format_table_: 'ddd, MMM yyyy',
	_default_column_format_agenda_: 'ddd, d MMM',

	txtCalendar: 'Kalendár',
	txtEnabledCalendars: 'Zapnuté Kalendáre',
	txtTodo: 'Pripomienka',
	txtTodoList: 'Zoznam',
	txtTodoLists: 'Zoznamy Pripomienok',
	txtEnabledTodoLists: 'Zapnuté Zoznamy Pripomienok',
	txtSubscribed: 'Odbery',
	fullCalendarTable: 'tabuľka',
	fullCalendarTodayButton: 'dnes',
	fullCalendarAllDay: 'celý deň',
	CalDAVsearch: 'Hľadať',
	resourceEnable: 'Zobraziť všetky kalendáre v danom prostriedku',
	resourceDisable: 'Schovať všetky kalendáre v danom prostriedku',
	allEnable: 'Zobraziť všetky kalendáre',
	allDisable: 'Schovať všetky kalendáre',
	timezone: 'Časové pásmo',
	txtTimezonePicker: 'Pásmo:',
	loadingRList: 'Načítavanie zoznamu prostriedkov ...',
	renderingE: 'Vykreslovanie kalendárov ...',
	timezoneChange: 'Aplikovanie zmeny časového pásma ...',
	customTimezone: 'Vlastná (Lokálny čas)',
	customRepeat: 'Iné (zmena nie je podporovaná)',
	loadPrevMonth: 'Načítať predchádzajúci mesiac',
	loadNextMonth: 'Načítať nasledujúci mesiac',
	repeatBoxButton: 'Opakovanie',
	repeatBoxContent: 'je opakovacia udalosť.',
	repeatBoxQuestion: 'S ktorými udalosťami chcete pracovať?',
	allEvsButton: 'Všetky udalosti',
	allFutureButton: 'Táto a všetky budúce udalosti',
	eventOnlyButton: 'Iba táto udalosť',
	repeatBoxContentTODO: 'je opakovacia pripomienka.',
	repeatBoxQuestionTODO: 'S ktorými pripomienkami chcete pracovať?',
	allEvsButtonTODO: 'Všetky pripomienky',
	allFutureButtonTODO: 'Táto a všetky budúce pripomienky',
	eventOnlyButtonTODO: 'Iba táto pripomienka',
	txtStatus: 'Stav',
	eventAvailability : 'Dostupnosť',
	eventAvailabilityBusy : 'Zaneprázdnený',
	eventAvailabilityFree : 'Voľný',
	eventType: 'Súkromie',
	eventTypePublic: 'Verejná',
	eventTypePrivate: 'Súkromná',
	eventTypeConfidential: 'Dôverná',
	txtPriority: 'Priority',
	txtPriorityNone: 'Žiadna',
	txtPriorityLow: 'Nízka',
	txtPriorityMedium: 'Stredná',
	txtPriorityHigh: 'Vysoká',
	eventURL : 'URL',
	repeatInterval: 'každých',
	repeatDays: 'dní',
	repeatWeeks: 'týždňov',
	repeatMonths: 'mesiacov',
	repeatYears: 'rokov',
	repeatChangeTxt: 'bol zmenený na serveri!',
	repeatChangeTxtClose: 'Zatvorte formulár a znova otvorte udalosť',
	repeatTodoChangeTxtClose: 'Zatvorte formulár a znova otvorte pripomienku.',
	calendarLoader: 'Znovunačítanie ...',
	resizeLoader: 'Prepočítavanie veľkosti ...',

	// TODOS
	pholderNameTODO: 'Názov',
	pholderNewTODO: 'Nová pripomienka',
	txtTypeTODO: 'Typ',
	txtTypeTODONone: 'Jednoduchá',
	txtTypeTODOStart: 'S časom začiatku',
	txtTypeTODODue: 'S časom konca',
	txtTypeTODOBoth: 'S časmi začiatku aj konca',
	txtDateFromTODO: 'Od',
	txtDateToTODO: 'Do',
	txtCompletedOn: 'Dokončené ku',

	pholderDateFromTODO: 'Deň od',
	pholderTimeFromTODO: 'Čas od',
	pholderDateToTODO: 'Deň do',
	pholderTimeToTODO: 'Čas do',
	pholderCompletedOnDate: 'Deň',
	pholderCompletedOnTime: 'Čas',

	txtStatusFiltersHeaderTODO: 'Filtre',
	txtStatusFiltersFooterTODO: '* dokončené %date% a neskôr',
	txtStatusNeedsActionTODO: 'Potrebuje akciu',
	txtStatusCompletedTODO: 'Dokončená',
	txtStatusInProcessTODO: 'Riešená',
	txtStatusCancelledTODO: 'Zrušená',
	txtPercentCompletedTODO: 'Dokončené',

	txtCalendarTODO: 'Kalendár',
	txtSelectCalendarTODO: 'Vyberte kalendár',
	txtAlertTODO: 'Alarm',
	txtAlertNoneTODO: 'Žiadny',
	txtAlertMessageTODO: 'Správa',
	txtAlertOnDateTODO: 'Na dátum',
	txtAlertWeeksBeforeTODO: 'Týždňov pred',
	txtAlertDaysBeforeTODO: 'Dní pred',
	txtAlertHoursBeforeTODO: 'Hodín pred',
	txtAlertMinutesBeforeTODO: 'Minút pred',
	txtAlertSecondsBeforeTODO: 'Sekúnd',
	txtAlertWeeksAfterTODO: 'Týždňov po',
	txtAlertDaysAfterTODO: 'Dní po',
	txtAlertHoursAfterTODO: 'Hodín po',
	txtAlertMinutesAfterTODO: 'Minút po',
	txtAlertSecondsAfterTODO: 'Sekúnd po',

	pholderAfterBeforeValTODO: 'Hodnota',
	pholderAlarmDateTODO: 'Deň alarmu',
	pholderAlarmTimeTODO: 'Čas alarmu',

	pholderNoteTODO: 'Poznámka',
	txtNoteTODO: 'Poznámka',

	todoPrevNav: 'Zobraziť prechádzajúcu inštanciu',
	todoNextNav: 'Zobraziť nasledujúcu inštanciu',
	todoUncompletedPrevNav: 'Zobraziť prechádzajúcu nedokončenú inštanciu',
	todoUncompletedNextNav: 'Zobraziť nasledujúcu nedokončenú inštanciu',

	buttonSaveTODO: 'Uložiť',
	buttonEditTODO: 'Editovať',
	buttonDuplicateTODO: 'Duplikovať',
	buttonResetTODO: 'Reset',
	buttonCloseTODO: 'Zatvoriť',
	buttonDeleteTODO: 'Vymazať',

	// EVENTS
	pholderName: 'Názov',
	pholderNewEvent: 'Nová udalosť',
	txtLocation: 'Miesto',
	pholderLocation: 'Miesto',

	txtAllDay: 'Celý deň',
	from: 'Od',
	to: 'Do',

	pholderDateFrom: 'Deň od',
	pholderTimeFrom: 'Čas od',
	pholderDateTo: 'Deň do',
	pholderTimeTo: 'Čas do',

	txtStatusNone: 'Nešpecifikovaný',
	txtStatusTentative: 'Predbežný',
	txtStatusConfirmed: 'Potvrdený',
	txtStatusCancelled: 'Zrušený',

	txtRepeat: 'Opakovať',
	txtNoRepeat: 'Neopakovať',
	txtRepeatDay: 'Denne',
	txtRepeatWeek: 'Týždenne',
	txtRepeatWeekend: 'Každý víkend',
	txtRepeatMonth: 'Mesačne',
	txtRepeatTwoWeek: 'Dvojtýždenne',
	txtRepeatYear: 'Ročne',
	txtRepeatCustomWeek: 'Týždenne vlastné',
	txtRepeatCustomMonth: 'Mesačne vlastné',
	txtRepeatCustomYear: 'Ročne vlastné',
	txtRepeatWork: 'Každý pracovný deň',
	txtRepeatOnDate: 'Do dátumu',
	txtRepeatAfter: 'Výskytov',
	txtRepeatNever: 'Nikdy',
	pholderUntilDate: 'Do dňa',
	pholderRepeatCount: 'Počet opakovaní',
	txtRepeatCustomWeekLabel: 'deň',
	txtRepeatCustomMonthLabel: 'v dni',
	txtRepeatCustomMonthEvery: 'Každý',
	txtRepeatCustomMonthFirst: 'Prvý',
	txtRepeatCustomMonthSecond: 'Druhý',
	txtRepeatCustomMonthThird: 'Tretí',
	txtRepeatCustomMonthFourth: 'Štvrtý',
	txtRepeatCustomMonthFifth: 'Piaty',
	txtRepeatCustomMonthLast: 'Posledný',
	txtRepeatCustomMonthCustom: 'Vlastné',
	txtRepeatCustomMonthMonth: 'Deň v mesiaci',
	txtRepeatCustomYearLabel1: 'každý',
	txtRepeatCustomYearLabel2: 'v mesiaci',

	txtRepeatEnd: 'koniec',
	txtEventCalendar: 'Kalendár',
	txtSelectCalendar: 'Vyberte kalendár',
	txtAlert: 'Alarm',
	txtAlertNone: 'Žiadny',
	txtAlertMessage: 'Správa',
	txtAlertOnDate: 'Na dátum',
	txtAlertWeeksBefore: 'Týždňov pred',
	txtAlertDaysBefore: 'Dní pred',
	txtAlertHoursBefore: 'Hodín pred',
	txtAlertMinutesBefore: 'Minút pred',
	txtAlertSecondsBefore: 'Sekúnd',
	txtAlertWeeksAfter: 'Týždňov po',
	txtAlertDaysAfter: 'Dní po',
	txtAlertHoursAfter: 'Hodín po',
	txtAlertMinutesAfter: 'Minút po',
	txtAlertSecondsAfter: 'Sekúnd po',

	pholderAfterBeforeVal: 'Hodnota',
	pholderAlarmDate: 'Deň alarmu',
	pholderAlarmTime: 'Čas alarmu',

	pholderNote: 'Poznámka',

	eventPrevNav: 'Zobraziť prechádzajúcu inštanciu',
	eventNextNav: 'Zobraziť nasledujúcu inštanciu',

	buttonClose: 'Zatvoriť',
	buttonDuplicate: 'Duplikovať',

	txtAllSavedTodo: 'Pripomienka úspešne uložená!',
	txtAllSaved: 'Udalosť úspešne uložená!',

	txtAllDeletedTodo: 'Pripomienka úspešne vymazaná!',
	txtAllDeleted: 'Udalosť úspešne vymazaná!',

	txtNotChooseTodo: 'Chyba: Musíte zvoliť kalendár!',
	txtNotChoose: 'Chyba: Musíte zvoliť kalendár!',

	txtErorInputTodo: 'Chyba: opravte chybné hodnoty!',
	txtDateTimeErrorTodo: 'Chyba: Musíte zvoliť deň a čas!',

	txtErrorDates: 'Chyba: Čas začiatku musí byť pred koncom!',
	txtErrorDatesTodo: 'Chyba: Čas začiatku musí byť pred koncom!',

	txtErorInput: 'Chyba: opravte vyznačené chybné hodnoty!',

	txtAlertsH: 'Alarmy',
	buttonAlert: 'Zmazať alarmy',

	altAddEvent: 'Pridať udalosť',
	altAddTodo: 'Pridať pripomienku',

	loadingCalendars: 'Načítavanie kalendárov (%act% z %total%) ...',
	unloadingCalendars: 'Odčítavanie kalendárov ...',

	errUnableSaveBeginCalDAV: 'Chyba: \'nepodarilo sa uložiť udalosť\': %%!',
	errUnableDeleteBeginCalDAV: 'Chyba: \'nepodarilo sa vymazať udalosť\': %%!',
	CalDAVerrHttp410: 'Udalosť už nie je dostupná na serveri',
	errUnableSaveTodoBeginCalDAV: 'Chyba: \'nepodarilo sa uložiť pripomienku\': %%!',
	errUnableDeleteTodoBeginCalDAV: 'Chyba: \'nepodarilo sa vymazať pripomienku\': %%!',
	CalDAVerrTodoHttp410: 'Pripomienka už nie je dostupná na serveri'
};

localizationCalDAV['tr_TR']=	/* thanks Selcuk Pultar */
{
	_default_title_format_month_: 'MMM yyyy',
	_default_title_format_week_: 'd[ MMM][ yyyy]{ \'–\' d MMM yyyy}',
	_default_title_format_day_: 'ddd, d MMM yyyy',
	_default_title_format_table_: 'ddd, MMM yyyy',
	_default_column_format_agenda_: 'ddd, d MMM',

	txtCalendar: 'Takvimler',
	txtEnabledCalendars: 'Takvimler yüklendi',
	txtTodo: 'Yapılacak',
	txtTodoList: 'Yapılacak Listesi',
	txtTodoLists: 'Yapılacak Listeleri',
	txtEnabledTodoLists: 'Kullanılabilir Yapılacak Listeleri',
	txtSubscribed: 'Abonelikler',
	fullCalendarTable: 'tablo',
	fullCalendarTodayButton: 'bugün',
	fullCalendarAllDay: 'tüm gün',
	CalDAVsearch: 'Ara',
	resourceEnable: 'Bu kaynaktaki tüm takvimleri etkinleştir',
	resourceDisable: 'Bu kaynaktaki tüm takvimleri etkisizleştir',
	allEnable: 'Tüm takvimleri etkinleştir',
	allDisable: 'Tüm takvimleri etkisizleştir',
	timezone: 'Saat dilimi',
	txtTimezonePicker: 'Saat dilimi:',
	loadingRList: 'Kaynak listesi yükleniyor ...',
	renderingE: 'Takvimler oluşturuluyor ...',
	timezoneChange: 'Saat dilimi değişikliği uygulanıyor ...',
	customTimezone: 'Özel (Yerel Saat)',
	customRepeat: 'Diğer (değişiklik desteklenmez)',
	loadPrevMonth: 'Önceki ayı yükle',
	loadNextMonth: 'Sonraki ayı yükle',
	repeatBoxButton: 'Yineleme',
	repeatBoxContent: 'tekrar eden bir etkinlik.',
	repeatBoxQuestion: 'Hangi etkinlikler üzerinde çalışmak istersiniz?',
	allEvsButton: 'Tüm etkinlikler',
	allFutureButton: 'Bu ve tüm gelecek etkinlikler',
	eventOnlyButton: 'Sadece bu etkinlik',
	repeatBoxContentTODO: 'tekrar eden bir yapılacak.',
	repeatBoxQuestionTODO: 'Hangi yapılacaklar üzerinde çalışmak istersiniz?',
	allEvsButtonTODO: 'Tüm yapılacaklar',
	allFutureButtonTODO: 'Bu ve tüm gelecek yapılacak',
	eventOnlyButtonTODO: 'Sadece bu yapılacak',
	txtStatus: 'Durum',
	eventAvailability : 'Müsaitlik',
	eventAvailabilityBusy : 'Meşgul',
	eventAvailabilityFree : 'Serbest',
	eventType: 'Mahremiyet',
	eventTypePublic: 'Halka açık',
	eventTypePrivate: 'Özel',
	eventTypeConfidential: 'Gizli',
	txtPriority: 'Öncelik',
	txtPriorityNone: 'Yok',
	txtPriorityLow: 'Düşük',
	txtPriorityMedium: 'Orta',
	txtPriorityHigh: 'Yüksek',
	eventURL : 'URL',
	repeatInterval: 'her',
	repeatDays: 'günler',
	repeatWeeks: 'haftalar',
	repeatMonths: 'aylar',
	repeatYears: 'yıllar',
	repeatChangeTxt: 'sunucuda değiştirilmiş!',
	repeatChangeTxtClose: 'Formu kapatıp etkinliği yeniden açın',
	repeatTodoChangeTxtClose: 'Formu kapatıp yapılacağı yeniden açın',
	calendarLoader: 'Yeniden yükleniyor ...',
	resizeLoader: 'Yeniden boyutlandırılıyor ...',

	// TODOS
	pholderNameTODO: 'İsim',
	pholderNewTODO: 'Yeni Yapılacak',
	txtTypeTODO: 'Tür',
	txtTypeTODONone: 'Basit',
	txtTypeTODOStart: 'Başlangıç zamanı ile',
	txtTypeTODODue: 'Vadesi dolma zamanı ile',
	txtTypeTODOBoth: 'Hem başlangıç ve hemde vadesi dolma zamanı ile',
	txtDateFromTODO: 'Başlangıç',
	txtDateToTODO: 'Bitiş',
	txtCompletedOn: 'Tamamlandığı tarih',

	pholderDateFromTODO: 'Tarihten',
	pholderTimeFromTODO: 'Saatten',
	pholderDateToTODO: 'Tarihe',
	pholderTimeToTODO: 'Saate',
	pholderCompletedOnDate: 'Tarih',
	pholderCompletedOnTime: 'Saat',

	txtStatusFiltersHeaderTODO: 'Filtreler',
	txtStatusFiltersFooterTODO: '* %date% tarihinde veya daha sonrasında tamamlanmış',
	txtStatusNeedsActionTODO: 'Eylem gerektiriyor',
	txtStatusCompletedTODO: 'Tamamlandı',
	txtStatusInProcessTODO: 'İlerlemekte',
	txtStatusCancelledTODO: 'İptal edildi',
	txtPercentCompletedTODO: 'Tamamlandı',

	txtCalendarTODO: 'Takvim',
	txtSelectCalendarTODO: 'Bir takvim seçin',
	txtAlertTODO: 'Uyarı',
	txtAlertNoneTODO: 'Yok',
	txtAlertMessageTODO: 'Mesaj',
	txtAlertOnDateTODO: 'Tarihte',
	txtAlertWeeksBeforeTODO: 'Hafta önce',
	txtAlertDaysBeforeTODO: 'Gün önce',
	txtAlertHoursBeforeTODO: 'Saat önce',
	txtAlertMinutesBeforeTODO: 'Dakika önce',
	txtAlertSecondsBeforeTODO: 'Saniye önce',
	txtAlertWeeksAfterTODO: 'Hafta sonra',
	txtAlertDaysAfterTODO: 'Gün sonra',
	txtAlertHoursAfterTODO: 'Saat sonra',
	txtAlertMinutesAfterTODO: 'Dakika sonra',
	txtAlertSecondsAfterTODO: 'Saniye sonra',

	pholderAfterBeforeValTODO: 'Değer',
	pholderAlarmDateTODO: 'Alarm tarihi',
	pholderAlarmTimeTODO: 'Alarm saati',

	pholderNoteTODO: 'Not',
	txtNoteTODO: 'Not',

	todoPrevNav: 'Önceki gerçekleşmesini göster',
	todoNextNav: 'Sonraki gerçekleşmesini göster',
	todoUncompletedPrevNav: 'Önceki tamamlanmamış gerçekleşmesini göster',
	todoUncompletedNextNav: 'Sonraki tamamlanmamış gerçekleşmesini göster',

	buttonSaveTODO: 'Kaydet',
	buttonEditTODO: 'Düzenle',
	buttonDuplicateTODO: 'Çift kopya',
	buttonResetTODO: 'Geri döndür',
	buttonCloseTODO: 'Kapat',
	buttonDeleteTODO: 'Sil',

	// EVENTS
	pholderName: 'İsim',
	pholderNewEvent: 'Yeni etkinlik',
	txtLocation: 'Yer',
	pholderLocation: 'Yer',

	txtAllDay: 'Tüm gün',
	from: 'Başlangıç',
	to: 'Bitiş',

	pholderDateFrom: 'Tarihten',
	pholderTimeFrom: 'Saatten',
	pholderDateTo: 'Tarihe',
	pholderTimeTo: 'Saate',

	txtStatusNone: 'Belirtilmemiş',
	txtStatusTentative: 'Olası',
	txtStatusConfirmed: 'Teyid Edilmiş',
	txtStatusCancelled: 'İptal Edilmiş',

	txtRepeat: 'Tekrar et',
	txtNoRepeat: 'Tekrar etme',
	txtRepeatDay: 'Günde bir',
	txtRepeatWeek: 'Haftada bir',
	txtRepeatWeekend: 'Her haftasonu',
	txtRepeatMonth: 'Ayda bir',
	txtRepeatTwoWeek: 'İki haftada bir',
	txtRepeatYear: 'Yılda bir',
	txtRepeatCustomWeek: 'Özel haftada bir',
	txtRepeatCustomMonth: 'Özel ayda bir',
	txtRepeatCustomYear: 'Özel yılda bir',
	txtRepeatWork: 'Her iş günü',
	txtRepeatOnDate: 'Tarihinde',
	txtRepeatAfter: 'Kereden sonra',
	txtRepeatNever: 'Hiç bir zaman',
	pholderUntilDate: 'Tarihine kadar',
	pholderRepeatCount: 'Tekrar sayısı',
	txtRepeatCustomWeekLabel: 'taihinde',
	txtRepeatCustomMonthLabel: 'günlerinde',
	txtRepeatCustomMonthEvery: 'Her',
	txtRepeatCustomMonthFirst: 'İlk',
	txtRepeatCustomMonthSecond: 'İkinci',
	txtRepeatCustomMonthThird: 'Üçüncü',
	txtRepeatCustomMonthFourth: 'Dördüncü',
	txtRepeatCustomMonthFifth: 'Beşinci',
	txtRepeatCustomMonthLast: 'Son',
	txtRepeatCustomMonthCustom: 'Özel',
	txtRepeatCustomMonthMonth: 'Ayın gününde',
	txtRepeatCustomYearLabel1: 'her',
	txtRepeatCustomYearLabel2: 'nin',

	txtRepeatEnd: 'son',
	txtEventCalendar: 'Takvim',
	txtSelectCalendar: 'Bir takvim seçin',
	txtAlert: 'Uyarı',
	txtAlertNone: 'Yok',
	txtAlertMessage: 'Mesaj',
	txtAlertOnDate: 'Tarihinde',
	txtAlertWeeksBefore: 'Hafta önce',
	txtAlertDaysBefore: 'Gün önce',
	txtAlertHoursBefore: 'Saat önce',
	txtAlertMinutesBefore: 'Dakika önce',
	txtAlertSecondsBefore: 'Saniye önce',
	txtAlertWeeksAfter: 'Hafta sonra',
	txtAlertDaysAfter: 'Gün sonra',
	txtAlertHoursAfter: 'Saat sonra',
	txtAlertMinutesAfter: 'Dakika sonra',
	txtAlertSecondsAfter: 'Saniye sonra',

	pholderAfterBeforeVal: 'Değer',
	pholderAlarmDate: 'Alarm tarihi',
	pholderAlarmTime: 'Alarm saati',

	pholderNote: 'Not',

	eventPrevNav: 'Önceki gerçekleşmesini göster',
	eventNextNav: 'Sonraki gerçekleşmesini göster',

	buttonClose: 'Kapat',
	buttonDuplicate: 'Çift kopya',

	txtAllSavedTodo: 'Başarılı: Yapılacak kaydedildi!',
	txtAllSaved: 'Başarılı: Etkinlik kaydedildi!',

	txtAllDeletedTodo: 'Başarılı: Yapılacak silindi!',
	txtAllDeleted: 'Başarılı: Etkinlik silindi!',

	txtNotChooseTodo: 'Hata: Takvim seçmeniz gerek!',
	txtNotChoose: 'Hata: Takvim seçmeniz gerek!',

	txtErrorDates: 'Hata: Başlangıç tarihi bitiş tarihinden önce olmalıdır!',
	txtErrorDatesTodo: 'Hata: Başlangıç tarihi bitiş tarihinden önce olmalıdır!',

	txtErorInputTodo: 'Kaydedilemedi: hatalı değerleri düzeltin!',
	txtDateTimeErrorTodo: 'Taih ve saat seçmeniz gerekiyor!',

	txtErorInput: 'Hata: \'kaydedilemedi\': renklendirilmiş hatalı değerleri düzeltin!',

	txtAlertsH: 'Uyarılar',
	buttonAlert: 'Uyarıları temizle',

	altAddEvent: 'Etkinlik ekle',
	altAddTodo: 'Yapılacak ekle',

	loadingCalendars: 'Takvimler yükleniyor (%total% taneden %act%) ...',
	unloadingCalendars: 'Takvimler kaldırılıyor ...',

	errUnableSaveBeginCalDAV: 'Hata: \'etkinlik kaydedilemedi\': %%!',
	errUnableDeleteBeginCalDAV: 'Hata: \'etkinlik silinemedi\': %%!',
	CalDAVerrHttp410: 'Etkinlik artık sunucuda mevcut değil',
	errUnableSaveTodoBeginCalDAV: 'Hata: \'yapılacak kaydedilemedi\': %%!',
	errUnableDeleteTodoBeginCalDAV: 'Hata: \'yapılacak silinemedi\': %%!',
	CalDAVerrTodoHttp410: 'Yapılacak artık sunucuda mevcut değil'
};

localizationCalDAV['ru_RU']=	/* thanks Александр Симонов */
{
	_default_title_format_month_: 'MMMM yyyy',
	_default_title_format_week_: 'd MMM yyyy{ \'–\' d MMM yyyy}',
	_default_title_format_day_: 'd MMM yyyy, dddd',
	_default_title_format_table_: 'MMM yyyy, ddd',
	_default_column_format_agenda_: 'd MMM, ddd',

	txtCalendar: 'Календарь',
	txtEnabledCalendars: 'Включенные календари',
	txtTodo: 'Задача',
	txtTodoList: 'Список задач',
	txtTodoLists: 'Списки задач',
	txtEnabledTodoLists: 'Включенные списки задач',
	txtSubscribed: 'Подписки',
	fullCalendarTable: 'Таблица',
	fullCalendarTodayButton: 'Сегодня',
	fullCalendarAllDay: 'Весь день',
	CalDAVsearch: 'Поиск',
	resourceEnable: 'Отобразить все календари в этом ресурсе',
	resourceDisable: 'Скрыть все календари в этом ресурсе',
	allEnable: 'Отобразить все календари',
	allDisable: 'Скрыть все календари',
	timezone: 'Врем. зона',
	txtTimezonePicker: 'Вр. зона:',
	loadingRList: 'Загрузка списка ресурсов...',
	renderingE: 'Отображение календарей...',
	timezoneChange: 'Применение временной зоны ...',
	customTimezone: 'Заказная (местное время)',
	customRepeat: 'Другое (без возможности изменения)',
	loadPrevMonth: 'Загрузить предыдущий месяц',
	loadNextMonth: 'Загрузить следующий месяц',
	repeatBoxButton: 'Повторение',
	repeatBoxContent: '- повторяющееся событие.',
	repeatBoxQuestion: 'С какими экземплярами события вы хотите работать?',
	allEvsButton: 'Со всеми',
	allFutureButton: 'С этим и со всеми будущими',
	eventOnlyButton: 'Только с этим',
	repeatBoxContentTODO: '- повторяющаяся задача.',
	repeatBoxQuestionTODO: 'С какими экземплярами задачи вы хотите работать?',
	allEvsButtonTODO: 'Со всеми',
	allFutureButtonTODO: 'С этим и со всеми будущими',
	eventOnlyButtonTODO: 'Только с этим',
	txtStatus: 'Состояние',
	eventAvailability : 'Доступность',
	eventAvailabilityBusy : 'Занят',
	eventAvailabilityFree : 'Свободен',
	eventType: 'Приватность',
	eventTypePublic: 'Публичное',
	eventTypePrivate: 'Приватное',
	eventTypeConfidential: 'Конфиденциальное',
	txtPriority: 'Приоритет',
	txtPriorityNone: 'Нет',
	txtPriorityLow: 'Низкий',
	txtPriorityMedium: 'Средний',
	txtPriorityHigh: 'Высокий',
	eventURL : 'URL',
	repeatInterval: 'каждый(ую)',
	repeatDays: 'день',
	repeatWeeks: 'неделю',
	repeatMonths: 'месяц',
	repeatYears: 'год',
	repeatChangeTxt: 'было изменено на сервере!',
	repeatChangeTxtClose: 'Закройте и откройте событие заново',
	repeatTodoChangeTxtClose: 'Закройте и откройте задачу заново',
	calendarLoader: 'Перезагрузка...',
	resizeLoader: 'Изменение размера...',

	// TODOS
	pholderNameTODO: 'Название',
	pholderNewTODO: 'новая задача',
	txtTypeTODO: 'Тип',
	txtTypeTODONone: 'Простая',
	txtTypeTODOStart: 'С датой/временем начала',
	txtTypeTODODue: 'С датой/временем окончания',
	txtTypeTODOBoth: 'С датой/временем начала и окончания',
	txtDateFromTODO: 'Начало',
	txtDateToTODO: 'Окончание',
	txtCompletedOn: 'Выполнена',

	pholderDateFromTODO: 'Дата начала',
	pholderTimeFromTODO: 'Время начала',
	pholderDateToTODO: 'Дата окончания',
	pholderTimeToTODO: 'Время окончания',
	pholderCompletedOnDate: 'Дата выполнения',
	pholderCompletedOnTime: 'Время выполнения',

	txtStatusFiltersHeaderTODO: 'Отбор по состоянию',
	txtStatusFiltersFooterTODO: '* выполненных %date% или позже',
	txtStatusNeedsActionTODO: 'Новая',
	txtStatusCompletedTODO: 'Выполнена',
	txtStatusInProcessTODO: 'В процессе',
	txtStatusCancelledTODO: 'Отменена',
	txtPercentCompletedTODO: 'Выполнено на',

	txtCalendarTODO: 'Календарь',
	txtSelectCalendarTODO: 'Выберите календарь',
	txtAlertTODO: 'Уведомление',
	txtAlertNoneTODO: 'Нет',
	txtAlertMessageTODO: 'Сообщение',
	txtAlertOnDateTODO: 'По дате',
	txtAlertWeeksBeforeTODO: 'За N недель до',
	txtAlertDaysBeforeTODO: 'За N дней до',
	txtAlertHoursBeforeTODO: 'За N часов до',
	txtAlertMinutesBeforeTODO: 'За N минут до',
	txtAlertSecondsBeforeTODO: 'За N секунд до',
	txtAlertWeeksAfterTODO: 'Через N недель после',
	txtAlertDaysAfterTODO: 'Через N дней после',
	txtAlertHoursAfterTODO: 'Через N часов после',
	txtAlertMinutesAfterTODO: 'Через N минут после',
	txtAlertSecondsAfterTODO: 'Через N секунд после',

	pholderAfterBeforeValTODO: 'Значение',
	pholderAlarmDateTODO: 'Дата уведомления',
	pholderAlarmTimeTODO: 'Время уведомления',

	pholderNoteTODO: 'Примечание',
	txtNoteTODO: 'Примечание',

	todoPrevNav: 'Показать предыдущий экземпляр',
	todoNextNav: 'Показать следующий экземпляр',
	todoUncompletedPrevNav: 'Показать предыдущий невыполненный экземпляр',
	todoUncompletedNextNav: 'Показать следующий невыполненный экземпляр',

	buttonSaveTODO: 'Сохранить',
	buttonEditTODO: 'Изменить',
	buttonDuplicateTODO: 'Дубликат',
	buttonResetTODO: 'Отменить',
	buttonCloseTODO: 'Закрыть',
	buttonDeleteTODO: 'Удалить',

	// EVENTS
	pholderName: 'Название',
	pholderNewEvent: 'Новое событие',
	txtLocation: 'Место',
	pholderLocation: 'Местоположение',

	txtAllDay: 'Весь день',
	from: 'Начало',
	to: 'Конец',

	pholderDateFrom: 'Дата начала',
	pholderTimeFrom: 'Время начала',
	pholderDateTo: 'Дата окончания',
	pholderTimeTo: 'Время окончания',

	txtStatusNone: 'Не указано',
	txtStatusTentative: 'Неизвестно',
	txtStatusConfirmed: 'Подтверждено',
	txtStatusCancelled: 'Отменено',

	txtRepeat: 'Повторять',
	txtNoRepeat: 'Не повторять',
	txtRepeatDay: 'Каждый божий день',
	txtRepeatWeek: 'Каждую неделю',
	txtRepeatWeekend: 'Каждый выходной',
	txtRepeatMonth: 'Раз в месяц',
	txtRepeatTwoWeek: 'Раз в две недели',
	txtRepeatYear: 'Раз в год',
	txtRepeatCustomWeek: 'Раз в неделю (настр.)',
	txtRepeatCustomMonth: 'Раз в месяц (настр.)',
	txtRepeatCustomYear: 'Раз в год (настр.)',
	txtRepeatWork: 'Каждый рабочий день',
	txtRepeatOnDate: 'По дате',
	txtRepeatAfter: 'Через N повторений',
	txtRepeatNever: 'Никогда',
	pholderUntilDate: 'Повторять до',
	pholderRepeatCount: 'Повторять раз',
	txtRepeatCustomWeekLabel: 'в',
	txtRepeatCustomMonthLabel: 'по дням',
	txtRepeatCustomMonthEvery: 'Каждый(ую/ое)',
	txtRepeatCustomMonthFirst: 'Первый(ую/ое)',
	txtRepeatCustomMonthSecond: 'Второй(ую/ое)',
	txtRepeatCustomMonthThird: 'Третий(ью/ье)',
	txtRepeatCustomMonthFourth: 'Четвертый(ую/ое)',
	txtRepeatCustomMonthFifth: 'Пятый(ую/ое)',
	txtRepeatCustomMonthLast: 'Крайний(юю/ее)',
	txtRepeatCustomMonthCustom: 'Указать дни (настр.)',
	txtRepeatCustomMonthMonth: 'День месяца',
	txtRepeatCustomYearLabel1: 'по дням',
	txtRepeatCustomYearLabel2: 'по месяцам',

	txtRepeatEnd: 'и закончить',
	txtEventCalendar: 'Календарь',
	txtSelectCalendar: 'Выберите календарь',
	txtAlert: 'Уведомление',
	txtAlertNone: 'Нет',
	txtAlertMessage: 'Сообщение',
	txtAlertOnDate: 'По дате',
	txtAlertWeeksBefore: 'За N недель до',
	txtAlertDaysBefore: 'За N дней до',
	txtAlertHoursBefore: 'За N часов до',
	txtAlertMinutesBefore: 'За N минут до',
	txtAlertSecondsBefore: 'За N секунд до',
	txtAlertWeeksAfter: 'Через N недель после',
	txtAlertDaysAfter: 'Через N дней после',
	txtAlertHoursAfter: 'Через N часов после',
	txtAlertMinutesAfter: 'Через N мирнут после',
	txtAlertSecondsAfter: 'Через N секунд после',

	pholderAfterBeforeVal: 'Значение',
	pholderAlarmDate: 'Дата уведомления',
	pholderAlarmTime: 'Время уведомления',

	pholderNote: 'Примечание',

	eventPrevNav: 'Показать предыдущий экземпляр',
	eventNextNav: 'Показать следующий экземпляр',

	buttonClose: 'Закрыть',
	buttonDuplicate: 'Дубликат',

	txtAllSavedTodo: 'Задача успешно сохранена!',
	txtAllSaved: 'Событие успешно сохранено!',

	txtAllDeletedTodo: 'Задача успешно удалена!',
	txtAllDeleted: 'Событие успешно удалено!',

	txtNotChooseTodo: 'Ошибка: необходимо выбрать календарь!',
	txtNotChoose: 'Ошибка: необходимо выбрать календарь!',

	txtErrorDates: 'Ошибка: дата начала не может быть позже даты окончания!',
	txtErrorDatesTodo: 'Ошибка: дата начала не может быть позже даты окончания!',

	txtErorInputTodo: 'Исправьте неверные значения!',
	txtDateTimeErrorTodo: 'Укажите дату и время!',

	txtErorInput: 'Ошибка: исправьте подсвеченные неверные значения!',

	txtAlertsH: 'Уведомления',
	buttonAlert: 'Очистить уведомления',

	altAddEvent: 'Добавить событие',
	altAddTodo: 'Добавить задачу',

	loadingCalendars: 'Загрузка календарей (%act% из %total%) ...',
	unloadingCalendars: 'Выгружаю календари ...',

	errUnableSaveBeginCalDAV: 'Ошибка: \'не могу сохранить событие\': %%!',
	errUnableDeleteBeginCalDAV: 'Ошибка: \'не могу удалить событие\': %%!',
	CalDAVerrHttp410: 'Событие более не существует на сервере',
	errUnableSaveTodoBeginCalDAV: 'Ошибка: \'не могу сохранить задачу\': %%!',
	errUnableDeleteTodoBeginCalDAV: 'Ошибка: \'не могу удалить задачу\': %%!',
	CalDAVerrTodoHttp410: 'Задача более не существует на сервере'
};

localizationCalDAV['uk_UA']=	/* Sergey Yakimchuck <yakim@yakim.org.ua> */
{
	_default_title_format_month_: 'MMM yyyy',
	_default_title_format_week_: 'd[ MMM][ yyyy]{ \'–\' d MMM yyyy}',
	_default_title_format_day_: 'ddd, d MMM yyyy',
	_default_title_format_table_: 'ddd, MMM yyyy',
	_default_column_format_agenda_: 'ddd, d MMM',

	txtCalendar: 'Календар',
	txtEnabledCalendars: 'Включені календарі',
	txtTodo: 'Завдання',
	txtTodoList: 'Список завданя',
	txtTodoLists: 'Списки завдань',
	txtEnabledTodoLists: 'Включені списки завдань',
	txtSubscribed: 'Підписка',
	fullCalendarTable: 'таблиця',
	fullCalendarTodayButton: 'сьогодні',
	fullCalendarAllDay: 'всі дні',
	CalDAVsearch: 'Пошук',
	resourceEnable: 'Включити всі календарі на цьому ресурсі',
	resourceDisable: 'Вимкнути всі календарі на цьому ресурсі',
	allEnable: 'Включити всі календарі',
	allDisable: 'Вимкнути всі календарі',
	timezone: 'Часова зона',
	txtTimezonePicker: 'Часова зона:',
	loadingRList: 'Завантаження списку ресурсів ...',
	renderingE: 'Надання календарів ...',
	timezoneChange: 'Прийняття змін часової зони ...',
	customTimezone: 'Налаштований (локальний час)',
	customRepeat: 'Інше (Зміни не підтримуються)',
	loadPrevMonth: 'Завантаження попереднього місяця',
	loadNextMonth: 'Завантаження наступного місяця',
	repeatBoxButton: 'Повторення',
	repeatBoxContent: 'ця подія повторюється.',
	repeatBoxQuestion: 'З якою подією ви бажаєте працювати?',
	allEvsButton: 'Всі події',
	allFutureButton: 'Ця, та всі наступні події',
	eventOnlyButton: 'Лише ця подія',
	repeatBoxContentTODO: 'Завдання що повторюється.',
	repeatBoxQuestionTODO: 'З яким завданням ви бажаєте працювати?',
	allEvsButtonTODO: 'Всі завдання',
	allFutureButtonTODO: 'Це, та всі наступні завдання',
	eventOnlyButtonTODO: 'Лише це завдання',
	txtStatus: 'Статус',
	eventAvailability : 'Доступність',
	eventAvailabilityBusy : 'Зайнятий',
	eventAvailabilityFree : 'Вільний',
	eventType: 'Приватність',
	eventTypePublic: 'Загальнодоступне',
	eventTypePrivate: 'Приватне',
	eventTypeConfidential: 'Конфіденційне',
	txtPriority: 'Приорітет',
	txtPriorityNone: 'Немає',
	txtPriorityLow: 'Низький',
	txtPriorityMedium: 'Середній',
	txtPriorityHigh: 'Високий',
	eventURL : 'URL',
	repeatInterval: 'кожен',
	repeatDays: 'день',
	repeatWeeks: 'тиждень',
	repeatMonths: 'місяць',
	repeatYears: 'рік',
	repeatChangeTxt: 'було змінено на сервері!',
	repeatChangeTxtClose: 'Закрийте форму та відкрийте подію знову',
	repeatTodoChangeTxtClose: 'Закрийте форму та відкрийте завдання знову',
	calendarLoader: 'перезавантаження ...',
	resizeLoader: 'зміна розміру ...',

	// TODOS
	pholderNameTODO: 'Назва',
	pholderNewTODO: 'Нове  завдання',
	txtTypeTODO: 'Тип',
	txtTypeTODONone: 'Просте',
	txtTypeTODOStart: 'Час початку',
	txtTypeTODODue: 'Тривалість',
	txtTypeTODOBoth: 'З часом початку та тривалістю',
	txtDateFromTODO: 'З',
	txtDateToTODO: 'До',
	txtCompletedOn: 'Завершено в',

	pholderDateFromTODO: 'Початкова дата',
	pholderTimeFromTODO: 'Початковий час',
	pholderDateToTODO: 'Кінцева дата',
	pholderTimeToTODO: 'Кінцевий час',
	pholderCompletedOnDate: 'Дата',
	pholderCompletedOnTime: 'Час',

	txtStatusFiltersHeaderTODO: 'Фільтри',
	txtStatusFiltersFooterTODO: '* завершення після чи в  %date%',
	txtStatusNeedsActionTODO: 'Потребує дії',
	txtStatusCompletedTODO: 'Завершено',
	txtStatusInProcessTODO: 'В процесі',
	txtStatusCancelledTODO: 'Скасовано',
	txtPercentCompletedTODO: 'Завершено',

	txtCalendarTODO: 'Календар',
	txtSelectCalendarTODO: 'Оберіть календар',
	txtAlertTODO: 'Попередження',
	txtAlertNoneTODO: 'Нічого',
	txtAlertMessageTODO: 'Повідомлення',
	txtAlertOnDateTODO: 'За дати',
	txtAlertWeeksBeforeTODO: 'За тижнів',
	txtAlertDaysBeforeTODO: 'За днів',
	txtAlertHoursBeforeTODO: 'За годин',
	txtAlertMinutesBeforeTODO: 'За хвилин',
	txtAlertSecondsBeforeTODO: 'За секунд',
	txtAlertWeeksAfterTODO: 'Через тижнів',
	txtAlertDaysAfterTODO: 'Через днів',
	txtAlertHoursAfterTODO: 'Через годин',
	txtAlertMinutesAfterTODO: 'Через хвилин',
	txtAlertSecondsAfterTODO: 'Через секунд',

	pholderAfterBeforeValTODO: 'Значення',
	pholderAlarmDateTODO: 'Дата попередження',
	pholderAlarmTimeTODO: 'Час попередження',

	pholderNoteTODO: 'Примітка',
	txtNoteTODO: 'Примітка',

	todoPrevNav: 'Показати попередній елемент',
	todoNextNav: 'Показати наступний елемент',
	todoUncompletedPrevNav: 'Показати попередній незавершений елемент',
	todoUncompletedNextNav: 'Показати наступний незавершений елемент',

	buttonSaveTODO: 'Зберегти',
	buttonEditTODO: 'Редагувати',
	buttonDuplicateTODO: 'Дублікат',
	buttonResetTODO: 'Скасувати',
	buttonCloseTODO: 'Закрити',
	buttonDeleteTODO: 'Видалити',

	// EVENTS
	pholderName: 'Назва',
	pholderNewEvent: 'Нова подія',
	txtLocation: 'Місцерозташування',
	pholderLocation: 'Місцерозташування',

	txtAllDay: 'Весь день',
	from: 'З',
	to: 'До',

	pholderDateFrom: 'З дати',
	pholderTimeFrom: 'З часу',
	pholderDateTo: 'До дати',
	pholderTimeTo: 'До часу',

	txtStatusNone: 'Не визначено',
	txtStatusTentative: 'Не певно',
	txtStatusConfirmed: 'Підтверджено',
	txtStatusCancelled: 'Скасовано',

	txtRepeat: 'Повторити',
	txtNoRepeat: 'Не повторювати',
	txtRepeatDay: 'Щоденно',
	txtRepeatWeek: 'Щотижня',
	txtRepeatWeekend: 'Кожні вихідні',
	txtRepeatMonth: 'Щомісяця',
	txtRepeatTwoWeek: 'кожних два тижні',
	txtRepeatYear: 'Щорічно',
	txtRepeatCustomWeek: 'Тижнева періодичність',
	txtRepeatCustomMonth: 'Місячна періодичність',
	txtRepeatCustomYear: 'Річна періодичність',
	txtRepeatWork: 'Кожен робочий день',
	txtRepeatOnDate: 'За дати',
	txtRepeatAfter: 'Повторів',
	txtRepeatNever: 'Ніколи',
	pholderUntilDate: 'До дати',
	pholderRepeatCount: 'Кількість повторень',
	txtRepeatCustomWeekLabel: 'в',
	txtRepeatCustomMonthLabel: 'в дні',
	txtRepeatCustomMonthEvery: 'кожен',
	txtRepeatCustomMonthFirst: 'Перший',
	txtRepeatCustomMonthSecond: 'Другий',
	txtRepeatCustomMonthThird: 'Третій',
	txtRepeatCustomMonthFourth: 'Четвертий',
	txtRepeatCustomMonthFifth: 'П\'ятий',
	txtRepeatCustomMonthLast: 'Останній',
	txtRepeatCustomMonthCustom: 'Обрати',
	txtRepeatCustomMonthMonth: 'День місяця',
	txtRepeatCustomYearLabel1: 'кожен',
	txtRepeatCustomYearLabel2: 'з',

	txtRepeatEnd: 'Кінець',
	txtEventCalendar: 'Календар',
	txtSelectCalendar: 'Оберіть календар',
	txtAlert: 'Попередження',
	txtAlertNone: 'Немає',
	txtAlertMessage: 'Повідомлення',
	txtAlertOnDate: 'За дати',
	txtAlertWeeksBefore: 'За тижнів',
	txtAlertDaysBefore: 'За днів',
	txtAlertHoursBefore: 'За годин',
	txtAlertMinutesBefore: 'За хвилин',
	txtAlertSecondsBefore: 'За секунд',
	txtAlertWeeksAfter: 'Через тижнів',
	txtAlertDaysAfter: 'Через днів',
	txtAlertHoursAfter: 'Через днів',
	txtAlertMinutesAfter: 'Через хвилин',
	txtAlertSecondsAfter: 'Через секунд',

	pholderAfterBeforeVal: 'Значення',
	pholderAlarmDate: 'Дата попередження',
	pholderAlarmTime: 'Час попередження',

	pholderNote: 'Примітка',

	eventPrevNav: 'Показати попередній елемент',
	eventNextNav: 'Показати наступний елемент',

	buttonClose: 'Закрити',
	buttonDuplicate: 'Дублікат',

	txtAllSavedTodo: 'Успіх: Завдання збережено!',
	txtAllSaved: 'Успіх: Подію збережено',

	txtAllDeletedTodo: 'Успіх: Завдання видалено!',
	txtAllDeleted: 'Успіх: Подію видалено!',

	txtNotChooseTodo: 'Помилка: Треба обрати календар!',
	txtNotChoose: 'Помилка: Треба обрати календар!',

	txtErrorDates: 'Помилка: Дата початки має передувати даті закінчення!',
	txtErrorDatesTodo: 'Помилка: Дата початки має передувати даті закінчення!',

	txtErorInputTodo: 'Неможливо зберегти: виправіть помилкові значення!',
	txtDateTimeErrorTodo: 'Треба обрати дату та час!',

	txtErorInput: 'Помилка: \'неможливо зберегти\': виправіть підсвічені помилкові значення!',

	txtAlertsH: 'Попередження',
	buttonAlert: 'Очистити попередження',

	altAddEvent: 'Додати подію',
	altAddTodo: 'Додати завдання',

	loadingCalendars: 'Завантаження календарів (%act% з %total%) ...',
	unloadingCalendars: 'Розвантаження календарі ...',

	errUnableSaveBeginCalDAV: 'Помилка: \'неможливо зберегти подію\': %%!',
	errUnableDeleteBeginCalDAV: 'Помилка: \'неможливо видалити подію\': %%!',
	CalDAVerrHttp410: 'Подія більше недоступна на сервері',
	errUnableSaveTodoBeginCalDAV: 'Помилка: \'неможливо видалити завдання\': %%!',
	errUnableDeleteTodoBeginCalDAV: 'Помилка: \'неможливо зберегти завдання\': %%!',
	CalDAVerrTodoHttp410: 'Завдання більше недоступне на сервері'
};

localizationCalDAV['zh_CN']=	/* thanks Fandy */
{
	_default_title_format_month_: 'yyyy年MMM月',
	_default_title_format_week_: 'yyyy年MMM月d日{ \'–\'[ yyyy年][ MMM月]d 日}',
	_default_title_format_day_: 'yyyy年MMM月d日, ddd',
	_default_title_format_table_: 'yyyy年MMM月, ddd',
	_default_column_format_agenda_: 'ddd, MMM月 d日',

	txtCalendar: '日程',
	txtEnabledCalendars: '选择日程表',
	txtTodo: '待办',
	txtTodoList: '待办列表',
	txtTodoLists: '待办列表',
	txtEnabledTodoLists: '可选待办列表',
	txtSubscribed: '订阅',
	fullCalendarTable: '日程表',
	fullCalendarTodayButton: '今天',
	fullCalendarAllDay: '全天',
	CalDAVsearch: '查找',
	resourceEnable: '启用此资源中的所有日历',
	resourceDisable: '关闭此资源中的所有日历',
	allEnable: '启用所有日历',
	allDisable: '关闭所有日历',
	timezone: '时区',
	txtTimezonePicker: '时区:',
	loadingRList: '加载资源列表 ...',
	renderingE: '加载日程 ...',
	timezoneChange: '应用更改时区 ...',
	customTimezone: '自定义 (本地时区)',
	customRepeat: '其它 (不支持修改)',
	loadPrevMonth: '加载上个月',
	loadNextMonth: '加载下个月',
	repeatBoxButton: '重复',
	repeatBoxContent: '重复事件.',
	repeatBoxQuestion: '你将要要处理哪件活动?',
	allEvsButton: '所有事宜',
	allFutureButton: '未来事宜',
	eventOnlyButton: '本事宜',
	repeatBoxContentTODO: '重复待办事件',
	repeatBoxQuestionTODO: '你将要处理哪件待办事情?',
	allEvsButtonTODO: '所有待办',
	allFutureButtonTODO: '目前及以后待办事情',
	eventOnlyButtonTODO: '仅此待办事情',
	txtStatus: '状态',
	eventAvailability : '可用性',
	eventAvailabilityBusy : '忙碌',
	eventAvailabilityFree : '空闲',
	eventType: '私有',
	eventTypePublic: '公开',
	eventTypePrivate: '私有',
	eventTypeConfidential: '机密',
	txtPriority: '优先',
	txtPriorityNone: '无',
	txtPriorityLow: '低',
	txtPriorityMedium: '中',
	txtPriorityHigh: '高',
	eventURL : '链接',
	repeatInterval: '间隔',
	repeatDays: '每日',
	repeatWeeks: '每周',
	repeatMonths: '每月',
	repeatYears: '每年',
	repeatChangeTxt: '在服务器上发生了改变！',
	repeatChangeTxtClose: '关闭窗体，重新打开活动',
	repeatTodoChangeTxtClose: '关闭窗体，重新打开待办',
	calendarLoader: '重新加载中 ...',
	resizeLoader: '调整大小...',

	// TODOS
	pholderNameTODO: '待办事宜',
	pholderNewTODO: '新待办',
	txtTypeTODO: '类型',
	txtTypeTODONone: '简易',
	txtTypeTODOStart: '开始时间',
	txtTypeTODODue: '结束时间',
	txtTypeTODOBoth: '开始时间和结束时间',
	txtDateFromTODO: '从',
	txtDateToTODO: '到',
	txtCompletedOn: '完成',

	pholderDateFromTODO: '开始日期',
	pholderTimeFromTODO: '开始时间',
	pholderDateToTODO: '结束日期',
	pholderTimeToTODO: '结束时间',
	pholderCompletedOnDate: '日期',
	pholderCompletedOnTime: '时间',

	txtStatusFiltersHeaderTODO: '过滤',
	txtStatusFiltersFooterTODO: '* 已完成及 %date%之后待办',
	txtStatusNeedsActionTODO: '待办',
	txtStatusCompletedTODO: '完成',
	txtStatusInProcessTODO: '进行中',
	txtStatusCancelledTODO: '取消',
	txtPercentCompletedTODO: '完成',

	txtCalendarTODO: '日历',
	txtSelectCalendarTODO: '请选择一个日历',
	txtAlertTODO: '提醒',
	txtAlertNoneTODO: '无提醒',
	txtAlertMessageTODO: '消息',
	txtAlertOnDateTODO: '指定日期',
	txtAlertWeeksBeforeTODO: '下一周之前',
	txtAlertDaysBeforeTODO: '第二天前',
	txtAlertHoursBeforeTODO: '下一个小时前',
	txtAlertMinutesBeforeTODO: '下一分钟前',
	txtAlertSecondsBeforeTODO: '下一秒前',
	txtAlertWeeksAfterTODO: '下一周之后 ',
	txtAlertDaysAfterTODO: '下一天后',
	txtAlertHoursAfterTODO: '下一个小时后',
	txtAlertMinutesAfterTODO: '下一分钟后 ',
	txtAlertSecondsAfterTODO: '下一秒后',

	pholderAfterBeforeValTODO: '值',
	pholderAlarmDateTODO: '提醒日期 ',
	pholderAlarmTimeTODO: '提醒时间',

	pholderNoteTODO: '备注',
	txtNoteTODO: '备注',

	todoPrevNav: '显示上一个',
	todoNextNav: '显示下一个',
	todoUncompletedPrevNav: '显示上一个未完成的',
	todoUncompletedNextNav: '显示下一个未完成的',

	buttonSaveTODO: '保存',
	buttonEditTODO: '编辑',
	buttonDuplicateTODO: '复制',
	buttonResetTODO: '撤销',
	buttonCloseTODO: '关闭',
	buttonDeleteTODO: '删除',

	// EVENTS
	pholderName: '名称',
	pholderNewEvent: '新建事件',
	txtLocation: '地点',
	pholderLocation: '地点',

	txtAllDay: '全天否',
	from: '开始时间',
	to: '结束时间',

	pholderDateFrom: '开始日期',
	pholderTimeFrom: '开始时间',
	pholderDateTo: '结束日期',
	pholderTimeTo: '结束时间',

	txtStatusNone: '未指定',
	txtStatusTentative: '暂定',
	txtStatusConfirmed: '确认',
	txtStatusCancelled: '取消',

	txtRepeat: '重复',
	txtNoRepeat: '不重复',
	txtRepeatDay: '每日',
	txtRepeatWeek: '每周',
	txtRepeatWeekend: '每周末',
	txtRepeatMonth: '每月',
	txtRepeatTwoWeek: '双周',
	txtRepeatYear: '每年',
	txtRepeatCustomWeek: '自定义周',
	txtRepeatCustomMonth: '自定义月',
	txtRepeatCustomYear: '自定义年',
	txtRepeatWork: '每个工作日',
	txtRepeatOnDate: '指定日期',
	txtRepeatAfter: '事后',
	txtRepeatNever: '从不',
	pholderUntilDate: '日期为止',
	pholderRepeatCount: '重复数',
	txtRepeatCustomWeekLabel: '星期',
	txtRepeatCustomMonthLabel: '日期',
	txtRepeatCustomMonthEvery: '每',
	txtRepeatCustomMonthFirst: '第一',
	txtRepeatCustomMonthSecond: '第二',
	txtRepeatCustomMonthThird: '第三',
	txtRepeatCustomMonthFourth: '第四',
	txtRepeatCustomMonthFifth: '第五',
	txtRepeatCustomMonthLast: '最终',
	txtRepeatCustomMonthCustom: '定制',
	txtRepeatCustomMonthMonth: '日期',
	txtRepeatCustomYearLabel1: '每',
	txtRepeatCustomYearLabel2: '共',

	txtRepeatEnd: '结束',
	txtEventCalendar: '日程类型',
	txtSelectCalendar: '请选择日程',
	txtAlert: '提醒',
	txtAlertNone: '无提醒',
	txtAlertMessage: '消息',
	txtAlertOnDate: '指定日期',
	txtAlertWeeksBefore: '下一周之前',
	txtAlertDaysBefore: '第二天前',
	txtAlertHoursBefore: '下一个小时前',
	txtAlertMinutesBefore: '下一分钟前',
	txtAlertSecondsBefore: '下一秒前',
	txtAlertWeeksAfter: '下一周之后',
	txtAlertDaysAfter: '下一天后',
	txtAlertHoursAfter: '下一个小时后',
	txtAlertMinutesAfter: '下一分钟后',
	txtAlertSecondsAfter: '下一秒后',

	pholderAfterBeforeVal: '值',
	pholderAlarmDate: '提醒日期',
	pholderAlarmTime: '提醒时间',

	pholderNote: '备注',

	eventPrevNav: '显示上一个',
	eventNextNav: '显示下一个',

	buttonClose: '关闭',
	buttonDuplicate: '复制',

	txtAllSavedTodo: '待办保存成功! ',
	txtAllSaved: '保存成功!',

	txtAllDeletedTodo: '待办删除成功!',
	txtAllDeleted: '删除成功!',

	txtNotChooseTodo: '错误:请先关闭日程!',
	txtNotChoose: '错误:请先选择日程!',

	txtErrorDates: '错误：开始日期必须小于结束日期!',
	txtErrorDatesTodo: '错误：开始日期必须小于结束日期!',

	txtErorInputTodo: '不能保存: 请修改无效的值!',
	txtDateTimeErrorTodo: '请选择日期和时间!',

	txtErorInput: '错误: \'不能保存\': 请修改高亮的值!',

	txtAlertsH: '提醒',
	buttonAlert: '清空提醒',

	altAddEvent: '新建日程',
	altAddTodo: '新建待办',

	loadingCalendars: '日程加载中 (第%act% 个/共%total%个) ...',
	unloadingCalendars: '卸载日程...',

	errUnableSaveBeginCalDAV: '错误: \'活动不能保存\': %%!',
	errUnableDeleteBeginCalDAV: '错误: \'活动不能删除\': %%!',
	CalDAVerrHttp410: '活动已经在服务器上',
	errUnableSaveTodoBeginCalDAV: '错误: \'不能保存待办\': %%!',
	errUnableDeleteTodoBeginCalDAV: '错误: \'不能删除待办\': %%!',
	CalDAVerrTodoHttp410: '待办已经服务器上。'
};

$.extend(true, localization, localizationCalDAV);

var localizationCardDAV = new Object();

localizationCardDAV['cs_CZ']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	/* index.html */
	altAddContact: 'Přidat kontakt',
	altPhoto: 'Fotka',
	txtAddressbook: 'Adresář',
	txtAddressbooks: 'Adresáře',
	txtVcardGroupsTextSingle: '%coll% [+ 1 skupina]',
	txtVcardGroupsTextMulti: '%coll% [+ %n% skupiny]',
	txtEnabledAddressbooks: 'Zapnuté Adresáře',
	txtCompanies: 'Firmy',
	txtContact: 'Kontakt',
	pholderNickname: 'Přezdívka',
	pholderPhGiven: 'Jméno foneticky',
	pholderPhFamily: 'Příjmení foneticky',
	pholderBday: 'Narozeniny',
	pholderDate: 'Datum',
	pholderTitle: 'Zařazení',
	pholderOrg: 'Firma',
	pholderDepartment: 'Oddělení',
	txtCompanyContact: 'Kontakt na společnost',
	txtRemoteImage: 'URL vzdáleného obrázku',
	txtName: 'Jméno',

	altDel: '-',
	altAdd: '+',
	altValueHandler: '>',	/* opening URL, calling phone number, ... */

	txtCustom: '» vlastní',
	pholderCustomVal: 'vlastní',

	txtDates: 'Datumy',
	txtDatesAnniversary: 'Výročí',
	txtDatesOther: 'jiné',

	txtPhone: 'Telefon',
	txtPhoneWork: 'práce',
	txtPhoneHome: 'domov',
	txtPhoneCell: 'mobil',
	txtPhoneCellWork: 'mobil (práce)',
	txtPhoneCellHome: 'mobil (domov)',
	txtPhoneMain: 'centrála',
	txtPhonePager: 'pager',
	txtPhoneFax: 'fax',
	txtPhoneFaxWork: 'fax (práce)',
	txtPhoneFaxHome: 'fax (domov)',
	txtPhoneIphone: 'iPhone',
	txtPhoneOther: 'jiné',
	pholderPhoneVal: 'Telefon',

	txtEmail: 'E-mail',
	txtEmailWork: 'práce',
	txtEmailHome: 'domov',
	txtEmailMobileme: 'mobileMe',
	txtEmailOther: 'jiné',
	pholderEmailVal: 'E-mail',

	txtUrl: 'Web',
	txtUrlWork: 'práce',
	txtUrlHome: 'domov',
	txtUrlHomepage: 'web',
	txtUrlOther: 'jiné',
	pholderUrlVal: 'URL',

	txtRelated: 'Příbuzné osoby',
	txtRelatedFather: 'otec',
	txtRelatedMother: 'matka',
	txtRelatedParent: 'rodič',
	txtRelatedBrother: 'bratr',
	txtRelatedSister: 'sestra',
	txtRelatedChild: 'dítě',
	txtRelatedFriend: 'přítel',
	txtRelatedSpouse: 'manžel(ka)',
	txtRelatedPartner: 'partner',
	txtRelatedAssistant: 'asistent',
	txtRelatedManager: 'manažer',
	txtRelatedOther: 'jiné',
	pholderRelatedVal: 'Jméno',

	txtIm: 'Adresa IM',
	txtImWork: 'práce',
	txtImHome: 'domov',
	txtImMobileme: 'mobileMe',
	txtImOther: 'jiné',
	txtImProtAim: 'AIM',
	txtImProtIcq: 'ICQ',
	txtImProtIrc: 'IRC',
	txtImProtJabber: 'Jabber',
	txtImProtMsn: 'MSN',
	txtImProtYahoo: 'Yahoo',
	txtImProtFacebook: 'Facebook',
	txtImProtGadugadu: 'GaduGadu',
	txtImProtGoogletalk: 'GoogleTalk',
	txtImProtQq: 'QQ',
	txtImProtSkype: 'Skype',
	pholderImVal: 'Uživatel',

	txtProfile: 'Profil',
	txtProfileTwitter: 'twitter',
	txtProfileFacebook: 'facebook',
	txtProfileFlickr: 'flickr',
	txtProfileLinkedin: 'linkedin',
	txtProfileMyspace: 'myspace',
	txtProfileSinaweibo: 'sina weibo',
	pholderProfileVal: 'Uživatel',

	txtAddress: 'Adresa',
	txtAddressWork: 'práce',
	txtAddressHome: 'domov',
	txtAddressOther: 'jiné',
	// address fields are handled specially

	txtCategories: 'Kategorie',
	// categories' values are handled specially

	pholderNoteVal: 'Text',

	buttonDeleteFromGroup: 'Vymazat ze skupiny',

	/* common.js - address field names */
	pholderAddressCity: 'Město',
	pholderAddressCityRegion: 'Město/Region',
	pholderAddressCounty: 'Okres',
	pholderAddressCountyCity: 'Okres/Město',
	pholderAddressDepartment: 'Oddělení',
	pholderAddressDistrict: 'Okrsek',
	pholderAddressDistrictSubdivision: 'Okrsek/Pododdíl',
	pholderAddressFurtherDivisions: 'Další rozdělení',
	pholderAddressGovernorate: 'Gubernie',
	pholderAddressIslandName: 'Název ostrova',
	pholderAddressPinCode: 'Kód PIN',
	pholderAddressPostCode: 'PSČ',
	pholderAddressPostal: 'PSČ',
	pholderAddressPostalCode: 'PSČ',
	pholderAddressPostalDistrict: 'Poštovní okrsek',
	pholderAddressPrefecture: 'Prefektura',
	pholderAddressProvince: 'Kraj',
	pholderAddressRegion: 'Region',
	pholderAddressState: 'Stát',
	pholderAddressStreet: 'Ulice',
	pholderAddressSuburb: 'Čtvrť',
	pholderAddressTownshipDistrict: 'Městký okrsek/Čtvrť',
	pholderAddressZip: 'PSČ',

	/* data_process.js */
	addCategory: 'Přidat kategorii',

	/* addressbook.js */
	contactConcurrentChange: 'Kontakt byl změněn na serveru a znovu načten!',
	contactRfcNotCompliant: 'Chyba: tento kontakt (vCard) není v souladu se standardem RFC 2426!',

	/* interface.js */
	loadingAddressbooks: 'Načítavání adresářů (%act% z %total%) ...',
	unloadingAddressbooks: 'Odčítavání adresářů ...',

	/* webdav_protocol.js */
	succContactSaved: 'Kontakt úspěšně uložen!',
	succContactDeleted: 'Kontakt úspěšně vymazán!',
	succContactDeletedFromGroup: 'Kontakt úspěšně vymazán z aktivní skupiny kontaktů!',
	errUnableLockBegin: 'Chyba: \'nepodařilo se zamknout prostředek\': %%!',
	errUnableUnlockBegin: 'Chyba: \'nepodařilo se odemknout prostředek\': %%!',
	errUnableSaveBegin: 'Chyba: \'nepodařilo se uložit kontakt\': %%!',
	errUnableSaveInvalidData: 'Chyba: \'nelze uložit\': opravte zvýrazněné neplatné hodnoty!',
	errUnableDeleteBegin: 'Chyba: \'nepodařilo se vymazat kontakt\': %%!',
	errResourceLocked: 'prostředek je právě zamčený',
	errHttp410: 'kontakt již není dostupný na serveru',
	errContactHidden: 'Upozornění: tento kontakt momentálně není viditelný v seznamu kontaktů!'
};

localizationCardDAV['da_DK']=	/* thanks Niels Bo Andersen and Michael Rasmussen */
{
	/* index.html */
	altAddContact: 'Tilføj kontaktperson',
	altPhoto: 'Foto',
	txtAddressbook: 'Adressebog',
	txtAddressbooks: 'Adressebøger',
	txtVcardGroupsTextSingle: '%coll% [+ 1 gruppe]',
	txtVcardGroupsTextMulti: '%coll% [+ %n% grupper]',
	txtEnabledAddressbooks: 'Aktive adressebøger',
	txtCompanies: 'Virksomheder',
	txtContact: 'Kontaktperson',
	pholderPhGiven: 'Fornavn (lydskrift)',
	pholderPhFamily: 'Efternavn (lydskrift)',
	pholderBday: 'Fødselsdag',
	pholderDate: 'Dato',
	pholderTitle: 'Jobtitel',
	pholderOrg: 'Firma',
	pholderDepartment: 'Afdeling',
	txtCompanyContact: 'Firmakontakt',
	txtRemoteImage: 'Link til billede',
	txtName: 'Navn',

	altDel: '-',
	altAdd: '+',
	altValueHandler: '>',	/* opening URL, calling phone number, ... */

	txtCustom: '» brugerdefineret',
	pholderCustomVal: 'brugerdefineret',

	txtDates: 'Datoer',
	txtDatesAnniversary: 'Jubilæum',
	txtDatesOther: 'andet',

	txtPhone: 'Telefon',
	txtPhoneWork: 'arbejde',
	txtPhoneHome: 'privat',
	txtPhoneCell: 'mobil',
	txtPhoneCellWork: 'mobil, arbejde',
	txtPhoneCellHome: 'mobil, privat',
	txtPhoneMain: 'primær',
	txtPhonePager: 'personsøger',
	txtPhoneFax: 'fax',
	txtPhoneFaxWork: 'fax, arbejde',
	txtPhoneFaxHome: 'fax, privat',
	txtPhoneIphone: 'iPhone',
	txtPhoneOther: 'andet',
	pholderPhoneVal: 'Telefon',

	txtEmail: 'E-mail',
	txtEmailWork: 'arbejde',
	txtEmailHome: 'privat',
	txtEmailMobileme: 'mobileMe',
	txtEmailOther: 'andet',
	pholderEmailVal: 'E-mail',

	txtUrl: 'Web',
	txtUrlWork: 'arbejde',
	txtUrlHome: 'privat',
	txtUrlHomepage: 'hjemmeside',
	txtUrlOther: 'andet',
	pholderUrlVal: 'URL',

	txtRelated: 'Relationer',
	txtRelatedFather: 'far',
	txtRelatedMother: 'mor',
	txtRelatedParent: 'forælder',
	txtRelatedBrother: 'bror',
	txtRelatedSister: 'søster',
	txtRelatedChild: 'barn',
	txtRelatedFriend: 'ven',
	txtRelatedSpouse: 'samlever',
	txtRelatedPartner: 'partner',
	txtRelatedAssistant: 'assistent',
	txtRelatedManager: 'overordnet',
	txtRelatedOther: 'andet',
	pholderRelatedVal: 'Navn',

	txtIm: 'IM',
	txtImWork: 'arbejde',
	txtImHome: 'privat',
	txtImMobileme: 'mobileMe',
	txtImOther: 'andet',
	txtImProtAim: 'AIM',
	txtImProtIcq: 'ICQ',
	txtImProtIrc: 'IRC',
	txtImProtJabber: 'Jabber',
	txtImProtMsn: 'MSN',
	txtImProtYahoo: 'Yahoo',
	txtImProtFacebook: 'Facebook',
	txtImProtGadugadu: 'GaduGadu',
	txtImProtGoogletalk: 'GoogleTalk',
	txtImProtQq: 'QQ',
	txtImProtSkype: 'Skype',
	pholderImVal: 'BrugerID',

	txtProfile: 'Profil',
	txtProfileTwitter: 'twitter',
	txtProfileFacebook: 'facebook',
	txtProfileFlickr: 'flickr',
	txtProfileLinkedin: 'linkedin',
	txtProfileMyspace: 'myspace',
	txtProfileSinaweibo: 'sina weibo',
	pholderProfileVal: 'Brugernavn',

	txtAddress: 'Adresse',
	txtAddressWork: 'arbejde',
	txtAddressHome: 'privat',
	txtAddressOther: 'andet',
	// address fields are handled specially

	txtCategories: 'Kategorier',
	// categories' values are handled specially

	pholderNoteVal: 'Tekst',

	buttonDeleteFromGroup: 'Fjern fra gruppe',

	/* common.js - address field names */
	pholderAddressCity: 'By',
	pholderAddressCityRegion: 'By/Region',
	pholderAddressCounty: 'Område',
	pholderAddressCountyCity: 'Område/By',
	pholderAddressDepartment: 'Afdeling',
	pholderAddressDistrict: 'Distrikt',
	pholderAddressDistrictSubdivision: 'Distrikt/Underafdeling',
	pholderAddressFurtherDivisions: 'Flere afdelinger',
	pholderAddressGovernorate: 'Governorat',
	pholderAddressIslandName: 'Ønavn',
	pholderAddressPinCode: 'PIN-Kode',
	pholderAddressPostCode: 'Postnummer',
	pholderAddressPostal: 'Postal',
	pholderAddressPostalCode: 'Postnummer',
	pholderAddressPostalDistrict: 'Postdistrikt',
	pholderAddressPrefecture: 'Præfektur',
	pholderAddressProvince: 'Provins',
	pholderAddressRegion: 'Region',
	pholderAddressState: 'Stat',
	pholderAddressStreet: 'Gade',
	pholderAddressSuburb: 'Forstad',
	pholderAddressTownshipDistrict: 'Bydistrikt',
	pholderAddressZip: 'ZIP',

	/* data_process.js */
	addCategory: 'Tilføj kategori',

	/* addressbook.js */
	contactConcurrentChange: 'Kontaktpersonen blev ændret på serveren, og er genindlæst!',
	contactRfcNotCompliant: 'Fejl: denne kontakt (vCard) overholder ikke RFC 2426!',

	/* interface.js */
	loadingAddressbooks: 'Indlæser adressebøger (%act% af %total%) ...',
	unloadingAddressbooks: 'Lukker adressebøger ...',

	/* webdav_protocol.js */
	succContactSaved: 'Kontaktpersonen blev gemt!',
	succContactDeleted: 'Kontaktpersonen blev slettet!',
	succContactDeletedFromGroup: 'Kontaktpersonen blev slettet fra den aktive kontaktgruppe!',
	errUnableLockBegin: 'Fejl: \'kunne ikke låse ressource\': %%!',
	errUnableUnlockBegin: 'Fejl: \'kunne ikke frigive ressource\': %%!',
	errUnableSaveBegin: 'Fejl: \'kunne ikke gemme kontaktpersonen\': %%!',
	errUnableSaveInvalidData: 'Fejl: \'kunne ikke gemme\': korrigere de fremhævede ugyldige værdier!',
	errUnableDeleteBegin: 'Fejl: \'kunne ikke slette kontaktpersonen\': %%!',
	errResourceLocked: 'ressource allerede låst',
	errHttp410: 'kontaktpersonen er ikke længere tilgængelig på serveren',
	errContactHidden: 'Note: Denne kontakt er ikke synlig i kontaktlisten på nuværende tidspunkt!'
};

localizationCardDAV['de_DE']=	/* thanks Marten Gajda and Thomas Scheel */
{
	/* index.html */
	altAddContact: 'Neuer Kontakt',
	altPhoto: 'Foto',
	txtAddressbook: 'Adressbuch',
	txtAddressbooks: 'Adressbücher',
	txtVcardGroupsTextSingle: '%coll% [+ 1 Gruppe]',
	txtVcardGroupsTextMulti: '%coll% [+ %n% Gruppen]',
	txtEnabledAddressbooks: 'Aktive Adressbücher',
	txtCompanies: 'Unternehmen',
	txtContact: 'Kontakt',
	pholderPhGiven: 'Vorname (Ausspracheform)',
	pholderPhFamily: 'Nachname (Ausspracheform)',
	pholderBday: 'Geburtstag',
	pholderDate: 'Datum',
	pholderTitle: 'Berufsbezeichnung',
	pholderOrg: 'Unternehmen',
	pholderDepartment: 'Abteilung',
	txtCompanyContact: 'Unternehmenskontakt',
	txtRemoteImage: 'Bild URL',
	txtName: 'Name',

	altDel: '-',
	altAdd: '+',
	altValueHandler: '>',	/* opening URL, calling phone number, ... */

	txtCustom: '» benutzerdefinierte',
	pholderCustomVal: 'benutzerdefinierte',

	txtDates: 'Ereignisse',
	txtDatesAnniversary: 'Jahrestag',
	txtDatesOther: 'andere',

	txtPhone: 'Telefon',
	txtPhoneWork: 'Büro',
	txtPhoneHome: 'privat',
	txtPhoneCell: 'mobil',
	txtPhoneCellWork: 'mobil (Büro)',
	txtPhoneCellHome: 'mobil (privat)',
	txtPhoneMain: 'Hauptnummer',
	txtPhonePager: 'Pager',
	txtPhoneFax: 'Fax',
	txtPhoneFaxWork: 'Fax (Büro)',
	txtPhoneFaxHome: 'Fax (privat)',
	txtPhoneIphone: 'iPhone',
	txtPhoneOther: 'andere',
	pholderPhoneVal: 'Telefon',

	txtEmail: 'Email',
	txtEmailWork: 'Büro',
	txtEmailHome: 'privat',
	txtEmailMobileme: 'mobileMe',
	txtEmailOther: 'andere',
	pholderEmailVal: 'Email',

	txtUrl: 'URL',
	txtUrlWork: 'Büro',
	txtUrlHome: 'privat',
	txtUrlHomepage: 'Homepage',
	txtUrlOther: 'andere',
	pholderUrlVal: 'URL',

	txtRelated: 'Beziehung',
	txtRelatedFather: 'Vater',
	txtRelatedMother: 'Mutter',
	txtRelatedParent: 'Elternteil',
	txtRelatedBrother: 'Bruder',
	txtRelatedSister: 'Schwester',
	txtRelatedChild: 'Kind',
	txtRelatedFriend: 'Freund',
	txtRelatedSpouse: 'Ehepartner',
	txtRelatedPartner: 'Partner',
	txtRelatedAssistant: 'Assistent',
	txtRelatedManager: 'Vorgesetzter',
	txtRelatedOther: 'andere',
	pholderRelatedVal: 'Name',

	txtIm: 'IM',
	txtImWork: 'Büro',
	txtImHome: 'privat',
	txtImMobileme: 'mobileMe',
	txtImOther: 'andere',
	txtImProtAim: 'AIM',
	txtImProtIcq: 'ICQ',
	txtImProtIrc: 'IRC',
	txtImProtJabber: 'Jabber',
	txtImProtMsn: 'MSN',
	txtImProtYahoo: 'Yahoo',
	txtImProtFacebook: 'Facebook',
	txtImProtGadugadu: 'GaduGadu',
	txtImProtGoogletalk: 'GoogleTalk',
	txtImProtQq: 'QQ',
	txtImProtSkype: 'Skype',
	pholderImVal: 'UserID',

	txtProfile: 'Profil',
	txtProfileTwitter: 'twitter',
	txtProfileFacebook: 'facebook',
	txtProfileFlickr: 'flickr',
	txtProfileLinkedin: 'linkedin',
	txtProfileMyspace: 'myspace',
	txtProfileSinaweibo: 'sina weibo',
	pholderProfileVal: 'Benutzername',

	txtAddress: 'Adresse',
	txtAddressWork: 'Büro',
	txtAddressHome: 'privat',
	txtAddressOther: 'andere',
	// address fields are handled specially

	txtCategories: 'Kategorien',
	// categories' values are handled specially

	pholderNoteVal: 'Notiztext',

	buttonDeleteFromGroup: 'Aus Gruppe löschen',

	/* common.js - address field names */
	pholderAddressCity: 'Stadt',
	pholderAddressCityRegion: 'Stadt/Region',
	pholderAddressCounty: 'Bezirk',
	pholderAddressCountyCity: 'Stadtbezirk',
	pholderAddressDepartment: 'Distrikt',
	pholderAddressDistrict: 'Kreis',
	pholderAddressDistrictSubdivision: 'Kreis/Unterteilung',
	pholderAddressFurtherDivisions: 'Weitere Unterteilungen',
	pholderAddressGovernorate: 'Regierungsbezirk',
	pholderAddressIslandName: 'Inselname',
	pholderAddressPinCode: 'PIN Code',
	pholderAddressPostCode: 'Postleitzahl',
	pholderAddressPostal: 'Postal',
	pholderAddressPostalCode: 'Postleitzahl',
	pholderAddressPostalDistrict: 'Postbezirk',
	pholderAddressPrefecture: 'Präfektur',
	pholderAddressProvince: 'Provinz',
	pholderAddressRegion: 'Region',
	pholderAddressState: 'Land',
	pholderAddressStreet: 'Straße',
	pholderAddressSuburb: 'Vorort',
	pholderAddressTownshipDistrict: 'Verwaltungsbezirk',
	pholderAddressZip: 'PLZ',

	/* data_process.js */
	addCategory: 'neue Kategorie',

	/* addressbook.js */
	contactConcurrentChange: 'Der Kontakt wurde auf dem Server geändert und neu geladen!',
	contactRfcNotCompliant: 'Fehler: Dieser Kontakt (vCard) ist nicht RFC 2426 konform!',

	/* interface.js */
	loadingAddressbooks: 'Lade Adressbücher (%act% von %total%) ...',
	unloadingAddressbooks: 'Entlade Adressbücher ...',

	/* webdav_protocol.js */
	succContactSaved: 'Kontakt erfolgreich gespeichert!',
	succContactDeleted: 'Kontakt erfolgreich gelöscht!',
	succContactDeletedFromGroup: 'Kontakt erfolgreich aus der aktiven Gruppe gelöscht!',
	errUnableLockBegin: 'Fehler: \'Ressource konnte nicht gesperrt werden\': %%!',
	errUnableUnlockBegin: 'Fehler: \'Ressource konnte nicht freigegeben werden\': %%!',
	errUnableSaveBegin: 'Fehler: \'Kontakt konnte nicht gespeichert werden\': %%!',
	errUnableSaveInvalidData: 'Fehler: \'kann nicht gespeichert werden\': Korrigieren Sie die markierten ungültige Werte!',
	errUnableDeleteBegin: 'Fehler: \'Kontakt konnte nicht gelöscht werden\': %%!',
	errResourceLocked: 'Ressource bereits gesperrt',
	errHttp410: 'Kontakt ist auf dem Server nicht mehr verfügbar',
	errContactHidden: 'Hinweis: Dieser Kontakt befindet sich in einem ausgeblendetem Adressbuch!'
};

localizationCardDAV['en_US']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	/* index.html */
	altAddContact: 'Add Contact',
	altPhoto: 'Photo',
	txtAddressbook: 'Addressbook',
	txtAddressbooks: 'Addressbooks',
	txtVcardGroupsTextSingle: '%coll% [+ 1 group]',
	txtVcardGroupsTextMulti: '%coll% [+ %n% groups]',
	txtEnabledAddressbooks: 'Enabled Addressbooks',
	txtCompanies: 'Companies',
	txtContact: 'Contact',
	pholderNickname: 'NickName',
	pholderPhGiven: 'PhoneticFirstName',
	pholderPhFamily: 'PhoneticLastName',
	pholderBday: 'BirthDay',
	pholderDate: 'Date',
	pholderTitle: 'JobTitle',
	pholderOrg: 'Company',
	pholderDepartment: 'Department',
	txtCompanyContact: 'Company Contact',
	txtRemoteImage: 'Remote Image URL',
	txtName: 'Name',

	altDel: '-',
	altAdd: '+',
	altValueHandler: '>',	/* opening URL, calling phone number, ... */

	txtCustom: '» custom',
	pholderCustomVal: 'custom',

	txtDates: 'Dates',
	txtDatesAnniversary: 'Anniversary',
	txtDatesOther: 'other',

	txtPhone: 'Phone',
	txtPhoneWork: 'work',
	txtPhoneHome: 'home',
	txtPhoneCell: 'mobile',
	txtPhoneCellWork: 'work mobile',
	txtPhoneCellHome: 'home mobile',
	txtPhoneMain: 'main',
	txtPhonePager: 'pager',
	txtPhoneFax: 'fax',
	txtPhoneFaxWork: 'work fax',
	txtPhoneFaxHome: 'home fax',
	txtPhoneIphone: 'iPhone',
	txtPhoneOther: 'other',
	pholderPhoneVal: 'Phone',

	txtEmail: 'Email',
	txtEmailWork: 'work',
	txtEmailHome: 'home',
	txtEmailMobileme: 'mobileMe',
	txtEmailOther: 'other',
	pholderEmailVal: 'Email',

	txtUrl: 'URL',
	txtUrlWork: 'work',
	txtUrlHome: 'home',
	txtUrlHomepage: 'homePage',
	txtUrlOther: 'other',
	pholderUrlVal: 'URL',

	txtRelated: 'Related',
	txtRelatedFather: 'father',
	txtRelatedMother: 'mother',
	txtRelatedParent: 'parent',
	txtRelatedBrother: 'brother',
	txtRelatedSister: 'sister',
	txtRelatedChild: 'child',
	txtRelatedFriend: 'friend',
	txtRelatedSpouse: 'spouse',
	txtRelatedPartner: 'partner',
	txtRelatedAssistant: 'assistant',
	txtRelatedManager: 'manager',
	txtRelatedOther: 'other',
	pholderRelatedVal: 'Name',

	txtIm: 'IM',
	txtImWork: 'work',
	txtImHome: 'home',
	txtImMobileme: 'mobileMe',
	txtImOther: 'other',
	txtImProtAim: 'AIM',
	txtImProtIcq: 'ICQ',
	txtImProtIrc: 'IRC',
	txtImProtJabber: 'Jabber',
	txtImProtMsn: 'MSN',
	txtImProtYahoo: 'Yahoo',
	txtImProtFacebook: 'Facebook',
	txtImProtGadugadu: 'GaduGadu',
	txtImProtGoogletalk: 'GoogleTalk',
	txtImProtQq: 'QQ',
	txtImProtSkype: 'Skype',
	pholderImVal: 'UserID',

	txtProfile: 'Profile',
	txtProfileTwitter: 'twitter',
	txtProfileFacebook: 'facebook',
	txtProfileFlickr: 'flickr',
	txtProfileLinkedin: 'linkedin',
	txtProfileMyspace: 'myspace',
	txtProfileSinaweibo: 'sina weibo',
	pholderProfileVal: 'UserName',

	txtAddress: 'Address',
	txtAddressWork: 'work',
	txtAddressHome: 'home',
	txtAddressOther: 'other',
	// address fields are handled specially

	txtCategories: 'Categories',
	// categories' values are handled specially

	pholderNoteVal: 'NoteText',

	buttonDeleteFromGroup: 'Delete from Group',

	/* common.js - address field names */
	pholderAddressCity: 'City',
	pholderAddressCityRegion: 'City/Region',
	pholderAddressCounty: 'County',
	pholderAddressCountyCity: 'County/City',
	pholderAddressDepartment: 'Department',
	pholderAddressDistrict: 'District',
	pholderAddressDistrictSubdivision: 'District/Subdivision',
	pholderAddressFurtherDivisions: 'Further Divisions',
	pholderAddressGovernorate: 'Governorate',
	pholderAddressIslandName: 'Island Name',
	pholderAddressPinCode: 'PIN Code',
	pholderAddressPostCode: 'Post Code',
	pholderAddressPostal: 'Postal',
	pholderAddressPostalCode: 'Postal Code',
	pholderAddressPostalDistrict: 'Postal District',
	pholderAddressPrefecture: 'Prefecture',
	pholderAddressProvince: 'Province',
	pholderAddressRegion: 'Region',
	pholderAddressState: 'State',
	pholderAddressStreet: 'Street',
	pholderAddressSuburb: 'Suburb',
	pholderAddressTownshipDistrict: 'Township/District',
	pholderAddressZip: 'ZIP',

	/* data_process.js */
	addCategory: 'AddCategory',

	/* addressbook.js */
	contactConcurrentChange: 'The contact on the server was changed and reloaded!',
	contactRfcNotCompliant: 'Error: this contact (vCard) is not compliant with RFC 2426!',

	/* interface.js */
	loadingAddressbooks: 'Loading addressbooks (%act% of %total%) ...',
	unloadingAddressbooks: 'Unloading addressbooks ...',

	/* webdav_protocol.js */
	succContactSaved: 'Contact successfully saved!',
	succContactDeleted: 'Contact successfully deleted!',
	succContactDeletedFromGroup: 'Contact successfully deleted from the active contact group!',
	errUnableLockBegin: 'Error: \'unable to lock resource\': %%!',
	errUnableUnlockBegin: 'Error: \'unable to unlock resource\': %%!',
	errUnableSaveBegin: 'Error: \'unable to save the contact\': %%!',
	errUnableSaveInvalidData: 'Error: \'unable to save\': correct the highlighted invalid values!',
	errUnableDeleteBegin: 'Error: \'unable to delete the contact\': %%!',
	errResourceLocked: 'resource already locked',
	errHttp410: 'contact is no longer available at the server',
	errContactHidden: 'Note: this contact is currently not visible in contact list!'
};

localizationCardDAV['es_ES']=	/* Damian Vila <damianvila@gmail.com> */
{
	/* index.html */
	altAddContact: 'Agregar contacto',
	altPhoto: 'Foto',
	txtAddressbook: 'Agenda',
	txtAddressbooks: 'Libretas de direcciones',
	txtVcardGroupsTextSingle: '%coll% [+ 1 grupo]',
	txtVcardGroupsTextMulti: '%coll% [+ %n% grupos]',
	txtEnabledAddressbooks: 'Habilitar Libretas de direcciones',
	txtCompanies: 'Compañías',
	txtContact: 'Contacto',
	pholderNickname: 'Apodo',
	pholderPhGiven: 'Nombre fonético',
	pholderPhFamily: 'Apellido fonético',
	pholderBday: 'Cumpleaños',
	pholderDate: 'Fecha',
	pholderTitle: 'Puesto',
	pholderOrg: 'Compañía',
	pholderDepartment: 'Departmento',
	txtCompanyContact: 'Contacto en Compañia',
	txtRemoteImage: 'URL de imagen remota',
	txtName: 'Nombre',

	altDel: '-',
	altAdd: '+',
	altValueHandler: '>',	/* opening URL, calling phone number, ... */

	txtCustom: '» personalizado',
	pholderCustomVal: 'personalizado',

	txtDates: 'Fechas',
	txtDatesAnniversary: 'Aniversario',
	txtDatesOther: 'otro',

	txtPhone: 'Teléfono',
	txtPhoneWork: 'trabajo',
	txtPhoneHome: 'casa',
	txtPhoneCell: 'móvil',
	txtPhoneCellWork: 'móvil trabajo',
	txtPhoneCellHome: 'móvil casa',
	txtPhoneMain: 'principal',
	txtPhonePager: 'pager',
	txtPhoneFax: 'fax',
	txtPhoneFaxWork: 'fax trabajo',
	txtPhoneFaxHome: 'fax casa',
	txtPhoneIphone: 'iPhone',
	txtPhoneOther: 'otro',
	pholderPhoneVal: 'Teléfono',

	txtEmail: 'E-mail',
	txtEmailWork: 'trabajo',
	txtEmailHome: 'casa',
	txtEmailMobileme: 'mobileMe',
	txtEmailOther: 'otro',
	pholderEmailVal: 'E-mail',

	txtUrl: 'URL',
	txtUrlWork: 'trabajo',
	txtUrlHome: 'casa',
	txtUrlHomepage: 'Página de inicio',
	txtUrlOther: 'otro',
	pholderUrlVal: 'URL',

	txtRelated: 'Relacionado',
	txtRelatedFather: 'padre',
	txtRelatedMother: 'madre',
	txtRelatedParent: 'progenitor',
	txtRelatedBrother: 'hermano',
	txtRelatedSister: 'hermana',
	txtRelatedChild: 'hijo',
	txtRelatedFriend: 'amigo',
	txtRelatedSpouse: 'cónyuge',
	txtRelatedPartner: 'compañero/a',
	txtRelatedAssistant: 'asistente',
	txtRelatedManager: 'gerente',
	txtRelatedOther: 'otro',
	pholderRelatedVal: 'Nombre',

	txtIm: 'IM',
	txtImWork: 'trabajo',
	txtImHome: 'casa',
	txtImMobileme: 'mobileMe',
	txtImOther: 'otro',
	txtImProtAim: 'AIM',
	txtImProtIcq: 'ICQ',
	txtImProtIrc: 'IRC',
	txtImProtJabber: 'Jabber',
	txtImProtMsn: 'MSN',
	txtImProtYahoo: 'Yahoo',
	txtImProtFacebook: 'Facebook',
	txtImProtGadugadu: 'GaduGadu',
	txtImProtGoogletalk: 'GoogleTalk',
	txtImProtQq: 'QQ',
	txtImProtSkype: 'Skype',
	pholderImVal: 'UserID',

	txtProfile: 'Perfil',
	txtProfileTwitter: 'twitter',
	txtProfileFacebook: 'facebook',
	txtProfileFlickr: 'flickr',
	txtProfileLinkedin: 'linkedin',
	txtProfileMyspace: 'myspace',
	txtProfileSinaweibo: 'sina weibo',
	pholderProfileVal: 'Nombre de usuario',

	txtAddress: 'Dirección',
	txtAddressWork: 'trabajo',
	txtAddressHome: 'casa',
	txtAddressOther: 'otro',
	// address fields are handled specially

	txtCategories: 'Categorías',
	// categories' values are handled specially

	pholderNoteVal: 'Texto de nota',

	buttonDeleteFromGroup: 'Borrar del grupo',

	/* common.js - address field names */
	pholderAddressCity: 'Ciudad',
	pholderAddressCityRegion: 'Ciudad/Región',
	pholderAddressCounty: 'Condado',
	pholderAddressCountyCity: 'Condado/Ciudad',
	pholderAddressDepartment: 'Departmento',
	pholderAddressDistrict: 'Distrito',
	pholderAddressDistrictSubdivision: 'Distrito/Subdivisión',
	pholderAddressFurtherDivisions: 'Divisiones extra',
	pholderAddressGovernorate: 'Governación',
	pholderAddressIslandName: 'Nombre de isla',
	pholderAddressPinCode: 'Código PIN',
	pholderAddressPostCode: 'Código postal',
	pholderAddressPostal: 'Postal',
	pholderAddressPostalCode: 'Código postal',
	pholderAddressPostalDistrict: 'Distrito postal',
	pholderAddressPrefecture: 'Prefectura',
	pholderAddressProvince: 'Provincia',
	pholderAddressRegion: 'Región',
	pholderAddressState: 'Estado',
	pholderAddressStreet: 'Calle',
	pholderAddressSuburb: 'Suburbio',
	pholderAddressTownshipDistrict: 'Municipio/Distrito',
	pholderAddressZip: 'Código postal',

	/* data_process.js */
	addCategory: 'Agregar categoría',

	/* addressbook.js */
	contactConcurrentChange: 'El contacto en el servidor ha sido cambiado y recargado!',
	contactRfcNotCompliant: 'Error: este contacto (vCard) no es compatible con RFC 2426!',

	/* interface.js */
	loadingAddressbooks: 'Cargando agendas (%act% de %total%) ...',
	unloadingAddressbooks: 'Quitando Libretas de direcciones ...',

	/* webdav_protocol.js */
	succContactSaved: 'Contacto guardado satisfactoriamente!',
	succContactDeleted: 'Contacto borrado satisfactoriamente!',
	succContactDeletedFromGroup: 'Contacto borrado satisfactoriamente del grupo de contactos activo!',
	errUnableLockBegin: 'Error: \'imposible bloquear el recurso\': %%!',
	errUnableUnlockBegin: 'Error: \'imposible desbloquear el recurso\': %%!',
	errUnableSaveBegin: 'Error: \'imposible guardar el contacto\': %%!',
	errUnableSaveInvalidData: 'Error: \'imposible guardar\': corrige los valores marcados!',
	errUnableDeleteBegin: 'Error: \'imposible borrar el contacto\': %%!',
	errResourceLocked: 'el recurso ya está bloqueado',
	errHttp410: 'el contacto ya no está disponible en el servidor',
	errContactHidden: 'Nota: este contacto no está visible en este momento en la lista de contactos!'
};

localizationCardDAV['fr_FR']=	/* thanks John Fischer and Jean-Christophe Bach */
{
	/* index.html */
	altAddContact: 'Ajouter un contact',
	altPhoto: 'Photo',
	txtAddressbook: 'Annuaire',
	txtAddressbooks: 'Carnets d\'adresses',
	txtVcardGroupsTextSingle: '%coll% [+ 1 groupe]',
	txtVcardGroupsTextMulti: '%coll% [+ %n% groupes]',
	txtEnabledAddressbooks: 'Carnets d\'adresses activés',
	txtCompanies: 'Sociétés',
	txtContact: 'Contact',
	pholderNickname: 'Surnom',
	pholderPhGiven: 'Prénom phonétique',
	pholderPhFamily: 'Nom phonétique',
	pholderBday: 'Date de naissance',
	pholderDate: 'Date',
	pholderTitle: 'Profession',
	pholderOrg: 'Société',
	pholderDepartment: 'Service',
	txtCompanyContact: 'Contact de la Société',
	txtRemoteImage: 'URL de l\'image partagée',
	txtName: 'Nom',

	altDel: '-',
	altAdd: '+',
	altValueHandler: '>',	/* opening URL, calling phone number, ... */

	txtCustom: '» personnalisée',
	pholderCustomVal: 'personnalisée',

	txtDates: 'Dates',
	txtDatesAnniversary: 'Anniversaire',
	txtDatesOther: 'autres',

	txtPhone: 'Téléphone',
	txtPhoneWork: 'travail',
	txtPhoneHome: 'domicile',
	txtPhoneCell: 'mobile',
	txtPhoneCellWork: 'mobile travail',
	txtPhoneCellHome: 'mobile domicile',
	txtPhoneMain: 'principal',
	txtPhonePager: 'pager',
	txtPhoneFax: 'fax',
	txtPhoneFaxWork: 'fax de travail',
	txtPhoneFaxHome: 'fax de domicile',
	txtPhoneIphone: 'iPhone',
	txtPhoneOther: 'autres',
	pholderPhoneVal: 'Phone',

	txtEmail: 'Email',
	txtEmailWork: 'travail',
	txtEmailHome: 'domicile',
	txtEmailMobileme: 'mobileMe',
	txtEmailOther: 'autres',
	pholderEmailVal: 'Email',

	txtUrl: 'URL',
	txtUrlWork: 'travail',
	txtUrlHome: 'domicile',
	txtUrlHomepage: 'homePage',
	txtUrlOther: 'autre',
	pholderUrlVal: 'URL',

	txtRelated: 'Related',
	txtRelatedFather: 'père',
	txtRelatedMother: 'mère',
	txtRelatedParent: 'parent',
	txtRelatedBrother: 'frère',
	txtRelatedSister: 'soeur',
	txtRelatedChild: 'enfant',
	txtRelatedFriend: 'ami',
	txtRelatedSpouse: 'conjoint',
	txtRelatedPartner: 'partenaire',
	txtRelatedAssistant: 'assistant',
	txtRelatedManager: 'directeur',
	txtRelatedOther: 'autre',
	pholderRelatedVal: 'Name',

	txtIm: 'IM',
	txtImWork: 'travail',
	txtImHome: 'domicile',
	txtImMobileme: 'mobileMe',
	txtImOther: 'autre',
	txtImProtAim: 'AIM',
	txtImProtIcq: 'ICQ',
	txtImProtIrc: 'IRC',
	txtImProtJabber: 'Jabber',
	txtImProtMsn: 'MSN',
	txtImProtYahoo: 'Yahoo',
	txtImProtFacebook: 'Facebook',
	txtImProtGadugadu: 'GaduGadu',
	txtImProtGoogletalk: 'GoogleTalk',
	txtImProtQq: 'QQ',
	txtImProtSkype: 'Skype',
	pholderImVal: 'UserID',

	txtProfile: 'Profil',
	txtProfileTwitter: 'twitter',
	txtProfileFacebook: 'facebook',
	txtProfileFlickr: 'flickr',
	txtProfileLinkedin: 'linkedin',
	txtProfileMyspace: 'myspace',
	txtProfileSinaweibo: 'sina weibo',
	pholderProfileVal: 'Nom d\'utilisateur',

	txtAddress: 'Adresse',
	txtAddressWork: 'travail',
	txtAddressHome: 'domicile',
	txtAddressOther: 'autre',
	// address fields are handled specially

	txtCategories: 'Catégories',
	// categories' values are handled specially

	pholderNoteVal: 'NoteText',

	buttonDeleteFromGroup: 'Supprimer du groupe',

	/* common.js - address field names */
	pholderAddressCity: 'Ville',
	pholderAddressCityRegion: 'Ville/Quartier',
	pholderAddressCounty: 'Comté',
	pholderAddressCountyCity: 'Région/Ville',
	pholderAddressDepartment: 'Département',
	pholderAddressDistrict: 'District',
	pholderAddressDistrictSubdivision: 'District/Sous-division',
	pholderAddressFurtherDivisions: 'Further Divisions',
	pholderAddressGovernorate: 'Gouvernorat',
	pholderAddressIslandName: 'Nom d\'île',
	pholderAddressPinCode: 'PIN Code',
	pholderAddressPostCode: 'CP',
	pholderAddressPostal: 'Postal',
	pholderAddressPostalCode: 'Code Postal',
	pholderAddressPostalDistrict: 'Postal District',
	pholderAddressPrefecture: 'Préfecture',
	pholderAddressProvince: 'Province',
	pholderAddressRegion: 'CP',
	pholderAddressState: 'Région',
	pholderAddressStreet: 'Rue',
	pholderAddressSuburb: 'Suburb',
	pholderAddressTownshipDistrict: 'Township/District',
	pholderAddressZip: 'CP',

	/* data_process.js */
	addCategory: 'AjouterUneCatégorie',

	/* addressbook.js */
	contactConcurrentChange: 'Le contact sur le serveur a été modifié et a été rechargé !',
	contactRfcNotCompliant: 'Erreur : ce contact (vCard) ne respecte pas la norme RFC 2426 !',

	/* interface.js */
	loadingAddressbooks: 'Chargement des contacts (%act% sur %total%) ...',
	unloadingAddressbooks: 'Déchargement des carnets d\'adresses ...',

	/* webdav_protocol.js */
	succContactSaved: 'Le contact a été enregistré avec succès !',
	succContactDeleted: 'Le contact a été supprimé avec succès !',
	succContactDeletedFromGroup: 'Le contact a été supprimé avec succès du groupe de contacts sélectionné !',
	errUnableLockBegin: 'Erreur : \'impossible de verrouiller la ressource\' : %% !',
	errUnableUnlockBegin: 'Erreur : \'impossible de déverrouiller la ressource\' : %% !',
	errUnableSaveBegin: 'Erreur : \'impossible de sauvegarder le contact\' : %% !',
	errUnableSaveInvalidData: 'Erreur : \'impossible d\'enregistrer\' : corriger les valeurs mises en évidence invalides !',
	errUnableDeleteBegin: 'Erreur : \'impossible de supprimer le contact\' : %% !',
	errResourceLocked: 'la ressource est déjà verrouillée',
	errHttp410: 'le contact n\'est plus disponible sur le serveur',
	errContactHidden: 'Note : ce contact n\'est actuellement pas visible dans la liste des contacts !'
};

localizationCardDAV['hu_HU']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	/* index.html */
	altAddContact: 'Új kapcsolat',
	altPhoto: 'Fotó',
	txtAddressbook: 'Címjegyzék',
	txtAddressbooks: 'Címjegyzékek',
	txtVcardGroupsTextSingle: '%coll% [+ 1 csoport]',
	txtVcardGroupsTextMulti: '%coll% [+ %n% csoportok]',
	txtEnabledAddressbooks: 'Betöltött címjegyzékek',
	txtCompanies: 'Vállalatok',
	txtContact: 'Kapcsolat',
	pholderNickname: 'Becenév',
	pholderPhGiven: 'Utó (fonetikus)',
	pholderPhFamily: 'Családi (fonetikus)',
	pholderBday: 'Születésnap',
	pholderDate: 'Dátum',
	pholderTitle: 'Foglalkozás',
	pholderOrg: 'Cég',
	pholderDepartment: 'Részleg',
	txtCompanyContact: 'Vállalati kapcsolat',
	txtRemoteImage: 'Távoli kép URL-címe',
	txtName: 'Név',

	altDel: '-',
	altAdd: '+',
	altValueHandler: '>',	/* opening URL, calling phone number, ... */

	txtCustom: '» egyéni',
	pholderCustomVal: 'egyéni',

	txtDates: 'Dátumok',
	txtDatesAnniversary: 'Évforduló',
	txtDatesOther: 'egyéb',

	txtPhone: 'Telefon',
	txtPhoneWork: 'céges',
	txtPhoneHome: 'otthon',
	txtPhoneCell: 'mobil',
	txtPhoneCellWork: 'céges mobil',
	txtPhoneCellHome: 'otthoni mobil',
	txtPhoneMain: 'központi',
	txtPhonePager: 'csipogó',
	txtPhoneFax: 'fax',
	txtPhoneFaxWork: 'céges fax',
	txtPhoneFaxHome: 'hazai fax',
	txtPhoneIphone: 'iPhone',
	txtPhoneOther: 'egyéb',
	pholderPhoneVal: 'Telefon',

	txtEmail: 'Email',
	txtEmailWork: 'céges',
	txtEmailHome: 'otthon',
	txtEmailMobileme: 'mobileMe',
	txtEmailOther: 'egyéb',
	pholderEmailVal: 'Email',

	txtUrl: 'Web',
	txtUrlWork: 'céges',
	txtUrlHome: 'otthon',
	txtUrlHomepage: 'honlap',
	txtUrlOther: 'egyéb',
	pholderUrlVal: 'URL',

	txtRelated: 'Kapcsolódó személyek',
	txtRelatedFather: 'apa',
	txtRelatedMother: 'anya',
	txtRelatedParent: 'szülő',
	txtRelatedBrother: 'fiútestvér',
	txtRelatedSister: 'lánytestvér',
	txtRelatedChild: 'gyermek',
	txtRelatedFriend: 'barát',
	txtRelatedSpouse: 'házastárs',
	txtRelatedPartner: 'partner',
	txtRelatedAssistant: 'asszisztens',
	txtRelatedManager: 'főnök',
	txtRelatedOther: 'egyéb',
	pholderRelatedVal: 'Név',

	txtIm: 'Azonnali üzenetek',
	txtImWork: 'céges',
	txtImHome: 'otthon',
	txtImMobileme: 'mobileMe',
	txtImOther: 'egyéb',
	txtImProtAim: 'AIM',
	txtImProtIcq: 'ICQ',
	txtImProtIrc: 'IRC',
	txtImProtJabber: 'Jabber',
	txtImProtMsn: 'MSN',
	txtImProtYahoo: 'Yahoo',
	txtImProtFacebook: 'Facebook',
	txtImProtGadugadu: 'GaduGadu',
	txtImProtGoogletalk: 'GoogleTalk',
	txtImProtQq: 'QQ',
	txtImProtSkype: 'Skype',
	pholderImVal: 'Felhasználói név',

	txtProfile: 'Profil',
	txtProfileTwitter: 'twitter',
	txtProfileFacebook: 'facebook',
	txtProfileFlickr: 'flickr',
	txtProfileLinkedin: 'linkedin',
	txtProfileMyspace: 'myspace',
	txtProfileSinaweibo: 'sina weibo',
	pholderProfileVal: 'Felhasználói név',

	txtAddress: 'Cím',
	txtAddressWork: 'céges',
	txtAddressHome: 'otthon',
	txtAddressOther: 'egyéb',
	// address fields are handled specially

	txtCategories: 'Kategóriák',
	// categories' values are handled specially

	pholderNoteVal: 'Szöveg',

	buttonDeleteFromGroup: 'Törlés a csoportból',

	/* common.js - address field names */
	pholderAddressCity: 'Város',
	pholderAddressCityRegion: 'Város/Régió',
	pholderAddressCounty: 'Megye',
	pholderAddressCountyCity: 'Megye/Város',
	pholderAddressDepartment: 'Részleg',
	pholderAddressDistrict: 'Kerület',
	pholderAddressDistrictSubdivision: 'Kerület/Területegység',
	pholderAddressFurtherDivisions: 'További divíziók',
	pholderAddressGovernorate: 'Kormányzóság',
	pholderAddressIslandName: 'Szigetnév',
	pholderAddressPinCode: 'PIN-kód',
	pholderAddressPostCode: 'Ir. szám',
	pholderAddressPostal: 'Ir. szám',
	pholderAddressPostalCode: 'Ir. szám',
	pholderAddressPostalDistrict: 'Postai kerület',
	pholderAddressPrefecture: 'Prefektúra',
	pholderAddressProvince: 'Tartomány',
	pholderAddressRegion: 'Régió',
	pholderAddressState: 'Állam',
	pholderAddressStreet: 'Utca',
	pholderAddressSuburb: 'Külváros',
	pholderAddressTownshipDistrict: 'Község/Kerület',
	pholderAddressZip: 'Ir. szám',

	/* data_process.js */
	addCategory: 'Új kategória',

	/* addressbook.js */
	contactConcurrentChange: 'A kapcsolat megváltozott a szerveren, és újra lett betöltve!',
	contactRfcNotCompliant: 'Hiba: a kapcsolat (vCard) nincs összhangban az RFC 2426 szabvánnyal!',

	/* interface.js */
	loadingAddressbooks: 'Címjegyzékek letöltése (%act%/%total%) ...',
	unloadingAddressbooks: 'Címjegyzékek eltávolítása ...',

	/* webdav_protocol.js */
	succContactSaved: 'A kapcsolat sikeresen elmentve!',
	succContactDeleted: 'A kapcsolat sikeresen törölve!',
	succContactDeletedFromGroup: 'A kapcsolat sikeresen törölve az aktív kapcsolatcsoportból!',
	errUnableLockBegin: 'Hiba: \'nem sikerült a forrás lezárása\': %%!',
	errUnableUnlockBegin: 'Hiba: \'nem sikerült a forrás kizárása\': %%!',
	errUnableSaveBegin: 'Hiba: \'nem sikerült a kapcsolat elmentése\': %%!',
	errUnableSaveInvalidData: 'Hiba: \'nem lehet menteni\': javítsa ki a kijelölt érvénytelen értékeket!',
	errUnableDeleteBegin: 'Hiba: \'nem sikerült a kapcsolat törlése\': %%!',
	errResourceLocked: 'a forrás jelenleg le van zárva',
	errHttp410: 'a kapcsolat már nem elérhető a szerveren',
	errContactHidden: 'Megjegyzés: ez a kapcsolat jelenleg nem látható a névjegyzékben!'
};

localizationCardDAV['it_IT']=	/* thanks Luca Ferrario */
{
	/* index.html */
	altAddContact: 'Nuovo Contatto',
	altPhoto: 'Foto',
	txtAddressbook: 'Rubrica',
	txtAddressbooks: 'Rubriche',
	txtVcardGroupsTextSingle: '%coll% [+ 1 gruppo]',
	txtVcardGroupsTextMulti: '%coll% [+ %n% gruppi]',
	txtEnabledAddressbooks: 'Rubriche Abilitate',
	txtCompanies: 'Aziende',
	txtContact: 'Contatto',
	pholderNickname: 'Nickname',
	pholderPhGiven: 'Nome fonetico',
	pholderPhFamily: 'Cognome fonetico',
	pholderBday: 'Compleanno',
	pholderDate: 'Data',
	pholderTitle: 'Ruolo',
	pholderOrg: 'Azienda',
	pholderDepartment: 'Dipartimento',
	txtCompanyContact: 'Contatto Aziendale',
	txtRemoteImage: 'URL Immagine Remota',
	txtName: 'Nome',

	altDel: '-',
	altAdd: '+',
	altValueHandler: '>',	/* opening URL, calling phone number, ... */

	txtCustom: '» personalizzata',
	pholderCustomVal: 'personalizzata',

	txtDates: 'Date',
	txtDatesAnniversary: 'Anniversario',
	txtDatesOther: 'altro',

	txtPhone: 'Telefono',
	txtPhoneWork: 'ufficio',
	txtPhoneHome: 'casa',
	txtPhoneCell: 'cellulare',
	txtPhoneCellWork: 'cellulare lavoro',
	txtPhoneCellHome: 'cellulare personale',
	txtPhoneMain: 'principale',
	txtPhonePager: 'cercapersone',
	txtPhoneFax: 'fax',
	txtPhoneFaxWork: 'fax ufficio',
	txtPhoneFaxHome: 'fax casa',
	txtPhoneIphone: 'iPhone',
	txtPhoneOther: 'altro',
	pholderPhoneVal: 'Telefono',

	txtEmail: 'Email',
	txtEmailWork: 'lavoro',
	txtEmailHome: 'personale',
	txtEmailMobileme: 'mobileMe',
	txtEmailOther: 'alrra',
	pholderEmailVal: 'Email',

	txtUrl: 'Indirizzo web (URL)',
	txtUrlWork: 'lavoro',
	txtUrlHome: 'personale',
	txtUrlHomepage: 'Home Page',
	txtUrlOther: 'altro',
	pholderUrlVal: 'Indirizzo web',

	txtRelated: 'Relazione',
	txtRelatedFather: 'padre',
	txtRelatedMother: 'madre',
	txtRelatedParent: 'genitore',
	txtRelatedBrother: 'fratello',
	txtRelatedSister: 'sorella',
	txtRelatedChild: 'figlio',
	txtRelatedFriend: 'amico',
	txtRelatedSpouse: 'coniuge',
	txtRelatedPartner: 'partner',
	txtRelatedAssistant: 'assistente',
	txtRelatedManager: 'superiore',
	txtRelatedOther: 'altro',
	pholderRelatedVal: 'Name',

	txtIm: 'IM',
	txtImWork: 'lavoro',
	txtImHome: 'personale',
	txtImMobileme: 'mobileMe',
	txtImOther: 'altro',
	txtImProtAim: 'AIM',
	txtImProtIcq: 'ICQ',
	txtImProtIrc: 'IRC',
	txtImProtJabber: 'Jabber',
	txtImProtMsn: 'MSN',
	txtImProtYahoo: 'Yahoo',
	txtImProtFacebook: 'Facebook',
	txtImProtGadugadu: 'GaduGadu',
	txtImProtGoogletalk: 'GoogleTalk',
	txtImProtQq: 'QQ',
	txtImProtSkype: 'Skype',
	pholderImVal: 'UserID',

	txtProfile: 'Profilo',
	txtProfileTwitter: 'twitter',
	txtProfileFacebook: 'facebook',
	txtProfileFlickr: 'flickr',
	txtProfileLinkedin: 'linkedin',
	txtProfileMyspace: 'myspace',
	txtProfileSinaweibo: 'sina weibo',
	pholderProfileVal: 'Nome utente',

	txtAddress: 'Indirizzo',
	txtAddressWork: 'ufficio',
	txtAddressHome: 'casa',
	txtAddressOther: 'altro',
	// address fields are handled specially

	txtCategories: 'Categorie',
	// categories' values are handled specially

	pholderNoteVal: 'Note',

	buttonDeleteFromGroup: 'Elimina dal Gruppo',

	/* common.js - address field names */
	pholderAddressCity: 'Città',
	pholderAddressCityRegion: 'Regione/Città',
	pholderAddressCounty: 'Contea',
	pholderAddressCountyCity: 'Contea/Città',
	pholderAddressDepartment: 'Department',
	pholderAddressDistrict: 'Distretto',
	pholderAddressDistrictSubdivision: 'Distretto/Sottosezione',
	pholderAddressFurtherDivisions: 'Ulteriori Sottosezioni',
	pholderAddressGovernorate: 'Governatorato',
	pholderAddressIslandName: 'Nome dell\'Isola',
	pholderAddressPinCode: 'Codice PIN',
	pholderAddressPostCode: 'CAP',
	pholderAddressPostal: 'Postale',
	pholderAddressPostalCode: 'CAP',
	pholderAddressPostalDistrict: 'Distretto Postale',
	pholderAddressPrefecture: 'Prefettura',
	pholderAddressProvince: 'Provincia',
	pholderAddressRegion: 'Regione',
	pholderAddressState: 'Stato',
	pholderAddressStreet: 'Via',
	pholderAddressSuburb: 'Quartiere',
	pholderAddressTownshipDistrict: 'Distretto',
	pholderAddressZip: 'CAP',

	/* data_process.js */
	addCategory: 'Aggiungi Categoria',

	/* addressbook.js */
	contactConcurrentChange: 'Il contatto è stato modificato sul server e non è stato ricaricato!',
	contactRfcNotCompliant: 'Attenzione: questo contatto (vCard) non è conforme allo standard RFC 2426!',

	/* interface.js */
	loadingAddressbooks: 'Caricamento rubriche in corso (%act% di %total%) ...',
	unloadingAddressbooks: 'Chiusura rubriche ...',

	/* webdav_protocol.js */
	succContactSaved: 'Contatto salvato con successo!',
	succContactDeleted: 'Contatto eliminato con successo!',
	succContactDeletedFromGroup: 'Contatto eliminato con successo dal gruppo attivo!',
	errUnableLockBegin: 'Errore: \'impossibile eseguire il lock della risorsa\': %%!',
	errUnableUnlockBegin: 'Errore: \'impossibile eseguire l\'unlock della risorsa\': %%!',
	errUnableSaveBegin: 'Errore: \'impossibile salvare il contatto\': %%!',
	errUnableSaveInvalidData: 'Errore: \'impossibile salvare\': correggere i valori evidenziati non validi!',
	errUnableDeleteBegin: 'Errore: \'impossibile eliminare il contatto\': %%!',
	errResourceLocked: 'la risorsa risulta già bloccata (lock)',
	errHttp410: 'il contatto non è più disponibile sul server',
	errContactHidden: 'Nota: questo contatto non è al momento visibile nella lista dei contatti!'
};

localizationCardDAV['ja_JP']=	/* Muimu Nakayama */
{
	/* index.html */
	altAddContact: '連絡先を追加',
	altPhoto: '写真',
	txtAddressbook: 'アドレス帳',
	txtAddressbooks: 'アドレス帳',
	txtVcardGroupsTextSingle: '%coll% [+ 1 グループ]',
	txtVcardGroupsTextMulti: '%coll% [+ %n% グループ]',
	txtEnabledAddressbooks: '有効なアドレス帳',
	txtCompanies: '会社',
	txtContact: '連絡先',
	pholderNickname: 'ニックネーム',
	pholderPhGiven: '名ふりがな',
	pholderPhFamily: '姓ふりがな',
	pholderBday: '誕生日',
	pholderDate: '日付',
	pholderTitle: '役職',
	pholderOrg: '会社',
	pholderDepartment: '部署',
	txtCompanyContact: 'この連絡先は会社',
	txtRemoteImage: '画像のURL',
	txtName: '名前',

	altDel: '-',
	altAdd: '+',
	altValueHandler: '>',	/* opening URL, calling phone number, ... */

	txtCustom: '» カスタム',
	pholderCustomVal: 'カスタム',

	txtDates: '日付',
	txtDatesAnniversary: '記念日',
	txtDatesOther: 'その他',

	txtPhone: '電話',
	txtPhoneWork: '仕事',
	txtPhoneHome: '家',
	txtPhoneCell: '携帯',
	txtPhoneCellWork: '携帯（仕事）',
	txtPhoneCellHome: '携帯（家）',
	txtPhoneMain: 'メイン',
	txtPhonePager: 'ポケベル',
	txtPhoneFax: 'Fax',
	txtPhoneFaxWork: 'Fax（仕事）',
	txtPhoneFaxHome: 'Fax（家）',
	txtPhoneIphone: 'iPhone',
	txtPhoneOther: 'その他',
	pholderPhoneVal: '電話',

	txtEmail: 'メール',
	txtEmailWork: '仕事',
	txtEmailHome: '家',
	txtEmailMobileme: 'mobileMe',
	txtEmailOther: 'その他',
	pholderEmailVal: 'メール',

	txtUrl: 'URL',
	txtUrlWork: '仕事',
	txtUrlHome: '家',
	txtUrlHomepage: 'ホームページ',
	txtUrlOther: 'その他',
	pholderUrlVal: 'URL',

	txtRelated: '関係者',
	txtRelatedFather: '父',
	txtRelatedMother: '母',
	txtRelatedParent: '親',
	txtRelatedBrother: '兄弟',
	txtRelatedSister: '姉妹',
	txtRelatedChild: '子',
	txtRelatedFriend: '友人',
	txtRelatedSpouse: '配偶者',
	txtRelatedPartner: 'パートナー',
	txtRelatedAssistant: '部下',
	txtRelatedManager: '上司',
	txtRelatedOther: 'その他',
	pholderRelatedVal: '名前',

	txtIm: 'IM',
	txtImWork: '仕事',
	txtImHome: '家',
	txtImMobileme: 'mobileMe',
	txtImOther: 'その他',
	txtImProtAim: 'AIM',
	txtImProtIcq: 'ICQ',
	txtImProtIrc: 'IRC',
	txtImProtJabber: 'Jabber',
	txtImProtMsn: 'MSN',
	txtImProtYahoo: 'Yahoo',
	txtImProtFacebook: 'Facebook',
	txtImProtGadugadu: 'GaduGadu',
	txtImProtGoogletalk: 'GoogleTalk',
	txtImProtQq: 'QQ',
	txtImProtSkype: 'Skype',
	pholderImVal: 'ユーザID',

	txtProfile: 'プロフィール',
	txtProfileTwitter: 'twitter',
	txtProfileFacebook: 'facebook',
	txtProfileFlickr: 'flickr',
	txtProfileLinkedin: 'linkedin',
	txtProfileMyspace: 'myspace',
	txtProfileSinaweibo: 'sina weibo',
	pholderProfileVal: 'ユーザ名',

	txtAddress: '住所',
	txtAddressWork: '仕事',
	txtAddressHome: '家',
	txtAddressOther: 'その他',
	// address fields are handled specially

	txtCategories: 'カテゴリー',
	// categories' values are handled specially

	pholderNoteVal: 'メモ',

	buttonDeleteFromGroup: 'グループから削除',

	/* common.js - address field names */
	pholderAddressCity: '市町村',
	pholderAddressCityRegion: '市/地方',
	pholderAddressCounty: '郡',
	pholderAddressCountyCity: '区市町村',
	pholderAddressDepartment: '県',
	pholderAddressDistrict: '地区',
	pholderAddressDistrictSubdivision: '地区/区分',
	pholderAddressFurtherDivisions: '残りの住所',
	pholderAddressGovernorate: '県',
	pholderAddressIslandName: '島名',
	pholderAddressPinCode: 'PIN Code',
	pholderAddressPostCode: '郵便番号',
	pholderAddressPostal: '郵便番号',
	pholderAddressPostalCode: '郵便番号',
	pholderAddressPostalDistrict: '郵便区',
	pholderAddressPrefecture: '都道府県',
	pholderAddressProvince: '州/省/道',
	pholderAddressRegion: '地方',
	pholderAddressState: '州',
	pholderAddressStreet: '通り',
	pholderAddressSuburb: '郊外',
	pholderAddressTownshipDistrict: 'タウンシップ/地区',
	pholderAddressZip: 'ZIP',

	/* data_process.js */
	addCategory: 'カテゴリーを追加',

	/* addressbook.js */
	contactConcurrentChange: 'サーバ上の連絡先が変更され，再読み込みされました!',
	contactRfcNotCompliant: 'エラー: この連絡先 (vCard) は RFC 2426 に整合しません!',

	/* interface.js */
	loadingAddressbooks: 'Lアドレス帳を読み込み中 (%act% of %total%) ...',
	unloadingAddressbooks: 'アドレス帳の読み込みを解除中 ...',

	/* webdav_protocol.js */
	succContactSaved: '連絡先の保存に成功しました!',
	succContactDeleted: '連絡先の削除に成功しました!',
	succContactDeletedFromGroup: '現在の連絡先グループから連絡先の削除に成功しました!',
	errUnableLockBegin: 'エラー: \'リソースをロックできません\': %%!',
	errUnableUnlockBegin: 'エラー: \'リソースのロックを解除できません\': %%!',
	errUnableSaveBegin: 'エラー: \'連絡先を保存できません\': %%!',
	errUnableSaveInvalidData: 'エラー: \'保存できません\': 指定された不正な値を直してください!',
	errUnableDeleteBegin: 'エラー: \'連絡先を削除できません\': %%!',
	errResourceLocked: 'リソースはすでにロックされています',
	errHttp410: '連絡先は既にサーバ上にありません',
	errContactHidden: '注意: 現在この連絡先は連絡先一覧で非表示です!'
};

localizationCardDAV['nb_NO']=	/* thanks Tore Ørpetveit */
{
	/* index.html */
	altAddContact: 'Legg til kontaktperson',
	altPhoto: 'Foto',
	txtAddressbook: 'Adressebok',
	txtAddressbooks: 'Adressebøker',
	txtVcardGroupsTextSingle: '%coll% [+ 1 gruppe]',
	txtVcardGroupsTextMulti: '%coll% [+ %n% grupper]',
	txtEnabledAddressbooks: 'Aktive adressebøker',
	txtCompanies: 'Virksomheter',
	txtContact: 'Kontaktperson',
	pholderNickname: 'Kallenavn',
	pholderPhGiven: 'Fornavn (lydskrift)',
	pholderPhFamily: 'Etternavn (lydskrift)',
	pholderBday: 'Fødselsdag',
	pholderDate: 'Dato',
	pholderTitle: 'Jobbtittel',
	pholderOrg: 'Firma',
	pholderDepartment: 'Avdeling',
	txtCompanyContact: 'Firmakontakt',
	txtRemoteImage: 'Link til bilde',
	txtName: 'Navn',

	altDel: '-',
	altAdd: '+',
	altValueHandler: '>',	/* opening URL, calling phone number, ... */

	txtCustom: '» brukerdefinert',
	pholderCustomVal: 'brukerdefinert',

	txtDates: 'Datoer',
	txtDatesAnniversary: 'Jubileum',
	txtDatesOther: 'annet',

	txtPhone: 'Telefon',
	txtPhoneWork: 'arbeid',
	txtPhoneHome: 'privat',
	txtPhoneCell: 'mobil',
	txtPhoneCellWork: 'mobil, arbeid',
	txtPhoneCellHome: 'mobil, privat',
	txtPhoneMain: 'primær',
	txtPhonePager: 'personsøker',
	txtPhoneFax: 'fax',
	txtPhoneFaxWork: 'fax, arbeid',
	txtPhoneFaxHome: 'fax, privat',
	txtPhoneIphone: 'iPhone',
	txtPhoneOther: 'annet',
	pholderPhoneVal: 'Telefon',

	txtEmail: 'E-post',
	txtEmailWork: 'arbeid',
	txtEmailHome: 'privat',
	txtEmailMobileme: 'mobileMe',
	txtEmailOther: 'annet',
	pholderEmailVal: 'E-post',

	txtUrl: 'Web',
	txtUrlWork: 'arbeid',
	txtUrlHome: 'privat',
	txtUrlHomepage: 'hjemmeside',
	txtUrlOther: 'annet',
	pholderUrlVal: 'URL',

	txtRelated: 'Relasjoner',
	txtRelatedFather: 'far',
	txtRelatedMother: 'mor',
	txtRelatedParent: 'forelder',
	txtRelatedBrother: 'bror',
	txtRelatedSister: 'søster',
	txtRelatedChild: 'barn',
	txtRelatedFriend: 'venn',
	txtRelatedSpouse: 'samboer',
	txtRelatedPartner: 'partner',
	txtRelatedAssistant: 'assistent',
	txtRelatedManager: 'overordnet',
	txtRelatedOther: 'annet',
	pholderRelatedVal: 'Navn',

	txtIm: 'IM',
	txtImWork: 'arbeid',
	txtImHome: 'privat',
	txtImMobileme: 'mobileMe',
	txtImOther: 'annet',
	txtImProtAim: 'AIM',
	txtImProtIcq: 'ICQ',
	txtImProtIrc: 'IRC',
	txtImProtJabber: 'Jabber',
	txtImProtMsn: 'MSN',
	txtImProtYahoo: 'Yahoo',
	txtImProtFacebook: 'Facebook',
	txtImProtGadugadu: 'GaduGadu',
	txtImProtGoogletalk: 'GoogleTalk',
	txtImProtQq: 'QQ',
	txtImProtSkype: 'Skype',
	pholderImVal: 'BrukerID',

	txtProfile: 'Profil',
	txtProfileTwitter: 'twitter',
	txtProfileFacebook: 'facebook',
	txtProfileFlickr: 'flickr',
	txtProfileLinkedin: 'linkedin',
	txtProfileMyspace: 'myspace',
	txtProfileSinaweibo: 'sina weibo',
	pholderProfileVal: 'Brukernavn',

	txtAddress: 'Adresse',
	txtAddressWork: 'arbeid',
	txtAddressHome: 'privat',
	txtAddressOther: 'annet',
	// address fields are handled specially

	txtCategories: 'Kategorier',
	// categories' values are handled specially

	pholderNoteVal: 'Tekst',

	buttonDeleteFromGroup: 'Fjern fra gruppe',

	/* common.js - address field names */
	pholderAddressCity: 'By',
	pholderAddressCityRegion: 'By/Region',
	pholderAddressCounty: 'Område',
	pholderAddressCountyCity: 'Område/By',
	pholderAddressDepartment: 'Avdeling',
	pholderAddressDistrict: 'Distrikt',
	pholderAddressDistrictSubdivision: 'Distrikt/Underavdeling',
	pholderAddressFurtherDivisions: 'Flere avdelinger',
	pholderAddressGovernorate: 'Governorat',
	pholderAddressIslandName: 'Øynavn',
	pholderAddressPinCode: 'PIN-Kode',
	pholderAddressPostCode: 'Postnummer',
	pholderAddressPostal: 'By',
	pholderAddressPostalCode: 'Postnummer',
	pholderAddressPostalDistrict: 'Postdistrikt',
	pholderAddressPrefecture: 'Prefektur',
	pholderAddressProvince: 'Provins',
	pholderAddressRegion: 'Region',
	pholderAddressState: 'Stat',
	pholderAddressStreet: 'Gate',
	pholderAddressSuburb: 'Forstad',
	pholderAddressTownshipDistrict: 'Bydistrikt',
	pholderAddressZip: 'Postnummer',

	/* data_process.js */
	addCategory: 'Legg til kategori',

	/* addressbook.js */
	contactConcurrentChange: 'Kontaktpersonen ble endret på serveren, og er lest inn på ny!',
	contactRfcNotCompliant: 'Feil: denne kontakten (vCard) overholder ikke RFC 2426!',

	/* interface.js */
	loadingAddressbooks: 'Leser inn adressebøker (%act% av %total%) ...',
	unloadingAddressbooks: 'Lukker adressebøker ...',

	/* webdav_protocol.js */
	succContactSaved: 'Kontaktpersonen ble lagret!',
	succContactDeleted: 'Kontaktpersonen ble slettet!',
	succContactDeletedFromGroup: 'Kontaktpersonen ble slettet fra den aktive kontaktgruppen!',
	errUnableLockBegin: 'Feil: \'kunne ikke låse ressurs\': %%!',
	errUnableUnlockBegin: 'Feil: \'kunne ikke frigi ressurs\': %%!',
	errUnableSaveBegin: 'Feil: \'kunne ikke lagre kontaktpersonen\': %%!',
	errUnableSaveInvalidData: 'Feil: \'kunne ikke lagre\': korriger uthevede ugyldige felt!',
	errUnableDeleteBegin: 'Feil: \'kunne ikke slette kontaktpersonen\': %%!',
	errResourceLocked: 'ressurs allerede låst',
	errHttp410: 'kontaktpersonen er ikke lenger tilgjengelig på serveren',
	errContactHidden: 'NB: Denne kontakten er ikke synlig i kontaktlisten på nåværende tidspunkt!'
};

localizationCardDAV['nl_NL']=	/* thanks Johan Vromans */
{
	/* index.html */
	altAddContact: 'Contact toevoegen',
	altPhoto: 'Foto',
	txtAddressbook: 'Adresboek',
	txtAddressbooks: 'Adresboeken',
	txtVcardGroupsTextSingle: '%coll% [+ 1 groep]',
	txtVcardGroupsTextMulti: '%coll% [+ %n% groepen]',
	txtEnabledAddressbooks: 'Actieve adresboeken',
	txtCompanies: 'Bedrijven',
	txtContact: 'Contact',
	pholderNickname: 'Roepnaam',
	pholderPhGiven: 'Voornaam (fonetisch)',
	pholderPhFamily: 'Achternaam (fonetisch)',
	pholderBday: 'Geboortedatum',
	pholderDate: 'Datum',
	pholderTitle: 'Beroep',
	pholderOrg: 'Bedrijf',
	pholderDepartment: 'Afdeling',
	txtCompanyContact: 'Contactpersoon bedrijf',
	txtRemoteImage: 'Externe URL voor afbeelding',
	txtName: 'Naam',

	altDel: '-',
	altAdd: '+',
	altValueHandler: '>',	/* opening URL, calling phone number, ... */

	txtCustom: '» specifiek',
	pholderCustomVal: 'specifiek',

	txtDates: 'Data',
	txtDatesAnniversary: 'Verjaardag',
	txtDatesOther: 'anders',

	txtPhone: 'Telefoon',
	txtPhoneWork: 'werk',
	txtPhoneHome: 'privé',
	txtPhoneCell: 'mobiel',
	txtPhoneCellWork: 'mobiel werk',
	txtPhoneCellHome: 'mobiel privé',
	txtPhoneMain: 'primair',
	txtPhonePager: 'pager',
	txtPhoneFax: 'fax',
	txtPhoneFaxWork: 'fax werk',
	txtPhoneFaxHome: 'fax privé',
	txtPhoneIphone: 'iPhone',
	txtPhoneOther: 'anders',
	pholderPhoneVal: 'Telefoonnummer',

	txtEmail: 'E-mail',
	txtEmailWork: 'werk',
	txtEmailHome: 'privé',
	txtEmailMobileme: 'mobileMe',
	txtEmailOther: 'anders',
	pholderEmailVal: 'E-mail',

	txtUrl: 'Webstek',
	txtUrlWork: 'werk',
	txtUrlHome: 'privé',
	txtUrlHomepage: 'homepage',
	txtUrlOther: 'anders',
	pholderUrlVal: 'URL',

	txtRelated: 'Relaties',
	txtRelatedFather: 'vader',
	txtRelatedMother: 'moeder',
	txtRelatedParent: 'ouder',
	txtRelatedBrother: 'broer',
	txtRelatedSister: 'zus',
	txtRelatedChild: 'kind',
	txtRelatedFriend: 'vriend',
	txtRelatedSpouse: 'echtgeno(o)t(e)',
	txtRelatedPartner: 'partner',
	txtRelatedAssistant: 'assistent',
	txtRelatedManager: 'manager',
	txtRelatedOther: 'anders',
	pholderRelatedVal: 'Naam',

	txtIm: 'Instant Messaging',
	txtImWork: 'werk',
	txtImHome: 'privé',
	txtImMobileme: 'mobileMe',
	txtImOther: 'anders',
	txtImProtAim: 'AIM',
	txtImProtIcq: 'ICQ',
	txtImProtIrc: 'IRC',
	txtImProtJabber: 'Jabber',
	txtImProtMsn: 'MSN',
	txtImProtYahoo: 'Yahoo',
	txtImProtFacebook: 'Facebook',
	txtImProtGadugadu: 'GaduGadu',
	txtImProtGoogletalk: 'GoogleTalk',
	txtImProtQq: 'QQ',
	txtImProtSkype: 'Skype',
	pholderImVal: 'UserID',

	txtProfile: 'Profiel',
	txtProfileTwitter: 'twitter',
	txtProfileFacebook: 'facebook',
	txtProfileFlickr: 'flickr',
	txtProfileLinkedin: 'linkedin',
	txtProfileMyspace: 'myspace',
	txtProfileSinaweibo: 'sina weibo',
	pholderProfileVal: 'UserName',

	txtAddress: 'Adres',
	txtAddressWork: 'werk',
	txtAddressHome: 'privé',
	txtAddressOther: 'anders',
	// address fields are handled specially

	txtCategories: 'Categorieën',
	// categories' values are handled specially

	pholderNoteVal: 'Tekst',

	buttonDeleteFromGroup: 'Uit de groep verwijderen',

	/* common.js - address field names */
	pholderAddressCity: 'Plaats',
	pholderAddressPostalCode: 'Postcode',
	pholderAddressStreet: 'Straat',
	pholderAddressCityRegion: 'Plaats/Regio',
	pholderAddressCounty: 'Landsdeel',
	pholderAddressCountyCity: 'Landsdeel/City',
	pholderAddressDepartment: 'Departement',
	pholderAddressDistrict: 'District',
	pholderAddressDistrictSubdivision: 'District/Onderdeel',
	pholderAddressFurtherDivisions: 'Andere onderdelen',
	pholderAddressGovernorate: 'Deelstaat',
	pholderAddressIslandName: 'Eiland',
	pholderAddressPinCode: 'PIN Code',
	pholderAddressPostCode: 'Postcode',
	pholderAddressPostal: 'Post',
	pholderAddressPostalDistrict: 'Postdistrict',
	pholderAddressPrefecture: 'Prefectuur',
	pholderAddressProvince: 'Provincie',
	pholderAddressRegion: 'Regio',
	pholderAddressState: 'Staat',
	pholderAddressSuburb: 'Stadsdeel',
	pholderAddressTownshipDistrict: 'Stad/District',
	pholderAddressZip: 'PC',

	/* data_process.js */
	addCategory: 'AddCategory',

	/* addressbook.js */
	contactConcurrentChange: 'Dit contact was op de server gewijzigd en is opnieuw opgehaald',
	contactRfcNotCompliant: 'Fout: Dit contact (vCard) is niet conform de RFC 2426 richtlijn',

	/* interface.js */
	loadingAddressbooks: 'Adresboeken worden geladen (%act% van %total%) ...',
	unloadingAddressbooks: 'Vrijgeven adresboeken ...',

	/* webdav_protocol.js */
	succContactSaved: 'Contact opgeslagen',
	succContactDeleted: 'Contact verwijderd',
	succContactDeletedFromGroup: 'Contact verwijderd uit de huidige contact groep',
	errUnableLockBegin: 'Fout: Exclusieve toegang kan niet worden gerealiseerd: %%',
	errUnableUnlockBegin: 'Fout: Exclusieve toegang kan niet worden opgeheven: %%',
	errUnableSaveBegin: 'Fout: Het contact kan niet worden opgeslagen: %%',
	errUnableSaveInvalidData: 'Fout: Corrigeer eerst de aangegeven waarden',
	errUnableDeleteBegin: 'Fout: Het contact kan niet worden verwijderd: %%',
	errResourceLocked: 'Dit contact is (tijdelijk) in gebruik',
	errHttp410: 'Dit contact is niet langer beschikbaar op de server',
	errContactHidden: 'Dit contact is niet ter inzage'
};

localizationCardDAV['sk_SK']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	/* index.html */
	altAddContact: 'Pridať kontakt',
	altPhoto: 'Fotka',
	txtAddressbook: 'Adresár',
	txtAddressbooks: 'Adresáre',
	txtVcardGroupsTextSingle: '%coll% [+ 1 skupina]',
	txtVcardGroupsTextMulti: '%coll% [+ %n% skupiny]',
	txtEnabledAddressbooks: 'Zapnuté Adresáre',
	txtCompanies: 'Firmy',
	txtContact: 'Kontakt',
	pholderNickname: 'Prezývka',
	pholderPhGiven: 'Meno foneticky',
	pholderPhFamily: 'Priezvisko foneticky',
	pholderBday: 'Narodeniny',
	pholderDate: 'Dátum',
	pholderTitle: 'Pozícia',
	pholderOrg: 'Spoločnosť',
	pholderDepartment: 'Oddelenie',
	txtCompanyContact: 'Kontakt na spoločnosť',
	txtRemoteImage: 'URL vzdialeného obrázku',
	txtName: 'Meno',

	altDel: '-',
	altAdd: '+',
	altValueHandler: '>',	/* opening URL, calling phone number, ... */

	txtCustom: '» vlastné',
	pholderCustomVal: 'vlastné',

	txtDates: 'Dátumy',
	txtDatesAnniversary: 'Výročie',
	txtDatesOther: 'iný',

	txtPhone: 'Telefón',
	txtPhoneWork: 'práca',
	txtPhoneHome: 'domov',
	txtPhoneCell: 'mobil',
	txtPhoneCellWork: 'mobil do práce',
	txtPhoneCellHome: 'mobil domov',
	txtPhoneMain: 'hlavný',
	txtPhonePager: 'pager',
	txtPhoneFax: 'fax',
	txtPhoneFaxWork: 'fax do práce',
	txtPhoneFaxHome: 'fax domov',
	txtPhoneIphone: 'iPhone',
	txtPhoneOther: 'iný',
	pholderPhoneVal: 'Telefón',

	txtEmail: 'Email',
	txtEmailWork: 'práca',
	txtEmailHome: 'domov',
	txtEmailMobileme: 'mobileMe',
	txtEmailOther: 'iný',
	pholderEmailVal: 'Email',

	txtUrl: 'Web',
	txtUrlWork: 'práca',
	txtUrlHome: 'domov',
	txtUrlHomepage: 'web',
	txtUrlOther: 'iný',
	pholderUrlVal: 'URL',

	txtRelated: 'Súvisiaci',
	txtRelatedFather: 'otec',
	txtRelatedMother: 'matka',
	txtRelatedParent: 'rodič',
	txtRelatedBrother: 'brat',
	txtRelatedSister: 'sestra',
	txtRelatedChild: 'dieťa',
	txtRelatedFriend: 'priateľ',
	txtRelatedSpouse: 'druh/družka',
	txtRelatedPartner: 'partner/ka',
	txtRelatedAssistant: 'asistent',
	txtRelatedManager: 'manažér',
	txtRelatedOther: 'iný',
	pholderRelatedVal: 'Meno',

	txtIm: 'IM účet',
	txtImWork: 'práca',
	txtImHome: 'domov',
	txtImMobileme: 'mobileMe',
	txtImOther: 'iný',
	txtImProtAim: 'AIM',
	txtImProtIcq: 'ICQ',
	txtImProtIrc: 'IRC',
	txtImProtJabber: 'Jabber',
	txtImProtMsn: 'MSN',
	txtImProtYahoo: 'Yahoo',
	txtImProtFacebook: 'Facebook',
	txtImProtGadugadu: 'GaduGadu',
	txtImProtGoogletalk: 'GoogleTalk',
	txtImProtQq: 'QQ',
	txtImProtSkype: 'Skype',
	pholderImVal: 'Meno',

	txtProfile: 'Profil',
	txtProfileTwitter: 'twitter',
	txtProfileFacebook: 'facebook',
	txtProfileFlickr: 'flickr',
	txtProfileLinkedin: 'linkedin',
	txtProfileMyspace: 'myspace',
	txtProfileSinaweibo: 'sina weibo',
	pholderProfileVal: 'Meno',

	txtAddress: 'Adresa',
	txtAddressWork: 'práca',
	txtAddressHome: 'domov',
	txtAddressOther: 'iný',
	// address fields are handled specially

	txtCategories: 'Kategórie',
	// categories' values are handled specially

	pholderNoteVal: 'Text',

	buttonDeleteFromGroup: 'Vymazať zo skupiny',

	/* common.js - address field names */
	pholderAddressCity: 'Mesto',
	pholderAddressCityRegion: 'Mesto/Región',
	pholderAddressCounty: 'Kraj',
	pholderAddressCountyCity: 'Kraj/Mesto',
	pholderAddressDepartment: 'Oddelenie',
	pholderAddressDistrict: 'Okres',
	pholderAddressDistrictSubdivision: 'Okres',
	pholderAddressFurtherDivisions: 'Ďaľšie územné celky',
	pholderAddressGovernorate: 'Gubernia',
	pholderAddressIslandName: 'Názov ostrova',
	pholderAddressPinCode: 'PIN kód',
	pholderAddressPostCode: 'PSČ',
	pholderAddressPostal: 'PSČ',
	pholderAddressPostalCode: 'PSČ',
	pholderAddressPostalDistrict: 'Poštový okrsok',
	pholderAddressPrefecture: 'Prefektúra',
	pholderAddressProvince: 'Provincia',
	pholderAddressRegion: 'Región',
	pholderAddressState: 'Štát',
	pholderAddressStreet: 'Ulica',
	pholderAddressSuburb: 'Predmestie',
	pholderAddressTownshipDistrict: 'Obvod/Okres',
	pholderAddressZip: 'PSČ',

	/* data_process.js */
	addCategory: 'Pridať kategóriu',

	/* addressbook.js */
	contactConcurrentChange: 'Kontakt bol zmenený na serveri a opätovne načítaný!',
	contactRfcNotCompliant: 'Chyba: tento kontakt (vCard) nie je v súlade so štandardom RFC 2426!',

	/* interface.js */
	loadingAddressbooks: 'Načítavanie adresárov (%act% z %total%) ...',
	unloadingAddressbooks: 'Odčítavanie adresárov ...',

	/* webdav_protocol.js */
	succContactSaved: 'Kontakt úspešne uložený!',
	succContactDeleted: 'Kontakt úspešne vymazaný!',
	succContactDeletedFromGroup: 'Kontakt úspešne vymazaný z aktívnej skupiny kontaktov!',
	errUnableLockBegin: 'Chyba: \'nepodarilo sa zamknúť prostriedok\': %%!',
	errUnableUnlockBegin: 'Chyba: \'nepodarilo sa odomknúť prostriedok\': %%!',
	errUnableSaveBegin: 'Chyba: \'nepodarilo sa uložiť kontakt\': %%!',
	errUnableSaveInvalidData: 'Chyba: \'nemožno uložiť\': opravte zvýraznené neplatné hodnoty!',
	errUnableDeleteBegin: 'Chyba: \'nepodarilo sa vymazať kontakt\': %%!',
	errResourceLocked: 'prostriedok je práve zamknutý',
	errHttp410: 'kontakt už nie je dostupný na serveri',
	errContactHidden: 'Upozornenie: tento kontakt momentálne nie je viditeľný v zozname kontaktov!'
};

localizationCardDAV['tr_TR']=	/* thanks Selcuk Pultar */
{
	/* index.html */
	altAddContact: 'İrtibat Ekle',
	altPhoto: 'Resim',
	txtAddressbook: 'Adres Rehberi',
	txtAddressbooks: 'Adres Rehberleri',
	txtVcardGroupsTextSingle: '%coll% [+ 1 grup]',
	txtVcardGroupsTextMulti: '%coll% [+ %n% grup]',
	txtEnabledAddressbooks: 'Etkin Adres Rehberleri',
	txtCompanies: 'Şirketler',
	txtContact: 'İrtibat',
	pholderPhGiven: 'Fonetik Adı',
	pholderPhFamily: 'Fonetik Soyadı',
	pholderBday: 'Doğum Günü',
	pholderDate: 'Tarih',
	pholderTitle: 'Ünvanı',
	pholderOrg: 'Şirketi',
	pholderDepartment: 'Bölümü',
	txtCompanyContact: 'Şirket İrtibatı',
	txtRemoteImage: 'Uzak Resim URLsi',
	txtName: 'Isim',

	altDel: '-',
	altAdd: '+',
	altValueHandler: '>',	/* opening URL, calling phone number, ... */

	txtCustom: '» özel',
	pholderCustomVal: 'özel',

	txtDates: 'Tarihler',
	txtDatesAnniversary: 'Yıldönümü',
	txtDatesOther: 'diğer',

	txtPhone: 'Telefon',
	txtPhoneWork: 'iş',
	txtPhoneHome: 'ev',
	txtPhoneCell: 'cep',
	txtPhoneCellWork: 'iş cep',
	txtPhoneCellHome: 'ev cep',
	txtPhoneMain: 'merkez',
	txtPhonePager: 'çağrı cihazı',
	txtPhoneFax: 'faks',
	txtPhoneFaxWork: 'iş faks',
	txtPhoneFaxHome: 'ev faks',
	txtPhoneIphone: 'iPhone',
	txtPhoneOther: 'diğer',
	pholderPhoneVal: 'Telefon',

	txtEmail: 'Eposta',
	txtEmailWork: 'iş',
	txtEmailHome: 'ev',
	txtEmailMobileme: 'mobileMe',
	txtEmailOther: 'diğer',
	pholderEmailVal: 'Eposta',

	txtUrl: 'URL',
	txtUrlWork: 'is',
	txtUrlHome: 'ev',
	txtUrlHomepage: 'anasayfa',
	txtUrlOther: 'diğer',
	pholderUrlVal: 'URL',

	txtRelated: 'İlişkili',
	txtRelatedFather: 'baba',
	txtRelatedMother: 'anne',
	txtRelatedParent: 'ebeveyin',
	txtRelatedBrother: 'ağabey',
	txtRelatedSister: 'abla',
	txtRelatedChild: 'çocuk',
	txtRelatedFriend: 'arkadaş',
	txtRelatedSpouse: 'eş',
	txtRelatedPartner: 'ortağı',
	txtRelatedAssistant: 'asistanı',
	txtRelatedManager: 'yöneticisi',
	txtRelatedOther: 'diğer',
	pholderRelatedVal: 'Adı',

	txtIm: 'IM',
	txtImWork: 'iş',
	txtImHome: 'ev',
	txtImMobileme: 'mobileMe',
	txtImOther: 'diğer',
	txtImProtAim: 'AIM',
	txtImProtIcq: 'ICQ',
	txtImProtIrc: 'IRC',
	txtImProtJabber: 'Jabber',
	txtImProtMsn: 'MSN',
	txtImProtYahoo: 'Yahoo',
	txtImProtFacebook: 'Facebook',
	txtImProtGadugadu: 'GaduGadu',
	txtImProtGoogletalk: 'GoogleTalk',
	txtImProtQq: 'QQ',
	txtImProtSkype: 'Skype',
	pholderImVal: 'Kullanıcı Adı',

	txtProfile: 'Profil',
	txtProfileTwitter: 'twitter',
	txtProfileFacebook: 'facebook',
	txtProfileFlickr: 'flickr',
	txtProfileLinkedin: 'linkedin',
	txtProfileMyspace: 'myspace',
	txtProfileSinaweibo: 'sina weibo',
	pholderProfileVal: 'KulllanıcıAdı',

	txtAddress: 'Adres',
	txtAddressWork: 'iş',
	txtAddressHome: 'ev',
	txtAddressOther: 'diğer',
	// address fields are handled specially

	txtCategories: 'Kategoriler',
	// categories' values are handled specially

	pholderNoteVal: 'Not Metni',

	buttonDeleteFromGroup: 'Gruptan sil',

	/* common.js - address field names */
	pholderAddressCity: 'Şehir',
	pholderAddressCityRegion: 'Şehir/Bölge',
	pholderAddressCounty: 'Kaza',
	pholderAddressCountyCity: 'Kaza/Şehir',
	pholderAddressDepartment: 'Bölüm',
	pholderAddressDistrict: 'Bölge',
	pholderAddressDistrictSubdivision: 'Bölge/Altbölüm',
	pholderAddressFurtherDivisions: 'İlave Altbölüm',
	pholderAddressGovernorate: 'Vilayet',
	pholderAddressIslandName: 'Ada İsmi',
	pholderAddressPinCode: 'PIN Kodu',
	pholderAddressPostCode: 'Posta Kodu',
	pholderAddressPostal: 'Posta',
	pholderAddressPostalCode: 'Posta Kodu',
	pholderAddressPostalDistrict: 'Posta Bölgesi',
	pholderAddressPrefecture: 'Vilayet',
	pholderAddressProvince: 'Vilayet',
	pholderAddressRegion: 'Bölge',
	pholderAddressState: 'Eyalet',
	pholderAddressStreet: 'Sokak',
	pholderAddressSuburb: 'Banliyö',
	pholderAddressTownshipDistrict: 'İlçe/Bölge',
	pholderAddressZip: 'Posta Kodu',

	/* data_process.js */
	addCategory: 'Kategori Ekle',

	/* addressbook.js */
	contactConcurrentChange: 'Sunucudaki irtibat değiştirilmiş ve yeniden yüklenmiş!',
	contactRfcNotCompliant: 'Hata: bu irtibat (vCard) RFC 2426 ile uyumlu değil!',

	/* interface.js */
	loadingAddressbooks: 'Adres rehberleri yükleniyor (%total% taneden %act%) ...',
	unloadingAddressbooks: 'Adres Rehberleri kaldırılıyor ...',

	/* webdav_protocol.js */
	succContactSaved: 'İrtibat başarıyla kaydedildi!',
	succContactDeleted: 'İrtibat başarıyla silindi!',
	succContactDeletedFromGroup: 'İrtibat aktif irtibat grubundan başarıyla silindi!',
	errUnableLockBegin: 'Hata: \'kaynak kilitlenemiyor\': %%!',
	errUnableUnlockBegin: 'Hata: \'kaynağın kilidi açılamıyor\': %%!',
	errUnableSaveBegin: 'Hata: \'irtibat kaydedilemiyor\': %%!',
	errUnableSaveInvalidData: 'Hata: \'kaydedilemiyor\': renklendirilmiş yanlış değerleri düzeltin!',
	errUnableDeleteBegin: 'Hata: \'irtibat silinemiyor\': %%!',
	errResourceLocked: 'kaynak zaten kilitli',
	errHttp410: 'irtibat artık sunucuda mevcut değil',
	errContactHidden: 'Not: Bu irtibat halihazırda görünür irtibat listesinde değil!'
};

localizationCardDAV['ru_RU']=	/* thanks Александр Симонов */
{
	/* index.html */
	altAddContact: 'Новый контакт',
	altPhoto: 'Фото',
	txtAddressbook: 'Адресная книга',
	txtAddressbooks: 'Адресные книги',
	txtVcardGroupsTextSingle: '%coll% [+ 1 группа]',
	txtVcardGroupsTextMulti: '%coll% [+ %n% групп(ы)]',
	txtEnabledAddressbooks: 'Включенные книги',
	txtCompanies: 'Организации',
	txtContact: 'Контакт',
	pholderPhGiven: 'Простое имя',
	pholderPhFamily: 'Простая фамилия',
	pholderBday: 'Дата рождения',
	pholderDate: 'Дата',
	pholderTitle: 'Должность',
	pholderOrg: 'Организация',
	pholderDepartment: 'Отдел',
	txtCompanyContact: 'Контакт организации',
	txtRemoteImage: 'Адрес URL изображения',
	txtName: 'Имя',

	altDel: '-',
	altAdd: '+',
	altValueHandler: '>',	/* opening URL, calling phone number, ... */

	txtCustom: 'указать...',
	pholderCustomVal: 'название',

	txtDates: 'Даты',
	txtDatesAnniversary: 'Юбилейная дата',
	txtDatesOther: 'другой',

	txtPhone: 'Телефон',
	txtPhoneWork: 'рабочий',
	txtPhoneHome: 'домашний',
	txtPhoneCell: 'мобильный',
	txtPhoneCellWork: 'рабочий мобильный',
	txtPhoneCellHome: 'личный мобильный',
	txtPhoneMain: 'основной',
	txtPhonePager: 'пейджер',
	txtPhoneFax: 'факс',
	txtPhoneFaxWork: 'рабочий факс',
	txtPhoneFaxHome: 'личный факс',
	txtPhoneIphone: 'iPhone',
	txtPhoneOther: 'другой',
	pholderPhoneVal: 'Телефон',

	txtEmail: 'Электронная почта',
	txtEmailWork: 'рабочая',
	txtEmailHome: 'личная',
	txtEmailMobileme: 'mobileMe',
	txtEmailOther: 'другая',
	pholderEmailVal: 'Электронная почта',

	txtUrl: 'Сайт',
	txtUrlWork: 'рабочий',
	txtUrlHome: 'личный',
	txtUrlHomepage: 'домашняя страница',
	txtUrlOther: 'другой',
	pholderUrlVal: 'Сайт',

	txtRelated: 'Родственники/знакомые',
	txtRelatedFather: 'отец',
	txtRelatedMother: 'мать',
	txtRelatedParent: 'родитель',
	txtRelatedBrother: 'брат',
	txtRelatedSister: 'сестра',
	txtRelatedChild: 'ребенок',
	txtRelatedFriend: 'друг',
	txtRelatedSpouse: 'супруг(а)',
	txtRelatedPartner: 'партнер',
	txtRelatedAssistant: 'помощник',
	txtRelatedManager: 'менеджер',
	txtRelatedOther: 'другой',
	pholderRelatedVal: 'Имя',

	txtIm: 'Мессенджеры',
	txtImWork: 'рабочий',
	txtImHome: 'личный',
	txtImMobileme: 'mobileMe',
	txtImOther: 'другой',
	txtImProtAim: 'AIM',
	txtImProtIcq: 'ICQ',
	txtImProtIrc: 'IRC',
	txtImProtJabber: 'Jabber',
	txtImProtMsn: 'MSN',
	txtImProtYahoo: 'Yahoo',
	txtImProtFacebook: 'Facebook',
	txtImProtGadugadu: 'GaduGadu',
	txtImProtGoogletalk: 'GoogleTalk',
	txtImProtQq: 'QQ',
	txtImProtSkype: 'Skype',
	pholderImVal: 'Идентификатор',

	txtProfile: 'Социальные сети',
	txtProfileTwitter: 'twitter',
	txtProfileFacebook: 'facebook',
	txtProfileFlickr: 'flickr',
	txtProfileLinkedin: 'linkedin',
	txtProfileMyspace: 'myspace',
	txtProfileSinaweibo: 'sina weibo',
	pholderProfileVal: 'Имя в социальной сети',

	txtAddress: 'Адрес',
	txtAddressWork: 'рабочий',
	txtAddressHome: 'домашний',
	txtAddressOther: 'другой',
	// address fields are handled specially

	txtCategories: 'Категории',
	// categories' values are handled specially

	pholderNoteVal: 'Примечание',

	buttonDeleteFromGroup: 'Удалить из группы',

	/* common.js - address field names */
	pholderAddressCity: 'Город',
	pholderAddressCityRegion: 'Город/регион',
	pholderAddressCounty: 'Область',
	pholderAddressCountyCity: 'Область/район',
	pholderAddressDepartment: 'Адм. единица',
	pholderAddressDistrict: 'Округ',
	pholderAddressDistrictSubdivision: 'Округ/муниципалитет',
	pholderAddressFurtherDivisions: 'Другие подразделения',
	pholderAddressGovernorate: 'Правление',
	pholderAddressIslandName: 'Остров',
	pholderAddressPinCode: 'ПИН-код',
	pholderAddressPostCode: 'Почтовый индекс',
	pholderAddressPostal: 'Почтовый индекс',
	pholderAddressPostalCode: 'Почтовый индекс',
	pholderAddressPostalDistrict: 'Почтовый округ',
	pholderAddressPrefecture: 'Префектура',
	pholderAddressProvince: 'Область',
	pholderAddressRegion: 'Регион',
	pholderAddressState: 'Штат',
	pholderAddressStreet: 'Улица',
	pholderAddressSuburb: 'Пригород',
	pholderAddressTownshipDistrict: 'Город',
	pholderAddressZip: 'Почтовый индекс',

	/* data_process.js */
	addCategory: 'Новая категория',

	/* addressbook.js */
	contactConcurrentChange: 'Контакт был изменен на сервере и перезагружен!',
	contactRfcNotCompliant: 'Ошибка: этот контакт (vCard) не соответствует RFC 2426!',

	/* interface.js */
	loadingAddressbooks: 'Загрузка адресных книг (%act% из %total%)...',
	unloadingAddressbooks: 'Выгружаю адресные книги ...',

	/* webdav_protocol.js */
	succContactSaved: 'Контакт успешно сохранен!',
	succContactDeleted: 'Контакт успешно удален!',
	succContactDeletedFromGroup: 'Контакт успешно удален из активной группы!',
	errUnableLockBegin: 'Ошибка: \'не могу заблокировать ресурс\': %%!',
	errUnableUnlockBegin: 'Ошибка: \'не могу разблокировать ресурс\': %%!',
	errUnableSaveBegin: 'Ошибка: \'не могу сохранить контакт\': %%!',
	errUnableSaveInvalidData: 'Ошибка: \'не могу сохранить контакт\': исправьте неверные значения!',
	errUnableDeleteBegin: 'Ошибка: \'не могу удалить контакт\': %%!',
	errResourceLocked: 'ресурс уже заблокирован',
	errHttp410: 'контакт более не существует на сервере',
	errContactHidden: 'Внимание: сейчас этот контакт не виден в списке контактов!'
};

localizationCardDAV['uk_UA']=	/* Serge Yakimchuck <yakim@yakim.org.ua */
{
	/* index.html */
	altAddContact: 'Додати контакт',
	altPhoto: 'Фото',
	txtAddressbook: 'Адресна книга',
	txtAddressbooks: 'Адресні книги',
	txtVcardGroupsTextSingle: '%coll% [+ 1 група]',
	txtVcardGroupsTextMulti: '%coll% [+ %n% групи]',
	txtEnabledAddressbooks: 'Увімкнути адресні книги',
	txtCompanies: 'Компанії',
	txtContact: 'Контакт',
	pholderNickname: 'Псевдо',
	pholderPhGiven: 'Вимова імені',
	pholderPhFamily: 'Вимова прізвища',
	pholderBday: 'День народження',
	pholderDate: 'Дата',
	pholderTitle: 'Посада',
	pholderOrg: 'Компанія',
	pholderDepartment: 'Відділ',
	txtCompanyContact: 'Контакт компанії',
	txtRemoteImage: 'Посилання на віддалене зображення',
	txtName: 'Назва',

	altDel: '-',
	altAdd: '+',
	altValueHandler: '>',	/* opening URL, calling phone number, ... */

	txtCustom: '» вказати',
	pholderCustomVal: 'вказати',

	txtDates: 'Дати',
	txtDatesAnniversary: 'Ювілей',
	txtDatesOther: 'інший',

	txtPhone: 'Телефон',
	txtPhoneWork: 'робочий',
	txtPhoneHome: 'домашній',
	txtPhoneCell: 'мобільний',
	txtPhoneCellWork: 'робочий мобільний',
	txtPhoneCellHome: 'домашній мобільний',
	txtPhoneMain: 'основний',
	txtPhonePager: 'пейджер',
	txtPhoneFax: 'факс',
	txtPhoneFaxWork: 'робочий факс',
	txtPhoneFaxHome: 'домашній факс',
	txtPhoneIphone: 'iPhone',
	txtPhoneOther: 'інший',
	pholderPhoneVal: 'Телефон',

	txtEmail: 'Ел. адреса',
	txtEmailWork: 'робоча',
	txtEmailHome: 'домашня',
	txtEmailMobileme: 'mobileMe',
	txtEmailOther: 'інша',
	pholderEmailVal: 'Ел. адреса',

	txtUrl: 'Сайт',
	txtUrlWork: 'робочий',
	txtUrlHome: 'домашній',
	txtUrlHomepage: 'домашня сторінка',
	txtUrlOther: 'інший',
	pholderUrlVal: 'Сайт',

	txtRelated: 'Відношення',
	txtRelatedFather: 'батько',
	txtRelatedMother: 'мати',
	txtRelatedParent: 'один з батьків',
	txtRelatedBrother: 'брат',
	txtRelatedSister: 'сестра',
	txtRelatedChild: 'дитина',
	txtRelatedFriend: 'товариш',
	txtRelatedSpouse: 'подружжя',
	txtRelatedPartner: 'партнер',
	txtRelatedAssistant: 'асистент',
	txtRelatedManager: 'менеджер',
	txtRelatedOther: 'інше',
	pholderRelatedVal: 'Ім\'я',

	txtIm: 'IM',
	txtImWork: 'робочий',
	txtImHome: 'домашній',
	txtImMobileme: 'mobileMe',
	txtImOther: 'інше',
	txtImProtAim: 'AIM',
	txtImProtIcq: 'ICQ',
	txtImProtIrc: 'IRC',
	txtImProtJabber: 'Jabber',
	txtImProtMsn: 'MSN',
	txtImProtYahoo: 'Yahoo',
	txtImProtFacebook: 'Facebook',
	txtImProtGadugadu: 'GaduGadu',
	txtImProtGoogletalk: 'GoogleTalk',
	txtImProtQq: 'QQ',
	txtImProtSkype: 'Skype',
	pholderImVal: 'UserID',

	txtProfile: 'Профіль',
	txtProfileTwitter: 'twitter',
	txtProfileFacebook: 'facebook',
	txtProfileFlickr: 'flickr',
	txtProfileLinkedin: 'linkedin',
	txtProfileMyspace: 'myspace',
	txtProfileSinaweibo: 'sina weibo',
	pholderProfileVal: 'Ім\'я',

	txtAddress: 'Адреса',
	txtAddressWork: 'робоча',
	txtAddressHome: 'домашня',
	txtAddressOther: 'інша',
	// address fields are handled specially

	txtCategories: 'Категорії',
	// categories' values are handled specially

	pholderNoteVal: 'Примітка',

	buttonDeleteFromGroup: 'Видалити з групи',

	/* common.js - address field names */
	pholderAddressCity: 'Місто',
	pholderAddressCityRegion: 'Місто/Регіон',
	pholderAddressCounty: 'Держава',
	pholderAddressCountyCity: 'Держава/Місто',
	pholderAddressDepartment: 'Департамент',
	pholderAddressDistrict: 'Район',
	pholderAddressDistrictSubdivision: 'Район/Підрозділ',
	pholderAddressFurtherDivisions: 'Подальший поділ',
	pholderAddressGovernorate: 'Губернаторство',
	pholderAddressIslandName: 'Острів',
	pholderAddressPinCode: 'PIN код',
	pholderAddressPostCode: 'Поштовий індекс',
	pholderAddressPostal: 'Поштовий', //postal
	pholderAddressPostalCode: 'Поштовий код',
	pholderAddressPostalDistrict: 'Поштовий підрозділ',
	pholderAddressPrefecture: 'Префектура',
	pholderAddressProvince: 'Провінція',
	pholderAddressRegion: 'Регіон',
	pholderAddressState: 'Штат',
	pholderAddressStreet: 'Вулиця',
	pholderAddressSuburb: 'Передмістя',
	pholderAddressTownshipDistrict: 'Містечко/Район',
	pholderAddressZip: 'ZIP',

	/* data_process.js */
	addCategory: 'Додати категорію',

	/* addressbook.js */
	contactConcurrentChange: 'Контакт на сервері було змінено та перезавантажено!',
	contactRfcNotCompliant: 'Помилка: Цей контакт (vCard) не відповідає RFC 2426!',

	/* interface.js */
	loadingAddressbooks: 'Завантаження адресних книг (%act% з %total%) ...',
	unloadingAddressbooks: 'Вивантажити адресні книги ...',

	/* webdav_protocol.js */
	succContactSaved: 'Контакт успішно збережено!',
	succContactDeleted: 'Контакт успішно видалено!',
	succContactDeletedFromGroup: 'Контакт успішно видалено з активної групи контактів!',
	errUnableLockBegin: 'Помилка: \'неможливо заблокувати ресурс\': %%!',
	errUnableUnlockBegin: 'Помилка: \'неможливо розблокувати ресурс\': %%!',
	errUnableSaveBegin: 'Помилка: \'неможливо зберегти контакт\': %%!',
	errUnableSaveInvalidData: 'Помилка: \'неможливо зберегти\': виправіть підсвічені неправильні значення!',
	errUnableDeleteBegin: 'Помилка: \'неможливо втдалити контакт\': %%!',
	errResourceLocked: 'ресурс вже заблокований',
	errHttp410: 'контакт більше недоступний на сервері',
	errContactHidden: 'Примітка: цей контакт зараз невидимий в контакт-листі!'
};

localizationCardDAV['zh_CN']=	/* thanks Fandy */
{
	/* index.html */
	altAddContact: '新增联系方式',
	altPhoto: '照片',
	txtAddressbook: '通讯录',
	txtAddressbooks: '通讯录',
	txtVcardGroupsTextSingle: '%coll% [+ 1 group]',
	txtVcardGroupsTextMulti: '%coll% [+ %n% groups]',
	txtEnabledAddressbooks: '可选联系簿',
	txtCompanies: '公司',
	txtContact: '联系方式',
	pholderNickname: '昵称',
	pholderPhGiven: '曾用名',
	pholderPhFamily: '曾用姓',
	pholderBday: '生日',
	pholderDate: '日期',
	pholderTitle: '职务',
	pholderOrg: '单位',
	pholderDepartment: '部门',
	txtCompanyContact: '单位联系方式',
	txtRemoteImage: '远程图像url',
	txtName: '单位名称',

	altDel: '-',
	altAdd: '+',
	altValueHandler: '>',	/* opening URL, calling phone number, ... */

	txtCustom: '» 定制',
	pholderCustomVal: '定制',

	txtDates: '日期',
	txtDatesAnniversary: '纪念日',
	txtDatesOther: '其他',

	txtPhone: '电话',
	txtPhoneWork: '工作',
	txtPhoneHome: '家庭',
	txtPhoneCell: '手机',
	txtPhoneCellWork: '工作手机',
	txtPhoneCellHome: '家庭手机',
	txtPhoneMain: '主要',
	txtPhonePager: '呼机',
	txtPhoneFax: '传真',
	txtPhoneFaxWork: '工作传真',
	txtPhoneFaxHome: '家庭传真',
	txtPhoneIphone: 'iPhone',
	txtPhoneOther: '其它',
	pholderPhoneVal: '电话',

	txtEmail: '邮件',
	txtEmailWork: '工作邮件',
	txtEmailHome: '家庭邮件',
	txtEmailMobileme: 'mobileMe',
	txtEmailOther: '其它',
	pholderEmailVal: '邮件',

	txtUrl: 'URL',
	txtUrlWork: '工作URl',
	txtUrlHome: '家庭URL',
	txtUrlHomepage: '主页',
	txtUrlOther: '其它',
	pholderUrlVal: 'URL',

	txtRelated: '家庭成员',
	txtRelatedFather: '父亲',
	txtRelatedMother: '母亲',
	txtRelatedParent: '父母',
	txtRelatedBrother: '兄弟',
	txtRelatedSister: '姐妹',
	txtRelatedChild: '子女',
	txtRelatedFriend: '朋友',
	txtRelatedSpouse: '配偶',
	txtRelatedPartner: '伙伴',
	txtRelatedAssistant: '助理',
	txtRelatedManager: '上司',
	txtRelatedOther: '其它',
	pholderRelatedVal: '关系名字',

	txtIm: '即时通讯',
	txtImWork: '工作',
	txtImHome: '家庭',
	txtImMobileme: 'mobileMe',
	txtImOther: '其它',
	txtImProtAim: 'AIM',
	txtImProtIcq: 'ICQ',
	txtImProtIrc: 'IRC',
	txtImProtJabber: 'Jabber',
	txtImProtMsn: 'MSN',
	txtImProtYahoo: 'Yahoo',
	txtImProtFacebook: 'Facebook',
	txtImProtGadugadu: 'GaduGadu',
	txtImProtGoogletalk: 'GoogleTalk',
	txtImProtQq: 'QQ',
	txtImProtSkype: 'Skype',
	pholderImVal: '用户ID',

	txtProfile: '简介',
	txtProfileTwitter: 'twitter',
	txtProfileFacebook: 'facebook',
	txtProfileFlickr: 'flickr',
	txtProfileLinkedin: 'linkedin',
	txtProfileMyspace: 'myspace',
	txtProfileSinaweibo: '新浪微博',
	pholderProfileVal: '用户名',

	txtAddress: '地址',
	txtAddressWork: '工作地址',
	txtAddressHome: '家庭地址',
	txtAddressOther: '其它',
	// address fields are handled specially

	txtCategories: '分类',
	// categories' values are handled specially

	pholderNoteVal: '备注',

	buttonDeleteFromGroup: '从群中删除',

	/* common.js - address field names */
	pholderAddressCity: '市',
	pholderAddressCityRegion: '地区',
	pholderAddressCounty: '县',
	pholderAddressCountyCity: '县级市',
	pholderAddressDepartment: '地址处',
	pholderAddressDistrict: '区',
	pholderAddressDistrictSubdivision: '区/细分区',
	pholderAddressFurtherDivisions: '进一步分裂',
	pholderAddressGovernorate: '省',
	pholderAddressIslandName: '岛屿名称',
	pholderAddressPinCode: 'PIN 码',
	pholderAddressPostCode: '邮政编码',
	pholderAddressPostal: '邮政编码',
	pholderAddressPostalCode: '邮政编码',
	pholderAddressPostalDistrict: '邮政区',
	pholderAddressPrefecture: '县',
	pholderAddressProvince: '省',
	pholderAddressRegion: '地区',
	pholderAddressState: '州',
	pholderAddressStreet: '街道',
	pholderAddressSuburb: '郊区',
	pholderAddressTownshipDistrict: '镇/区',
	pholderAddressZip: '邮政编码',

	/* data_process.js */
	addCategory: '分类',

	/* addressbook.js */
	contactConcurrentChange: '通讯录服务器已更新，请刷新！',
	contactRfcNotCompliant: '错误:通讯录(名片)不符合RFC 2426 规范!',

	/* interface.js */
	loadingAddressbooks: '加载通讯录 (第%act%/共%total%) ...',
	unloadingAddressbooks: '卸载通信录 ...',

	/* webdav_protocol.js */
	succContactSaved: '通信录保存成功!',
	succContactDeleted: '通信录删除成功!',
	succContactDeletedFromGroup: '通信录从组中删除成功!',
	errUnableLockBegin: '错误: \'不能锁定资源\': %%!',
	errUnableUnlockBegin: '错误: \'不能锁定资源\': %%!',
	errUnableSaveBegin: '错误: \'不能保存通讯录\': %%!',
	errUnableSaveInvalidData: '错误: \'不能保存\': 请修正无效的高亮值!',
	errUnableDeleteBegin: '错误: \'不能删除通讯录\': %%!',
	errResourceLocked: '资源已经锁定',
	errHttp410: '通信录不再服务器上',
	errContactHidden: '注意: 联系方式不在通信列表中!'
};

$.extend(true, localization, localizationCardDAV);
