<?php
// URL to CalDAVZap
$config['caldavzap_url'] = 'plugins/caldavzap/caldavzap_0.13.2/roundcube.html';

// Domain for CalDAV server
$config['caldav_server'] = 'sub.domain.com';

// CalDAV Path where the DAV server resides
$config['caldav_path'] = '/dav/calendars/';

// Name for the CalDAV server
$config['caldav_name'] = 'My Calendars';

// This options sets the default calendar view option 
// Supported values:
// - 'month'
// - 'multiWeek'
// - 'agendaWeek'
// - 'agendaDay'
$config['cdz_standardview'] = "agendaWeek";

// Set the datepicker first day of the week: Sunday is 0, Monday is 1, etc.
$config['cdz_weekstart'] = 1;

// These options set the start and end of business hours with 0.5 hour
// precision. Non-business hours are faded out in the calendar interface.
// If both variables are set to the same value then no fade out occurs.
$config['cdz_businesstart'] = 7;
$config['cdz_businessend'] = 15;

// This option sets the 2 days considered as weekend days, these
// are faded out in the calendar interface. Non-weekend days are automatically
// considered as business days.
// Sunday is 0, Monday is 1, etc.
$config['cdz_weekendays'] = "0,6";

// This option enables timezone support in the client.
$config['cdz_tzsupport'] = true;
// Rerite timezone information using the official IANA timezone database information
$config['cdz_rewritetz'] = false;
// Remove unknown timezone information from an event
$config['cdz_removetz'] = false;
$config['cdz_ignserver'] = false;
?>
