const CACHE_NAME = 'caldavzap-cache-v1';
const urlsToCache = [
	'common.min.js',
	'config_rc.js',
	'config.js',
	'data_process.min.js',
	'forms.min.js',
	'interface.min.js',
	'localization.min.js',
	'main_rc.js',
	'main.js',
	'resource.min.js',
	'timezones.min.js',
	'vcalendar.min.js',
	'vcalendar_rfc_regex.min.js',
	'vtodo.min.js',
	'webdav_protocol.min.js',
	'css/default.min.css',
	'css/default_integration.min.css',
	'css/fullcalendar.min.css',
	'css/jquery-ui.custom.min.css',
	'css/spectrum.custom.min.css',
	'css/rc.css',
	'fonts/Roboto-BoldItalic-webfont.eot',
	'fonts/Roboto-BoldItalic-webfont.svg',
	'fonts/Roboto-BoldItalic-webfont.ttf',
	'fonts/Roboto-BoldItalic-webfont.woff',
	'fonts/Roboto-Bold-webfont.eot',
	'fonts/Roboto-Bold-webfont.svg',
	'fonts/Roboto-Bold-webfont.ttf',
	'fonts/Roboto-Bold-webfont.woff',
	'fonts/Roboto-Italic-webfont.eot',
	'fonts/Roboto-Italic-webfont.svg',
	'fonts/Roboto-Italic-webfont.ttf',
	'fonts/Roboto-Italic-webfont.woff',
	'fonts/Roboto-LightItalic-webfont.eot',
	'fonts/Roboto-LightItalic-webfont.svg',
	'fonts/Roboto-LightItalic-webfont.ttf',
	'fonts/Roboto-LightItalic-webfont.woff',
	'fonts/Roboto-Light-webfont.eot',
	'fonts/Roboto-Light-webfont.svg',
	'fonts/Roboto-Light-webfont.ttf',
	'fonts/Roboto-Light-webfont.woff',
	'fonts/Roboto-MediumItalic-webfont.eot',
	'fonts/Roboto-MediumItalic-webfont.svg',
	'fonts/Roboto-MediumItalic-webfont.ttf',
	'fonts/Roboto-MediumItalic-webfont.woff',
	'fonts/Roboto-Medium-webfont.eot',
	'fonts/Roboto-Medium-webfont.svg',
	'fonts/Roboto-Medium-webfont.ttf',
	'fonts/Roboto-Medium-webfont.woff',
	'fonts/Roboto-Regular-webfont.eot',
	'fonts/Roboto-Regular-webfont.svg',
	'fonts/Roboto-Regular-webfont.ttf',
	'fonts/Roboto-Regular-webfont.woff',
	'images/add_cal.svg',
	'images/add_cal_white.svg',
	'images/arrow_next_red.svg',
	'images/arrow_next.svg',
	'images/arrow_prev_red.svg',
	'images/arrow_prev.svg',
	'images/banner_calendar.svg',
	'images/banner_logout.svg',
	'images/banner_refresh.svg',
	'images/banner_todo.svg',
	'images/calendarB.svg',
	'images/cdz_logo.svg',
	'images/cloud.svg',
	'images/delegation.svg',
	'images/dp_left.svg',
	'images/dp_right.svg',
	'images/error_badge.svg',
	'images/error_b.svg',
	'images/error_w.svg',
	'images/in_progress_b.svg',
	'images/in_progress_dr.svg',
	'images/in_progress_r.svg',
	'images/in_progress_w.svg',
	'images/jumper_bottom_b.svg',
	'images/jumper_bottom_w.svg',
	'images/jumper_top_b.svg',
	'images/jumper_top_w.svg',
	'images/loadinfo.gif',
	'images/loadinfo_s1.gif',
	'images/loadinfo_s2.gif',
	'images/loadinfo_s3.gif',
	'images/loadinfo_s4.gif',
	'images/login.svg',
	'images/logout.svg',
	'images/needs_action_b.svg',
	'images/needs_action_dr.svg',
	'images/needs_action_r.svg',
	'images/needs_action_w.svg',
	'images/new_item.svg',
	'images/popupArrow.svg',
	'images/priority-1-dr.svg',
	'images/priority-1-r.svg',
	'images/priority-1.svg',
	'images/priority-1-w.svg',
	'images/priority-2-dr.svg',
	'images/priority-2-r.svg',
	'images/priority-2.svg',
	'images/priority-2-w.svg',
	'images/priority-3-dr.svg',
	'images/priority-3-r.svg',
	'images/priority-3.svg',
	'images/priority-3-w.svg',
	'images/read_only_b.svg',
	'images/read_only_w.svg',
	'images/remove_cal.svg',
	'images/remove_cal_white.svg',
	'images/reset_b.svg',
	'images/reset_dr.svg',
	'images/reset_drw.svg',
	'images/reset_r.svg',
	'images/reset_rw.svg',
	'images/reset_w.svg',
	'images/resource_arrow_down.svg',
	'images/resource_arrow_right.svg',
	'images/resource_arrow_up.svg',
	'images/resources.svg',
	'images/search.svg',
	'images/searchWhiteNew.svg',
	'images/select_bg_black.svg',
	'images/select_bg_dis.svg',
	'images/select_bg.svg',
	'images/select_black.svg',
	'images/select_dis.svg',
	'images/select_login.svg',
	'images/select.svg',
	'images/success_b.svg',
	'images/success_dr.svg',
	'images/success_drw.svg',
	'images/success_r.svg',
	'images/success_rw.svg',
	'images/success_w.svg',
	'images/todoB.svg',
	'lib/fullcalendar.min.js',
	'lib/ie_base64.js',
	'lib/jquery-2.1.4.min.js',
	'lib/jquery.autosize.min.js',
	'lib/jquery.browser.min.js',
	'lib/jquery.placeholder-1.1.9.min.js',
	'lib/jquery.quicksearch.min.js',
	'lib/jquery-ui-1.11.4.custom.min.js',
	'lib/rrule.min.js',
	'lib/sha256.js',
	'lib/spectrum.min.js',
];

self.addEventListener('install', function(event) {
	event.waitUntil(
		caches.open(CACHE_NAME)
			.then(function(cache) {
			return cache.addAll(urlsToCache);
		})
	);
	self.skipWaiting();
});

self.addEventListener('activate', event => {
    var cacheKeeplist = [CACHE_NAME];
    event.waitUntil(caches.keys().then( keyList => {
        return Promise.all(keyList.map( key => {
            if (cacheKeeplist.indexOf(key) === -1) {
                return caches.delete(key);
            }
        }));
    }).then(self.clients.claim()));
});