# install.sh is generated by ./extra/install.batsh, do not modify it directly.
# "npm run compile-install-script" to compile install.sh
# The command is working on Windows PowerShell and Docker for Windows only.
# curl -o kuma_install.sh https://raw.githubusercontent.com/louislam/uptime-kuma/master/install.sh && sudo bash kuma_install.sh
"echo" "-e" "====================="
"echo" "-e" "Uptime Kuma Install Script"
"echo" "-e" "====================="
"echo" "-e" "Supported OS: Ubuntu >= 16.04, Debian and CentOS/RHEL 7/8"
"echo" "-e" "---------------------------------------"
"echo" "-e" "This script is designed for Linux and basic usage."
"echo" "-e" "For advanced usage, please go to https://github.com/louislam/uptime-kuma/wiki/Installation"
"echo" "-e" "---------------------------------------"
"echo" "-e" ""
"echo" "-e" "Local - Install Uptime Kuma on your current machine with git, Node.js and pm2"
"echo" "-e" "Docker - Install Uptime Kuma Docker container"
"echo" "-e" ""
if [ "$1" != "" ]; then
  type="$1"
else
  "read" "-p" "Which installation method do you prefer? [DOCKER/local]: " "type"
fi
defaultPort="3001"
function checkNode {
  local _0
  nodeVersion=$(node -e 'console.log(process.versions.node.split(`.`)[0])')
  "echo" "-e" "Node Version: ""$nodeVersion"
  _0="12"
  if [ $(($nodeVersion <= $_0)) == 1 ]; then
    "echo" "-e" "Error: Required Node.js 14"
    "exit" "1"  
fi
}
function deb {
  nodeCheck=$(node -v)
  apt --yes update
  if [ "$nodeCheck" != "" ]; then
    "checkNode" 
  else
    # Old nodejs binary name is "nodejs"
    check=$(nodejs --version)
    if [ "$check" != "" ]; then
      "echo" "-e" "Error: 'node' command is not found, but 'nodejs' command is found. Your NodeJS should be too old."
      exit 1    
fi
    curlCheck=$(curl --version)
    if [ "$curlCheck" == "" ]; then
      "echo" "-e" "Installing Curl"
      apt --yes install curl    
fi
    "echo" "-e" "Installing Node.js 16"
    curl -sL https://deb.nodesource.com/setup_16.x | bash - > log.txt
    apt --yes install nodejs
    node -v
    nodeCheckAgain=$(node -v)
    if [ "$nodeCheckAgain" == "" ]; then
      "echo" "-e" "Error during Node.js installation"
      exit 1    
fi
  fi
  check=$(git --version)
  if [ "$check" == "" ]; then
    "echo" "-e" "Installing Git"
    apt --yes install git  
fi
}
if [ "$type" == "local" ]; then
  defaultInstallPath="/opt/uptime-kuma"
  if [ -e "/etc/redhat-release" ]; then
    os=$("cat" "/etc/redhat-release")
    distribution="rhel"
  else
    if [ -e "/etc/issue" ]; then
      os=$(head -n1 /etc/issue | cut -f 1 -d ' ')
      if [ "$os" == "Ubuntu" ]; then
        distribution="ubuntu"
        # Get ubuntu version
        . /etc/lsb-release
        version="$DISTRIB_RELEASE"      
fi
      if [ "$os" == "Debian" ]; then
        distribution="debian"      
fi    
fi
  fi
  arch=$(uname -i)
  "echo" "-e" "Your OS: ""$os"
  "echo" "-e" "Distribution: ""$distribution"
  "echo" "-e" "Version: ""$version"
  "echo" "-e" "Arch: ""$arch"
  if [ "$3" != "" ]; then
    port="$3"
  else
    "read" "-p" "Listening Port [$defaultPort]: " "port"
    if [ "$port" == "" ]; then
      port="$defaultPort"    
fi
  fi
  if [ "$2" != "" ]; then
    installPath="$2"
  else
    "read" "-p" "Installation Path [$defaultInstallPath]: " "installPath"
    if [ "$installPath" == "" ]; then
      installPath="$defaultInstallPath"    
fi
  fi
  # CentOS
  if [ "$distribution" == "rhel" ]; then
    nodeCheck=$(node -v)
    if [ "$nodeCheck" != "" ]; then
      "checkNode" 
    else
      dnfCheck=$(dnf --version)
      # Use yum
      if [ "$dnfCheck" == "" ]; then
        curlCheck=$(curl --version)
        if [ "$curlCheck" == "" ]; then
          "echo" "-e" "Installing Curl"
          yum -y -q install curl        
fi
        "echo" "-e" "Installing Node.js 16"
        curl -sL https://rpm.nodesource.com/setup_16.x | bash - > log.txt
        yum install -y -q nodejs
      else
        curlCheck=$(curl --version)
        if [ "$curlCheck" == "" ]; then
          "echo" "-e" "Installing Curl"
          dnf -y install curl        
fi
        "echo" "-e" "Installing Node.js 16"
        curl -sL https://rpm.nodesource.com/setup_16.x | bash - > log.txt
        dnf install -y nodejs
      fi
      node -v
      nodeCheckAgain=$(node -v)
      if [ "$nodeCheckAgain" == "" ]; then
        "echo" "-e" "Error during Node.js installation"
        exit 1      
fi
    fi
    check=$(git --version)
    if [ "$check" == "" ]; then
      "echo" "-e" "Installing Git"
      yum -y -q install git    
fi
    # Ubuntu
  else
    if [ "$distribution" == "ubuntu" ]; then
      "deb" 
      # Debian
    else
      if [ "$distribution" == "debian" ]; then
        "deb" 
      else
        # Unknown distribution
        error=$((0))
        check=$(git --version)
        if [ "$check" == "" ]; then
          error=$((1))
          "echo" "-e" "Error: git is not found!"
          "echo" "-e" "help: an installation guide is available at https://git-scm.com/book/en/v2/Getting-Started-Installing-Git"        
fi
        check=$(node -v)
        if [ "$check" == "" ]; then
          error=$((1))
          "echo" "-e" "Error: node is not found"
          "echo" "-e" "help: an installation guide is available at https://nodejs.org/en/download"        
fi
        if [ $(($error > 0)) == 1 ]; then
          "echo" "-e" "Please install above missing software"
          exit 1        
fi
      fi
    fi
  fi
  check=$(pm2 --version)
  if [ "$check" == "" ]; then
    "echo" "-e" "Installing PM2"
    npm install pm2 -g && pm2 install pm2-logrotate
    pm2 startup  
fi
  # Check again
  check=$(pm2 --version)
  if [ "$check" == "" ]; then
    "echo" "-e" "Error: pm2 is not found!"
    "echo" "-e" "help: an installation guide is available at https://pm2.keymetrics.io/docs/usage/quick-start/"
    exit 1  
fi
  mkdir -p $installPath
  cd $installPath
  git clone https://github.com/louislam/uptime-kuma.git .
  npm run setup
  pm2 start server/server.js --name uptime-kuma -- --port=$port
else
  defaultVolume="uptime-kuma"
  check=$(docker -v)
  if [ "$check" == "" ]; then
    "echo" "-e" "Error: docker is not found!"
    "echo" "-e" "help: an installation guide is available at https://docs.docker.com/desktop/"
    exit 1  
fi
  check=$(docker info)
  if [[ "$check" == *"Is the docker daemon running"* ]]; then
      "echo" "Error: docker is not running"
      "echo" "help: a troubleshooting guide is available at https://docs.docker.com/config/daemon/troubleshoot/"
      "exit" "1"
    fi
  if [ "$3" != "" ]; then
    port="$3"
  else
    "read" "-p" "Expose Port [$defaultPort]: " "port"
    if [ "$port" == "" ]; then
      port="$defaultPort"    
fi
  fi
  if [ "$2" != "" ]; then
    volume="$2"
  else
    "read" "-p" "Volume Name [$defaultVolume]: " "volume"
    if [ "$volume" == "" ]; then
      volume="$defaultVolume"    
fi
  fi
  "echo" "-e" "Port: $port"
  "echo" "-e" "Volume: $volume"
  docker volume create $volume
  docker run -d --restart=always -p $port:3001 -v $volume:/app/data --name uptime-kuma louislam/uptime-kuma:1
fi
"echo" "-e" "http://localhost:$port"
