// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
import { formatError } from "./logging";
/**
 * Throws if the received scope is not valid.
 * @internal
 */
export function ensureValidScope(scope, logger) {
    if (!scope.match(/^[0-9a-zA-Z-.:/]+$/)) {
        const error = new Error("Invalid scope was specified by the user or calling client");
        logger.getToken.info(formatError(scope, error));
        throw error;
    }
}
/**
 * Returns the resource out of a scope.
 * @internal
 */
export function getScopeResource(scope) {
    return scope.replace(/\/.default$/, "");
}
//# sourceMappingURL=scopeUtils.js.map