/*! noble-ciphers - MIT License (c) 2023 Paul Miller (paulmillr.com) */
import * as u from './utils.js';
export declare function hsalsa(c: Uint32Array, key: Uint8Array, nonce: Uint8Array): Uint8Array;
export declare function hchacha(c: Uint32Array, key: Uint8Array, nonce: Uint8Array): Uint8Array;
/**
 * salsa20, 12-byte nonce.
 */
export declare const salsa20: (key: Uint8Array, nonce: Uint8Array, data: Uint8Array, output?: Uint8Array | undefined, counter?: number) => Uint8Array;
/**
 * xsalsa20, 24-byte nonce.
 */
export declare const xsalsa20: (key: Uint8Array, nonce: Uint8Array, data: Uint8Array, output?: Uint8Array | undefined, counter?: number) => Uint8Array;
/**
 * chacha20 non-RFC, original version by djb. 8-byte nonce, 8-byte counter.
 */
export declare const chacha20orig: (key: Uint8Array, nonce: Uint8Array, data: Uint8Array, output?: Uint8Array | undefined, counter?: number) => Uint8Array;
/**
 * chacha20 RFC 8439 (IETF / TLS). 12-byte nonce, 4-byte counter.
 */
export declare const chacha20: (key: Uint8Array, nonce: Uint8Array, data: Uint8Array, output?: Uint8Array | undefined, counter?: number) => Uint8Array;
/**
 * xchacha20 eXtended-nonce. https://datatracker.ietf.org/doc/html/draft-irtf-cfrg-xchacha
 */
export declare const xchacha20: (key: Uint8Array, nonce: Uint8Array, data: Uint8Array, output?: Uint8Array | undefined, counter?: number) => Uint8Array;
/**
 * 8-round chacha from the original paper.
 */
export declare const chacha8: (key: Uint8Array, nonce: Uint8Array, data: Uint8Array, output?: Uint8Array | undefined, counter?: number) => Uint8Array;
/**
 * 12-round chacha from the original paper.
 */
export declare const chacha12: (key: Uint8Array, nonce: Uint8Array, data: Uint8Array, output?: Uint8Array | undefined, counter?: number) => Uint8Array;
export declare function poly1305(msg: Uint8Array, key: Uint8Array): Uint8Array;
/**
 * xsalsa20-poly1305 eXtended-nonce (24 bytes) salsa.
 */
export declare function xsalsa20poly1305(key: Uint8Array, nonce: Uint8Array): {
    encrypt: (plaintext: Uint8Array) => Uint8Array;
    decrypt: (ciphertext: Uint8Array) => Uint8Array;
};
/**
 * Alias to xsalsa20-poly1305
 */
export declare function secretbox(key: Uint8Array, nonce: Uint8Array): {
    seal: (plaintext: Uint8Array) => Uint8Array;
    open: (ciphertext: Uint8Array) => Uint8Array;
};
export declare const _poly1305_aead: (fn: typeof chacha20) => (key: Uint8Array, nonce: Uint8Array, AAD?: Uint8Array) => u.Cipher;
/**
 * chacha20-poly1305 12-byte-nonce chacha.
 */
export declare const chacha20poly1305: (key: Uint8Array, nonce: Uint8Array, AAD?: Uint8Array) => u.Cipher;
/**
 * xchacha20-poly1305 eXtended-nonce (24 bytes) chacha.
 * With 24-byte nonce, it's safe to use fill it with random (CSPRNG).
 */
export declare const xchacha20poly1305: (key: Uint8Array, nonce: Uint8Array, AAD?: Uint8Array) => u.Cipher;
//# sourceMappingURL=_micro.d.ts.map