import { utf8ToBytes } from './utils.js';
export { utf8ToBytes };
/**
 * Alias to xsalsa20poly1305, for compatibility with libsodium / nacl
 */
export declare function secretbox(key: Uint8Array, nonce: Uint8Array): {
    seal: (plaintext: Uint8Array) => Uint8Array;
    open: (ciphertext: Uint8Array) => Uint8Array;
};
export declare function randomKey(): Uint8Array;
/**
 * Encrypt plaintext under key with random nonce, using xchacha20poly1305.
 * User never touches nonce: it is prepended to ciphertext.
 */
export declare function encrypt(key: Uint8Array, plaintext: Uint8Array): Uint8Array;
/**
 * Decrypt plaintext under key with random nonce, using xchacha20poly1305.
 * User never touches nonce: it is prepended to ciphertext.
 */
export declare function decrypt(key: Uint8Array, ciphertext: Uint8Array): Uint8Array;
export declare function aes_encrypt(key: Uint8Array, plaintext: Uint8Array): Promise<Uint8Array>;
export declare function aes_decrypt(key: Uint8Array, ciphertext: Uint8Array): Promise<Uint8Array>;
//# sourceMappingURL=simple.d.ts.map