# node-radius-client

A simple promise based client library for radius built on top of node-radius and node-radius-utils.

## Install

```sh
npm i node-radius-client
```

## Options

Options passed into a client instance use the following schema:

```js
Joi.object().keys({
  host: Joi.string().trim().required(),
  hostPort: Joi.number().min(0).optional(), // default 1812
  localPort: Joi.number().min(0).optional(), // default random between 49152 and 65535
  timeout: Joi.number().min(0).optional(), // default 2500
  retries: Joi.number().min(0).optional(), // default 3
  dictionaries: Joi.array().items(Joi.string().trim()).optional(), // default ones included with node-radius
});
```

## Methods

### `client.accessRequest`
* Accepts an object with a secret and attributes.
* Attributes can be an object like the example below which will be converted to an array of arrays using the `attributesToArray` function from `node-radius-utils`.
* If the response recieved is an `Access-Reject` the promise will reject.

### `client.send`

* Accepts an object with a secret, code and attributes.
* Attributes can be an object like the example below which will be converted to an array of arrays using the `attributesToArray` function from `node-radius-utils`.
* If the request reaches the maximum number of retries with no response, the promise will reject.

## Example Usage

```js
const Client = require('node-radius-client');
const {
  dictionaries: {
    rfc2865: {
      file,
      attributes,
    },
  },
} = require('node-radius-utils');

const client = new Client({
  host: '10.0.0.123',
  dictionaries: [
    file,
  ],
});

client.accessRequest({
  secret: 'super-secret',
  attributes: [
    [attributes.USER_NAME, 'bobross'],
    [attributes.USER_PASSWORD, 'hunter2'],
  ],
}).then((result) => {
  console.log('result', result);
}).catch((error) => {
  console.log('error', error);
});
```
