/**
 * Get an Ephemeral Port
 * http://en.wikipedia.org/wiki/Ephemeral_port
 *
 * @return {number}
 */

function getEphemeralPort() {
  const begin = 49152;
  const end = 65535;

  return Math.floor(Math.random() * (end - begin + 1) + begin);
}

module.exports = {
  getEphemeralPort,
};
